/*
This file is part of the KubeVirt project

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Copyright The KubeVirt Authors.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1beta1

import (
	context "context"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
	scheme "kubevirt.io/client-go/containerizeddataimporter/scheme"
	corev1beta1 "kubevirt.io/containerized-data-importer-api/pkg/apis/core/v1beta1"
)

// VolumeCloneSourcesGetter has a method to return a VolumeCloneSourceInterface.
// A group's client should implement this interface.
type VolumeCloneSourcesGetter interface {
	VolumeCloneSources(namespace string) VolumeCloneSourceInterface
}

// VolumeCloneSourceInterface has methods to work with VolumeCloneSource resources.
type VolumeCloneSourceInterface interface {
	Create(ctx context.Context, volumeCloneSource *corev1beta1.VolumeCloneSource, opts v1.CreateOptions) (*corev1beta1.VolumeCloneSource, error)
	Update(ctx context.Context, volumeCloneSource *corev1beta1.VolumeCloneSource, opts v1.UpdateOptions) (*corev1beta1.VolumeCloneSource, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*corev1beta1.VolumeCloneSource, error)
	List(ctx context.Context, opts v1.ListOptions) (*corev1beta1.VolumeCloneSourceList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *corev1beta1.VolumeCloneSource, err error)
	VolumeCloneSourceExpansion
}

// volumeCloneSources implements VolumeCloneSourceInterface
type volumeCloneSources struct {
	*gentype.ClientWithList[*corev1beta1.VolumeCloneSource, *corev1beta1.VolumeCloneSourceList]
}

// newVolumeCloneSources returns a VolumeCloneSources
func newVolumeCloneSources(c *CdiV1beta1Client, namespace string) *volumeCloneSources {
	return &volumeCloneSources{
		gentype.NewClientWithList[*corev1beta1.VolumeCloneSource, *corev1beta1.VolumeCloneSourceList](
			"volumeclonesources",
			c.RESTClient(),
			scheme.ParameterCodec,
			namespace,
			func() *corev1beta1.VolumeCloneSource { return &corev1beta1.VolumeCloneSource{} },
			func() *corev1beta1.VolumeCloneSourceList { return &corev1beta1.VolumeCloneSourceList{} },
		),
	}
}
