/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.writer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.index.IndexTerm;
import org.dita.dost.index.IndexTermTarget;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.writer.AbstractExtendDitaWriter;

public final class EclipseIndexWriter
extends AbstractExtendDitaWriter {
    private String filepath = null;
    private String targetExt = ".html";
    private boolean inIndexsee = false;
    private List<IndexTerm> termCloneList = null;

    public void setFilePath(String filePath) {
        this.filepath = filePath;
    }

    public String getFilePath() {
        return this.filepath;
    }

    public void write(File filename) throws DITAOTException {
        FileOutputStream out = null;
        XMLStreamWriter serializer = null;
        try {
            out = new FileOutputStream(filename);
            boolean indexsee = false;
            if (this.getPipelineHashIO() != null) {
                indexsee = Boolean.valueOf(this.getPipelineHashIO().getAttribute("eclipse.indexsee"));
                this.targetExt = this.getPipelineHashIO().getAttribute("targetext");
            }
            serializer = XMLOutputFactory.newInstance().createXMLStreamWriter(out, "UTF-8");
            serializer.writeStartDocument();
            serializer.writeStartElement("index");
            this.termCloneList = this.cloneIndextermList(this.termList);
            for (IndexTerm term : this.termList) {
                this.outputIndexTerm(term, serializer, indexsee);
            }
            serializer.writeEndElement();
            serializer.writeEndDocument();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DITAOTException((Throwable)e);
        }
        finally {
            if (serializer != null) {
                try {
                    serializer.close();
                }
                catch (XMLStreamException e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private void outputIndexTerm(IndexTerm term, XMLStreamWriter serializer, boolean indexsee) throws XMLStreamException {
        List subTerms = term.getSubTerms();
        int subTermNum = subTerms.size();
        this.outputIndexTermStartElement(term, serializer, indexsee);
        if (subTermNum > 0) {
            for (IndexTerm subTerm : subTerms) {
                this.outputIndexTerm(subTerm, serializer, indexsee);
            }
        }
        this.outputIndexTermEndElement(term, serializer, indexsee);
    }

    private String replaceExtName(String aFileName) {
        int index = aFileName.indexOf("#");
        if (aFileName.startsWith("#")) {
            return aFileName;
        }
        if (index != -1) {
            String fileName = aFileName.substring(0, index);
            int fileExtIndex = fileName.lastIndexOf(".");
            return fileExtIndex != -1 ? fileName.substring(0, fileExtIndex) + this.targetExt + aFileName.substring(index) : aFileName;
        }
        int fileExtIndex = aFileName.lastIndexOf(".");
        return fileExtIndex != -1 ? aFileName.substring(0, fileExtIndex) + this.targetExt : aFileName;
    }

    public String getIndexFileName(String outputFileRoot) {
        File indexDir = new File(outputFileRoot).getParentFile();
        this.setFilePath(indexDir.getAbsolutePath());
        return new File(indexDir, "index.xml").getAbsolutePath();
    }

    private void outputIndexEntry(IndexTerm term, XMLStreamWriter serializer) throws XMLStreamException {
        List targets = term.getTargetList();
        boolean foundIndexTerm = false;
        boolean foundIndexsee = false;
        String indexSeeRefTerm = null;
        int termCloneNum = this.termCloneList.size();
        if (!targets.isEmpty()) {
            for (IndexTermTarget target : targets) {
                String targetUri = target.getTargetURI();
                String targetName = target.getTargetName();
                if (targetUri == null) {
                    serializer.writeStartElement("topic");
                    serializer.writeAttribute("title", target.getTargetName());
                    serializer.writeEndElement();
                    continue;
                }
                if (targetName == null || targetName.trim().length() <= 0) continue;
                if (term.getTermPrefix() != null || this.inIndexsee) {
                    indexSeeRefTerm = term.getTermName();
                    this.inIndexsee = true;
                    foundIndexsee = true;
                    for (int j = 0; j < termCloneNum; ++j) {
                        IndexTerm termClone = this.termCloneList.get(j);
                        if (!term.getTermName().equals(termClone.getTermName())) continue;
                        foundIndexTerm = true;
                        if (termClone.getTargetList().size() > 0) {
                            serializer.writeStartElement("topic");
                            IndexTermTarget indexTermTarget = (IndexTermTarget)termClone.getTargetList().get(0);
                            serializer.writeAttribute("href", this.replaceExtName(indexTermTarget.getTargetURI()));
                            if (indexTermTarget.getTargetName() != null && !indexTermTarget.getTargetName().trim().isEmpty()) {
                                serializer.writeAttribute("title", indexTermTarget.getTargetName());
                            }
                            serializer.writeEndElement();
                        }
                        this.termCloneList = termClone.getSubTerms();
                        break;
                    }
                    if (term.getSubTerms().size() != 0) continue;
                    this.inIndexsee = false;
                    continue;
                }
                serializer.writeStartElement("topic");
                serializer.writeAttribute("href", this.replaceExtName(targetUri));
                if (targetName.trim().length() > 0) {
                    serializer.writeAttribute("title", target.getTargetName());
                }
                serializer.writeEndElement();
            }
            if (!foundIndexTerm && foundIndexsee && indexSeeRefTerm != null && !indexSeeRefTerm.equals("***")) {
                this.logger.warn(MessageUtils.getMessage((String)"DOTJ050W", (String[])new String[]{indexSeeRefTerm.trim()}).toString());
            }
        }
    }

    private void outputIndexEntryEclipseIndexsee(IndexTerm term, XMLStreamWriter serializer) throws XMLStreamException {
        List targets = term.getTargetList();
        if (!targets.isEmpty()) {
            for (IndexTermTarget target : targets) {
                String targetUri = target.getTargetURI();
                String targetName = target.getTargetName();
                if (targetUri == null) {
                    serializer.writeStartElement("topic");
                    serializer.writeAttribute("title", target.getTargetName());
                    serializer.writeEndElement();
                    continue;
                }
                serializer.writeStartElement("topic");
                serializer.writeAttribute("href", this.replaceExtName(targetUri));
                if (targetName.trim().length() > 0) {
                    serializer.writeAttribute("title", target.getTargetName());
                }
                serializer.writeEndElement();
            }
        }
    }

    private List<IndexTerm> cloneIndextermList(List<IndexTerm> termList) {
        ArrayList<IndexTerm> termListClone = new ArrayList<IndexTerm>(termList.size());
        if (!termList.isEmpty()) {
            termListClone.addAll(termList);
        }
        return termListClone;
    }

    private void outputIndexTermStartElement(IndexTerm term, XMLStreamWriter serializer, boolean indexsee) throws XMLStreamException {
        if (indexsee) {
            if (term.getTermPrefix() != null) {
                this.inIndexsee = true;
                serializer.writeStartElement("see");
                serializer.writeAttribute("keyword", term.getTermName());
            } else if (this.inIndexsee) {
                serializer.writeStartElement("subpath");
                serializer.writeAttribute("keyword", term.getTermName());
                serializer.writeEndElement();
            } else {
                serializer.writeStartElement("entry");
                serializer.writeAttribute("keyword", term.getTermName());
                this.outputIndexEntryEclipseIndexsee(term, serializer);
            }
        } else {
            serializer.writeStartElement("entry");
            serializer.writeAttribute("keyword", term.getTermFullName());
            this.outputIndexEntry(term, serializer);
        }
    }

    private void outputIndexTermEndElement(IndexTerm term, XMLStreamWriter serializer, boolean indexsee) throws XMLStreamException {
        if (indexsee) {
            if (term.getTermPrefix() != null) {
                serializer.writeEndElement();
                this.inIndexsee = false;
            } else if (!this.inIndexsee) {
                serializer.writeEndElement();
            }
        } else {
            serializer.writeEndElement();
        }
    }
}

