/*
 * Decompiled with CFR 0.152.
 */
package javax.measure.spi;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.measure.Quantity;
import javax.measure.spi.FormatService;
import javax.measure.spi.QuantityFactory;
import javax.measure.spi.SystemOfUnitsService;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class ServiceProvider {
    private static final String LEGACY_NAMED_ANNOTATION = "javax.inject.Named";
    private static final String LEGACY_PRIORITY_ANNOTATION = "javax.annotation.Priority";
    private static final String NAMED_ANNOTATION = "jakarta.inject.Named";
    private static final String PRIORITY_ANNOTATION = "jakarta.annotation.Priority";
    private static final AtomicReference<ServiceProvider> current = new AtomicReference();

    protected ServiceProvider() {
    }

    public int getPriority() {
        return 0;
    }

    public abstract SystemOfUnitsService getSystemOfUnitsService();

    public abstract FormatService getFormatService();

    public abstract <Q extends Quantity<Q>> QuantityFactory<Q> getQuantityFactory(Class<Q> var1);

    public static final List<ServiceProvider> available() {
        ArrayList arrayList;
        block3: {
            arrayList = new Selector(null).stream().collect(Collectors.toCollection(ArrayList::new));
            ServiceProvider serviceProvider = current.get();
            if (serviceProvider != null) {
                Class<?> clazz = serviceProvider.getClass();
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    if (!clazz.equals(((ServiceProvider)arrayList.get(i)).getClass())) continue;
                    if (i != 0) {
                        arrayList.remove(i);
                        break;
                    }
                    break block3;
                }
                arrayList.add(0, serviceProvider);
            }
        }
        return arrayList;
    }

    public static ServiceProvider of(String string) {
        Objects.requireNonNull(string);
        Selector selector = new Selector(string);
        ServiceProvider serviceProvider = current.get();
        if (serviceProvider != null && selector.test(serviceProvider)) {
            return serviceProvider;
        }
        Optional optional = selector.stream().findFirst();
        if (optional.isPresent()) {
            return (ServiceProvider)optional.get();
        }
        throw new IllegalArgumentException("No Measurement ServiceProvider " + string + " found .");
    }

    public static final ServiceProvider current() {
        ServiceProvider serviceProvider = current.get();
        if (serviceProvider == null) {
            Optional optional = new Selector(null).stream().findFirst();
            if (optional.isPresent()) {
                serviceProvider = (ServiceProvider)optional.get();
            } else {
                throw new IllegalStateException("No Measurement ServiceProvider found.");
            }
        }
        return serviceProvider;
    }

    public static final ServiceProvider setCurrent(ServiceProvider serviceProvider) {
        Objects.requireNonNull(serviceProvider);
        ServiceProvider serviceProvider2 = current.getAndSet(serviceProvider);
        if (serviceProvider2 != serviceProvider) {
            System.getLogger("javax.measure.spi").log(System.Logger.Level.DEBUG, "Measurement ServiceProvider {1,choice,0#set to|1#replaced by} {0}.", serviceProvider.getClass().getName(), serviceProvider2 == null ? 0 : 1);
        }
        return serviceProvider2;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class Selector
    implements Predicate<ServiceLoader.Provider<ServiceProvider>>,
    Comparator<ServiceLoader.Provider<ServiceProvider>> {
        private final String toSearch;
        private final Method nameGetter;
        private final Method priorityGetter;
        private final Method legacyNameGetter;
        private final Method legacyPriorityGetter;

        Selector(String string) {
            this.toSearch = string;
            try {
                if (string != null) {
                    this.nameGetter = Selector.getValueMethod(ServiceProvider.NAMED_ANNOTATION);
                    this.legacyNameGetter = Selector.getValueMethod(ServiceProvider.LEGACY_NAMED_ANNOTATION);
                } else {
                    this.nameGetter = null;
                    this.legacyNameGetter = null;
                }
                this.priorityGetter = Selector.getValueMethod(ServiceProvider.PRIORITY_ANNOTATION);
                this.legacyPriorityGetter = Selector.getValueMethod(ServiceProvider.LEGACY_PRIORITY_ANNOTATION);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new ServiceConfigurationError("Cannot get annotation value", noSuchMethodException);
            }
        }

        private static Method getValueMethod(String string) throws NoSuchMethodException {
            try {
                return Class.forName(string).getMethod("value", null);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }

        private static Object getValue(Class<?> clazz, Method method, Method method2) {
            if (method == null) {
                method = method2;
                method2 = null;
            }
            while (method != null) {
                Annotation annotation = clazz.getAnnotation(method.getDeclaringClass().asSubclass(Annotation.class));
                if (annotation != null) {
                    try {
                        return method.invoke((Object)annotation, (Object[])null);
                    }
                    catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                        throw new ServiceConfigurationError("Cannot get annotation value", reflectiveOperationException);
                    }
                }
                method = method2;
                method2 = null;
            }
            return null;
        }

        @Override
        public boolean test(ServiceProvider serviceProvider) {
            Object object = Selector.getValue(serviceProvider.getClass(), this.nameGetter, this.legacyNameGetter);
            if (object == null) {
                object = serviceProvider.toString();
            }
            return this.toSearch.equals(object);
        }

        @Override
        public boolean test(ServiceLoader.Provider<ServiceProvider> provider) {
            Object object = Selector.getValue(provider.type(), this.nameGetter, this.legacyNameGetter);
            if (object == null) {
                object = provider.get().toString();
            }
            return this.toSearch.equals(object);
        }

        private int priority(ServiceLoader.Provider<ServiceProvider> provider) {
            Object object = Selector.getValue(provider.type(), this.priorityGetter, this.legacyPriorityGetter);
            if (object != null) {
                return (Integer)object;
            }
            return provider.get().getPriority();
        }

        @Override
        public int compare(ServiceLoader.Provider<ServiceProvider> provider, ServiceLoader.Provider<ServiceProvider> provider2) {
            return Integer.compare(this.priority(provider2), this.priority(provider));
        }

        private Stream<ServiceProvider> stream() {
            Stream<ServiceLoader.Provider<ServiceProvider>> stream = ServiceLoader.load(ServiceProvider.class).stream();
            if (this.toSearch != null) {
                stream = stream.filter(this);
            }
            return stream.sorted(this).map(ServiceLoader.Provider::get);
        }
    }
}

