/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.server;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import org.apache.sshd.common.util.MapEntryUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.sftp.server.DirectoryHandle;
import org.apache.sshd.sftp.server.FileHandle;
import org.apache.sshd.sftp.server.Handle;
import org.apache.sshd.sftp.server.SftpEventListener;

public abstract class AbstractSftpEventListenerAdapter
extends AbstractLoggingBean
implements SftpEventListener {
    protected AbstractSftpEventListenerAdapter() {
    }

    @Override
    public void receivedExtension(ServerSession session, String extension, int id) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("receivedExtension({}) id={}, extension={}", new Object[]{session, id, extension});
        }
    }

    @Override
    public void initialized(ServerSession session, int version) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("initialized({}) version={}", (Object)session, (Object)version);
        }
    }

    @Override
    public void destroying(ServerSession session) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("destroying({})", (Object)session);
        }
    }

    @Override
    public void opening(ServerSession session, String remoteHandle, Handle localHandle) throws IOException {
        if (this.log.isTraceEnabled()) {
            Path path = localHandle.getFile();
            this.log.trace("opening({})[{}] {} {}", new Object[]{session, remoteHandle, Files.isDirectory(path, new LinkOption[0]) ? "directory" : "file", path});
        }
    }

    @Override
    public void openFailed(ServerSession session, String remotePath, Path localPath, boolean isDirectory, Throwable thrown) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("openFailed({}) remotePath={}, localPath={}, isDir={}, thrown={}", new Object[]{session, remotePath, localPath, isDirectory, thrown});
        }
    }

    @Override
    public void open(ServerSession session, String remoteHandle, Handle localHandle) throws IOException {
        if (this.log.isTraceEnabled()) {
            Path path = localHandle.getFile();
            this.log.trace("open({})[{}] {} {}", new Object[]{session, remoteHandle, Files.isDirectory(path, new LinkOption[0]) ? "directory" : "file", path});
        }
    }

    @Override
    public void readingEntries(ServerSession session, String remoteHandle, DirectoryHandle localHandle) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("readingEntries({}) handle={}[{}]", new Object[]{session, remoteHandle, localHandle.getFile()});
        }
    }

    @Override
    public void readEntries(ServerSession session, String remoteHandle, DirectoryHandle localHandle, Map<String, Path> entries) throws IOException {
        int numEntries = MapEntryUtils.size(entries);
        if (this.log.isDebugEnabled()) {
            this.log.debug("read({})[{}] {} entries", new Object[]{session, localHandle.getFile(), numEntries});
        }
        if (numEntries > 0 && this.log.isTraceEnabled()) {
            entries.forEach((key, value) -> this.log.trace("read({})[{}] {} - {}", new Object[]{session, localHandle.getFile(), key, value}));
        }
    }

    @Override
    public void reading(ServerSession session, String remoteHandle, FileHandle localHandle, long offset, byte[] data, int dataOffset, int dataLen) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("reading({})[{}] offset={}, requested={}", new Object[]{session, localHandle.getFile(), offset, dataLen});
        }
    }

    @Override
    public void read(ServerSession session, String remoteHandle, FileHandle localHandle, long offset, byte[] data, int dataOffset, int dataLen, int readLen, Throwable thrown) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("read({})[{}] offset={}, requested={}, read={}{}", new Object[]{session, localHandle.getFile(), offset, dataLen, readLen, thrown == null ? "" : ": " + thrown});
        }
    }

    @Override
    public void writing(ServerSession session, String remoteHandle, FileHandle localHandle, long offset, byte[] data, int dataOffset, int dataLen) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("writing({})[{}] offset={}, requested={}", new Object[]{session, localHandle.getFile(), offset, dataLen});
        }
    }

    @Override
    public void written(ServerSession session, String remoteHandle, FileHandle localHandle, long offset, byte[] data, int dataOffset, int dataLen, Throwable thrown) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("written({})[{}] offset={}, requested={}{}", new Object[]{session, localHandle.getFile(), offset, dataLen, thrown == null ? "" : ": " + thrown});
        }
    }

    @Override
    public void blocking(ServerSession session, String remoteHandle, FileHandle localHandle, long offset, long length, int mask) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("blocking({})[{}] offset={}, length={}, mask=0x{}", new Object[]{session, localHandle.getFile(), offset, length, Integer.toHexString(mask)});
        }
    }

    @Override
    public void blocked(ServerSession session, String remoteHandle, FileHandle localHandle, long offset, long length, int mask, Throwable thrown) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("blocked({})[{}] offset={}, length={}, mask=0x{}{}", new Object[]{session, localHandle.getFile(), offset, length, Integer.toHexString(mask), thrown == null ? "" : ": " + thrown});
        }
    }

    @Override
    public void unblocking(ServerSession session, String remoteHandle, FileHandle localHandle, long offset, long length) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("unblocking({})[{}] offset={}, length={}", new Object[]{session, localHandle.getFile(), offset, length});
        }
    }

    @Override
    public void unblocked(ServerSession session, String remoteHandle, FileHandle localHandle, long offset, long length, Throwable thrown) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("unblocked({})[{}] offset={}, length={}{}", new Object[]{session, localHandle.getFile(), offset, length, thrown == null ? "" : ": " + thrown});
        }
    }

    @Override
    public void closing(ServerSession session, String remoteHandle, Handle localHandle) throws IOException {
        if (this.log.isTraceEnabled()) {
            Path path = localHandle.getFile();
            this.log.trace("close({})[{}] {} {}", new Object[]{session, localHandle.getFile(), Files.isDirectory(path, new LinkOption[0]) ? "directory" : "file", path});
        }
    }

    @Override
    public void closed(ServerSession session, String remoteHandle, Handle localHandle, Throwable thrown) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("closed({}) handle={}[{}]{}", new Object[]{session, remoteHandle, localHandle.getFile(), thrown == null ? "" : ": " + thrown});
        }
    }

    @Override
    public void creating(ServerSession session, Path path, Map<String, ?> attrs) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("creating({}) {} {}", new Object[]{session, Files.isDirectory(path, new LinkOption[0]) ? "directory" : "file", path});
        }
    }

    @Override
    public void created(ServerSession session, Path path, Map<String, ?> attrs, Throwable thrown) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("created({}) {} {}{}", new Object[]{session, Files.isDirectory(path, new LinkOption[0]) ? "directory" : "file", path, thrown == null ? "" : ": " + thrown});
        }
    }

    @Override
    public void moving(ServerSession session, Path srcPath, Path dstPath, Collection<CopyOption> opts) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("moving({})[{}] {} => {}", new Object[]{session, opts, srcPath, dstPath});
        }
    }

    @Override
    public void moved(ServerSession session, Path srcPath, Path dstPath, Collection<CopyOption> opts, Throwable thrown) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("moved({})[{}] {} => {}{}", new Object[]{session, opts, srcPath, dstPath, thrown == null ? "" : ": " + thrown});
        }
    }

    @Override
    public void removing(ServerSession session, Path path, boolean isDirectory) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("removing({})[dir={}] {}", new Object[]{session, isDirectory, path});
        }
    }

    @Override
    public void removed(ServerSession session, Path path, boolean isDirectory, Throwable thrown) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("removed({})[dir={}] {}{}", new Object[]{session, isDirectory, path, thrown == null ? "" : ": " + thrown});
        }
    }

    @Override
    public void linking(ServerSession session, Path source, Path target, boolean symLink) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("linking({})[{}] {} => {}", new Object[]{session, symLink, source, target});
        }
    }

    @Override
    public void linked(ServerSession session, Path source, Path target, boolean symLink, Throwable thrown) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("linked({})[{}] {} => {}{}", new Object[]{session, symLink, source, target, thrown == null ? "" : ": " + thrown});
        }
    }

    @Override
    public void modifyingAttributes(ServerSession session, Path path, Map<String, ?> attrs) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("modifyingAttributes({}) {}: {}", new Object[]{session, path, attrs});
        }
    }

    @Override
    public void modifiedAttributes(ServerSession session, Path path, Map<String, ?> attrs, Throwable thrown) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("modifiedAttributes({}) {}{}", new Object[]{session, path, thrown == null ? "" : ": " + thrown});
        }
    }

    @Override
    public void exiting(ServerSession session, Handle handle) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("exiting({}) handle={}[{}]", new Object[]{session, handle.getFile(), handle.getFileHandle()});
        }
    }
}

