# Cantera 3.0.0

Published on August 22, 2023 | [Full release on GitHub](https://github.com/Cantera/cantera/releases/tag/v3.0.0)

The Cantera development team is pleased to announce the availability of Cantera 3.0.0. There have been over [1400 commits](https://github.com/Cantera/cantera/wiki/Cantera-3.0.0-Changelog) to Cantera since the last version, 2.6.0, which was released in May 2022. We have closed or merged [192 pull requests](https://github.com/Cantera/cantera/pulls?q=is%3Apr+merged%3A2022-05-01..2023-08-22+is%3Aclosed) and closed [111 issues](https://github.com/Cantera/cantera/issues?q=is%3Aissue+closed%3A2022-05-01..2023-08-22+is%3Aclosed). Instructions for installing Cantera 3.0 are available on the [Cantera website](/install/index).

## Highlights

- Major performance enhancements for reactor network calculations with large kinetic mechanisms. This comes from a new formulation for the reactor governing equations using species moles (rather than mass fractions) used together with a sparse, iterative solver in the ODE integrator that makes use of a semi-analytical Jacobian. ([`preconditioned_integration.py`](/examples/python/reactors/preconditioned_integration), [#1010](https://github.com/Cantera/cantera/pull/1010), [#1344](https://github.com/Cantera/cantera/pull/1344), [#1363](https://github.com/Cantera/cantera/pull/1363), [#1377](https://github.com/Cantera/cantera/pull/1377), [#1411](https://github.com/Cantera/cantera/pull/1411))
- Introduce `ExtensibleRate` Python class that can be used to implement new reaction rate parameterizations in Python, with parameters defined in YAML input files. These rate types can be used even when the main user application is not written in Python. (class {py:class}`~cantera.ExtensibleRate`), [`custom_reactions.py`](/examples/python/kinetics/custom_reactions), [#1382](https://github.com/Cantera/cantera/pull/1382), [#1417](https://github.com/Cantera/cantera/pull/1417), [#1456](https://github.com/Cantera/cantera/pull/1456), [#1478](https://github.com/Cantera/cantera/pull/1478), [#1494](https://github.com/Cantera/cantera/pull/1494), [#1499](https://github.com/Cantera/cantera/pull/1499))
- Introduce a C++ `SolutionArray` class, which is now used as the backend for the Python `SolutionArray` class ([E#137](https://github.com/Cantera/enhancements/issues/137), [#1385](https://github.com/Cantera/cantera/pull/1385), [#1426](https://github.com/Cantera/cantera/pull/1426), [#1458](https://github.com/Cantera/cantera/pull/1458), [#1462](https://github.com/Cantera/cantera/pull/1462), [#1464](https://github.com/Cantera/cantera/pull/1464), [#1508](https://github.com/Cantera/cantera/pull/1508), [#1520](https://github.com/Cantera/cantera/pull/1520), [#1547](https://github.com/Cantera/cantera/pull/1547), [#1585](https://github.com/Cantera/cantera/pull/1585))
- Add "native" support for HDF5 as an input/output format for `SolutionArray` and 1D flames ([E#166](https://github.com/Cantera/enhancements/issues/166), [`flame_initial_guess.py`](/examples/python/onedim/flame_initial_guess))
- Add a new thermo model, `coverage-dependent-surface` for representing surfaces where the enthalpy, entropy, and heat capacity of each species may depend on its coverage and the coverage of other species in the phase. (class {ct}`CoverageDependentSurfPhase`, [E#59](https://github.com/Cantera/enhancements/issues/59), [#1135](https://github.com/Cantera/cantera/pull/1135), [#1471](https://github.com/Cantera/cantera/pull/1471), [#1529](https://github.com/Cantera/cantera/pull/1529), [#1583](https://github.com/Cantera/cantera/pull/1583))
- Add support for surface chemistry to the plug flow reactor model (class {py:class}`~cantera.FlowReactor`, [`1D_pfr_surfchem.py`](/examples/python/reactors/1D_pfr_surfchem), [`surf_pfr.py`](/examples/python/reactors/surf_pfr), [#1490](https://github.com/Cantera/cantera/pull/1490))
- Add support for using real gas models (Redlich-Kwong and Peng-Robinson) with the 1D flame solver ([E#109](https://github.com/Cantera/enhancements/issues/109), [#1079](https://github.com/Cantera/cantera/pull/1079))
- Introduction of the `yaml2ck` script, which converts Cantera's YAML mechanism format into the legacy Chemkin format. ([`yaml2ck.py`](/yaml/yaml2ck), [E#52](https://github.com/Cantera/enhancements/issues/52), [#1286](https://github.com/Cantera/cantera/pull/1286), [#1365](https://github.com/Cantera/cantera/pull/1365), [#1420](https://github.com/Cantera/cantera/pull/1420))
- Add an experimental Python module where Cantera returns dimensional values as quantities using the `pint` package. This is currently available only for thermo methods ([module `cantera.with_units`](/python/units), [`isentropic_units.py`](/examples/python/thermo/isentropic_units), [`rankine_units.py`](/examples/python/thermo/rankine_units), [`sound_speed_units.py`](/examples/python/thermo/sound_speed_units), [E#3](https://github.com/Cantera/enhancements/issues/3), [#991](https://github.com/Cantera/cantera/pull/991), [#1569](https://github.com/Cantera/cantera/pull/1569))
- Preview release of a new Matlab toolbox, with a rewritten API that makes use of modern Matlab features and replaces the difficult-to-maintain MEX-file based backend with one based on using `calllib` to interact directly with the Cantera C interface. (For the adventurous, see [`README.md`](https://github.com/Cantera/cantera/blob/main/interfaces/matlab_experimental/readme.md), [E#32](https://github.com/Cantera/enhancements/issues/32), [#1182](https://github.com/Cantera/cantera/pull/1182), [#1496](https://github.com/Cantera/cantera/pull/1496), [#1498](https://github.com/Cantera/cantera/pull/1498))
- Preview release of a new C# interface. See [`README.md`](https://github.com/Cantera/cantera/blob/main/interfaces/dotnet/README.md) for more on what's implemented and how to contribute ([#1331](https://github.com/Cantera/cantera/pull/1331), [#1401](https://github.com/Cantera/cantera/pull/1401))

## New features

- Add support for polynomial dependency of activation energy on surface species coverages ([documentation](sec-yaml-interface-Arrhenius), [#1495](https://github.com/Cantera/cantera/pull/1495))
- Add speed of sound property to `ThermoPhase` objects ([`sound_speed.py`](/examples/python/thermo/sound_speed), [#1491](https://github.com/Cantera/cantera/pull/1491))
- Implemented isothermal compressibility and thermal expansion coefficient calculations for Redlich-Kwong and Peng-Robinson equations of state ([E#122](https://github.com/Cantera/enhancements/issues/122), [#1421](https://github.com/Cantera/cantera/pull/1421))
- Add `interfaceCurrent` (C++) and `interface_current` methods to `Kinetics` objects ([#1398](https://github.com/Cantera/cantera/pull/1398))
- Add molecular weight attribute to `Species` objects ([#1266](https://github.com/Cantera/cantera/pull/1266))
- Add `set_equivalence_ratio` and `set_mixture_fraction` methods to Python `Quantity` objects ([#1517](https://github.com/Cantera/cantera/pull/1517))
- Add array size methods to Python `SolutionArray` class ([#1284](https://github.com/Cantera/cantera/pull/1284))
- Add `Solution` class to `clib` ([#1448](https://github.com/Cantera/cantera/pull/1448), [#1600](https://github.com/Cantera/cantera/pull/1600))
- Introduce factory for creating 1D domains (`newDomain` in C++, `domain_new` in `clib`) ([#1445](https://github.com/Cantera/cantera/pull/1445))
- Introduce factory for creating functor objects (`newFunc1` in C++; `func_new_basic`, `func_new_advanced`, `func_new_compound`, and `func_new_modified` in `clib`; and `Func1.cxx_functor` in Python) (<a href="../../cxx/dc/d4c/group__func1.html">documentation</a>, [#1513](https://github.com/Cantera/cantera/pull/1513), [#1521](https://github.com/Cantera/cantera/pull/1521))
- Provide a more complete interface to the C++ `Units` class in Python ([#1285](https://github.com/Cantera/cantera/pull/1285))
- Add a sample program demonstrating the use of the Cantera C interface, `clib` ([#1454](https://github.com/Cantera/cantera/pull/1454))
- Add an example of modelling a porous media burner using the `ExtensibleReactor` class ([`PorousMediaBurner.py`](/examples/python/reactors/porous_media_burner), [#1443](https://github.com/Cantera/cantera/pull/1443))
- Add an example demonstrating saving and loading of 1D flame simulations and restarting with different initial guesses ([`flame_initial_guess.py`](/examples/python/onedim/flame_initial_guess), [#1293](https://github.com/Cantera/cantera/pull/1293))
- The test suite now includes a comprehensive set of thermodynamic consistency tests for all phase models ([E#114](https://github.com/Cantera/enhancements/issues/114), [#1299](https://github.com/Cantera/cantera/pull/1299), [#1501](https://github.com/Cantera/cantera/pull/1501))
- Consolidate literature references in the C++ documentation into a <a href="../../cxx/d0/de3/citelist.html">bibliography</a> ([#1550](https://github.com/Cantera/cantera/pull/1550), [#1575](https://github.com/Cantera/cantera/pull/1575))
- Enable linking to the Cantera shared library on Windows ([E#140](https://github.com/Cantera/enhancements/issues/140), [#1429](https://github.com/Cantera/cantera/pull/1429))
- Split up compilation of the Python module to allow parallel builds and faster incremental builds ([#1334](https://github.com/Cantera/cantera/pull/1334), [#1484](https://github.com/Cantera/cantera/pull/1484))
- Automatically detect and use optimized BLAS/LAPACK libraries when compiling ([E#144](https://github.com/Cantera/enhancements/issues/144), [#1316](https://github.com/Cantera/cantera/pull/1316))
- Add new `core.h` header file to simplify required includes for high-level Cantera usage ([`demo.cpp`](/examples/cxx/demo), [#1238](https://github.com/Cantera/cantera/pull/1238))
- Added support for Python 3.11 and dropped support for Python 3.7 ([#1326](https://github.com/Cantera/cantera/pull/1326), [#1406](https://github.com/Cantera/cantera/pull/1406), [#1467](https://github.com/Cantera/cantera/pull/1467))
- Added support for SUNDIALS versions up to 6.6.0 and dropped support for SUNDIALS 2.x ([#1341](https://github.com/Cantera/cantera/pull/1341), [#1570](https://github.com/Cantera/cantera/pull/1570))
- Add support for building MATLAB toolbox on Apple Silicon ([#1524](https://github.com/Cantera/cantera/pull/1524))
- Added SCons option to set `AR` (for example, to use `llvm-ar` instead of `ar`) ([#1424](https://github.com/Cantera/cantera/pull/1424))

## Changes to existing capabilities

- `BulkKinetics` now handles kinetics for any bulk phase, given the appropriate reaction rate parameterizations. As a result, `GasKinetics` is deprecated in favor of `BulkKinetics` ([#1483](https://github.com/Cantera/cantera/pull/1483))
- Rename C++ phase setter mnemonics to use `D` for density instead of `R` for rho, for example `setState_TR` is deprecated in favor of `setState_TD` ([#1433](https://github.com/Cantera/cantera/pull/1433))
- Introduce properties for certain reactor features in Python and deprecate the old getter/setter methods. `ReactorNet.initial_time` replaces `ReactorNet.set_initial_time()`, `Wall.velocity` replaces `Wall.set_velocity()`, `Wall.heat_flux` replaces `Wall.set_heat_flux()`, `Wall.expansion_rate` replaces `wall.vdot`, `Wall.heat_rate` replaces `wall.qdot()`, `Valve.time_function` replaces `Valve.set_time_function()`, `MassFlowController.pressure_function` replaces `MassFlowController.set_pressure_function()` and `PressureController.primary` replaces `PressureController.set_master()` ([E#160](https://github.com/Cantera/enhancements/issues/160), [#1515](https://github.com/Cantera/cantera/pull/1515))
- Improve ability to find non-extinct diffusion flames when using the "auto" solver mode ([E#155](https://github.com/Cantera/enhancements/issues/155), [#1463](https://github.com/Cantera/cantera/pull/1463))
- Guard against combining Python `Quantity` objects at constant enthalpy and pressure if their pressures aren't equal ([#1517](https://github.com/Cantera/cantera/pull/1517))
- Allow transport geometry flags in Chemkin input files that are formatted as floating point values ([#1396](https://github.com/Cantera/cantera/pull/1396))
- Disable irrelevant warnings for extinct diffusion flames ([#1336](https://github.com/Cantera/cantera/pull/1336))
- Moved Python test suite and examples out of the Python module; they are no longer installed as part of the Cantera Python package. ([E#51](https://github.com/Cantera/enhancements/issues/51), [#1352](https://github.com/Cantera/cantera/pull/1352), [#1354](https://github.com/Cantera/cantera/pull/1354))
- Drop support for generating `Makefile`s for samples ([#1380](https://github.com/Cantera/cantera/pull/1380))
- Drop support for compiling in Cygwin ([E#134](https://github.com/Cantera/enhancements/issues/134), [#1367](https://github.com/Cantera/cantera/pull/1367))
- Migrate to C++17 standard, make use of modern C++ features, and make various style improvements to the C++ code ([E#181](https://github.com/Cantera/enhancements/issues/181), [E#184](https://github.com/Cantera/enhancements/issues/184), [#1246](https://github.com/Cantera/cantera/pull/1246), [#1327](https://github.com/Cantera/cantera/pull/1327), [#1346](https://github.com/Cantera/cantera/pull/1346), [#1438](https://github.com/Cantera/cantera/pull/1438), [#1441](https://github.com/Cantera/cantera/pull/1441), [#1452](https://github.com/Cantera/cantera/pull/1452), [#1507](https://github.com/Cantera/cantera/pull/1507), [#1565](https://github.com/Cantera/cantera/pull/1565), [#1568](https://github.com/Cantera/cantera/pull/1568), [#1571](https://github.com/Cantera/cantera/pull/1571), [#1589](https://github.com/Cantera/cantera/pull/1589))
- Numerous improvements to the organization and formatting of the Doxygen and Sphinx documentation, in part by using `doxygen-awesome` and the PyData Sphinx theme([E#115](https://github.com/Cantera/enhancements/issues/115), [E#175](https://github.com/Cantera/enhancements/issues/175), [E#179](https://github.com/Cantera/enhancements/issues/179), [#1279](https://github.com/Cantera/cantera/pull/1279), [#1427](https://github.com/Cantera/cantera/pull/1427), [#1518](https://github.com/Cantera/cantera/pull/1518), [#1534](https://github.com/Cantera/cantera/pull/1534), [#1541](https://github.com/Cantera/cantera/pull/1541), [#1543](https://github.com/Cantera/cantera/pull/1543), [#1546](https://github.com/Cantera/cantera/pull/1546), [#1551](https://github.com/Cantera/cantera/pull/1551), [#1557](https://github.com/Cantera/cantera/pull/1557), [#1558](https://github.com/Cantera/cantera/pull/1558), [#1559](https://github.com/Cantera/cantera/pull/1559), [#1561](https://github.com/Cantera/cantera/pull/1561), [#1562](https://github.com/Cantera/cantera/pull/1562), [#1563](https://github.com/Cantera/cantera/pull/1563), [#1567](https://github.com/Cantera/cantera/pull/1567), [#1572](https://github.com/Cantera/cantera/pull/1572), [#1573](https://github.com/Cantera/cantera/pull/1573), [#1582](https://github.com/Cantera/cantera/pull/1582), [#1581](https://github.com/Cantera/cantera/pull/1581), [#1584](https://github.com/Cantera/cantera/pull/1584), [#1590](https://github.com/Cantera/cantera/pull/1590))
- Various improvements to the SCons build system ([#1268](https://github.com/Cantera/cantera/pull/1268), [#1307](https://github.com/Cantera/cantera/pull/1307), [#1351](https://github.com/Cantera/cantera/pull/1351), [#1360](https://github.com/Cantera/cantera/pull/1360), [#1404](https://github.com/Cantera/cantera/pull/1404), [#1470](https://github.com/Cantera/cantera/pull/1470), [#1472](https://github.com/Cantera/cantera/pull/1472), [#1509](https://github.com/Cantera/cantera/pull/1509), [#1542](https://github.com/Cantera/cantera/pull/1542))
- Updates to simplify the special behavior that implements different 1D flame types and boundary conditions ([E#165](https://github.com/Cantera/enhancements/issues/165), [E#171](https://github.com/Cantera/enhancements/issues/171), [#1477](https://github.com/Cantera/cantera/pull/1477), [#1514](https://github.com/Cantera/cantera/pull/1514), [#1523](https://github.com/Cantera/cantera/pull/1523), [#1531](https://github.com/Cantera/cantera/pull/1531), [#1555](https://github.com/Cantera/cantera/pull/1555))
- Make use of C++ `Solution` objects in `Domain1D` and related classes ([#1345](https://github.com/Cantera/cantera/pull/1345), [#1384](https://github.com/Cantera/cantera/pull/1384), [#1444](https://github.com/Cantera/cantera/pull/1444), [#1594](https://github.com/Cantera/cantera/pull/1594), [#1598](https://github.com/Cantera/cantera/pull/1598))
- Improved error handling for clib `thermo_setDensity` and `thermo_setMolarDensity` methods ([#1413](https://github.com/Cantera/cantera/pull/1413))
- Speed up Python module import by deferring imports of optional dependencies ([#1428](https://github.com/Cantera/cantera/pull/1428))
- Link Python `list_data_files` to C++ `getDataDirectories` ([#1358](https://github.com/Cantera/cantera/pull/1358))
- Remove features deprecated in Cantera 2.6. Principally, this includes legacy reaction rate types ([#1292](https://github.com/Cantera/cantera/pull/1292)) and the CTI/XML input formats ([#1291](https://github.com/Cantera/cantera/pull/1291))
- Deprecate remaining specializations of `Reaction` class and obsolete methods that were used by legacy reaction rate evaluators ([E#149](https://github.com/Cantera/enhancements/issues/149), [#1295](https://github.com/Cantera/cantera/pull/1295), [#1333](https://github.com/Cantera/cantera/pull/1333))
- Deprecate other untested, unused and/or obsolete code (<a href="../../cxx/da/d58/deprecated.html">C++ Deprecations</a>, [#1455](https://github.com/Cantera/cantera/pull/1455), [#1504](https://github.com/Cantera/cantera/pull/1504))
- Improve deprecation warnings issued from Python to include the name of the deprecated method and to show the line where that function is called from ([#1519](https://github.com/Cantera/cantera/pull/1519))

## Bugs fixed

- Fixed thermodynamic consistency issues with `SurfPhase` and `RedlichKisterVPSSTP` ([#1449](https://github.com/Cantera/cantera/pull/1449))
- Fixed thermodynamic consistency errors in IAPWS water equation of state ([#1394](https://github.com/Cantera/cantera/pull/1394))
- Fixed thermodynamic consistency issues in `IdealSolidSolnPhase` and `BinarySolutionTabulatedThermo` ([#1442](https://github.com/Cantera/cantera/pull/1442))
- Fix calculation of electron enthalpy contribution in `PlasmaPhase` ([#1323](https://github.com/Cantera/cantera/pull/1323))
- Fix setting reference pressure for a phase by setting the reference pressure of the individual species ([#1503](https://github.com/Cantera/cantera/pull/1503))
- Fix issues with "volume" and compressibility of `SurfPhase` ([#1350](https://github.com/Cantera/cantera/pull/1350))
- Handle factorization errors in equilibrium initial estimator ([#1479](https://github.com/Cantera/cantera/pull/1479))
- Make helpful errors for invalid reactions work more consistently ([#1330](https://github.com/Cantera/cantera/pull/1330), [#1356](https://github.com/Cantera/cantera/pull/1356))
- Fix serialization of phases with reactions from multiple YAML sections ([#1552](https://github.com/Cantera/cantera/pull/1552))
- Fix loading serialized mechanisms where reactions contain undeclared third bodies ([#1588](https://github.com/Cantera/cantera/pull/1588))
- Fix cases where three-body reactions were not being automatically detected ([#1338](https://github.com/Cantera/cantera/pull/1338))
- Fix possible segfaults when using Python `CustomRate` ([#1293](https://github.com/Cantera/cantera/pull/1293))
- Partial fix for PLOG validation at low temperatures ([#1553](https://github.com/Cantera/cantera/pull/1553))
- Fix default `atol` used in `ReactorNet.advance_to_steady_state` ([#1305](https://github.com/Cantera/cantera/pull/1305))
- Fix reading arrays containing subnormal floating point values ([#1545](https://github.com/Cantera/cantera/pull/1545))
- Fix adding Python `Quantity` objects when using molar basis ([#1517](https://github.com/Cantera/cantera/pull/1517))
- Add missing array properties to `SolutionArray` and `FlameBase` ([#1342](https://github.com/Cantera/cantera/pull/1342))
- Fix [`surf_pfr_chain.py`](/examples/python/reactors/surf_pfr_chain) example to avoid misleading use of perturbed `Solution` objects ([#1304](https://github.com/Cantera/cantera/pull/1304))
- Fix Matlab samples to resolve issues from transition to YAML input files ([#1414](https://github.com/Cantera/cantera/pull/1414))
- Fix numerous build issues for certain configurations and platforms ([#1272](https://github.com/Cantera/cantera/pull/1272), [#1362](https://github.com/Cantera/cantera/pull/1362), [#1364](https://github.com/Cantera/cantera/pull/1364), [#1366](https://github.com/Cantera/cantera/pull/1366), [#1378](https://github.com/Cantera/cantera/pull/1378), [#1381](https://github.com/Cantera/cantera/pull/1381), [#1390](https://github.com/Cantera/cantera/pull/1390), [#1434](https://github.com/Cantera/cantera/pull/1434), [#1437](https://github.com/Cantera/cantera/pull/1437), [#1505](https://github.com/Cantera/cantera/pull/1505), [#1511](https://github.com/Cantera/cantera/pull/1511), [#1538](https://github.com/Cantera/cantera/pull/1538), [#1544](https://github.com/Cantera/cantera/pull/1544), [#1574](https://github.com/Cantera/cantera/pull/1574), [#1591](https://github.com/Cantera/cantera/pull/1591))
- Various documentation updates ([#1276](https://github.com/Cantera/cantera/pull/1276), [#1296](https://github.com/Cantera/cantera/pull/1296), [#1328](https://github.com/Cantera/cantera/pull/1328), [#1335](https://github.com/Cantera/cantera/pull/1335))


## Contributors

This release was made possible by the following contributors: [@anthony-walker](https://github.com/anthony-walker), [@arghdos](https://github.com/arghdos), [@band-a-prend](https://github.com/band-a-prend), [@BangShiuh](https://github.com/BangShiuh), [@bryanwweber](https://github.com/bryanwweber), [@burkenyo](https://github.com/burkenyo), [@c-randall](https://github.com/c-randall), [@cdeil](https://github.com/cdeil), [@chinahg](https://github.com/chinahg), [@corykinney](https://github.com/corykinney), [@decaluwe](https://github.com/decaluwe), [@g3bk47](https://github.com/g3bk47), [@gkogekar](https://github.com/gkogekar), [@hallaali](https://github.com/hallaali), [@ischoegl](https://github.com/ischoegl), [@jongyoonbae](https://github.com/jongyoonbae), [@kyleniemeyer](https://github.com/kyleniemeyer), [@mefuller](https://github.com/mefuller), [@rwest](https://github.com/rwest), [@speth](https://github.com/speth), [@ssun30](https://github.com/ssun30), [@tsikes](https://github.com/tsikes), [@yeanment](https://github.com/yeanment), [@yurivict](https://github.com/yurivict)
