// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package spoe

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// DeleteSpoeGroupNoContentCode is the HTTP code returned for type DeleteSpoeGroupNoContent
const DeleteSpoeGroupNoContentCode int = 204

/*
DeleteSpoeGroupNoContent Spoe group deleted

swagger:response deleteSpoeGroupNoContent
*/
type DeleteSpoeGroupNoContent struct {
}

// NewDeleteSpoeGroupNoContent creates DeleteSpoeGroupNoContent with default headers values
func NewDeleteSpoeGroupNoContent() *DeleteSpoeGroupNoContent {

	return &DeleteSpoeGroupNoContent{}
}

// WriteResponse to the client
func (o *DeleteSpoeGroupNoContent) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(204)
}

// DeleteSpoeGroupNotFoundCode is the HTTP code returned for type DeleteSpoeGroupNotFound
const DeleteSpoeGroupNotFoundCode int = 404

/*
DeleteSpoeGroupNotFound The specified resource was not found

swagger:response deleteSpoeGroupNotFound
*/
type DeleteSpoeGroupNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteSpoeGroupNotFound creates DeleteSpoeGroupNotFound with default headers values
func NewDeleteSpoeGroupNotFound() *DeleteSpoeGroupNotFound {

	return &DeleteSpoeGroupNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the delete spoe group not found response
func (o *DeleteSpoeGroupNotFound) WithConfigurationVersion(configurationVersion string) *DeleteSpoeGroupNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete spoe group not found response
func (o *DeleteSpoeGroupNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete spoe group not found response
func (o *DeleteSpoeGroupNotFound) WithPayload(payload *models.Error) *DeleteSpoeGroupNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete spoe group not found response
func (o *DeleteSpoeGroupNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteSpoeGroupNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
DeleteSpoeGroupDefault General Error

swagger:response deleteSpoeGroupDefault
*/
type DeleteSpoeGroupDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteSpoeGroupDefault creates DeleteSpoeGroupDefault with default headers values
func NewDeleteSpoeGroupDefault(code int) *DeleteSpoeGroupDefault {
	if code <= 0 {
		code = 500
	}

	return &DeleteSpoeGroupDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the delete spoe group default response
func (o *DeleteSpoeGroupDefault) WithStatusCode(code int) *DeleteSpoeGroupDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the delete spoe group default response
func (o *DeleteSpoeGroupDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the delete spoe group default response
func (o *DeleteSpoeGroupDefault) WithConfigurationVersion(configurationVersion string) *DeleteSpoeGroupDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete spoe group default response
func (o *DeleteSpoeGroupDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete spoe group default response
func (o *DeleteSpoeGroupDefault) WithPayload(payload *models.Error) *DeleteSpoeGroupDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete spoe group default response
func (o *DeleteSpoeGroupDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteSpoeGroupDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
