// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package quic_initial_rule

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// ReplaceQUICInitialRuleDefaultsOKCode is the HTTP code returned for type ReplaceQUICInitialRuleDefaultsOK
const ReplaceQUICInitialRuleDefaultsOKCode int = 200

/*
ReplaceQUICInitialRuleDefaultsOK QUIC Initial Rule replaced

swagger:response replaceQuicInitialRuleDefaultsOK
*/
type ReplaceQUICInitialRuleDefaultsOK struct {

	/*
	  In: Body
	*/
	Payload *models.QUICInitialRule `json:"body,omitempty"`
}

// NewReplaceQUICInitialRuleDefaultsOK creates ReplaceQUICInitialRuleDefaultsOK with default headers values
func NewReplaceQUICInitialRuleDefaultsOK() *ReplaceQUICInitialRuleDefaultsOK {

	return &ReplaceQUICInitialRuleDefaultsOK{}
}

// WithPayload adds the payload to the replace Quic initial rule defaults o k response
func (o *ReplaceQUICInitialRuleDefaultsOK) WithPayload(payload *models.QUICInitialRule) *ReplaceQUICInitialRuleDefaultsOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Quic initial rule defaults o k response
func (o *ReplaceQUICInitialRuleDefaultsOK) SetPayload(payload *models.QUICInitialRule) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceQUICInitialRuleDefaultsOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceQUICInitialRuleDefaultsAcceptedCode is the HTTP code returned for type ReplaceQUICInitialRuleDefaultsAccepted
const ReplaceQUICInitialRuleDefaultsAcceptedCode int = 202

/*
ReplaceQUICInitialRuleDefaultsAccepted Configuration change accepted and reload requested

swagger:response replaceQuicInitialRuleDefaultsAccepted
*/
type ReplaceQUICInitialRuleDefaultsAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.QUICInitialRule `json:"body,omitempty"`
}

// NewReplaceQUICInitialRuleDefaultsAccepted creates ReplaceQUICInitialRuleDefaultsAccepted with default headers values
func NewReplaceQUICInitialRuleDefaultsAccepted() *ReplaceQUICInitialRuleDefaultsAccepted {

	return &ReplaceQUICInitialRuleDefaultsAccepted{}
}

// WithReloadID adds the reloadId to the replace Quic initial rule defaults accepted response
func (o *ReplaceQUICInitialRuleDefaultsAccepted) WithReloadID(reloadID string) *ReplaceQUICInitialRuleDefaultsAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the replace Quic initial rule defaults accepted response
func (o *ReplaceQUICInitialRuleDefaultsAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the replace Quic initial rule defaults accepted response
func (o *ReplaceQUICInitialRuleDefaultsAccepted) WithPayload(payload *models.QUICInitialRule) *ReplaceQUICInitialRuleDefaultsAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Quic initial rule defaults accepted response
func (o *ReplaceQUICInitialRuleDefaultsAccepted) SetPayload(payload *models.QUICInitialRule) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceQUICInitialRuleDefaultsAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceQUICInitialRuleDefaultsBadRequestCode is the HTTP code returned for type ReplaceQUICInitialRuleDefaultsBadRequest
const ReplaceQUICInitialRuleDefaultsBadRequestCode int = 400

/*
ReplaceQUICInitialRuleDefaultsBadRequest Bad request

swagger:response replaceQuicInitialRuleDefaultsBadRequest
*/
type ReplaceQUICInitialRuleDefaultsBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceQUICInitialRuleDefaultsBadRequest creates ReplaceQUICInitialRuleDefaultsBadRequest with default headers values
func NewReplaceQUICInitialRuleDefaultsBadRequest() *ReplaceQUICInitialRuleDefaultsBadRequest {

	return &ReplaceQUICInitialRuleDefaultsBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the replace Quic initial rule defaults bad request response
func (o *ReplaceQUICInitialRuleDefaultsBadRequest) WithConfigurationVersion(configurationVersion string) *ReplaceQUICInitialRuleDefaultsBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace Quic initial rule defaults bad request response
func (o *ReplaceQUICInitialRuleDefaultsBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace Quic initial rule defaults bad request response
func (o *ReplaceQUICInitialRuleDefaultsBadRequest) WithPayload(payload *models.Error) *ReplaceQUICInitialRuleDefaultsBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Quic initial rule defaults bad request response
func (o *ReplaceQUICInitialRuleDefaultsBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceQUICInitialRuleDefaultsBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceQUICInitialRuleDefaultsNotFoundCode is the HTTP code returned for type ReplaceQUICInitialRuleDefaultsNotFound
const ReplaceQUICInitialRuleDefaultsNotFoundCode int = 404

/*
ReplaceQUICInitialRuleDefaultsNotFound The specified resource was not found

swagger:response replaceQuicInitialRuleDefaultsNotFound
*/
type ReplaceQUICInitialRuleDefaultsNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceQUICInitialRuleDefaultsNotFound creates ReplaceQUICInitialRuleDefaultsNotFound with default headers values
func NewReplaceQUICInitialRuleDefaultsNotFound() *ReplaceQUICInitialRuleDefaultsNotFound {

	return &ReplaceQUICInitialRuleDefaultsNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the replace Quic initial rule defaults not found response
func (o *ReplaceQUICInitialRuleDefaultsNotFound) WithConfigurationVersion(configurationVersion string) *ReplaceQUICInitialRuleDefaultsNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace Quic initial rule defaults not found response
func (o *ReplaceQUICInitialRuleDefaultsNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace Quic initial rule defaults not found response
func (o *ReplaceQUICInitialRuleDefaultsNotFound) WithPayload(payload *models.Error) *ReplaceQUICInitialRuleDefaultsNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Quic initial rule defaults not found response
func (o *ReplaceQUICInitialRuleDefaultsNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceQUICInitialRuleDefaultsNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
ReplaceQUICInitialRuleDefaultsDefault General Error

swagger:response replaceQuicInitialRuleDefaultsDefault
*/
type ReplaceQUICInitialRuleDefaultsDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceQUICInitialRuleDefaultsDefault creates ReplaceQUICInitialRuleDefaultsDefault with default headers values
func NewReplaceQUICInitialRuleDefaultsDefault(code int) *ReplaceQUICInitialRuleDefaultsDefault {
	if code <= 0 {
		code = 500
	}

	return &ReplaceQUICInitialRuleDefaultsDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the replace QUIC initial rule defaults default response
func (o *ReplaceQUICInitialRuleDefaultsDefault) WithStatusCode(code int) *ReplaceQUICInitialRuleDefaultsDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the replace QUIC initial rule defaults default response
func (o *ReplaceQUICInitialRuleDefaultsDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the replace QUIC initial rule defaults default response
func (o *ReplaceQUICInitialRuleDefaultsDefault) WithConfigurationVersion(configurationVersion string) *ReplaceQUICInitialRuleDefaultsDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace QUIC initial rule defaults default response
func (o *ReplaceQUICInitialRuleDefaultsDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace QUIC initial rule defaults default response
func (o *ReplaceQUICInitialRuleDefaultsDefault) WithPayload(payload *models.Error) *ReplaceQUICInitialRuleDefaultsDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace QUIC initial rule defaults default response
func (o *ReplaceQUICInitialRuleDefaultsDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceQUICInitialRuleDefaultsDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
