#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 2023
#define LARGE_STATE_COUNT 463
#define SYMBOL_COUNT 360
#define ALIAS_COUNT 3
#define TOKEN_COUNT 161
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 39
#define MAX_ALIAS_SEQUENCE_LENGTH 9
#define PRODUCTION_ID_COUNT 133

enum ts_symbol_identifiers {
  sym_identifier = 1,
  aux_sym_preproc_include_token1 = 2,
  aux_sym_preproc_include_token2 = 3,
  aux_sym_preproc_def_token1 = 4,
  anon_sym_LPAREN = 5,
  anon_sym_DOT_DOT_DOT = 6,
  anon_sym_COMMA = 7,
  anon_sym_RPAREN = 8,
  aux_sym_preproc_if_token1 = 9,
  anon_sym_LF = 10,
  aux_sym_preproc_if_token2 = 11,
  aux_sym_preproc_ifdef_token1 = 12,
  aux_sym_preproc_ifdef_token2 = 13,
  aux_sym_preproc_else_token1 = 14,
  aux_sym_preproc_elif_token1 = 15,
  aux_sym_preproc_elifdef_token1 = 16,
  aux_sym_preproc_elifdef_token2 = 17,
  sym_preproc_arg = 18,
  sym_preproc_directive = 19,
  anon_sym_LPAREN2 = 20,
  anon_sym_defined = 21,
  anon_sym_BANG = 22,
  anon_sym_TILDE = 23,
  anon_sym_DASH = 24,
  anon_sym_PLUS = 25,
  anon_sym_STAR = 26,
  anon_sym_SLASH = 27,
  anon_sym_PERCENT = 28,
  anon_sym_PIPE_PIPE = 29,
  anon_sym_AMP_AMP = 30,
  anon_sym_PIPE = 31,
  anon_sym_CARET = 32,
  anon_sym_AMP = 33,
  anon_sym_EQ_EQ = 34,
  anon_sym_BANG_EQ = 35,
  anon_sym_GT = 36,
  anon_sym_GT_EQ = 37,
  anon_sym_LT_EQ = 38,
  anon_sym_LT = 39,
  anon_sym_LT_LT = 40,
  anon_sym_GT_GT = 41,
  anon_sym_SEMI = 42,
  anon_sym___extension__ = 43,
  anon_sym_typedef = 44,
  anon_sym_extern = 45,
  anon_sym___attribute__ = 46,
  anon_sym___attribute = 47,
  anon_sym_COLON_COLON = 48,
  anon_sym_LBRACK_LBRACK = 49,
  anon_sym_RBRACK_RBRACK = 50,
  anon_sym___declspec = 51,
  anon_sym___based = 52,
  anon_sym___cdecl = 53,
  anon_sym___clrcall = 54,
  anon_sym___stdcall = 55,
  anon_sym___fastcall = 56,
  anon_sym___thiscall = 57,
  anon_sym___vectorcall = 58,
  sym_ms_restrict_modifier = 59,
  sym_ms_unsigned_ptr_modifier = 60,
  sym_ms_signed_ptr_modifier = 61,
  anon_sym__unaligned = 62,
  anon_sym___unaligned = 63,
  anon_sym_LBRACE = 64,
  anon_sym_RBRACE = 65,
  anon_sym_signed = 66,
  anon_sym_unsigned = 67,
  anon_sym_long = 68,
  anon_sym_short = 69,
  anon_sym_LBRACK = 70,
  anon_sym_static = 71,
  anon_sym_RBRACK = 72,
  anon_sym_EQ = 73,
  anon_sym_auto = 74,
  anon_sym_register = 75,
  anon_sym_inline = 76,
  anon_sym___inline = 77,
  anon_sym___inline__ = 78,
  anon_sym___forceinline = 79,
  anon_sym_thread_local = 80,
  anon_sym___thread = 81,
  anon_sym_const = 82,
  anon_sym_constexpr = 83,
  anon_sym_volatile = 84,
  anon_sym_restrict = 85,
  anon_sym___restrict__ = 86,
  anon_sym__Atomic = 87,
  anon_sym__Noreturn = 88,
  anon_sym_noreturn = 89,
  anon_sym__Nonnull = 90,
  anon_sym_alignas = 91,
  anon_sym__Alignas = 92,
  sym_primitive_type = 93,
  anon_sym_enum = 94,
  anon_sym_COLON = 95,
  anon_sym_struct = 96,
  anon_sym_union = 97,
  anon_sym_if = 98,
  anon_sym_else = 99,
  anon_sym_switch = 100,
  anon_sym_case = 101,
  anon_sym_default = 102,
  anon_sym_while = 103,
  anon_sym_do = 104,
  anon_sym_for = 105,
  anon_sym_return = 106,
  anon_sym_break = 107,
  anon_sym_continue = 108,
  anon_sym_goto = 109,
  anon_sym___try = 110,
  anon_sym___except = 111,
  anon_sym___finally = 112,
  anon_sym___leave = 113,
  anon_sym_QMARK = 114,
  anon_sym_STAR_EQ = 115,
  anon_sym_SLASH_EQ = 116,
  anon_sym_PERCENT_EQ = 117,
  anon_sym_PLUS_EQ = 118,
  anon_sym_DASH_EQ = 119,
  anon_sym_LT_LT_EQ = 120,
  anon_sym_GT_GT_EQ = 121,
  anon_sym_AMP_EQ = 122,
  anon_sym_CARET_EQ = 123,
  anon_sym_PIPE_EQ = 124,
  anon_sym_DASH_DASH = 125,
  anon_sym_PLUS_PLUS = 126,
  anon_sym_sizeof = 127,
  anon_sym___alignof__ = 128,
  anon_sym___alignof = 129,
  anon_sym__alignof = 130,
  anon_sym_alignof = 131,
  anon_sym__Alignof = 132,
  anon_sym_offsetof = 133,
  anon_sym__Generic = 134,
  anon_sym_asm = 135,
  anon_sym___asm__ = 136,
  anon_sym___asm = 137,
  anon_sym___volatile__ = 138,
  anon_sym_DOT = 139,
  anon_sym_DASH_GT = 140,
  sym_number_literal = 141,
  anon_sym_L_SQUOTE = 142,
  anon_sym_u_SQUOTE = 143,
  anon_sym_U_SQUOTE = 144,
  anon_sym_u8_SQUOTE = 145,
  anon_sym_SQUOTE = 146,
  aux_sym_char_literal_token1 = 147,
  anon_sym_L_DQUOTE = 148,
  anon_sym_u_DQUOTE = 149,
  anon_sym_U_DQUOTE = 150,
  anon_sym_u8_DQUOTE = 151,
  anon_sym_DQUOTE = 152,
  aux_sym_string_literal_token1 = 153,
  sym_escape_sequence = 154,
  sym_system_lib_string = 155,
  sym_true = 156,
  sym_false = 157,
  anon_sym_NULL = 158,
  anon_sym_nullptr = 159,
  sym_comment = 160,
  sym_translation_unit = 161,
  sym__top_level_item = 162,
  sym__block_item = 163,
  sym_preproc_include = 164,
  sym_preproc_def = 165,
  sym_preproc_function_def = 166,
  sym_preproc_params = 167,
  sym_preproc_call = 168,
  sym_preproc_if = 169,
  sym_preproc_ifdef = 170,
  sym_preproc_else = 171,
  sym_preproc_elif = 172,
  sym_preproc_elifdef = 173,
  sym_preproc_if_in_field_declaration_list = 174,
  sym_preproc_ifdef_in_field_declaration_list = 175,
  sym_preproc_else_in_field_declaration_list = 176,
  sym_preproc_elif_in_field_declaration_list = 177,
  sym_preproc_elifdef_in_field_declaration_list = 178,
  sym_preproc_if_in_enumerator_list = 179,
  sym_preproc_ifdef_in_enumerator_list = 180,
  sym_preproc_else_in_enumerator_list = 181,
  sym_preproc_elif_in_enumerator_list = 182,
  sym_preproc_elifdef_in_enumerator_list = 183,
  sym_preproc_if_in_enumerator_list_no_comma = 184,
  sym_preproc_ifdef_in_enumerator_list_no_comma = 185,
  sym_preproc_else_in_enumerator_list_no_comma = 186,
  sym_preproc_elif_in_enumerator_list_no_comma = 187,
  sym_preproc_elifdef_in_enumerator_list_no_comma = 188,
  sym__preproc_expression = 189,
  sym_preproc_parenthesized_expression = 190,
  sym_preproc_defined = 191,
  sym_preproc_unary_expression = 192,
  sym_preproc_call_expression = 193,
  sym_preproc_argument_list = 194,
  sym_preproc_binary_expression = 195,
  sym_function_definition = 196,
  sym__old_style_function_definition = 197,
  sym_declaration = 198,
  sym_type_definition = 199,
  sym__type_definition_type = 200,
  sym__type_definition_declarators = 201,
  sym__declaration_modifiers = 202,
  sym__declaration_specifiers = 203,
  sym_linkage_specification = 204,
  sym_attribute_specifier = 205,
  sym_attribute = 206,
  sym_attribute_declaration = 207,
  sym_ms_declspec_modifier = 208,
  sym_ms_based_modifier = 209,
  sym_ms_call_modifier = 210,
  sym_ms_unaligned_ptr_modifier = 211,
  sym_ms_pointer_modifier = 212,
  sym_declaration_list = 213,
  sym__declarator = 214,
  sym__declaration_declarator = 215,
  sym__field_declarator = 216,
  sym__type_declarator = 217,
  sym__abstract_declarator = 218,
  sym_parenthesized_declarator = 219,
  sym_parenthesized_field_declarator = 220,
  sym_parenthesized_type_declarator = 221,
  sym_abstract_parenthesized_declarator = 222,
  sym_attributed_declarator = 223,
  sym_attributed_field_declarator = 224,
  sym_attributed_type_declarator = 225,
  sym_pointer_declarator = 226,
  sym_pointer_field_declarator = 227,
  sym_pointer_type_declarator = 228,
  sym_abstract_pointer_declarator = 229,
  sym_function_declarator = 230,
  sym__function_declaration_declarator = 231,
  sym_function_field_declarator = 232,
  sym_function_type_declarator = 233,
  sym_abstract_function_declarator = 234,
  sym__old_style_function_declarator = 235,
  sym_array_declarator = 236,
  sym_array_field_declarator = 237,
  sym_array_type_declarator = 238,
  sym_abstract_array_declarator = 239,
  sym_init_declarator = 240,
  sym_compound_statement = 241,
  sym_storage_class_specifier = 242,
  sym_type_qualifier = 243,
  sym_alignas_qualifier = 244,
  sym_type_specifier = 245,
  sym_sized_type_specifier = 246,
  sym_enum_specifier = 247,
  sym_enumerator_list = 248,
  sym_struct_specifier = 249,
  sym_union_specifier = 250,
  sym_field_declaration_list = 251,
  sym__field_declaration_list_item = 252,
  sym_field_declaration = 253,
  sym__field_declaration_declarator = 254,
  sym_bitfield_clause = 255,
  sym_enumerator = 256,
  sym_variadic_parameter = 257,
  sym_parameter_list = 258,
  sym__old_style_parameter_list = 259,
  sym_parameter_declaration = 260,
  sym_attributed_statement = 261,
  sym_statement = 262,
  sym__top_level_statement = 263,
  sym_labeled_statement = 264,
  sym__top_level_expression_statement = 265,
  sym_expression_statement = 266,
  sym_if_statement = 267,
  sym_else_clause = 268,
  sym_switch_statement = 269,
  sym_case_statement = 270,
  sym_while_statement = 271,
  sym_do_statement = 272,
  sym_for_statement = 273,
  sym__for_statement_body = 274,
  sym_return_statement = 275,
  sym_break_statement = 276,
  sym_continue_statement = 277,
  sym_goto_statement = 278,
  sym_seh_try_statement = 279,
  sym_seh_except_clause = 280,
  sym_seh_finally_clause = 281,
  sym_seh_leave_statement = 282,
  sym_expression = 283,
  sym__string = 284,
  sym_comma_expression = 285,
  sym_conditional_expression = 286,
  sym_assignment_expression = 287,
  sym_pointer_expression = 288,
  sym_unary_expression = 289,
  sym_binary_expression = 290,
  sym_update_expression = 291,
  sym_cast_expression = 292,
  sym_type_descriptor = 293,
  sym_sizeof_expression = 294,
  sym_alignof_expression = 295,
  sym_offsetof_expression = 296,
  sym_generic_expression = 297,
  sym_subscript_expression = 298,
  sym_call_expression = 299,
  sym_gnu_asm_expression = 300,
  sym_gnu_asm_qualifier = 301,
  sym_gnu_asm_output_operand_list = 302,
  sym_gnu_asm_output_operand = 303,
  sym_gnu_asm_input_operand_list = 304,
  sym_gnu_asm_input_operand = 305,
  sym_gnu_asm_clobber_list = 306,
  sym_gnu_asm_goto_list = 307,
  sym_extension_expression = 308,
  sym_argument_list = 309,
  sym_field_expression = 310,
  sym_compound_literal_expression = 311,
  sym_parenthesized_expression = 312,
  sym_initializer_list = 313,
  sym_initializer_pair = 314,
  sym_subscript_designator = 315,
  sym_subscript_range_designator = 316,
  sym_field_designator = 317,
  sym_char_literal = 318,
  sym_concatenated_string = 319,
  sym_string_literal = 320,
  sym_null = 321,
  sym__empty_declaration = 322,
  sym_macro_type_specifier = 323,
  aux_sym_translation_unit_repeat1 = 324,
  aux_sym_preproc_params_repeat1 = 325,
  aux_sym_preproc_if_repeat1 = 326,
  aux_sym_preproc_if_in_field_declaration_list_repeat1 = 327,
  aux_sym_preproc_if_in_enumerator_list_repeat1 = 328,
  aux_sym_preproc_if_in_enumerator_list_no_comma_repeat1 = 329,
  aux_sym_preproc_argument_list_repeat1 = 330,
  aux_sym__old_style_function_definition_repeat1 = 331,
  aux_sym_declaration_repeat1 = 332,
  aux_sym_type_definition_repeat1 = 333,
  aux_sym__type_definition_type_repeat1 = 334,
  aux_sym__type_definition_declarators_repeat1 = 335,
  aux_sym__declaration_specifiers_repeat1 = 336,
  aux_sym_attribute_declaration_repeat1 = 337,
  aux_sym_attributed_declarator_repeat1 = 338,
  aux_sym_pointer_declarator_repeat1 = 339,
  aux_sym_function_declarator_repeat1 = 340,
  aux_sym_array_declarator_repeat1 = 341,
  aux_sym_sized_type_specifier_repeat1 = 342,
  aux_sym_enumerator_list_repeat1 = 343,
  aux_sym__field_declaration_declarator_repeat1 = 344,
  aux_sym_parameter_list_repeat1 = 345,
  aux_sym__old_style_parameter_list_repeat1 = 346,
  aux_sym_case_statement_repeat1 = 347,
  aux_sym_generic_expression_repeat1 = 348,
  aux_sym_gnu_asm_expression_repeat1 = 349,
  aux_sym_gnu_asm_output_operand_list_repeat1 = 350,
  aux_sym_gnu_asm_input_operand_list_repeat1 = 351,
  aux_sym_gnu_asm_clobber_list_repeat1 = 352,
  aux_sym_gnu_asm_goto_list_repeat1 = 353,
  aux_sym_argument_list_repeat1 = 354,
  aux_sym_initializer_list_repeat1 = 355,
  aux_sym_initializer_pair_repeat1 = 356,
  aux_sym_char_literal_repeat1 = 357,
  aux_sym_concatenated_string_repeat1 = 358,
  aux_sym_string_literal_repeat1 = 359,
  alias_sym_field_identifier = 360,
  alias_sym_statement_identifier = 361,
  alias_sym_type_identifier = 362,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [aux_sym_preproc_include_token1] = "#include",
  [aux_sym_preproc_include_token2] = "preproc_include_token2",
  [aux_sym_preproc_def_token1] = "#define",
  [anon_sym_LPAREN] = "(",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_COMMA] = ",",
  [anon_sym_RPAREN] = ")",
  [aux_sym_preproc_if_token1] = "#if",
  [anon_sym_LF] = "\n",
  [aux_sym_preproc_if_token2] = "#endif",
  [aux_sym_preproc_ifdef_token1] = "#ifdef",
  [aux_sym_preproc_ifdef_token2] = "#ifndef",
  [aux_sym_preproc_else_token1] = "#else",
  [aux_sym_preproc_elif_token1] = "#elif",
  [aux_sym_preproc_elifdef_token1] = "#elifdef",
  [aux_sym_preproc_elifdef_token2] = "#elifndef",
  [sym_preproc_arg] = "preproc_arg",
  [sym_preproc_directive] = "preproc_directive",
  [anon_sym_LPAREN2] = "(",
  [anon_sym_defined] = "defined",
  [anon_sym_BANG] = "!",
  [anon_sym_TILDE] = "~",
  [anon_sym_DASH] = "-",
  [anon_sym_PLUS] = "+",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE] = "|",
  [anon_sym_CARET] = "^",
  [anon_sym_AMP] = "&",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_GT] = ">",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_LT] = "<",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_SEMI] = ";",
  [anon_sym___extension__] = "__extension__",
  [anon_sym_typedef] = "typedef",
  [anon_sym_extern] = "extern",
  [anon_sym___attribute__] = "__attribute__",
  [anon_sym___attribute] = "__attribute",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_LBRACK_LBRACK] = "[[",
  [anon_sym_RBRACK_RBRACK] = "]]",
  [anon_sym___declspec] = "__declspec",
  [anon_sym___based] = "__based",
  [anon_sym___cdecl] = "__cdecl",
  [anon_sym___clrcall] = "__clrcall",
  [anon_sym___stdcall] = "__stdcall",
  [anon_sym___fastcall] = "__fastcall",
  [anon_sym___thiscall] = "__thiscall",
  [anon_sym___vectorcall] = "__vectorcall",
  [sym_ms_restrict_modifier] = "ms_restrict_modifier",
  [sym_ms_unsigned_ptr_modifier] = "ms_unsigned_ptr_modifier",
  [sym_ms_signed_ptr_modifier] = "ms_signed_ptr_modifier",
  [anon_sym__unaligned] = "_unaligned",
  [anon_sym___unaligned] = "__unaligned",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_signed] = "signed",
  [anon_sym_unsigned] = "unsigned",
  [anon_sym_long] = "long",
  [anon_sym_short] = "short",
  [anon_sym_LBRACK] = "[",
  [anon_sym_static] = "static",
  [anon_sym_RBRACK] = "]",
  [anon_sym_EQ] = "=",
  [anon_sym_auto] = "auto",
  [anon_sym_register] = "register",
  [anon_sym_inline] = "inline",
  [anon_sym___inline] = "__inline",
  [anon_sym___inline__] = "__inline__",
  [anon_sym___forceinline] = "__forceinline",
  [anon_sym_thread_local] = "thread_local",
  [anon_sym___thread] = "__thread",
  [anon_sym_const] = "const",
  [anon_sym_constexpr] = "constexpr",
  [anon_sym_volatile] = "volatile",
  [anon_sym_restrict] = "restrict",
  [anon_sym___restrict__] = "__restrict__",
  [anon_sym__Atomic] = "_Atomic",
  [anon_sym__Noreturn] = "_Noreturn",
  [anon_sym_noreturn] = "noreturn",
  [anon_sym__Nonnull] = "_Nonnull",
  [anon_sym_alignas] = "alignas",
  [anon_sym__Alignas] = "_Alignas",
  [sym_primitive_type] = "primitive_type",
  [anon_sym_enum] = "enum",
  [anon_sym_COLON] = ":",
  [anon_sym_struct] = "struct",
  [anon_sym_union] = "union",
  [anon_sym_if] = "if",
  [anon_sym_else] = "else",
  [anon_sym_switch] = "switch",
  [anon_sym_case] = "case",
  [anon_sym_default] = "default",
  [anon_sym_while] = "while",
  [anon_sym_do] = "do",
  [anon_sym_for] = "for",
  [anon_sym_return] = "return",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [anon_sym_goto] = "goto",
  [anon_sym___try] = "__try",
  [anon_sym___except] = "__except",
  [anon_sym___finally] = "__finally",
  [anon_sym___leave] = "__leave",
  [anon_sym_QMARK] = "\?",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_DASH_DASH] = "--",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_sizeof] = "sizeof",
  [anon_sym___alignof__] = "__alignof__",
  [anon_sym___alignof] = "__alignof",
  [anon_sym__alignof] = "_alignof",
  [anon_sym_alignof] = "alignof",
  [anon_sym__Alignof] = "_Alignof",
  [anon_sym_offsetof] = "offsetof",
  [anon_sym__Generic] = "_Generic",
  [anon_sym_asm] = "asm",
  [anon_sym___asm__] = "__asm__",
  [anon_sym___asm] = "__asm",
  [anon_sym___volatile__] = "__volatile__",
  [anon_sym_DOT] = ".",
  [anon_sym_DASH_GT] = "->",
  [sym_number_literal] = "number_literal",
  [anon_sym_L_SQUOTE] = "L'",
  [anon_sym_u_SQUOTE] = "u'",
  [anon_sym_U_SQUOTE] = "U'",
  [anon_sym_u8_SQUOTE] = "u8'",
  [anon_sym_SQUOTE] = "'",
  [aux_sym_char_literal_token1] = "character",
  [anon_sym_L_DQUOTE] = "L\"",
  [anon_sym_u_DQUOTE] = "u\"",
  [anon_sym_U_DQUOTE] = "U\"",
  [anon_sym_u8_DQUOTE] = "u8\"",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_string_literal_token1] = "string_content",
  [sym_escape_sequence] = "escape_sequence",
  [sym_system_lib_string] = "system_lib_string",
  [sym_true] = "true",
  [sym_false] = "false",
  [anon_sym_NULL] = "NULL",
  [anon_sym_nullptr] = "nullptr",
  [sym_comment] = "comment",
  [sym_translation_unit] = "translation_unit",
  [sym__top_level_item] = "_top_level_item",
  [sym__block_item] = "_block_item",
  [sym_preproc_include] = "preproc_include",
  [sym_preproc_def] = "preproc_def",
  [sym_preproc_function_def] = "preproc_function_def",
  [sym_preproc_params] = "preproc_params",
  [sym_preproc_call] = "preproc_call",
  [sym_preproc_if] = "preproc_if",
  [sym_preproc_ifdef] = "preproc_ifdef",
  [sym_preproc_else] = "preproc_else",
  [sym_preproc_elif] = "preproc_elif",
  [sym_preproc_elifdef] = "preproc_elifdef",
  [sym_preproc_if_in_field_declaration_list] = "preproc_if",
  [sym_preproc_ifdef_in_field_declaration_list] = "preproc_ifdef",
  [sym_preproc_else_in_field_declaration_list] = "preproc_else",
  [sym_preproc_elif_in_field_declaration_list] = "preproc_elif",
  [sym_preproc_elifdef_in_field_declaration_list] = "preproc_elifdef",
  [sym_preproc_if_in_enumerator_list] = "preproc_if",
  [sym_preproc_ifdef_in_enumerator_list] = "preproc_ifdef",
  [sym_preproc_else_in_enumerator_list] = "preproc_else",
  [sym_preproc_elif_in_enumerator_list] = "preproc_elif",
  [sym_preproc_elifdef_in_enumerator_list] = "preproc_elifdef",
  [sym_preproc_if_in_enumerator_list_no_comma] = "preproc_if",
  [sym_preproc_ifdef_in_enumerator_list_no_comma] = "preproc_ifdef",
  [sym_preproc_else_in_enumerator_list_no_comma] = "preproc_else",
  [sym_preproc_elif_in_enumerator_list_no_comma] = "preproc_elif",
  [sym_preproc_elifdef_in_enumerator_list_no_comma] = "preproc_elifdef",
  [sym__preproc_expression] = "_preproc_expression",
  [sym_preproc_parenthesized_expression] = "parenthesized_expression",
  [sym_preproc_defined] = "preproc_defined",
  [sym_preproc_unary_expression] = "unary_expression",
  [sym_preproc_call_expression] = "call_expression",
  [sym_preproc_argument_list] = "argument_list",
  [sym_preproc_binary_expression] = "binary_expression",
  [sym_function_definition] = "function_definition",
  [sym__old_style_function_definition] = "function_definition",
  [sym_declaration] = "declaration",
  [sym_type_definition] = "type_definition",
  [sym__type_definition_type] = "_type_definition_type",
  [sym__type_definition_declarators] = "_type_definition_declarators",
  [sym__declaration_modifiers] = "_declaration_modifiers",
  [sym__declaration_specifiers] = "_declaration_specifiers",
  [sym_linkage_specification] = "linkage_specification",
  [sym_attribute_specifier] = "attribute_specifier",
  [sym_attribute] = "attribute",
  [sym_attribute_declaration] = "attribute_declaration",
  [sym_ms_declspec_modifier] = "ms_declspec_modifier",
  [sym_ms_based_modifier] = "ms_based_modifier",
  [sym_ms_call_modifier] = "ms_call_modifier",
  [sym_ms_unaligned_ptr_modifier] = "ms_unaligned_ptr_modifier",
  [sym_ms_pointer_modifier] = "ms_pointer_modifier",
  [sym_declaration_list] = "declaration_list",
  [sym__declarator] = "_declarator",
  [sym__declaration_declarator] = "_declaration_declarator",
  [sym__field_declarator] = "_field_declarator",
  [sym__type_declarator] = "_type_declarator",
  [sym__abstract_declarator] = "_abstract_declarator",
  [sym_parenthesized_declarator] = "parenthesized_declarator",
  [sym_parenthesized_field_declarator] = "parenthesized_declarator",
  [sym_parenthesized_type_declarator] = "parenthesized_declarator",
  [sym_abstract_parenthesized_declarator] = "abstract_parenthesized_declarator",
  [sym_attributed_declarator] = "attributed_declarator",
  [sym_attributed_field_declarator] = "attributed_declarator",
  [sym_attributed_type_declarator] = "attributed_declarator",
  [sym_pointer_declarator] = "pointer_declarator",
  [sym_pointer_field_declarator] = "pointer_declarator",
  [sym_pointer_type_declarator] = "pointer_declarator",
  [sym_abstract_pointer_declarator] = "abstract_pointer_declarator",
  [sym_function_declarator] = "function_declarator",
  [sym__function_declaration_declarator] = "function_declarator",
  [sym_function_field_declarator] = "function_declarator",
  [sym_function_type_declarator] = "function_declarator",
  [sym_abstract_function_declarator] = "abstract_function_declarator",
  [sym__old_style_function_declarator] = "function_declarator",
  [sym_array_declarator] = "array_declarator",
  [sym_array_field_declarator] = "array_declarator",
  [sym_array_type_declarator] = "array_declarator",
  [sym_abstract_array_declarator] = "abstract_array_declarator",
  [sym_init_declarator] = "init_declarator",
  [sym_compound_statement] = "compound_statement",
  [sym_storage_class_specifier] = "storage_class_specifier",
  [sym_type_qualifier] = "type_qualifier",
  [sym_alignas_qualifier] = "alignas_qualifier",
  [sym_type_specifier] = "type_specifier",
  [sym_sized_type_specifier] = "sized_type_specifier",
  [sym_enum_specifier] = "enum_specifier",
  [sym_enumerator_list] = "enumerator_list",
  [sym_struct_specifier] = "struct_specifier",
  [sym_union_specifier] = "union_specifier",
  [sym_field_declaration_list] = "field_declaration_list",
  [sym__field_declaration_list_item] = "_field_declaration_list_item",
  [sym_field_declaration] = "field_declaration",
  [sym__field_declaration_declarator] = "_field_declaration_declarator",
  [sym_bitfield_clause] = "bitfield_clause",
  [sym_enumerator] = "enumerator",
  [sym_variadic_parameter] = "variadic_parameter",
  [sym_parameter_list] = "parameter_list",
  [sym__old_style_parameter_list] = "parameter_list",
  [sym_parameter_declaration] = "parameter_declaration",
  [sym_attributed_statement] = "attributed_statement",
  [sym_statement] = "statement",
  [sym__top_level_statement] = "_top_level_statement",
  [sym_labeled_statement] = "labeled_statement",
  [sym__top_level_expression_statement] = "expression_statement",
  [sym_expression_statement] = "expression_statement",
  [sym_if_statement] = "if_statement",
  [sym_else_clause] = "else_clause",
  [sym_switch_statement] = "switch_statement",
  [sym_case_statement] = "case_statement",
  [sym_while_statement] = "while_statement",
  [sym_do_statement] = "do_statement",
  [sym_for_statement] = "for_statement",
  [sym__for_statement_body] = "_for_statement_body",
  [sym_return_statement] = "return_statement",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_goto_statement] = "goto_statement",
  [sym_seh_try_statement] = "seh_try_statement",
  [sym_seh_except_clause] = "seh_except_clause",
  [sym_seh_finally_clause] = "seh_finally_clause",
  [sym_seh_leave_statement] = "seh_leave_statement",
  [sym_expression] = "expression",
  [sym__string] = "_string",
  [sym_comma_expression] = "comma_expression",
  [sym_conditional_expression] = "conditional_expression",
  [sym_assignment_expression] = "assignment_expression",
  [sym_pointer_expression] = "pointer_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_update_expression] = "update_expression",
  [sym_cast_expression] = "cast_expression",
  [sym_type_descriptor] = "type_descriptor",
  [sym_sizeof_expression] = "sizeof_expression",
  [sym_alignof_expression] = "alignof_expression",
  [sym_offsetof_expression] = "offsetof_expression",
  [sym_generic_expression] = "generic_expression",
  [sym_subscript_expression] = "subscript_expression",
  [sym_call_expression] = "call_expression",
  [sym_gnu_asm_expression] = "gnu_asm_expression",
  [sym_gnu_asm_qualifier] = "gnu_asm_qualifier",
  [sym_gnu_asm_output_operand_list] = "gnu_asm_output_operand_list",
  [sym_gnu_asm_output_operand] = "gnu_asm_output_operand",
  [sym_gnu_asm_input_operand_list] = "gnu_asm_input_operand_list",
  [sym_gnu_asm_input_operand] = "gnu_asm_input_operand",
  [sym_gnu_asm_clobber_list] = "gnu_asm_clobber_list",
  [sym_gnu_asm_goto_list] = "gnu_asm_goto_list",
  [sym_extension_expression] = "extension_expression",
  [sym_argument_list] = "argument_list",
  [sym_field_expression] = "field_expression",
  [sym_compound_literal_expression] = "compound_literal_expression",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_initializer_list] = "initializer_list",
  [sym_initializer_pair] = "initializer_pair",
  [sym_subscript_designator] = "subscript_designator",
  [sym_subscript_range_designator] = "subscript_range_designator",
  [sym_field_designator] = "field_designator",
  [sym_char_literal] = "char_literal",
  [sym_concatenated_string] = "concatenated_string",
  [sym_string_literal] = "string_literal",
  [sym_null] = "null",
  [sym__empty_declaration] = "_empty_declaration",
  [sym_macro_type_specifier] = "macro_type_specifier",
  [aux_sym_translation_unit_repeat1] = "translation_unit_repeat1",
  [aux_sym_preproc_params_repeat1] = "preproc_params_repeat1",
  [aux_sym_preproc_if_repeat1] = "preproc_if_repeat1",
  [aux_sym_preproc_if_in_field_declaration_list_repeat1] = "preproc_if_in_field_declaration_list_repeat1",
  [aux_sym_preproc_if_in_enumerator_list_repeat1] = "preproc_if_in_enumerator_list_repeat1",
  [aux_sym_preproc_if_in_enumerator_list_no_comma_repeat1] = "preproc_if_in_enumerator_list_no_comma_repeat1",
  [aux_sym_preproc_argument_list_repeat1] = "preproc_argument_list_repeat1",
  [aux_sym__old_style_function_definition_repeat1] = "_old_style_function_definition_repeat1",
  [aux_sym_declaration_repeat1] = "declaration_repeat1",
  [aux_sym_type_definition_repeat1] = "type_definition_repeat1",
  [aux_sym__type_definition_type_repeat1] = "_type_definition_type_repeat1",
  [aux_sym__type_definition_declarators_repeat1] = "_type_definition_declarators_repeat1",
  [aux_sym__declaration_specifiers_repeat1] = "_declaration_specifiers_repeat1",
  [aux_sym_attribute_declaration_repeat1] = "attribute_declaration_repeat1",
  [aux_sym_attributed_declarator_repeat1] = "attributed_declarator_repeat1",
  [aux_sym_pointer_declarator_repeat1] = "pointer_declarator_repeat1",
  [aux_sym_function_declarator_repeat1] = "function_declarator_repeat1",
  [aux_sym_array_declarator_repeat1] = "array_declarator_repeat1",
  [aux_sym_sized_type_specifier_repeat1] = "sized_type_specifier_repeat1",
  [aux_sym_enumerator_list_repeat1] = "enumerator_list_repeat1",
  [aux_sym__field_declaration_declarator_repeat1] = "_field_declaration_declarator_repeat1",
  [aux_sym_parameter_list_repeat1] = "parameter_list_repeat1",
  [aux_sym__old_style_parameter_list_repeat1] = "_old_style_parameter_list_repeat1",
  [aux_sym_case_statement_repeat1] = "case_statement_repeat1",
  [aux_sym_generic_expression_repeat1] = "generic_expression_repeat1",
  [aux_sym_gnu_asm_expression_repeat1] = "gnu_asm_expression_repeat1",
  [aux_sym_gnu_asm_output_operand_list_repeat1] = "gnu_asm_output_operand_list_repeat1",
  [aux_sym_gnu_asm_input_operand_list_repeat1] = "gnu_asm_input_operand_list_repeat1",
  [aux_sym_gnu_asm_clobber_list_repeat1] = "gnu_asm_clobber_list_repeat1",
  [aux_sym_gnu_asm_goto_list_repeat1] = "gnu_asm_goto_list_repeat1",
  [aux_sym_argument_list_repeat1] = "argument_list_repeat1",
  [aux_sym_initializer_list_repeat1] = "initializer_list_repeat1",
  [aux_sym_initializer_pair_repeat1] = "initializer_pair_repeat1",
  [aux_sym_char_literal_repeat1] = "char_literal_repeat1",
  [aux_sym_concatenated_string_repeat1] = "concatenated_string_repeat1",
  [aux_sym_string_literal_repeat1] = "string_literal_repeat1",
  [alias_sym_field_identifier] = "field_identifier",
  [alias_sym_statement_identifier] = "statement_identifier",
  [alias_sym_type_identifier] = "type_identifier",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [aux_sym_preproc_include_token1] = aux_sym_preproc_include_token1,
  [aux_sym_preproc_include_token2] = aux_sym_preproc_include_token2,
  [aux_sym_preproc_def_token1] = aux_sym_preproc_def_token1,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [aux_sym_preproc_if_token1] = aux_sym_preproc_if_token1,
  [anon_sym_LF] = anon_sym_LF,
  [aux_sym_preproc_if_token2] = aux_sym_preproc_if_token2,
  [aux_sym_preproc_ifdef_token1] = aux_sym_preproc_ifdef_token1,
  [aux_sym_preproc_ifdef_token2] = aux_sym_preproc_ifdef_token2,
  [aux_sym_preproc_else_token1] = aux_sym_preproc_else_token1,
  [aux_sym_preproc_elif_token1] = aux_sym_preproc_elif_token1,
  [aux_sym_preproc_elifdef_token1] = aux_sym_preproc_elifdef_token1,
  [aux_sym_preproc_elifdef_token2] = aux_sym_preproc_elifdef_token2,
  [sym_preproc_arg] = sym_preproc_arg,
  [sym_preproc_directive] = sym_preproc_directive,
  [anon_sym_LPAREN2] = anon_sym_LPAREN,
  [anon_sym_defined] = anon_sym_defined,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym___extension__] = anon_sym___extension__,
  [anon_sym_typedef] = anon_sym_typedef,
  [anon_sym_extern] = anon_sym_extern,
  [anon_sym___attribute__] = anon_sym___attribute__,
  [anon_sym___attribute] = anon_sym___attribute,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_LBRACK_LBRACK] = anon_sym_LBRACK_LBRACK,
  [anon_sym_RBRACK_RBRACK] = anon_sym_RBRACK_RBRACK,
  [anon_sym___declspec] = anon_sym___declspec,
  [anon_sym___based] = anon_sym___based,
  [anon_sym___cdecl] = anon_sym___cdecl,
  [anon_sym___clrcall] = anon_sym___clrcall,
  [anon_sym___stdcall] = anon_sym___stdcall,
  [anon_sym___fastcall] = anon_sym___fastcall,
  [anon_sym___thiscall] = anon_sym___thiscall,
  [anon_sym___vectorcall] = anon_sym___vectorcall,
  [sym_ms_restrict_modifier] = sym_ms_restrict_modifier,
  [sym_ms_unsigned_ptr_modifier] = sym_ms_unsigned_ptr_modifier,
  [sym_ms_signed_ptr_modifier] = sym_ms_signed_ptr_modifier,
  [anon_sym__unaligned] = anon_sym__unaligned,
  [anon_sym___unaligned] = anon_sym___unaligned,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_signed] = anon_sym_signed,
  [anon_sym_unsigned] = anon_sym_unsigned,
  [anon_sym_long] = anon_sym_long,
  [anon_sym_short] = anon_sym_short,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_static] = anon_sym_static,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_auto] = anon_sym_auto,
  [anon_sym_register] = anon_sym_register,
  [anon_sym_inline] = anon_sym_inline,
  [anon_sym___inline] = anon_sym___inline,
  [anon_sym___inline__] = anon_sym___inline__,
  [anon_sym___forceinline] = anon_sym___forceinline,
  [anon_sym_thread_local] = anon_sym_thread_local,
  [anon_sym___thread] = anon_sym___thread,
  [anon_sym_const] = anon_sym_const,
  [anon_sym_constexpr] = anon_sym_constexpr,
  [anon_sym_volatile] = anon_sym_volatile,
  [anon_sym_restrict] = anon_sym_restrict,
  [anon_sym___restrict__] = anon_sym___restrict__,
  [anon_sym__Atomic] = anon_sym__Atomic,
  [anon_sym__Noreturn] = anon_sym__Noreturn,
  [anon_sym_noreturn] = anon_sym_noreturn,
  [anon_sym__Nonnull] = anon_sym__Nonnull,
  [anon_sym_alignas] = anon_sym_alignas,
  [anon_sym__Alignas] = anon_sym__Alignas,
  [sym_primitive_type] = sym_primitive_type,
  [anon_sym_enum] = anon_sym_enum,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_struct] = anon_sym_struct,
  [anon_sym_union] = anon_sym_union,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_default] = anon_sym_default,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_goto] = anon_sym_goto,
  [anon_sym___try] = anon_sym___try,
  [anon_sym___except] = anon_sym___except,
  [anon_sym___finally] = anon_sym___finally,
  [anon_sym___leave] = anon_sym___leave,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_DASH_DASH] = anon_sym_DASH_DASH,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_sizeof] = anon_sym_sizeof,
  [anon_sym___alignof__] = anon_sym___alignof__,
  [anon_sym___alignof] = anon_sym___alignof,
  [anon_sym__alignof] = anon_sym__alignof,
  [anon_sym_alignof] = anon_sym_alignof,
  [anon_sym__Alignof] = anon_sym__Alignof,
  [anon_sym_offsetof] = anon_sym_offsetof,
  [anon_sym__Generic] = anon_sym__Generic,
  [anon_sym_asm] = anon_sym_asm,
  [anon_sym___asm__] = anon_sym___asm__,
  [anon_sym___asm] = anon_sym___asm,
  [anon_sym___volatile__] = anon_sym___volatile__,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [sym_number_literal] = sym_number_literal,
  [anon_sym_L_SQUOTE] = anon_sym_L_SQUOTE,
  [anon_sym_u_SQUOTE] = anon_sym_u_SQUOTE,
  [anon_sym_U_SQUOTE] = anon_sym_U_SQUOTE,
  [anon_sym_u8_SQUOTE] = anon_sym_u8_SQUOTE,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [aux_sym_char_literal_token1] = aux_sym_char_literal_token1,
  [anon_sym_L_DQUOTE] = anon_sym_L_DQUOTE,
  [anon_sym_u_DQUOTE] = anon_sym_u_DQUOTE,
  [anon_sym_U_DQUOTE] = anon_sym_U_DQUOTE,
  [anon_sym_u8_DQUOTE] = anon_sym_u8_DQUOTE,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_string_literal_token1] = aux_sym_string_literal_token1,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_system_lib_string] = sym_system_lib_string,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [anon_sym_NULL] = anon_sym_NULL,
  [anon_sym_nullptr] = anon_sym_nullptr,
  [sym_comment] = sym_comment,
  [sym_translation_unit] = sym_translation_unit,
  [sym__top_level_item] = sym__top_level_item,
  [sym__block_item] = sym__block_item,
  [sym_preproc_include] = sym_preproc_include,
  [sym_preproc_def] = sym_preproc_def,
  [sym_preproc_function_def] = sym_preproc_function_def,
  [sym_preproc_params] = sym_preproc_params,
  [sym_preproc_call] = sym_preproc_call,
  [sym_preproc_if] = sym_preproc_if,
  [sym_preproc_ifdef] = sym_preproc_ifdef,
  [sym_preproc_else] = sym_preproc_else,
  [sym_preproc_elif] = sym_preproc_elif,
  [sym_preproc_elifdef] = sym_preproc_elifdef,
  [sym_preproc_if_in_field_declaration_list] = sym_preproc_if,
  [sym_preproc_ifdef_in_field_declaration_list] = sym_preproc_ifdef,
  [sym_preproc_else_in_field_declaration_list] = sym_preproc_else,
  [sym_preproc_elif_in_field_declaration_list] = sym_preproc_elif,
  [sym_preproc_elifdef_in_field_declaration_list] = sym_preproc_elifdef,
  [sym_preproc_if_in_enumerator_list] = sym_preproc_if,
  [sym_preproc_ifdef_in_enumerator_list] = sym_preproc_ifdef,
  [sym_preproc_else_in_enumerator_list] = sym_preproc_else,
  [sym_preproc_elif_in_enumerator_list] = sym_preproc_elif,
  [sym_preproc_elifdef_in_enumerator_list] = sym_preproc_elifdef,
  [sym_preproc_if_in_enumerator_list_no_comma] = sym_preproc_if,
  [sym_preproc_ifdef_in_enumerator_list_no_comma] = sym_preproc_ifdef,
  [sym_preproc_else_in_enumerator_list_no_comma] = sym_preproc_else,
  [sym_preproc_elif_in_enumerator_list_no_comma] = sym_preproc_elif,
  [sym_preproc_elifdef_in_enumerator_list_no_comma] = sym_preproc_elifdef,
  [sym__preproc_expression] = sym__preproc_expression,
  [sym_preproc_parenthesized_expression] = sym_parenthesized_expression,
  [sym_preproc_defined] = sym_preproc_defined,
  [sym_preproc_unary_expression] = sym_unary_expression,
  [sym_preproc_call_expression] = sym_call_expression,
  [sym_preproc_argument_list] = sym_argument_list,
  [sym_preproc_binary_expression] = sym_binary_expression,
  [sym_function_definition] = sym_function_definition,
  [sym__old_style_function_definition] = sym_function_definition,
  [sym_declaration] = sym_declaration,
  [sym_type_definition] = sym_type_definition,
  [sym__type_definition_type] = sym__type_definition_type,
  [sym__type_definition_declarators] = sym__type_definition_declarators,
  [sym__declaration_modifiers] = sym__declaration_modifiers,
  [sym__declaration_specifiers] = sym__declaration_specifiers,
  [sym_linkage_specification] = sym_linkage_specification,
  [sym_attribute_specifier] = sym_attribute_specifier,
  [sym_attribute] = sym_attribute,
  [sym_attribute_declaration] = sym_attribute_declaration,
  [sym_ms_declspec_modifier] = sym_ms_declspec_modifier,
  [sym_ms_based_modifier] = sym_ms_based_modifier,
  [sym_ms_call_modifier] = sym_ms_call_modifier,
  [sym_ms_unaligned_ptr_modifier] = sym_ms_unaligned_ptr_modifier,
  [sym_ms_pointer_modifier] = sym_ms_pointer_modifier,
  [sym_declaration_list] = sym_declaration_list,
  [sym__declarator] = sym__declarator,
  [sym__declaration_declarator] = sym__declaration_declarator,
  [sym__field_declarator] = sym__field_declarator,
  [sym__type_declarator] = sym__type_declarator,
  [sym__abstract_declarator] = sym__abstract_declarator,
  [sym_parenthesized_declarator] = sym_parenthesized_declarator,
  [sym_parenthesized_field_declarator] = sym_parenthesized_declarator,
  [sym_parenthesized_type_declarator] = sym_parenthesized_declarator,
  [sym_abstract_parenthesized_declarator] = sym_abstract_parenthesized_declarator,
  [sym_attributed_declarator] = sym_attributed_declarator,
  [sym_attributed_field_declarator] = sym_attributed_declarator,
  [sym_attributed_type_declarator] = sym_attributed_declarator,
  [sym_pointer_declarator] = sym_pointer_declarator,
  [sym_pointer_field_declarator] = sym_pointer_declarator,
  [sym_pointer_type_declarator] = sym_pointer_declarator,
  [sym_abstract_pointer_declarator] = sym_abstract_pointer_declarator,
  [sym_function_declarator] = sym_function_declarator,
  [sym__function_declaration_declarator] = sym_function_declarator,
  [sym_function_field_declarator] = sym_function_declarator,
  [sym_function_type_declarator] = sym_function_declarator,
  [sym_abstract_function_declarator] = sym_abstract_function_declarator,
  [sym__old_style_function_declarator] = sym_function_declarator,
  [sym_array_declarator] = sym_array_declarator,
  [sym_array_field_declarator] = sym_array_declarator,
  [sym_array_type_declarator] = sym_array_declarator,
  [sym_abstract_array_declarator] = sym_abstract_array_declarator,
  [sym_init_declarator] = sym_init_declarator,
  [sym_compound_statement] = sym_compound_statement,
  [sym_storage_class_specifier] = sym_storage_class_specifier,
  [sym_type_qualifier] = sym_type_qualifier,
  [sym_alignas_qualifier] = sym_alignas_qualifier,
  [sym_type_specifier] = sym_type_specifier,
  [sym_sized_type_specifier] = sym_sized_type_specifier,
  [sym_enum_specifier] = sym_enum_specifier,
  [sym_enumerator_list] = sym_enumerator_list,
  [sym_struct_specifier] = sym_struct_specifier,
  [sym_union_specifier] = sym_union_specifier,
  [sym_field_declaration_list] = sym_field_declaration_list,
  [sym__field_declaration_list_item] = sym__field_declaration_list_item,
  [sym_field_declaration] = sym_field_declaration,
  [sym__field_declaration_declarator] = sym__field_declaration_declarator,
  [sym_bitfield_clause] = sym_bitfield_clause,
  [sym_enumerator] = sym_enumerator,
  [sym_variadic_parameter] = sym_variadic_parameter,
  [sym_parameter_list] = sym_parameter_list,
  [sym__old_style_parameter_list] = sym_parameter_list,
  [sym_parameter_declaration] = sym_parameter_declaration,
  [sym_attributed_statement] = sym_attributed_statement,
  [sym_statement] = sym_statement,
  [sym__top_level_statement] = sym__top_level_statement,
  [sym_labeled_statement] = sym_labeled_statement,
  [sym__top_level_expression_statement] = sym_expression_statement,
  [sym_expression_statement] = sym_expression_statement,
  [sym_if_statement] = sym_if_statement,
  [sym_else_clause] = sym_else_clause,
  [sym_switch_statement] = sym_switch_statement,
  [sym_case_statement] = sym_case_statement,
  [sym_while_statement] = sym_while_statement,
  [sym_do_statement] = sym_do_statement,
  [sym_for_statement] = sym_for_statement,
  [sym__for_statement_body] = sym__for_statement_body,
  [sym_return_statement] = sym_return_statement,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_goto_statement] = sym_goto_statement,
  [sym_seh_try_statement] = sym_seh_try_statement,
  [sym_seh_except_clause] = sym_seh_except_clause,
  [sym_seh_finally_clause] = sym_seh_finally_clause,
  [sym_seh_leave_statement] = sym_seh_leave_statement,
  [sym_expression] = sym_expression,
  [sym__string] = sym__string,
  [sym_comma_expression] = sym_comma_expression,
  [sym_conditional_expression] = sym_conditional_expression,
  [sym_assignment_expression] = sym_assignment_expression,
  [sym_pointer_expression] = sym_pointer_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_update_expression] = sym_update_expression,
  [sym_cast_expression] = sym_cast_expression,
  [sym_type_descriptor] = sym_type_descriptor,
  [sym_sizeof_expression] = sym_sizeof_expression,
  [sym_alignof_expression] = sym_alignof_expression,
  [sym_offsetof_expression] = sym_offsetof_expression,
  [sym_generic_expression] = sym_generic_expression,
  [sym_subscript_expression] = sym_subscript_expression,
  [sym_call_expression] = sym_call_expression,
  [sym_gnu_asm_expression] = sym_gnu_asm_expression,
  [sym_gnu_asm_qualifier] = sym_gnu_asm_qualifier,
  [sym_gnu_asm_output_operand_list] = sym_gnu_asm_output_operand_list,
  [sym_gnu_asm_output_operand] = sym_gnu_asm_output_operand,
  [sym_gnu_asm_input_operand_list] = sym_gnu_asm_input_operand_list,
  [sym_gnu_asm_input_operand] = sym_gnu_asm_input_operand,
  [sym_gnu_asm_clobber_list] = sym_gnu_asm_clobber_list,
  [sym_gnu_asm_goto_list] = sym_gnu_asm_goto_list,
  [sym_extension_expression] = sym_extension_expression,
  [sym_argument_list] = sym_argument_list,
  [sym_field_expression] = sym_field_expression,
  [sym_compound_literal_expression] = sym_compound_literal_expression,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_initializer_list] = sym_initializer_list,
  [sym_initializer_pair] = sym_initializer_pair,
  [sym_subscript_designator] = sym_subscript_designator,
  [sym_subscript_range_designator] = sym_subscript_range_designator,
  [sym_field_designator] = sym_field_designator,
  [sym_char_literal] = sym_char_literal,
  [sym_concatenated_string] = sym_concatenated_string,
  [sym_string_literal] = sym_string_literal,
  [sym_null] = sym_null,
  [sym__empty_declaration] = sym__empty_declaration,
  [sym_macro_type_specifier] = sym_macro_type_specifier,
  [aux_sym_translation_unit_repeat1] = aux_sym_translation_unit_repeat1,
  [aux_sym_preproc_params_repeat1] = aux_sym_preproc_params_repeat1,
  [aux_sym_preproc_if_repeat1] = aux_sym_preproc_if_repeat1,
  [aux_sym_preproc_if_in_field_declaration_list_repeat1] = aux_sym_preproc_if_in_field_declaration_list_repeat1,
  [aux_sym_preproc_if_in_enumerator_list_repeat1] = aux_sym_preproc_if_in_enumerator_list_repeat1,
  [aux_sym_preproc_if_in_enumerator_list_no_comma_repeat1] = aux_sym_preproc_if_in_enumerator_list_no_comma_repeat1,
  [aux_sym_preproc_argument_list_repeat1] = aux_sym_preproc_argument_list_repeat1,
  [aux_sym__old_style_function_definition_repeat1] = aux_sym__old_style_function_definition_repeat1,
  [aux_sym_declaration_repeat1] = aux_sym_declaration_repeat1,
  [aux_sym_type_definition_repeat1] = aux_sym_type_definition_repeat1,
  [aux_sym__type_definition_type_repeat1] = aux_sym__type_definition_type_repeat1,
  [aux_sym__type_definition_declarators_repeat1] = aux_sym__type_definition_declarators_repeat1,
  [aux_sym__declaration_specifiers_repeat1] = aux_sym__declaration_specifiers_repeat1,
  [aux_sym_attribute_declaration_repeat1] = aux_sym_attribute_declaration_repeat1,
  [aux_sym_attributed_declarator_repeat1] = aux_sym_attributed_declarator_repeat1,
  [aux_sym_pointer_declarator_repeat1] = aux_sym_pointer_declarator_repeat1,
  [aux_sym_function_declarator_repeat1] = aux_sym_function_declarator_repeat1,
  [aux_sym_array_declarator_repeat1] = aux_sym_array_declarator_repeat1,
  [aux_sym_sized_type_specifier_repeat1] = aux_sym_sized_type_specifier_repeat1,
  [aux_sym_enumerator_list_repeat1] = aux_sym_enumerator_list_repeat1,
  [aux_sym__field_declaration_declarator_repeat1] = aux_sym__field_declaration_declarator_repeat1,
  [aux_sym_parameter_list_repeat1] = aux_sym_parameter_list_repeat1,
  [aux_sym__old_style_parameter_list_repeat1] = aux_sym__old_style_parameter_list_repeat1,
  [aux_sym_case_statement_repeat1] = aux_sym_case_statement_repeat1,
  [aux_sym_generic_expression_repeat1] = aux_sym_generic_expression_repeat1,
  [aux_sym_gnu_asm_expression_repeat1] = aux_sym_gnu_asm_expression_repeat1,
  [aux_sym_gnu_asm_output_operand_list_repeat1] = aux_sym_gnu_asm_output_operand_list_repeat1,
  [aux_sym_gnu_asm_input_operand_list_repeat1] = aux_sym_gnu_asm_input_operand_list_repeat1,
  [aux_sym_gnu_asm_clobber_list_repeat1] = aux_sym_gnu_asm_clobber_list_repeat1,
  [aux_sym_gnu_asm_goto_list_repeat1] = aux_sym_gnu_asm_goto_list_repeat1,
  [aux_sym_argument_list_repeat1] = aux_sym_argument_list_repeat1,
  [aux_sym_initializer_list_repeat1] = aux_sym_initializer_list_repeat1,
  [aux_sym_initializer_pair_repeat1] = aux_sym_initializer_pair_repeat1,
  [aux_sym_char_literal_repeat1] = aux_sym_char_literal_repeat1,
  [aux_sym_concatenated_string_repeat1] = aux_sym_concatenated_string_repeat1,
  [aux_sym_string_literal_repeat1] = aux_sym_string_literal_repeat1,
  [alias_sym_field_identifier] = alias_sym_field_identifier,
  [alias_sym_statement_identifier] = alias_sym_statement_identifier,
  [alias_sym_type_identifier] = alias_sym_type_identifier,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_preproc_include_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_include_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_preproc_def_token1] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_if_token1] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LF] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_if_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_ifdef_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_ifdef_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_else_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_elif_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_elifdef_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_elifdef_token2] = {
    .visible = true,
    .named = false,
  },
  [sym_preproc_arg] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_directive] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LPAREN2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_defined] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___extension__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_typedef] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extern] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___attribute__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___attribute] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___declspec] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___based] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___cdecl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___clrcall] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___stdcall] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___fastcall] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___thiscall] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___vectorcall] = {
    .visible = true,
    .named = false,
  },
  [sym_ms_restrict_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_ms_unsigned_ptr_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_ms_signed_ptr_modifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym__unaligned] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___unaligned] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_signed] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unsigned] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_long] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_short] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_static] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_auto] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_register] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_inline] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___inline] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___inline__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___forceinline] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_thread_local] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___thread] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_constexpr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_volatile] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_restrict] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___restrict__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__Atomic] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__Noreturn] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_noreturn] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__Nonnull] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_alignas] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__Alignas] = {
    .visible = true,
    .named = false,
  },
  [sym_primitive_type] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_enum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_struct] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_union] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_default] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_goto] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___except] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___finally] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___leave] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sizeof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___alignof__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___alignof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__alignof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_alignof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__Alignof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_offsetof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__Generic] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_asm] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___asm__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___asm] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___volatile__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [sym_number_literal] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_L_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_U_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u8_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_char_literal_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_L_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_U_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u8_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_literal_token1] = {
    .visible = true,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_system_lib_string] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_NULL] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_nullptr] = {
    .visible = true,
    .named = false,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_translation_unit] = {
    .visible = true,
    .named = true,
  },
  [sym__top_level_item] = {
    .visible = false,
    .named = true,
  },
  [sym__block_item] = {
    .visible = false,
    .named = true,
  },
  [sym_preproc_include] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_def] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_function_def] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_params] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_call] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_if] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_ifdef] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_else] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_elif] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_elifdef] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_if_in_field_declaration_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_ifdef_in_field_declaration_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_else_in_field_declaration_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_elif_in_field_declaration_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_elifdef_in_field_declaration_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_if_in_enumerator_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_ifdef_in_enumerator_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_else_in_enumerator_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_elif_in_enumerator_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_elifdef_in_enumerator_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_if_in_enumerator_list_no_comma] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_ifdef_in_enumerator_list_no_comma] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_else_in_enumerator_list_no_comma] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_elif_in_enumerator_list_no_comma] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_elifdef_in_enumerator_list_no_comma] = {
    .visible = true,
    .named = true,
  },
  [sym__preproc_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_preproc_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_defined] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym__old_style_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_type_definition] = {
    .visible = true,
    .named = true,
  },
  [sym__type_definition_type] = {
    .visible = false,
    .named = true,
  },
  [sym__type_definition_declarators] = {
    .visible = false,
    .named = true,
  },
  [sym__declaration_modifiers] = {
    .visible = false,
    .named = true,
  },
  [sym__declaration_specifiers] = {
    .visible = false,
    .named = true,
  },
  [sym_linkage_specification] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_ms_declspec_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_ms_based_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_ms_call_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_ms_unaligned_ptr_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_ms_pointer_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_declaration_list] = {
    .visible = true,
    .named = true,
  },
  [sym__declarator] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym__declaration_declarator] = {
    .visible = false,
    .named = true,
  },
  [sym__field_declarator] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym__type_declarator] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym__abstract_declarator] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_parenthesized_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_field_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_type_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_abstract_parenthesized_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_attributed_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_attributed_field_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_attributed_type_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_pointer_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_pointer_field_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_pointer_type_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_abstract_pointer_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_function_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym__function_declaration_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_function_field_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_function_type_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_abstract_function_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym__old_style_function_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_array_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_array_field_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_array_type_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_abstract_array_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_init_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_compound_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_storage_class_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_type_qualifier] = {
    .visible = true,
    .named = true,
  },
  [sym_alignas_qualifier] = {
    .visible = true,
    .named = true,
  },
  [sym_type_specifier] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_sized_type_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_enumerator_list] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_union_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_field_declaration_list] = {
    .visible = true,
    .named = true,
  },
  [sym__field_declaration_list_item] = {
    .visible = false,
    .named = true,
  },
  [sym_field_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__field_declaration_declarator] = {
    .visible = false,
    .named = true,
  },
  [sym_bitfield_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_enumerator] = {
    .visible = true,
    .named = true,
  },
  [sym_variadic_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter_list] = {
    .visible = true,
    .named = true,
  },
  [sym__old_style_parameter_list] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_attributed_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_statement] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym__top_level_statement] = {
    .visible = false,
    .named = true,
  },
  [sym_labeled_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__top_level_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_case_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_do_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__for_statement_body] = {
    .visible = false,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_goto_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_seh_try_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_seh_except_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_seh_finally_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_seh_leave_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym__string] = {
    .visible = false,
    .named = true,
  },
  [sym_comma_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_conditional_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_pointer_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_update_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_cast_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_type_descriptor] = {
    .visible = true,
    .named = true,
  },
  [sym_sizeof_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_alignof_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_offsetof_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_generic_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_gnu_asm_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_gnu_asm_qualifier] = {
    .visible = true,
    .named = true,
  },
  [sym_gnu_asm_output_operand_list] = {
    .visible = true,
    .named = true,
  },
  [sym_gnu_asm_output_operand] = {
    .visible = true,
    .named = true,
  },
  [sym_gnu_asm_input_operand_list] = {
    .visible = true,
    .named = true,
  },
  [sym_gnu_asm_input_operand] = {
    .visible = true,
    .named = true,
  },
  [sym_gnu_asm_clobber_list] = {
    .visible = true,
    .named = true,
  },
  [sym_gnu_asm_goto_list] = {
    .visible = true,
    .named = true,
  },
  [sym_extension_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_field_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_compound_literal_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_initializer_list] = {
    .visible = true,
    .named = true,
  },
  [sym_initializer_pair] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript_designator] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript_range_designator] = {
    .visible = true,
    .named = true,
  },
  [sym_field_designator] = {
    .visible = true,
    .named = true,
  },
  [sym_char_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_concatenated_string] = {
    .visible = true,
    .named = true,
  },
  [sym_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_null] = {
    .visible = true,
    .named = true,
  },
  [sym__empty_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_macro_type_specifier] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_translation_unit_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_preproc_params_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_preproc_if_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_preproc_if_in_field_declaration_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_preproc_if_in_enumerator_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_preproc_if_in_enumerator_list_no_comma_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_preproc_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__old_style_function_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__type_definition_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__type_definition_declarators_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__declaration_specifiers_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_attribute_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_attributed_declarator_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pointer_declarator_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_declarator_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_declarator_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_sized_type_specifier_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enumerator_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__field_declaration_declarator_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parameter_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__old_style_parameter_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_generic_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_gnu_asm_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_gnu_asm_output_operand_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_gnu_asm_input_operand_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_gnu_asm_clobber_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_gnu_asm_goto_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_initializer_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_initializer_pair_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_char_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_concatenated_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_field_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_statement_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_type_identifier] = {
    .visible = true,
    .named = true,
  },
};

enum ts_field_identifiers {
  field_alternative = 1,
  field_argument = 2,
  field_arguments = 3,
  field_assembly_code = 4,
  field_body = 5,
  field_clobbers = 6,
  field_condition = 7,
  field_consequence = 8,
  field_constraint = 9,
  field_declarator = 10,
  field_designator = 11,
  field_directive = 12,
  field_end = 13,
  field_field = 14,
  field_filter = 15,
  field_function = 16,
  field_goto_labels = 17,
  field_index = 18,
  field_initializer = 19,
  field_input_operands = 20,
  field_label = 21,
  field_left = 22,
  field_member = 23,
  field_name = 24,
  field_operand = 25,
  field_operator = 26,
  field_output_operands = 27,
  field_parameters = 28,
  field_path = 29,
  field_prefix = 30,
  field_register = 31,
  field_right = 32,
  field_size = 33,
  field_start = 34,
  field_symbol = 35,
  field_type = 36,
  field_underlying_type = 37,
  field_update = 38,
  field_value = 39,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alternative] = "alternative",
  [field_argument] = "argument",
  [field_arguments] = "arguments",
  [field_assembly_code] = "assembly_code",
  [field_body] = "body",
  [field_clobbers] = "clobbers",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_constraint] = "constraint",
  [field_declarator] = "declarator",
  [field_designator] = "designator",
  [field_directive] = "directive",
  [field_end] = "end",
  [field_field] = "field",
  [field_filter] = "filter",
  [field_function] = "function",
  [field_goto_labels] = "goto_labels",
  [field_index] = "index",
  [field_initializer] = "initializer",
  [field_input_operands] = "input_operands",
  [field_label] = "label",
  [field_left] = "left",
  [field_member] = "member",
  [field_name] = "name",
  [field_operand] = "operand",
  [field_operator] = "operator",
  [field_output_operands] = "output_operands",
  [field_parameters] = "parameters",
  [field_path] = "path",
  [field_prefix] = "prefix",
  [field_register] = "register",
  [field_right] = "right",
  [field_size] = "size",
  [field_start] = "start",
  [field_symbol] = "symbol",
  [field_type] = "type",
  [field_underlying_type] = "underlying_type",
  [field_update] = "update",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [2] = {.index = 0, .length = 3},
  [3] = {.index = 3, .length = 1},
  [4] = {.index = 4, .length = 1},
  [5] = {.index = 5, .length = 2},
  [6] = {.index = 7, .length = 1},
  [7] = {.index = 8, .length = 1},
  [8] = {.index = 9, .length = 1},
  [9] = {.index = 10, .length = 1},
  [10] = {.index = 3, .length = 1},
  [11] = {.index = 11, .length = 2},
  [12] = {.index = 13, .length = 2},
  [13] = {.index = 15, .length = 2},
  [14] = {.index = 17, .length = 1},
  [15] = {.index = 17, .length = 1},
  [16] = {.index = 18, .length = 1},
  [17] = {.index = 8, .length = 1},
  [18] = {.index = 19, .length = 2},
  [19] = {.index = 21, .length = 2},
  [20] = {.index = 23, .length = 1},
  [22] = {.index = 24, .length = 1},
  [23] = {.index = 25, .length = 2},
  [24] = {.index = 27, .length = 2},
  [25] = {.index = 29, .length = 1},
  [26] = {.index = 30, .length = 1},
  [27] = {.index = 31, .length = 2},
  [28] = {.index = 33, .length = 2},
  [29] = {.index = 35, .length = 1},
  [30] = {.index = 36, .length = 3},
  [31] = {.index = 39, .length = 1},
  [32] = {.index = 40, .length = 1},
  [33] = {.index = 41, .length = 3},
  [34] = {.index = 44, .length = 2},
  [35] = {.index = 46, .length = 2},
  [36] = {.index = 48, .length = 5},
  [37] = {.index = 53, .length = 3},
  [38] = {.index = 56, .length = 1},
  [39] = {.index = 56, .length = 1},
  [40] = {.index = 57, .length = 2},
  [41] = {.index = 59, .length = 2},
  [42] = {.index = 61, .length = 1},
  [43] = {.index = 62, .length = 2},
  [44] = {.index = 64, .length = 1},
  [45] = {.index = 65, .length = 2},
  [46] = {.index = 67, .length = 2},
  [47] = {.index = 69, .length = 2},
  [48] = {.index = 71, .length = 2},
  [49] = {.index = 73, .length = 2},
  [50] = {.index = 75, .length = 2},
  [51] = {.index = 77, .length = 2},
  [52] = {.index = 79, .length = 2},
  [54] = {.index = 81, .length = 2},
  [55] = {.index = 83, .length = 1},
  [56] = {.index = 84, .length = 1},
  [57] = {.index = 85, .length = 3},
  [58] = {.index = 88, .length = 1},
  [59] = {.index = 89, .length = 1},
  [60] = {.index = 90, .length = 2},
  [61] = {.index = 92, .length = 1},
  [62] = {.index = 93, .length = 3},
  [63] = {.index = 96, .length = 3},
  [64] = {.index = 99, .length = 2},
  [65] = {.index = 101, .length = 3},
  [66] = {.index = 104, .length = 2},
  [67] = {.index = 106, .length = 5},
  [68] = {.index = 111, .length = 3},
  [69] = {.index = 114, .length = 5},
  [70] = {.index = 119, .length = 2},
  [71] = {.index = 121, .length = 2},
  [72] = {.index = 123, .length = 3},
  [73] = {.index = 126, .length = 2},
  [74] = {.index = 128, .length = 2},
  [75] = {.index = 130, .length = 1},
  [76] = {.index = 131, .length = 2},
  [77] = {.index = 133, .length = 2},
  [78] = {.index = 135, .length = 2},
  [79] = {.index = 137, .length = 3},
  [80] = {.index = 140, .length = 2},
  [81] = {.index = 142, .length = 2},
  [82] = {.index = 144, .length = 2},
  [83] = {.index = 146, .length = 1},
  [84] = {.index = 147, .length = 2},
  [85] = {.index = 149, .length = 2},
  [86] = {.index = 151, .length = 4},
  [87] = {.index = 155, .length = 1},
  [88] = {.index = 156, .length = 2},
  [89] = {.index = 158, .length = 1},
  [90] = {.index = 159, .length = 1},
  [91] = {.index = 160, .length = 4},
  [92] = {.index = 164, .length = 4},
  [93] = {.index = 168, .length = 2},
  [94] = {.index = 170, .length = 2},
  [95] = {.index = 172, .length = 3},
  [96] = {.index = 175, .length = 5},
  [97] = {.index = 180, .length = 3},
  [98] = {.index = 183, .length = 2},
  [99] = {.index = 185, .length = 1},
  [101] = {.index = 186, .length = 2},
  [102] = {.index = 188, .length = 2},
  [103] = {.index = 190, .length = 2},
  [104] = {.index = 192, .length = 3},
  [105] = {.index = 195, .length = 2},
  [106] = {.index = 197, .length = 2},
  [107] = {.index = 199, .length = 2},
  [108] = {.index = 201, .length = 2},
  [109] = {.index = 203, .length = 3},
  [110] = {.index = 206, .length = 2},
  [111] = {.index = 208, .length = 1},
  [112] = {.index = 209, .length = 5},
  [113] = {.index = 214, .length = 2},
  [114] = {.index = 216, .length = 3},
  [115] = {.index = 219, .length = 2},
  [116] = {.index = 219, .length = 2},
  [117] = {.index = 221, .length = 3},
  [118] = {.index = 224, .length = 2},
  [119] = {.index = 226, .length = 1},
  [120] = {.index = 227, .length = 4},
  [121] = {.index = 231, .length = 3},
  [122] = {.index = 234, .length = 2},
  [123] = {.index = 236, .length = 2},
  [124] = {.index = 35, .length = 1},
  [125] = {.index = 238, .length = 5},
  [126] = {.index = 243, .length = 4},
  [127] = {.index = 247, .length = 2},
  [128] = {.index = 249, .length = 2},
  [129] = {.index = 251, .length = 2},
  [130] = {.index = 253, .length = 5},
  [131] = {.index = 258, .length = 2},
  [132] = {.index = 260, .length = 3},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_body, 0, .inherited = true},
    {field_declarator, 0, .inherited = true},
    {field_type, 0, .inherited = true},
  [3] =
    {field_type, 0},
  [4] =
    {field_directive, 0},
  [5] =
    {field_argument, 1},
    {field_operator, 0},
  [7] =
    {field_name, 0},
  [8] =
    {field_name, 1},
  [9] =
    {field_body, 1},
  [10] =
    {field_value, 1},
  [11] =
    {field_declarator, 0, .inherited = true},
    {field_parameters, 0, .inherited = true},
  [13] =
    {field_argument, 0},
    {field_operator, 1},
  [15] =
    {field_arguments, 1},
    {field_function, 0},
  [17] =
    {field_type, 1},
  [18] =
    {field_path, 1},
  [19] =
    {field_argument, 1},
    {field_directive, 0},
  [21] =
    {field_declarator, 1},
    {field_type, 0},
  [23] =
    {field_parameters, 0},
  [24] =
    {field_declarator, 0},
  [25] =
    {field_body, 2},
    {field_value, 1},
  [27] =
    {field_body, 2},
    {field_name, 1},
  [29] =
    {field_name, 2},
  [30] =
    {field_body, 2},
  [31] =
    {field_condition, 1},
    {field_consequence, 2},
  [33] =
    {field_body, 2},
    {field_condition, 1},
  [35] =
    {field_label, 1},
  [36] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [39] =
    {field_label, 0},
  [40] =
    {field_declarator, 1},
  [41] =
    {field_body, 2},
    {field_declarator, 1},
    {field_type, 0, .inherited = true},
  [44] =
    {field_declarator, 0},
    {field_parameters, 1},
  [46] =
    {field_declarator, 1},
    {field_type, 0, .inherited = true},
  [48] =
    {field_body, 2},
    {field_declarator, 1},
    {field_declarator, 1, .inherited = true},
    {field_parameters, 1, .inherited = true},
    {field_type, 0, .inherited = true},
  [53] =
    {field_argument, 0},
    {field_field, 2},
    {field_operator, 1},
  [56] =
    {field_type, 2},
  [57] =
    {field_name, 1},
    {field_value, 2},
  [59] =
    {field_name, 1},
    {field_parameters, 2},
  [61] =
    {field_condition, 1},
  [62] =
    {field_alternative, 2},
    {field_name, 1},
  [64] =
    {field_type, 0, .inherited = true},
  [65] =
    {field_declarator, 2},
    {field_type, 0},
  [67] =
    {field_left, 0},
    {field_right, 2},
  [69] =
    {field_type, 1},
    {field_value, 3},
  [71] =
    {field_declarator, 2},
    {field_type, 1},
  [73] =
    {field_declarator, 2, .inherited = true},
    {field_type, 1, .inherited = true},
  [75] =
    {field_declarator, 0},
    {field_declarator, 1, .inherited = true},
  [77] =
    {field_name, 2},
    {field_prefix, 0},
  [79] =
    {field_name, 1},
    {field_underlying_type, 3},
  [81] =
    {field_body, 3},
    {field_name, 2},
  [83] =
    {field_name, 3},
  [84] =
    {field_body, 3},
  [85] =
    {field_alternative, 3},
    {field_condition, 1},
    {field_consequence, 2},
  [88] =
    {field_initializer, 0},
  [89] =
    {field_assembly_code, 2},
  [90] =
    {field_name, 0},
    {field_type, 2},
  [92] =
    {field_declarator, 2},
  [93] =
    {field_body, 3},
    {field_declarator, 2},
    {field_type, 0, .inherited = true},
  [96] =
    {field_declarator, 1},
    {field_declarator, 2},
    {field_type, 0, .inherited = true},
  [99] =
    {field_declarator, 0},
    {field_value, 2},
  [101] =
    {field_declarator, 1},
    {field_declarator, 2, .inherited = true},
    {field_type, 0, .inherited = true},
  [104] =
    {field_declarator, 0, .inherited = true},
    {field_declarator, 1, .inherited = true},
  [106] =
    {field_body, 3},
    {field_declarator, 1},
    {field_declarator, 1, .inherited = true},
    {field_parameters, 1, .inherited = true},
    {field_type, 0, .inherited = true},
  [111] =
    {field_body, 3},
    {field_declarator, 2},
    {field_type, 1, .inherited = true},
  [114] =
    {field_body, 3},
    {field_declarator, 2},
    {field_declarator, 2, .inherited = true},
    {field_parameters, 2, .inherited = true},
    {field_type, 1, .inherited = true},
  [119] =
    {field_argument, 0},
    {field_index, 2},
  [121] =
    {field_alternative, 3},
    {field_condition, 0},
  [123] =
    {field_name, 1},
    {field_parameters, 2},
    {field_value, 3},
  [126] =
    {field_alternative, 3},
    {field_condition, 1},
  [128] =
    {field_alternative, 3},
    {field_name, 1},
  [130] =
    {field_size, 1},
  [131] =
    {field_declarator, 3},
    {field_type, 1},
  [133] =
    {field_declarator, 3, .inherited = true},
    {field_type, 2, .inherited = true},
  [135] =
    {field_name, 0},
    {field_value, 2},
  [137] =
    {field_body, 4},
    {field_name, 1},
    {field_underlying_type, 3},
  [140] =
    {field_declarator, 1, .inherited = true},
    {field_type, 0, .inherited = true},
  [142] =
    {field_body, 4},
    {field_name, 3},
  [144] =
    {field_body, 1},
    {field_condition, 3},
  [146] =
    {field_update, 2},
  [147] =
    {field_initializer, 0},
    {field_update, 2},
  [149] =
    {field_condition, 1},
    {field_initializer, 0},
  [151] =
    {field_body, 4},
    {field_condition, 2, .inherited = true},
    {field_initializer, 2, .inherited = true},
    {field_update, 2, .inherited = true},
  [155] =
    {field_operand, 1},
  [156] =
    {field_assembly_code, 2},
    {field_output_operands, 3},
  [158] =
    {field_assembly_code, 3},
  [159] =
    {field_declarator, 3},
  [160] =
    {field_declarator, 1},
    {field_declarator, 2},
    {field_declarator, 3},
    {field_type, 0, .inherited = true},
  [164] =
    {field_declarator, 1},
    {field_declarator, 2},
    {field_declarator, 3, .inherited = true},
    {field_type, 0, .inherited = true},
  [168] =
    {field_declarator, 0},
    {field_size, 2},
  [170] =
    {field_declarator, 1},
    {field_declarator, 2},
  [172] =
    {field_body, 4},
    {field_declarator, 3},
    {field_type, 1, .inherited = true},
  [175] =
    {field_body, 4},
    {field_declarator, 2},
    {field_declarator, 2, .inherited = true},
    {field_parameters, 2, .inherited = true},
    {field_type, 1, .inherited = true},
  [180] =
    {field_alternative, 4},
    {field_condition, 0},
    {field_consequence, 2},
  [183] =
    {field_alternative, 4},
    {field_condition, 1},
  [185] =
    {field_size, 2},
  [186] =
    {field_body, 2},
    {field_filter, 1},
  [188] =
    {field_declarator, 0},
    {field_declarator, 2, .inherited = true},
  [190] =
    {field_condition, 1},
    {field_update, 3},
  [192] =
    {field_condition, 1},
    {field_initializer, 0},
    {field_update, 3},
  [195] =
    {field_initializer, 0},
    {field_update, 3},
  [197] =
    {field_condition, 2},
    {field_initializer, 0},
  [199] =
    {field_member, 4},
    {field_type, 2},
  [201] =
    {field_operand, 1},
    {field_operand, 2, .inherited = true},
  [203] =
    {field_assembly_code, 2},
    {field_input_operands, 4},
    {field_output_operands, 3},
  [206] =
    {field_assembly_code, 3},
    {field_output_operands, 4},
  [208] =
    {field_declarator, 4},
  [209] =
    {field_declarator, 1},
    {field_declarator, 2},
    {field_declarator, 3},
    {field_declarator, 4, .inherited = true},
    {field_type, 0, .inherited = true},
  [214] =
    {field_declarator, 0},
    {field_size, 3},
  [216] =
    {field_declarator, 1},
    {field_declarator, 2},
    {field_declarator, 3},
  [219] =
    {field_designator, 0},
    {field_value, 2},
  [221] =
    {field_condition, 2},
    {field_initializer, 0},
    {field_update, 4},
  [224] =
    {field_operand, 0, .inherited = true},
    {field_operand, 1, .inherited = true},
  [226] =
    {field_register, 1},
  [227] =
    {field_assembly_code, 2},
    {field_clobbers, 5},
    {field_input_operands, 4},
    {field_output_operands, 3},
  [231] =
    {field_assembly_code, 3},
    {field_input_operands, 5},
    {field_output_operands, 4},
  [234] =
    {field_constraint, 0},
    {field_value, 2},
  [236] =
    {field_register, 1},
    {field_register, 2, .inherited = true},
  [238] =
    {field_assembly_code, 2},
    {field_clobbers, 5},
    {field_goto_labels, 6},
    {field_input_operands, 4},
    {field_output_operands, 3},
  [243] =
    {field_assembly_code, 3},
    {field_clobbers, 6},
    {field_input_operands, 5},
    {field_output_operands, 4},
  [247] =
    {field_end, 3},
    {field_start, 1},
  [249] =
    {field_register, 0, .inherited = true},
    {field_register, 1, .inherited = true},
  [251] =
    {field_label, 1},
    {field_label, 2, .inherited = true},
  [253] =
    {field_assembly_code, 3},
    {field_clobbers, 6},
    {field_goto_labels, 7},
    {field_input_operands, 5},
    {field_output_operands, 4},
  [258] =
    {field_label, 0, .inherited = true},
    {field_label, 1, .inherited = true},
  [260] =
    {field_constraint, 3},
    {field_symbol, 1},
    {field_value, 5},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = alias_sym_type_identifier,
  },
  [7] = {
    [1] = alias_sym_type_identifier,
  },
  [10] = {
    [0] = alias_sym_type_identifier,
  },
  [15] = {
    [1] = alias_sym_type_identifier,
  },
  [21] = {
    [0] = sym_primitive_type,
  },
  [24] = {
    [1] = alias_sym_type_identifier,
  },
  [25] = {
    [2] = alias_sym_type_identifier,
  },
  [29] = {
    [1] = alias_sym_statement_identifier,
  },
  [31] = {
    [0] = alias_sym_statement_identifier,
  },
  [37] = {
    [2] = alias_sym_field_identifier,
  },
  [39] = {
    [2] = alias_sym_type_identifier,
  },
  [52] = {
    [1] = alias_sym_type_identifier,
  },
  [53] = {
    [0] = alias_sym_field_identifier,
  },
  [54] = {
    [2] = alias_sym_type_identifier,
  },
  [55] = {
    [3] = alias_sym_type_identifier,
  },
  [79] = {
    [1] = alias_sym_type_identifier,
  },
  [81] = {
    [3] = alias_sym_type_identifier,
  },
  [100] = {
    [1] = alias_sym_field_identifier,
  },
  [107] = {
    [4] = alias_sym_field_identifier,
  },
  [115] = {
    [0] = alias_sym_field_identifier,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 8,
  [9] = 9,
  [10] = 2,
  [11] = 4,
  [12] = 3,
  [13] = 5,
  [14] = 2,
  [15] = 4,
  [16] = 3,
  [17] = 5,
  [18] = 2,
  [19] = 4,
  [20] = 3,
  [21] = 5,
  [22] = 22,
  [23] = 23,
  [24] = 22,
  [25] = 23,
  [26] = 26,
  [27] = 27,
  [28] = 27,
  [29] = 29,
  [30] = 30,
  [31] = 27,
  [32] = 29,
  [33] = 23,
  [34] = 30,
  [35] = 35,
  [36] = 30,
  [37] = 30,
  [38] = 29,
  [39] = 23,
  [40] = 22,
  [41] = 27,
  [42] = 29,
  [43] = 43,
  [44] = 44,
  [45] = 45,
  [46] = 46,
  [47] = 47,
  [48] = 48,
  [49] = 49,
  [50] = 48,
  [51] = 46,
  [52] = 46,
  [53] = 47,
  [54] = 45,
  [55] = 48,
  [56] = 49,
  [57] = 45,
  [58] = 46,
  [59] = 48,
  [60] = 47,
  [61] = 49,
  [62] = 45,
  [63] = 47,
  [64] = 49,
  [65] = 65,
  [66] = 65,
  [67] = 46,
  [68] = 65,
  [69] = 45,
  [70] = 48,
  [71] = 47,
  [72] = 49,
  [73] = 65,
  [74] = 65,
  [75] = 75,
  [76] = 75,
  [77] = 75,
  [78] = 75,
  [79] = 75,
  [80] = 80,
  [81] = 81,
  [82] = 82,
  [83] = 83,
  [84] = 84,
  [85] = 85,
  [86] = 86,
  [87] = 87,
  [88] = 88,
  [89] = 89,
  [90] = 90,
  [91] = 91,
  [92] = 92,
  [93] = 93,
  [94] = 94,
  [95] = 95,
  [96] = 96,
  [97] = 97,
  [98] = 98,
  [99] = 99,
  [100] = 100,
  [101] = 101,
  [102] = 102,
  [103] = 103,
  [104] = 104,
  [105] = 105,
  [106] = 106,
  [107] = 107,
  [108] = 108,
  [109] = 109,
  [110] = 110,
  [111] = 111,
  [112] = 112,
  [113] = 113,
  [114] = 114,
  [115] = 109,
  [116] = 116,
  [117] = 106,
  [118] = 118,
  [119] = 119,
  [120] = 120,
  [121] = 121,
  [122] = 122,
  [123] = 123,
  [124] = 124,
  [125] = 125,
  [126] = 126,
  [127] = 127,
  [128] = 128,
  [129] = 129,
  [130] = 130,
  [131] = 131,
  [132] = 132,
  [133] = 133,
  [134] = 134,
  [135] = 135,
  [136] = 136,
  [137] = 137,
  [138] = 138,
  [139] = 139,
  [140] = 140,
  [141] = 141,
  [142] = 142,
  [143] = 143,
  [144] = 144,
  [145] = 145,
  [146] = 146,
  [147] = 147,
  [148] = 80,
  [149] = 80,
  [150] = 80,
  [151] = 91,
  [152] = 101,
  [153] = 102,
  [154] = 103,
  [155] = 104,
  [156] = 105,
  [157] = 109,
  [158] = 98,
  [159] = 110,
  [160] = 99,
  [161] = 111,
  [162] = 100,
  [163] = 111,
  [164] = 112,
  [165] = 113,
  [166] = 101,
  [167] = 114,
  [168] = 118,
  [169] = 108,
  [170] = 106,
  [171] = 102,
  [172] = 97,
  [173] = 116,
  [174] = 103,
  [175] = 118,
  [176] = 104,
  [177] = 82,
  [178] = 107,
  [179] = 109,
  [180] = 110,
  [181] = 108,
  [182] = 111,
  [183] = 112,
  [184] = 113,
  [185] = 114,
  [186] = 118,
  [187] = 108,
  [188] = 106,
  [189] = 83,
  [190] = 116,
  [191] = 84,
  [192] = 85,
  [193] = 82,
  [194] = 83,
  [195] = 84,
  [196] = 85,
  [197] = 88,
  [198] = 89,
  [199] = 90,
  [200] = 86,
  [201] = 87,
  [202] = 95,
  [203] = 96,
  [204] = 81,
  [205] = 97,
  [206] = 98,
  [207] = 81,
  [208] = 103,
  [209] = 104,
  [210] = 86,
  [211] = 87,
  [212] = 91,
  [213] = 92,
  [214] = 93,
  [215] = 94,
  [216] = 100,
  [217] = 101,
  [218] = 102,
  [219] = 105,
  [220] = 116,
  [221] = 88,
  [222] = 89,
  [223] = 90,
  [224] = 82,
  [225] = 83,
  [226] = 84,
  [227] = 85,
  [228] = 86,
  [229] = 105,
  [230] = 107,
  [231] = 91,
  [232] = 92,
  [233] = 93,
  [234] = 94,
  [235] = 87,
  [236] = 113,
  [237] = 95,
  [238] = 96,
  [239] = 81,
  [240] = 88,
  [241] = 114,
  [242] = 89,
  [243] = 90,
  [244] = 97,
  [245] = 112,
  [246] = 96,
  [247] = 92,
  [248] = 93,
  [249] = 94,
  [250] = 110,
  [251] = 107,
  [252] = 98,
  [253] = 99,
  [254] = 100,
  [255] = 95,
  [256] = 99,
  [257] = 145,
  [258] = 141,
  [259] = 142,
  [260] = 144,
  [261] = 145,
  [262] = 143,
  [263] = 146,
  [264] = 137,
  [265] = 147,
  [266] = 121,
  [267] = 122,
  [268] = 126,
  [269] = 128,
  [270] = 138,
  [271] = 129,
  [272] = 119,
  [273] = 273,
  [274] = 120,
  [275] = 127,
  [276] = 130,
  [277] = 132,
  [278] = 133,
  [279] = 134,
  [280] = 135,
  [281] = 136,
  [282] = 140,
  [283] = 123,
  [284] = 124,
  [285] = 131,
  [286] = 129,
  [287] = 119,
  [288] = 139,
  [289] = 141,
  [290] = 144,
  [291] = 143,
  [292] = 146,
  [293] = 137,
  [294] = 122,
  [295] = 126,
  [296] = 128,
  [297] = 138,
  [298] = 120,
  [299] = 127,
  [300] = 130,
  [301] = 132,
  [302] = 134,
  [303] = 135,
  [304] = 136,
  [305] = 140,
  [306] = 123,
  [307] = 124,
  [308] = 125,
  [309] = 131,
  [310] = 142,
  [311] = 145,
  [312] = 147,
  [313] = 121,
  [314] = 133,
  [315] = 131,
  [316] = 139,
  [317] = 125,
  [318] = 273,
  [319] = 319,
  [320] = 146,
  [321] = 137,
  [322] = 322,
  [323] = 123,
  [324] = 124,
  [325] = 125,
  [326] = 143,
  [327] = 327,
  [328] = 328,
  [329] = 147,
  [330] = 121,
  [331] = 331,
  [332] = 122,
  [333] = 333,
  [334] = 334,
  [335] = 126,
  [336] = 128,
  [337] = 138,
  [338] = 338,
  [339] = 327,
  [340] = 340,
  [341] = 322,
  [342] = 120,
  [343] = 127,
  [344] = 130,
  [345] = 132,
  [346] = 133,
  [347] = 134,
  [348] = 135,
  [349] = 349,
  [350] = 328,
  [351] = 334,
  [352] = 333,
  [353] = 327,
  [354] = 322,
  [355] = 334,
  [356] = 333,
  [357] = 139,
  [358] = 327,
  [359] = 322,
  [360] = 136,
  [361] = 349,
  [362] = 362,
  [363] = 328,
  [364] = 334,
  [365] = 333,
  [366] = 333,
  [367] = 141,
  [368] = 328,
  [369] = 142,
  [370] = 327,
  [371] = 322,
  [372] = 334,
  [373] = 349,
  [374] = 144,
  [375] = 349,
  [376] = 331,
  [377] = 140,
  [378] = 349,
  [379] = 331,
  [380] = 331,
  [381] = 328,
  [382] = 382,
  [383] = 382,
  [384] = 382,
  [385] = 382,
  [386] = 386,
  [387] = 387,
  [388] = 388,
  [389] = 387,
  [390] = 273,
  [391] = 386,
  [392] = 386,
  [393] = 387,
  [394] = 386,
  [395] = 387,
  [396] = 386,
  [397] = 387,
  [398] = 387,
  [399] = 386,
  [400] = 400,
  [401] = 400,
  [402] = 402,
  [403] = 403,
  [404] = 273,
  [405] = 273,
  [406] = 80,
  [407] = 407,
  [408] = 408,
  [409] = 408,
  [410] = 408,
  [411] = 408,
  [412] = 408,
  [413] = 408,
  [414] = 408,
  [415] = 408,
  [416] = 416,
  [417] = 273,
  [418] = 418,
  [419] = 419,
  [420] = 420,
  [421] = 421,
  [422] = 422,
  [423] = 423,
  [424] = 424,
  [425] = 425,
  [426] = 426,
  [427] = 427,
  [428] = 428,
  [429] = 429,
  [430] = 388,
  [431] = 431,
  [432] = 432,
  [433] = 433,
  [434] = 434,
  [435] = 435,
  [436] = 436,
  [437] = 432,
  [438] = 438,
  [439] = 436,
  [440] = 434,
  [441] = 441,
  [442] = 432,
  [443] = 438,
  [444] = 436,
  [445] = 434,
  [446] = 438,
  [447] = 447,
  [448] = 448,
  [449] = 449,
  [450] = 450,
  [451] = 451,
  [452] = 452,
  [453] = 453,
  [454] = 454,
  [455] = 455,
  [456] = 452,
  [457] = 452,
  [458] = 458,
  [459] = 459,
  [460] = 460,
  [461] = 460,
  [462] = 459,
  [463] = 463,
  [464] = 464,
  [465] = 465,
  [466] = 466,
  [467] = 467,
  [468] = 468,
  [469] = 466,
  [470] = 466,
  [471] = 464,
  [472] = 472,
  [473] = 473,
  [474] = 474,
  [475] = 475,
  [476] = 476,
  [477] = 477,
  [478] = 476,
  [479] = 466,
  [480] = 464,
  [481] = 476,
  [482] = 466,
  [483] = 464,
  [484] = 476,
  [485] = 485,
  [486] = 486,
  [487] = 487,
  [488] = 466,
  [489] = 476,
  [490] = 476,
  [491] = 491,
  [492] = 492,
  [493] = 493,
  [494] = 494,
  [495] = 495,
  [496] = 496,
  [497] = 497,
  [498] = 498,
  [499] = 497,
  [500] = 500,
  [501] = 501,
  [502] = 502,
  [503] = 497,
  [504] = 504,
  [505] = 505,
  [506] = 497,
  [507] = 507,
  [508] = 508,
  [509] = 509,
  [510] = 510,
  [511] = 511,
  [512] = 512,
  [513] = 513,
  [514] = 514,
  [515] = 508,
  [516] = 510,
  [517] = 517,
  [518] = 518,
  [519] = 519,
  [520] = 512,
  [521] = 521,
  [522] = 514,
  [523] = 513,
  [524] = 518,
  [525] = 519,
  [526] = 526,
  [527] = 527,
  [528] = 528,
  [529] = 529,
  [530] = 509,
  [531] = 531,
  [532] = 532,
  [533] = 531,
  [534] = 534,
  [535] = 531,
  [536] = 510,
  [537] = 513,
  [538] = 518,
  [539] = 539,
  [540] = 540,
  [541] = 508,
  [542] = 542,
  [543] = 543,
  [544] = 526,
  [545] = 545,
  [546] = 546,
  [547] = 547,
  [548] = 519,
  [549] = 545,
  [550] = 416,
  [551] = 526,
  [552] = 547,
  [553] = 527,
  [554] = 514,
  [555] = 528,
  [556] = 529,
  [557] = 557,
  [558] = 513,
  [559] = 510,
  [560] = 543,
  [561] = 545,
  [562] = 546,
  [563] = 527,
  [564] = 547,
  [565] = 529,
  [566] = 566,
  [567] = 567,
  [568] = 509,
  [569] = 528,
  [570] = 514,
  [571] = 513,
  [572] = 532,
  [573] = 509,
  [574] = 518,
  [575] = 543,
  [576] = 566,
  [577] = 514,
  [578] = 513,
  [579] = 518,
  [580] = 519,
  [581] = 526,
  [582] = 527,
  [583] = 528,
  [584] = 529,
  [585] = 509,
  [586] = 531,
  [587] = 587,
  [588] = 531,
  [589] = 510,
  [590] = 508,
  [591] = 514,
  [592] = 518,
  [593] = 519,
  [594] = 526,
  [595] = 527,
  [596] = 528,
  [597] = 529,
  [598] = 509,
  [599] = 531,
  [600] = 510,
  [601] = 508,
  [602] = 543,
  [603] = 545,
  [604] = 546,
  [605] = 547,
  [606] = 529,
  [607] = 545,
  [608] = 546,
  [609] = 532,
  [610] = 519,
  [611] = 546,
  [612] = 612,
  [613] = 532,
  [614] = 547,
  [615] = 532,
  [616] = 543,
  [617] = 587,
  [618] = 545,
  [619] = 546,
  [620] = 547,
  [621] = 526,
  [622] = 527,
  [623] = 528,
  [624] = 508,
  [625] = 543,
  [626] = 566,
  [627] = 587,
  [628] = 628,
  [629] = 629,
  [630] = 630,
  [631] = 631,
  [632] = 632,
  [633] = 633,
  [634] = 634,
  [635] = 635,
  [636] = 636,
  [637] = 637,
  [638] = 638,
  [639] = 639,
  [640] = 640,
  [641] = 641,
  [642] = 642,
  [643] = 643,
  [644] = 644,
  [645] = 645,
  [646] = 646,
  [647] = 647,
  [648] = 648,
  [649] = 649,
  [650] = 647,
  [651] = 651,
  [652] = 649,
  [653] = 649,
  [654] = 647,
  [655] = 648,
  [656] = 651,
  [657] = 647,
  [658] = 649,
  [659] = 648,
  [660] = 651,
  [661] = 651,
  [662] = 648,
  [663] = 663,
  [664] = 664,
  [665] = 665,
  [666] = 666,
  [667] = 667,
  [668] = 402,
  [669] = 669,
  [670] = 403,
  [671] = 669,
  [672] = 672,
  [673] = 673,
  [674] = 674,
  [675] = 675,
  [676] = 676,
  [677] = 677,
  [678] = 678,
  [679] = 679,
  [680] = 680,
  [681] = 681,
  [682] = 682,
  [683] = 675,
  [684] = 684,
  [685] = 685,
  [686] = 686,
  [687] = 687,
  [688] = 688,
  [689] = 689,
  [690] = 690,
  [691] = 674,
  [692] = 692,
  [693] = 693,
  [694] = 674,
  [695] = 675,
  [696] = 675,
  [697] = 674,
  [698] = 698,
  [699] = 699,
  [700] = 700,
  [701] = 701,
  [702] = 702,
  [703] = 703,
  [704] = 704,
  [705] = 705,
  [706] = 706,
  [707] = 707,
  [708] = 708,
  [709] = 709,
  [710] = 710,
  [711] = 711,
  [712] = 712,
  [713] = 713,
  [714] = 673,
  [715] = 715,
  [716] = 699,
  [717] = 717,
  [718] = 631,
  [719] = 631,
  [720] = 703,
  [721] = 721,
  [722] = 722,
  [723] = 723,
  [724] = 724,
  [725] = 725,
  [726] = 402,
  [727] = 727,
  [728] = 728,
  [729] = 729,
  [730] = 403,
  [731] = 731,
  [732] = 732,
  [733] = 733,
  [734] = 734,
  [735] = 735,
  [736] = 736,
  [737] = 737,
  [738] = 738,
  [739] = 739,
  [740] = 740,
  [741] = 741,
  [742] = 742,
  [743] = 743,
  [744] = 744,
  [745] = 745,
  [746] = 746,
  [747] = 747,
  [748] = 748,
  [749] = 749,
  [750] = 750,
  [751] = 751,
  [752] = 752,
  [753] = 753,
  [754] = 754,
  [755] = 755,
  [756] = 756,
  [757] = 757,
  [758] = 758,
  [759] = 759,
  [760] = 760,
  [761] = 761,
  [762] = 762,
  [763] = 763,
  [764] = 764,
  [765] = 765,
  [766] = 766,
  [767] = 767,
  [768] = 768,
  [769] = 769,
  [770] = 770,
  [771] = 771,
  [772] = 772,
  [773] = 773,
  [774] = 774,
  [775] = 775,
  [776] = 776,
  [777] = 777,
  [778] = 778,
  [779] = 779,
  [780] = 780,
  [781] = 781,
  [782] = 782,
  [783] = 783,
  [784] = 784,
  [785] = 785,
  [786] = 786,
  [787] = 787,
  [788] = 788,
  [789] = 789,
  [790] = 790,
  [791] = 791,
  [792] = 788,
  [793] = 793,
  [794] = 794,
  [795] = 795,
  [796] = 788,
  [797] = 797,
  [798] = 793,
  [799] = 788,
  [800] = 793,
  [801] = 801,
  [802] = 131,
  [803] = 142,
  [804] = 788,
  [805] = 145,
  [806] = 147,
  [807] = 121,
  [808] = 133,
  [809] = 809,
  [810] = 810,
  [811] = 811,
  [812] = 793,
  [813] = 813,
  [814] = 814,
  [815] = 815,
  [816] = 816,
  [817] = 817,
  [818] = 818,
  [819] = 819,
  [820] = 820,
  [821] = 821,
  [822] = 822,
  [823] = 823,
  [824] = 821,
  [825] = 825,
  [826] = 826,
  [827] = 827,
  [828] = 827,
  [829] = 815,
  [830] = 816,
  [831] = 820,
  [832] = 813,
  [833] = 817,
  [834] = 834,
  [835] = 819,
  [836] = 826,
  [837] = 825,
  [838] = 834,
  [839] = 839,
  [840] = 631,
  [841] = 823,
  [842] = 839,
  [843] = 682,
  [844] = 844,
  [845] = 682,
  [846] = 642,
  [847] = 797,
  [848] = 783,
  [849] = 638,
  [850] = 850,
  [851] = 147,
  [852] = 121,
  [853] = 853,
  [854] = 810,
  [855] = 811,
  [856] = 784,
  [857] = 133,
  [858] = 809,
  [859] = 131,
  [860] = 786,
  [861] = 795,
  [862] = 794,
  [863] = 131,
  [864] = 787,
  [865] = 142,
  [866] = 145,
  [867] = 795,
  [868] = 850,
  [869] = 850,
  [870] = 809,
  [871] = 121,
  [872] = 785,
  [873] = 786,
  [874] = 133,
  [875] = 785,
  [876] = 876,
  [877] = 810,
  [878] = 850,
  [879] = 879,
  [880] = 787,
  [881] = 789,
  [882] = 811,
  [883] = 790,
  [884] = 791,
  [885] = 794,
  [886] = 142,
  [887] = 789,
  [888] = 784,
  [889] = 145,
  [890] = 790,
  [891] = 791,
  [892] = 147,
  [893] = 893,
  [894] = 894,
  [895] = 702,
  [896] = 700,
  [897] = 897,
  [898] = 823,
  [899] = 821,
  [900] = 825,
  [901] = 826,
  [902] = 839,
  [903] = 827,
  [904] = 815,
  [905] = 816,
  [906] = 820,
  [907] = 813,
  [908] = 908,
  [909] = 817,
  [910] = 834,
  [911] = 819,
  [912] = 708,
  [913] = 707,
  [914] = 704,
  [915] = 705,
  [916] = 916,
  [917] = 917,
  [918] = 86,
  [919] = 94,
  [920] = 100,
  [921] = 101,
  [922] = 102,
  [923] = 923,
  [924] = 105,
  [925] = 706,
  [926] = 87,
  [927] = 709,
  [928] = 91,
  [929] = 92,
  [930] = 93,
  [931] = 701,
  [932] = 682,
  [933] = 933,
  [934] = 934,
  [935] = 935,
  [936] = 936,
  [937] = 92,
  [938] = 93,
  [939] = 94,
  [940] = 940,
  [941] = 100,
  [942] = 101,
  [943] = 102,
  [944] = 105,
  [945] = 945,
  [946] = 946,
  [947] = 87,
  [948] = 91,
  [949] = 86,
  [950] = 950,
  [951] = 951,
  [952] = 952,
  [953] = 934,
  [954] = 954,
  [955] = 955,
  [956] = 956,
  [957] = 936,
  [958] = 955,
  [959] = 959,
  [960] = 960,
  [961] = 961,
  [962] = 962,
  [963] = 954,
  [964] = 956,
  [965] = 965,
  [966] = 960,
  [967] = 816,
  [968] = 968,
  [969] = 819,
  [970] = 823,
  [971] = 821,
  [972] = 825,
  [973] = 826,
  [974] = 839,
  [975] = 827,
  [976] = 815,
  [977] = 816,
  [978] = 820,
  [979] = 813,
  [980] = 817,
  [981] = 834,
  [982] = 834,
  [983] = 821,
  [984] = 825,
  [985] = 826,
  [986] = 839,
  [987] = 819,
  [988] = 827,
  [989] = 815,
  [990] = 823,
  [991] = 820,
  [992] = 813,
  [993] = 817,
  [994] = 994,
  [995] = 994,
  [996] = 996,
  [997] = 997,
  [998] = 998,
  [999] = 999,
  [1000] = 1000,
  [1001] = 1001,
  [1002] = 1002,
  [1003] = 1003,
  [1004] = 1004,
  [1005] = 1005,
  [1006] = 994,
  [1007] = 1007,
  [1008] = 1001,
  [1009] = 1001,
  [1010] = 994,
  [1011] = 1001,
  [1012] = 1012,
  [1013] = 1013,
  [1014] = 1014,
  [1015] = 1014,
  [1016] = 1016,
  [1017] = 1017,
  [1018] = 1018,
  [1019] = 1019,
  [1020] = 818,
  [1021] = 1021,
  [1022] = 844,
  [1023] = 1023,
  [1024] = 1024,
  [1025] = 1025,
  [1026] = 1024,
  [1027] = 1027,
  [1028] = 1028,
  [1029] = 823,
  [1030] = 821,
  [1031] = 825,
  [1032] = 826,
  [1033] = 839,
  [1034] = 827,
  [1035] = 815,
  [1036] = 816,
  [1037] = 820,
  [1038] = 813,
  [1039] = 1039,
  [1040] = 817,
  [1041] = 1039,
  [1042] = 834,
  [1043] = 1043,
  [1044] = 879,
  [1045] = 1045,
  [1046] = 1046,
  [1047] = 1047,
  [1048] = 1048,
  [1049] = 1049,
  [1050] = 1050,
  [1051] = 1051,
  [1052] = 1049,
  [1053] = 1053,
  [1054] = 1054,
  [1055] = 1050,
  [1056] = 1050,
  [1057] = 1057,
  [1058] = 1058,
  [1059] = 1059,
  [1060] = 819,
  [1061] = 1061,
  [1062] = 876,
  [1063] = 722,
  [1064] = 1064,
  [1065] = 1039,
  [1066] = 1066,
  [1067] = 968,
  [1068] = 1068,
  [1069] = 853,
  [1070] = 1039,
  [1071] = 1049,
  [1072] = 1053,
  [1073] = 1039,
  [1074] = 1049,
  [1075] = 1050,
  [1076] = 713,
  [1077] = 1077,
  [1078] = 1039,
  [1079] = 1079,
  [1080] = 1080,
  [1081] = 1081,
  [1082] = 1082,
  [1083] = 1079,
  [1084] = 1084,
  [1085] = 1085,
  [1086] = 1086,
  [1087] = 1087,
  [1088] = 1088,
  [1089] = 1089,
  [1090] = 1079,
  [1091] = 1091,
  [1092] = 1092,
  [1093] = 1093,
  [1094] = 1094,
  [1095] = 1095,
  [1096] = 1096,
  [1097] = 1079,
  [1098] = 1098,
  [1099] = 1099,
  [1100] = 1100,
  [1101] = 1101,
  [1102] = 1102,
  [1103] = 1103,
  [1104] = 1104,
  [1105] = 1105,
  [1106] = 1106,
  [1107] = 1105,
  [1108] = 1079,
  [1109] = 1109,
  [1110] = 1110,
  [1111] = 1111,
  [1112] = 1112,
  [1113] = 1111,
  [1114] = 1114,
  [1115] = 1114,
  [1116] = 1116,
  [1117] = 1112,
  [1118] = 1118,
  [1119] = 1119,
  [1120] = 713,
  [1121] = 749,
  [1122] = 722,
  [1123] = 1123,
  [1124] = 1124,
  [1125] = 1125,
  [1126] = 1126,
  [1127] = 1127,
  [1128] = 1128,
  [1129] = 768,
  [1130] = 750,
  [1131] = 751,
  [1132] = 752,
  [1133] = 753,
  [1134] = 754,
  [1135] = 747,
  [1136] = 1136,
  [1137] = 1136,
  [1138] = 1136,
  [1139] = 1136,
  [1140] = 770,
  [1141] = 771,
  [1142] = 755,
  [1143] = 749,
  [1144] = 766,
  [1145] = 1145,
  [1146] = 745,
  [1147] = 756,
  [1148] = 1148,
  [1149] = 1149,
  [1150] = 1150,
  [1151] = 1150,
  [1152] = 1149,
  [1153] = 1148,
  [1154] = 1149,
  [1155] = 818,
  [1156] = 1156,
  [1157] = 1150,
  [1158] = 1149,
  [1159] = 1149,
  [1160] = 1149,
  [1161] = 1161,
  [1162] = 1148,
  [1163] = 1161,
  [1164] = 1161,
  [1165] = 1148,
  [1166] = 1145,
  [1167] = 1167,
  [1168] = 684,
  [1169] = 1169,
  [1170] = 1170,
  [1171] = 1171,
  [1172] = 1172,
  [1173] = 1173,
  [1174] = 1174,
  [1175] = 1175,
  [1176] = 1176,
  [1177] = 1177,
  [1178] = 1178,
  [1179] = 1179,
  [1180] = 1180,
  [1181] = 1181,
  [1182] = 1182,
  [1183] = 1183,
  [1184] = 1184,
  [1185] = 1185,
  [1186] = 1186,
  [1187] = 1187,
  [1188] = 1186,
  [1189] = 1189,
  [1190] = 1190,
  [1191] = 1177,
  [1192] = 1192,
  [1193] = 1193,
  [1194] = 1194,
  [1195] = 1192,
  [1196] = 1183,
  [1197] = 1197,
  [1198] = 1198,
  [1199] = 1199,
  [1200] = 1200,
  [1201] = 1167,
  [1202] = 1202,
  [1203] = 1173,
  [1204] = 1200,
  [1205] = 1205,
  [1206] = 1194,
  [1207] = 1197,
  [1208] = 1208,
  [1209] = 1198,
  [1210] = 1200,
  [1211] = 1194,
  [1212] = 1208,
  [1213] = 1213,
  [1214] = 1214,
  [1215] = 1215,
  [1216] = 1170,
  [1217] = 1181,
  [1218] = 1218,
  [1219] = 1214,
  [1220] = 1220,
  [1221] = 1194,
  [1222] = 1222,
  [1223] = 1169,
  [1224] = 1171,
  [1225] = 1178,
  [1226] = 1182,
  [1227] = 1184,
  [1228] = 1187,
  [1229] = 1189,
  [1230] = 1202,
  [1231] = 1205,
  [1232] = 1232,
  [1233] = 1222,
  [1234] = 1218,
  [1235] = 1235,
  [1236] = 1176,
  [1237] = 1237,
  [1238] = 1220,
  [1239] = 1239,
  [1240] = 1012,
  [1241] = 1241,
  [1242] = 1242,
  [1243] = 684,
  [1244] = 1004,
  [1245] = 1190,
  [1246] = 1246,
  [1247] = 1000,
  [1248] = 1237,
  [1249] = 999,
  [1250] = 1250,
  [1251] = 1251,
  [1252] = 1246,
  [1253] = 1253,
  [1254] = 1237,
  [1255] = 1246,
  [1256] = 1213,
  [1257] = 1253,
  [1258] = 1237,
  [1259] = 1246,
  [1260] = 1253,
  [1261] = 1261,
  [1262] = 1261,
  [1263] = 1263,
  [1264] = 1264,
  [1265] = 1265,
  [1266] = 1266,
  [1267] = 1261,
  [1268] = 1268,
  [1269] = 1261,
  [1270] = 1270,
  [1271] = 1271,
  [1272] = 1272,
  [1273] = 1273,
  [1274] = 1274,
  [1275] = 1275,
  [1276] = 1274,
  [1277] = 1274,
  [1278] = 1274,
  [1279] = 1271,
  [1280] = 1271,
  [1281] = 1281,
  [1282] = 1271,
  [1283] = 1283,
  [1284] = 1283,
  [1285] = 1285,
  [1286] = 1283,
  [1287] = 1287,
  [1288] = 1288,
  [1289] = 1289,
  [1290] = 1290,
  [1291] = 1291,
  [1292] = 1292,
  [1293] = 1293,
  [1294] = 1294,
  [1295] = 1295,
  [1296] = 1263,
  [1297] = 1297,
  [1298] = 1298,
  [1299] = 1299,
  [1300] = 1300,
  [1301] = 1301,
  [1302] = 1302,
  [1303] = 1303,
  [1304] = 1304,
  [1305] = 1305,
  [1306] = 1306,
  [1307] = 1307,
  [1308] = 1308,
  [1309] = 1309,
  [1310] = 1306,
  [1311] = 1311,
  [1312] = 1307,
  [1313] = 1313,
  [1314] = 1314,
  [1315] = 1315,
  [1316] = 1306,
  [1317] = 1317,
  [1318] = 1307,
  [1319] = 1306,
  [1320] = 1307,
  [1321] = 1321,
  [1322] = 1307,
  [1323] = 1307,
  [1324] = 1324,
  [1325] = 1325,
  [1326] = 1326,
  [1327] = 1327,
  [1328] = 1328,
  [1329] = 1329,
  [1330] = 1330,
  [1331] = 1331,
  [1332] = 1332,
  [1333] = 1273,
  [1334] = 1334,
  [1335] = 1335,
  [1336] = 1336,
  [1337] = 1337,
  [1338] = 1338,
  [1339] = 1281,
  [1340] = 1340,
  [1341] = 1341,
  [1342] = 1342,
  [1343] = 1343,
  [1344] = 1344,
  [1345] = 1345,
  [1346] = 1346,
  [1347] = 1347,
  [1348] = 1348,
  [1349] = 1349,
  [1350] = 1350,
  [1351] = 1275,
  [1352] = 1352,
  [1353] = 1353,
  [1354] = 1349,
  [1355] = 1349,
  [1356] = 1356,
  [1357] = 1357,
  [1358] = 1349,
  [1359] = 1359,
  [1360] = 1360,
  [1361] = 1361,
  [1362] = 1362,
  [1363] = 1363,
  [1364] = 1364,
  [1365] = 1365,
  [1366] = 1366,
  [1367] = 1367,
  [1368] = 1302,
  [1369] = 1299,
  [1370] = 1301,
  [1371] = 1300,
  [1372] = 1372,
  [1373] = 1365,
  [1374] = 1365,
  [1375] = 1375,
  [1376] = 1365,
  [1377] = 1377,
  [1378] = 1378,
  [1379] = 1379,
  [1380] = 1380,
  [1381] = 1381,
  [1382] = 1382,
  [1383] = 1383,
  [1384] = 1384,
  [1385] = 1385,
  [1386] = 1386,
  [1387] = 1379,
  [1388] = 1388,
  [1389] = 1389,
  [1390] = 1379,
  [1391] = 1391,
  [1392] = 1392,
  [1393] = 1381,
  [1394] = 1378,
  [1395] = 1395,
  [1396] = 1396,
  [1397] = 1397,
  [1398] = 1379,
  [1399] = 1399,
  [1400] = 1381,
  [1401] = 1381,
  [1402] = 1378,
  [1403] = 1403,
  [1404] = 1378,
  [1405] = 1405,
  [1406] = 1406,
  [1407] = 1407,
  [1408] = 1408,
  [1409] = 1409,
  [1410] = 1410,
  [1411] = 1407,
  [1412] = 1408,
  [1413] = 1413,
  [1414] = 1414,
  [1415] = 1415,
  [1416] = 1408,
  [1417] = 1417,
  [1418] = 1418,
  [1419] = 1419,
  [1420] = 1420,
  [1421] = 1421,
  [1422] = 1406,
  [1423] = 1423,
  [1424] = 1424,
  [1425] = 1407,
  [1426] = 1426,
  [1427] = 1427,
  [1428] = 1407,
  [1429] = 1429,
  [1430] = 1430,
  [1431] = 1431,
  [1432] = 1432,
  [1433] = 1406,
  [1434] = 1406,
  [1435] = 1408,
  [1436] = 1436,
  [1437] = 1437,
  [1438] = 1438,
  [1439] = 1439,
  [1440] = 1440,
  [1441] = 1441,
  [1442] = 1442,
  [1443] = 1443,
  [1444] = 1444,
  [1445] = 1445,
  [1446] = 1445,
  [1447] = 1447,
  [1448] = 1440,
  [1449] = 1449,
  [1450] = 1450,
  [1451] = 1451,
  [1452] = 1452,
  [1453] = 1445,
  [1454] = 1454,
  [1455] = 1440,
  [1456] = 1456,
  [1457] = 1445,
  [1458] = 1440,
  [1459] = 1445,
  [1460] = 1440,
  [1461] = 1461,
  [1462] = 1440,
  [1463] = 1463,
  [1464] = 1464,
  [1465] = 1465,
  [1466] = 1466,
  [1467] = 1467,
  [1468] = 1445,
  [1469] = 1469,
  [1470] = 1470,
  [1471] = 1471,
  [1472] = 1472,
  [1473] = 1473,
  [1474] = 1474,
  [1475] = 1475,
  [1476] = 1476,
  [1477] = 1477,
  [1478] = 1478,
  [1479] = 1479,
  [1480] = 1480,
  [1481] = 1481,
  [1482] = 1482,
  [1483] = 1483,
  [1484] = 1484,
  [1485] = 1485,
  [1486] = 1486,
  [1487] = 1487,
  [1488] = 1488,
  [1489] = 1489,
  [1490] = 1490,
  [1491] = 1491,
  [1492] = 1492,
  [1493] = 1493,
  [1494] = 1494,
  [1495] = 1495,
  [1496] = 1496,
  [1497] = 1497,
  [1498] = 1498,
  [1499] = 1499,
  [1500] = 1500,
  [1501] = 1499,
  [1502] = 1502,
  [1503] = 1499,
  [1504] = 1502,
  [1505] = 1502,
  [1506] = 1506,
  [1507] = 1507,
  [1508] = 1508,
  [1509] = 1502,
  [1510] = 1499,
  [1511] = 1511,
  [1512] = 1512,
  [1513] = 1513,
  [1514] = 1500,
  [1515] = 1515,
  [1516] = 1516,
  [1517] = 1517,
  [1518] = 1518,
  [1519] = 1508,
  [1520] = 1500,
  [1521] = 1521,
  [1522] = 1508,
  [1523] = 1508,
  [1524] = 1524,
  [1525] = 1500,
  [1526] = 1526,
  [1527] = 1527,
  [1528] = 1528,
  [1529] = 1529,
  [1530] = 1530,
  [1531] = 1531,
  [1532] = 1532,
  [1533] = 1533,
  [1534] = 1534,
  [1535] = 1535,
  [1536] = 1536,
  [1537] = 1537,
  [1538] = 1538,
  [1539] = 1539,
  [1540] = 1537,
  [1541] = 1528,
  [1542] = 1539,
  [1543] = 1533,
  [1544] = 1539,
  [1545] = 1545,
  [1546] = 1539,
  [1547] = 1547,
  [1548] = 1539,
  [1549] = 1549,
  [1550] = 1550,
  [1551] = 1551,
  [1552] = 1552,
  [1553] = 1527,
  [1554] = 1554,
  [1555] = 1555,
  [1556] = 1528,
  [1557] = 1557,
  [1558] = 1537,
  [1559] = 1528,
  [1560] = 1528,
  [1561] = 1561,
  [1562] = 1528,
  [1563] = 1563,
  [1564] = 1527,
  [1565] = 1565,
  [1566] = 1566,
  [1567] = 1528,
  [1568] = 1533,
  [1569] = 1554,
  [1570] = 1554,
  [1571] = 1571,
  [1572] = 1572,
  [1573] = 1573,
  [1574] = 1574,
  [1575] = 1575,
  [1576] = 1576,
  [1577] = 1577,
  [1578] = 1578,
  [1579] = 1579,
  [1580] = 1580,
  [1581] = 1581,
  [1582] = 1582,
  [1583] = 1583,
  [1584] = 1584,
  [1585] = 1585,
  [1586] = 1586,
  [1587] = 1587,
  [1588] = 1588,
  [1589] = 1589,
  [1590] = 1583,
  [1591] = 1591,
  [1592] = 1592,
  [1593] = 1593,
  [1594] = 1594,
  [1595] = 1595,
  [1596] = 1581,
  [1597] = 1586,
  [1598] = 1598,
  [1599] = 1599,
  [1600] = 1571,
  [1601] = 1601,
  [1602] = 1602,
  [1603] = 1603,
  [1604] = 1582,
  [1605] = 1605,
  [1606] = 1606,
  [1607] = 1607,
  [1608] = 1608,
  [1609] = 1609,
  [1610] = 1610,
  [1611] = 1611,
  [1612] = 1612,
  [1613] = 1601,
  [1614] = 1578,
  [1615] = 1602,
  [1616] = 1616,
  [1617] = 1572,
  [1618] = 1571,
  [1619] = 1582,
  [1620] = 1586,
  [1621] = 1592,
  [1622] = 1606,
  [1623] = 1592,
  [1624] = 1593,
  [1625] = 1594,
  [1626] = 1626,
  [1627] = 1601,
  [1628] = 1628,
  [1629] = 1571,
  [1630] = 1601,
  [1631] = 1631,
  [1632] = 1593,
  [1633] = 1606,
  [1634] = 1606,
  [1635] = 1586,
  [1636] = 1636,
  [1637] = 1592,
  [1638] = 1593,
  [1639] = 1594,
  [1640] = 1571,
  [1641] = 1601,
  [1642] = 1602,
  [1643] = 1606,
  [1644] = 1586,
  [1645] = 1592,
  [1646] = 1593,
  [1647] = 1594,
  [1648] = 1571,
  [1649] = 1601,
  [1650] = 1602,
  [1651] = 1606,
  [1652] = 1652,
  [1653] = 1594,
  [1654] = 1573,
  [1655] = 1578,
  [1656] = 1656,
  [1657] = 1583,
  [1658] = 1658,
  [1659] = 1592,
  [1660] = 1593,
  [1661] = 1661,
  [1662] = 1581,
  [1663] = 1602,
  [1664] = 1594,
  [1665] = 1652,
  [1666] = 1666,
  [1667] = 1667,
  [1668] = 1668,
  [1669] = 1658,
  [1670] = 1670,
  [1671] = 1671,
  [1672] = 1672,
  [1673] = 1586,
  [1674] = 1674,
  [1675] = 1417,
  [1676] = 1676,
  [1677] = 1677,
  [1678] = 1678,
  [1679] = 1652,
  [1680] = 1680,
  [1681] = 1573,
  [1682] = 1682,
  [1683] = 1683,
  [1684] = 1578,
  [1685] = 1685,
  [1686] = 1602,
  [1687] = 1687,
  [1688] = 1688,
  [1689] = 1689,
  [1690] = 1690,
  [1691] = 1691,
  [1692] = 1692,
  [1693] = 1693,
  [1694] = 1694,
  [1695] = 1695,
  [1696] = 1696,
  [1697] = 1697,
  [1698] = 1698,
  [1699] = 1692,
  [1700] = 1692,
  [1701] = 1701,
  [1702] = 1702,
  [1703] = 1690,
  [1704] = 1687,
  [1705] = 1701,
  [1706] = 1690,
  [1707] = 1692,
  [1708] = 1692,
  [1709] = 1690,
  [1710] = 1701,
  [1711] = 1690,
  [1712] = 1692,
  [1713] = 1713,
  [1714] = 1714,
  [1715] = 1715,
  [1716] = 1716,
  [1717] = 1690,
  [1718] = 1692,
  [1719] = 1694,
  [1720] = 1689,
  [1721] = 1693,
  [1722] = 1702,
  [1723] = 1690,
  [1724] = 1689,
  [1725] = 1697,
  [1726] = 1702,
  [1727] = 1727,
  [1728] = 1728,
  [1729] = 1729,
  [1730] = 1730,
  [1731] = 1731,
  [1732] = 1701,
  [1733] = 1733,
  [1734] = 1734,
  [1735] = 1716,
  [1736] = 1702,
  [1737] = 1737,
  [1738] = 1737,
  [1739] = 1687,
  [1740] = 1740,
  [1741] = 1687,
  [1742] = 1689,
  [1743] = 1743,
  [1744] = 1694,
  [1745] = 1689,
  [1746] = 1693,
  [1747] = 1702,
  [1748] = 1748,
  [1749] = 1698,
  [1750] = 1697,
  [1751] = 1734,
  [1752] = 1716,
  [1753] = 1737,
  [1754] = 1693,
  [1755] = 1755,
  [1756] = 1756,
  [1757] = 1698,
  [1758] = 1697,
  [1759] = 1698,
  [1760] = 1716,
  [1761] = 1761,
  [1762] = 1737,
  [1763] = 1737,
  [1764] = 1764,
  [1765] = 1687,
  [1766] = 1697,
  [1767] = 1701,
  [1768] = 1768,
  [1769] = 1769,
  [1770] = 1770,
  [1771] = 1771,
  [1772] = 1772,
  [1773] = 1773,
  [1774] = 1774,
  [1775] = 1775,
  [1776] = 1776,
  [1777] = 1777,
  [1778] = 1778,
  [1779] = 1779,
  [1780] = 1780,
  [1781] = 1781,
  [1782] = 1782,
  [1783] = 1783,
  [1784] = 1783,
  [1785] = 1785,
  [1786] = 1786,
  [1787] = 1787,
  [1788] = 1777,
  [1789] = 1789,
  [1790] = 1790,
  [1791] = 1791,
  [1792] = 1792,
  [1793] = 1793,
  [1794] = 1786,
  [1795] = 1795,
  [1796] = 1796,
  [1797] = 1797,
  [1798] = 1780,
  [1799] = 1799,
  [1800] = 1000,
  [1801] = 1791,
  [1802] = 1012,
  [1803] = 1783,
  [1804] = 1804,
  [1805] = 1805,
  [1806] = 1787,
  [1807] = 1807,
  [1808] = 1786,
  [1809] = 1780,
  [1810] = 1810,
  [1811] = 1811,
  [1812] = 1786,
  [1813] = 1813,
  [1814] = 1807,
  [1815] = 1815,
  [1816] = 1790,
  [1817] = 1817,
  [1818] = 1777,
  [1819] = 1783,
  [1820] = 1787,
  [1821] = 1821,
  [1822] = 1786,
  [1823] = 1796,
  [1824] = 1824,
  [1825] = 1825,
  [1826] = 1826,
  [1827] = 642,
  [1828] = 1828,
  [1829] = 1829,
  [1830] = 1783,
  [1831] = 1779,
  [1832] = 1790,
  [1833] = 1833,
  [1834] = 1834,
  [1835] = 1835,
  [1836] = 1836,
  [1837] = 1837,
  [1838] = 1815,
  [1839] = 1790,
  [1840] = 1840,
  [1841] = 1841,
  [1842] = 1842,
  [1843] = 1843,
  [1844] = 1786,
  [1845] = 1845,
  [1846] = 1797,
  [1847] = 1780,
  [1848] = 1848,
  [1849] = 1849,
  [1850] = 1850,
  [1851] = 1791,
  [1852] = 1852,
  [1853] = 1853,
  [1854] = 1807,
  [1855] = 1855,
  [1856] = 1789,
  [1857] = 1857,
  [1858] = 1858,
  [1859] = 1859,
  [1860] = 1860,
  [1861] = 1817,
  [1862] = 1862,
  [1863] = 1863,
  [1864] = 1864,
  [1865] = 1797,
  [1866] = 1866,
  [1867] = 1799,
  [1868] = 638,
  [1869] = 1869,
  [1870] = 1870,
  [1871] = 1795,
  [1872] = 1872,
  [1873] = 1863,
  [1874] = 1815,
  [1875] = 1789,
  [1876] = 1813,
  [1877] = 1824,
  [1878] = 1780,
  [1879] = 1817,
  [1880] = 1880,
  [1881] = 1787,
  [1882] = 1783,
  [1883] = 1834,
  [1884] = 1884,
  [1885] = 1885,
  [1886] = 1886,
  [1887] = 1779,
  [1888] = 1790,
  [1889] = 1889,
  [1890] = 1890,
  [1891] = 1891,
  [1892] = 1892,
  [1893] = 1813,
  [1894] = 1894,
  [1895] = 1895,
  [1896] = 1896,
  [1897] = 1897,
  [1898] = 1787,
  [1899] = 1899,
  [1900] = 1900,
  [1901] = 1901,
  [1902] = 1848,
  [1903] = 1903,
  [1904] = 1904,
  [1905] = 1905,
  [1906] = 1858,
  [1907] = 1804,
  [1908] = 1795,
  [1909] = 1848,
  [1910] = 1848,
  [1911] = 1834,
  [1912] = 1912,
  [1913] = 1858,
  [1914] = 1824,
  [1915] = 1825,
  [1916] = 1825,
  [1917] = 1894,
  [1918] = 1807,
  [1919] = 1919,
  [1920] = 1920,
  [1921] = 1886,
  [1922] = 1922,
  [1923] = 1833,
  [1924] = 1894,
  [1925] = 1925,
  [1926] = 1926,
  [1927] = 1927,
  [1928] = 1789,
  [1929] = 1886,
  [1930] = 1930,
  [1931] = 1931,
  [1932] = 1932,
  [1933] = 1863,
  [1934] = 1934,
  [1935] = 1872,
  [1936] = 1919,
  [1937] = 1815,
  [1938] = 1922,
  [1939] = 1795,
  [1940] = 1872,
  [1941] = 1863,
  [1942] = 999,
  [1943] = 1943,
  [1944] = 1930,
  [1945] = 1824,
  [1946] = 1825,
  [1947] = 1947,
  [1948] = 1783,
  [1949] = 1949,
  [1950] = 1858,
  [1951] = 1833,
  [1952] = 1952,
  [1953] = 1953,
  [1954] = 1954,
  [1955] = 1786,
  [1956] = 1956,
  [1957] = 1957,
  [1958] = 1797,
  [1959] = 1930,
  [1960] = 1901,
  [1961] = 1961,
  [1962] = 1813,
  [1963] = 1963,
  [1964] = 1964,
  [1965] = 1965,
  [1966] = 1824,
  [1967] = 1967,
  [1968] = 1968,
  [1969] = 1969,
  [1970] = 1824,
  [1971] = 1824,
  [1972] = 1947,
  [1973] = 1973,
  [1974] = 1974,
  [1975] = 1975,
  [1976] = 1919,
  [1977] = 1778,
  [1978] = 1978,
  [1979] = 1834,
  [1980] = 1804,
  [1981] = 1981,
  [1982] = 1982,
  [1983] = 1790,
  [1984] = 1791,
  [1985] = 1985,
  [1986] = 1986,
  [1987] = 1894,
  [1988] = 1842,
  [1989] = 1817,
  [1990] = 1930,
  [1991] = 1991,
  [1992] = 1967,
  [1993] = 1993,
  [1994] = 1789,
  [1995] = 1815,
  [1996] = 1833,
  [1997] = 1834,
  [1998] = 1834,
  [1999] = 1999,
  [2000] = 1978,
  [2001] = 2001,
  [2002] = 1884,
  [2003] = 1842,
  [2004] = 2004,
  [2005] = 1947,
  [2006] = 1787,
  [2007] = 1789,
  [2008] = 2008,
  [2009] = 1919,
  [2010] = 2010,
  [2011] = 1842,
  [2012] = 2012,
  [2013] = 1004,
  [2014] = 2008,
  [2015] = 2015,
  [2016] = 1978,
  [2017] = 2017,
  [2018] = 2008,
  [2019] = 1978,
  [2020] = 2020,
  [2021] = 1787,
  [2022] = 1978,
};

static TSCharacterRange sym_number_literal_character_set_13[] = {
  {'0', '9'}, {'B', 'B'}, {'D', 'D'}, {'F', 'F'}, {'L', 'L'}, {'U', 'U'}, {'W', 'W'}, {'b', 'b'},
  {'d', 'd'}, {'f', 'f'}, {'l', 'l'}, {'u', 'u'}, {'w', 'w'},
};

static TSCharacterRange sym_identifier_character_set_1[] = {
  {'$', '$'}, {'A', 'Z'}, {'\\', '\\'}, {'_', '_'}, {'a', 'z'}, {0xaa, 0xaa}, {0xb5, 0xb5}, {0xba, 0xba},
  {0xc0, 0xd6}, {0xd8, 0xf6}, {0xf8, 0x2c1}, {0x2c6, 0x2d1}, {0x2e0, 0x2e4}, {0x2ec, 0x2ec}, {0x2ee, 0x2ee}, {0x370, 0x374},
  {0x376, 0x377}, {0x37b, 0x37d}, {0x37f, 0x37f}, {0x386, 0x386}, {0x388, 0x38a}, {0x38c, 0x38c}, {0x38e, 0x3a1}, {0x3a3, 0x3f5},
  {0x3f7, 0x481}, {0x48a, 0x52f}, {0x531, 0x556}, {0x559, 0x559}, {0x560, 0x588}, {0x5d0, 0x5ea}, {0x5ef, 0x5f2}, {0x620, 0x64a},
  {0x66e, 0x66f}, {0x671, 0x6d3}, {0x6d5, 0x6d5}, {0x6e5, 0x6e6}, {0x6ee, 0x6ef}, {0x6fa, 0x6fc}, {0x6ff, 0x6ff}, {0x710, 0x710},
  {0x712, 0x72f}, {0x74d, 0x7a5}, {0x7b1, 0x7b1}, {0x7ca, 0x7ea}, {0x7f4, 0x7f5}, {0x7fa, 0x7fa}, {0x800, 0x815}, {0x81a, 0x81a},
  {0x824, 0x824}, {0x828, 0x828}, {0x840, 0x858}, {0x860, 0x86a}, {0x870, 0x887}, {0x889, 0x88e}, {0x8a0, 0x8c9}, {0x904, 0x939},
  {0x93d, 0x93d}, {0x950, 0x950}, {0x958, 0x961}, {0x971, 0x980}, {0x985, 0x98c}, {0x98f, 0x990}, {0x993, 0x9a8}, {0x9aa, 0x9b0},
  {0x9b2, 0x9b2}, {0x9b6, 0x9b9}, {0x9bd, 0x9bd}, {0x9ce, 0x9ce}, {0x9dc, 0x9dd}, {0x9df, 0x9e1}, {0x9f0, 0x9f1}, {0x9fc, 0x9fc},
  {0xa05, 0xa0a}, {0xa0f, 0xa10}, {0xa13, 0xa28}, {0xa2a, 0xa30}, {0xa32, 0xa33}, {0xa35, 0xa36}, {0xa38, 0xa39}, {0xa59, 0xa5c},
  {0xa5e, 0xa5e}, {0xa72, 0xa74}, {0xa85, 0xa8d}, {0xa8f, 0xa91}, {0xa93, 0xaa8}, {0xaaa, 0xab0}, {0xab2, 0xab3}, {0xab5, 0xab9},
  {0xabd, 0xabd}, {0xad0, 0xad0}, {0xae0, 0xae1}, {0xaf9, 0xaf9}, {0xb05, 0xb0c}, {0xb0f, 0xb10}, {0xb13, 0xb28}, {0xb2a, 0xb30},
  {0xb32, 0xb33}, {0xb35, 0xb39}, {0xb3d, 0xb3d}, {0xb5c, 0xb5d}, {0xb5f, 0xb61}, {0xb71, 0xb71}, {0xb83, 0xb83}, {0xb85, 0xb8a},
  {0xb8e, 0xb90}, {0xb92, 0xb95}, {0xb99, 0xb9a}, {0xb9c, 0xb9c}, {0xb9e, 0xb9f}, {0xba3, 0xba4}, {0xba8, 0xbaa}, {0xbae, 0xbb9},
  {0xbd0, 0xbd0}, {0xc05, 0xc0c}, {0xc0e, 0xc10}, {0xc12, 0xc28}, {0xc2a, 0xc39}, {0xc3d, 0xc3d}, {0xc58, 0xc5a}, {0xc5d, 0xc5d},
  {0xc60, 0xc61}, {0xc80, 0xc80}, {0xc85, 0xc8c}, {0xc8e, 0xc90}, {0xc92, 0xca8}, {0xcaa, 0xcb3}, {0xcb5, 0xcb9}, {0xcbd, 0xcbd},
  {0xcdd, 0xcde}, {0xce0, 0xce1}, {0xcf1, 0xcf2}, {0xd04, 0xd0c}, {0xd0e, 0xd10}, {0xd12, 0xd3a}, {0xd3d, 0xd3d}, {0xd4e, 0xd4e},
  {0xd54, 0xd56}, {0xd5f, 0xd61}, {0xd7a, 0xd7f}, {0xd85, 0xd96}, {0xd9a, 0xdb1}, {0xdb3, 0xdbb}, {0xdbd, 0xdbd}, {0xdc0, 0xdc6},
  {0xe01, 0xe30}, {0xe32, 0xe32}, {0xe40, 0xe46}, {0xe81, 0xe82}, {0xe84, 0xe84}, {0xe86, 0xe8a}, {0xe8c, 0xea3}, {0xea5, 0xea5},
  {0xea7, 0xeb0}, {0xeb2, 0xeb2}, {0xebd, 0xebd}, {0xec0, 0xec4}, {0xec6, 0xec6}, {0xedc, 0xedf}, {0xf00, 0xf00}, {0xf40, 0xf47},
  {0xf49, 0xf6c}, {0xf88, 0xf8c}, {0x1000, 0x102a}, {0x103f, 0x103f}, {0x1050, 0x1055}, {0x105a, 0x105d}, {0x1061, 0x1061}, {0x1065, 0x1066},
  {0x106e, 0x1070}, {0x1075, 0x1081}, {0x108e, 0x108e}, {0x10a0, 0x10c5}, {0x10c7, 0x10c7}, {0x10cd, 0x10cd}, {0x10d0, 0x10fa}, {0x10fc, 0x1248},
  {0x124a, 0x124d}, {0x1250, 0x1256}, {0x1258, 0x1258}, {0x125a, 0x125d}, {0x1260, 0x1288}, {0x128a, 0x128d}, {0x1290, 0x12b0}, {0x12b2, 0x12b5},
  {0x12b8, 0x12be}, {0x12c0, 0x12c0}, {0x12c2, 0x12c5}, {0x12c8, 0x12d6}, {0x12d8, 0x1310}, {0x1312, 0x1315}, {0x1318, 0x135a}, {0x1380, 0x138f},
  {0x13a0, 0x13f5}, {0x13f8, 0x13fd}, {0x1401, 0x166c}, {0x166f, 0x167f}, {0x1681, 0x169a}, {0x16a0, 0x16ea}, {0x16ee, 0x16f8}, {0x1700, 0x1711},
  {0x171f, 0x1731}, {0x1740, 0x1751}, {0x1760, 0x176c}, {0x176e, 0x1770}, {0x1780, 0x17b3}, {0x17d7, 0x17d7}, {0x17dc, 0x17dc}, {0x1820, 0x1878},
  {0x1880, 0x18a8}, {0x18aa, 0x18aa}, {0x18b0, 0x18f5}, {0x1900, 0x191e}, {0x1950, 0x196d}, {0x1970, 0x1974}, {0x1980, 0x19ab}, {0x19b0, 0x19c9},
  {0x1a00, 0x1a16}, {0x1a20, 0x1a54}, {0x1aa7, 0x1aa7}, {0x1b05, 0x1b33}, {0x1b45, 0x1b4c}, {0x1b83, 0x1ba0}, {0x1bae, 0x1baf}, {0x1bba, 0x1be5},
  {0x1c00, 0x1c23}, {0x1c4d, 0x1c4f}, {0x1c5a, 0x1c7d}, {0x1c80, 0x1c88}, {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf}, {0x1ce9, 0x1cec}, {0x1cee, 0x1cf3},
  {0x1cf5, 0x1cf6}, {0x1cfa, 0x1cfa}, {0x1d00, 0x1dbf}, {0x1e00, 0x1f15}, {0x1f18, 0x1f1d}, {0x1f20, 0x1f45}, {0x1f48, 0x1f4d}, {0x1f50, 0x1f57},
  {0x1f59, 0x1f59}, {0x1f5b, 0x1f5b}, {0x1f5d, 0x1f5d}, {0x1f5f, 0x1f7d}, {0x1f80, 0x1fb4}, {0x1fb6, 0x1fbc}, {0x1fbe, 0x1fbe}, {0x1fc2, 0x1fc4},
  {0x1fc6, 0x1fcc}, {0x1fd0, 0x1fd3}, {0x1fd6, 0x1fdb}, {0x1fe0, 0x1fec}, {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffc}, {0x2071, 0x2071}, {0x207f, 0x207f},
  {0x2090, 0x209c}, {0x2102, 0x2102}, {0x2107, 0x2107}, {0x210a, 0x2113}, {0x2115, 0x2115}, {0x2118, 0x211d}, {0x2124, 0x2124}, {0x2126, 0x2126},
  {0x2128, 0x2128}, {0x212a, 0x2139}, {0x213c, 0x213f}, {0x2145, 0x2149}, {0x214e, 0x214e}, {0x2160, 0x2188}, {0x2c00, 0x2ce4}, {0x2ceb, 0x2cee},
  {0x2cf2, 0x2cf3}, {0x2d00, 0x2d25}, {0x2d27, 0x2d27}, {0x2d2d, 0x2d2d}, {0x2d30, 0x2d67}, {0x2d6f, 0x2d6f}, {0x2d80, 0x2d96}, {0x2da0, 0x2da6},
  {0x2da8, 0x2dae}, {0x2db0, 0x2db6}, {0x2db8, 0x2dbe}, {0x2dc0, 0x2dc6}, {0x2dc8, 0x2dce}, {0x2dd0, 0x2dd6}, {0x2dd8, 0x2dde}, {0x3005, 0x3007},
  {0x3021, 0x3029}, {0x3031, 0x3035}, {0x3038, 0x303c}, {0x3041, 0x3096}, {0x309d, 0x309f}, {0x30a1, 0x30fa}, {0x30fc, 0x30ff}, {0x3105, 0x312f},
  {0x3131, 0x318e}, {0x31a0, 0x31bf}, {0x31f0, 0x31ff}, {0x3400, 0x4dbf}, {0x4e00, 0xa48c}, {0xa4d0, 0xa4fd}, {0xa500, 0xa60c}, {0xa610, 0xa61f},
  {0xa62a, 0xa62b}, {0xa640, 0xa66e}, {0xa67f, 0xa69d}, {0xa6a0, 0xa6ef}, {0xa717, 0xa71f}, {0xa722, 0xa788}, {0xa78b, 0xa7ca}, {0xa7d0, 0xa7d1},
  {0xa7d3, 0xa7d3}, {0xa7d5, 0xa7d9}, {0xa7f2, 0xa801}, {0xa803, 0xa805}, {0xa807, 0xa80a}, {0xa80c, 0xa822}, {0xa840, 0xa873}, {0xa882, 0xa8b3},
  {0xa8f2, 0xa8f7}, {0xa8fb, 0xa8fb}, {0xa8fd, 0xa8fe}, {0xa90a, 0xa925}, {0xa930, 0xa946}, {0xa960, 0xa97c}, {0xa984, 0xa9b2}, {0xa9cf, 0xa9cf},
  {0xa9e0, 0xa9e4}, {0xa9e6, 0xa9ef}, {0xa9fa, 0xa9fe}, {0xaa00, 0xaa28}, {0xaa40, 0xaa42}, {0xaa44, 0xaa4b}, {0xaa60, 0xaa76}, {0xaa7a, 0xaa7a},
  {0xaa7e, 0xaaaf}, {0xaab1, 0xaab1}, {0xaab5, 0xaab6}, {0xaab9, 0xaabd}, {0xaac0, 0xaac0}, {0xaac2, 0xaac2}, {0xaadb, 0xaadd}, {0xaae0, 0xaaea},
  {0xaaf2, 0xaaf4}, {0xab01, 0xab06}, {0xab09, 0xab0e}, {0xab11, 0xab16}, {0xab20, 0xab26}, {0xab28, 0xab2e}, {0xab30, 0xab5a}, {0xab5c, 0xab69},
  {0xab70, 0xabe2}, {0xac00, 0xd7a3}, {0xd7b0, 0xd7c6}, {0xd7cb, 0xd7fb}, {0xf900, 0xfa6d}, {0xfa70, 0xfad9}, {0xfb00, 0xfb06}, {0xfb13, 0xfb17},
  {0xfb1d, 0xfb1d}, {0xfb1f, 0xfb28}, {0xfb2a, 0xfb36}, {0xfb38, 0xfb3c}, {0xfb3e, 0xfb3e}, {0xfb40, 0xfb41}, {0xfb43, 0xfb44}, {0xfb46, 0xfbb1},
  {0xfbd3, 0xfc5d}, {0xfc64, 0xfd3d}, {0xfd50, 0xfd8f}, {0xfd92, 0xfdc7}, {0xfdf0, 0xfdf9}, {0xfe71, 0xfe71}, {0xfe73, 0xfe73}, {0xfe77, 0xfe77},
  {0xfe79, 0xfe79}, {0xfe7b, 0xfe7b}, {0xfe7d, 0xfe7d}, {0xfe7f, 0xfefc}, {0xff21, 0xff3a}, {0xff41, 0xff5a}, {0xff66, 0xff9d}, {0xffa0, 0xffbe},
  {0xffc2, 0xffc7}, {0xffca, 0xffcf}, {0xffd2, 0xffd7}, {0xffda, 0xffdc}, {0x10000, 0x1000b}, {0x1000d, 0x10026}, {0x10028, 0x1003a}, {0x1003c, 0x1003d},
  {0x1003f, 0x1004d}, {0x10050, 0x1005d}, {0x10080, 0x100fa}, {0x10140, 0x10174}, {0x10280, 0x1029c}, {0x102a0, 0x102d0}, {0x10300, 0x1031f}, {0x1032d, 0x1034a},
  {0x10350, 0x10375}, {0x10380, 0x1039d}, {0x103a0, 0x103c3}, {0x103c8, 0x103cf}, {0x103d1, 0x103d5}, {0x10400, 0x1049d}, {0x104b0, 0x104d3}, {0x104d8, 0x104fb},
  {0x10500, 0x10527}, {0x10530, 0x10563}, {0x10570, 0x1057a}, {0x1057c, 0x1058a}, {0x1058c, 0x10592}, {0x10594, 0x10595}, {0x10597, 0x105a1}, {0x105a3, 0x105b1},
  {0x105b3, 0x105b9}, {0x105bb, 0x105bc}, {0x10600, 0x10736}, {0x10740, 0x10755}, {0x10760, 0x10767}, {0x10780, 0x10785}, {0x10787, 0x107b0}, {0x107b2, 0x107ba},
  {0x10800, 0x10805}, {0x10808, 0x10808}, {0x1080a, 0x10835}, {0x10837, 0x10838}, {0x1083c, 0x1083c}, {0x1083f, 0x10855}, {0x10860, 0x10876}, {0x10880, 0x1089e},
  {0x108e0, 0x108f2}, {0x108f4, 0x108f5}, {0x10900, 0x10915}, {0x10920, 0x10939}, {0x10980, 0x109b7}, {0x109be, 0x109bf}, {0x10a00, 0x10a00}, {0x10a10, 0x10a13},
  {0x10a15, 0x10a17}, {0x10a19, 0x10a35}, {0x10a60, 0x10a7c}, {0x10a80, 0x10a9c}, {0x10ac0, 0x10ac7}, {0x10ac9, 0x10ae4}, {0x10b00, 0x10b35}, {0x10b40, 0x10b55},
  {0x10b60, 0x10b72}, {0x10b80, 0x10b91}, {0x10c00, 0x10c48}, {0x10c80, 0x10cb2}, {0x10cc0, 0x10cf2}, {0x10d00, 0x10d23}, {0x10e80, 0x10ea9}, {0x10eb0, 0x10eb1},
  {0x10f00, 0x10f1c}, {0x10f27, 0x10f27}, {0x10f30, 0x10f45}, {0x10f70, 0x10f81}, {0x10fb0, 0x10fc4}, {0x10fe0, 0x10ff6}, {0x11003, 0x11037}, {0x11071, 0x11072},
  {0x11075, 0x11075}, {0x11083, 0x110af}, {0x110d0, 0x110e8}, {0x11103, 0x11126}, {0x11144, 0x11144}, {0x11147, 0x11147}, {0x11150, 0x11172}, {0x11176, 0x11176},
  {0x11183, 0x111b2}, {0x111c1, 0x111c4}, {0x111da, 0x111da}, {0x111dc, 0x111dc}, {0x11200, 0x11211}, {0x11213, 0x1122b}, {0x1123f, 0x11240}, {0x11280, 0x11286},
  {0x11288, 0x11288}, {0x1128a, 0x1128d}, {0x1128f, 0x1129d}, {0x1129f, 0x112a8}, {0x112b0, 0x112de}, {0x11305, 0x1130c}, {0x1130f, 0x11310}, {0x11313, 0x11328},
  {0x1132a, 0x11330}, {0x11332, 0x11333}, {0x11335, 0x11339}, {0x1133d, 0x1133d}, {0x11350, 0x11350}, {0x1135d, 0x11361}, {0x11400, 0x11434}, {0x11447, 0x1144a},
  {0x1145f, 0x11461}, {0x11480, 0x114af}, {0x114c4, 0x114c5}, {0x114c7, 0x114c7}, {0x11580, 0x115ae}, {0x115d8, 0x115db}, {0x11600, 0x1162f}, {0x11644, 0x11644},
  {0x11680, 0x116aa}, {0x116b8, 0x116b8}, {0x11700, 0x1171a}, {0x11740, 0x11746}, {0x11800, 0x1182b}, {0x118a0, 0x118df}, {0x118ff, 0x11906}, {0x11909, 0x11909},
  {0x1190c, 0x11913}, {0x11915, 0x11916}, {0x11918, 0x1192f}, {0x1193f, 0x1193f}, {0x11941, 0x11941}, {0x119a0, 0x119a7}, {0x119aa, 0x119d0}, {0x119e1, 0x119e1},
  {0x119e3, 0x119e3}, {0x11a00, 0x11a00}, {0x11a0b, 0x11a32}, {0x11a3a, 0x11a3a}, {0x11a50, 0x11a50}, {0x11a5c, 0x11a89}, {0x11a9d, 0x11a9d}, {0x11ab0, 0x11af8},
  {0x11c00, 0x11c08}, {0x11c0a, 0x11c2e}, {0x11c40, 0x11c40}, {0x11c72, 0x11c8f}, {0x11d00, 0x11d06}, {0x11d08, 0x11d09}, {0x11d0b, 0x11d30}, {0x11d46, 0x11d46},
  {0x11d60, 0x11d65}, {0x11d67, 0x11d68}, {0x11d6a, 0x11d89}, {0x11d98, 0x11d98}, {0x11ee0, 0x11ef2}, {0x11f02, 0x11f02}, {0x11f04, 0x11f10}, {0x11f12, 0x11f33},
  {0x11fb0, 0x11fb0}, {0x12000, 0x12399}, {0x12400, 0x1246e}, {0x12480, 0x12543}, {0x12f90, 0x12ff0}, {0x13000, 0x1342f}, {0x13441, 0x13446}, {0x14400, 0x14646},
  {0x16800, 0x16a38}, {0x16a40, 0x16a5e}, {0x16a70, 0x16abe}, {0x16ad0, 0x16aed}, {0x16b00, 0x16b2f}, {0x16b40, 0x16b43}, {0x16b63, 0x16b77}, {0x16b7d, 0x16b8f},
  {0x16e40, 0x16e7f}, {0x16f00, 0x16f4a}, {0x16f50, 0x16f50}, {0x16f93, 0x16f9f}, {0x16fe0, 0x16fe1}, {0x16fe3, 0x16fe3}, {0x17000, 0x187f7}, {0x18800, 0x18cd5},
  {0x18d00, 0x18d08}, {0x1aff0, 0x1aff3}, {0x1aff5, 0x1affb}, {0x1affd, 0x1affe}, {0x1b000, 0x1b122}, {0x1b132, 0x1b132}, {0x1b150, 0x1b152}, {0x1b155, 0x1b155},
  {0x1b164, 0x1b167}, {0x1b170, 0x1b2fb}, {0x1bc00, 0x1bc6a}, {0x1bc70, 0x1bc7c}, {0x1bc80, 0x1bc88}, {0x1bc90, 0x1bc99}, {0x1d400, 0x1d454}, {0x1d456, 0x1d49c},
  {0x1d49e, 0x1d49f}, {0x1d4a2, 0x1d4a2}, {0x1d4a5, 0x1d4a6}, {0x1d4a9, 0x1d4ac}, {0x1d4ae, 0x1d4b9}, {0x1d4bb, 0x1d4bb}, {0x1d4bd, 0x1d4c3}, {0x1d4c5, 0x1d505},
  {0x1d507, 0x1d50a}, {0x1d50d, 0x1d514}, {0x1d516, 0x1d51c}, {0x1d51e, 0x1d539}, {0x1d53b, 0x1d53e}, {0x1d540, 0x1d544}, {0x1d546, 0x1d546}, {0x1d54a, 0x1d550},
  {0x1d552, 0x1d6a5}, {0x1d6a8, 0x1d6c0}, {0x1d6c2, 0x1d6da}, {0x1d6dc, 0x1d6fa}, {0x1d6fc, 0x1d714}, {0x1d716, 0x1d734}, {0x1d736, 0x1d74e}, {0x1d750, 0x1d76e},
  {0x1d770, 0x1d788}, {0x1d78a, 0x1d7a8}, {0x1d7aa, 0x1d7c2}, {0x1d7c4, 0x1d7cb}, {0x1df00, 0x1df1e}, {0x1df25, 0x1df2a}, {0x1e030, 0x1e06d}, {0x1e100, 0x1e12c},
  {0x1e137, 0x1e13d}, {0x1e14e, 0x1e14e}, {0x1e290, 0x1e2ad}, {0x1e2c0, 0x1e2eb}, {0x1e4d0, 0x1e4eb}, {0x1e7e0, 0x1e7e6}, {0x1e7e8, 0x1e7eb}, {0x1e7ed, 0x1e7ee},
  {0x1e7f0, 0x1e7fe}, {0x1e800, 0x1e8c4}, {0x1e900, 0x1e943}, {0x1e94b, 0x1e94b}, {0x1ee00, 0x1ee03}, {0x1ee05, 0x1ee1f}, {0x1ee21, 0x1ee22}, {0x1ee24, 0x1ee24},
  {0x1ee27, 0x1ee27}, {0x1ee29, 0x1ee32}, {0x1ee34, 0x1ee37}, {0x1ee39, 0x1ee39}, {0x1ee3b, 0x1ee3b}, {0x1ee42, 0x1ee42}, {0x1ee47, 0x1ee47}, {0x1ee49, 0x1ee49},
  {0x1ee4b, 0x1ee4b}, {0x1ee4d, 0x1ee4f}, {0x1ee51, 0x1ee52}, {0x1ee54, 0x1ee54}, {0x1ee57, 0x1ee57}, {0x1ee59, 0x1ee59}, {0x1ee5b, 0x1ee5b}, {0x1ee5d, 0x1ee5d},
  {0x1ee5f, 0x1ee5f}, {0x1ee61, 0x1ee62}, {0x1ee64, 0x1ee64}, {0x1ee67, 0x1ee6a}, {0x1ee6c, 0x1ee72}, {0x1ee74, 0x1ee77}, {0x1ee79, 0x1ee7c}, {0x1ee7e, 0x1ee7e},
  {0x1ee80, 0x1ee89}, {0x1ee8b, 0x1ee9b}, {0x1eea1, 0x1eea3}, {0x1eea5, 0x1eea9}, {0x1eeab, 0x1eebb}, {0x20000, 0x2a6df}, {0x2a700, 0x2b739}, {0x2b740, 0x2b81d},
  {0x2b820, 0x2cea1}, {0x2ceb0, 0x2ebe0}, {0x2ebf0, 0x2ee5d}, {0x2f800, 0x2fa1d}, {0x30000, 0x3134a}, {0x31350, 0x323af},
};

static TSCharacterRange sym_identifier_character_set_2[] = {
  {'$', '$'}, {'0', '9'}, {'A', 'Z'}, {'\\', '\\'}, {'_', '_'}, {'a', 'z'}, {0xaa, 0xaa}, {0xb5, 0xb5},
  {0xb7, 0xb7}, {0xba, 0xba}, {0xc0, 0xd6}, {0xd8, 0xf6}, {0xf8, 0x2c1}, {0x2c6, 0x2d1}, {0x2e0, 0x2e4}, {0x2ec, 0x2ec},
  {0x2ee, 0x2ee}, {0x300, 0x374}, {0x376, 0x377}, {0x37b, 0x37d}, {0x37f, 0x37f}, {0x386, 0x38a}, {0x38c, 0x38c}, {0x38e, 0x3a1},
  {0x3a3, 0x3f5}, {0x3f7, 0x481}, {0x483, 0x487}, {0x48a, 0x52f}, {0x531, 0x556}, {0x559, 0x559}, {0x560, 0x588}, {0x591, 0x5bd},
  {0x5bf, 0x5bf}, {0x5c1, 0x5c2}, {0x5c4, 0x5c5}, {0x5c7, 0x5c7}, {0x5d0, 0x5ea}, {0x5ef, 0x5f2}, {0x610, 0x61a}, {0x620, 0x669},
  {0x66e, 0x6d3}, {0x6d5, 0x6dc}, {0x6df, 0x6e8}, {0x6ea, 0x6fc}, {0x6ff, 0x6ff}, {0x710, 0x74a}, {0x74d, 0x7b1}, {0x7c0, 0x7f5},
  {0x7fa, 0x7fa}, {0x7fd, 0x7fd}, {0x800, 0x82d}, {0x840, 0x85b}, {0x860, 0x86a}, {0x870, 0x887}, {0x889, 0x88e}, {0x898, 0x8e1},
  {0x8e3, 0x963}, {0x966, 0x96f}, {0x971, 0x983}, {0x985, 0x98c}, {0x98f, 0x990}, {0x993, 0x9a8}, {0x9aa, 0x9b0}, {0x9b2, 0x9b2},
  {0x9b6, 0x9b9}, {0x9bc, 0x9c4}, {0x9c7, 0x9c8}, {0x9cb, 0x9ce}, {0x9d7, 0x9d7}, {0x9dc, 0x9dd}, {0x9df, 0x9e3}, {0x9e6, 0x9f1},
  {0x9fc, 0x9fc}, {0x9fe, 0x9fe}, {0xa01, 0xa03}, {0xa05, 0xa0a}, {0xa0f, 0xa10}, {0xa13, 0xa28}, {0xa2a, 0xa30}, {0xa32, 0xa33},
  {0xa35, 0xa36}, {0xa38, 0xa39}, {0xa3c, 0xa3c}, {0xa3e, 0xa42}, {0xa47, 0xa48}, {0xa4b, 0xa4d}, {0xa51, 0xa51}, {0xa59, 0xa5c},
  {0xa5e, 0xa5e}, {0xa66, 0xa75}, {0xa81, 0xa83}, {0xa85, 0xa8d}, {0xa8f, 0xa91}, {0xa93, 0xaa8}, {0xaaa, 0xab0}, {0xab2, 0xab3},
  {0xab5, 0xab9}, {0xabc, 0xac5}, {0xac7, 0xac9}, {0xacb, 0xacd}, {0xad0, 0xad0}, {0xae0, 0xae3}, {0xae6, 0xaef}, {0xaf9, 0xaff},
  {0xb01, 0xb03}, {0xb05, 0xb0c}, {0xb0f, 0xb10}, {0xb13, 0xb28}, {0xb2a, 0xb30}, {0xb32, 0xb33}, {0xb35, 0xb39}, {0xb3c, 0xb44},
  {0xb47, 0xb48}, {0xb4b, 0xb4d}, {0xb55, 0xb57}, {0xb5c, 0xb5d}, {0xb5f, 0xb63}, {0xb66, 0xb6f}, {0xb71, 0xb71}, {0xb82, 0xb83},
  {0xb85, 0xb8a}, {0xb8e, 0xb90}, {0xb92, 0xb95}, {0xb99, 0xb9a}, {0xb9c, 0xb9c}, {0xb9e, 0xb9f}, {0xba3, 0xba4}, {0xba8, 0xbaa},
  {0xbae, 0xbb9}, {0xbbe, 0xbc2}, {0xbc6, 0xbc8}, {0xbca, 0xbcd}, {0xbd0, 0xbd0}, {0xbd7, 0xbd7}, {0xbe6, 0xbef}, {0xc00, 0xc0c},
  {0xc0e, 0xc10}, {0xc12, 0xc28}, {0xc2a, 0xc39}, {0xc3c, 0xc44}, {0xc46, 0xc48}, {0xc4a, 0xc4d}, {0xc55, 0xc56}, {0xc58, 0xc5a},
  {0xc5d, 0xc5d}, {0xc60, 0xc63}, {0xc66, 0xc6f}, {0xc80, 0xc83}, {0xc85, 0xc8c}, {0xc8e, 0xc90}, {0xc92, 0xca8}, {0xcaa, 0xcb3},
  {0xcb5, 0xcb9}, {0xcbc, 0xcc4}, {0xcc6, 0xcc8}, {0xcca, 0xccd}, {0xcd5, 0xcd6}, {0xcdd, 0xcde}, {0xce0, 0xce3}, {0xce6, 0xcef},
  {0xcf1, 0xcf3}, {0xd00, 0xd0c}, {0xd0e, 0xd10}, {0xd12, 0xd44}, {0xd46, 0xd48}, {0xd4a, 0xd4e}, {0xd54, 0xd57}, {0xd5f, 0xd63},
  {0xd66, 0xd6f}, {0xd7a, 0xd7f}, {0xd81, 0xd83}, {0xd85, 0xd96}, {0xd9a, 0xdb1}, {0xdb3, 0xdbb}, {0xdbd, 0xdbd}, {0xdc0, 0xdc6},
  {0xdca, 0xdca}, {0xdcf, 0xdd4}, {0xdd6, 0xdd6}, {0xdd8, 0xddf}, {0xde6, 0xdef}, {0xdf2, 0xdf3}, {0xe01, 0xe3a}, {0xe40, 0xe4e},
  {0xe50, 0xe59}, {0xe81, 0xe82}, {0xe84, 0xe84}, {0xe86, 0xe8a}, {0xe8c, 0xea3}, {0xea5, 0xea5}, {0xea7, 0xebd}, {0xec0, 0xec4},
  {0xec6, 0xec6}, {0xec8, 0xece}, {0xed0, 0xed9}, {0xedc, 0xedf}, {0xf00, 0xf00}, {0xf18, 0xf19}, {0xf20, 0xf29}, {0xf35, 0xf35},
  {0xf37, 0xf37}, {0xf39, 0xf39}, {0xf3e, 0xf47}, {0xf49, 0xf6c}, {0xf71, 0xf84}, {0xf86, 0xf97}, {0xf99, 0xfbc}, {0xfc6, 0xfc6},
  {0x1000, 0x1049}, {0x1050, 0x109d}, {0x10a0, 0x10c5}, {0x10c7, 0x10c7}, {0x10cd, 0x10cd}, {0x10d0, 0x10fa}, {0x10fc, 0x1248}, {0x124a, 0x124d},
  {0x1250, 0x1256}, {0x1258, 0x1258}, {0x125a, 0x125d}, {0x1260, 0x1288}, {0x128a, 0x128d}, {0x1290, 0x12b0}, {0x12b2, 0x12b5}, {0x12b8, 0x12be},
  {0x12c0, 0x12c0}, {0x12c2, 0x12c5}, {0x12c8, 0x12d6}, {0x12d8, 0x1310}, {0x1312, 0x1315}, {0x1318, 0x135a}, {0x135d, 0x135f}, {0x1369, 0x1371},
  {0x1380, 0x138f}, {0x13a0, 0x13f5}, {0x13f8, 0x13fd}, {0x1401, 0x166c}, {0x166f, 0x167f}, {0x1681, 0x169a}, {0x16a0, 0x16ea}, {0x16ee, 0x16f8},
  {0x1700, 0x1715}, {0x171f, 0x1734}, {0x1740, 0x1753}, {0x1760, 0x176c}, {0x176e, 0x1770}, {0x1772, 0x1773}, {0x1780, 0x17d3}, {0x17d7, 0x17d7},
  {0x17dc, 0x17dd}, {0x17e0, 0x17e9}, {0x180b, 0x180d}, {0x180f, 0x1819}, {0x1820, 0x1878}, {0x1880, 0x18aa}, {0x18b0, 0x18f5}, {0x1900, 0x191e},
  {0x1920, 0x192b}, {0x1930, 0x193b}, {0x1946, 0x196d}, {0x1970, 0x1974}, {0x1980, 0x19ab}, {0x19b0, 0x19c9}, {0x19d0, 0x19da}, {0x1a00, 0x1a1b},
  {0x1a20, 0x1a5e}, {0x1a60, 0x1a7c}, {0x1a7f, 0x1a89}, {0x1a90, 0x1a99}, {0x1aa7, 0x1aa7}, {0x1ab0, 0x1abd}, {0x1abf, 0x1ace}, {0x1b00, 0x1b4c},
  {0x1b50, 0x1b59}, {0x1b6b, 0x1b73}, {0x1b80, 0x1bf3}, {0x1c00, 0x1c37}, {0x1c40, 0x1c49}, {0x1c4d, 0x1c7d}, {0x1c80, 0x1c88}, {0x1c90, 0x1cba},
  {0x1cbd, 0x1cbf}, {0x1cd0, 0x1cd2}, {0x1cd4, 0x1cfa}, {0x1d00, 0x1f15}, {0x1f18, 0x1f1d}, {0x1f20, 0x1f45}, {0x1f48, 0x1f4d}, {0x1f50, 0x1f57},
  {0x1f59, 0x1f59}, {0x1f5b, 0x1f5b}, {0x1f5d, 0x1f5d}, {0x1f5f, 0x1f7d}, {0x1f80, 0x1fb4}, {0x1fb6, 0x1fbc}, {0x1fbe, 0x1fbe}, {0x1fc2, 0x1fc4},
  {0x1fc6, 0x1fcc}, {0x1fd0, 0x1fd3}, {0x1fd6, 0x1fdb}, {0x1fe0, 0x1fec}, {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffc}, {0x200c, 0x200d}, {0x203f, 0x2040},
  {0x2054, 0x2054}, {0x2071, 0x2071}, {0x207f, 0x207f}, {0x2090, 0x209c}, {0x20d0, 0x20dc}, {0x20e1, 0x20e1}, {0x20e5, 0x20f0}, {0x2102, 0x2102},
  {0x2107, 0x2107}, {0x210a, 0x2113}, {0x2115, 0x2115}, {0x2118, 0x211d}, {0x2124, 0x2124}, {0x2126, 0x2126}, {0x2128, 0x2128}, {0x212a, 0x2139},
  {0x213c, 0x213f}, {0x2145, 0x2149}, {0x214e, 0x214e}, {0x2160, 0x2188}, {0x2c00, 0x2ce4}, {0x2ceb, 0x2cf3}, {0x2d00, 0x2d25}, {0x2d27, 0x2d27},
  {0x2d2d, 0x2d2d}, {0x2d30, 0x2d67}, {0x2d6f, 0x2d6f}, {0x2d7f, 0x2d96}, {0x2da0, 0x2da6}, {0x2da8, 0x2dae}, {0x2db0, 0x2db6}, {0x2db8, 0x2dbe},
  {0x2dc0, 0x2dc6}, {0x2dc8, 0x2dce}, {0x2dd0, 0x2dd6}, {0x2dd8, 0x2dde}, {0x2de0, 0x2dff}, {0x3005, 0x3007}, {0x3021, 0x302f}, {0x3031, 0x3035},
  {0x3038, 0x303c}, {0x3041, 0x3096}, {0x3099, 0x309a}, {0x309d, 0x309f}, {0x30a1, 0x30ff}, {0x3105, 0x312f}, {0x3131, 0x318e}, {0x31a0, 0x31bf},
  {0x31f0, 0x31ff}, {0x3400, 0x4dbf}, {0x4e00, 0xa48c}, {0xa4d0, 0xa4fd}, {0xa500, 0xa60c}, {0xa610, 0xa62b}, {0xa640, 0xa66f}, {0xa674, 0xa67d},
  {0xa67f, 0xa6f1}, {0xa717, 0xa71f}, {0xa722, 0xa788}, {0xa78b, 0xa7ca}, {0xa7d0, 0xa7d1}, {0xa7d3, 0xa7d3}, {0xa7d5, 0xa7d9}, {0xa7f2, 0xa827},
  {0xa82c, 0xa82c}, {0xa840, 0xa873}, {0xa880, 0xa8c5}, {0xa8d0, 0xa8d9}, {0xa8e0, 0xa8f7}, {0xa8fb, 0xa8fb}, {0xa8fd, 0xa92d}, {0xa930, 0xa953},
  {0xa960, 0xa97c}, {0xa980, 0xa9c0}, {0xa9cf, 0xa9d9}, {0xa9e0, 0xa9fe}, {0xaa00, 0xaa36}, {0xaa40, 0xaa4d}, {0xaa50, 0xaa59}, {0xaa60, 0xaa76},
  {0xaa7a, 0xaac2}, {0xaadb, 0xaadd}, {0xaae0, 0xaaef}, {0xaaf2, 0xaaf6}, {0xab01, 0xab06}, {0xab09, 0xab0e}, {0xab11, 0xab16}, {0xab20, 0xab26},
  {0xab28, 0xab2e}, {0xab30, 0xab5a}, {0xab5c, 0xab69}, {0xab70, 0xabea}, {0xabec, 0xabed}, {0xabf0, 0xabf9}, {0xac00, 0xd7a3}, {0xd7b0, 0xd7c6},
  {0xd7cb, 0xd7fb}, {0xf900, 0xfa6d}, {0xfa70, 0xfad9}, {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, {0xfb1d, 0xfb28}, {0xfb2a, 0xfb36}, {0xfb38, 0xfb3c},
  {0xfb3e, 0xfb3e}, {0xfb40, 0xfb41}, {0xfb43, 0xfb44}, {0xfb46, 0xfbb1}, {0xfbd3, 0xfc5d}, {0xfc64, 0xfd3d}, {0xfd50, 0xfd8f}, {0xfd92, 0xfdc7},
  {0xfdf0, 0xfdf9}, {0xfe00, 0xfe0f}, {0xfe20, 0xfe2f}, {0xfe33, 0xfe34}, {0xfe4d, 0xfe4f}, {0xfe71, 0xfe71}, {0xfe73, 0xfe73}, {0xfe77, 0xfe77},
  {0xfe79, 0xfe79}, {0xfe7b, 0xfe7b}, {0xfe7d, 0xfe7d}, {0xfe7f, 0xfefc}, {0xff10, 0xff19}, {0xff21, 0xff3a}, {0xff3f, 0xff3f}, {0xff41, 0xff5a},
  {0xff65, 0xffbe}, {0xffc2, 0xffc7}, {0xffca, 0xffcf}, {0xffd2, 0xffd7}, {0xffda, 0xffdc}, {0x10000, 0x1000b}, {0x1000d, 0x10026}, {0x10028, 0x1003a},
  {0x1003c, 0x1003d}, {0x1003f, 0x1004d}, {0x10050, 0x1005d}, {0x10080, 0x100fa}, {0x10140, 0x10174}, {0x101fd, 0x101fd}, {0x10280, 0x1029c}, {0x102a0, 0x102d0},
  {0x102e0, 0x102e0}, {0x10300, 0x1031f}, {0x1032d, 0x1034a}, {0x10350, 0x1037a}, {0x10380, 0x1039d}, {0x103a0, 0x103c3}, {0x103c8, 0x103cf}, {0x103d1, 0x103d5},
  {0x10400, 0x1049d}, {0x104a0, 0x104a9}, {0x104b0, 0x104d3}, {0x104d8, 0x104fb}, {0x10500, 0x10527}, {0x10530, 0x10563}, {0x10570, 0x1057a}, {0x1057c, 0x1058a},
  {0x1058c, 0x10592}, {0x10594, 0x10595}, {0x10597, 0x105a1}, {0x105a3, 0x105b1}, {0x105b3, 0x105b9}, {0x105bb, 0x105bc}, {0x10600, 0x10736}, {0x10740, 0x10755},
  {0x10760, 0x10767}, {0x10780, 0x10785}, {0x10787, 0x107b0}, {0x107b2, 0x107ba}, {0x10800, 0x10805}, {0x10808, 0x10808}, {0x1080a, 0x10835}, {0x10837, 0x10838},
  {0x1083c, 0x1083c}, {0x1083f, 0x10855}, {0x10860, 0x10876}, {0x10880, 0x1089e}, {0x108e0, 0x108f2}, {0x108f4, 0x108f5}, {0x10900, 0x10915}, {0x10920, 0x10939},
  {0x10980, 0x109b7}, {0x109be, 0x109bf}, {0x10a00, 0x10a03}, {0x10a05, 0x10a06}, {0x10a0c, 0x10a13}, {0x10a15, 0x10a17}, {0x10a19, 0x10a35}, {0x10a38, 0x10a3a},
  {0x10a3f, 0x10a3f}, {0x10a60, 0x10a7c}, {0x10a80, 0x10a9c}, {0x10ac0, 0x10ac7}, {0x10ac9, 0x10ae6}, {0x10b00, 0x10b35}, {0x10b40, 0x10b55}, {0x10b60, 0x10b72},
  {0x10b80, 0x10b91}, {0x10c00, 0x10c48}, {0x10c80, 0x10cb2}, {0x10cc0, 0x10cf2}, {0x10d00, 0x10d27}, {0x10d30, 0x10d39}, {0x10e80, 0x10ea9}, {0x10eab, 0x10eac},
  {0x10eb0, 0x10eb1}, {0x10efd, 0x10f1c}, {0x10f27, 0x10f27}, {0x10f30, 0x10f50}, {0x10f70, 0x10f85}, {0x10fb0, 0x10fc4}, {0x10fe0, 0x10ff6}, {0x11000, 0x11046},
  {0x11066, 0x11075}, {0x1107f, 0x110ba}, {0x110c2, 0x110c2}, {0x110d0, 0x110e8}, {0x110f0, 0x110f9}, {0x11100, 0x11134}, {0x11136, 0x1113f}, {0x11144, 0x11147},
  {0x11150, 0x11173}, {0x11176, 0x11176}, {0x11180, 0x111c4}, {0x111c9, 0x111cc}, {0x111ce, 0x111da}, {0x111dc, 0x111dc}, {0x11200, 0x11211}, {0x11213, 0x11237},
  {0x1123e, 0x11241}, {0x11280, 0x11286}, {0x11288, 0x11288}, {0x1128a, 0x1128d}, {0x1128f, 0x1129d}, {0x1129f, 0x112a8}, {0x112b0, 0x112ea}, {0x112f0, 0x112f9},
  {0x11300, 0x11303}, {0x11305, 0x1130c}, {0x1130f, 0x11310}, {0x11313, 0x11328}, {0x1132a, 0x11330}, {0x11332, 0x11333}, {0x11335, 0x11339}, {0x1133b, 0x11344},
  {0x11347, 0x11348}, {0x1134b, 0x1134d}, {0x11350, 0x11350}, {0x11357, 0x11357}, {0x1135d, 0x11363}, {0x11366, 0x1136c}, {0x11370, 0x11374}, {0x11400, 0x1144a},
  {0x11450, 0x11459}, {0x1145e, 0x11461}, {0x11480, 0x114c5}, {0x114c7, 0x114c7}, {0x114d0, 0x114d9}, {0x11580, 0x115b5}, {0x115b8, 0x115c0}, {0x115d8, 0x115dd},
  {0x11600, 0x11640}, {0x11644, 0x11644}, {0x11650, 0x11659}, {0x11680, 0x116b8}, {0x116c0, 0x116c9}, {0x11700, 0x1171a}, {0x1171d, 0x1172b}, {0x11730, 0x11739},
  {0x11740, 0x11746}, {0x11800, 0x1183a}, {0x118a0, 0x118e9}, {0x118ff, 0x11906}, {0x11909, 0x11909}, {0x1190c, 0x11913}, {0x11915, 0x11916}, {0x11918, 0x11935},
  {0x11937, 0x11938}, {0x1193b, 0x11943}, {0x11950, 0x11959}, {0x119a0, 0x119a7}, {0x119aa, 0x119d7}, {0x119da, 0x119e1}, {0x119e3, 0x119e4}, {0x11a00, 0x11a3e},
  {0x11a47, 0x11a47}, {0x11a50, 0x11a99}, {0x11a9d, 0x11a9d}, {0x11ab0, 0x11af8}, {0x11c00, 0x11c08}, {0x11c0a, 0x11c36}, {0x11c38, 0x11c40}, {0x11c50, 0x11c59},
  {0x11c72, 0x11c8f}, {0x11c92, 0x11ca7}, {0x11ca9, 0x11cb6}, {0x11d00, 0x11d06}, {0x11d08, 0x11d09}, {0x11d0b, 0x11d36}, {0x11d3a, 0x11d3a}, {0x11d3c, 0x11d3d},
  {0x11d3f, 0x11d47}, {0x11d50, 0x11d59}, {0x11d60, 0x11d65}, {0x11d67, 0x11d68}, {0x11d6a, 0x11d8e}, {0x11d90, 0x11d91}, {0x11d93, 0x11d98}, {0x11da0, 0x11da9},
  {0x11ee0, 0x11ef6}, {0x11f00, 0x11f10}, {0x11f12, 0x11f3a}, {0x11f3e, 0x11f42}, {0x11f50, 0x11f59}, {0x11fb0, 0x11fb0}, {0x12000, 0x12399}, {0x12400, 0x1246e},
  {0x12480, 0x12543}, {0x12f90, 0x12ff0}, {0x13000, 0x1342f}, {0x13440, 0x13455}, {0x14400, 0x14646}, {0x16800, 0x16a38}, {0x16a40, 0x16a5e}, {0x16a60, 0x16a69},
  {0x16a70, 0x16abe}, {0x16ac0, 0x16ac9}, {0x16ad0, 0x16aed}, {0x16af0, 0x16af4}, {0x16b00, 0x16b36}, {0x16b40, 0x16b43}, {0x16b50, 0x16b59}, {0x16b63, 0x16b77},
  {0x16b7d, 0x16b8f}, {0x16e40, 0x16e7f}, {0x16f00, 0x16f4a}, {0x16f4f, 0x16f87}, {0x16f8f, 0x16f9f}, {0x16fe0, 0x16fe1}, {0x16fe3, 0x16fe4}, {0x16ff0, 0x16ff1},
  {0x17000, 0x187f7}, {0x18800, 0x18cd5}, {0x18d00, 0x18d08}, {0x1aff0, 0x1aff3}, {0x1aff5, 0x1affb}, {0x1affd, 0x1affe}, {0x1b000, 0x1b122}, {0x1b132, 0x1b132},
  {0x1b150, 0x1b152}, {0x1b155, 0x1b155}, {0x1b164, 0x1b167}, {0x1b170, 0x1b2fb}, {0x1bc00, 0x1bc6a}, {0x1bc70, 0x1bc7c}, {0x1bc80, 0x1bc88}, {0x1bc90, 0x1bc99},
  {0x1bc9d, 0x1bc9e}, {0x1cf00, 0x1cf2d}, {0x1cf30, 0x1cf46}, {0x1d165, 0x1d169}, {0x1d16d, 0x1d172}, {0x1d17b, 0x1d182}, {0x1d185, 0x1d18b}, {0x1d1aa, 0x1d1ad},
  {0x1d242, 0x1d244}, {0x1d400, 0x1d454}, {0x1d456, 0x1d49c}, {0x1d49e, 0x1d49f}, {0x1d4a2, 0x1d4a2}, {0x1d4a5, 0x1d4a6}, {0x1d4a9, 0x1d4ac}, {0x1d4ae, 0x1d4b9},
  {0x1d4bb, 0x1d4bb}, {0x1d4bd, 0x1d4c3}, {0x1d4c5, 0x1d505}, {0x1d507, 0x1d50a}, {0x1d50d, 0x1d514}, {0x1d516, 0x1d51c}, {0x1d51e, 0x1d539}, {0x1d53b, 0x1d53e},
  {0x1d540, 0x1d544}, {0x1d546, 0x1d546}, {0x1d54a, 0x1d550}, {0x1d552, 0x1d6a5}, {0x1d6a8, 0x1d6c0}, {0x1d6c2, 0x1d6da}, {0x1d6dc, 0x1d6fa}, {0x1d6fc, 0x1d714},
  {0x1d716, 0x1d734}, {0x1d736, 0x1d74e}, {0x1d750, 0x1d76e}, {0x1d770, 0x1d788}, {0x1d78a, 0x1d7a8}, {0x1d7aa, 0x1d7c2}, {0x1d7c4, 0x1d7cb}, {0x1d7ce, 0x1d7ff},
  {0x1da00, 0x1da36}, {0x1da3b, 0x1da6c}, {0x1da75, 0x1da75}, {0x1da84, 0x1da84}, {0x1da9b, 0x1da9f}, {0x1daa1, 0x1daaf}, {0x1df00, 0x1df1e}, {0x1df25, 0x1df2a},
  {0x1e000, 0x1e006}, {0x1e008, 0x1e018}, {0x1e01b, 0x1e021}, {0x1e023, 0x1e024}, {0x1e026, 0x1e02a}, {0x1e030, 0x1e06d}, {0x1e08f, 0x1e08f}, {0x1e100, 0x1e12c},
  {0x1e130, 0x1e13d}, {0x1e140, 0x1e149}, {0x1e14e, 0x1e14e}, {0x1e290, 0x1e2ae}, {0x1e2c0, 0x1e2f9}, {0x1e4d0, 0x1e4f9}, {0x1e7e0, 0x1e7e6}, {0x1e7e8, 0x1e7eb},
  {0x1e7ed, 0x1e7ee}, {0x1e7f0, 0x1e7fe}, {0x1e800, 0x1e8c4}, {0x1e8d0, 0x1e8d6}, {0x1e900, 0x1e94b}, {0x1e950, 0x1e959}, {0x1ee00, 0x1ee03}, {0x1ee05, 0x1ee1f},
  {0x1ee21, 0x1ee22}, {0x1ee24, 0x1ee24}, {0x1ee27, 0x1ee27}, {0x1ee29, 0x1ee32}, {0x1ee34, 0x1ee37}, {0x1ee39, 0x1ee39}, {0x1ee3b, 0x1ee3b}, {0x1ee42, 0x1ee42},
  {0x1ee47, 0x1ee47}, {0x1ee49, 0x1ee49}, {0x1ee4b, 0x1ee4b}, {0x1ee4d, 0x1ee4f}, {0x1ee51, 0x1ee52}, {0x1ee54, 0x1ee54}, {0x1ee57, 0x1ee57}, {0x1ee59, 0x1ee59},
  {0x1ee5b, 0x1ee5b}, {0x1ee5d, 0x1ee5d}, {0x1ee5f, 0x1ee5f}, {0x1ee61, 0x1ee62}, {0x1ee64, 0x1ee64}, {0x1ee67, 0x1ee6a}, {0x1ee6c, 0x1ee72}, {0x1ee74, 0x1ee77},
  {0x1ee79, 0x1ee7c}, {0x1ee7e, 0x1ee7e}, {0x1ee80, 0x1ee89}, {0x1ee8b, 0x1ee9b}, {0x1eea1, 0x1eea3}, {0x1eea5, 0x1eea9}, {0x1eeab, 0x1eebb}, {0x1fbf0, 0x1fbf9},
  {0x20000, 0x2a6df}, {0x2a700, 0x2b739}, {0x2b740, 0x2b81d}, {0x2b820, 0x2cea1}, {0x2ceb0, 0x2ebe0}, {0x2ebf0, 0x2ee5d}, {0x2f800, 0x2fa1d}, {0x30000, 0x3134a},
  {0x31350, 0x323af}, {0xe0100, 0xe01ef},
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(121);
      ADVANCE_MAP(
        '!', 188,
        '"', 287,
        '#', 75,
        '%', 205,
        '&', 214,
        '\'', 278,
        '(', 125,
        ')', 128,
        '*', 201,
        '+', 196,
        ',', 127,
        '-', 191,
        '.', 254,
        '/', 203,
        '0', 260,
        ':', 238,
        ';', 227,
        '<', 221,
        '=', 237,
        '>', 217,
        '?', 239,
        'L', 302,
        'U', 304,
        '[', 234,
        '\\', 2,
        ']', 235,
        '^', 211,
        'u', 306,
        '{', 231,
        '|', 208,
        '}', 232,
        '~', 189,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(119);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(262);
      if (set_contains(sym_identifier_character_set_1, 670, lookahead)) ADVANCE(314);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(43);
      END_STATE();
    case 2:
      if (lookahead == '\n') SKIP(43);
      if (lookahead == '\r') SKIP(1);
      if (lookahead == 'U') ADVANCE(116);
      if (lookahead == 'u') ADVANCE(108);
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(46);
      END_STATE();
    case 4:
      if (lookahead == '\n') SKIP(46);
      if (lookahead == '\r') SKIP(3);
      if (lookahead == 'U') ADVANCE(116);
      if (lookahead == 'u') ADVANCE(108);
      END_STATE();
    case 5:
      if (lookahead == '\n') SKIP(45);
      END_STATE();
    case 6:
      if (lookahead == '\n') SKIP(45);
      if (lookahead == '\r') SKIP(5);
      if (lookahead == 'U') ADVANCE(116);
      if (lookahead == 'u') ADVANCE(108);
      END_STATE();
    case 7:
      if (lookahead == '\n') SKIP(47);
      END_STATE();
    case 8:
      if (lookahead == '\n') SKIP(47);
      if (lookahead == '\r') SKIP(7);
      if (lookahead == 'U') ADVANCE(116);
      if (lookahead == 'u') ADVANCE(108);
      END_STATE();
    case 9:
      if (lookahead == '\n') SKIP(49);
      END_STATE();
    case 10:
      if (lookahead == '\n') SKIP(49);
      if (lookahead == '\r') SKIP(9);
      if (lookahead == 'U') ADVANCE(116);
      if (lookahead == 'u') ADVANCE(108);
      END_STATE();
    case 11:
      if (lookahead == '\n') SKIP(53);
      END_STATE();
    case 12:
      if (lookahead == '\n') SKIP(53);
      if (lookahead == '\r') SKIP(11);
      if (lookahead == 'U') ADVANCE(116);
      if (lookahead == 'u') ADVANCE(108);
      END_STATE();
    case 13:
      if (lookahead == '\n') SKIP(52);
      END_STATE();
    case 14:
      if (lookahead == '\n') SKIP(52);
      if (lookahead == '\r') SKIP(13);
      if (lookahead == 'U') ADVANCE(116);
      if (lookahead == 'u') ADVANCE(108);
      END_STATE();
    case 15:
      if (lookahead == '\n') SKIP(57);
      END_STATE();
    case 16:
      if (lookahead == '\n') SKIP(57);
      if (lookahead == '\r') SKIP(15);
      if (lookahead == 'U') ADVANCE(116);
      if (lookahead == 'u') ADVANCE(108);
      END_STATE();
    case 17:
      if (lookahead == '\n') SKIP(50);
      END_STATE();
    case 18:
      if (lookahead == '\n') SKIP(50);
      if (lookahead == '\r') SKIP(17);
      if (lookahead == 'U') ADVANCE(116);
      if (lookahead == 'u') ADVANCE(108);
      END_STATE();
    case 19:
      if (lookahead == '\n') SKIP(51);
      END_STATE();
    case 20:
      if (lookahead == '\n') SKIP(51);
      if (lookahead == '\r') SKIP(19);
      if (lookahead == 'U') ADVANCE(116);
      if (lookahead == 'u') ADVANCE(108);
      END_STATE();
    case 21:
      if (lookahead == '\n') SKIP(48);
      END_STATE();
    case 22:
      if (lookahead == '\n') SKIP(48);
      if (lookahead == '\r') SKIP(21);
      if (lookahead == 'U') ADVANCE(116);
      if (lookahead == 'u') ADVANCE(108);
      END_STATE();
    case 23:
      if (lookahead == '\n') SKIP(25);
      END_STATE();
    case 24:
      if (lookahead == '\n') SKIP(25);
      if (lookahead == '\r') SKIP(23);
      END_STATE();
    case 25:
      ADVANCE_MAP(
        '\n', 130,
        '!', 68,
        '%', 204,
        '&', 213,
        '(', 186,
        '*', 200,
        '+', 195,
        '-', 190,
        '/', 202,
        '<', 222,
        '=', 69,
        '>', 218,
      );
      if (lookahead == '\\') SKIP(24);
      if (lookahead == '^') ADVANCE(210);
      if (lookahead == '|') ADVANCE(209);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(25);
      END_STATE();
    case 26:
      if (lookahead == '\n') SKIP(56);
      END_STATE();
    case 27:
      if (lookahead == '\n') SKIP(56);
      if (lookahead == '\r') SKIP(26);
      if (lookahead == 'U') ADVANCE(116);
      if (lookahead == 'u') ADVANCE(108);
      END_STATE();
    case 28:
      if (lookahead == '\n') SKIP(54);
      END_STATE();
    case 29:
      if (lookahead == '\n') SKIP(54);
      if (lookahead == '\r') SKIP(28);
      if (lookahead == 'U') ADVANCE(116);
      if (lookahead == 'u') ADVANCE(108);
      END_STATE();
    case 30:
      if (lookahead == '\n') SKIP(58);
      if (lookahead == '\'') ADVANCE(278);
      if (lookahead == '/') ADVANCE(281);
      if (lookahead == '\\') ADVANCE(280);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(282);
      if (lookahead != 0) ADVANCE(279);
      END_STATE();
    case 31:
      if (lookahead == '\n') ADVANCE(294);
      if (lookahead == '\r') ADVANCE(293);
      if (lookahead == 'U') ADVANCE(117);
      if (lookahead == 'u') ADVANCE(109);
      if (lookahead == 'x') ADVANCE(103);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(296);
      if (lookahead != 0) ADVANCE(293);
      END_STATE();
    case 32:
      if (lookahead == '\n') ADVANCE(123);
      if (lookahead == '\r') ADVANCE(36);
      if (lookahead == '(') ADVANCE(125);
      if (lookahead == '/') ADVANCE(151);
      if (lookahead == '\\') ADVANCE(146);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(66);
      if (lookahead != 0) ADVANCE(153);
      END_STATE();
    case 33:
      if (lookahead == '\n') ADVANCE(123);
      if (lookahead == '\r') ADVANCE(36);
      if (lookahead == '/') ADVANCE(151);
      if (lookahead == '\\') ADVANCE(146);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(66);
      if (lookahead != 0) ADVANCE(153);
      END_STATE();
    case 34:
      if (lookahead == '\n') ADVANCE(123);
      if (lookahead == '\r') ADVANCE(35);
      if (lookahead == '(') ADVANCE(186);
      if (lookahead == '/') ADVANCE(60);
      if (lookahead == '\\') SKIP(39);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(59);
      END_STATE();
    case 35:
      if (lookahead == '\n') ADVANCE(123);
      if (lookahead == '(') ADVANCE(186);
      if (lookahead == '/') ADVANCE(60);
      if (lookahead == '\\') SKIP(39);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(59);
      END_STATE();
    case 36:
      if (lookahead == '\n') ADVANCE(123);
      if (lookahead == '/') ADVANCE(151);
      if (lookahead == '\\') ADVANCE(146);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(66);
      if (lookahead != 0) ADVANCE(153);
      END_STATE();
    case 37:
      if (lookahead == '\n') SKIP(55);
      if (lookahead == '"') ADVANCE(287);
      if (lookahead == '/') ADVANCE(288);
      if (lookahead == '\\') ADVANCE(31);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(291);
      if (lookahead != 0) ADVANCE(292);
      END_STATE();
    case 38:
      if (lookahead == '\n') SKIP(59);
      END_STATE();
    case 39:
      if (lookahead == '\n') SKIP(59);
      if (lookahead == '\r') SKIP(38);
      END_STATE();
    case 40:
      if (lookahead == '\n') SKIP(44);
      END_STATE();
    case 41:
      if (lookahead == '\n') SKIP(44);
      if (lookahead == '\r') SKIP(40);
      if (lookahead == 'U') ADVANCE(116);
      if (lookahead == 'u') ADVANCE(108);
      END_STATE();
    case 42:
      if (lookahead == '\r') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(317);
      if (lookahead != 0) ADVANCE(322);
      END_STATE();
    case 43:
      ADVANCE_MAP(
        '!', 188,
        '"', 287,
        '#', 75,
        '%', 205,
        '&', 214,
        '\'', 278,
        '(', 186,
        ')', 128,
        '*', 201,
        '+', 196,
        ',', 127,
        '-', 191,
        '.', 254,
        '/', 203,
        '0', 260,
        ':', 238,
        ';', 227,
        '<', 221,
        '=', 237,
        '>', 217,
        '?', 239,
        'L', 302,
        'U', 304,
        '[', 234,
        '\\', 2,
        ']', 235,
        '^', 211,
        'u', 306,
        '{', 231,
        '|', 208,
        '}', 232,
        '~', 189,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(43);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(262);
      if (set_contains(sym_identifier_character_set_1, 670, lookahead)) ADVANCE(314);
      END_STATE();
    case 44:
      ADVANCE_MAP(
        '!', 188,
        '"', 287,
        '#', 83,
        '%', 205,
        '&', 214,
        '\'', 278,
        '(', 186,
        ')', 128,
        '*', 201,
        '+', 196,
        ',', 127,
        '-', 191,
        '.', 254,
        '/', 203,
        '0', 260,
        ':', 238,
        ';', 227,
        '<', 221,
        '=', 237,
        '>', 217,
        '?', 239,
        'L', 302,
        'U', 304,
        '[', 233,
        '\\', 41,
        ']', 235,
        '^', 211,
        'u', 306,
        '{', 231,
        '|', 208,
        '}', 232,
        '~', 189,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(44);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(262);
      if (set_contains(sym_identifier_character_set_1, 670, lookahead)) ADVANCE(314);
      END_STATE();
    case 45:
      ADVANCE_MAP(
        '!', 187,
        '"', 287,
        '#', 75,
        '&', 212,
        '\'', 278,
        '(', 186,
        '*', 200,
        '+', 197,
        ',', 127,
        '-', 192,
        '.', 96,
        '/', 60,
        '0', 260,
        ':', 67,
        ';', 227,
        'L', 302,
        'U', 304,
        '[', 73,
        '\\', 6,
        ']', 74,
        'u', 306,
        '{', 231,
        '~', 189,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(45);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(262);
      if (set_contains(sym_identifier_character_set_1, 670, lookahead)) ADVANCE(314);
      END_STATE();
    case 46:
      ADVANCE_MAP(
        '!', 187,
        '"', 287,
        '#', 79,
        '&', 212,
        '\'', 278,
        '(', 186,
        ')', 128,
        '*', 200,
        '+', 197,
        ',', 127,
        '-', 192,
        '.', 255,
        '/', 60,
        '0', 260,
        ':', 238,
        ';', 227,
        '=', 236,
        'L', 302,
        'U', 304,
        '[', 234,
        '\\', 4,
        ']', 235,
        'u', 306,
        '{', 231,
        '}', 232,
        '~', 189,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(46);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(262);
      if (set_contains(sym_identifier_character_set_1, 670, lookahead)) ADVANCE(314);
      END_STATE();
    case 47:
      ADVANCE_MAP(
        '!', 187,
        '"', 287,
        '#', 77,
        '&', 212,
        '\'', 278,
        '(', 186,
        '*', 200,
        '+', 197,
        '-', 192,
        '.', 96,
        '/', 60,
        '0', 260,
        ';', 227,
        'L', 302,
        'U', 304,
        '[', 73,
        '\\', 8,
        'u', 306,
        '{', 231,
        '~', 189,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(47);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(262);
      if (set_contains(sym_identifier_character_set_1, 670, lookahead)) ADVANCE(314);
      END_STATE();
    case 48:
      ADVANCE_MAP(
        '!', 187,
        '\'', 278,
        '(', 186,
        ')', 128,
        '+', 199,
        '-', 194,
        '.', 96,
        '/', 60,
        '0', 260,
        'L', 310,
        'U', 311,
        '\\', 22,
        'u', 312,
        '~', 189,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(48);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(262);
      if (set_contains(sym_identifier_character_set_1, 670, lookahead)) ADVANCE(314);
      END_STATE();
    case 49:
      ADVANCE_MAP(
        '!', 68,
        '"', 287,
        '#', 83,
        '%', 205,
        '&', 214,
        '(', 186,
        ')', 128,
        '*', 201,
        '+', 198,
        ',', 127,
        '-', 193,
        '.', 253,
        '/', 203,
        ':', 238,
        ';', 227,
        '<', 221,
        '=', 237,
        '>', 217,
        '?', 239,
        'L', 303,
        'U', 305,
        '[', 234,
        '\\', 10,
        ']', 235,
        '^', 211,
        'u', 307,
        '|', 208,
        '}', 232,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(49);
      if (set_contains(sym_identifier_character_set_1, 670, lookahead)) ADVANCE(314);
      END_STATE();
    case 50:
      ADVANCE_MAP(
        '!', 68,
        '#', 83,
        '%', 205,
        '&', 214,
        '(', 186,
        ')', 128,
        '*', 201,
        '+', 198,
        ',', 127,
        '-', 193,
        '.', 253,
        '/', 203,
        ':', 238,
        ';', 227,
        '<', 221,
        '=', 237,
        '>', 217,
        '?', 239,
        '[', 234,
        '\\', 18,
        ']', 235,
        '^', 211,
        '{', 231,
        '|', 208,
        '}', 232,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(50);
      if (set_contains(sym_identifier_character_set_1, 670, lookahead)) ADVANCE(314);
      END_STATE();
    case 51:
      ADVANCE_MAP(
        '!', 68,
        '#', 83,
        '%', 205,
        '&', 214,
        '(', 186,
        ')', 128,
        '*', 201,
        '+', 198,
        ',', 127,
        '-', 193,
        '.', 252,
        '/', 203,
        ':', 238,
        ';', 227,
        '<', 221,
        '=', 237,
        '>', 217,
        '?', 239,
        '[', 233,
        '\\', 20,
        ']', 74,
        '^', 211,
        '|', 208,
        '}', 232,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(51);
      if (set_contains(sym_identifier_character_set_1, 670, lookahead)) ADVANCE(314);
      END_STATE();
    case 52:
      ADVANCE_MAP(
        '!', 68,
        '#', 80,
        '%', 204,
        '&', 213,
        '(', 186,
        ')', 128,
        '*', 200,
        '+', 195,
        ',', 127,
        '-', 190,
        '/', 202,
        ';', 227,
        '<', 222,
        '=', 237,
        '>', 218,
        '[', 234,
        '\\', 14,
        '^', 210,
        '{', 231,
        '|', 209,
        '}', 232,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(52);
      if (set_contains(sym_identifier_character_set_1, 670, lookahead)) ADVANCE(314);
      END_STATE();
    case 53:
      ADVANCE_MAP(
        '!', 68,
        '#', 76,
        '%', 205,
        '&', 214,
        '(', 186,
        ')', 128,
        '*', 201,
        '+', 198,
        ',', 127,
        '-', 193,
        '.', 253,
        '/', 203,
        ':', 238,
        ';', 227,
        '<', 221,
        '=', 237,
        '>', 217,
        '?', 239,
        '[', 234,
        '\\', 12,
        '^', 211,
        '{', 231,
        '|', 208,
        '}', 232,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(53);
      if (set_contains(sym_identifier_character_set_1, 670, lookahead)) ADVANCE(314);
      END_STATE();
    case 54:
      if (lookahead == '"') ADVANCE(287);
      if (lookahead == '/') ADVANCE(60);
      if (lookahead == '<') ADVANCE(70);
      if (lookahead == 'L') ADVANCE(303);
      if (lookahead == 'U') ADVANCE(305);
      if (lookahead == '\\') ADVANCE(29);
      if (lookahead == 'u') ADVANCE(307);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(54);
      if (set_contains(sym_identifier_character_set_1, 670, lookahead)) ADVANCE(314);
      END_STATE();
    case 55:
      if (lookahead == '"') ADVANCE(287);
      if (lookahead == '/') ADVANCE(60);
      if (lookahead == '\\') ADVANCE(31);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(55);
      END_STATE();
    case 56:
      if (lookahead == '#') ADVANCE(93);
      if (lookahead == '/') ADVANCE(60);
      if (lookahead == '\\') ADVANCE(27);
      if (lookahead == '}') ADVANCE(232);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(56);
      if (set_contains(sym_identifier_character_set_1, 670, lookahead)) ADVANCE(314);
      END_STATE();
    case 57:
      if (lookahead == '#') ADVANCE(78);
      if (lookahead == '/') ADVANCE(60);
      if (lookahead == '[') ADVANCE(73);
      if (lookahead == '\\') ADVANCE(16);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(57);
      if (set_contains(sym_identifier_character_set_1, 670, lookahead)) ADVANCE(314);
      END_STATE();
    case 58:
      if (lookahead == '\'') ADVANCE(278);
      if (lookahead == '/') ADVANCE(60);
      if (lookahead == '\\') ADVANCE(31);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(58);
      END_STATE();
    case 59:
      if (lookahead == '(') ADVANCE(186);
      if (lookahead == '/') ADVANCE(60);
      if (lookahead == '\\') SKIP(39);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(59);
      END_STATE();
    case 60:
      if (lookahead == '*') ADVANCE(62);
      if (lookahead == '/') ADVANCE(322);
      END_STATE();
    case 61:
      if (lookahead == '*') ADVANCE(61);
      if (lookahead == '/') ADVANCE(315);
      if (lookahead != 0) ADVANCE(62);
      END_STATE();
    case 62:
      if (lookahead == '*') ADVANCE(61);
      if (lookahead != 0) ADVANCE(62);
      END_STATE();
    case 63:
      if (lookahead == '*') ADVANCE(61);
      if (lookahead != 0) ADVANCE(144);
      END_STATE();
    case 64:
      if (lookahead == '.') ADVANCE(96);
      if (lookahead == '0') ADVANCE(258);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(259);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(268);
      END_STATE();
    case 65:
      if (lookahead == '.') ADVANCE(126);
      END_STATE();
    case 66:
      if (lookahead == '/') ADVANCE(151);
      if (lookahead == '\\') ADVANCE(146);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(66);
      if (lookahead != 0) ADVANCE(153);
      END_STATE();
    case 67:
      if (lookahead == ':') ADVANCE(228);
      END_STATE();
    case 68:
      if (lookahead == '=') ADVANCE(216);
      END_STATE();
    case 69:
      if (lookahead == '=') ADVANCE(215);
      END_STATE();
    case 70:
      if (lookahead == '>') ADVANCE(300);
      if (lookahead == '\\') ADVANCE(71);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(70);
      END_STATE();
    case 71:
      if (lookahead == '>') ADVANCE(301);
      if (lookahead == '\\') ADVANCE(71);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(70);
      END_STATE();
    case 72:
      if (lookahead == 'U') ADVANCE(116);
      if (lookahead == 'u') ADVANCE(108);
      END_STATE();
    case 73:
      if (lookahead == '[') ADVANCE(229);
      END_STATE();
    case 74:
      if (lookahead == ']') ADVANCE(230);
      END_STATE();
    case 75:
      if (lookahead == 'd') ADVANCE(160);
      if (lookahead == 'e') ADVANCE(180);
      if (lookahead == 'i') ADVANCE(168);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(75);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(185);
      END_STATE();
    case 76:
      if (lookahead == 'd') ADVANCE(160);
      if (lookahead == 'e') ADVANCE(180);
      if (lookahead == 'i') ADVANCE(169);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(76);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(185);
      END_STATE();
    case 77:
      if (lookahead == 'd') ADVANCE(160);
      if (lookahead == 'e') ADVANCE(182);
      if (lookahead == 'i') ADVANCE(168);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(77);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(185);
      END_STATE();
    case 78:
      if (lookahead == 'd') ADVANCE(160);
      if (lookahead == 'e') ADVANCE(182);
      if (lookahead == 'i') ADVANCE(169);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(78);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(185);
      END_STATE();
    case 79:
      if (lookahead == 'd') ADVANCE(160);
      if (lookahead == 'i') ADVANCE(168);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(79);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(185);
      END_STATE();
    case 80:
      if (lookahead == 'd') ADVANCE(160);
      if (lookahead == 'i') ADVANCE(169);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(80);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(185);
      END_STATE();
    case 81:
      if (lookahead == 'd') ADVANCE(92);
      END_STATE();
    case 82:
      if (lookahead == 'd') ADVANCE(86);
      END_STATE();
    case 83:
      if (lookahead == 'e') ADVANCE(94);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(83);
      END_STATE();
    case 84:
      if (lookahead == 'e') ADVANCE(135);
      END_STATE();
    case 85:
      if (lookahead == 'e') ADVANCE(89);
      END_STATE();
    case 86:
      if (lookahead == 'e') ADVANCE(90);
      END_STATE();
    case 87:
      if (lookahead == 'f') ADVANCE(137);
      END_STATE();
    case 88:
      if (lookahead == 'f') ADVANCE(131);
      END_STATE();
    case 89:
      if (lookahead == 'f') ADVANCE(139);
      END_STATE();
    case 90:
      if (lookahead == 'f') ADVANCE(141);
      END_STATE();
    case 91:
      if (lookahead == 'i') ADVANCE(87);
      if (lookahead == 's') ADVANCE(84);
      END_STATE();
    case 92:
      if (lookahead == 'i') ADVANCE(88);
      END_STATE();
    case 93:
      if (lookahead == 'i') ADVANCE(169);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(93);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(185);
      END_STATE();
    case 94:
      if (lookahead == 'l') ADVANCE(91);
      if (lookahead == 'n') ADVANCE(81);
      END_STATE();
    case 95:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(262);
      END_STATE();
    case 96:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(257);
      END_STATE();
    case 97:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(259);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(268);
      END_STATE();
    case 98:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(314);
      END_STATE();
    case 99:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(265);
      END_STATE();
    case 100:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(268);
      END_STATE();
    case 101:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(263);
      END_STATE();
    case 102:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(293);
      END_STATE();
    case 103:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(299);
      END_STATE();
    case 104:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(98);
      END_STATE();
    case 105:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(102);
      END_STATE();
    case 106:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(104);
      END_STATE();
    case 107:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(105);
      END_STATE();
    case 108:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(106);
      END_STATE();
    case 109:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(107);
      END_STATE();
    case 110:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(108);
      END_STATE();
    case 111:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(109);
      END_STATE();
    case 112:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(110);
      END_STATE();
    case 113:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(111);
      END_STATE();
    case 114:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(112);
      END_STATE();
    case 115:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(113);
      END_STATE();
    case 116:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(114);
      END_STATE();
    case 117:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(115);
      END_STATE();
    case 118:
      if (lookahead != 0 &&
          lookahead != '*') ADVANCE(153);
      END_STATE();
    case 119:
      if (eof) ADVANCE(121);
      ADVANCE_MAP(
        '!', 188,
        '"', 287,
        '#', 75,
        '%', 205,
        '&', 214,
        '\'', 278,
        '(', 186,
        ')', 128,
        '*', 201,
        '+', 196,
        ',', 127,
        '-', 191,
        '.', 254,
        '/', 203,
        '0', 260,
        ':', 238,
        ';', 227,
        '<', 221,
        '=', 237,
        '>', 217,
        '?', 239,
        'L', 302,
        'U', 304,
        '[', 234,
        '\\', 2,
        ']', 235,
        '^', 211,
        'u', 306,
        '{', 231,
        '|', 208,
        '}', 232,
        '~', 189,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(119);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(262);
      if (set_contains(sym_identifier_character_set_1, 670, lookahead)) ADVANCE(314);
      END_STATE();
    case 120:
      if (eof) ADVANCE(121);
      ADVANCE_MAP(
        '!', 187,
        '"', 287,
        '#', 79,
        '&', 212,
        '\'', 278,
        '(', 186,
        ')', 128,
        '*', 200,
        '+', 197,
        ',', 127,
        '-', 192,
        '.', 255,
        '/', 60,
        '0', 260,
        ':', 238,
        ';', 227,
        '=', 236,
        'L', 302,
        'U', 304,
        '[', 234,
        '\\', 4,
        ']', 235,
        'u', 306,
        '{', 231,
        '}', 232,
        '~', 189,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(120);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(262);
      if (set_contains(sym_identifier_character_set_1, 670, lookahead)) ADVANCE(314);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(aux_sym_preproc_include_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(185);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(aux_sym_preproc_include_token2);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(aux_sym_preproc_def_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(185);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(aux_sym_preproc_if_token1);
      if (lookahead == 'd') ADVANCE(164);
      if (lookahead == 'n') ADVANCE(158);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(185);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(130);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(aux_sym_preproc_if_token2);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(aux_sym_preproc_if_token2);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(185);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(aux_sym_preproc_ifdef_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(185);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(aux_sym_preproc_ifdef_token2);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(185);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(aux_sym_preproc_else_token1);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(aux_sym_preproc_else_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(185);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(aux_sym_preproc_elif_token1);
      if (lookahead == 'd') ADVANCE(85);
      if (lookahead == 'n') ADVANCE(82);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(aux_sym_preproc_elif_token1);
      if (lookahead == 'd') ADVANCE(166);
      if (lookahead == 'n') ADVANCE(159);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(185);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(aux_sym_preproc_elifdef_token1);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(aux_sym_preproc_elifdef_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(185);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(aux_sym_preproc_elifdef_token2);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(aux_sym_preproc_elifdef_token2);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(185);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '\n') ADVANCE(62);
      if (lookahead == '*') ADVANCE(143);
      if (lookahead == '/') ADVANCE(315);
      if (lookahead == '\\') ADVANCE(149);
      if (lookahead != 0) ADVANCE(144);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '\n') ADVANCE(62);
      if (lookahead == '*') ADVANCE(143);
      if (lookahead == '/') ADVANCE(63);
      if (lookahead == '\\') ADVANCE(149);
      if (lookahead != 0) ADVANCE(144);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '\n') ADVANCE(322);
      if (lookahead == '\r') ADVANCE(316);
      if (lookahead == '/') ADVANCE(319);
      if (lookahead == '\\') ADVANCE(318);
      if (lookahead != 0) ADVANCE(320);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '\n') SKIP(66);
      if (lookahead == '\r') ADVANCE(147);
      if (lookahead == '/') ADVANCE(118);
      if (lookahead == '\\') ADVANCE(148);
      if (lookahead != 0) ADVANCE(153);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '\n') SKIP(66);
      if (lookahead == '/') ADVANCE(118);
      if (lookahead == '\\') ADVANCE(148);
      if (lookahead != 0) ADVANCE(153);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '\r') ADVANCE(154);
      if (lookahead == '/') ADVANCE(118);
      if (lookahead == '\\') ADVANCE(148);
      if (lookahead != 0) ADVANCE(153);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '\r') ADVANCE(152);
      if (lookahead == '*') ADVANCE(143);
      if (lookahead == '/') ADVANCE(63);
      if (lookahead == '\\') ADVANCE(149);
      if (lookahead != 0) ADVANCE(144);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '\r') ADVANCE(321);
      if (lookahead == '/') ADVANCE(319);
      if (lookahead == '\\') ADVANCE(318);
      if (lookahead != 0) ADVANCE(320);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '*') ADVANCE(144);
      if (lookahead == '/') ADVANCE(319);
      if (lookahead == '\\') ADVANCE(148);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(153);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '*') ADVANCE(143);
      if (lookahead == '/') ADVANCE(63);
      if (lookahead == '\\') ADVANCE(149);
      if (lookahead != 0) ADVANCE(144);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '/') ADVANCE(118);
      if (lookahead == '\\') ADVANCE(148);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(153);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '/') ADVANCE(118);
      if (lookahead == '\\') ADVANCE(148);
      if (lookahead != 0) ADVANCE(153);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'c') ADVANCE(181);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(185);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'd') ADVANCE(179);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(185);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'd') ADVANCE(163);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(185);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'd') ADVANCE(165);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(185);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'd') ADVANCE(167);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(185);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'e') ADVANCE(170);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(185);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'e') ADVANCE(136);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(185);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'e') ADVANCE(124);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(185);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'e') ADVANCE(122);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(185);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'e') ADVANCE(173);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(185);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'e') ADVANCE(174);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(185);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'e') ADVANCE(175);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(185);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'e') ADVANCE(176);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(185);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'f') ADVANCE(129);
      if (lookahead == 'n') ADVANCE(155);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(185);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'f') ADVANCE(129);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(185);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'f') ADVANCE(177);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(185);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'f') ADVANCE(138);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(185);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'f') ADVANCE(132);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(185);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'f') ADVANCE(133);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(185);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'f') ADVANCE(134);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(185);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'f') ADVANCE(140);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(185);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'f') ADVANCE(142);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(185);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'i') ADVANCE(183);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(185);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'i') ADVANCE(171);
      if (lookahead == 's') ADVANCE(161);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(185);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'i') ADVANCE(172);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(185);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'l') ADVANCE(178);
      if (lookahead == 'n') ADVANCE(156);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(185);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'l') ADVANCE(184);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(185);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'n') ADVANCE(156);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(185);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'n') ADVANCE(162);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(185);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'u') ADVANCE(157);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(185);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(185);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(anon_sym_LPAREN2);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(216);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(250);
      if (lookahead == '.') ADVANCE(96);
      if (lookahead == '0') ADVANCE(260);
      if (lookahead == '=') ADVANCE(244);
      if (lookahead == '>') ADVANCE(256);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(262);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(250);
      if (lookahead == '.') ADVANCE(96);
      if (lookahead == '0') ADVANCE(260);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(262);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(250);
      if (lookahead == '=') ADVANCE(244);
      if (lookahead == '>') ADVANCE(256);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '.') ADVANCE(96);
      if (lookahead == '0') ADVANCE(260);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(262);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(251);
      if (lookahead == '.') ADVANCE(96);
      if (lookahead == '0') ADVANCE(260);
      if (lookahead == '=') ADVANCE(243);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(262);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(251);
      if (lookahead == '.') ADVANCE(96);
      if (lookahead == '0') ADVANCE(260);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(262);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(251);
      if (lookahead == '=') ADVANCE(243);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '.') ADVANCE(96);
      if (lookahead == '0') ADVANCE(260);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(262);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '=') ADVANCE(240);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(62);
      if (lookahead == '/') ADVANCE(322);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(62);
      if (lookahead == '/') ADVANCE(322);
      if (lookahead == '=') ADVANCE(241);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(242);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(249);
      if (lookahead == '|') ADVANCE(206);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(206);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(248);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(207);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(207);
      if (lookahead == '=') ADVANCE(247);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(219);
      if (lookahead == '>') ADVANCE(226);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(219);
      if (lookahead == '>') ADVANCE(225);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(224);
      if (lookahead == '=') ADVANCE(220);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(223);
      if (lookahead == '=') ADVANCE(220);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(245);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(246);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(anon_sym_LBRACK_LBRACK);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(anon_sym_RBRACK_RBRACK);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      if (lookahead == '[') ADVANCE(229);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(215);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(65);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(65);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(257);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(257);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(sym_number_literal);
      if (lookahead == '\'') ADVANCE(96);
      if (lookahead == 'E' ||
          lookahead == 'P' ||
          lookahead == 'e' ||
          lookahead == 'p') ADVANCE(270);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(257);
      if (set_contains(sym_number_literal_character_set_13, 13, lookahead)) ADVANCE(273);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(sym_number_literal);
      ADVANCE_MAP(
        '\'', 97,
        '.', 271,
        'B', 267,
        'b', 267,
        'E', 266,
        'e', 266,
        'P', 270,
        'p', 270,
        'X', 100,
        'x', 100,
        'A', 268,
        'C', 268,
        'a', 268,
        'c', 268,
        'D', 268,
        'F', 268,
        'd', 268,
        'f', 268,
        'L', 273,
        'U', 273,
        'W', 273,
        'l', 273,
        'u', 273,
        'w', 273,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(259);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(sym_number_literal);
      ADVANCE_MAP(
        '\'', 97,
        '.', 271,
        'E', 266,
        'e', 266,
        'P', 270,
        'p', 270,
        'A', 268,
        'C', 268,
        'a', 268,
        'c', 268,
        'B', 268,
        'D', 268,
        'F', 268,
        'b', 268,
        'd', 268,
        'f', 268,
        'L', 273,
        'U', 273,
        'W', 273,
        'l', 273,
        'u', 273,
        'w', 273,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(259);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(sym_number_literal);
      ADVANCE_MAP(
        '\'', 95,
        '.', 271,
        'B', 269,
        'b', 269,
        'X', 64,
        'x', 64,
        'E', 270,
        'P', 270,
        'e', 270,
        'p', 270,
        'D', 273,
        'F', 273,
        'L', 273,
        'U', 273,
        'W', 273,
        'd', 273,
        'f', 273,
        'l', 273,
        'u', 273,
        'w', 273,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(262);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(sym_number_literal);
      ADVANCE_MAP(
        '\'', 95,
        '.', 271,
        'B', 272,
        'b', 272,
        'X', 100,
        'x', 100,
        'E', 270,
        'P', 270,
        'e', 270,
        'p', 270,
        'D', 273,
        'F', 273,
        'L', 273,
        'U', 273,
        'W', 273,
        'd', 273,
        'f', 273,
        'l', 273,
        'u', 273,
        'w', 273,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(262);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(sym_number_literal);
      if (lookahead == '\'') ADVANCE(95);
      if (lookahead == '.') ADVANCE(271);
      if (lookahead == 'E' ||
          lookahead == 'P' ||
          lookahead == 'e' ||
          lookahead == 'p') ADVANCE(270);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(262);
      if (set_contains(sym_number_literal_character_set_13, 13, lookahead)) ADVANCE(273);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(sym_number_literal);
      ADVANCE_MAP(
        '\'', 101,
        'B', 263,
        'D', 263,
        'F', 263,
        'b', 263,
        'd', 263,
        'f', 263,
        'L', 273,
        'U', 273,
        'W', 273,
        'l', 273,
        'u', 273,
        'w', 273,
      );
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'E') ||
          ('a' <= lookahead && lookahead <= 'e')) ADVANCE(263);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(sym_number_literal);
      ADVANCE_MAP(
        '\'', 99,
        '+', 101,
        '-', 101,
        'E', 264,
        'e', 264,
        'P', 270,
        'p', 270,
        'B', 265,
        'D', 265,
        'F', 265,
        'b', 265,
        'd', 265,
        'f', 265,
        'L', 273,
        'U', 273,
        'W', 273,
        'l', 273,
        'u', 273,
        'w', 273,
      );
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'C') ||
          ('a' <= lookahead && lookahead <= 'c')) ADVANCE(265);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(sym_number_literal);
      ADVANCE_MAP(
        '\'', 99,
        'E', 264,
        'e', 264,
        'P', 270,
        'p', 270,
        'B', 265,
        'D', 265,
        'F', 265,
        'b', 265,
        'd', 265,
        'f', 265,
        'L', 273,
        'U', 273,
        'W', 273,
        'l', 273,
        'u', 273,
        'w', 273,
      );
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'C') ||
          ('a' <= lookahead && lookahead <= 'c')) ADVANCE(265);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(sym_number_literal);
      ADVANCE_MAP(
        '\'', 100,
        '.', 271,
        '+', 101,
        '-', 101,
        'E', 266,
        'e', 266,
        'P', 270,
        'p', 270,
        'B', 268,
        'D', 268,
        'F', 268,
        'b', 268,
        'd', 268,
        'f', 268,
        'L', 273,
        'U', 273,
        'W', 273,
        'l', 273,
        'u', 273,
        'w', 273,
      );
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'C') ||
          ('a' <= lookahead && lookahead <= 'c')) ADVANCE(268);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(sym_number_literal);
      ADVANCE_MAP(
        '\'', 100,
        '.', 271,
        'E', 266,
        'e', 266,
        'P', 270,
        'p', 270,
        'A', 268,
        'C', 268,
        'a', 268,
        'c', 268,
        'B', 268,
        'D', 268,
        'F', 268,
        'b', 268,
        'd', 268,
        'f', 268,
        'L', 273,
        'U', 273,
        'W', 273,
        'l', 273,
        'u', 273,
        'w', 273,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(259);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(sym_number_literal);
      ADVANCE_MAP(
        '\'', 100,
        '.', 271,
        'E', 266,
        'e', 266,
        'P', 270,
        'p', 270,
        'B', 268,
        'D', 268,
        'F', 268,
        'b', 268,
        'd', 268,
        'f', 268,
        'L', 273,
        'U', 273,
        'W', 273,
        'l', 273,
        'u', 273,
        'w', 273,
      );
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'C') ||
          ('a' <= lookahead && lookahead <= 'c')) ADVANCE(268);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(sym_number_literal);
      if (lookahead == '.') ADVANCE(96);
      if (lookahead == '0') ADVANCE(261);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(262);
      if (set_contains(sym_number_literal_character_set_13, 13, lookahead)) ADVANCE(273);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(sym_number_literal);
      ADVANCE_MAP(
        '+', 101,
        '-', 101,
        'B', 263,
        'D', 263,
        'F', 263,
        'b', 263,
        'd', 263,
        'f', 263,
        'L', 273,
        'U', 273,
        'W', 273,
        'l', 273,
        'u', 273,
        'w', 273,
      );
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'E') ||
          ('a' <= lookahead && lookahead <= 'e')) ADVANCE(263);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(sym_number_literal);
      ADVANCE_MAP(
        'E', 264,
        'e', 264,
        'P', 270,
        'p', 270,
        'B', 265,
        'D', 265,
        'F', 265,
        'b', 265,
        'd', 265,
        'f', 265,
        'L', 273,
        'U', 273,
        'W', 273,
        'l', 273,
        'u', 273,
        'w', 273,
      );
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'C') ||
          ('a' <= lookahead && lookahead <= 'c')) ADVANCE(265);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(sym_number_literal);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(262);
      if (set_contains(sym_number_literal_character_set_13, 13, lookahead)) ADVANCE(273);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(sym_number_literal);
      ADVANCE_MAP(
        'B', 273,
        'D', 273,
        'F', 273,
        'L', 273,
        'U', 273,
        'W', 273,
        'b', 273,
        'd', 273,
        'f', 273,
        'l', 273,
        'u', 273,
        'w', 273,
      );
      END_STATE();
    case 274:
      ACCEPT_TOKEN(anon_sym_L_SQUOTE);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(anon_sym_u_SQUOTE);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(anon_sym_U_SQUOTE);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(anon_sym_u8_SQUOTE);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(aux_sym_char_literal_token1);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(aux_sym_char_literal_token1);
      if (lookahead == '\n') ADVANCE(294);
      if (lookahead == '\r') ADVANCE(293);
      if (lookahead == 'U') ADVANCE(117);
      if (lookahead == 'u') ADVANCE(109);
      if (lookahead == 'x') ADVANCE(103);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(296);
      if (lookahead != 0) ADVANCE(293);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(aux_sym_char_literal_token1);
      if (lookahead == '*') ADVANCE(62);
      if (lookahead == '/') ADVANCE(322);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(aux_sym_char_literal_token1);
      if (lookahead == '\\') ADVANCE(31);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(anon_sym_L_DQUOTE);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(anon_sym_u_DQUOTE);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(anon_sym_U_DQUOTE);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(anon_sym_u8_DQUOTE);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(aux_sym_string_literal_token1);
      if (lookahead == '*') ADVANCE(290);
      if (lookahead == '/') ADVANCE(292);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(292);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(aux_sym_string_literal_token1);
      if (lookahead == '*') ADVANCE(289);
      if (lookahead == '/') ADVANCE(292);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(290);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(aux_sym_string_literal_token1);
      if (lookahead == '*') ADVANCE(289);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(290);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(aux_sym_string_literal_token1);
      if (lookahead == '/') ADVANCE(288);
      if (lookahead == '\t' ||
          (0x0b <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(291);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(292);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(aux_sym_string_literal_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(292);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\\') ADVANCE(31);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(293);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(295);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(293);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(297);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(298);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(sym_system_lib_string);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(sym_system_lib_string);
      if (lookahead == '>') ADVANCE(300);
      if (lookahead == '\\') ADVANCE(71);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(70);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '"') ADVANCE(283);
      if (lookahead == '\'') ADVANCE(274);
      if (lookahead == '\\') ADVANCE(72);
      if (set_contains(sym_identifier_character_set_2, 778, lookahead)) ADVANCE(314);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '"') ADVANCE(283);
      if (lookahead == '\\') ADVANCE(72);
      if (set_contains(sym_identifier_character_set_2, 778, lookahead)) ADVANCE(314);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '"') ADVANCE(285);
      if (lookahead == '\'') ADVANCE(276);
      if (lookahead == '\\') ADVANCE(72);
      if (set_contains(sym_identifier_character_set_2, 778, lookahead)) ADVANCE(314);
      END_STATE();
    case 305:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '"') ADVANCE(285);
      if (lookahead == '\\') ADVANCE(72);
      if (set_contains(sym_identifier_character_set_2, 778, lookahead)) ADVANCE(314);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '"') ADVANCE(284);
      if (lookahead == '\'') ADVANCE(275);
      if (lookahead == '8') ADVANCE(308);
      if (lookahead == '\\') ADVANCE(72);
      if (set_contains(sym_identifier_character_set_2, 778, lookahead)) ADVANCE(314);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '"') ADVANCE(284);
      if (lookahead == '8') ADVANCE(309);
      if (lookahead == '\\') ADVANCE(72);
      if (set_contains(sym_identifier_character_set_2, 778, lookahead)) ADVANCE(314);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '"') ADVANCE(286);
      if (lookahead == '\'') ADVANCE(277);
      if (lookahead == '\\') ADVANCE(72);
      if (set_contains(sym_identifier_character_set_2, 778, lookahead)) ADVANCE(314);
      END_STATE();
    case 309:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '"') ADVANCE(286);
      if (lookahead == '\\') ADVANCE(72);
      if (set_contains(sym_identifier_character_set_2, 778, lookahead)) ADVANCE(314);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\'') ADVANCE(274);
      if (lookahead == '\\') ADVANCE(72);
      if (set_contains(sym_identifier_character_set_2, 778, lookahead)) ADVANCE(314);
      END_STATE();
    case 311:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\'') ADVANCE(276);
      if (lookahead == '\\') ADVANCE(72);
      if (set_contains(sym_identifier_character_set_2, 778, lookahead)) ADVANCE(314);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\'') ADVANCE(275);
      if (lookahead == '8') ADVANCE(313);
      if (lookahead == '\\') ADVANCE(72);
      if (set_contains(sym_identifier_character_set_2, 778, lookahead)) ADVANCE(314);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\'') ADVANCE(277);
      if (lookahead == '\\') ADVANCE(72);
      if (set_contains(sym_identifier_character_set_2, 778, lookahead)) ADVANCE(314);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\\') ADVANCE(72);
      if (set_contains(sym_identifier_character_set_2, 778, lookahead)) ADVANCE(314);
      END_STATE();
    case 315:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 316:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(322);
      if (lookahead == '/') ADVANCE(319);
      if (lookahead == '\\') ADVANCE(150);
      if (lookahead != 0) ADVANCE(320);
      END_STATE();
    case 317:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\r') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(317);
      if (lookahead != 0) ADVANCE(322);
      END_STATE();
    case 318:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\r') ADVANCE(321);
      if (lookahead == '/') ADVANCE(319);
      if (lookahead == '\\') ADVANCE(318);
      if (lookahead != 0) ADVANCE(320);
      END_STATE();
    case 319:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '*') ADVANCE(322);
      if (lookahead == '\\') ADVANCE(145);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(320);
      END_STATE();
    case 320:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '/') ADVANCE(319);
      if (lookahead == '\\') ADVANCE(150);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(320);
      END_STATE();
    case 321:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '/') ADVANCE(319);
      if (lookahead == '\\') ADVANCE(150);
      if (lookahead != 0) ADVANCE(320);
      END_STATE();
    case 322:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\\') ADVANCE(42);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(322);
      END_STATE();
    case 323:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\\') ADVANCE(42);
      if (lookahead != 0) ADVANCE(322);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'F') ADVANCE(1);
      if (lookahead == 'N') ADVANCE(2);
      if (lookahead == 'T') ADVANCE(3);
      if (lookahead == '\\') SKIP(4);
      if (lookahead == '_') ADVANCE(5);
      if (lookahead == 'a') ADVANCE(6);
      if (lookahead == 'b') ADVANCE(7);
      if (lookahead == 'c') ADVANCE(8);
      if (lookahead == 'd') ADVANCE(9);
      if (lookahead == 'e') ADVANCE(10);
      if (lookahead == 'f') ADVANCE(11);
      if (lookahead == 'g') ADVANCE(12);
      if (lookahead == 'i') ADVANCE(13);
      if (lookahead == 'l') ADVANCE(14);
      if (lookahead == 'm') ADVANCE(15);
      if (lookahead == 'n') ADVANCE(16);
      if (lookahead == 'o') ADVANCE(17);
      if (lookahead == 'p') ADVANCE(18);
      if (lookahead == 'r') ADVANCE(19);
      if (lookahead == 's') ADVANCE(20);
      if (lookahead == 't') ADVANCE(21);
      if (lookahead == 'u') ADVANCE(22);
      if (lookahead == 'v') ADVANCE(23);
      if (lookahead == 'w') ADVANCE(24);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(0);
      END_STATE();
    case 1:
      if (lookahead == 'A') ADVANCE(25);
      END_STATE();
    case 2:
      if (lookahead == 'U') ADVANCE(26);
      END_STATE();
    case 3:
      if (lookahead == 'R') ADVANCE(27);
      END_STATE();
    case 4:
      if (lookahead == '\n') SKIP(0);
      if (lookahead == '\r') SKIP(28);
      END_STATE();
    case 5:
      if (lookahead == 'A') ADVANCE(29);
      if (lookahead == 'G') ADVANCE(30);
      if (lookahead == 'N') ADVANCE(31);
      if (lookahead == '_') ADVANCE(32);
      if (lookahead == 'a') ADVANCE(33);
      if (lookahead == 'u') ADVANCE(34);
      END_STATE();
    case 6:
      if (lookahead == 'l') ADVANCE(35);
      if (lookahead == 's') ADVANCE(36);
      if (lookahead == 'u') ADVANCE(37);
      END_STATE();
    case 7:
      if (lookahead == 'o') ADVANCE(38);
      if (lookahead == 'r') ADVANCE(39);
      END_STATE();
    case 8:
      if (lookahead == 'a') ADVANCE(40);
      if (lookahead == 'h') ADVANCE(41);
      if (lookahead == 'o') ADVANCE(42);
      END_STATE();
    case 9:
      if (lookahead == 'e') ADVANCE(43);
      if (lookahead == 'o') ADVANCE(44);
      END_STATE();
    case 10:
      if (lookahead == 'l') ADVANCE(45);
      if (lookahead == 'n') ADVANCE(46);
      if (lookahead == 'x') ADVANCE(47);
      END_STATE();
    case 11:
      if (lookahead == 'a') ADVANCE(48);
      if (lookahead == 'l') ADVANCE(49);
      if (lookahead == 'o') ADVANCE(50);
      END_STATE();
    case 12:
      if (lookahead == 'o') ADVANCE(51);
      END_STATE();
    case 13:
      if (lookahead == 'f') ADVANCE(52);
      if (lookahead == 'n') ADVANCE(53);
      END_STATE();
    case 14:
      if (lookahead == 'o') ADVANCE(54);
      END_STATE();
    case 15:
      if (lookahead == 'a') ADVANCE(55);
      END_STATE();
    case 16:
      if (lookahead == 'o') ADVANCE(56);
      if (lookahead == 'u') ADVANCE(57);
      END_STATE();
    case 17:
      if (lookahead == 'f') ADVANCE(58);
      END_STATE();
    case 18:
      if (lookahead == 't') ADVANCE(59);
      END_STATE();
    case 19:
      if (lookahead == 'e') ADVANCE(60);
      END_STATE();
    case 20:
      if (lookahead == 'h') ADVANCE(61);
      if (lookahead == 'i') ADVANCE(62);
      if (lookahead == 's') ADVANCE(63);
      if (lookahead == 't') ADVANCE(64);
      if (lookahead == 'w') ADVANCE(65);
      END_STATE();
    case 21:
      if (lookahead == 'h') ADVANCE(66);
      if (lookahead == 'r') ADVANCE(67);
      if (lookahead == 'y') ADVANCE(68);
      END_STATE();
    case 22:
      if (lookahead == 'i') ADVANCE(69);
      if (lookahead == 'n') ADVANCE(70);
      END_STATE();
    case 23:
      if (lookahead == 'o') ADVANCE(71);
      END_STATE();
    case 24:
      if (lookahead == 'h') ADVANCE(72);
      END_STATE();
    case 25:
      if (lookahead == 'L') ADVANCE(73);
      END_STATE();
    case 26:
      if (lookahead == 'L') ADVANCE(74);
      END_STATE();
    case 27:
      if (lookahead == 'U') ADVANCE(75);
      END_STATE();
    case 28:
      if (lookahead == '\n') SKIP(0);
      END_STATE();
    case 29:
      if (lookahead == 'l') ADVANCE(76);
      if (lookahead == 't') ADVANCE(77);
      END_STATE();
    case 30:
      if (lookahead == 'e') ADVANCE(78);
      END_STATE();
    case 31:
      if (lookahead == 'o') ADVANCE(79);
      END_STATE();
    case 32:
      ADVANCE_MAP(
        'a', 80,
        'b', 81,
        'c', 82,
        'd', 83,
        'e', 84,
        'f', 85,
        'i', 86,
        'l', 87,
        'r', 88,
        's', 89,
        't', 90,
        'u', 91,
        'v', 92,
      );
      END_STATE();
    case 33:
      if (lookahead == 'l') ADVANCE(93);
      END_STATE();
    case 34:
      if (lookahead == 'n') ADVANCE(94);
      END_STATE();
    case 35:
      if (lookahead == 'i') ADVANCE(95);
      END_STATE();
    case 36:
      if (lookahead == 'm') ADVANCE(96);
      END_STATE();
    case 37:
      if (lookahead == 't') ADVANCE(97);
      END_STATE();
    case 38:
      if (lookahead == 'o') ADVANCE(98);
      END_STATE();
    case 39:
      if (lookahead == 'e') ADVANCE(99);
      END_STATE();
    case 40:
      if (lookahead == 's') ADVANCE(100);
      END_STATE();
    case 41:
      if (lookahead == 'a') ADVANCE(101);
      END_STATE();
    case 42:
      if (lookahead == 'n') ADVANCE(102);
      END_STATE();
    case 43:
      if (lookahead == 'f') ADVANCE(103);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_do);
      if (lookahead == 'u') ADVANCE(104);
      END_STATE();
    case 45:
      if (lookahead == 's') ADVANCE(105);
      END_STATE();
    case 46:
      if (lookahead == 'u') ADVANCE(106);
      END_STATE();
    case 47:
      if (lookahead == 't') ADVANCE(107);
      END_STATE();
    case 48:
      if (lookahead == 'l') ADVANCE(108);
      END_STATE();
    case 49:
      if (lookahead == 'o') ADVANCE(109);
      END_STATE();
    case 50:
      if (lookahead == 'r') ADVANCE(110);
      END_STATE();
    case 51:
      if (lookahead == 't') ADVANCE(111);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 53:
      if (lookahead == 'l') ADVANCE(112);
      if (lookahead == 't') ADVANCE(113);
      END_STATE();
    case 54:
      if (lookahead == 'n') ADVANCE(114);
      END_STATE();
    case 55:
      if (lookahead == 'x') ADVANCE(115);
      END_STATE();
    case 56:
      if (lookahead == 'r') ADVANCE(116);
      END_STATE();
    case 57:
      if (lookahead == 'l') ADVANCE(117);
      END_STATE();
    case 58:
      if (lookahead == 'f') ADVANCE(118);
      END_STATE();
    case 59:
      if (lookahead == 'r') ADVANCE(119);
      END_STATE();
    case 60:
      if (lookahead == 'g') ADVANCE(120);
      if (lookahead == 's') ADVANCE(121);
      if (lookahead == 't') ADVANCE(122);
      END_STATE();
    case 61:
      if (lookahead == 'o') ADVANCE(123);
      END_STATE();
    case 62:
      if (lookahead == 'g') ADVANCE(124);
      if (lookahead == 'z') ADVANCE(125);
      END_STATE();
    case 63:
      if (lookahead == 'i') ADVANCE(126);
      END_STATE();
    case 64:
      if (lookahead == 'a') ADVANCE(127);
      if (lookahead == 'r') ADVANCE(128);
      END_STATE();
    case 65:
      if (lookahead == 'i') ADVANCE(129);
      END_STATE();
    case 66:
      if (lookahead == 'r') ADVANCE(130);
      END_STATE();
    case 67:
      if (lookahead == 'u') ADVANCE(131);
      END_STATE();
    case 68:
      if (lookahead == 'p') ADVANCE(132);
      END_STATE();
    case 69:
      if (lookahead == 'n') ADVANCE(133);
      END_STATE();
    case 70:
      if (lookahead == 'i') ADVANCE(134);
      if (lookahead == 's') ADVANCE(135);
      END_STATE();
    case 71:
      if (lookahead == 'i') ADVANCE(136);
      if (lookahead == 'l') ADVANCE(137);
      END_STATE();
    case 72:
      if (lookahead == 'i') ADVANCE(138);
      END_STATE();
    case 73:
      if (lookahead == 'S') ADVANCE(139);
      END_STATE();
    case 74:
      if (lookahead == 'L') ADVANCE(140);
      END_STATE();
    case 75:
      if (lookahead == 'E') ADVANCE(141);
      END_STATE();
    case 76:
      if (lookahead == 'i') ADVANCE(142);
      END_STATE();
    case 77:
      if (lookahead == 'o') ADVANCE(143);
      END_STATE();
    case 78:
      if (lookahead == 'n') ADVANCE(144);
      END_STATE();
    case 79:
      if (lookahead == 'n') ADVANCE(145);
      if (lookahead == 'r') ADVANCE(146);
      END_STATE();
    case 80:
      if (lookahead == 'l') ADVANCE(147);
      if (lookahead == 's') ADVANCE(148);
      if (lookahead == 't') ADVANCE(149);
      END_STATE();
    case 81:
      if (lookahead == 'a') ADVANCE(150);
      END_STATE();
    case 82:
      if (lookahead == 'd') ADVANCE(151);
      if (lookahead == 'l') ADVANCE(152);
      END_STATE();
    case 83:
      if (lookahead == 'e') ADVANCE(153);
      END_STATE();
    case 84:
      if (lookahead == 'x') ADVANCE(154);
      END_STATE();
    case 85:
      if (lookahead == 'a') ADVANCE(155);
      if (lookahead == 'i') ADVANCE(156);
      if (lookahead == 'o') ADVANCE(157);
      END_STATE();
    case 86:
      if (lookahead == 'n') ADVANCE(158);
      END_STATE();
    case 87:
      if (lookahead == 'e') ADVANCE(159);
      END_STATE();
    case 88:
      if (lookahead == 'e') ADVANCE(160);
      END_STATE();
    case 89:
      if (lookahead == 'p') ADVANCE(161);
      if (lookahead == 't') ADVANCE(162);
      END_STATE();
    case 90:
      if (lookahead == 'h') ADVANCE(163);
      if (lookahead == 'r') ADVANCE(164);
      END_STATE();
    case 91:
      if (lookahead == 'n') ADVANCE(165);
      if (lookahead == 'p') ADVANCE(166);
      END_STATE();
    case 92:
      if (lookahead == 'e') ADVANCE(167);
      if (lookahead == 'o') ADVANCE(168);
      END_STATE();
    case 93:
      if (lookahead == 'i') ADVANCE(169);
      END_STATE();
    case 94:
      if (lookahead == 'a') ADVANCE(170);
      END_STATE();
    case 95:
      if (lookahead == 'g') ADVANCE(171);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_asm);
      END_STATE();
    case 97:
      if (lookahead == 'o') ADVANCE(172);
      END_STATE();
    case 98:
      if (lookahead == 'l') ADVANCE(173);
      END_STATE();
    case 99:
      if (lookahead == 'a') ADVANCE(174);
      END_STATE();
    case 100:
      if (lookahead == 'e') ADVANCE(175);
      END_STATE();
    case 101:
      if (lookahead == 'r') ADVANCE(176);
      END_STATE();
    case 102:
      if (lookahead == 's') ADVANCE(177);
      if (lookahead == 't') ADVANCE(178);
      END_STATE();
    case 103:
      if (lookahead == 'a') ADVANCE(179);
      if (lookahead == 'i') ADVANCE(180);
      END_STATE();
    case 104:
      if (lookahead == 'b') ADVANCE(181);
      END_STATE();
    case 105:
      if (lookahead == 'e') ADVANCE(182);
      END_STATE();
    case 106:
      if (lookahead == 'm') ADVANCE(183);
      END_STATE();
    case 107:
      if (lookahead == 'e') ADVANCE(184);
      END_STATE();
    case 108:
      if (lookahead == 's') ADVANCE(185);
      END_STATE();
    case 109:
      if (lookahead == 'a') ADVANCE(186);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 111:
      if (lookahead == 'o') ADVANCE(187);
      END_STATE();
    case 112:
      if (lookahead == 'i') ADVANCE(188);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(sym_primitive_type);
      if (lookahead == '1') ADVANCE(189);
      if (lookahead == '3') ADVANCE(190);
      if (lookahead == '6') ADVANCE(191);
      if (lookahead == '8') ADVANCE(192);
      if (lookahead == 'p') ADVANCE(193);
      END_STATE();
    case 114:
      if (lookahead == 'g') ADVANCE(194);
      END_STATE();
    case 115:
      if (lookahead == '_') ADVANCE(195);
      END_STATE();
    case 116:
      if (lookahead == 'e') ADVANCE(196);
      END_STATE();
    case 117:
      if (lookahead == 'l') ADVANCE(197);
      END_STATE();
    case 118:
      if (lookahead == 's') ADVANCE(198);
      END_STATE();
    case 119:
      if (lookahead == 'd') ADVANCE(199);
      END_STATE();
    case 120:
      if (lookahead == 'i') ADVANCE(200);
      END_STATE();
    case 121:
      if (lookahead == 't') ADVANCE(201);
      END_STATE();
    case 122:
      if (lookahead == 'u') ADVANCE(202);
      END_STATE();
    case 123:
      if (lookahead == 'r') ADVANCE(203);
      END_STATE();
    case 124:
      if (lookahead == 'n') ADVANCE(204);
      END_STATE();
    case 125:
      if (lookahead == 'e') ADVANCE(205);
      END_STATE();
    case 126:
      if (lookahead == 'z') ADVANCE(206);
      END_STATE();
    case 127:
      if (lookahead == 't') ADVANCE(207);
      END_STATE();
    case 128:
      if (lookahead == 'u') ADVANCE(208);
      END_STATE();
    case 129:
      if (lookahead == 't') ADVANCE(209);
      END_STATE();
    case 130:
      if (lookahead == 'e') ADVANCE(210);
      END_STATE();
    case 131:
      if (lookahead == 'e') ADVANCE(141);
      END_STATE();
    case 132:
      if (lookahead == 'e') ADVANCE(211);
      END_STATE();
    case 133:
      if (lookahead == 't') ADVANCE(212);
      END_STATE();
    case 134:
      if (lookahead == 'o') ADVANCE(213);
      END_STATE();
    case 135:
      if (lookahead == 'i') ADVANCE(214);
      END_STATE();
    case 136:
      if (lookahead == 'd') ADVANCE(173);
      END_STATE();
    case 137:
      if (lookahead == 'a') ADVANCE(215);
      END_STATE();
    case 138:
      if (lookahead == 'l') ADVANCE(216);
      END_STATE();
    case 139:
      if (lookahead == 'E') ADVANCE(217);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_NULL);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 142:
      if (lookahead == 'g') ADVANCE(218);
      END_STATE();
    case 143:
      if (lookahead == 'm') ADVANCE(219);
      END_STATE();
    case 144:
      if (lookahead == 'e') ADVANCE(220);
      END_STATE();
    case 145:
      if (lookahead == 'n') ADVANCE(221);
      END_STATE();
    case 146:
      if (lookahead == 'e') ADVANCE(222);
      END_STATE();
    case 147:
      if (lookahead == 'i') ADVANCE(223);
      END_STATE();
    case 148:
      if (lookahead == 'm') ADVANCE(224);
      END_STATE();
    case 149:
      if (lookahead == 't') ADVANCE(225);
      END_STATE();
    case 150:
      if (lookahead == 's') ADVANCE(226);
      END_STATE();
    case 151:
      if (lookahead == 'e') ADVANCE(227);
      END_STATE();
    case 152:
      if (lookahead == 'r') ADVANCE(228);
      END_STATE();
    case 153:
      if (lookahead == 'c') ADVANCE(229);
      END_STATE();
    case 154:
      if (lookahead == 'c') ADVANCE(230);
      if (lookahead == 't') ADVANCE(231);
      END_STATE();
    case 155:
      if (lookahead == 's') ADVANCE(232);
      END_STATE();
    case 156:
      if (lookahead == 'n') ADVANCE(233);
      END_STATE();
    case 157:
      if (lookahead == 'r') ADVANCE(234);
      END_STATE();
    case 158:
      if (lookahead == 'l') ADVANCE(235);
      END_STATE();
    case 159:
      if (lookahead == 'a') ADVANCE(236);
      END_STATE();
    case 160:
      if (lookahead == 's') ADVANCE(237);
      END_STATE();
    case 161:
      if (lookahead == 't') ADVANCE(238);
      END_STATE();
    case 162:
      if (lookahead == 'd') ADVANCE(239);
      END_STATE();
    case 163:
      if (lookahead == 'i') ADVANCE(240);
      if (lookahead == 'r') ADVANCE(241);
      END_STATE();
    case 164:
      if (lookahead == 'y') ADVANCE(242);
      END_STATE();
    case 165:
      if (lookahead == 'a') ADVANCE(243);
      END_STATE();
    case 166:
      if (lookahead == 't') ADVANCE(244);
      END_STATE();
    case 167:
      if (lookahead == 'c') ADVANCE(245);
      END_STATE();
    case 168:
      if (lookahead == 'l') ADVANCE(246);
      END_STATE();
    case 169:
      if (lookahead == 'g') ADVANCE(247);
      END_STATE();
    case 170:
      if (lookahead == 'l') ADVANCE(248);
      END_STATE();
    case 171:
      if (lookahead == 'n') ADVANCE(249);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(anon_sym_auto);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(sym_primitive_type);
      END_STATE();
    case 174:
      if (lookahead == 'k') ADVANCE(250);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(sym_primitive_type);
      if (lookahead == '1') ADVANCE(251);
      if (lookahead == '3') ADVANCE(252);
      if (lookahead == '6') ADVANCE(253);
      if (lookahead == '8') ADVANCE(254);
      if (lookahead == 'p') ADVANCE(255);
      END_STATE();
    case 177:
      if (lookahead == 't') ADVANCE(256);
      END_STATE();
    case 178:
      if (lookahead == 'i') ADVANCE(257);
      END_STATE();
    case 179:
      if (lookahead == 'u') ADVANCE(258);
      END_STATE();
    case 180:
      if (lookahead == 'n') ADVANCE(259);
      END_STATE();
    case 181:
      if (lookahead == 'l') ADVANCE(260);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(anon_sym_enum);
      END_STATE();
    case 184:
      if (lookahead == 'r') ADVANCE(261);
      END_STATE();
    case 185:
      if (lookahead == 'e') ADVANCE(217);
      END_STATE();
    case 186:
      if (lookahead == 't') ADVANCE(173);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(anon_sym_goto);
      END_STATE();
    case 188:
      if (lookahead == 'n') ADVANCE(262);
      END_STATE();
    case 189:
      if (lookahead == '6') ADVANCE(263);
      END_STATE();
    case 190:
      if (lookahead == '2') ADVANCE(264);
      END_STATE();
    case 191:
      if (lookahead == '4') ADVANCE(265);
      END_STATE();
    case 192:
      if (lookahead == '_') ADVANCE(266);
      END_STATE();
    case 193:
      if (lookahead == 't') ADVANCE(267);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(anon_sym_long);
      END_STATE();
    case 195:
      if (lookahead == 'a') ADVANCE(268);
      END_STATE();
    case 196:
      if (lookahead == 't') ADVANCE(269);
      END_STATE();
    case 197:
      if (lookahead == 'p') ADVANCE(270);
      END_STATE();
    case 198:
      if (lookahead == 'e') ADVANCE(271);
      END_STATE();
    case 199:
      if (lookahead == 'i') ADVANCE(272);
      END_STATE();
    case 200:
      if (lookahead == 's') ADVANCE(273);
      END_STATE();
    case 201:
      if (lookahead == 'r') ADVANCE(274);
      END_STATE();
    case 202:
      if (lookahead == 'r') ADVANCE(275);
      END_STATE();
    case 203:
      if (lookahead == 't') ADVANCE(276);
      END_STATE();
    case 204:
      if (lookahead == 'e') ADVANCE(277);
      END_STATE();
    case 205:
      if (lookahead == '_') ADVANCE(278);
      if (lookahead == 'o') ADVANCE(279);
      END_STATE();
    case 206:
      if (lookahead == 'e') ADVANCE(280);
      END_STATE();
    case 207:
      if (lookahead == 'i') ADVANCE(281);
      END_STATE();
    case 208:
      if (lookahead == 'c') ADVANCE(282);
      END_STATE();
    case 209:
      if (lookahead == 'c') ADVANCE(283);
      END_STATE();
    case 210:
      if (lookahead == 'a') ADVANCE(284);
      END_STATE();
    case 211:
      if (lookahead == 'd') ADVANCE(285);
      END_STATE();
    case 212:
      if (lookahead == '1') ADVANCE(286);
      if (lookahead == '3') ADVANCE(287);
      if (lookahead == '6') ADVANCE(288);
      if (lookahead == '8') ADVANCE(289);
      if (lookahead == 'p') ADVANCE(290);
      END_STATE();
    case 213:
      if (lookahead == 'n') ADVANCE(291);
      END_STATE();
    case 214:
      if (lookahead == 'g') ADVANCE(292);
      END_STATE();
    case 215:
      if (lookahead == 't') ADVANCE(293);
      END_STATE();
    case 216:
      if (lookahead == 'e') ADVANCE(294);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 218:
      if (lookahead == 'n') ADVANCE(295);
      END_STATE();
    case 219:
      if (lookahead == 'i') ADVANCE(296);
      END_STATE();
    case 220:
      if (lookahead == 'r') ADVANCE(297);
      END_STATE();
    case 221:
      if (lookahead == 'u') ADVANCE(298);
      END_STATE();
    case 222:
      if (lookahead == 't') ADVANCE(299);
      END_STATE();
    case 223:
      if (lookahead == 'g') ADVANCE(300);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(anon_sym___asm);
      if (lookahead == '_') ADVANCE(301);
      END_STATE();
    case 225:
      if (lookahead == 'r') ADVANCE(302);
      END_STATE();
    case 226:
      if (lookahead == 'e') ADVANCE(303);
      END_STATE();
    case 227:
      if (lookahead == 'c') ADVANCE(304);
      END_STATE();
    case 228:
      if (lookahead == 'c') ADVANCE(305);
      END_STATE();
    case 229:
      if (lookahead == 'l') ADVANCE(306);
      END_STATE();
    case 230:
      if (lookahead == 'e') ADVANCE(307);
      END_STATE();
    case 231:
      if (lookahead == 'e') ADVANCE(308);
      END_STATE();
    case 232:
      if (lookahead == 't') ADVANCE(309);
      END_STATE();
    case 233:
      if (lookahead == 'a') ADVANCE(310);
      END_STATE();
    case 234:
      if (lookahead == 'c') ADVANCE(311);
      END_STATE();
    case 235:
      if (lookahead == 'i') ADVANCE(312);
      END_STATE();
    case 236:
      if (lookahead == 'v') ADVANCE(313);
      END_STATE();
    case 237:
      if (lookahead == 't') ADVANCE(314);
      END_STATE();
    case 238:
      if (lookahead == 'r') ADVANCE(315);
      END_STATE();
    case 239:
      if (lookahead == 'c') ADVANCE(316);
      END_STATE();
    case 240:
      if (lookahead == 's') ADVANCE(317);
      END_STATE();
    case 241:
      if (lookahead == 'e') ADVANCE(318);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(anon_sym___try);
      END_STATE();
    case 243:
      if (lookahead == 'l') ADVANCE(319);
      END_STATE();
    case 244:
      if (lookahead == 'r') ADVANCE(320);
      END_STATE();
    case 245:
      if (lookahead == 't') ADVANCE(321);
      END_STATE();
    case 246:
      if (lookahead == 'a') ADVANCE(322);
      END_STATE();
    case 247:
      if (lookahead == 'n') ADVANCE(323);
      END_STATE();
    case 248:
      if (lookahead == 'i') ADVANCE(324);
      END_STATE();
    case 249:
      if (lookahead == 'a') ADVANCE(325);
      if (lookahead == 'o') ADVANCE(326);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 251:
      if (lookahead == '6') ADVANCE(327);
      END_STATE();
    case 252:
      if (lookahead == '2') ADVANCE(328);
      END_STATE();
    case 253:
      if (lookahead == '4') ADVANCE(329);
      END_STATE();
    case 254:
      if (lookahead == '_') ADVANCE(330);
      END_STATE();
    case 255:
      if (lookahead == 't') ADVANCE(331);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(anon_sym_const);
      if (lookahead == 'e') ADVANCE(332);
      END_STATE();
    case 257:
      if (lookahead == 'n') ADVANCE(333);
      END_STATE();
    case 258:
      if (lookahead == 'l') ADVANCE(334);
      END_STATE();
    case 259:
      if (lookahead == 'e') ADVANCE(335);
      END_STATE();
    case 260:
      if (lookahead == 'e') ADVANCE(173);
      END_STATE();
    case 261:
      if (lookahead == 'n') ADVANCE(336);
      END_STATE();
    case 262:
      if (lookahead == 'e') ADVANCE(337);
      END_STATE();
    case 263:
      if (lookahead == '_') ADVANCE(338);
      END_STATE();
    case 264:
      if (lookahead == '_') ADVANCE(339);
      END_STATE();
    case 265:
      if (lookahead == '_') ADVANCE(340);
      END_STATE();
    case 266:
      if (lookahead == 't') ADVANCE(173);
      END_STATE();
    case 267:
      if (lookahead == 'r') ADVANCE(341);
      END_STATE();
    case 268:
      if (lookahead == 'l') ADVANCE(342);
      END_STATE();
    case 269:
      if (lookahead == 'u') ADVANCE(343);
      END_STATE();
    case 270:
      if (lookahead == 't') ADVANCE(344);
      END_STATE();
    case 271:
      if (lookahead == 't') ADVANCE(345);
      END_STATE();
    case 272:
      if (lookahead == 'f') ADVANCE(346);
      END_STATE();
    case 273:
      if (lookahead == 't') ADVANCE(347);
      END_STATE();
    case 274:
      if (lookahead == 'i') ADVANCE(348);
      END_STATE();
    case 275:
      if (lookahead == 'n') ADVANCE(349);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(anon_sym_short);
      END_STATE();
    case 277:
      if (lookahead == 'd') ADVANCE(350);
      END_STATE();
    case 278:
      if (lookahead == 't') ADVANCE(173);
      END_STATE();
    case 279:
      if (lookahead == 'f') ADVANCE(351);
      END_STATE();
    case 280:
      if (lookahead == '_') ADVANCE(352);
      END_STATE();
    case 281:
      if (lookahead == 'c') ADVANCE(353);
      END_STATE();
    case 282:
      if (lookahead == 't') ADVANCE(354);
      END_STATE();
    case 283:
      if (lookahead == 'h') ADVANCE(355);
      END_STATE();
    case 284:
      if (lookahead == 'd') ADVANCE(356);
      END_STATE();
    case 285:
      if (lookahead == 'e') ADVANCE(357);
      END_STATE();
    case 286:
      if (lookahead == '6') ADVANCE(358);
      END_STATE();
    case 287:
      if (lookahead == '2') ADVANCE(359);
      END_STATE();
    case 288:
      if (lookahead == '4') ADVANCE(360);
      END_STATE();
    case 289:
      if (lookahead == '_') ADVANCE(361);
      END_STATE();
    case 290:
      if (lookahead == 't') ADVANCE(362);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(anon_sym_union);
      END_STATE();
    case 292:
      if (lookahead == 'n') ADVANCE(363);
      END_STATE();
    case 293:
      if (lookahead == 'i') ADVANCE(364);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 295:
      if (lookahead == 'a') ADVANCE(365);
      if (lookahead == 'o') ADVANCE(366);
      END_STATE();
    case 296:
      if (lookahead == 'c') ADVANCE(367);
      END_STATE();
    case 297:
      if (lookahead == 'i') ADVANCE(368);
      END_STATE();
    case 298:
      if (lookahead == 'l') ADVANCE(369);
      END_STATE();
    case 299:
      if (lookahead == 'u') ADVANCE(370);
      END_STATE();
    case 300:
      if (lookahead == 'n') ADVANCE(371);
      END_STATE();
    case 301:
      if (lookahead == '_') ADVANCE(372);
      END_STATE();
    case 302:
      if (lookahead == 'i') ADVANCE(373);
      END_STATE();
    case 303:
      if (lookahead == 'd') ADVANCE(374);
      END_STATE();
    case 304:
      if (lookahead == 'l') ADVANCE(375);
      END_STATE();
    case 305:
      if (lookahead == 'a') ADVANCE(376);
      END_STATE();
    case 306:
      if (lookahead == 's') ADVANCE(377);
      END_STATE();
    case 307:
      if (lookahead == 'p') ADVANCE(378);
      END_STATE();
    case 308:
      if (lookahead == 'n') ADVANCE(379);
      END_STATE();
    case 309:
      if (lookahead == 'c') ADVANCE(380);
      END_STATE();
    case 310:
      if (lookahead == 'l') ADVANCE(381);
      END_STATE();
    case 311:
      if (lookahead == 'e') ADVANCE(382);
      END_STATE();
    case 312:
      if (lookahead == 'n') ADVANCE(383);
      END_STATE();
    case 313:
      if (lookahead == 'e') ADVANCE(384);
      END_STATE();
    case 314:
      if (lookahead == 'r') ADVANCE(385);
      END_STATE();
    case 315:
      ACCEPT_TOKEN(sym_ms_signed_ptr_modifier);
      END_STATE();
    case 316:
      if (lookahead == 'a') ADVANCE(386);
      END_STATE();
    case 317:
      if (lookahead == 'c') ADVANCE(387);
      END_STATE();
    case 318:
      if (lookahead == 'a') ADVANCE(388);
      END_STATE();
    case 319:
      if (lookahead == 'i') ADVANCE(389);
      END_STATE();
    case 320:
      ACCEPT_TOKEN(sym_ms_unsigned_ptr_modifier);
      END_STATE();
    case 321:
      if (lookahead == 'o') ADVANCE(390);
      END_STATE();
    case 322:
      if (lookahead == 't') ADVANCE(391);
      END_STATE();
    case 323:
      if (lookahead == 'o') ADVANCE(392);
      END_STATE();
    case 324:
      if (lookahead == 'g') ADVANCE(393);
      END_STATE();
    case 325:
      if (lookahead == 's') ADVANCE(394);
      END_STATE();
    case 326:
      if (lookahead == 'f') ADVANCE(395);
      END_STATE();
    case 327:
      if (lookahead == '_') ADVANCE(396);
      END_STATE();
    case 328:
      if (lookahead == '_') ADVANCE(397);
      END_STATE();
    case 329:
      if (lookahead == '_') ADVANCE(398);
      END_STATE();
    case 330:
      if (lookahead == 't') ADVANCE(173);
      END_STATE();
    case 331:
      if (lookahead == 'r') ADVANCE(399);
      END_STATE();
    case 332:
      if (lookahead == 'x') ADVANCE(400);
      END_STATE();
    case 333:
      if (lookahead == 'u') ADVANCE(401);
      END_STATE();
    case 334:
      if (lookahead == 't') ADVANCE(402);
      END_STATE();
    case 335:
      if (lookahead == 'd') ADVANCE(403);
      END_STATE();
    case 336:
      ACCEPT_TOKEN(anon_sym_extern);
      END_STATE();
    case 337:
      ACCEPT_TOKEN(anon_sym_inline);
      END_STATE();
    case 338:
      if (lookahead == 't') ADVANCE(173);
      END_STATE();
    case 339:
      if (lookahead == 't') ADVANCE(173);
      END_STATE();
    case 340:
      if (lookahead == 't') ADVANCE(173);
      END_STATE();
    case 341:
      if (lookahead == '_') ADVANCE(404);
      END_STATE();
    case 342:
      if (lookahead == 'i') ADVANCE(405);
      END_STATE();
    case 343:
      if (lookahead == 'r') ADVANCE(406);
      END_STATE();
    case 344:
      if (lookahead == 'r') ADVANCE(407);
      END_STATE();
    case 345:
      if (lookahead == 'o') ADVANCE(408);
      END_STATE();
    case 346:
      if (lookahead == 'f') ADVANCE(409);
      END_STATE();
    case 347:
      if (lookahead == 'e') ADVANCE(410);
      END_STATE();
    case 348:
      if (lookahead == 'c') ADVANCE(411);
      END_STATE();
    case 349:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 350:
      ACCEPT_TOKEN(anon_sym_signed);
      END_STATE();
    case 351:
      ACCEPT_TOKEN(anon_sym_sizeof);
      END_STATE();
    case 352:
      if (lookahead == 't') ADVANCE(173);
      END_STATE();
    case 353:
      ACCEPT_TOKEN(anon_sym_static);
      END_STATE();
    case 354:
      ACCEPT_TOKEN(anon_sym_struct);
      END_STATE();
    case 355:
      ACCEPT_TOKEN(anon_sym_switch);
      END_STATE();
    case 356:
      if (lookahead == '_') ADVANCE(412);
      END_STATE();
    case 357:
      if (lookahead == 'f') ADVANCE(413);
      END_STATE();
    case 358:
      if (lookahead == '_') ADVANCE(414);
      END_STATE();
    case 359:
      if (lookahead == '_') ADVANCE(415);
      END_STATE();
    case 360:
      if (lookahead == '_') ADVANCE(416);
      END_STATE();
    case 361:
      if (lookahead == 't') ADVANCE(173);
      END_STATE();
    case 362:
      if (lookahead == 'r') ADVANCE(417);
      END_STATE();
    case 363:
      if (lookahead == 'e') ADVANCE(418);
      END_STATE();
    case 364:
      if (lookahead == 'l') ADVANCE(419);
      END_STATE();
    case 365:
      if (lookahead == 's') ADVANCE(420);
      END_STATE();
    case 366:
      if (lookahead == 'f') ADVANCE(421);
      END_STATE();
    case 367:
      ACCEPT_TOKEN(anon_sym__Atomic);
      END_STATE();
    case 368:
      if (lookahead == 'c') ADVANCE(422);
      END_STATE();
    case 369:
      if (lookahead == 'l') ADVANCE(423);
      END_STATE();
    case 370:
      if (lookahead == 'r') ADVANCE(424);
      END_STATE();
    case 371:
      if (lookahead == 'o') ADVANCE(425);
      END_STATE();
    case 372:
      ACCEPT_TOKEN(anon_sym___asm__);
      END_STATE();
    case 373:
      if (lookahead == 'b') ADVANCE(426);
      END_STATE();
    case 374:
      ACCEPT_TOKEN(anon_sym___based);
      END_STATE();
    case 375:
      ACCEPT_TOKEN(anon_sym___cdecl);
      END_STATE();
    case 376:
      if (lookahead == 'l') ADVANCE(427);
      END_STATE();
    case 377:
      if (lookahead == 'p') ADVANCE(428);
      END_STATE();
    case 378:
      if (lookahead == 't') ADVANCE(429);
      END_STATE();
    case 379:
      if (lookahead == 's') ADVANCE(430);
      END_STATE();
    case 380:
      if (lookahead == 'a') ADVANCE(431);
      END_STATE();
    case 381:
      if (lookahead == 'l') ADVANCE(432);
      END_STATE();
    case 382:
      if (lookahead == 'i') ADVANCE(433);
      END_STATE();
    case 383:
      if (lookahead == 'e') ADVANCE(434);
      END_STATE();
    case 384:
      ACCEPT_TOKEN(anon_sym___leave);
      END_STATE();
    case 385:
      if (lookahead == 'i') ADVANCE(435);
      END_STATE();
    case 386:
      if (lookahead == 'l') ADVANCE(436);
      END_STATE();
    case 387:
      if (lookahead == 'a') ADVANCE(437);
      END_STATE();
    case 388:
      if (lookahead == 'd') ADVANCE(438);
      END_STATE();
    case 389:
      if (lookahead == 'g') ADVANCE(439);
      END_STATE();
    case 390:
      if (lookahead == 'r') ADVANCE(440);
      END_STATE();
    case 391:
      if (lookahead == 'i') ADVANCE(441);
      END_STATE();
    case 392:
      if (lookahead == 'f') ADVANCE(442);
      END_STATE();
    case 393:
      if (lookahead == 'n') ADVANCE(443);
      END_STATE();
    case 394:
      ACCEPT_TOKEN(anon_sym_alignas);
      END_STATE();
    case 395:
      ACCEPT_TOKEN(anon_sym_alignof);
      END_STATE();
    case 396:
      if (lookahead == 't') ADVANCE(173);
      END_STATE();
    case 397:
      if (lookahead == 't') ADVANCE(173);
      END_STATE();
    case 398:
      if (lookahead == 't') ADVANCE(173);
      END_STATE();
    case 399:
      if (lookahead == '_') ADVANCE(444);
      END_STATE();
    case 400:
      if (lookahead == 'p') ADVANCE(445);
      END_STATE();
    case 401:
      if (lookahead == 'e') ADVANCE(446);
      END_STATE();
    case 402:
      ACCEPT_TOKEN(anon_sym_default);
      END_STATE();
    case 403:
      ACCEPT_TOKEN(anon_sym_defined);
      END_STATE();
    case 404:
      if (lookahead == 't') ADVANCE(173);
      END_STATE();
    case 405:
      if (lookahead == 'g') ADVANCE(447);
      END_STATE();
    case 406:
      if (lookahead == 'n') ADVANCE(448);
      END_STATE();
    case 407:
      ACCEPT_TOKEN(anon_sym_nullptr);
      if (lookahead == '_') ADVANCE(449);
      END_STATE();
    case 408:
      if (lookahead == 'f') ADVANCE(450);
      END_STATE();
    case 409:
      if (lookahead == '_') ADVANCE(451);
      END_STATE();
    case 410:
      if (lookahead == 'r') ADVANCE(452);
      END_STATE();
    case 411:
      if (lookahead == 't') ADVANCE(453);
      END_STATE();
    case 412:
      if (lookahead == 'l') ADVANCE(454);
      END_STATE();
    case 413:
      ACCEPT_TOKEN(anon_sym_typedef);
      END_STATE();
    case 414:
      if (lookahead == 't') ADVANCE(173);
      END_STATE();
    case 415:
      if (lookahead == 't') ADVANCE(173);
      END_STATE();
    case 416:
      if (lookahead == 't') ADVANCE(173);
      END_STATE();
    case 417:
      if (lookahead == '_') ADVANCE(455);
      END_STATE();
    case 418:
      if (lookahead == 'd') ADVANCE(456);
      END_STATE();
    case 419:
      if (lookahead == 'e') ADVANCE(457);
      END_STATE();
    case 420:
      ACCEPT_TOKEN(anon_sym__Alignas);
      END_STATE();
    case 421:
      ACCEPT_TOKEN(anon_sym__Alignof);
      END_STATE();
    case 422:
      ACCEPT_TOKEN(anon_sym__Generic);
      END_STATE();
    case 423:
      ACCEPT_TOKEN(anon_sym__Nonnull);
      END_STATE();
    case 424:
      if (lookahead == 'n') ADVANCE(458);
      END_STATE();
    case 425:
      if (lookahead == 'f') ADVANCE(459);
      END_STATE();
    case 426:
      if (lookahead == 'u') ADVANCE(460);
      END_STATE();
    case 427:
      if (lookahead == 'l') ADVANCE(461);
      END_STATE();
    case 428:
      if (lookahead == 'e') ADVANCE(462);
      END_STATE();
    case 429:
      ACCEPT_TOKEN(anon_sym___except);
      END_STATE();
    case 430:
      if (lookahead == 'i') ADVANCE(463);
      END_STATE();
    case 431:
      if (lookahead == 'l') ADVANCE(464);
      END_STATE();
    case 432:
      if (lookahead == 'y') ADVANCE(465);
      END_STATE();
    case 433:
      if (lookahead == 'n') ADVANCE(466);
      END_STATE();
    case 434:
      ACCEPT_TOKEN(anon_sym___inline);
      if (lookahead == '_') ADVANCE(467);
      END_STATE();
    case 435:
      if (lookahead == 'c') ADVANCE(468);
      END_STATE();
    case 436:
      if (lookahead == 'l') ADVANCE(469);
      END_STATE();
    case 437:
      if (lookahead == 'l') ADVANCE(470);
      END_STATE();
    case 438:
      ACCEPT_TOKEN(anon_sym___thread);
      END_STATE();
    case 439:
      if (lookahead == 'n') ADVANCE(471);
      END_STATE();
    case 440:
      if (lookahead == 'c') ADVANCE(472);
      END_STATE();
    case 441:
      if (lookahead == 'l') ADVANCE(473);
      END_STATE();
    case 442:
      ACCEPT_TOKEN(anon_sym__alignof);
      END_STATE();
    case 443:
      if (lookahead == 'e') ADVANCE(474);
      END_STATE();
    case 444:
      if (lookahead == 't') ADVANCE(173);
      END_STATE();
    case 445:
      if (lookahead == 'r') ADVANCE(475);
      END_STATE();
    case 446:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 447:
      if (lookahead == 'n') ADVANCE(476);
      END_STATE();
    case 448:
      ACCEPT_TOKEN(anon_sym_noreturn);
      END_STATE();
    case 449:
      if (lookahead == 't') ADVANCE(173);
      END_STATE();
    case 450:
      ACCEPT_TOKEN(anon_sym_offsetof);
      END_STATE();
    case 451:
      if (lookahead == 't') ADVANCE(173);
      END_STATE();
    case 452:
      ACCEPT_TOKEN(anon_sym_register);
      END_STATE();
    case 453:
      ACCEPT_TOKEN(anon_sym_restrict);
      END_STATE();
    case 454:
      if (lookahead == 'o') ADVANCE(477);
      END_STATE();
    case 455:
      if (lookahead == 't') ADVANCE(173);
      END_STATE();
    case 456:
      ACCEPT_TOKEN(anon_sym_unsigned);
      END_STATE();
    case 457:
      ACCEPT_TOKEN(anon_sym_volatile);
      END_STATE();
    case 458:
      ACCEPT_TOKEN(anon_sym__Noreturn);
      END_STATE();
    case 459:
      ACCEPT_TOKEN(anon_sym___alignof);
      if (lookahead == '_') ADVANCE(478);
      END_STATE();
    case 460:
      if (lookahead == 't') ADVANCE(479);
      END_STATE();
    case 461:
      ACCEPT_TOKEN(anon_sym___clrcall);
      END_STATE();
    case 462:
      if (lookahead == 'c') ADVANCE(480);
      END_STATE();
    case 463:
      if (lookahead == 'o') ADVANCE(481);
      END_STATE();
    case 464:
      if (lookahead == 'l') ADVANCE(482);
      END_STATE();
    case 465:
      ACCEPT_TOKEN(anon_sym___finally);
      END_STATE();
    case 466:
      if (lookahead == 'l') ADVANCE(483);
      END_STATE();
    case 467:
      if (lookahead == '_') ADVANCE(484);
      END_STATE();
    case 468:
      if (lookahead == 't') ADVANCE(485);
      END_STATE();
    case 469:
      ACCEPT_TOKEN(anon_sym___stdcall);
      END_STATE();
    case 470:
      if (lookahead == 'l') ADVANCE(486);
      END_STATE();
    case 471:
      if (lookahead == 'e') ADVANCE(487);
      END_STATE();
    case 472:
      if (lookahead == 'a') ADVANCE(488);
      END_STATE();
    case 473:
      if (lookahead == 'e') ADVANCE(489);
      END_STATE();
    case 474:
      if (lookahead == 'd') ADVANCE(490);
      END_STATE();
    case 475:
      ACCEPT_TOKEN(anon_sym_constexpr);
      END_STATE();
    case 476:
      if (lookahead == '_') ADVANCE(491);
      END_STATE();
    case 477:
      if (lookahead == 'c') ADVANCE(492);
      END_STATE();
    case 478:
      if (lookahead == '_') ADVANCE(493);
      END_STATE();
    case 479:
      if (lookahead == 'e') ADVANCE(494);
      END_STATE();
    case 480:
      ACCEPT_TOKEN(anon_sym___declspec);
      END_STATE();
    case 481:
      if (lookahead == 'n') ADVANCE(495);
      END_STATE();
    case 482:
      ACCEPT_TOKEN(anon_sym___fastcall);
      END_STATE();
    case 483:
      if (lookahead == 'i') ADVANCE(496);
      END_STATE();
    case 484:
      ACCEPT_TOKEN(anon_sym___inline__);
      END_STATE();
    case 485:
      ACCEPT_TOKEN(sym_ms_restrict_modifier);
      if (lookahead == '_') ADVANCE(497);
      END_STATE();
    case 486:
      ACCEPT_TOKEN(anon_sym___thiscall);
      END_STATE();
    case 487:
      if (lookahead == 'd') ADVANCE(498);
      END_STATE();
    case 488:
      if (lookahead == 'l') ADVANCE(499);
      END_STATE();
    case 489:
      if (lookahead == '_') ADVANCE(500);
      END_STATE();
    case 490:
      ACCEPT_TOKEN(anon_sym__unaligned);
      END_STATE();
    case 491:
      if (lookahead == 't') ADVANCE(173);
      END_STATE();
    case 492:
      if (lookahead == 'a') ADVANCE(501);
      END_STATE();
    case 493:
      ACCEPT_TOKEN(anon_sym___alignof__);
      END_STATE();
    case 494:
      ACCEPT_TOKEN(anon_sym___attribute);
      if (lookahead == '_') ADVANCE(502);
      END_STATE();
    case 495:
      if (lookahead == '_') ADVANCE(503);
      END_STATE();
    case 496:
      if (lookahead == 'n') ADVANCE(504);
      END_STATE();
    case 497:
      if (lookahead == '_') ADVANCE(505);
      END_STATE();
    case 498:
      ACCEPT_TOKEN(anon_sym___unaligned);
      END_STATE();
    case 499:
      if (lookahead == 'l') ADVANCE(506);
      END_STATE();
    case 500:
      if (lookahead == '_') ADVANCE(507);
      END_STATE();
    case 501:
      if (lookahead == 'l') ADVANCE(508);
      END_STATE();
    case 502:
      if (lookahead == '_') ADVANCE(509);
      END_STATE();
    case 503:
      if (lookahead == '_') ADVANCE(510);
      END_STATE();
    case 504:
      if (lookahead == 'e') ADVANCE(511);
      END_STATE();
    case 505:
      ACCEPT_TOKEN(anon_sym___restrict__);
      END_STATE();
    case 506:
      ACCEPT_TOKEN(anon_sym___vectorcall);
      END_STATE();
    case 507:
      ACCEPT_TOKEN(anon_sym___volatile__);
      END_STATE();
    case 508:
      ACCEPT_TOKEN(anon_sym_thread_local);
      END_STATE();
    case 509:
      ACCEPT_TOKEN(anon_sym___attribute__);
      END_STATE();
    case 510:
      ACCEPT_TOKEN(anon_sym___extension__);
      END_STATE();
    case 511:
      ACCEPT_TOKEN(anon_sym___forceinline);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 120},
  [2] = {.lex_state = 45},
  [3] = {.lex_state = 45},
  [4] = {.lex_state = 45},
  [5] = {.lex_state = 45},
  [6] = {.lex_state = 45},
  [7] = {.lex_state = 45},
  [8] = {.lex_state = 45},
  [9] = {.lex_state = 45},
  [10] = {.lex_state = 45},
  [11] = {.lex_state = 45},
  [12] = {.lex_state = 45},
  [13] = {.lex_state = 45},
  [14] = {.lex_state = 45},
  [15] = {.lex_state = 45},
  [16] = {.lex_state = 45},
  [17] = {.lex_state = 45},
  [18] = {.lex_state = 45},
  [19] = {.lex_state = 45},
  [20] = {.lex_state = 45},
  [21] = {.lex_state = 45},
  [22] = {.lex_state = 45},
  [23] = {.lex_state = 120},
  [24] = {.lex_state = 120},
  [25] = {.lex_state = 120},
  [26] = {.lex_state = 47},
  [27] = {.lex_state = 120},
  [28] = {.lex_state = 120},
  [29] = {.lex_state = 120},
  [30] = {.lex_state = 120},
  [31] = {.lex_state = 120},
  [32] = {.lex_state = 120},
  [33] = {.lex_state = 120},
  [34] = {.lex_state = 120},
  [35] = {.lex_state = 47},
  [36] = {.lex_state = 120},
  [37] = {.lex_state = 120},
  [38] = {.lex_state = 120},
  [39] = {.lex_state = 120},
  [40] = {.lex_state = 47},
  [41] = {.lex_state = 120},
  [42] = {.lex_state = 120},
  [43] = {.lex_state = 120},
  [44] = {.lex_state = 120},
  [45] = {.lex_state = 45},
  [46] = {.lex_state = 45},
  [47] = {.lex_state = 45},
  [48] = {.lex_state = 45},
  [49] = {.lex_state = 45},
  [50] = {.lex_state = 120},
  [51] = {.lex_state = 120},
  [52] = {.lex_state = 120},
  [53] = {.lex_state = 120},
  [54] = {.lex_state = 120},
  [55] = {.lex_state = 120},
  [56] = {.lex_state = 120},
  [57] = {.lex_state = 47},
  [58] = {.lex_state = 47},
  [59] = {.lex_state = 47},
  [60] = {.lex_state = 47},
  [61] = {.lex_state = 47},
  [62] = {.lex_state = 120},
  [63] = {.lex_state = 120},
  [64] = {.lex_state = 120},
  [65] = {.lex_state = 120},
  [66] = {.lex_state = 120},
  [67] = {.lex_state = 120},
  [68] = {.lex_state = 120},
  [69] = {.lex_state = 120},
  [70] = {.lex_state = 120},
  [71] = {.lex_state = 120},
  [72] = {.lex_state = 120},
  [73] = {.lex_state = 120},
  [74] = {.lex_state = 120},
  [75] = {.lex_state = 120},
  [76] = {.lex_state = 120},
  [77] = {.lex_state = 120},
  [78] = {.lex_state = 120},
  [79] = {.lex_state = 120},
  [80] = {.lex_state = 45},
  [81] = {.lex_state = 45},
  [82] = {.lex_state = 45},
  [83] = {.lex_state = 45},
  [84] = {.lex_state = 45},
  [85] = {.lex_state = 45},
  [86] = {.lex_state = 45},
  [87] = {.lex_state = 45},
  [88] = {.lex_state = 45},
  [89] = {.lex_state = 45},
  [90] = {.lex_state = 45},
  [91] = {.lex_state = 45},
  [92] = {.lex_state = 45},
  [93] = {.lex_state = 45},
  [94] = {.lex_state = 45},
  [95] = {.lex_state = 45},
  [96] = {.lex_state = 45},
  [97] = {.lex_state = 45},
  [98] = {.lex_state = 45},
  [99] = {.lex_state = 45},
  [100] = {.lex_state = 45},
  [101] = {.lex_state = 45},
  [102] = {.lex_state = 45},
  [103] = {.lex_state = 45},
  [104] = {.lex_state = 45},
  [105] = {.lex_state = 45},
  [106] = {.lex_state = 45},
  [107] = {.lex_state = 45},
  [108] = {.lex_state = 45},
  [109] = {.lex_state = 45},
  [110] = {.lex_state = 45},
  [111] = {.lex_state = 45},
  [112] = {.lex_state = 45},
  [113] = {.lex_state = 45},
  [114] = {.lex_state = 45},
  [115] = {.lex_state = 120},
  [116] = {.lex_state = 45},
  [117] = {.lex_state = 120},
  [118] = {.lex_state = 45},
  [119] = {.lex_state = 45},
  [120] = {.lex_state = 45},
  [121] = {.lex_state = 45},
  [122] = {.lex_state = 45},
  [123] = {.lex_state = 45},
  [124] = {.lex_state = 45},
  [125] = {.lex_state = 45},
  [126] = {.lex_state = 45},
  [127] = {.lex_state = 45},
  [128] = {.lex_state = 45},
  [129] = {.lex_state = 45},
  [130] = {.lex_state = 45},
  [131] = {.lex_state = 45},
  [132] = {.lex_state = 45},
  [133] = {.lex_state = 45},
  [134] = {.lex_state = 45},
  [135] = {.lex_state = 45},
  [136] = {.lex_state = 45},
  [137] = {.lex_state = 45},
  [138] = {.lex_state = 45},
  [139] = {.lex_state = 45},
  [140] = {.lex_state = 45},
  [141] = {.lex_state = 45},
  [142] = {.lex_state = 45},
  [143] = {.lex_state = 45},
  [144] = {.lex_state = 45},
  [145] = {.lex_state = 45},
  [146] = {.lex_state = 45},
  [147] = {.lex_state = 45},
  [148] = {.lex_state = 47},
  [149] = {.lex_state = 120},
  [150] = {.lex_state = 120},
  [151] = {.lex_state = 120},
  [152] = {.lex_state = 120},
  [153] = {.lex_state = 120},
  [154] = {.lex_state = 120},
  [155] = {.lex_state = 120},
  [156] = {.lex_state = 120},
  [157] = {.lex_state = 120},
  [158] = {.lex_state = 120},
  [159] = {.lex_state = 120},
  [160] = {.lex_state = 120},
  [161] = {.lex_state = 120},
  [162] = {.lex_state = 120},
  [163] = {.lex_state = 120},
  [164] = {.lex_state = 120},
  [165] = {.lex_state = 120},
  [166] = {.lex_state = 120},
  [167] = {.lex_state = 120},
  [168] = {.lex_state = 120},
  [169] = {.lex_state = 120},
  [170] = {.lex_state = 120},
  [171] = {.lex_state = 120},
  [172] = {.lex_state = 120},
  [173] = {.lex_state = 120},
  [174] = {.lex_state = 120},
  [175] = {.lex_state = 120},
  [176] = {.lex_state = 120},
  [177] = {.lex_state = 120},
  [178] = {.lex_state = 47},
  [179] = {.lex_state = 47},
  [180] = {.lex_state = 47},
  [181] = {.lex_state = 120},
  [182] = {.lex_state = 47},
  [183] = {.lex_state = 47},
  [184] = {.lex_state = 47},
  [185] = {.lex_state = 47},
  [186] = {.lex_state = 47},
  [187] = {.lex_state = 47},
  [188] = {.lex_state = 47},
  [189] = {.lex_state = 120},
  [190] = {.lex_state = 47},
  [191] = {.lex_state = 120},
  [192] = {.lex_state = 120},
  [193] = {.lex_state = 47},
  [194] = {.lex_state = 47},
  [195] = {.lex_state = 47},
  [196] = {.lex_state = 47},
  [197] = {.lex_state = 47},
  [198] = {.lex_state = 47},
  [199] = {.lex_state = 47},
  [200] = {.lex_state = 120},
  [201] = {.lex_state = 120},
  [202] = {.lex_state = 47},
  [203] = {.lex_state = 47},
  [204] = {.lex_state = 47},
  [205] = {.lex_state = 47},
  [206] = {.lex_state = 47},
  [207] = {.lex_state = 120},
  [208] = {.lex_state = 47},
  [209] = {.lex_state = 47},
  [210] = {.lex_state = 47},
  [211] = {.lex_state = 47},
  [212] = {.lex_state = 47},
  [213] = {.lex_state = 47},
  [214] = {.lex_state = 47},
  [215] = {.lex_state = 47},
  [216] = {.lex_state = 47},
  [217] = {.lex_state = 47},
  [218] = {.lex_state = 47},
  [219] = {.lex_state = 47},
  [220] = {.lex_state = 120},
  [221] = {.lex_state = 120},
  [222] = {.lex_state = 120},
  [223] = {.lex_state = 120},
  [224] = {.lex_state = 120},
  [225] = {.lex_state = 120},
  [226] = {.lex_state = 120},
  [227] = {.lex_state = 120},
  [228] = {.lex_state = 120},
  [229] = {.lex_state = 120},
  [230] = {.lex_state = 120},
  [231] = {.lex_state = 120},
  [232] = {.lex_state = 120},
  [233] = {.lex_state = 120},
  [234] = {.lex_state = 120},
  [235] = {.lex_state = 120},
  [236] = {.lex_state = 120},
  [237] = {.lex_state = 120},
  [238] = {.lex_state = 120},
  [239] = {.lex_state = 120},
  [240] = {.lex_state = 120},
  [241] = {.lex_state = 120},
  [242] = {.lex_state = 120},
  [243] = {.lex_state = 120},
  [244] = {.lex_state = 120},
  [245] = {.lex_state = 120},
  [246] = {.lex_state = 120},
  [247] = {.lex_state = 120},
  [248] = {.lex_state = 120},
  [249] = {.lex_state = 120},
  [250] = {.lex_state = 120},
  [251] = {.lex_state = 120},
  [252] = {.lex_state = 120},
  [253] = {.lex_state = 120},
  [254] = {.lex_state = 120},
  [255] = {.lex_state = 120},
  [256] = {.lex_state = 47},
  [257] = {.lex_state = 120},
  [258] = {.lex_state = 120},
  [259] = {.lex_state = 120},
  [260] = {.lex_state = 120},
  [261] = {.lex_state = 120},
  [262] = {.lex_state = 120},
  [263] = {.lex_state = 120},
  [264] = {.lex_state = 120},
  [265] = {.lex_state = 120},
  [266] = {.lex_state = 120},
  [267] = {.lex_state = 120},
  [268] = {.lex_state = 120},
  [269] = {.lex_state = 120},
  [270] = {.lex_state = 120},
  [271] = {.lex_state = 120},
  [272] = {.lex_state = 120},
  [273] = {.lex_state = 44},
  [274] = {.lex_state = 120},
  [275] = {.lex_state = 120},
  [276] = {.lex_state = 120},
  [277] = {.lex_state = 120},
  [278] = {.lex_state = 120},
  [279] = {.lex_state = 120},
  [280] = {.lex_state = 120},
  [281] = {.lex_state = 120},
  [282] = {.lex_state = 120},
  [283] = {.lex_state = 120},
  [284] = {.lex_state = 120},
  [285] = {.lex_state = 120},
  [286] = {.lex_state = 47},
  [287] = {.lex_state = 47},
  [288] = {.lex_state = 47},
  [289] = {.lex_state = 47},
  [290] = {.lex_state = 47},
  [291] = {.lex_state = 47},
  [292] = {.lex_state = 47},
  [293] = {.lex_state = 47},
  [294] = {.lex_state = 47},
  [295] = {.lex_state = 47},
  [296] = {.lex_state = 47},
  [297] = {.lex_state = 47},
  [298] = {.lex_state = 47},
  [299] = {.lex_state = 47},
  [300] = {.lex_state = 47},
  [301] = {.lex_state = 47},
  [302] = {.lex_state = 47},
  [303] = {.lex_state = 47},
  [304] = {.lex_state = 47},
  [305] = {.lex_state = 47},
  [306] = {.lex_state = 47},
  [307] = {.lex_state = 47},
  [308] = {.lex_state = 47},
  [309] = {.lex_state = 47},
  [310] = {.lex_state = 47},
  [311] = {.lex_state = 47},
  [312] = {.lex_state = 47},
  [313] = {.lex_state = 47},
  [314] = {.lex_state = 47},
  [315] = {.lex_state = 120},
  [316] = {.lex_state = 120},
  [317] = {.lex_state = 120},
  [318] = {.lex_state = 44},
  [319] = {.lex_state = 120},
  [320] = {.lex_state = 120},
  [321] = {.lex_state = 120},
  [322] = {.lex_state = 120},
  [323] = {.lex_state = 120},
  [324] = {.lex_state = 120},
  [325] = {.lex_state = 120},
  [326] = {.lex_state = 120},
  [327] = {.lex_state = 120},
  [328] = {.lex_state = 120},
  [329] = {.lex_state = 120},
  [330] = {.lex_state = 120},
  [331] = {.lex_state = 120},
  [332] = {.lex_state = 120},
  [333] = {.lex_state = 120},
  [334] = {.lex_state = 120},
  [335] = {.lex_state = 120},
  [336] = {.lex_state = 120},
  [337] = {.lex_state = 120},
  [338] = {.lex_state = 120},
  [339] = {.lex_state = 120},
  [340] = {.lex_state = 120},
  [341] = {.lex_state = 120},
  [342] = {.lex_state = 120},
  [343] = {.lex_state = 120},
  [344] = {.lex_state = 120},
  [345] = {.lex_state = 120},
  [346] = {.lex_state = 120},
  [347] = {.lex_state = 120},
  [348] = {.lex_state = 120},
  [349] = {.lex_state = 120},
  [350] = {.lex_state = 120},
  [351] = {.lex_state = 120},
  [352] = {.lex_state = 120},
  [353] = {.lex_state = 120},
  [354] = {.lex_state = 120},
  [355] = {.lex_state = 120},
  [356] = {.lex_state = 120},
  [357] = {.lex_state = 120},
  [358] = {.lex_state = 120},
  [359] = {.lex_state = 120},
  [360] = {.lex_state = 120},
  [361] = {.lex_state = 120},
  [362] = {.lex_state = 120},
  [363] = {.lex_state = 120},
  [364] = {.lex_state = 120},
  [365] = {.lex_state = 120},
  [366] = {.lex_state = 120},
  [367] = {.lex_state = 120},
  [368] = {.lex_state = 120},
  [369] = {.lex_state = 120},
  [370] = {.lex_state = 120},
  [371] = {.lex_state = 120},
  [372] = {.lex_state = 120},
  [373] = {.lex_state = 120},
  [374] = {.lex_state = 120},
  [375] = {.lex_state = 120},
  [376] = {.lex_state = 120},
  [377] = {.lex_state = 120},
  [378] = {.lex_state = 120},
  [379] = {.lex_state = 120},
  [380] = {.lex_state = 120},
  [381] = {.lex_state = 120},
  [382] = {.lex_state = 120},
  [383] = {.lex_state = 120},
  [384] = {.lex_state = 120},
  [385] = {.lex_state = 120},
  [386] = {.lex_state = 120},
  [387] = {.lex_state = 120},
  [388] = {.lex_state = 120},
  [389] = {.lex_state = 120},
  [390] = {.lex_state = 44},
  [391] = {.lex_state = 120},
  [392] = {.lex_state = 120},
  [393] = {.lex_state = 120},
  [394] = {.lex_state = 120},
  [395] = {.lex_state = 120},
  [396] = {.lex_state = 120},
  [397] = {.lex_state = 120},
  [398] = {.lex_state = 120},
  [399] = {.lex_state = 120},
  [400] = {.lex_state = 120},
  [401] = {.lex_state = 120},
  [402] = {.lex_state = 120},
  [403] = {.lex_state = 120},
  [404] = {.lex_state = 44},
  [405] = {.lex_state = 44},
  [406] = {.lex_state = 120},
  [407] = {.lex_state = 120},
  [408] = {.lex_state = 49},
  [409] = {.lex_state = 49},
  [410] = {.lex_state = 49},
  [411] = {.lex_state = 49},
  [412] = {.lex_state = 49},
  [413] = {.lex_state = 49},
  [414] = {.lex_state = 49},
  [415] = {.lex_state = 49},
  [416] = {.lex_state = 49},
  [417] = {.lex_state = 44},
  [418] = {.lex_state = 49},
  [419] = {.lex_state = 53},
  [420] = {.lex_state = 120},
  [421] = {.lex_state = 120},
  [422] = {.lex_state = 120},
  [423] = {.lex_state = 120},
  [424] = {.lex_state = 120},
  [425] = {.lex_state = 120},
  [426] = {.lex_state = 120},
  [427] = {.lex_state = 120},
  [428] = {.lex_state = 120},
  [429] = {.lex_state = 120},
  [430] = {.lex_state = 120},
  [431] = {.lex_state = 53},
  [432] = {.lex_state = 53},
  [433] = {.lex_state = 53},
  [434] = {.lex_state = 53},
  [435] = {.lex_state = 53},
  [436] = {.lex_state = 53},
  [437] = {.lex_state = 53},
  [438] = {.lex_state = 53},
  [439] = {.lex_state = 53},
  [440] = {.lex_state = 53},
  [441] = {.lex_state = 53},
  [442] = {.lex_state = 53},
  [443] = {.lex_state = 53},
  [444] = {.lex_state = 53},
  [445] = {.lex_state = 53},
  [446] = {.lex_state = 53},
  [447] = {.lex_state = 120},
  [448] = {.lex_state = 53},
  [449] = {.lex_state = 120},
  [450] = {.lex_state = 120},
  [451] = {.lex_state = 120},
  [452] = {.lex_state = 53},
  [453] = {.lex_state = 52},
  [454] = {.lex_state = 52},
  [455] = {.lex_state = 57},
  [456] = {.lex_state = 52},
  [457] = {.lex_state = 57},
  [458] = {.lex_state = 57},
  [459] = {.lex_state = 120},
  [460] = {.lex_state = 120},
  [461] = {.lex_state = 120},
  [462] = {.lex_state = 120},
  [463] = {.lex_state = 120},
  [464] = {.lex_state = 120},
  [465] = {.lex_state = 120},
  [466] = {.lex_state = 120},
  [467] = {.lex_state = 120},
  [468] = {.lex_state = 120},
  [469] = {.lex_state = 120},
  [470] = {.lex_state = 120},
  [471] = {.lex_state = 120},
  [472] = {.lex_state = 120},
  [473] = {.lex_state = 120},
  [474] = {.lex_state = 120},
  [475] = {.lex_state = 120},
  [476] = {.lex_state = 120},
  [477] = {.lex_state = 120},
  [478] = {.lex_state = 120},
  [479] = {.lex_state = 120},
  [480] = {.lex_state = 120},
  [481] = {.lex_state = 120},
  [482] = {.lex_state = 120},
  [483] = {.lex_state = 120},
  [484] = {.lex_state = 120},
  [485] = {.lex_state = 120},
  [486] = {.lex_state = 120},
  [487] = {.lex_state = 120},
  [488] = {.lex_state = 120},
  [489] = {.lex_state = 120},
  [490] = {.lex_state = 120},
  [491] = {.lex_state = 120},
  [492] = {.lex_state = 120},
  [493] = {.lex_state = 120},
  [494] = {.lex_state = 120},
  [495] = {.lex_state = 120},
  [496] = {.lex_state = 120},
  [497] = {.lex_state = 53},
  [498] = {.lex_state = 120},
  [499] = {.lex_state = 53},
  [500] = {.lex_state = 120},
  [501] = {.lex_state = 120},
  [502] = {.lex_state = 120},
  [503] = {.lex_state = 53},
  [504] = {.lex_state = 120},
  [505] = {.lex_state = 120},
  [506] = {.lex_state = 53},
  [507] = {.lex_state = 120},
  [508] = {.lex_state = 120},
  [509] = {.lex_state = 120},
  [510] = {.lex_state = 120},
  [511] = {.lex_state = 120},
  [512] = {.lex_state = 120},
  [513] = {.lex_state = 120},
  [514] = {.lex_state = 120},
  [515] = {.lex_state = 120},
  [516] = {.lex_state = 120},
  [517] = {.lex_state = 120},
  [518] = {.lex_state = 120},
  [519] = {.lex_state = 120},
  [520] = {.lex_state = 120},
  [521] = {.lex_state = 120},
  [522] = {.lex_state = 120},
  [523] = {.lex_state = 120},
  [524] = {.lex_state = 120},
  [525] = {.lex_state = 120},
  [526] = {.lex_state = 120},
  [527] = {.lex_state = 120},
  [528] = {.lex_state = 120},
  [529] = {.lex_state = 120},
  [530] = {.lex_state = 120},
  [531] = {.lex_state = 120},
  [532] = {.lex_state = 120},
  [533] = {.lex_state = 120},
  [534] = {.lex_state = 120},
  [535] = {.lex_state = 120},
  [536] = {.lex_state = 120},
  [537] = {.lex_state = 120},
  [538] = {.lex_state = 120},
  [539] = {.lex_state = 120},
  [540] = {.lex_state = 120},
  [541] = {.lex_state = 120},
  [542] = {.lex_state = 120},
  [543] = {.lex_state = 120},
  [544] = {.lex_state = 120},
  [545] = {.lex_state = 120},
  [546] = {.lex_state = 120},
  [547] = {.lex_state = 120},
  [548] = {.lex_state = 120},
  [549] = {.lex_state = 120},
  [550] = {.lex_state = 49},
  [551] = {.lex_state = 120},
  [552] = {.lex_state = 120},
  [553] = {.lex_state = 120},
  [554] = {.lex_state = 120},
  [555] = {.lex_state = 120},
  [556] = {.lex_state = 120},
  [557] = {.lex_state = 120},
  [558] = {.lex_state = 120},
  [559] = {.lex_state = 120},
  [560] = {.lex_state = 120},
  [561] = {.lex_state = 120},
  [562] = {.lex_state = 120},
  [563] = {.lex_state = 120},
  [564] = {.lex_state = 120},
  [565] = {.lex_state = 120},
  [566] = {.lex_state = 120},
  [567] = {.lex_state = 120},
  [568] = {.lex_state = 120},
  [569] = {.lex_state = 120},
  [570] = {.lex_state = 120},
  [571] = {.lex_state = 120},
  [572] = {.lex_state = 120},
  [573] = {.lex_state = 120},
  [574] = {.lex_state = 120},
  [575] = {.lex_state = 120},
  [576] = {.lex_state = 120},
  [577] = {.lex_state = 120},
  [578] = {.lex_state = 120},
  [579] = {.lex_state = 120},
  [580] = {.lex_state = 120},
  [581] = {.lex_state = 120},
  [582] = {.lex_state = 120},
  [583] = {.lex_state = 120},
  [584] = {.lex_state = 120},
  [585] = {.lex_state = 120},
  [586] = {.lex_state = 120},
  [587] = {.lex_state = 120},
  [588] = {.lex_state = 120},
  [589] = {.lex_state = 120},
  [590] = {.lex_state = 120},
  [591] = {.lex_state = 120},
  [592] = {.lex_state = 120},
  [593] = {.lex_state = 120},
  [594] = {.lex_state = 120},
  [595] = {.lex_state = 120},
  [596] = {.lex_state = 120},
  [597] = {.lex_state = 120},
  [598] = {.lex_state = 120},
  [599] = {.lex_state = 120},
  [600] = {.lex_state = 120},
  [601] = {.lex_state = 120},
  [602] = {.lex_state = 120},
  [603] = {.lex_state = 120},
  [604] = {.lex_state = 120},
  [605] = {.lex_state = 120},
  [606] = {.lex_state = 120},
  [607] = {.lex_state = 120},
  [608] = {.lex_state = 120},
  [609] = {.lex_state = 120},
  [610] = {.lex_state = 120},
  [611] = {.lex_state = 120},
  [612] = {.lex_state = 120},
  [613] = {.lex_state = 120},
  [614] = {.lex_state = 120},
  [615] = {.lex_state = 120},
  [616] = {.lex_state = 120},
  [617] = {.lex_state = 120},
  [618] = {.lex_state = 120},
  [619] = {.lex_state = 120},
  [620] = {.lex_state = 120},
  [621] = {.lex_state = 120},
  [622] = {.lex_state = 120},
  [623] = {.lex_state = 120},
  [624] = {.lex_state = 120},
  [625] = {.lex_state = 120},
  [626] = {.lex_state = 120},
  [627] = {.lex_state = 120},
  [628] = {.lex_state = 49},
  [629] = {.lex_state = 49},
  [630] = {.lex_state = 49},
  [631] = {.lex_state = 49},
  [632] = {.lex_state = 53},
  [633] = {.lex_state = 53},
  [634] = {.lex_state = 50},
  [635] = {.lex_state = 50},
  [636] = {.lex_state = 50},
  [637] = {.lex_state = 50},
  [638] = {.lex_state = 49},
  [639] = {.lex_state = 50},
  [640] = {.lex_state = 50},
  [641] = {.lex_state = 50},
  [642] = {.lex_state = 49},
  [643] = {.lex_state = 50},
  [644] = {.lex_state = 50},
  [645] = {.lex_state = 50},
  [646] = {.lex_state = 53},
  [647] = {.lex_state = 53},
  [648] = {.lex_state = 53},
  [649] = {.lex_state = 53},
  [650] = {.lex_state = 53},
  [651] = {.lex_state = 53},
  [652] = {.lex_state = 53},
  [653] = {.lex_state = 53},
  [654] = {.lex_state = 53},
  [655] = {.lex_state = 53},
  [656] = {.lex_state = 53},
  [657] = {.lex_state = 53},
  [658] = {.lex_state = 53},
  [659] = {.lex_state = 53},
  [660] = {.lex_state = 53},
  [661] = {.lex_state = 53},
  [662] = {.lex_state = 53},
  [663] = {.lex_state = 53},
  [664] = {.lex_state = 53},
  [665] = {.lex_state = 53},
  [666] = {.lex_state = 53},
  [667] = {.lex_state = 120},
  [668] = {.lex_state = 120},
  [669] = {.lex_state = 120},
  [670] = {.lex_state = 120},
  [671] = {.lex_state = 50},
  [672] = {.lex_state = 53},
  [673] = {.lex_state = 49},
  [674] = {.lex_state = 53},
  [675] = {.lex_state = 53},
  [676] = {.lex_state = 50},
  [677] = {.lex_state = 50},
  [678] = {.lex_state = 50},
  [679] = {.lex_state = 50},
  [680] = {.lex_state = 50},
  [681] = {.lex_state = 50},
  [682] = {.lex_state = 50},
  [683] = {.lex_state = 53},
  [684] = {.lex_state = 50},
  [685] = {.lex_state = 50},
  [686] = {.lex_state = 50},
  [687] = {.lex_state = 50},
  [688] = {.lex_state = 50},
  [689] = {.lex_state = 50},
  [690] = {.lex_state = 50},
  [691] = {.lex_state = 53},
  [692] = {.lex_state = 50},
  [693] = {.lex_state = 50},
  [694] = {.lex_state = 53},
  [695] = {.lex_state = 53},
  [696] = {.lex_state = 53},
  [697] = {.lex_state = 53},
  [698] = {.lex_state = 50},
  [699] = {.lex_state = 120},
  [700] = {.lex_state = 50},
  [701] = {.lex_state = 51},
  [702] = {.lex_state = 50},
  [703] = {.lex_state = 120},
  [704] = {.lex_state = 50},
  [705] = {.lex_state = 50},
  [706] = {.lex_state = 51},
  [707] = {.lex_state = 50},
  [708] = {.lex_state = 50},
  [709] = {.lex_state = 51},
  [710] = {.lex_state = 53},
  [711] = {.lex_state = 53},
  [712] = {.lex_state = 53},
  [713] = {.lex_state = 53},
  [714] = {.lex_state = 49},
  [715] = {.lex_state = 53},
  [716] = {.lex_state = 53},
  [717] = {.lex_state = 53},
  [718] = {.lex_state = 49},
  [719] = {.lex_state = 49},
  [720] = {.lex_state = 53},
  [721] = {.lex_state = 53},
  [722] = {.lex_state = 53},
  [723] = {.lex_state = 53},
  [724] = {.lex_state = 53},
  [725] = {.lex_state = 53},
  [726] = {.lex_state = 53},
  [727] = {.lex_state = 53},
  [728] = {.lex_state = 53},
  [729] = {.lex_state = 53},
  [730] = {.lex_state = 53},
  [731] = {.lex_state = 53},
  [732] = {.lex_state = 53},
  [733] = {.lex_state = 53},
  [734] = {.lex_state = 53},
  [735] = {.lex_state = 53},
  [736] = {.lex_state = 53},
  [737] = {.lex_state = 53},
  [738] = {.lex_state = 53},
  [739] = {.lex_state = 53},
  [740] = {.lex_state = 53},
  [741] = {.lex_state = 53},
  [742] = {.lex_state = 53},
  [743] = {.lex_state = 53},
  [744] = {.lex_state = 53},
  [745] = {.lex_state = 53},
  [746] = {.lex_state = 53},
  [747] = {.lex_state = 53},
  [748] = {.lex_state = 53},
  [749] = {.lex_state = 53},
  [750] = {.lex_state = 53},
  [751] = {.lex_state = 53},
  [752] = {.lex_state = 53},
  [753] = {.lex_state = 53},
  [754] = {.lex_state = 53},
  [755] = {.lex_state = 53},
  [756] = {.lex_state = 53},
  [757] = {.lex_state = 53},
  [758] = {.lex_state = 53},
  [759] = {.lex_state = 53},
  [760] = {.lex_state = 53},
  [761] = {.lex_state = 53},
  [762] = {.lex_state = 53},
  [763] = {.lex_state = 53},
  [764] = {.lex_state = 53},
  [765] = {.lex_state = 53},
  [766] = {.lex_state = 53},
  [767] = {.lex_state = 53},
  [768] = {.lex_state = 53},
  [769] = {.lex_state = 53},
  [770] = {.lex_state = 53},
  [771] = {.lex_state = 53},
  [772] = {.lex_state = 53},
  [773] = {.lex_state = 53},
  [774] = {.lex_state = 53},
  [775] = {.lex_state = 53},
  [776] = {.lex_state = 53},
  [777] = {.lex_state = 53},
  [778] = {.lex_state = 53},
  [779] = {.lex_state = 53},
  [780] = {.lex_state = 53},
  [781] = {.lex_state = 53},
  [782] = {.lex_state = 53},
  [783] = {.lex_state = 53},
  [784] = {.lex_state = 53},
  [785] = {.lex_state = 53},
  [786] = {.lex_state = 53},
  [787] = {.lex_state = 53},
  [788] = {.lex_state = 49},
  [789] = {.lex_state = 53},
  [790] = {.lex_state = 53},
  [791] = {.lex_state = 53},
  [792] = {.lex_state = 49},
  [793] = {.lex_state = 53},
  [794] = {.lex_state = 53},
  [795] = {.lex_state = 53},
  [796] = {.lex_state = 49},
  [797] = {.lex_state = 53},
  [798] = {.lex_state = 53},
  [799] = {.lex_state = 49},
  [800] = {.lex_state = 53},
  [801] = {.lex_state = 49},
  [802] = {.lex_state = 53},
  [803] = {.lex_state = 53},
  [804] = {.lex_state = 49},
  [805] = {.lex_state = 53},
  [806] = {.lex_state = 53},
  [807] = {.lex_state = 53},
  [808] = {.lex_state = 53},
  [809] = {.lex_state = 53},
  [810] = {.lex_state = 53},
  [811] = {.lex_state = 53},
  [812] = {.lex_state = 53},
  [813] = {.lex_state = 53},
  [814] = {.lex_state = 53},
  [815] = {.lex_state = 53},
  [816] = {.lex_state = 53},
  [817] = {.lex_state = 53},
  [818] = {.lex_state = 53},
  [819] = {.lex_state = 53},
  [820] = {.lex_state = 53},
  [821] = {.lex_state = 53},
  [822] = {.lex_state = 53},
  [823] = {.lex_state = 50},
  [824] = {.lex_state = 50},
  [825] = {.lex_state = 50},
  [826] = {.lex_state = 50},
  [827] = {.lex_state = 53},
  [828] = {.lex_state = 50},
  [829] = {.lex_state = 50},
  [830] = {.lex_state = 50},
  [831] = {.lex_state = 50},
  [832] = {.lex_state = 50},
  [833] = {.lex_state = 50},
  [834] = {.lex_state = 50},
  [835] = {.lex_state = 50},
  [836] = {.lex_state = 53},
  [837] = {.lex_state = 53},
  [838] = {.lex_state = 53},
  [839] = {.lex_state = 53},
  [840] = {.lex_state = 49},
  [841] = {.lex_state = 53},
  [842] = {.lex_state = 50},
  [843] = {.lex_state = 53},
  [844] = {.lex_state = 53},
  [845] = {.lex_state = 50},
  [846] = {.lex_state = 53},
  [847] = {.lex_state = 53},
  [848] = {.lex_state = 53},
  [849] = {.lex_state = 53},
  [850] = {.lex_state = 49},
  [851] = {.lex_state = 57},
  [852] = {.lex_state = 57},
  [853] = {.lex_state = 53},
  [854] = {.lex_state = 57},
  [855] = {.lex_state = 57},
  [856] = {.lex_state = 57},
  [857] = {.lex_state = 57},
  [858] = {.lex_state = 52},
  [859] = {.lex_state = 57},
  [860] = {.lex_state = 52},
  [861] = {.lex_state = 57},
  [862] = {.lex_state = 52},
  [863] = {.lex_state = 52},
  [864] = {.lex_state = 52},
  [865] = {.lex_state = 52},
  [866] = {.lex_state = 52},
  [867] = {.lex_state = 52},
  [868] = {.lex_state = 49},
  [869] = {.lex_state = 49},
  [870] = {.lex_state = 57},
  [871] = {.lex_state = 52},
  [872] = {.lex_state = 57},
  [873] = {.lex_state = 57},
  [874] = {.lex_state = 52},
  [875] = {.lex_state = 52},
  [876] = {.lex_state = 53},
  [877] = {.lex_state = 52},
  [878] = {.lex_state = 49},
  [879] = {.lex_state = 53},
  [880] = {.lex_state = 57},
  [881] = {.lex_state = 57},
  [882] = {.lex_state = 52},
  [883] = {.lex_state = 57},
  [884] = {.lex_state = 57},
  [885] = {.lex_state = 57},
  [886] = {.lex_state = 57},
  [887] = {.lex_state = 52},
  [888] = {.lex_state = 52},
  [889] = {.lex_state = 57},
  [890] = {.lex_state = 52},
  [891] = {.lex_state = 52},
  [892] = {.lex_state = 52},
  [893] = {.lex_state = 53},
  [894] = {.lex_state = 53},
  [895] = {.lex_state = 49},
  [896] = {.lex_state = 49},
  [897] = {.lex_state = 53},
  [898] = {.lex_state = 49},
  [899] = {.lex_state = 49},
  [900] = {.lex_state = 49},
  [901] = {.lex_state = 49},
  [902] = {.lex_state = 49},
  [903] = {.lex_state = 49},
  [904] = {.lex_state = 49},
  [905] = {.lex_state = 49},
  [906] = {.lex_state = 49},
  [907] = {.lex_state = 49},
  [908] = {.lex_state = 53},
  [909] = {.lex_state = 49},
  [910] = {.lex_state = 49},
  [911] = {.lex_state = 49},
  [912] = {.lex_state = 49},
  [913] = {.lex_state = 49},
  [914] = {.lex_state = 49},
  [915] = {.lex_state = 49},
  [916] = {.lex_state = 53},
  [917] = {.lex_state = 53},
  [918] = {.lex_state = 120},
  [919] = {.lex_state = 120},
  [920] = {.lex_state = 120},
  [921] = {.lex_state = 120},
  [922] = {.lex_state = 120},
  [923] = {.lex_state = 53},
  [924] = {.lex_state = 120},
  [925] = {.lex_state = 49},
  [926] = {.lex_state = 120},
  [927] = {.lex_state = 49},
  [928] = {.lex_state = 120},
  [929] = {.lex_state = 120},
  [930] = {.lex_state = 120},
  [931] = {.lex_state = 49},
  [932] = {.lex_state = 49},
  [933] = {.lex_state = 53},
  [934] = {.lex_state = 53},
  [935] = {.lex_state = 49},
  [936] = {.lex_state = 53},
  [937] = {.lex_state = 53},
  [938] = {.lex_state = 53},
  [939] = {.lex_state = 53},
  [940] = {.lex_state = 53},
  [941] = {.lex_state = 53},
  [942] = {.lex_state = 53},
  [943] = {.lex_state = 53},
  [944] = {.lex_state = 53},
  [945] = {.lex_state = 53},
  [946] = {.lex_state = 53},
  [947] = {.lex_state = 53},
  [948] = {.lex_state = 53},
  [949] = {.lex_state = 53},
  [950] = {.lex_state = 53},
  [951] = {.lex_state = 53},
  [952] = {.lex_state = 53},
  [953] = {.lex_state = 53},
  [954] = {.lex_state = 53},
  [955] = {.lex_state = 53},
  [956] = {.lex_state = 53},
  [957] = {.lex_state = 53},
  [958] = {.lex_state = 53},
  [959] = {.lex_state = 53},
  [960] = {.lex_state = 53},
  [961] = {.lex_state = 53},
  [962] = {.lex_state = 53},
  [963] = {.lex_state = 53},
  [964] = {.lex_state = 53},
  [965] = {.lex_state = 53},
  [966] = {.lex_state = 53},
  [967] = {.lex_state = 53},
  [968] = {.lex_state = 50},
  [969] = {.lex_state = 53},
  [970] = {.lex_state = 50},
  [971] = {.lex_state = 50},
  [972] = {.lex_state = 50},
  [973] = {.lex_state = 50},
  [974] = {.lex_state = 50},
  [975] = {.lex_state = 50},
  [976] = {.lex_state = 50},
  [977] = {.lex_state = 50},
  [978] = {.lex_state = 50},
  [979] = {.lex_state = 50},
  [980] = {.lex_state = 50},
  [981] = {.lex_state = 50},
  [982] = {.lex_state = 53},
  [983] = {.lex_state = 53},
  [984] = {.lex_state = 53},
  [985] = {.lex_state = 53},
  [986] = {.lex_state = 53},
  [987] = {.lex_state = 50},
  [988] = {.lex_state = 53},
  [989] = {.lex_state = 53},
  [990] = {.lex_state = 53},
  [991] = {.lex_state = 53},
  [992] = {.lex_state = 53},
  [993] = {.lex_state = 53},
  [994] = {.lex_state = 53},
  [995] = {.lex_state = 53},
  [996] = {.lex_state = 53},
  [997] = {.lex_state = 53},
  [998] = {.lex_state = 53},
  [999] = {.lex_state = 52},
  [1000] = {.lex_state = 52},
  [1001] = {.lex_state = 53},
  [1002] = {.lex_state = 53},
  [1003] = {.lex_state = 53},
  [1004] = {.lex_state = 52},
  [1005] = {.lex_state = 53},
  [1006] = {.lex_state = 53},
  [1007] = {.lex_state = 53},
  [1008] = {.lex_state = 53},
  [1009] = {.lex_state = 53},
  [1010] = {.lex_state = 53},
  [1011] = {.lex_state = 53},
  [1012] = {.lex_state = 52},
  [1013] = {.lex_state = 53},
  [1014] = {.lex_state = 53},
  [1015] = {.lex_state = 53},
  [1016] = {.lex_state = 53},
  [1017] = {.lex_state = 53},
  [1018] = {.lex_state = 53},
  [1019] = {.lex_state = 49},
  [1020] = {.lex_state = 53},
  [1021] = {.lex_state = 53},
  [1022] = {.lex_state = 53},
  [1023] = {.lex_state = 49},
  [1024] = {.lex_state = 49},
  [1025] = {.lex_state = 49},
  [1026] = {.lex_state = 49},
  [1027] = {.lex_state = 49},
  [1028] = {.lex_state = 49},
  [1029] = {.lex_state = 49},
  [1030] = {.lex_state = 49},
  [1031] = {.lex_state = 49},
  [1032] = {.lex_state = 49},
  [1033] = {.lex_state = 49},
  [1034] = {.lex_state = 49},
  [1035] = {.lex_state = 49},
  [1036] = {.lex_state = 49},
  [1037] = {.lex_state = 49},
  [1038] = {.lex_state = 49},
  [1039] = {.lex_state = 49},
  [1040] = {.lex_state = 49},
  [1041] = {.lex_state = 49},
  [1042] = {.lex_state = 49},
  [1043] = {.lex_state = 49},
  [1044] = {.lex_state = 53},
  [1045] = {.lex_state = 49},
  [1046] = {.lex_state = 49},
  [1047] = {.lex_state = 49},
  [1048] = {.lex_state = 49},
  [1049] = {.lex_state = 49},
  [1050] = {.lex_state = 49},
  [1051] = {.lex_state = 49},
  [1052] = {.lex_state = 49},
  [1053] = {.lex_state = 49},
  [1054] = {.lex_state = 49},
  [1055] = {.lex_state = 49},
  [1056] = {.lex_state = 49},
  [1057] = {.lex_state = 49},
  [1058] = {.lex_state = 49},
  [1059] = {.lex_state = 49},
  [1060] = {.lex_state = 49},
  [1061] = {.lex_state = 49},
  [1062] = {.lex_state = 53},
  [1063] = {.lex_state = 53},
  [1064] = {.lex_state = 49},
  [1065] = {.lex_state = 49},
  [1066] = {.lex_state = 49},
  [1067] = {.lex_state = 49},
  [1068] = {.lex_state = 49},
  [1069] = {.lex_state = 53},
  [1070] = {.lex_state = 49},
  [1071] = {.lex_state = 49},
  [1072] = {.lex_state = 49},
  [1073] = {.lex_state = 49},
  [1074] = {.lex_state = 49},
  [1075] = {.lex_state = 49},
  [1076] = {.lex_state = 53},
  [1077] = {.lex_state = 49},
  [1078] = {.lex_state = 49},
  [1079] = {.lex_state = 49},
  [1080] = {.lex_state = 49},
  [1081] = {.lex_state = 49},
  [1082] = {.lex_state = 49},
  [1083] = {.lex_state = 49},
  [1084] = {.lex_state = 53},
  [1085] = {.lex_state = 53},
  [1086] = {.lex_state = 49},
  [1087] = {.lex_state = 53},
  [1088] = {.lex_state = 49},
  [1089] = {.lex_state = 49},
  [1090] = {.lex_state = 49},
  [1091] = {.lex_state = 53},
  [1092] = {.lex_state = 49},
  [1093] = {.lex_state = 53},
  [1094] = {.lex_state = 49},
  [1095] = {.lex_state = 49},
  [1096] = {.lex_state = 49},
  [1097] = {.lex_state = 49},
  [1098] = {.lex_state = 49},
  [1099] = {.lex_state = 49},
  [1100] = {.lex_state = 49},
  [1101] = {.lex_state = 53},
  [1102] = {.lex_state = 49},
  [1103] = {.lex_state = 49},
  [1104] = {.lex_state = 49},
  [1105] = {.lex_state = 49},
  [1106] = {.lex_state = 49},
  [1107] = {.lex_state = 49},
  [1108] = {.lex_state = 49},
  [1109] = {.lex_state = 53},
  [1110] = {.lex_state = 53},
  [1111] = {.lex_state = 53},
  [1112] = {.lex_state = 53},
  [1113] = {.lex_state = 53},
  [1114] = {.lex_state = 53},
  [1115] = {.lex_state = 53},
  [1116] = {.lex_state = 49},
  [1117] = {.lex_state = 53},
  [1118] = {.lex_state = 53},
  [1119] = {.lex_state = 49},
  [1120] = {.lex_state = 53},
  [1121] = {.lex_state = 53},
  [1122] = {.lex_state = 53},
  [1123] = {.lex_state = 53},
  [1124] = {.lex_state = 53},
  [1125] = {.lex_state = 53},
  [1126] = {.lex_state = 53},
  [1127] = {.lex_state = 53},
  [1128] = {.lex_state = 53},
  [1129] = {.lex_state = 53},
  [1130] = {.lex_state = 53},
  [1131] = {.lex_state = 53},
  [1132] = {.lex_state = 53},
  [1133] = {.lex_state = 53},
  [1134] = {.lex_state = 53},
  [1135] = {.lex_state = 53},
  [1136] = {.lex_state = 53},
  [1137] = {.lex_state = 53},
  [1138] = {.lex_state = 53},
  [1139] = {.lex_state = 53},
  [1140] = {.lex_state = 53},
  [1141] = {.lex_state = 53},
  [1142] = {.lex_state = 53},
  [1143] = {.lex_state = 53},
  [1144] = {.lex_state = 53},
  [1145] = {.lex_state = 52},
  [1146] = {.lex_state = 53},
  [1147] = {.lex_state = 53},
  [1148] = {.lex_state = 53},
  [1149] = {.lex_state = 53},
  [1150] = {.lex_state = 52},
  [1151] = {.lex_state = 52},
  [1152] = {.lex_state = 53},
  [1153] = {.lex_state = 53},
  [1154] = {.lex_state = 53},
  [1155] = {.lex_state = 53},
  [1156] = {.lex_state = 53},
  [1157] = {.lex_state = 52},
  [1158] = {.lex_state = 53},
  [1159] = {.lex_state = 53},
  [1160] = {.lex_state = 53},
  [1161] = {.lex_state = 48},
  [1162] = {.lex_state = 53},
  [1163] = {.lex_state = 48},
  [1164] = {.lex_state = 48},
  [1165] = {.lex_state = 53},
  [1166] = {.lex_state = 25},
  [1167] = {.lex_state = 48},
  [1168] = {.lex_state = 52},
  [1169] = {.lex_state = 52},
  [1170] = {.lex_state = 48},
  [1171] = {.lex_state = 52},
  [1172] = {.lex_state = 48},
  [1173] = {.lex_state = 48},
  [1174] = {.lex_state = 48},
  [1175] = {.lex_state = 48},
  [1176] = {.lex_state = 52},
  [1177] = {.lex_state = 48},
  [1178] = {.lex_state = 52},
  [1179] = {.lex_state = 48},
  [1180] = {.lex_state = 52},
  [1181] = {.lex_state = 48},
  [1182] = {.lex_state = 52},
  [1183] = {.lex_state = 48},
  [1184] = {.lex_state = 52},
  [1185] = {.lex_state = 48},
  [1186] = {.lex_state = 48},
  [1187] = {.lex_state = 52},
  [1188] = {.lex_state = 48},
  [1189] = {.lex_state = 52},
  [1190] = {.lex_state = 52},
  [1191] = {.lex_state = 48},
  [1192] = {.lex_state = 48},
  [1193] = {.lex_state = 48},
  [1194] = {.lex_state = 48},
  [1195] = {.lex_state = 48},
  [1196] = {.lex_state = 48},
  [1197] = {.lex_state = 48},
  [1198] = {.lex_state = 48},
  [1199] = {.lex_state = 48},
  [1200] = {.lex_state = 48},
  [1201] = {.lex_state = 48},
  [1202] = {.lex_state = 52},
  [1203] = {.lex_state = 48},
  [1204] = {.lex_state = 48},
  [1205] = {.lex_state = 52},
  [1206] = {.lex_state = 48},
  [1207] = {.lex_state = 48},
  [1208] = {.lex_state = 48},
  [1209] = {.lex_state = 48},
  [1210] = {.lex_state = 48},
  [1211] = {.lex_state = 48},
  [1212] = {.lex_state = 48},
  [1213] = {.lex_state = 52},
  [1214] = {.lex_state = 48},
  [1215] = {.lex_state = 48},
  [1216] = {.lex_state = 48},
  [1217] = {.lex_state = 48},
  [1218] = {.lex_state = 52},
  [1219] = {.lex_state = 48},
  [1220] = {.lex_state = 52},
  [1221] = {.lex_state = 48},
  [1222] = {.lex_state = 52},
  [1223] = {.lex_state = 25},
  [1224] = {.lex_state = 25},
  [1225] = {.lex_state = 25},
  [1226] = {.lex_state = 25},
  [1227] = {.lex_state = 25},
  [1228] = {.lex_state = 25},
  [1229] = {.lex_state = 25},
  [1230] = {.lex_state = 25},
  [1231] = {.lex_state = 25},
  [1232] = {.lex_state = 25},
  [1233] = {.lex_state = 52},
  [1234] = {.lex_state = 25},
  [1235] = {.lex_state = 25},
  [1236] = {.lex_state = 25},
  [1237] = {.lex_state = 25},
  [1238] = {.lex_state = 25},
  [1239] = {.lex_state = 25},
  [1240] = {.lex_state = 25},
  [1241] = {.lex_state = 25},
  [1242] = {.lex_state = 25},
  [1243] = {.lex_state = 25},
  [1244] = {.lex_state = 25},
  [1245] = {.lex_state = 25},
  [1246] = {.lex_state = 53},
  [1247] = {.lex_state = 25},
  [1248] = {.lex_state = 25},
  [1249] = {.lex_state = 25},
  [1250] = {.lex_state = 25},
  [1251] = {.lex_state = 25},
  [1252] = {.lex_state = 53},
  [1253] = {.lex_state = 25},
  [1254] = {.lex_state = 25},
  [1255] = {.lex_state = 53},
  [1256] = {.lex_state = 25},
  [1257] = {.lex_state = 25},
  [1258] = {.lex_state = 25},
  [1259] = {.lex_state = 53},
  [1260] = {.lex_state = 25},
  [1261] = {.lex_state = 53},
  [1262] = {.lex_state = 53},
  [1263] = {.lex_state = 53},
  [1264] = {.lex_state = 53},
  [1265] = {.lex_state = 53},
  [1266] = {.lex_state = 53},
  [1267] = {.lex_state = 53},
  [1268] = {.lex_state = 53},
  [1269] = {.lex_state = 53},
  [1270] = {.lex_state = 53},
  [1271] = {.lex_state = 53},
  [1272] = {.lex_state = 53},
  [1273] = {.lex_state = 53},
  [1274] = {.lex_state = 53},
  [1275] = {.lex_state = 53},
  [1276] = {.lex_state = 53},
  [1277] = {.lex_state = 53},
  [1278] = {.lex_state = 53},
  [1279] = {.lex_state = 53},
  [1280] = {.lex_state = 53},
  [1281] = {.lex_state = 53},
  [1282] = {.lex_state = 53},
  [1283] = {.lex_state = 53},
  [1284] = {.lex_state = 53},
  [1285] = {.lex_state = 53},
  [1286] = {.lex_state = 53},
  [1287] = {.lex_state = 53},
  [1288] = {.lex_state = 53},
  [1289] = {.lex_state = 53},
  [1290] = {.lex_state = 53},
  [1291] = {.lex_state = 50},
  [1292] = {.lex_state = 50},
  [1293] = {.lex_state = 50},
  [1294] = {.lex_state = 50},
  [1295] = {.lex_state = 53},
  [1296] = {.lex_state = 53},
  [1297] = {.lex_state = 53},
  [1298] = {.lex_state = 53},
  [1299] = {.lex_state = 53},
  [1300] = {.lex_state = 53},
  [1301] = {.lex_state = 53},
  [1302] = {.lex_state = 53},
  [1303] = {.lex_state = 53},
  [1304] = {.lex_state = 53},
  [1305] = {.lex_state = 53},
  [1306] = {.lex_state = 53},
  [1307] = {.lex_state = 53},
  [1308] = {.lex_state = 53},
  [1309] = {.lex_state = 53},
  [1310] = {.lex_state = 53},
  [1311] = {.lex_state = 53},
  [1312] = {.lex_state = 53},
  [1313] = {.lex_state = 53},
  [1314] = {.lex_state = 53},
  [1315] = {.lex_state = 53},
  [1316] = {.lex_state = 53},
  [1317] = {.lex_state = 56},
  [1318] = {.lex_state = 53},
  [1319] = {.lex_state = 53},
  [1320] = {.lex_state = 53},
  [1321] = {.lex_state = 53},
  [1322] = {.lex_state = 53},
  [1323] = {.lex_state = 53},
  [1324] = {.lex_state = 56},
  [1325] = {.lex_state = 53},
  [1326] = {.lex_state = 53},
  [1327] = {.lex_state = 53},
  [1328] = {.lex_state = 53},
  [1329] = {.lex_state = 53},
  [1330] = {.lex_state = 53},
  [1331] = {.lex_state = 49},
  [1332] = {.lex_state = 50},
  [1333] = {.lex_state = 53},
  [1334] = {.lex_state = 56},
  [1335] = {.lex_state = 53},
  [1336] = {.lex_state = 50},
  [1337] = {.lex_state = 53},
  [1338] = {.lex_state = 53},
  [1339] = {.lex_state = 53},
  [1340] = {.lex_state = 50},
  [1341] = {.lex_state = 50},
  [1342] = {.lex_state = 50},
  [1343] = {.lex_state = 50},
  [1344] = {.lex_state = 50},
  [1345] = {.lex_state = 53},
  [1346] = {.lex_state = 50},
  [1347] = {.lex_state = 50},
  [1348] = {.lex_state = 50},
  [1349] = {.lex_state = 53},
  [1350] = {.lex_state = 53},
  [1351] = {.lex_state = 53},
  [1352] = {.lex_state = 50},
  [1353] = {.lex_state = 50},
  [1354] = {.lex_state = 53},
  [1355] = {.lex_state = 53},
  [1356] = {.lex_state = 53},
  [1357] = {.lex_state = 53},
  [1358] = {.lex_state = 53},
  [1359] = {.lex_state = 50},
  [1360] = {.lex_state = 50},
  [1361] = {.lex_state = 53},
  [1362] = {.lex_state = 53},
  [1363] = {.lex_state = 53},
  [1364] = {.lex_state = 0},
  [1365] = {.lex_state = 120},
  [1366] = {.lex_state = 53},
  [1367] = {.lex_state = 53},
  [1368] = {.lex_state = 53},
  [1369] = {.lex_state = 53},
  [1370] = {.lex_state = 53},
  [1371] = {.lex_state = 53},
  [1372] = {.lex_state = 0},
  [1373] = {.lex_state = 120},
  [1374] = {.lex_state = 120},
  [1375] = {.lex_state = 53},
  [1376] = {.lex_state = 120},
  [1377] = {.lex_state = 49},
  [1378] = {.lex_state = 120},
  [1379] = {.lex_state = 54},
  [1380] = {.lex_state = 53},
  [1381] = {.lex_state = 120},
  [1382] = {.lex_state = 53},
  [1383] = {.lex_state = 53},
  [1384] = {.lex_state = 53},
  [1385] = {.lex_state = 49},
  [1386] = {.lex_state = 49},
  [1387] = {.lex_state = 54},
  [1388] = {.lex_state = 53},
  [1389] = {.lex_state = 53},
  [1390] = {.lex_state = 54},
  [1391] = {.lex_state = 120},
  [1392] = {.lex_state = 53},
  [1393] = {.lex_state = 120},
  [1394] = {.lex_state = 120},
  [1395] = {.lex_state = 53},
  [1396] = {.lex_state = 53},
  [1397] = {.lex_state = 53},
  [1398] = {.lex_state = 54},
  [1399] = {.lex_state = 53},
  [1400] = {.lex_state = 120},
  [1401] = {.lex_state = 120},
  [1402] = {.lex_state = 120},
  [1403] = {.lex_state = 53},
  [1404] = {.lex_state = 120},
  [1405] = {.lex_state = 53},
  [1406] = {.lex_state = 120},
  [1407] = {.lex_state = 120},
  [1408] = {.lex_state = 120},
  [1409] = {.lex_state = 53},
  [1410] = {.lex_state = 53},
  [1411] = {.lex_state = 120},
  [1412] = {.lex_state = 120},
  [1413] = {.lex_state = 53},
  [1414] = {.lex_state = 53},
  [1415] = {.lex_state = 50},
  [1416] = {.lex_state = 120},
  [1417] = {.lex_state = 50},
  [1418] = {.lex_state = 53},
  [1419] = {.lex_state = 0},
  [1420] = {.lex_state = 53},
  [1421] = {.lex_state = 53},
  [1422] = {.lex_state = 120},
  [1423] = {.lex_state = 53},
  [1424] = {.lex_state = 53},
  [1425] = {.lex_state = 120},
  [1426] = {.lex_state = 53},
  [1427] = {.lex_state = 50},
  [1428] = {.lex_state = 120},
  [1429] = {.lex_state = 53},
  [1430] = {.lex_state = 53},
  [1431] = {.lex_state = 0},
  [1432] = {.lex_state = 53},
  [1433] = {.lex_state = 120},
  [1434] = {.lex_state = 120},
  [1435] = {.lex_state = 120},
  [1436] = {.lex_state = 53},
  [1437] = {.lex_state = 53},
  [1438] = {.lex_state = 120},
  [1439] = {.lex_state = 120},
  [1440] = {.lex_state = 53},
  [1441] = {.lex_state = 53},
  [1442] = {.lex_state = 53},
  [1443] = {.lex_state = 120},
  [1444] = {.lex_state = 0},
  [1445] = {.lex_state = 53},
  [1446] = {.lex_state = 53},
  [1447] = {.lex_state = 53},
  [1448] = {.lex_state = 53},
  [1449] = {.lex_state = 53},
  [1450] = {.lex_state = 53},
  [1451] = {.lex_state = 53},
  [1452] = {.lex_state = 53},
  [1453] = {.lex_state = 53},
  [1454] = {.lex_state = 120},
  [1455] = {.lex_state = 53},
  [1456] = {.lex_state = 0},
  [1457] = {.lex_state = 53},
  [1458] = {.lex_state = 53},
  [1459] = {.lex_state = 53},
  [1460] = {.lex_state = 53},
  [1461] = {.lex_state = 120},
  [1462] = {.lex_state = 53},
  [1463] = {.lex_state = 50},
  [1464] = {.lex_state = 53},
  [1465] = {.lex_state = 53},
  [1466] = {.lex_state = 53},
  [1467] = {.lex_state = 53},
  [1468] = {.lex_state = 53},
  [1469] = {.lex_state = 120},
  [1470] = {.lex_state = 120},
  [1471] = {.lex_state = 53},
  [1472] = {.lex_state = 53},
  [1473] = {.lex_state = 53},
  [1474] = {.lex_state = 120},
  [1475] = {.lex_state = 53},
  [1476] = {.lex_state = 56},
  [1477] = {.lex_state = 0},
  [1478] = {.lex_state = 53},
  [1479] = {.lex_state = 0},
  [1480] = {.lex_state = 56},
  [1481] = {.lex_state = 120},
  [1482] = {.lex_state = 56},
  [1483] = {.lex_state = 56},
  [1484] = {.lex_state = 120},
  [1485] = {.lex_state = 56},
  [1486] = {.lex_state = 120},
  [1487] = {.lex_state = 50},
  [1488] = {.lex_state = 56},
  [1489] = {.lex_state = 56},
  [1490] = {.lex_state = 56},
  [1491] = {.lex_state = 53},
  [1492] = {.lex_state = 53},
  [1493] = {.lex_state = 56},
  [1494] = {.lex_state = 53},
  [1495] = {.lex_state = 120},
  [1496] = {.lex_state = 56},
  [1497] = {.lex_state = 0},
  [1498] = {.lex_state = 56},
  [1499] = {.lex_state = 53},
  [1500] = {.lex_state = 53},
  [1501] = {.lex_state = 53},
  [1502] = {.lex_state = 53},
  [1503] = {.lex_state = 53},
  [1504] = {.lex_state = 53},
  [1505] = {.lex_state = 53},
  [1506] = {.lex_state = 53},
  [1507] = {.lex_state = 53},
  [1508] = {.lex_state = 53},
  [1509] = {.lex_state = 53},
  [1510] = {.lex_state = 53},
  [1511] = {.lex_state = 53},
  [1512] = {.lex_state = 53},
  [1513] = {.lex_state = 53},
  [1514] = {.lex_state = 53},
  [1515] = {.lex_state = 53},
  [1516] = {.lex_state = 45},
  [1517] = {.lex_state = 50},
  [1518] = {.lex_state = 53},
  [1519] = {.lex_state = 53},
  [1520] = {.lex_state = 53},
  [1521] = {.lex_state = 53},
  [1522] = {.lex_state = 53},
  [1523] = {.lex_state = 53},
  [1524] = {.lex_state = 53},
  [1525] = {.lex_state = 53},
  [1526] = {.lex_state = 53},
  [1527] = {.lex_state = 30},
  [1528] = {.lex_state = 32},
  [1529] = {.lex_state = 50},
  [1530] = {.lex_state = 0},
  [1531] = {.lex_state = 0},
  [1532] = {.lex_state = 0},
  [1533] = {.lex_state = 53},
  [1534] = {.lex_state = 50},
  [1535] = {.lex_state = 50},
  [1536] = {.lex_state = 45},
  [1537] = {.lex_state = 37},
  [1538] = {.lex_state = 0},
  [1539] = {.lex_state = 53},
  [1540] = {.lex_state = 37},
  [1541] = {.lex_state = 32},
  [1542] = {.lex_state = 53},
  [1543] = {.lex_state = 53},
  [1544] = {.lex_state = 53},
  [1545] = {.lex_state = 0},
  [1546] = {.lex_state = 53},
  [1547] = {.lex_state = 120},
  [1548] = {.lex_state = 53},
  [1549] = {.lex_state = 0},
  [1550] = {.lex_state = 50},
  [1551] = {.lex_state = 0},
  [1552] = {.lex_state = 53},
  [1553] = {.lex_state = 30},
  [1554] = {.lex_state = 37},
  [1555] = {.lex_state = 120},
  [1556] = {.lex_state = 32},
  [1557] = {.lex_state = 30},
  [1558] = {.lex_state = 37},
  [1559] = {.lex_state = 32},
  [1560] = {.lex_state = 32},
  [1561] = {.lex_state = 0},
  [1562] = {.lex_state = 32},
  [1563] = {.lex_state = 0},
  [1564] = {.lex_state = 30},
  [1565] = {.lex_state = 37},
  [1566] = {.lex_state = 0},
  [1567] = {.lex_state = 32},
  [1568] = {.lex_state = 53},
  [1569] = {.lex_state = 37},
  [1570] = {.lex_state = 37},
  [1571] = {.lex_state = 0},
  [1572] = {.lex_state = 0},
  [1573] = {.lex_state = 53},
  [1574] = {.lex_state = 0},
  [1575] = {.lex_state = 0},
  [1576] = {.lex_state = 0},
  [1577] = {.lex_state = 0},
  [1578] = {.lex_state = 34},
  [1579] = {.lex_state = 0},
  [1580] = {.lex_state = 0},
  [1581] = {.lex_state = 45},
  [1582] = {.lex_state = 0},
  [1583] = {.lex_state = 45},
  [1584] = {.lex_state = 0},
  [1585] = {.lex_state = 0},
  [1586] = {.lex_state = 0},
  [1587] = {.lex_state = 0},
  [1588] = {.lex_state = 53},
  [1589] = {.lex_state = 53},
  [1590] = {.lex_state = 45},
  [1591] = {.lex_state = 0},
  [1592] = {.lex_state = 0},
  [1593] = {.lex_state = 0},
  [1594] = {.lex_state = 0},
  [1595] = {.lex_state = 0},
  [1596] = {.lex_state = 45},
  [1597] = {.lex_state = 0},
  [1598] = {.lex_state = 0},
  [1599] = {.lex_state = 0},
  [1600] = {.lex_state = 0},
  [1601] = {.lex_state = 0},
  [1602] = {.lex_state = 0},
  [1603] = {.lex_state = 0},
  [1604] = {.lex_state = 0},
  [1605] = {.lex_state = 0},
  [1606] = {.lex_state = 0},
  [1607] = {.lex_state = 0},
  [1608] = {.lex_state = 0},
  [1609] = {.lex_state = 0},
  [1610] = {.lex_state = 53},
  [1611] = {.lex_state = 53},
  [1612] = {.lex_state = 0},
  [1613] = {.lex_state = 0},
  [1614] = {.lex_state = 34},
  [1615] = {.lex_state = 0},
  [1616] = {.lex_state = 0},
  [1617] = {.lex_state = 0},
  [1618] = {.lex_state = 0},
  [1619] = {.lex_state = 0},
  [1620] = {.lex_state = 0},
  [1621] = {.lex_state = 0},
  [1622] = {.lex_state = 0},
  [1623] = {.lex_state = 0},
  [1624] = {.lex_state = 0},
  [1625] = {.lex_state = 0},
  [1626] = {.lex_state = 0},
  [1627] = {.lex_state = 0},
  [1628] = {.lex_state = 0},
  [1629] = {.lex_state = 0},
  [1630] = {.lex_state = 0},
  [1631] = {.lex_state = 0},
  [1632] = {.lex_state = 0},
  [1633] = {.lex_state = 0},
  [1634] = {.lex_state = 0},
  [1635] = {.lex_state = 0},
  [1636] = {.lex_state = 53},
  [1637] = {.lex_state = 0},
  [1638] = {.lex_state = 0},
  [1639] = {.lex_state = 0},
  [1640] = {.lex_state = 0},
  [1641] = {.lex_state = 0},
  [1642] = {.lex_state = 0},
  [1643] = {.lex_state = 0},
  [1644] = {.lex_state = 0},
  [1645] = {.lex_state = 0},
  [1646] = {.lex_state = 0},
  [1647] = {.lex_state = 0},
  [1648] = {.lex_state = 0},
  [1649] = {.lex_state = 0},
  [1650] = {.lex_state = 0},
  [1651] = {.lex_state = 0},
  [1652] = {.lex_state = 30},
  [1653] = {.lex_state = 0},
  [1654] = {.lex_state = 53},
  [1655] = {.lex_state = 34},
  [1656] = {.lex_state = 45},
  [1657] = {.lex_state = 45},
  [1658] = {.lex_state = 0},
  [1659] = {.lex_state = 0},
  [1660] = {.lex_state = 0},
  [1661] = {.lex_state = 0},
  [1662] = {.lex_state = 45},
  [1663] = {.lex_state = 0},
  [1664] = {.lex_state = 0},
  [1665] = {.lex_state = 30},
  [1666] = {.lex_state = 0},
  [1667] = {.lex_state = 0},
  [1668] = {.lex_state = 0},
  [1669] = {.lex_state = 0},
  [1670] = {.lex_state = 0},
  [1671] = {.lex_state = 0},
  [1672] = {.lex_state = 0},
  [1673] = {.lex_state = 0},
  [1674] = {.lex_state = 0},
  [1675] = {.lex_state = 0},
  [1676] = {.lex_state = 0},
  [1677] = {.lex_state = 0},
  [1678] = {.lex_state = 0},
  [1679] = {.lex_state = 30},
  [1680] = {.lex_state = 0},
  [1681] = {.lex_state = 53},
  [1682] = {.lex_state = 0},
  [1683] = {.lex_state = 0},
  [1684] = {.lex_state = 34},
  [1685] = {.lex_state = 0},
  [1686] = {.lex_state = 0},
  [1687] = {.lex_state = 0},
  [1688] = {.lex_state = 0},
  [1689] = {.lex_state = 120},
  [1690] = {.lex_state = 33},
  [1691] = {.lex_state = 0},
  [1692] = {.lex_state = 33},
  [1693] = {.lex_state = 120},
  [1694] = {.lex_state = 53},
  [1695] = {.lex_state = 0},
  [1696] = {.lex_state = 0},
  [1697] = {.lex_state = 0},
  [1698] = {.lex_state = 0},
  [1699] = {.lex_state = 33},
  [1700] = {.lex_state = 33},
  [1701] = {.lex_state = 0},
  [1702] = {.lex_state = 120},
  [1703] = {.lex_state = 33},
  [1704] = {.lex_state = 0},
  [1705] = {.lex_state = 0},
  [1706] = {.lex_state = 33},
  [1707] = {.lex_state = 33},
  [1708] = {.lex_state = 33},
  [1709] = {.lex_state = 33},
  [1710] = {.lex_state = 0},
  [1711] = {.lex_state = 33},
  [1712] = {.lex_state = 33},
  [1713] = {.lex_state = 0},
  [1714] = {.lex_state = 0},
  [1715] = {.lex_state = 120},
  [1716] = {.lex_state = 120},
  [1717] = {.lex_state = 33},
  [1718] = {.lex_state = 33},
  [1719] = {.lex_state = 53},
  [1720] = {.lex_state = 120},
  [1721] = {.lex_state = 120},
  [1722] = {.lex_state = 120},
  [1723] = {.lex_state = 33},
  [1724] = {.lex_state = 120},
  [1725] = {.lex_state = 0},
  [1726] = {.lex_state = 120},
  [1727] = {.lex_state = 45},
  [1728] = {.lex_state = 53},
  [1729] = {.lex_state = 0},
  [1730] = {.lex_state = 45},
  [1731] = {.lex_state = 33},
  [1732] = {.lex_state = 0},
  [1733] = {.lex_state = 0},
  [1734] = {.lex_state = 53},
  [1735] = {.lex_state = 120},
  [1736] = {.lex_state = 120},
  [1737] = {.lex_state = 120},
  [1738] = {.lex_state = 120},
  [1739] = {.lex_state = 0},
  [1740] = {.lex_state = 0},
  [1741] = {.lex_state = 0},
  [1742] = {.lex_state = 120},
  [1743] = {.lex_state = 0},
  [1744] = {.lex_state = 53},
  [1745] = {.lex_state = 120},
  [1746] = {.lex_state = 120},
  [1747] = {.lex_state = 120},
  [1748] = {.lex_state = 0},
  [1749] = {.lex_state = 0},
  [1750] = {.lex_state = 0},
  [1751] = {.lex_state = 53},
  [1752] = {.lex_state = 120},
  [1753] = {.lex_state = 120},
  [1754] = {.lex_state = 120},
  [1755] = {.lex_state = 33},
  [1756] = {.lex_state = 53},
  [1757] = {.lex_state = 0},
  [1758] = {.lex_state = 0},
  [1759] = {.lex_state = 0},
  [1760] = {.lex_state = 120},
  [1761] = {.lex_state = 0},
  [1762] = {.lex_state = 120},
  [1763] = {.lex_state = 120},
  [1764] = {.lex_state = 33},
  [1765] = {.lex_state = 0},
  [1766] = {.lex_state = 0},
  [1767] = {.lex_state = 0},
  [1768] = {.lex_state = 0},
  [1769] = {.lex_state = 0},
  [1770] = {.lex_state = 0},
  [1771] = {.lex_state = 53},
  [1772] = {.lex_state = 0},
  [1773] = {.lex_state = 120},
  [1774] = {.lex_state = 45},
  [1775] = {.lex_state = 44},
  [1776] = {.lex_state = 44},
  [1777] = {.lex_state = 44},
  [1778] = {.lex_state = 120},
  [1779] = {.lex_state = 44},
  [1780] = {.lex_state = 0},
  [1781] = {.lex_state = 0},
  [1782] = {.lex_state = 44},
  [1783] = {.lex_state = 34},
  [1784] = {.lex_state = 34},
  [1785] = {.lex_state = 53},
  [1786] = {.lex_state = 34},
  [1787] = {.lex_state = 34},
  [1788] = {.lex_state = 44},
  [1789] = {.lex_state = 0},
  [1790] = {.lex_state = 0},
  [1791] = {.lex_state = 0},
  [1792] = {.lex_state = 44},
  [1793] = {.lex_state = 44},
  [1794] = {.lex_state = 34},
  [1795] = {.lex_state = 0},
  [1796] = {.lex_state = 0},
  [1797] = {.lex_state = 44},
  [1798] = {.lex_state = 0},
  [1799] = {.lex_state = 53},
  [1800] = {.lex_state = 34},
  [1801] = {.lex_state = 0},
  [1802] = {.lex_state = 34},
  [1803] = {.lex_state = 34},
  [1804] = {.lex_state = 44},
  [1805] = {.lex_state = 44},
  [1806] = {.lex_state = 34},
  [1807] = {.lex_state = 0},
  [1808] = {.lex_state = 34},
  [1809] = {.lex_state = 0},
  [1810] = {.lex_state = 0},
  [1811] = {.lex_state = 0},
  [1812] = {.lex_state = 34},
  [1813] = {.lex_state = 44},
  [1814] = {.lex_state = 0},
  [1815] = {.lex_state = 0},
  [1816] = {.lex_state = 0},
  [1817] = {.lex_state = 34},
  [1818] = {.lex_state = 44},
  [1819] = {.lex_state = 34},
  [1820] = {.lex_state = 34},
  [1821] = {.lex_state = 53},
  [1822] = {.lex_state = 34},
  [1823] = {.lex_state = 0},
  [1824] = {.lex_state = 53},
  [1825] = {.lex_state = 53},
  [1826] = {.lex_state = 0},
  [1827] = {.lex_state = 34},
  [1828] = {.lex_state = 0},
  [1829] = {.lex_state = 44},
  [1830] = {.lex_state = 34},
  [1831] = {.lex_state = 44},
  [1832] = {.lex_state = 0},
  [1833] = {.lex_state = 53},
  [1834] = {.lex_state = 0},
  [1835] = {.lex_state = 44},
  [1836] = {.lex_state = 44},
  [1837] = {.lex_state = 0},
  [1838] = {.lex_state = 0},
  [1839] = {.lex_state = 0},
  [1840] = {.lex_state = 0},
  [1841] = {.lex_state = 0},
  [1842] = {.lex_state = 53},
  [1843] = {.lex_state = 120},
  [1844] = {.lex_state = 34},
  [1845] = {.lex_state = 0},
  [1846] = {.lex_state = 44},
  [1847] = {.lex_state = 0},
  [1848] = {.lex_state = 0},
  [1849] = {.lex_state = 0},
  [1850] = {.lex_state = 0},
  [1851] = {.lex_state = 0},
  [1852] = {.lex_state = 53},
  [1853] = {.lex_state = 120},
  [1854] = {.lex_state = 0},
  [1855] = {.lex_state = 53},
  [1856] = {.lex_state = 0},
  [1857] = {.lex_state = 0},
  [1858] = {.lex_state = 0},
  [1859] = {.lex_state = 0},
  [1860] = {.lex_state = 0},
  [1861] = {.lex_state = 34},
  [1862] = {.lex_state = 0},
  [1863] = {.lex_state = 0},
  [1864] = {.lex_state = 120},
  [1865] = {.lex_state = 44},
  [1866] = {.lex_state = 0},
  [1867] = {.lex_state = 53},
  [1868] = {.lex_state = 34},
  [1869] = {.lex_state = 53},
  [1870] = {.lex_state = 44},
  [1871] = {.lex_state = 0},
  [1872] = {.lex_state = 53},
  [1873] = {.lex_state = 0},
  [1874] = {.lex_state = 0},
  [1875] = {.lex_state = 0},
  [1876] = {.lex_state = 44},
  [1877] = {.lex_state = 53},
  [1878] = {.lex_state = 0},
  [1879] = {.lex_state = 34},
  [1880] = {.lex_state = 0},
  [1881] = {.lex_state = 34},
  [1882] = {.lex_state = 34},
  [1883] = {.lex_state = 0},
  [1884] = {.lex_state = 0},
  [1885] = {.lex_state = 0},
  [1886] = {.lex_state = 0},
  [1887] = {.lex_state = 44},
  [1888] = {.lex_state = 0},
  [1889] = {.lex_state = 53},
  [1890] = {.lex_state = 53},
  [1891] = {.lex_state = 44},
  [1892] = {.lex_state = 120},
  [1893] = {.lex_state = 44},
  [1894] = {.lex_state = 44},
  [1895] = {.lex_state = 53},
  [1896] = {.lex_state = 44},
  [1897] = {.lex_state = 44},
  [1898] = {.lex_state = 34},
  [1899] = {.lex_state = 44},
  [1900] = {.lex_state = 0},
  [1901] = {.lex_state = 53},
  [1902] = {.lex_state = 0},
  [1903] = {.lex_state = 44},
  [1904] = {.lex_state = 53},
  [1905] = {.lex_state = 0},
  [1906] = {.lex_state = 0},
  [1907] = {.lex_state = 44},
  [1908] = {.lex_state = 0},
  [1909] = {.lex_state = 0},
  [1910] = {.lex_state = 0},
  [1911] = {.lex_state = 0},
  [1912] = {.lex_state = 0},
  [1913] = {.lex_state = 0},
  [1914] = {.lex_state = 53},
  [1915] = {.lex_state = 53},
  [1916] = {.lex_state = 53},
  [1917] = {.lex_state = 44},
  [1918] = {.lex_state = 0},
  [1919] = {.lex_state = 44},
  [1920] = {.lex_state = 53},
  [1921] = {.lex_state = 0},
  [1922] = {.lex_state = 0},
  [1923] = {.lex_state = 53},
  [1924] = {.lex_state = 44},
  [1925] = {.lex_state = 0},
  [1926] = {.lex_state = 44},
  [1927] = {.lex_state = 44},
  [1928] = {.lex_state = 0},
  [1929] = {.lex_state = 0},
  [1930] = {.lex_state = 0},
  [1931] = {.lex_state = 53},
  [1932] = {.lex_state = 53},
  [1933] = {.lex_state = 0},
  [1934] = {.lex_state = 44},
  [1935] = {.lex_state = 53},
  [1936] = {.lex_state = 44},
  [1937] = {.lex_state = 0},
  [1938] = {.lex_state = 0},
  [1939] = {.lex_state = 0},
  [1940] = {.lex_state = 53},
  [1941] = {.lex_state = 0},
  [1942] = {.lex_state = 34},
  [1943] = {.lex_state = 0},
  [1944] = {.lex_state = 0},
  [1945] = {.lex_state = 53},
  [1946] = {.lex_state = 53},
  [1947] = {.lex_state = 44},
  [1948] = {.lex_state = 34},
  [1949] = {.lex_state = 0},
  [1950] = {.lex_state = 0},
  [1951] = {.lex_state = 53},
  [1952] = {.lex_state = 120},
  [1953] = {.lex_state = 0},
  [1954] = {.lex_state = 44},
  [1955] = {.lex_state = 34},
  [1956] = {.lex_state = 53},
  [1957] = {.lex_state = 0},
  [1958] = {.lex_state = 44},
  [1959] = {.lex_state = 0},
  [1960] = {.lex_state = 53},
  [1961] = {.lex_state = 0},
  [1962] = {.lex_state = 44},
  [1963] = {.lex_state = 120},
  [1964] = {.lex_state = 0},
  [1965] = {.lex_state = 0},
  [1966] = {.lex_state = 53},
  [1967] = {.lex_state = 0},
  [1968] = {.lex_state = 0},
  [1969] = {.lex_state = 53},
  [1970] = {.lex_state = 53},
  [1971] = {.lex_state = 53},
  [1972] = {.lex_state = 44},
  [1973] = {.lex_state = 0},
  [1974] = {.lex_state = 0},
  [1975] = {.lex_state = 120},
  [1976] = {.lex_state = 44},
  [1977] = {.lex_state = 120},
  [1978] = {.lex_state = 120},
  [1979] = {.lex_state = 0},
  [1980] = {.lex_state = 44},
  [1981] = {.lex_state = 0},
  [1982] = {.lex_state = 0},
  [1983] = {.lex_state = 0},
  [1984] = {.lex_state = 0},
  [1985] = {.lex_state = 120},
  [1986] = {.lex_state = 44},
  [1987] = {.lex_state = 44},
  [1988] = {.lex_state = 53},
  [1989] = {.lex_state = 34},
  [1990] = {.lex_state = 0},
  [1991] = {.lex_state = 120},
  [1992] = {.lex_state = 0},
  [1993] = {.lex_state = 44},
  [1994] = {.lex_state = 0},
  [1995] = {.lex_state = 0},
  [1996] = {.lex_state = 53},
  [1997] = {.lex_state = 0},
  [1998] = {.lex_state = 0},
  [1999] = {.lex_state = 0},
  [2000] = {.lex_state = 120},
  [2001] = {.lex_state = 53},
  [2002] = {.lex_state = 0},
  [2003] = {.lex_state = 53},
  [2004] = {.lex_state = 0},
  [2005] = {.lex_state = 44},
  [2006] = {.lex_state = 34},
  [2007] = {.lex_state = 0},
  [2008] = {.lex_state = 0},
  [2009] = {.lex_state = 44},
  [2010] = {.lex_state = 0},
  [2011] = {.lex_state = 53},
  [2012] = {.lex_state = 44},
  [2013] = {.lex_state = 34},
  [2014] = {.lex_state = 0},
  [2015] = {.lex_state = 44},
  [2016] = {.lex_state = 120},
  [2017] = {.lex_state = 44},
  [2018] = {.lex_state = 0},
  [2019] = {.lex_state = 120},
  [2020] = {.lex_state = 0},
  [2021] = {.lex_state = 34},
  [2022] = {.lex_state = 120},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [aux_sym_preproc_include_token1] = ACTIONS(1),
    [aux_sym_preproc_def_token1] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [aux_sym_preproc_if_token1] = ACTIONS(1),
    [aux_sym_preproc_if_token2] = ACTIONS(1),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1),
    [aux_sym_preproc_else_token1] = ACTIONS(1),
    [aux_sym_preproc_elif_token1] = ACTIONS(1),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1),
    [sym_preproc_directive] = ACTIONS(1),
    [anon_sym_LPAREN2] = ACTIONS(1),
    [anon_sym_defined] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym___extension__] = ACTIONS(1),
    [anon_sym_typedef] = ACTIONS(1),
    [anon_sym_extern] = ACTIONS(1),
    [anon_sym___attribute__] = ACTIONS(1),
    [anon_sym___attribute] = ACTIONS(1),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1),
    [anon_sym___declspec] = ACTIONS(1),
    [anon_sym___based] = ACTIONS(1),
    [anon_sym___cdecl] = ACTIONS(1),
    [anon_sym___clrcall] = ACTIONS(1),
    [anon_sym___stdcall] = ACTIONS(1),
    [anon_sym___fastcall] = ACTIONS(1),
    [anon_sym___thiscall] = ACTIONS(1),
    [anon_sym___vectorcall] = ACTIONS(1),
    [sym_ms_restrict_modifier] = ACTIONS(1),
    [sym_ms_unsigned_ptr_modifier] = ACTIONS(1),
    [sym_ms_signed_ptr_modifier] = ACTIONS(1),
    [anon_sym__unaligned] = ACTIONS(1),
    [anon_sym___unaligned] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_signed] = ACTIONS(1),
    [anon_sym_unsigned] = ACTIONS(1),
    [anon_sym_long] = ACTIONS(1),
    [anon_sym_short] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_static] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_auto] = ACTIONS(1),
    [anon_sym_register] = ACTIONS(1),
    [anon_sym_inline] = ACTIONS(1),
    [anon_sym___inline] = ACTIONS(1),
    [anon_sym___inline__] = ACTIONS(1),
    [anon_sym___forceinline] = ACTIONS(1),
    [anon_sym_thread_local] = ACTIONS(1),
    [anon_sym___thread] = ACTIONS(1),
    [anon_sym_const] = ACTIONS(1),
    [anon_sym_constexpr] = ACTIONS(1),
    [anon_sym_volatile] = ACTIONS(1),
    [anon_sym_restrict] = ACTIONS(1),
    [anon_sym___restrict__] = ACTIONS(1),
    [anon_sym__Atomic] = ACTIONS(1),
    [anon_sym__Noreturn] = ACTIONS(1),
    [anon_sym_noreturn] = ACTIONS(1),
    [anon_sym__Nonnull] = ACTIONS(1),
    [anon_sym_alignas] = ACTIONS(1),
    [anon_sym__Alignas] = ACTIONS(1),
    [sym_primitive_type] = ACTIONS(1),
    [anon_sym_enum] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_struct] = ACTIONS(1),
    [anon_sym_union] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_switch] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_default] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_goto] = ACTIONS(1),
    [anon_sym___try] = ACTIONS(1),
    [anon_sym___except] = ACTIONS(1),
    [anon_sym___finally] = ACTIONS(1),
    [anon_sym___leave] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_DASH_DASH] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_sizeof] = ACTIONS(1),
    [anon_sym___alignof__] = ACTIONS(1),
    [anon_sym___alignof] = ACTIONS(1),
    [anon_sym__alignof] = ACTIONS(1),
    [anon_sym_alignof] = ACTIONS(1),
    [anon_sym__Alignof] = ACTIONS(1),
    [anon_sym_offsetof] = ACTIONS(1),
    [anon_sym__Generic] = ACTIONS(1),
    [anon_sym_asm] = ACTIONS(1),
    [anon_sym___asm__] = ACTIONS(1),
    [anon_sym___asm] = ACTIONS(1),
    [anon_sym___volatile__] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [sym_number_literal] = ACTIONS(1),
    [anon_sym_L_SQUOTE] = ACTIONS(1),
    [anon_sym_u_SQUOTE] = ACTIONS(1),
    [anon_sym_U_SQUOTE] = ACTIONS(1),
    [anon_sym_u8_SQUOTE] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_L_DQUOTE] = ACTIONS(1),
    [anon_sym_u_DQUOTE] = ACTIONS(1),
    [anon_sym_U_DQUOTE] = ACTIONS(1),
    [anon_sym_u8_DQUOTE] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [anon_sym_NULL] = ACTIONS(1),
    [anon_sym_nullptr] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
  },
  [1] = {
    [sym_translation_unit] = STATE(1981),
    [sym__top_level_item] = STATE(44),
    [sym_preproc_include] = STATE(44),
    [sym_preproc_def] = STATE(44),
    [sym_preproc_function_def] = STATE(44),
    [sym_preproc_call] = STATE(44),
    [sym_preproc_if] = STATE(44),
    [sym_preproc_ifdef] = STATE(44),
    [sym_function_definition] = STATE(44),
    [sym__old_style_function_definition] = STATE(338),
    [sym_declaration] = STATE(44),
    [sym_type_definition] = STATE(44),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1136),
    [sym_linkage_specification] = STATE(44),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_ms_call_modifier] = STATE(691),
    [sym_compound_statement] = STATE(44),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(800),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(362),
    [sym__top_level_statement] = STATE(44),
    [sym_labeled_statement] = STATE(44),
    [sym__top_level_expression_statement] = STATE(44),
    [sym_if_statement] = STATE(44),
    [sym_switch_statement] = STATE(44),
    [sym_case_statement] = STATE(44),
    [sym_while_statement] = STATE(44),
    [sym_do_statement] = STATE(44),
    [sym_for_statement] = STATE(44),
    [sym_return_statement] = STATE(44),
    [sym_break_statement] = STATE(44),
    [sym_continue_statement] = STATE(44),
    [sym_goto_statement] = STATE(44),
    [sym_expression] = STATE(1116),
    [sym__string] = STATE(1119),
    [sym_conditional_expression] = STATE(1119),
    [sym_assignment_expression] = STATE(1119),
    [sym_pointer_expression] = STATE(935),
    [sym_unary_expression] = STATE(1119),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(1119),
    [sym_cast_expression] = STATE(1119),
    [sym_sizeof_expression] = STATE(1119),
    [sym_alignof_expression] = STATE(1119),
    [sym_offsetof_expression] = STATE(1119),
    [sym_generic_expression] = STATE(1119),
    [sym_subscript_expression] = STATE(935),
    [sym_call_expression] = STATE(935),
    [sym_gnu_asm_expression] = STATE(1119),
    [sym_extension_expression] = STATE(1119),
    [sym_field_expression] = STATE(935),
    [sym_compound_literal_expression] = STATE(1119),
    [sym_parenthesized_expression] = STATE(935),
    [sym_char_literal] = STATE(1119),
    [sym_concatenated_string] = STATE(1119),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(1119),
    [sym__empty_declaration] = STATE(44),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym_translation_unit_repeat1] = STATE(44),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(375),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_identifier] = ACTIONS(7),
    [aux_sym_preproc_include_token1] = ACTIONS(9),
    [aux_sym_preproc_def_token1] = ACTIONS(11),
    [aux_sym_preproc_if_token1] = ACTIONS(13),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(15),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(15),
    [sym_preproc_directive] = ACTIONS(17),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(27),
    [anon_sym___extension__] = ACTIONS(29),
    [anon_sym_typedef] = ACTIONS(31),
    [anon_sym_extern] = ACTIONS(33),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(37),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym___cdecl] = ACTIONS(41),
    [anon_sym___clrcall] = ACTIONS(41),
    [anon_sym___stdcall] = ACTIONS(41),
    [anon_sym___fastcall] = ACTIONS(41),
    [anon_sym___thiscall] = ACTIONS(41),
    [anon_sym___vectorcall] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(61),
    [anon_sym_switch] = ACTIONS(63),
    [anon_sym_case] = ACTIONS(65),
    [anon_sym_default] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(69),
    [anon_sym_do] = ACTIONS(71),
    [anon_sym_for] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_break] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(79),
    [anon_sym_goto] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(95),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(101),
    [sym_false] = ACTIONS(101),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [2] = {
    [sym__block_item] = STATE(3),
    [sym_preproc_include] = STATE(3),
    [sym_preproc_def] = STATE(3),
    [sym_preproc_function_def] = STATE(3),
    [sym_preproc_call] = STATE(3),
    [sym_preproc_if] = STATE(3),
    [sym_preproc_ifdef] = STATE(3),
    [sym_preproc_else] = STATE(1894),
    [sym_preproc_elif] = STATE(1894),
    [sym_preproc_elifdef] = STATE(1894),
    [sym_function_definition] = STATE(3),
    [sym__old_style_function_definition] = STATE(129),
    [sym_declaration] = STATE(3),
    [sym_type_definition] = STATE(3),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1137),
    [sym_linkage_specification] = STATE(3),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_ms_call_modifier] = STATE(674),
    [sym_compound_statement] = STATE(110),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(793),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(119),
    [sym_statement] = STATE(3),
    [sym_labeled_statement] = STATE(110),
    [sym_expression_statement] = STATE(110),
    [sym_if_statement] = STATE(110),
    [sym_switch_statement] = STATE(110),
    [sym_case_statement] = STATE(110),
    [sym_while_statement] = STATE(110),
    [sym_do_statement] = STATE(110),
    [sym_for_statement] = STATE(110),
    [sym_return_statement] = STATE(110),
    [sym_break_statement] = STATE(110),
    [sym_continue_statement] = STATE(110),
    [sym_goto_statement] = STATE(110),
    [sym_seh_try_statement] = STATE(110),
    [sym_seh_leave_statement] = STATE(110),
    [sym_expression] = STATE(1049),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1950),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym__empty_declaration] = STATE(3),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym_preproc_if_repeat1] = STATE(3),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(373),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [sym_identifier] = ACTIONS(105),
    [aux_sym_preproc_include_token1] = ACTIONS(107),
    [aux_sym_preproc_def_token1] = ACTIONS(109),
    [aux_sym_preproc_if_token1] = ACTIONS(111),
    [aux_sym_preproc_if_token2] = ACTIONS(113),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(115),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(115),
    [aux_sym_preproc_else_token1] = ACTIONS(117),
    [aux_sym_preproc_elif_token1] = ACTIONS(119),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(121),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(121),
    [sym_preproc_directive] = ACTIONS(123),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(125),
    [anon_sym___extension__] = ACTIONS(127),
    [anon_sym_typedef] = ACTIONS(129),
    [anon_sym_extern] = ACTIONS(131),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(37),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym___cdecl] = ACTIONS(41),
    [anon_sym___clrcall] = ACTIONS(41),
    [anon_sym___stdcall] = ACTIONS(41),
    [anon_sym___fastcall] = ACTIONS(41),
    [anon_sym___thiscall] = ACTIONS(41),
    [anon_sym___vectorcall] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(133),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(135),
    [anon_sym_switch] = ACTIONS(137),
    [anon_sym_case] = ACTIONS(139),
    [anon_sym_default] = ACTIONS(141),
    [anon_sym_while] = ACTIONS(143),
    [anon_sym_do] = ACTIONS(145),
    [anon_sym_for] = ACTIONS(147),
    [anon_sym_return] = ACTIONS(149),
    [anon_sym_break] = ACTIONS(151),
    [anon_sym_continue] = ACTIONS(153),
    [anon_sym_goto] = ACTIONS(155),
    [anon_sym___try] = ACTIONS(157),
    [anon_sym___leave] = ACTIONS(159),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(161),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(163),
    [sym_false] = ACTIONS(163),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [3] = {
    [sym__block_item] = STATE(22),
    [sym_preproc_include] = STATE(22),
    [sym_preproc_def] = STATE(22),
    [sym_preproc_function_def] = STATE(22),
    [sym_preproc_call] = STATE(22),
    [sym_preproc_if] = STATE(22),
    [sym_preproc_ifdef] = STATE(22),
    [sym_preproc_else] = STATE(1893),
    [sym_preproc_elif] = STATE(1893),
    [sym_preproc_elifdef] = STATE(1893),
    [sym_function_definition] = STATE(22),
    [sym__old_style_function_definition] = STATE(129),
    [sym_declaration] = STATE(22),
    [sym_type_definition] = STATE(22),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1137),
    [sym_linkage_specification] = STATE(22),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_ms_call_modifier] = STATE(674),
    [sym_compound_statement] = STATE(110),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(793),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(119),
    [sym_statement] = STATE(22),
    [sym_labeled_statement] = STATE(110),
    [sym_expression_statement] = STATE(110),
    [sym_if_statement] = STATE(110),
    [sym_switch_statement] = STATE(110),
    [sym_case_statement] = STATE(110),
    [sym_while_statement] = STATE(110),
    [sym_do_statement] = STATE(110),
    [sym_for_statement] = STATE(110),
    [sym_return_statement] = STATE(110),
    [sym_break_statement] = STATE(110),
    [sym_continue_statement] = STATE(110),
    [sym_goto_statement] = STATE(110),
    [sym_seh_try_statement] = STATE(110),
    [sym_seh_leave_statement] = STATE(110),
    [sym_expression] = STATE(1049),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1950),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym__empty_declaration] = STATE(22),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym_preproc_if_repeat1] = STATE(22),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(373),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [sym_identifier] = ACTIONS(105),
    [aux_sym_preproc_include_token1] = ACTIONS(107),
    [aux_sym_preproc_def_token1] = ACTIONS(109),
    [aux_sym_preproc_if_token1] = ACTIONS(111),
    [aux_sym_preproc_if_token2] = ACTIONS(165),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(115),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(115),
    [aux_sym_preproc_else_token1] = ACTIONS(117),
    [aux_sym_preproc_elif_token1] = ACTIONS(119),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(121),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(121),
    [sym_preproc_directive] = ACTIONS(123),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(125),
    [anon_sym___extension__] = ACTIONS(127),
    [anon_sym_typedef] = ACTIONS(129),
    [anon_sym_extern] = ACTIONS(131),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(37),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym___cdecl] = ACTIONS(41),
    [anon_sym___clrcall] = ACTIONS(41),
    [anon_sym___stdcall] = ACTIONS(41),
    [anon_sym___fastcall] = ACTIONS(41),
    [anon_sym___thiscall] = ACTIONS(41),
    [anon_sym___vectorcall] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(133),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(135),
    [anon_sym_switch] = ACTIONS(137),
    [anon_sym_case] = ACTIONS(139),
    [anon_sym_default] = ACTIONS(141),
    [anon_sym_while] = ACTIONS(143),
    [anon_sym_do] = ACTIONS(145),
    [anon_sym_for] = ACTIONS(147),
    [anon_sym_return] = ACTIONS(149),
    [anon_sym_break] = ACTIONS(151),
    [anon_sym_continue] = ACTIONS(153),
    [anon_sym_goto] = ACTIONS(155),
    [anon_sym___try] = ACTIONS(157),
    [anon_sym___leave] = ACTIONS(159),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(161),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(163),
    [sym_false] = ACTIONS(163),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [4] = {
    [sym__block_item] = STATE(5),
    [sym_preproc_include] = STATE(5),
    [sym_preproc_def] = STATE(5),
    [sym_preproc_function_def] = STATE(5),
    [sym_preproc_call] = STATE(5),
    [sym_preproc_if] = STATE(5),
    [sym_preproc_ifdef] = STATE(5),
    [sym_preproc_else] = STATE(1846),
    [sym_preproc_elif] = STATE(1846),
    [sym_preproc_elifdef] = STATE(1846),
    [sym_function_definition] = STATE(5),
    [sym__old_style_function_definition] = STATE(129),
    [sym_declaration] = STATE(5),
    [sym_type_definition] = STATE(5),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1137),
    [sym_linkage_specification] = STATE(5),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_ms_call_modifier] = STATE(674),
    [sym_compound_statement] = STATE(110),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(793),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(119),
    [sym_statement] = STATE(5),
    [sym_labeled_statement] = STATE(110),
    [sym_expression_statement] = STATE(110),
    [sym_if_statement] = STATE(110),
    [sym_switch_statement] = STATE(110),
    [sym_case_statement] = STATE(110),
    [sym_while_statement] = STATE(110),
    [sym_do_statement] = STATE(110),
    [sym_for_statement] = STATE(110),
    [sym_return_statement] = STATE(110),
    [sym_break_statement] = STATE(110),
    [sym_continue_statement] = STATE(110),
    [sym_goto_statement] = STATE(110),
    [sym_seh_try_statement] = STATE(110),
    [sym_seh_leave_statement] = STATE(110),
    [sym_expression] = STATE(1049),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1950),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym__empty_declaration] = STATE(5),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym_preproc_if_repeat1] = STATE(5),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(373),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [sym_identifier] = ACTIONS(105),
    [aux_sym_preproc_include_token1] = ACTIONS(107),
    [aux_sym_preproc_def_token1] = ACTIONS(109),
    [aux_sym_preproc_if_token1] = ACTIONS(111),
    [aux_sym_preproc_if_token2] = ACTIONS(167),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(115),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(115),
    [aux_sym_preproc_else_token1] = ACTIONS(117),
    [aux_sym_preproc_elif_token1] = ACTIONS(119),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(121),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(121),
    [sym_preproc_directive] = ACTIONS(123),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(125),
    [anon_sym___extension__] = ACTIONS(127),
    [anon_sym_typedef] = ACTIONS(129),
    [anon_sym_extern] = ACTIONS(131),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(37),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym___cdecl] = ACTIONS(41),
    [anon_sym___clrcall] = ACTIONS(41),
    [anon_sym___stdcall] = ACTIONS(41),
    [anon_sym___fastcall] = ACTIONS(41),
    [anon_sym___thiscall] = ACTIONS(41),
    [anon_sym___vectorcall] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(133),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(135),
    [anon_sym_switch] = ACTIONS(137),
    [anon_sym_case] = ACTIONS(139),
    [anon_sym_default] = ACTIONS(141),
    [anon_sym_while] = ACTIONS(143),
    [anon_sym_do] = ACTIONS(145),
    [anon_sym_for] = ACTIONS(147),
    [anon_sym_return] = ACTIONS(149),
    [anon_sym_break] = ACTIONS(151),
    [anon_sym_continue] = ACTIONS(153),
    [anon_sym_goto] = ACTIONS(155),
    [anon_sym___try] = ACTIONS(157),
    [anon_sym___leave] = ACTIONS(159),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(161),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(163),
    [sym_false] = ACTIONS(163),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [5] = {
    [sym__block_item] = STATE(22),
    [sym_preproc_include] = STATE(22),
    [sym_preproc_def] = STATE(22),
    [sym_preproc_function_def] = STATE(22),
    [sym_preproc_call] = STATE(22),
    [sym_preproc_if] = STATE(22),
    [sym_preproc_ifdef] = STATE(22),
    [sym_preproc_else] = STATE(1936),
    [sym_preproc_elif] = STATE(1936),
    [sym_preproc_elifdef] = STATE(1936),
    [sym_function_definition] = STATE(22),
    [sym__old_style_function_definition] = STATE(129),
    [sym_declaration] = STATE(22),
    [sym_type_definition] = STATE(22),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1137),
    [sym_linkage_specification] = STATE(22),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_ms_call_modifier] = STATE(674),
    [sym_compound_statement] = STATE(110),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(793),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(119),
    [sym_statement] = STATE(22),
    [sym_labeled_statement] = STATE(110),
    [sym_expression_statement] = STATE(110),
    [sym_if_statement] = STATE(110),
    [sym_switch_statement] = STATE(110),
    [sym_case_statement] = STATE(110),
    [sym_while_statement] = STATE(110),
    [sym_do_statement] = STATE(110),
    [sym_for_statement] = STATE(110),
    [sym_return_statement] = STATE(110),
    [sym_break_statement] = STATE(110),
    [sym_continue_statement] = STATE(110),
    [sym_goto_statement] = STATE(110),
    [sym_seh_try_statement] = STATE(110),
    [sym_seh_leave_statement] = STATE(110),
    [sym_expression] = STATE(1049),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1950),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym__empty_declaration] = STATE(22),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym_preproc_if_repeat1] = STATE(22),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(373),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [sym_identifier] = ACTIONS(105),
    [aux_sym_preproc_include_token1] = ACTIONS(107),
    [aux_sym_preproc_def_token1] = ACTIONS(109),
    [aux_sym_preproc_if_token1] = ACTIONS(111),
    [aux_sym_preproc_if_token2] = ACTIONS(169),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(115),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(115),
    [aux_sym_preproc_else_token1] = ACTIONS(117),
    [aux_sym_preproc_elif_token1] = ACTIONS(119),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(121),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(121),
    [sym_preproc_directive] = ACTIONS(123),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(125),
    [anon_sym___extension__] = ACTIONS(127),
    [anon_sym_typedef] = ACTIONS(129),
    [anon_sym_extern] = ACTIONS(131),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(37),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym___cdecl] = ACTIONS(41),
    [anon_sym___clrcall] = ACTIONS(41),
    [anon_sym___stdcall] = ACTIONS(41),
    [anon_sym___fastcall] = ACTIONS(41),
    [anon_sym___thiscall] = ACTIONS(41),
    [anon_sym___vectorcall] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(133),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(135),
    [anon_sym_switch] = ACTIONS(137),
    [anon_sym_case] = ACTIONS(139),
    [anon_sym_default] = ACTIONS(141),
    [anon_sym_while] = ACTIONS(143),
    [anon_sym_do] = ACTIONS(145),
    [anon_sym_for] = ACTIONS(147),
    [anon_sym_return] = ACTIONS(149),
    [anon_sym_break] = ACTIONS(151),
    [anon_sym_continue] = ACTIONS(153),
    [anon_sym_goto] = ACTIONS(155),
    [anon_sym___try] = ACTIONS(157),
    [anon_sym___leave] = ACTIONS(159),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(161),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(163),
    [sym_false] = ACTIONS(163),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [6] = {
    [sym__block_item] = STATE(8),
    [sym_preproc_include] = STATE(8),
    [sym_preproc_def] = STATE(8),
    [sym_preproc_function_def] = STATE(8),
    [sym_preproc_call] = STATE(8),
    [sym_preproc_if] = STATE(8),
    [sym_preproc_ifdef] = STATE(8),
    [sym_preproc_else] = STATE(1792),
    [sym_preproc_elif] = STATE(1792),
    [sym_preproc_elifdef] = STATE(1792),
    [sym_function_definition] = STATE(8),
    [sym__old_style_function_definition] = STATE(129),
    [sym_declaration] = STATE(8),
    [sym_type_definition] = STATE(8),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1137),
    [sym_linkage_specification] = STATE(8),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_ms_call_modifier] = STATE(674),
    [sym_compound_statement] = STATE(110),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(793),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(119),
    [sym_statement] = STATE(8),
    [sym_labeled_statement] = STATE(110),
    [sym_expression_statement] = STATE(110),
    [sym_if_statement] = STATE(110),
    [sym_switch_statement] = STATE(110),
    [sym_case_statement] = STATE(110),
    [sym_while_statement] = STATE(110),
    [sym_do_statement] = STATE(110),
    [sym_for_statement] = STATE(110),
    [sym_return_statement] = STATE(110),
    [sym_break_statement] = STATE(110),
    [sym_continue_statement] = STATE(110),
    [sym_goto_statement] = STATE(110),
    [sym_seh_try_statement] = STATE(110),
    [sym_seh_leave_statement] = STATE(110),
    [sym_expression] = STATE(1049),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1950),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym__empty_declaration] = STATE(8),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym_preproc_if_repeat1] = STATE(8),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(373),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [sym_identifier] = ACTIONS(105),
    [aux_sym_preproc_include_token1] = ACTIONS(107),
    [aux_sym_preproc_def_token1] = ACTIONS(109),
    [aux_sym_preproc_if_token1] = ACTIONS(111),
    [aux_sym_preproc_if_token2] = ACTIONS(171),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(115),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(115),
    [aux_sym_preproc_else_token1] = ACTIONS(117),
    [aux_sym_preproc_elif_token1] = ACTIONS(119),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(121),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(121),
    [sym_preproc_directive] = ACTIONS(123),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(125),
    [anon_sym___extension__] = ACTIONS(127),
    [anon_sym_typedef] = ACTIONS(129),
    [anon_sym_extern] = ACTIONS(131),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(37),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym___cdecl] = ACTIONS(41),
    [anon_sym___clrcall] = ACTIONS(41),
    [anon_sym___stdcall] = ACTIONS(41),
    [anon_sym___fastcall] = ACTIONS(41),
    [anon_sym___thiscall] = ACTIONS(41),
    [anon_sym___vectorcall] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(133),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(135),
    [anon_sym_switch] = ACTIONS(137),
    [anon_sym_case] = ACTIONS(139),
    [anon_sym_default] = ACTIONS(141),
    [anon_sym_while] = ACTIONS(143),
    [anon_sym_do] = ACTIONS(145),
    [anon_sym_for] = ACTIONS(147),
    [anon_sym_return] = ACTIONS(149),
    [anon_sym_break] = ACTIONS(151),
    [anon_sym_continue] = ACTIONS(153),
    [anon_sym_goto] = ACTIONS(155),
    [anon_sym___try] = ACTIONS(157),
    [anon_sym___leave] = ACTIONS(159),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(161),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(163),
    [sym_false] = ACTIONS(163),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [7] = {
    [sym__block_item] = STATE(9),
    [sym_preproc_include] = STATE(9),
    [sym_preproc_def] = STATE(9),
    [sym_preproc_function_def] = STATE(9),
    [sym_preproc_call] = STATE(9),
    [sym_preproc_if] = STATE(9),
    [sym_preproc_ifdef] = STATE(9),
    [sym_preproc_else] = STATE(1793),
    [sym_preproc_elif] = STATE(1793),
    [sym_preproc_elifdef] = STATE(1793),
    [sym_function_definition] = STATE(9),
    [sym__old_style_function_definition] = STATE(129),
    [sym_declaration] = STATE(9),
    [sym_type_definition] = STATE(9),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1137),
    [sym_linkage_specification] = STATE(9),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_ms_call_modifier] = STATE(674),
    [sym_compound_statement] = STATE(110),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(793),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(119),
    [sym_statement] = STATE(9),
    [sym_labeled_statement] = STATE(110),
    [sym_expression_statement] = STATE(110),
    [sym_if_statement] = STATE(110),
    [sym_switch_statement] = STATE(110),
    [sym_case_statement] = STATE(110),
    [sym_while_statement] = STATE(110),
    [sym_do_statement] = STATE(110),
    [sym_for_statement] = STATE(110),
    [sym_return_statement] = STATE(110),
    [sym_break_statement] = STATE(110),
    [sym_continue_statement] = STATE(110),
    [sym_goto_statement] = STATE(110),
    [sym_seh_try_statement] = STATE(110),
    [sym_seh_leave_statement] = STATE(110),
    [sym_expression] = STATE(1049),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1950),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym__empty_declaration] = STATE(9),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym_preproc_if_repeat1] = STATE(9),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(373),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [sym_identifier] = ACTIONS(105),
    [aux_sym_preproc_include_token1] = ACTIONS(107),
    [aux_sym_preproc_def_token1] = ACTIONS(109),
    [aux_sym_preproc_if_token1] = ACTIONS(111),
    [aux_sym_preproc_if_token2] = ACTIONS(173),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(115),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(115),
    [aux_sym_preproc_else_token1] = ACTIONS(117),
    [aux_sym_preproc_elif_token1] = ACTIONS(119),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(121),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(121),
    [sym_preproc_directive] = ACTIONS(123),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(125),
    [anon_sym___extension__] = ACTIONS(127),
    [anon_sym_typedef] = ACTIONS(129),
    [anon_sym_extern] = ACTIONS(131),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(37),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym___cdecl] = ACTIONS(41),
    [anon_sym___clrcall] = ACTIONS(41),
    [anon_sym___stdcall] = ACTIONS(41),
    [anon_sym___fastcall] = ACTIONS(41),
    [anon_sym___thiscall] = ACTIONS(41),
    [anon_sym___vectorcall] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(133),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(135),
    [anon_sym_switch] = ACTIONS(137),
    [anon_sym_case] = ACTIONS(139),
    [anon_sym_default] = ACTIONS(141),
    [anon_sym_while] = ACTIONS(143),
    [anon_sym_do] = ACTIONS(145),
    [anon_sym_for] = ACTIONS(147),
    [anon_sym_return] = ACTIONS(149),
    [anon_sym_break] = ACTIONS(151),
    [anon_sym_continue] = ACTIONS(153),
    [anon_sym_goto] = ACTIONS(155),
    [anon_sym___try] = ACTIONS(157),
    [anon_sym___leave] = ACTIONS(159),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(161),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(163),
    [sym_false] = ACTIONS(163),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [8] = {
    [sym__block_item] = STATE(22),
    [sym_preproc_include] = STATE(22),
    [sym_preproc_def] = STATE(22),
    [sym_preproc_function_def] = STATE(22),
    [sym_preproc_call] = STATE(22),
    [sym_preproc_if] = STATE(22),
    [sym_preproc_ifdef] = STATE(22),
    [sym_preproc_else] = STATE(1805),
    [sym_preproc_elif] = STATE(1805),
    [sym_preproc_elifdef] = STATE(1805),
    [sym_function_definition] = STATE(22),
    [sym__old_style_function_definition] = STATE(129),
    [sym_declaration] = STATE(22),
    [sym_type_definition] = STATE(22),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1137),
    [sym_linkage_specification] = STATE(22),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_ms_call_modifier] = STATE(674),
    [sym_compound_statement] = STATE(110),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(793),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(119),
    [sym_statement] = STATE(22),
    [sym_labeled_statement] = STATE(110),
    [sym_expression_statement] = STATE(110),
    [sym_if_statement] = STATE(110),
    [sym_switch_statement] = STATE(110),
    [sym_case_statement] = STATE(110),
    [sym_while_statement] = STATE(110),
    [sym_do_statement] = STATE(110),
    [sym_for_statement] = STATE(110),
    [sym_return_statement] = STATE(110),
    [sym_break_statement] = STATE(110),
    [sym_continue_statement] = STATE(110),
    [sym_goto_statement] = STATE(110),
    [sym_seh_try_statement] = STATE(110),
    [sym_seh_leave_statement] = STATE(110),
    [sym_expression] = STATE(1049),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1950),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym__empty_declaration] = STATE(22),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym_preproc_if_repeat1] = STATE(22),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(373),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [sym_identifier] = ACTIONS(105),
    [aux_sym_preproc_include_token1] = ACTIONS(107),
    [aux_sym_preproc_def_token1] = ACTIONS(109),
    [aux_sym_preproc_if_token1] = ACTIONS(111),
    [aux_sym_preproc_if_token2] = ACTIONS(175),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(115),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(115),
    [aux_sym_preproc_else_token1] = ACTIONS(117),
    [aux_sym_preproc_elif_token1] = ACTIONS(119),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(121),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(121),
    [sym_preproc_directive] = ACTIONS(123),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(125),
    [anon_sym___extension__] = ACTIONS(127),
    [anon_sym_typedef] = ACTIONS(129),
    [anon_sym_extern] = ACTIONS(131),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(37),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym___cdecl] = ACTIONS(41),
    [anon_sym___clrcall] = ACTIONS(41),
    [anon_sym___stdcall] = ACTIONS(41),
    [anon_sym___fastcall] = ACTIONS(41),
    [anon_sym___thiscall] = ACTIONS(41),
    [anon_sym___vectorcall] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(133),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(135),
    [anon_sym_switch] = ACTIONS(137),
    [anon_sym_case] = ACTIONS(139),
    [anon_sym_default] = ACTIONS(141),
    [anon_sym_while] = ACTIONS(143),
    [anon_sym_do] = ACTIONS(145),
    [anon_sym_for] = ACTIONS(147),
    [anon_sym_return] = ACTIONS(149),
    [anon_sym_break] = ACTIONS(151),
    [anon_sym_continue] = ACTIONS(153),
    [anon_sym_goto] = ACTIONS(155),
    [anon_sym___try] = ACTIONS(157),
    [anon_sym___leave] = ACTIONS(159),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(161),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(163),
    [sym_false] = ACTIONS(163),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [9] = {
    [sym__block_item] = STATE(22),
    [sym_preproc_include] = STATE(22),
    [sym_preproc_def] = STATE(22),
    [sym_preproc_function_def] = STATE(22),
    [sym_preproc_call] = STATE(22),
    [sym_preproc_if] = STATE(22),
    [sym_preproc_ifdef] = STATE(22),
    [sym_preproc_else] = STATE(2017),
    [sym_preproc_elif] = STATE(2017),
    [sym_preproc_elifdef] = STATE(2017),
    [sym_function_definition] = STATE(22),
    [sym__old_style_function_definition] = STATE(129),
    [sym_declaration] = STATE(22),
    [sym_type_definition] = STATE(22),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1137),
    [sym_linkage_specification] = STATE(22),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_ms_call_modifier] = STATE(674),
    [sym_compound_statement] = STATE(110),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(793),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(119),
    [sym_statement] = STATE(22),
    [sym_labeled_statement] = STATE(110),
    [sym_expression_statement] = STATE(110),
    [sym_if_statement] = STATE(110),
    [sym_switch_statement] = STATE(110),
    [sym_case_statement] = STATE(110),
    [sym_while_statement] = STATE(110),
    [sym_do_statement] = STATE(110),
    [sym_for_statement] = STATE(110),
    [sym_return_statement] = STATE(110),
    [sym_break_statement] = STATE(110),
    [sym_continue_statement] = STATE(110),
    [sym_goto_statement] = STATE(110),
    [sym_seh_try_statement] = STATE(110),
    [sym_seh_leave_statement] = STATE(110),
    [sym_expression] = STATE(1049),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1950),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym__empty_declaration] = STATE(22),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym_preproc_if_repeat1] = STATE(22),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(373),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [sym_identifier] = ACTIONS(105),
    [aux_sym_preproc_include_token1] = ACTIONS(107),
    [aux_sym_preproc_def_token1] = ACTIONS(109),
    [aux_sym_preproc_if_token1] = ACTIONS(111),
    [aux_sym_preproc_if_token2] = ACTIONS(177),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(115),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(115),
    [aux_sym_preproc_else_token1] = ACTIONS(117),
    [aux_sym_preproc_elif_token1] = ACTIONS(119),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(121),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(121),
    [sym_preproc_directive] = ACTIONS(123),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(125),
    [anon_sym___extension__] = ACTIONS(127),
    [anon_sym_typedef] = ACTIONS(129),
    [anon_sym_extern] = ACTIONS(131),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(37),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym___cdecl] = ACTIONS(41),
    [anon_sym___clrcall] = ACTIONS(41),
    [anon_sym___stdcall] = ACTIONS(41),
    [anon_sym___fastcall] = ACTIONS(41),
    [anon_sym___thiscall] = ACTIONS(41),
    [anon_sym___vectorcall] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(133),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(135),
    [anon_sym_switch] = ACTIONS(137),
    [anon_sym_case] = ACTIONS(139),
    [anon_sym_default] = ACTIONS(141),
    [anon_sym_while] = ACTIONS(143),
    [anon_sym_do] = ACTIONS(145),
    [anon_sym_for] = ACTIONS(147),
    [anon_sym_return] = ACTIONS(149),
    [anon_sym_break] = ACTIONS(151),
    [anon_sym_continue] = ACTIONS(153),
    [anon_sym_goto] = ACTIONS(155),
    [anon_sym___try] = ACTIONS(157),
    [anon_sym___leave] = ACTIONS(159),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(161),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(163),
    [sym_false] = ACTIONS(163),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [10] = {
    [sym__block_item] = STATE(12),
    [sym_preproc_include] = STATE(12),
    [sym_preproc_def] = STATE(12),
    [sym_preproc_function_def] = STATE(12),
    [sym_preproc_call] = STATE(12),
    [sym_preproc_if] = STATE(12),
    [sym_preproc_ifdef] = STATE(12),
    [sym_preproc_else] = STATE(1987),
    [sym_preproc_elif] = STATE(1987),
    [sym_preproc_elifdef] = STATE(1987),
    [sym_function_definition] = STATE(12),
    [sym__old_style_function_definition] = STATE(129),
    [sym_declaration] = STATE(12),
    [sym_type_definition] = STATE(12),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1137),
    [sym_linkage_specification] = STATE(12),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_ms_call_modifier] = STATE(674),
    [sym_compound_statement] = STATE(110),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(793),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(119),
    [sym_statement] = STATE(12),
    [sym_labeled_statement] = STATE(110),
    [sym_expression_statement] = STATE(110),
    [sym_if_statement] = STATE(110),
    [sym_switch_statement] = STATE(110),
    [sym_case_statement] = STATE(110),
    [sym_while_statement] = STATE(110),
    [sym_do_statement] = STATE(110),
    [sym_for_statement] = STATE(110),
    [sym_return_statement] = STATE(110),
    [sym_break_statement] = STATE(110),
    [sym_continue_statement] = STATE(110),
    [sym_goto_statement] = STATE(110),
    [sym_seh_try_statement] = STATE(110),
    [sym_seh_leave_statement] = STATE(110),
    [sym_expression] = STATE(1049),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1950),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym__empty_declaration] = STATE(12),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym_preproc_if_repeat1] = STATE(12),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(373),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [sym_identifier] = ACTIONS(105),
    [aux_sym_preproc_include_token1] = ACTIONS(107),
    [aux_sym_preproc_def_token1] = ACTIONS(109),
    [aux_sym_preproc_if_token1] = ACTIONS(111),
    [aux_sym_preproc_if_token2] = ACTIONS(179),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(115),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(115),
    [aux_sym_preproc_else_token1] = ACTIONS(117),
    [aux_sym_preproc_elif_token1] = ACTIONS(119),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(121),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(121),
    [sym_preproc_directive] = ACTIONS(123),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(125),
    [anon_sym___extension__] = ACTIONS(127),
    [anon_sym_typedef] = ACTIONS(129),
    [anon_sym_extern] = ACTIONS(131),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(37),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym___cdecl] = ACTIONS(41),
    [anon_sym___clrcall] = ACTIONS(41),
    [anon_sym___stdcall] = ACTIONS(41),
    [anon_sym___fastcall] = ACTIONS(41),
    [anon_sym___thiscall] = ACTIONS(41),
    [anon_sym___vectorcall] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(133),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(135),
    [anon_sym_switch] = ACTIONS(137),
    [anon_sym_case] = ACTIONS(139),
    [anon_sym_default] = ACTIONS(141),
    [anon_sym_while] = ACTIONS(143),
    [anon_sym_do] = ACTIONS(145),
    [anon_sym_for] = ACTIONS(147),
    [anon_sym_return] = ACTIONS(149),
    [anon_sym_break] = ACTIONS(151),
    [anon_sym_continue] = ACTIONS(153),
    [anon_sym_goto] = ACTIONS(155),
    [anon_sym___try] = ACTIONS(157),
    [anon_sym___leave] = ACTIONS(159),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(161),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(163),
    [sym_false] = ACTIONS(163),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [11] = {
    [sym__block_item] = STATE(13),
    [sym_preproc_include] = STATE(13),
    [sym_preproc_def] = STATE(13),
    [sym_preproc_function_def] = STATE(13),
    [sym_preproc_call] = STATE(13),
    [sym_preproc_if] = STATE(13),
    [sym_preproc_ifdef] = STATE(13),
    [sym_preproc_else] = STATE(1797),
    [sym_preproc_elif] = STATE(1797),
    [sym_preproc_elifdef] = STATE(1797),
    [sym_function_definition] = STATE(13),
    [sym__old_style_function_definition] = STATE(129),
    [sym_declaration] = STATE(13),
    [sym_type_definition] = STATE(13),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1137),
    [sym_linkage_specification] = STATE(13),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_ms_call_modifier] = STATE(674),
    [sym_compound_statement] = STATE(110),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(793),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(119),
    [sym_statement] = STATE(13),
    [sym_labeled_statement] = STATE(110),
    [sym_expression_statement] = STATE(110),
    [sym_if_statement] = STATE(110),
    [sym_switch_statement] = STATE(110),
    [sym_case_statement] = STATE(110),
    [sym_while_statement] = STATE(110),
    [sym_do_statement] = STATE(110),
    [sym_for_statement] = STATE(110),
    [sym_return_statement] = STATE(110),
    [sym_break_statement] = STATE(110),
    [sym_continue_statement] = STATE(110),
    [sym_goto_statement] = STATE(110),
    [sym_seh_try_statement] = STATE(110),
    [sym_seh_leave_statement] = STATE(110),
    [sym_expression] = STATE(1049),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1950),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym__empty_declaration] = STATE(13),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym_preproc_if_repeat1] = STATE(13),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(373),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [sym_identifier] = ACTIONS(105),
    [aux_sym_preproc_include_token1] = ACTIONS(107),
    [aux_sym_preproc_def_token1] = ACTIONS(109),
    [aux_sym_preproc_if_token1] = ACTIONS(111),
    [aux_sym_preproc_if_token2] = ACTIONS(181),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(115),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(115),
    [aux_sym_preproc_else_token1] = ACTIONS(117),
    [aux_sym_preproc_elif_token1] = ACTIONS(119),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(121),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(121),
    [sym_preproc_directive] = ACTIONS(123),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(125),
    [anon_sym___extension__] = ACTIONS(127),
    [anon_sym_typedef] = ACTIONS(129),
    [anon_sym_extern] = ACTIONS(131),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(37),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym___cdecl] = ACTIONS(41),
    [anon_sym___clrcall] = ACTIONS(41),
    [anon_sym___stdcall] = ACTIONS(41),
    [anon_sym___fastcall] = ACTIONS(41),
    [anon_sym___thiscall] = ACTIONS(41),
    [anon_sym___vectorcall] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(133),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(135),
    [anon_sym_switch] = ACTIONS(137),
    [anon_sym_case] = ACTIONS(139),
    [anon_sym_default] = ACTIONS(141),
    [anon_sym_while] = ACTIONS(143),
    [anon_sym_do] = ACTIONS(145),
    [anon_sym_for] = ACTIONS(147),
    [anon_sym_return] = ACTIONS(149),
    [anon_sym_break] = ACTIONS(151),
    [anon_sym_continue] = ACTIONS(153),
    [anon_sym_goto] = ACTIONS(155),
    [anon_sym___try] = ACTIONS(157),
    [anon_sym___leave] = ACTIONS(159),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(161),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(163),
    [sym_false] = ACTIONS(163),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [12] = {
    [sym__block_item] = STATE(22),
    [sym_preproc_include] = STATE(22),
    [sym_preproc_def] = STATE(22),
    [sym_preproc_function_def] = STATE(22),
    [sym_preproc_call] = STATE(22),
    [sym_preproc_if] = STATE(22),
    [sym_preproc_ifdef] = STATE(22),
    [sym_preproc_else] = STATE(1813),
    [sym_preproc_elif] = STATE(1813),
    [sym_preproc_elifdef] = STATE(1813),
    [sym_function_definition] = STATE(22),
    [sym__old_style_function_definition] = STATE(129),
    [sym_declaration] = STATE(22),
    [sym_type_definition] = STATE(22),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1137),
    [sym_linkage_specification] = STATE(22),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_ms_call_modifier] = STATE(674),
    [sym_compound_statement] = STATE(110),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(793),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(119),
    [sym_statement] = STATE(22),
    [sym_labeled_statement] = STATE(110),
    [sym_expression_statement] = STATE(110),
    [sym_if_statement] = STATE(110),
    [sym_switch_statement] = STATE(110),
    [sym_case_statement] = STATE(110),
    [sym_while_statement] = STATE(110),
    [sym_do_statement] = STATE(110),
    [sym_for_statement] = STATE(110),
    [sym_return_statement] = STATE(110),
    [sym_break_statement] = STATE(110),
    [sym_continue_statement] = STATE(110),
    [sym_goto_statement] = STATE(110),
    [sym_seh_try_statement] = STATE(110),
    [sym_seh_leave_statement] = STATE(110),
    [sym_expression] = STATE(1049),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1950),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym__empty_declaration] = STATE(22),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym_preproc_if_repeat1] = STATE(22),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(373),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [sym_identifier] = ACTIONS(105),
    [aux_sym_preproc_include_token1] = ACTIONS(107),
    [aux_sym_preproc_def_token1] = ACTIONS(109),
    [aux_sym_preproc_if_token1] = ACTIONS(111),
    [aux_sym_preproc_if_token2] = ACTIONS(183),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(115),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(115),
    [aux_sym_preproc_else_token1] = ACTIONS(117),
    [aux_sym_preproc_elif_token1] = ACTIONS(119),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(121),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(121),
    [sym_preproc_directive] = ACTIONS(123),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(125),
    [anon_sym___extension__] = ACTIONS(127),
    [anon_sym_typedef] = ACTIONS(129),
    [anon_sym_extern] = ACTIONS(131),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(37),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym___cdecl] = ACTIONS(41),
    [anon_sym___clrcall] = ACTIONS(41),
    [anon_sym___stdcall] = ACTIONS(41),
    [anon_sym___fastcall] = ACTIONS(41),
    [anon_sym___thiscall] = ACTIONS(41),
    [anon_sym___vectorcall] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(133),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(135),
    [anon_sym_switch] = ACTIONS(137),
    [anon_sym_case] = ACTIONS(139),
    [anon_sym_default] = ACTIONS(141),
    [anon_sym_while] = ACTIONS(143),
    [anon_sym_do] = ACTIONS(145),
    [anon_sym_for] = ACTIONS(147),
    [anon_sym_return] = ACTIONS(149),
    [anon_sym_break] = ACTIONS(151),
    [anon_sym_continue] = ACTIONS(153),
    [anon_sym_goto] = ACTIONS(155),
    [anon_sym___try] = ACTIONS(157),
    [anon_sym___leave] = ACTIONS(159),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(161),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(163),
    [sym_false] = ACTIONS(163),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [13] = {
    [sym__block_item] = STATE(22),
    [sym_preproc_include] = STATE(22),
    [sym_preproc_def] = STATE(22),
    [sym_preproc_function_def] = STATE(22),
    [sym_preproc_call] = STATE(22),
    [sym_preproc_if] = STATE(22),
    [sym_preproc_ifdef] = STATE(22),
    [sym_preproc_else] = STATE(1919),
    [sym_preproc_elif] = STATE(1919),
    [sym_preproc_elifdef] = STATE(1919),
    [sym_function_definition] = STATE(22),
    [sym__old_style_function_definition] = STATE(129),
    [sym_declaration] = STATE(22),
    [sym_type_definition] = STATE(22),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1137),
    [sym_linkage_specification] = STATE(22),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_ms_call_modifier] = STATE(674),
    [sym_compound_statement] = STATE(110),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(793),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(119),
    [sym_statement] = STATE(22),
    [sym_labeled_statement] = STATE(110),
    [sym_expression_statement] = STATE(110),
    [sym_if_statement] = STATE(110),
    [sym_switch_statement] = STATE(110),
    [sym_case_statement] = STATE(110),
    [sym_while_statement] = STATE(110),
    [sym_do_statement] = STATE(110),
    [sym_for_statement] = STATE(110),
    [sym_return_statement] = STATE(110),
    [sym_break_statement] = STATE(110),
    [sym_continue_statement] = STATE(110),
    [sym_goto_statement] = STATE(110),
    [sym_seh_try_statement] = STATE(110),
    [sym_seh_leave_statement] = STATE(110),
    [sym_expression] = STATE(1049),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1950),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym__empty_declaration] = STATE(22),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym_preproc_if_repeat1] = STATE(22),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(373),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [sym_identifier] = ACTIONS(105),
    [aux_sym_preproc_include_token1] = ACTIONS(107),
    [aux_sym_preproc_def_token1] = ACTIONS(109),
    [aux_sym_preproc_if_token1] = ACTIONS(111),
    [aux_sym_preproc_if_token2] = ACTIONS(185),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(115),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(115),
    [aux_sym_preproc_else_token1] = ACTIONS(117),
    [aux_sym_preproc_elif_token1] = ACTIONS(119),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(121),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(121),
    [sym_preproc_directive] = ACTIONS(123),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(125),
    [anon_sym___extension__] = ACTIONS(127),
    [anon_sym_typedef] = ACTIONS(129),
    [anon_sym_extern] = ACTIONS(131),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(37),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym___cdecl] = ACTIONS(41),
    [anon_sym___clrcall] = ACTIONS(41),
    [anon_sym___stdcall] = ACTIONS(41),
    [anon_sym___fastcall] = ACTIONS(41),
    [anon_sym___thiscall] = ACTIONS(41),
    [anon_sym___vectorcall] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(133),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(135),
    [anon_sym_switch] = ACTIONS(137),
    [anon_sym_case] = ACTIONS(139),
    [anon_sym_default] = ACTIONS(141),
    [anon_sym_while] = ACTIONS(143),
    [anon_sym_do] = ACTIONS(145),
    [anon_sym_for] = ACTIONS(147),
    [anon_sym_return] = ACTIONS(149),
    [anon_sym_break] = ACTIONS(151),
    [anon_sym_continue] = ACTIONS(153),
    [anon_sym_goto] = ACTIONS(155),
    [anon_sym___try] = ACTIONS(157),
    [anon_sym___leave] = ACTIONS(159),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(161),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(163),
    [sym_false] = ACTIONS(163),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [14] = {
    [sym__block_item] = STATE(16),
    [sym_preproc_include] = STATE(16),
    [sym_preproc_def] = STATE(16),
    [sym_preproc_function_def] = STATE(16),
    [sym_preproc_call] = STATE(16),
    [sym_preproc_if] = STATE(16),
    [sym_preproc_ifdef] = STATE(16),
    [sym_preproc_else] = STATE(1924),
    [sym_preproc_elif] = STATE(1924),
    [sym_preproc_elifdef] = STATE(1924),
    [sym_function_definition] = STATE(16),
    [sym__old_style_function_definition] = STATE(129),
    [sym_declaration] = STATE(16),
    [sym_type_definition] = STATE(16),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1137),
    [sym_linkage_specification] = STATE(16),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_ms_call_modifier] = STATE(674),
    [sym_compound_statement] = STATE(110),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(793),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(119),
    [sym_statement] = STATE(16),
    [sym_labeled_statement] = STATE(110),
    [sym_expression_statement] = STATE(110),
    [sym_if_statement] = STATE(110),
    [sym_switch_statement] = STATE(110),
    [sym_case_statement] = STATE(110),
    [sym_while_statement] = STATE(110),
    [sym_do_statement] = STATE(110),
    [sym_for_statement] = STATE(110),
    [sym_return_statement] = STATE(110),
    [sym_break_statement] = STATE(110),
    [sym_continue_statement] = STATE(110),
    [sym_goto_statement] = STATE(110),
    [sym_seh_try_statement] = STATE(110),
    [sym_seh_leave_statement] = STATE(110),
    [sym_expression] = STATE(1049),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1950),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym__empty_declaration] = STATE(16),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym_preproc_if_repeat1] = STATE(16),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(373),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [sym_identifier] = ACTIONS(105),
    [aux_sym_preproc_include_token1] = ACTIONS(107),
    [aux_sym_preproc_def_token1] = ACTIONS(109),
    [aux_sym_preproc_if_token1] = ACTIONS(111),
    [aux_sym_preproc_if_token2] = ACTIONS(187),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(115),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(115),
    [aux_sym_preproc_else_token1] = ACTIONS(117),
    [aux_sym_preproc_elif_token1] = ACTIONS(119),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(121),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(121),
    [sym_preproc_directive] = ACTIONS(123),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(125),
    [anon_sym___extension__] = ACTIONS(127),
    [anon_sym_typedef] = ACTIONS(129),
    [anon_sym_extern] = ACTIONS(131),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(37),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym___cdecl] = ACTIONS(41),
    [anon_sym___clrcall] = ACTIONS(41),
    [anon_sym___stdcall] = ACTIONS(41),
    [anon_sym___fastcall] = ACTIONS(41),
    [anon_sym___thiscall] = ACTIONS(41),
    [anon_sym___vectorcall] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(133),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(135),
    [anon_sym_switch] = ACTIONS(137),
    [anon_sym_case] = ACTIONS(139),
    [anon_sym_default] = ACTIONS(141),
    [anon_sym_while] = ACTIONS(143),
    [anon_sym_do] = ACTIONS(145),
    [anon_sym_for] = ACTIONS(147),
    [anon_sym_return] = ACTIONS(149),
    [anon_sym_break] = ACTIONS(151),
    [anon_sym_continue] = ACTIONS(153),
    [anon_sym_goto] = ACTIONS(155),
    [anon_sym___try] = ACTIONS(157),
    [anon_sym___leave] = ACTIONS(159),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(161),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(163),
    [sym_false] = ACTIONS(163),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [15] = {
    [sym__block_item] = STATE(17),
    [sym_preproc_include] = STATE(17),
    [sym_preproc_def] = STATE(17),
    [sym_preproc_function_def] = STATE(17),
    [sym_preproc_call] = STATE(17),
    [sym_preproc_if] = STATE(17),
    [sym_preproc_ifdef] = STATE(17),
    [sym_preproc_else] = STATE(1865),
    [sym_preproc_elif] = STATE(1865),
    [sym_preproc_elifdef] = STATE(1865),
    [sym_function_definition] = STATE(17),
    [sym__old_style_function_definition] = STATE(129),
    [sym_declaration] = STATE(17),
    [sym_type_definition] = STATE(17),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1137),
    [sym_linkage_specification] = STATE(17),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_ms_call_modifier] = STATE(674),
    [sym_compound_statement] = STATE(110),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(793),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(119),
    [sym_statement] = STATE(17),
    [sym_labeled_statement] = STATE(110),
    [sym_expression_statement] = STATE(110),
    [sym_if_statement] = STATE(110),
    [sym_switch_statement] = STATE(110),
    [sym_case_statement] = STATE(110),
    [sym_while_statement] = STATE(110),
    [sym_do_statement] = STATE(110),
    [sym_for_statement] = STATE(110),
    [sym_return_statement] = STATE(110),
    [sym_break_statement] = STATE(110),
    [sym_continue_statement] = STATE(110),
    [sym_goto_statement] = STATE(110),
    [sym_seh_try_statement] = STATE(110),
    [sym_seh_leave_statement] = STATE(110),
    [sym_expression] = STATE(1049),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1950),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym__empty_declaration] = STATE(17),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym_preproc_if_repeat1] = STATE(17),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(373),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [sym_identifier] = ACTIONS(105),
    [aux_sym_preproc_include_token1] = ACTIONS(107),
    [aux_sym_preproc_def_token1] = ACTIONS(109),
    [aux_sym_preproc_if_token1] = ACTIONS(111),
    [aux_sym_preproc_if_token2] = ACTIONS(189),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(115),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(115),
    [aux_sym_preproc_else_token1] = ACTIONS(117),
    [aux_sym_preproc_elif_token1] = ACTIONS(119),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(121),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(121),
    [sym_preproc_directive] = ACTIONS(123),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(125),
    [anon_sym___extension__] = ACTIONS(127),
    [anon_sym_typedef] = ACTIONS(129),
    [anon_sym_extern] = ACTIONS(131),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(37),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym___cdecl] = ACTIONS(41),
    [anon_sym___clrcall] = ACTIONS(41),
    [anon_sym___stdcall] = ACTIONS(41),
    [anon_sym___fastcall] = ACTIONS(41),
    [anon_sym___thiscall] = ACTIONS(41),
    [anon_sym___vectorcall] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(133),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(135),
    [anon_sym_switch] = ACTIONS(137),
    [anon_sym_case] = ACTIONS(139),
    [anon_sym_default] = ACTIONS(141),
    [anon_sym_while] = ACTIONS(143),
    [anon_sym_do] = ACTIONS(145),
    [anon_sym_for] = ACTIONS(147),
    [anon_sym_return] = ACTIONS(149),
    [anon_sym_break] = ACTIONS(151),
    [anon_sym_continue] = ACTIONS(153),
    [anon_sym_goto] = ACTIONS(155),
    [anon_sym___try] = ACTIONS(157),
    [anon_sym___leave] = ACTIONS(159),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(161),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(163),
    [sym_false] = ACTIONS(163),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [16] = {
    [sym__block_item] = STATE(22),
    [sym_preproc_include] = STATE(22),
    [sym_preproc_def] = STATE(22),
    [sym_preproc_function_def] = STATE(22),
    [sym_preproc_call] = STATE(22),
    [sym_preproc_if] = STATE(22),
    [sym_preproc_ifdef] = STATE(22),
    [sym_preproc_else] = STATE(1876),
    [sym_preproc_elif] = STATE(1876),
    [sym_preproc_elifdef] = STATE(1876),
    [sym_function_definition] = STATE(22),
    [sym__old_style_function_definition] = STATE(129),
    [sym_declaration] = STATE(22),
    [sym_type_definition] = STATE(22),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1137),
    [sym_linkage_specification] = STATE(22),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_ms_call_modifier] = STATE(674),
    [sym_compound_statement] = STATE(110),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(793),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(119),
    [sym_statement] = STATE(22),
    [sym_labeled_statement] = STATE(110),
    [sym_expression_statement] = STATE(110),
    [sym_if_statement] = STATE(110),
    [sym_switch_statement] = STATE(110),
    [sym_case_statement] = STATE(110),
    [sym_while_statement] = STATE(110),
    [sym_do_statement] = STATE(110),
    [sym_for_statement] = STATE(110),
    [sym_return_statement] = STATE(110),
    [sym_break_statement] = STATE(110),
    [sym_continue_statement] = STATE(110),
    [sym_goto_statement] = STATE(110),
    [sym_seh_try_statement] = STATE(110),
    [sym_seh_leave_statement] = STATE(110),
    [sym_expression] = STATE(1049),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1950),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym__empty_declaration] = STATE(22),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym_preproc_if_repeat1] = STATE(22),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(373),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [sym_identifier] = ACTIONS(105),
    [aux_sym_preproc_include_token1] = ACTIONS(107),
    [aux_sym_preproc_def_token1] = ACTIONS(109),
    [aux_sym_preproc_if_token1] = ACTIONS(111),
    [aux_sym_preproc_if_token2] = ACTIONS(191),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(115),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(115),
    [aux_sym_preproc_else_token1] = ACTIONS(117),
    [aux_sym_preproc_elif_token1] = ACTIONS(119),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(121),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(121),
    [sym_preproc_directive] = ACTIONS(123),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(125),
    [anon_sym___extension__] = ACTIONS(127),
    [anon_sym_typedef] = ACTIONS(129),
    [anon_sym_extern] = ACTIONS(131),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(37),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym___cdecl] = ACTIONS(41),
    [anon_sym___clrcall] = ACTIONS(41),
    [anon_sym___stdcall] = ACTIONS(41),
    [anon_sym___fastcall] = ACTIONS(41),
    [anon_sym___thiscall] = ACTIONS(41),
    [anon_sym___vectorcall] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(133),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(135),
    [anon_sym_switch] = ACTIONS(137),
    [anon_sym_case] = ACTIONS(139),
    [anon_sym_default] = ACTIONS(141),
    [anon_sym_while] = ACTIONS(143),
    [anon_sym_do] = ACTIONS(145),
    [anon_sym_for] = ACTIONS(147),
    [anon_sym_return] = ACTIONS(149),
    [anon_sym_break] = ACTIONS(151),
    [anon_sym_continue] = ACTIONS(153),
    [anon_sym_goto] = ACTIONS(155),
    [anon_sym___try] = ACTIONS(157),
    [anon_sym___leave] = ACTIONS(159),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(161),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(163),
    [sym_false] = ACTIONS(163),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [17] = {
    [sym__block_item] = STATE(22),
    [sym_preproc_include] = STATE(22),
    [sym_preproc_def] = STATE(22),
    [sym_preproc_function_def] = STATE(22),
    [sym_preproc_call] = STATE(22),
    [sym_preproc_if] = STATE(22),
    [sym_preproc_ifdef] = STATE(22),
    [sym_preproc_else] = STATE(1976),
    [sym_preproc_elif] = STATE(1976),
    [sym_preproc_elifdef] = STATE(1976),
    [sym_function_definition] = STATE(22),
    [sym__old_style_function_definition] = STATE(129),
    [sym_declaration] = STATE(22),
    [sym_type_definition] = STATE(22),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1137),
    [sym_linkage_specification] = STATE(22),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_ms_call_modifier] = STATE(674),
    [sym_compound_statement] = STATE(110),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(793),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(119),
    [sym_statement] = STATE(22),
    [sym_labeled_statement] = STATE(110),
    [sym_expression_statement] = STATE(110),
    [sym_if_statement] = STATE(110),
    [sym_switch_statement] = STATE(110),
    [sym_case_statement] = STATE(110),
    [sym_while_statement] = STATE(110),
    [sym_do_statement] = STATE(110),
    [sym_for_statement] = STATE(110),
    [sym_return_statement] = STATE(110),
    [sym_break_statement] = STATE(110),
    [sym_continue_statement] = STATE(110),
    [sym_goto_statement] = STATE(110),
    [sym_seh_try_statement] = STATE(110),
    [sym_seh_leave_statement] = STATE(110),
    [sym_expression] = STATE(1049),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1950),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym__empty_declaration] = STATE(22),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym_preproc_if_repeat1] = STATE(22),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(373),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [sym_identifier] = ACTIONS(105),
    [aux_sym_preproc_include_token1] = ACTIONS(107),
    [aux_sym_preproc_def_token1] = ACTIONS(109),
    [aux_sym_preproc_if_token1] = ACTIONS(111),
    [aux_sym_preproc_if_token2] = ACTIONS(193),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(115),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(115),
    [aux_sym_preproc_else_token1] = ACTIONS(117),
    [aux_sym_preproc_elif_token1] = ACTIONS(119),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(121),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(121),
    [sym_preproc_directive] = ACTIONS(123),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(125),
    [anon_sym___extension__] = ACTIONS(127),
    [anon_sym_typedef] = ACTIONS(129),
    [anon_sym_extern] = ACTIONS(131),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(37),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym___cdecl] = ACTIONS(41),
    [anon_sym___clrcall] = ACTIONS(41),
    [anon_sym___stdcall] = ACTIONS(41),
    [anon_sym___fastcall] = ACTIONS(41),
    [anon_sym___thiscall] = ACTIONS(41),
    [anon_sym___vectorcall] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(133),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(135),
    [anon_sym_switch] = ACTIONS(137),
    [anon_sym_case] = ACTIONS(139),
    [anon_sym_default] = ACTIONS(141),
    [anon_sym_while] = ACTIONS(143),
    [anon_sym_do] = ACTIONS(145),
    [anon_sym_for] = ACTIONS(147),
    [anon_sym_return] = ACTIONS(149),
    [anon_sym_break] = ACTIONS(151),
    [anon_sym_continue] = ACTIONS(153),
    [anon_sym_goto] = ACTIONS(155),
    [anon_sym___try] = ACTIONS(157),
    [anon_sym___leave] = ACTIONS(159),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(161),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(163),
    [sym_false] = ACTIONS(163),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [18] = {
    [sym__block_item] = STATE(20),
    [sym_preproc_include] = STATE(20),
    [sym_preproc_def] = STATE(20),
    [sym_preproc_function_def] = STATE(20),
    [sym_preproc_call] = STATE(20),
    [sym_preproc_if] = STATE(20),
    [sym_preproc_ifdef] = STATE(20),
    [sym_preproc_else] = STATE(1917),
    [sym_preproc_elif] = STATE(1917),
    [sym_preproc_elifdef] = STATE(1917),
    [sym_function_definition] = STATE(20),
    [sym__old_style_function_definition] = STATE(129),
    [sym_declaration] = STATE(20),
    [sym_type_definition] = STATE(20),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1137),
    [sym_linkage_specification] = STATE(20),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_ms_call_modifier] = STATE(674),
    [sym_compound_statement] = STATE(110),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(793),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(119),
    [sym_statement] = STATE(20),
    [sym_labeled_statement] = STATE(110),
    [sym_expression_statement] = STATE(110),
    [sym_if_statement] = STATE(110),
    [sym_switch_statement] = STATE(110),
    [sym_case_statement] = STATE(110),
    [sym_while_statement] = STATE(110),
    [sym_do_statement] = STATE(110),
    [sym_for_statement] = STATE(110),
    [sym_return_statement] = STATE(110),
    [sym_break_statement] = STATE(110),
    [sym_continue_statement] = STATE(110),
    [sym_goto_statement] = STATE(110),
    [sym_seh_try_statement] = STATE(110),
    [sym_seh_leave_statement] = STATE(110),
    [sym_expression] = STATE(1049),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1950),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym__empty_declaration] = STATE(20),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym_preproc_if_repeat1] = STATE(20),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(373),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [sym_identifier] = ACTIONS(105),
    [aux_sym_preproc_include_token1] = ACTIONS(107),
    [aux_sym_preproc_def_token1] = ACTIONS(109),
    [aux_sym_preproc_if_token1] = ACTIONS(111),
    [aux_sym_preproc_if_token2] = ACTIONS(195),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(115),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(115),
    [aux_sym_preproc_else_token1] = ACTIONS(117),
    [aux_sym_preproc_elif_token1] = ACTIONS(119),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(121),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(121),
    [sym_preproc_directive] = ACTIONS(123),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(125),
    [anon_sym___extension__] = ACTIONS(127),
    [anon_sym_typedef] = ACTIONS(129),
    [anon_sym_extern] = ACTIONS(131),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(37),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym___cdecl] = ACTIONS(41),
    [anon_sym___clrcall] = ACTIONS(41),
    [anon_sym___stdcall] = ACTIONS(41),
    [anon_sym___fastcall] = ACTIONS(41),
    [anon_sym___thiscall] = ACTIONS(41),
    [anon_sym___vectorcall] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(133),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(135),
    [anon_sym_switch] = ACTIONS(137),
    [anon_sym_case] = ACTIONS(139),
    [anon_sym_default] = ACTIONS(141),
    [anon_sym_while] = ACTIONS(143),
    [anon_sym_do] = ACTIONS(145),
    [anon_sym_for] = ACTIONS(147),
    [anon_sym_return] = ACTIONS(149),
    [anon_sym_break] = ACTIONS(151),
    [anon_sym_continue] = ACTIONS(153),
    [anon_sym_goto] = ACTIONS(155),
    [anon_sym___try] = ACTIONS(157),
    [anon_sym___leave] = ACTIONS(159),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(161),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(163),
    [sym_false] = ACTIONS(163),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [19] = {
    [sym__block_item] = STATE(21),
    [sym_preproc_include] = STATE(21),
    [sym_preproc_def] = STATE(21),
    [sym_preproc_function_def] = STATE(21),
    [sym_preproc_call] = STATE(21),
    [sym_preproc_if] = STATE(21),
    [sym_preproc_ifdef] = STATE(21),
    [sym_preproc_else] = STATE(1958),
    [sym_preproc_elif] = STATE(1958),
    [sym_preproc_elifdef] = STATE(1958),
    [sym_function_definition] = STATE(21),
    [sym__old_style_function_definition] = STATE(129),
    [sym_declaration] = STATE(21),
    [sym_type_definition] = STATE(21),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1137),
    [sym_linkage_specification] = STATE(21),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_ms_call_modifier] = STATE(674),
    [sym_compound_statement] = STATE(110),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(793),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(119),
    [sym_statement] = STATE(21),
    [sym_labeled_statement] = STATE(110),
    [sym_expression_statement] = STATE(110),
    [sym_if_statement] = STATE(110),
    [sym_switch_statement] = STATE(110),
    [sym_case_statement] = STATE(110),
    [sym_while_statement] = STATE(110),
    [sym_do_statement] = STATE(110),
    [sym_for_statement] = STATE(110),
    [sym_return_statement] = STATE(110),
    [sym_break_statement] = STATE(110),
    [sym_continue_statement] = STATE(110),
    [sym_goto_statement] = STATE(110),
    [sym_seh_try_statement] = STATE(110),
    [sym_seh_leave_statement] = STATE(110),
    [sym_expression] = STATE(1049),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1950),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym__empty_declaration] = STATE(21),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym_preproc_if_repeat1] = STATE(21),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(373),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [sym_identifier] = ACTIONS(105),
    [aux_sym_preproc_include_token1] = ACTIONS(107),
    [aux_sym_preproc_def_token1] = ACTIONS(109),
    [aux_sym_preproc_if_token1] = ACTIONS(111),
    [aux_sym_preproc_if_token2] = ACTIONS(197),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(115),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(115),
    [aux_sym_preproc_else_token1] = ACTIONS(117),
    [aux_sym_preproc_elif_token1] = ACTIONS(119),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(121),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(121),
    [sym_preproc_directive] = ACTIONS(123),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(125),
    [anon_sym___extension__] = ACTIONS(127),
    [anon_sym_typedef] = ACTIONS(129),
    [anon_sym_extern] = ACTIONS(131),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(37),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym___cdecl] = ACTIONS(41),
    [anon_sym___clrcall] = ACTIONS(41),
    [anon_sym___stdcall] = ACTIONS(41),
    [anon_sym___fastcall] = ACTIONS(41),
    [anon_sym___thiscall] = ACTIONS(41),
    [anon_sym___vectorcall] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(133),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(135),
    [anon_sym_switch] = ACTIONS(137),
    [anon_sym_case] = ACTIONS(139),
    [anon_sym_default] = ACTIONS(141),
    [anon_sym_while] = ACTIONS(143),
    [anon_sym_do] = ACTIONS(145),
    [anon_sym_for] = ACTIONS(147),
    [anon_sym_return] = ACTIONS(149),
    [anon_sym_break] = ACTIONS(151),
    [anon_sym_continue] = ACTIONS(153),
    [anon_sym_goto] = ACTIONS(155),
    [anon_sym___try] = ACTIONS(157),
    [anon_sym___leave] = ACTIONS(159),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(161),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(163),
    [sym_false] = ACTIONS(163),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [20] = {
    [sym__block_item] = STATE(22),
    [sym_preproc_include] = STATE(22),
    [sym_preproc_def] = STATE(22),
    [sym_preproc_function_def] = STATE(22),
    [sym_preproc_call] = STATE(22),
    [sym_preproc_if] = STATE(22),
    [sym_preproc_ifdef] = STATE(22),
    [sym_preproc_else] = STATE(1962),
    [sym_preproc_elif] = STATE(1962),
    [sym_preproc_elifdef] = STATE(1962),
    [sym_function_definition] = STATE(22),
    [sym__old_style_function_definition] = STATE(129),
    [sym_declaration] = STATE(22),
    [sym_type_definition] = STATE(22),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1137),
    [sym_linkage_specification] = STATE(22),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_ms_call_modifier] = STATE(674),
    [sym_compound_statement] = STATE(110),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(793),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(119),
    [sym_statement] = STATE(22),
    [sym_labeled_statement] = STATE(110),
    [sym_expression_statement] = STATE(110),
    [sym_if_statement] = STATE(110),
    [sym_switch_statement] = STATE(110),
    [sym_case_statement] = STATE(110),
    [sym_while_statement] = STATE(110),
    [sym_do_statement] = STATE(110),
    [sym_for_statement] = STATE(110),
    [sym_return_statement] = STATE(110),
    [sym_break_statement] = STATE(110),
    [sym_continue_statement] = STATE(110),
    [sym_goto_statement] = STATE(110),
    [sym_seh_try_statement] = STATE(110),
    [sym_seh_leave_statement] = STATE(110),
    [sym_expression] = STATE(1049),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1950),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym__empty_declaration] = STATE(22),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym_preproc_if_repeat1] = STATE(22),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(373),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [sym_identifier] = ACTIONS(105),
    [aux_sym_preproc_include_token1] = ACTIONS(107),
    [aux_sym_preproc_def_token1] = ACTIONS(109),
    [aux_sym_preproc_if_token1] = ACTIONS(111),
    [aux_sym_preproc_if_token2] = ACTIONS(199),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(115),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(115),
    [aux_sym_preproc_else_token1] = ACTIONS(117),
    [aux_sym_preproc_elif_token1] = ACTIONS(119),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(121),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(121),
    [sym_preproc_directive] = ACTIONS(123),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(125),
    [anon_sym___extension__] = ACTIONS(127),
    [anon_sym_typedef] = ACTIONS(129),
    [anon_sym_extern] = ACTIONS(131),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(37),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym___cdecl] = ACTIONS(41),
    [anon_sym___clrcall] = ACTIONS(41),
    [anon_sym___stdcall] = ACTIONS(41),
    [anon_sym___fastcall] = ACTIONS(41),
    [anon_sym___thiscall] = ACTIONS(41),
    [anon_sym___vectorcall] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(133),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(135),
    [anon_sym_switch] = ACTIONS(137),
    [anon_sym_case] = ACTIONS(139),
    [anon_sym_default] = ACTIONS(141),
    [anon_sym_while] = ACTIONS(143),
    [anon_sym_do] = ACTIONS(145),
    [anon_sym_for] = ACTIONS(147),
    [anon_sym_return] = ACTIONS(149),
    [anon_sym_break] = ACTIONS(151),
    [anon_sym_continue] = ACTIONS(153),
    [anon_sym_goto] = ACTIONS(155),
    [anon_sym___try] = ACTIONS(157),
    [anon_sym___leave] = ACTIONS(159),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(161),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(163),
    [sym_false] = ACTIONS(163),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [21] = {
    [sym__block_item] = STATE(22),
    [sym_preproc_include] = STATE(22),
    [sym_preproc_def] = STATE(22),
    [sym_preproc_function_def] = STATE(22),
    [sym_preproc_call] = STATE(22),
    [sym_preproc_if] = STATE(22),
    [sym_preproc_ifdef] = STATE(22),
    [sym_preproc_else] = STATE(2009),
    [sym_preproc_elif] = STATE(2009),
    [sym_preproc_elifdef] = STATE(2009),
    [sym_function_definition] = STATE(22),
    [sym__old_style_function_definition] = STATE(129),
    [sym_declaration] = STATE(22),
    [sym_type_definition] = STATE(22),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1137),
    [sym_linkage_specification] = STATE(22),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_ms_call_modifier] = STATE(674),
    [sym_compound_statement] = STATE(110),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(793),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(119),
    [sym_statement] = STATE(22),
    [sym_labeled_statement] = STATE(110),
    [sym_expression_statement] = STATE(110),
    [sym_if_statement] = STATE(110),
    [sym_switch_statement] = STATE(110),
    [sym_case_statement] = STATE(110),
    [sym_while_statement] = STATE(110),
    [sym_do_statement] = STATE(110),
    [sym_for_statement] = STATE(110),
    [sym_return_statement] = STATE(110),
    [sym_break_statement] = STATE(110),
    [sym_continue_statement] = STATE(110),
    [sym_goto_statement] = STATE(110),
    [sym_seh_try_statement] = STATE(110),
    [sym_seh_leave_statement] = STATE(110),
    [sym_expression] = STATE(1049),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1950),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym__empty_declaration] = STATE(22),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym_preproc_if_repeat1] = STATE(22),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(373),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [sym_identifier] = ACTIONS(105),
    [aux_sym_preproc_include_token1] = ACTIONS(107),
    [aux_sym_preproc_def_token1] = ACTIONS(109),
    [aux_sym_preproc_if_token1] = ACTIONS(111),
    [aux_sym_preproc_if_token2] = ACTIONS(201),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(115),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(115),
    [aux_sym_preproc_else_token1] = ACTIONS(117),
    [aux_sym_preproc_elif_token1] = ACTIONS(119),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(121),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(121),
    [sym_preproc_directive] = ACTIONS(123),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(125),
    [anon_sym___extension__] = ACTIONS(127),
    [anon_sym_typedef] = ACTIONS(129),
    [anon_sym_extern] = ACTIONS(131),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(37),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym___cdecl] = ACTIONS(41),
    [anon_sym___clrcall] = ACTIONS(41),
    [anon_sym___stdcall] = ACTIONS(41),
    [anon_sym___fastcall] = ACTIONS(41),
    [anon_sym___thiscall] = ACTIONS(41),
    [anon_sym___vectorcall] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(133),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(135),
    [anon_sym_switch] = ACTIONS(137),
    [anon_sym_case] = ACTIONS(139),
    [anon_sym_default] = ACTIONS(141),
    [anon_sym_while] = ACTIONS(143),
    [anon_sym_do] = ACTIONS(145),
    [anon_sym_for] = ACTIONS(147),
    [anon_sym_return] = ACTIONS(149),
    [anon_sym_break] = ACTIONS(151),
    [anon_sym_continue] = ACTIONS(153),
    [anon_sym_goto] = ACTIONS(155),
    [anon_sym___try] = ACTIONS(157),
    [anon_sym___leave] = ACTIONS(159),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(161),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(163),
    [sym_false] = ACTIONS(163),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [22] = {
    [sym__block_item] = STATE(22),
    [sym_preproc_include] = STATE(22),
    [sym_preproc_def] = STATE(22),
    [sym_preproc_function_def] = STATE(22),
    [sym_preproc_call] = STATE(22),
    [sym_preproc_if] = STATE(22),
    [sym_preproc_ifdef] = STATE(22),
    [sym_function_definition] = STATE(22),
    [sym__old_style_function_definition] = STATE(129),
    [sym_declaration] = STATE(22),
    [sym_type_definition] = STATE(22),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1137),
    [sym_linkage_specification] = STATE(22),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_ms_call_modifier] = STATE(674),
    [sym_compound_statement] = STATE(110),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(793),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(119),
    [sym_statement] = STATE(22),
    [sym_labeled_statement] = STATE(110),
    [sym_expression_statement] = STATE(110),
    [sym_if_statement] = STATE(110),
    [sym_switch_statement] = STATE(110),
    [sym_case_statement] = STATE(110),
    [sym_while_statement] = STATE(110),
    [sym_do_statement] = STATE(110),
    [sym_for_statement] = STATE(110),
    [sym_return_statement] = STATE(110),
    [sym_break_statement] = STATE(110),
    [sym_continue_statement] = STATE(110),
    [sym_goto_statement] = STATE(110),
    [sym_seh_try_statement] = STATE(110),
    [sym_seh_leave_statement] = STATE(110),
    [sym_expression] = STATE(1049),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1950),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym__empty_declaration] = STATE(22),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym_preproc_if_repeat1] = STATE(22),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(373),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [sym_identifier] = ACTIONS(203),
    [aux_sym_preproc_include_token1] = ACTIONS(206),
    [aux_sym_preproc_def_token1] = ACTIONS(209),
    [aux_sym_preproc_if_token1] = ACTIONS(212),
    [aux_sym_preproc_if_token2] = ACTIONS(215),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(217),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(217),
    [aux_sym_preproc_else_token1] = ACTIONS(215),
    [aux_sym_preproc_elif_token1] = ACTIONS(215),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(215),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(215),
    [sym_preproc_directive] = ACTIONS(220),
    [anon_sym_LPAREN2] = ACTIONS(223),
    [anon_sym_BANG] = ACTIONS(226),
    [anon_sym_TILDE] = ACTIONS(226),
    [anon_sym_DASH] = ACTIONS(229),
    [anon_sym_PLUS] = ACTIONS(229),
    [anon_sym_STAR] = ACTIONS(232),
    [anon_sym_AMP] = ACTIONS(232),
    [anon_sym_SEMI] = ACTIONS(235),
    [anon_sym___extension__] = ACTIONS(238),
    [anon_sym_typedef] = ACTIONS(241),
    [anon_sym_extern] = ACTIONS(244),
    [anon_sym___attribute__] = ACTIONS(247),
    [anon_sym___attribute] = ACTIONS(247),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(250),
    [anon_sym___declspec] = ACTIONS(253),
    [anon_sym___cdecl] = ACTIONS(256),
    [anon_sym___clrcall] = ACTIONS(256),
    [anon_sym___stdcall] = ACTIONS(256),
    [anon_sym___fastcall] = ACTIONS(256),
    [anon_sym___thiscall] = ACTIONS(256),
    [anon_sym___vectorcall] = ACTIONS(256),
    [anon_sym_LBRACE] = ACTIONS(259),
    [anon_sym_signed] = ACTIONS(262),
    [anon_sym_unsigned] = ACTIONS(262),
    [anon_sym_long] = ACTIONS(262),
    [anon_sym_short] = ACTIONS(262),
    [anon_sym_static] = ACTIONS(265),
    [anon_sym_auto] = ACTIONS(265),
    [anon_sym_register] = ACTIONS(265),
    [anon_sym_inline] = ACTIONS(265),
    [anon_sym___inline] = ACTIONS(265),
    [anon_sym___inline__] = ACTIONS(265),
    [anon_sym___forceinline] = ACTIONS(265),
    [anon_sym_thread_local] = ACTIONS(265),
    [anon_sym___thread] = ACTIONS(265),
    [anon_sym_const] = ACTIONS(268),
    [anon_sym_constexpr] = ACTIONS(268),
    [anon_sym_volatile] = ACTIONS(268),
    [anon_sym_restrict] = ACTIONS(268),
    [anon_sym___restrict__] = ACTIONS(268),
    [anon_sym__Atomic] = ACTIONS(268),
    [anon_sym__Noreturn] = ACTIONS(268),
    [anon_sym_noreturn] = ACTIONS(268),
    [anon_sym__Nonnull] = ACTIONS(268),
    [anon_sym_alignas] = ACTIONS(271),
    [anon_sym__Alignas] = ACTIONS(271),
    [sym_primitive_type] = ACTIONS(274),
    [anon_sym_enum] = ACTIONS(277),
    [anon_sym_struct] = ACTIONS(280),
    [anon_sym_union] = ACTIONS(283),
    [anon_sym_if] = ACTIONS(286),
    [anon_sym_switch] = ACTIONS(289),
    [anon_sym_case] = ACTIONS(292),
    [anon_sym_default] = ACTIONS(295),
    [anon_sym_while] = ACTIONS(298),
    [anon_sym_do] = ACTIONS(301),
    [anon_sym_for] = ACTIONS(304),
    [anon_sym_return] = ACTIONS(307),
    [anon_sym_break] = ACTIONS(310),
    [anon_sym_continue] = ACTIONS(313),
    [anon_sym_goto] = ACTIONS(316),
    [anon_sym___try] = ACTIONS(319),
    [anon_sym___leave] = ACTIONS(322),
    [anon_sym_DASH_DASH] = ACTIONS(325),
    [anon_sym_PLUS_PLUS] = ACTIONS(325),
    [anon_sym_sizeof] = ACTIONS(328),
    [anon_sym___alignof__] = ACTIONS(331),
    [anon_sym___alignof] = ACTIONS(331),
    [anon_sym__alignof] = ACTIONS(331),
    [anon_sym_alignof] = ACTIONS(331),
    [anon_sym__Alignof] = ACTIONS(331),
    [anon_sym_offsetof] = ACTIONS(334),
    [anon_sym__Generic] = ACTIONS(337),
    [anon_sym_asm] = ACTIONS(340),
    [anon_sym___asm__] = ACTIONS(340),
    [anon_sym___asm] = ACTIONS(340),
    [sym_number_literal] = ACTIONS(343),
    [anon_sym_L_SQUOTE] = ACTIONS(346),
    [anon_sym_u_SQUOTE] = ACTIONS(346),
    [anon_sym_U_SQUOTE] = ACTIONS(346),
    [anon_sym_u8_SQUOTE] = ACTIONS(346),
    [anon_sym_SQUOTE] = ACTIONS(346),
    [anon_sym_L_DQUOTE] = ACTIONS(349),
    [anon_sym_u_DQUOTE] = ACTIONS(349),
    [anon_sym_U_DQUOTE] = ACTIONS(349),
    [anon_sym_u8_DQUOTE] = ACTIONS(349),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [sym_true] = ACTIONS(352),
    [sym_false] = ACTIONS(352),
    [anon_sym_NULL] = ACTIONS(355),
    [anon_sym_nullptr] = ACTIONS(355),
    [sym_comment] = ACTIONS(3),
  },
  [23] = {
    [sym__block_item] = STATE(31),
    [sym_preproc_include] = STATE(31),
    [sym_preproc_def] = STATE(31),
    [sym_preproc_function_def] = STATE(31),
    [sym_preproc_call] = STATE(31),
    [sym_preproc_if] = STATE(31),
    [sym_preproc_ifdef] = STATE(31),
    [sym_function_definition] = STATE(31),
    [sym__old_style_function_definition] = STATE(271),
    [sym_declaration] = STATE(31),
    [sym_type_definition] = STATE(31),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1138),
    [sym_linkage_specification] = STATE(31),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_ms_call_modifier] = STATE(694),
    [sym_compound_statement] = STATE(250),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(812),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(272),
    [sym_statement] = STATE(31),
    [sym_labeled_statement] = STATE(250),
    [sym_expression_statement] = STATE(250),
    [sym_if_statement] = STATE(250),
    [sym_switch_statement] = STATE(250),
    [sym_case_statement] = STATE(250),
    [sym_while_statement] = STATE(250),
    [sym_do_statement] = STATE(250),
    [sym_for_statement] = STATE(250),
    [sym_return_statement] = STATE(250),
    [sym_break_statement] = STATE(250),
    [sym_continue_statement] = STATE(250),
    [sym_goto_statement] = STATE(250),
    [sym_seh_try_statement] = STATE(250),
    [sym_seh_leave_statement] = STATE(250),
    [sym_expression] = STATE(1071),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1906),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym__empty_declaration] = STATE(31),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym_preproc_if_repeat1] = STATE(31),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(349),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [sym_identifier] = ACTIONS(358),
    [aux_sym_preproc_include_token1] = ACTIONS(360),
    [aux_sym_preproc_def_token1] = ACTIONS(362),
    [aux_sym_preproc_if_token1] = ACTIONS(364),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(366),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(366),
    [sym_preproc_directive] = ACTIONS(368),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(370),
    [anon_sym___extension__] = ACTIONS(372),
    [anon_sym_typedef] = ACTIONS(374),
    [anon_sym_extern] = ACTIONS(376),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(37),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym___cdecl] = ACTIONS(41),
    [anon_sym___clrcall] = ACTIONS(41),
    [anon_sym___stdcall] = ACTIONS(41),
    [anon_sym___fastcall] = ACTIONS(41),
    [anon_sym___thiscall] = ACTIONS(41),
    [anon_sym___vectorcall] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(378),
    [anon_sym_RBRACE] = ACTIONS(380),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(382),
    [anon_sym_switch] = ACTIONS(384),
    [anon_sym_case] = ACTIONS(386),
    [anon_sym_default] = ACTIONS(388),
    [anon_sym_while] = ACTIONS(390),
    [anon_sym_do] = ACTIONS(392),
    [anon_sym_for] = ACTIONS(394),
    [anon_sym_return] = ACTIONS(396),
    [anon_sym_break] = ACTIONS(398),
    [anon_sym_continue] = ACTIONS(400),
    [anon_sym_goto] = ACTIONS(402),
    [anon_sym___try] = ACTIONS(404),
    [anon_sym___leave] = ACTIONS(406),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(161),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(163),
    [sym_false] = ACTIONS(163),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [24] = {
    [sym__block_item] = STATE(24),
    [sym_preproc_include] = STATE(24),
    [sym_preproc_def] = STATE(24),
    [sym_preproc_function_def] = STATE(24),
    [sym_preproc_call] = STATE(24),
    [sym_preproc_if] = STATE(24),
    [sym_preproc_ifdef] = STATE(24),
    [sym_function_definition] = STATE(24),
    [sym__old_style_function_definition] = STATE(271),
    [sym_declaration] = STATE(24),
    [sym_type_definition] = STATE(24),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1138),
    [sym_linkage_specification] = STATE(24),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_ms_call_modifier] = STATE(694),
    [sym_compound_statement] = STATE(250),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(812),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(272),
    [sym_statement] = STATE(24),
    [sym_labeled_statement] = STATE(250),
    [sym_expression_statement] = STATE(250),
    [sym_if_statement] = STATE(250),
    [sym_switch_statement] = STATE(250),
    [sym_case_statement] = STATE(250),
    [sym_while_statement] = STATE(250),
    [sym_do_statement] = STATE(250),
    [sym_for_statement] = STATE(250),
    [sym_return_statement] = STATE(250),
    [sym_break_statement] = STATE(250),
    [sym_continue_statement] = STATE(250),
    [sym_goto_statement] = STATE(250),
    [sym_seh_try_statement] = STATE(250),
    [sym_seh_leave_statement] = STATE(250),
    [sym_expression] = STATE(1071),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1906),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym__empty_declaration] = STATE(24),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym_preproc_if_repeat1] = STATE(24),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(349),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [sym_identifier] = ACTIONS(408),
    [aux_sym_preproc_include_token1] = ACTIONS(411),
    [aux_sym_preproc_def_token1] = ACTIONS(414),
    [aux_sym_preproc_if_token1] = ACTIONS(417),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(420),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(420),
    [sym_preproc_directive] = ACTIONS(423),
    [anon_sym_LPAREN2] = ACTIONS(223),
    [anon_sym_BANG] = ACTIONS(226),
    [anon_sym_TILDE] = ACTIONS(226),
    [anon_sym_DASH] = ACTIONS(229),
    [anon_sym_PLUS] = ACTIONS(229),
    [anon_sym_STAR] = ACTIONS(232),
    [anon_sym_AMP] = ACTIONS(232),
    [anon_sym_SEMI] = ACTIONS(426),
    [anon_sym___extension__] = ACTIONS(429),
    [anon_sym_typedef] = ACTIONS(432),
    [anon_sym_extern] = ACTIONS(435),
    [anon_sym___attribute__] = ACTIONS(247),
    [anon_sym___attribute] = ACTIONS(247),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(250),
    [anon_sym___declspec] = ACTIONS(253),
    [anon_sym___cdecl] = ACTIONS(256),
    [anon_sym___clrcall] = ACTIONS(256),
    [anon_sym___stdcall] = ACTIONS(256),
    [anon_sym___fastcall] = ACTIONS(256),
    [anon_sym___thiscall] = ACTIONS(256),
    [anon_sym___vectorcall] = ACTIONS(256),
    [anon_sym_LBRACE] = ACTIONS(438),
    [anon_sym_RBRACE] = ACTIONS(441),
    [anon_sym_signed] = ACTIONS(262),
    [anon_sym_unsigned] = ACTIONS(262),
    [anon_sym_long] = ACTIONS(262),
    [anon_sym_short] = ACTIONS(262),
    [anon_sym_static] = ACTIONS(265),
    [anon_sym_auto] = ACTIONS(265),
    [anon_sym_register] = ACTIONS(265),
    [anon_sym_inline] = ACTIONS(265),
    [anon_sym___inline] = ACTIONS(265),
    [anon_sym___inline__] = ACTIONS(265),
    [anon_sym___forceinline] = ACTIONS(265),
    [anon_sym_thread_local] = ACTIONS(265),
    [anon_sym___thread] = ACTIONS(265),
    [anon_sym_const] = ACTIONS(268),
    [anon_sym_constexpr] = ACTIONS(268),
    [anon_sym_volatile] = ACTIONS(268),
    [anon_sym_restrict] = ACTIONS(268),
    [anon_sym___restrict__] = ACTIONS(268),
    [anon_sym__Atomic] = ACTIONS(268),
    [anon_sym__Noreturn] = ACTIONS(268),
    [anon_sym_noreturn] = ACTIONS(268),
    [anon_sym__Nonnull] = ACTIONS(268),
    [anon_sym_alignas] = ACTIONS(271),
    [anon_sym__Alignas] = ACTIONS(271),
    [sym_primitive_type] = ACTIONS(274),
    [anon_sym_enum] = ACTIONS(277),
    [anon_sym_struct] = ACTIONS(280),
    [anon_sym_union] = ACTIONS(283),
    [anon_sym_if] = ACTIONS(443),
    [anon_sym_switch] = ACTIONS(446),
    [anon_sym_case] = ACTIONS(449),
    [anon_sym_default] = ACTIONS(452),
    [anon_sym_while] = ACTIONS(455),
    [anon_sym_do] = ACTIONS(458),
    [anon_sym_for] = ACTIONS(461),
    [anon_sym_return] = ACTIONS(464),
    [anon_sym_break] = ACTIONS(467),
    [anon_sym_continue] = ACTIONS(470),
    [anon_sym_goto] = ACTIONS(473),
    [anon_sym___try] = ACTIONS(476),
    [anon_sym___leave] = ACTIONS(479),
    [anon_sym_DASH_DASH] = ACTIONS(325),
    [anon_sym_PLUS_PLUS] = ACTIONS(325),
    [anon_sym_sizeof] = ACTIONS(328),
    [anon_sym___alignof__] = ACTIONS(331),
    [anon_sym___alignof] = ACTIONS(331),
    [anon_sym__alignof] = ACTIONS(331),
    [anon_sym_alignof] = ACTIONS(331),
    [anon_sym__Alignof] = ACTIONS(331),
    [anon_sym_offsetof] = ACTIONS(334),
    [anon_sym__Generic] = ACTIONS(337),
    [anon_sym_asm] = ACTIONS(340),
    [anon_sym___asm__] = ACTIONS(340),
    [anon_sym___asm] = ACTIONS(340),
    [sym_number_literal] = ACTIONS(343),
    [anon_sym_L_SQUOTE] = ACTIONS(346),
    [anon_sym_u_SQUOTE] = ACTIONS(346),
    [anon_sym_U_SQUOTE] = ACTIONS(346),
    [anon_sym_u8_SQUOTE] = ACTIONS(346),
    [anon_sym_SQUOTE] = ACTIONS(346),
    [anon_sym_L_DQUOTE] = ACTIONS(349),
    [anon_sym_u_DQUOTE] = ACTIONS(349),
    [anon_sym_U_DQUOTE] = ACTIONS(349),
    [anon_sym_u8_DQUOTE] = ACTIONS(349),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [sym_true] = ACTIONS(352),
    [sym_false] = ACTIONS(352),
    [anon_sym_NULL] = ACTIONS(355),
    [anon_sym_nullptr] = ACTIONS(355),
    [sym_comment] = ACTIONS(3),
  },
  [25] = {
    [sym__block_item] = STATE(27),
    [sym_preproc_include] = STATE(27),
    [sym_preproc_def] = STATE(27),
    [sym_preproc_function_def] = STATE(27),
    [sym_preproc_call] = STATE(27),
    [sym_preproc_if] = STATE(27),
    [sym_preproc_ifdef] = STATE(27),
    [sym_function_definition] = STATE(27),
    [sym__old_style_function_definition] = STATE(271),
    [sym_declaration] = STATE(27),
    [sym_type_definition] = STATE(27),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1138),
    [sym_linkage_specification] = STATE(27),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_ms_call_modifier] = STATE(694),
    [sym_compound_statement] = STATE(250),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(812),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(272),
    [sym_statement] = STATE(27),
    [sym_labeled_statement] = STATE(250),
    [sym_expression_statement] = STATE(250),
    [sym_if_statement] = STATE(250),
    [sym_switch_statement] = STATE(250),
    [sym_case_statement] = STATE(250),
    [sym_while_statement] = STATE(250),
    [sym_do_statement] = STATE(250),
    [sym_for_statement] = STATE(250),
    [sym_return_statement] = STATE(250),
    [sym_break_statement] = STATE(250),
    [sym_continue_statement] = STATE(250),
    [sym_goto_statement] = STATE(250),
    [sym_seh_try_statement] = STATE(250),
    [sym_seh_leave_statement] = STATE(250),
    [sym_expression] = STATE(1071),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1906),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym__empty_declaration] = STATE(27),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym_preproc_if_repeat1] = STATE(27),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(349),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [sym_identifier] = ACTIONS(358),
    [aux_sym_preproc_include_token1] = ACTIONS(360),
    [aux_sym_preproc_def_token1] = ACTIONS(362),
    [aux_sym_preproc_if_token1] = ACTIONS(364),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(366),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(366),
    [sym_preproc_directive] = ACTIONS(368),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(370),
    [anon_sym___extension__] = ACTIONS(372),
    [anon_sym_typedef] = ACTIONS(374),
    [anon_sym_extern] = ACTIONS(376),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(37),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym___cdecl] = ACTIONS(41),
    [anon_sym___clrcall] = ACTIONS(41),
    [anon_sym___stdcall] = ACTIONS(41),
    [anon_sym___fastcall] = ACTIONS(41),
    [anon_sym___thiscall] = ACTIONS(41),
    [anon_sym___vectorcall] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(378),
    [anon_sym_RBRACE] = ACTIONS(482),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(382),
    [anon_sym_switch] = ACTIONS(384),
    [anon_sym_case] = ACTIONS(386),
    [anon_sym_default] = ACTIONS(388),
    [anon_sym_while] = ACTIONS(390),
    [anon_sym_do] = ACTIONS(392),
    [anon_sym_for] = ACTIONS(394),
    [anon_sym_return] = ACTIONS(396),
    [anon_sym_break] = ACTIONS(398),
    [anon_sym_continue] = ACTIONS(400),
    [anon_sym_goto] = ACTIONS(402),
    [anon_sym___try] = ACTIONS(404),
    [anon_sym___leave] = ACTIONS(406),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(161),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(163),
    [sym_false] = ACTIONS(163),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [26] = {
    [sym__block_item] = STATE(40),
    [sym_preproc_include] = STATE(40),
    [sym_preproc_def] = STATE(40),
    [sym_preproc_function_def] = STATE(40),
    [sym_preproc_call] = STATE(40),
    [sym_preproc_if] = STATE(40),
    [sym_preproc_ifdef] = STATE(40),
    [sym_function_definition] = STATE(40),
    [sym__old_style_function_definition] = STATE(286),
    [sym_declaration] = STATE(40),
    [sym_type_definition] = STATE(40),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1139),
    [sym_linkage_specification] = STATE(40),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_ms_call_modifier] = STATE(697),
    [sym_compound_statement] = STATE(180),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(798),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(287),
    [sym_statement] = STATE(40),
    [sym_labeled_statement] = STATE(180),
    [sym_expression_statement] = STATE(180),
    [sym_if_statement] = STATE(180),
    [sym_switch_statement] = STATE(180),
    [sym_case_statement] = STATE(180),
    [sym_while_statement] = STATE(180),
    [sym_do_statement] = STATE(180),
    [sym_for_statement] = STATE(180),
    [sym_return_statement] = STATE(180),
    [sym_break_statement] = STATE(180),
    [sym_continue_statement] = STATE(180),
    [sym_goto_statement] = STATE(180),
    [sym_seh_try_statement] = STATE(180),
    [sym_seh_leave_statement] = STATE(180),
    [sym_expression] = STATE(1052),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1858),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym__empty_declaration] = STATE(40),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym_preproc_if_repeat1] = STATE(40),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(378),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [sym_identifier] = ACTIONS(484),
    [aux_sym_preproc_include_token1] = ACTIONS(486),
    [aux_sym_preproc_def_token1] = ACTIONS(488),
    [aux_sym_preproc_if_token1] = ACTIONS(490),
    [aux_sym_preproc_if_token2] = ACTIONS(492),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(494),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(494),
    [sym_preproc_directive] = ACTIONS(496),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(498),
    [anon_sym___extension__] = ACTIONS(500),
    [anon_sym_typedef] = ACTIONS(502),
    [anon_sym_extern] = ACTIONS(504),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(37),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym___cdecl] = ACTIONS(41),
    [anon_sym___clrcall] = ACTIONS(41),
    [anon_sym___stdcall] = ACTIONS(41),
    [anon_sym___fastcall] = ACTIONS(41),
    [anon_sym___thiscall] = ACTIONS(41),
    [anon_sym___vectorcall] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(506),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(508),
    [anon_sym_switch] = ACTIONS(510),
    [anon_sym_case] = ACTIONS(512),
    [anon_sym_default] = ACTIONS(514),
    [anon_sym_while] = ACTIONS(516),
    [anon_sym_do] = ACTIONS(518),
    [anon_sym_for] = ACTIONS(520),
    [anon_sym_return] = ACTIONS(522),
    [anon_sym_break] = ACTIONS(524),
    [anon_sym_continue] = ACTIONS(526),
    [anon_sym_goto] = ACTIONS(528),
    [anon_sym___try] = ACTIONS(530),
    [anon_sym___leave] = ACTIONS(532),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(161),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(163),
    [sym_false] = ACTIONS(163),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [27] = {
    [sym__block_item] = STATE(24),
    [sym_preproc_include] = STATE(24),
    [sym_preproc_def] = STATE(24),
    [sym_preproc_function_def] = STATE(24),
    [sym_preproc_call] = STATE(24),
    [sym_preproc_if] = STATE(24),
    [sym_preproc_ifdef] = STATE(24),
    [sym_function_definition] = STATE(24),
    [sym__old_style_function_definition] = STATE(271),
    [sym_declaration] = STATE(24),
    [sym_type_definition] = STATE(24),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1138),
    [sym_linkage_specification] = STATE(24),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_ms_call_modifier] = STATE(694),
    [sym_compound_statement] = STATE(250),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(812),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(272),
    [sym_statement] = STATE(24),
    [sym_labeled_statement] = STATE(250),
    [sym_expression_statement] = STATE(250),
    [sym_if_statement] = STATE(250),
    [sym_switch_statement] = STATE(250),
    [sym_case_statement] = STATE(250),
    [sym_while_statement] = STATE(250),
    [sym_do_statement] = STATE(250),
    [sym_for_statement] = STATE(250),
    [sym_return_statement] = STATE(250),
    [sym_break_statement] = STATE(250),
    [sym_continue_statement] = STATE(250),
    [sym_goto_statement] = STATE(250),
    [sym_seh_try_statement] = STATE(250),
    [sym_seh_leave_statement] = STATE(250),
    [sym_expression] = STATE(1071),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1906),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym__empty_declaration] = STATE(24),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym_preproc_if_repeat1] = STATE(24),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(349),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [sym_identifier] = ACTIONS(358),
    [aux_sym_preproc_include_token1] = ACTIONS(360),
    [aux_sym_preproc_def_token1] = ACTIONS(362),
    [aux_sym_preproc_if_token1] = ACTIONS(364),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(366),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(366),
    [sym_preproc_directive] = ACTIONS(368),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(370),
    [anon_sym___extension__] = ACTIONS(372),
    [anon_sym_typedef] = ACTIONS(374),
    [anon_sym_extern] = ACTIONS(376),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(37),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym___cdecl] = ACTIONS(41),
    [anon_sym___clrcall] = ACTIONS(41),
    [anon_sym___stdcall] = ACTIONS(41),
    [anon_sym___fastcall] = ACTIONS(41),
    [anon_sym___thiscall] = ACTIONS(41),
    [anon_sym___vectorcall] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(378),
    [anon_sym_RBRACE] = ACTIONS(534),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(382),
    [anon_sym_switch] = ACTIONS(384),
    [anon_sym_case] = ACTIONS(386),
    [anon_sym_default] = ACTIONS(388),
    [anon_sym_while] = ACTIONS(390),
    [anon_sym_do] = ACTIONS(392),
    [anon_sym_for] = ACTIONS(394),
    [anon_sym_return] = ACTIONS(396),
    [anon_sym_break] = ACTIONS(398),
    [anon_sym_continue] = ACTIONS(400),
    [anon_sym_goto] = ACTIONS(402),
    [anon_sym___try] = ACTIONS(404),
    [anon_sym___leave] = ACTIONS(406),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(161),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(163),
    [sym_false] = ACTIONS(163),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [28] = {
    [sym__block_item] = STATE(24),
    [sym_preproc_include] = STATE(24),
    [sym_preproc_def] = STATE(24),
    [sym_preproc_function_def] = STATE(24),
    [sym_preproc_call] = STATE(24),
    [sym_preproc_if] = STATE(24),
    [sym_preproc_ifdef] = STATE(24),
    [sym_function_definition] = STATE(24),
    [sym__old_style_function_definition] = STATE(271),
    [sym_declaration] = STATE(24),
    [sym_type_definition] = STATE(24),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1138),
    [sym_linkage_specification] = STATE(24),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_ms_call_modifier] = STATE(694),
    [sym_compound_statement] = STATE(250),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(812),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(272),
    [sym_statement] = STATE(24),
    [sym_labeled_statement] = STATE(250),
    [sym_expression_statement] = STATE(250),
    [sym_if_statement] = STATE(250),
    [sym_switch_statement] = STATE(250),
    [sym_case_statement] = STATE(250),
    [sym_while_statement] = STATE(250),
    [sym_do_statement] = STATE(250),
    [sym_for_statement] = STATE(250),
    [sym_return_statement] = STATE(250),
    [sym_break_statement] = STATE(250),
    [sym_continue_statement] = STATE(250),
    [sym_goto_statement] = STATE(250),
    [sym_seh_try_statement] = STATE(250),
    [sym_seh_leave_statement] = STATE(250),
    [sym_expression] = STATE(1071),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1906),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym__empty_declaration] = STATE(24),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym_preproc_if_repeat1] = STATE(24),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(349),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [sym_identifier] = ACTIONS(358),
    [aux_sym_preproc_include_token1] = ACTIONS(360),
    [aux_sym_preproc_def_token1] = ACTIONS(362),
    [aux_sym_preproc_if_token1] = ACTIONS(364),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(366),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(366),
    [sym_preproc_directive] = ACTIONS(368),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(370),
    [anon_sym___extension__] = ACTIONS(372),
    [anon_sym_typedef] = ACTIONS(374),
    [anon_sym_extern] = ACTIONS(376),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(37),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym___cdecl] = ACTIONS(41),
    [anon_sym___clrcall] = ACTIONS(41),
    [anon_sym___stdcall] = ACTIONS(41),
    [anon_sym___fastcall] = ACTIONS(41),
    [anon_sym___thiscall] = ACTIONS(41),
    [anon_sym___vectorcall] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(378),
    [anon_sym_RBRACE] = ACTIONS(536),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(382),
    [anon_sym_switch] = ACTIONS(384),
    [anon_sym_case] = ACTIONS(386),
    [anon_sym_default] = ACTIONS(388),
    [anon_sym_while] = ACTIONS(390),
    [anon_sym_do] = ACTIONS(392),
    [anon_sym_for] = ACTIONS(394),
    [anon_sym_return] = ACTIONS(396),
    [anon_sym_break] = ACTIONS(398),
    [anon_sym_continue] = ACTIONS(400),
    [anon_sym_goto] = ACTIONS(402),
    [anon_sym___try] = ACTIONS(404),
    [anon_sym___leave] = ACTIONS(406),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(161),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(163),
    [sym_false] = ACTIONS(163),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [29] = {
    [sym__block_item] = STATE(24),
    [sym_preproc_include] = STATE(24),
    [sym_preproc_def] = STATE(24),
    [sym_preproc_function_def] = STATE(24),
    [sym_preproc_call] = STATE(24),
    [sym_preproc_if] = STATE(24),
    [sym_preproc_ifdef] = STATE(24),
    [sym_function_definition] = STATE(24),
    [sym__old_style_function_definition] = STATE(271),
    [sym_declaration] = STATE(24),
    [sym_type_definition] = STATE(24),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1138),
    [sym_linkage_specification] = STATE(24),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_ms_call_modifier] = STATE(694),
    [sym_compound_statement] = STATE(250),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(812),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(272),
    [sym_statement] = STATE(24),
    [sym_labeled_statement] = STATE(250),
    [sym_expression_statement] = STATE(250),
    [sym_if_statement] = STATE(250),
    [sym_switch_statement] = STATE(250),
    [sym_case_statement] = STATE(250),
    [sym_while_statement] = STATE(250),
    [sym_do_statement] = STATE(250),
    [sym_for_statement] = STATE(250),
    [sym_return_statement] = STATE(250),
    [sym_break_statement] = STATE(250),
    [sym_continue_statement] = STATE(250),
    [sym_goto_statement] = STATE(250),
    [sym_seh_try_statement] = STATE(250),
    [sym_seh_leave_statement] = STATE(250),
    [sym_expression] = STATE(1071),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1906),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym__empty_declaration] = STATE(24),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym_preproc_if_repeat1] = STATE(24),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(349),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [sym_identifier] = ACTIONS(358),
    [aux_sym_preproc_include_token1] = ACTIONS(360),
    [aux_sym_preproc_def_token1] = ACTIONS(362),
    [aux_sym_preproc_if_token1] = ACTIONS(364),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(366),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(366),
    [sym_preproc_directive] = ACTIONS(368),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(370),
    [anon_sym___extension__] = ACTIONS(372),
    [anon_sym_typedef] = ACTIONS(374),
    [anon_sym_extern] = ACTIONS(376),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(37),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym___cdecl] = ACTIONS(41),
    [anon_sym___clrcall] = ACTIONS(41),
    [anon_sym___stdcall] = ACTIONS(41),
    [anon_sym___fastcall] = ACTIONS(41),
    [anon_sym___thiscall] = ACTIONS(41),
    [anon_sym___vectorcall] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(378),
    [anon_sym_RBRACE] = ACTIONS(538),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(382),
    [anon_sym_switch] = ACTIONS(384),
    [anon_sym_case] = ACTIONS(386),
    [anon_sym_default] = ACTIONS(388),
    [anon_sym_while] = ACTIONS(390),
    [anon_sym_do] = ACTIONS(392),
    [anon_sym_for] = ACTIONS(394),
    [anon_sym_return] = ACTIONS(396),
    [anon_sym_break] = ACTIONS(398),
    [anon_sym_continue] = ACTIONS(400),
    [anon_sym_goto] = ACTIONS(402),
    [anon_sym___try] = ACTIONS(404),
    [anon_sym___leave] = ACTIONS(406),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(161),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(163),
    [sym_false] = ACTIONS(163),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [30] = {
    [sym__block_item] = STATE(32),
    [sym_preproc_include] = STATE(32),
    [sym_preproc_def] = STATE(32),
    [sym_preproc_function_def] = STATE(32),
    [sym_preproc_call] = STATE(32),
    [sym_preproc_if] = STATE(32),
    [sym_preproc_ifdef] = STATE(32),
    [sym_function_definition] = STATE(32),
    [sym__old_style_function_definition] = STATE(271),
    [sym_declaration] = STATE(32),
    [sym_type_definition] = STATE(32),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1138),
    [sym_linkage_specification] = STATE(32),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_ms_call_modifier] = STATE(694),
    [sym_compound_statement] = STATE(250),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(812),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(272),
    [sym_statement] = STATE(32),
    [sym_labeled_statement] = STATE(250),
    [sym_expression_statement] = STATE(250),
    [sym_if_statement] = STATE(250),
    [sym_switch_statement] = STATE(250),
    [sym_case_statement] = STATE(250),
    [sym_while_statement] = STATE(250),
    [sym_do_statement] = STATE(250),
    [sym_for_statement] = STATE(250),
    [sym_return_statement] = STATE(250),
    [sym_break_statement] = STATE(250),
    [sym_continue_statement] = STATE(250),
    [sym_goto_statement] = STATE(250),
    [sym_seh_try_statement] = STATE(250),
    [sym_seh_leave_statement] = STATE(250),
    [sym_expression] = STATE(1071),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1906),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym__empty_declaration] = STATE(32),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym_preproc_if_repeat1] = STATE(32),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(349),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [sym_identifier] = ACTIONS(358),
    [aux_sym_preproc_include_token1] = ACTIONS(360),
    [aux_sym_preproc_def_token1] = ACTIONS(362),
    [aux_sym_preproc_if_token1] = ACTIONS(364),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(366),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(366),
    [sym_preproc_directive] = ACTIONS(368),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(370),
    [anon_sym___extension__] = ACTIONS(372),
    [anon_sym_typedef] = ACTIONS(374),
    [anon_sym_extern] = ACTIONS(376),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(37),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym___cdecl] = ACTIONS(41),
    [anon_sym___clrcall] = ACTIONS(41),
    [anon_sym___stdcall] = ACTIONS(41),
    [anon_sym___fastcall] = ACTIONS(41),
    [anon_sym___thiscall] = ACTIONS(41),
    [anon_sym___vectorcall] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(378),
    [anon_sym_RBRACE] = ACTIONS(540),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(382),
    [anon_sym_switch] = ACTIONS(384),
    [anon_sym_case] = ACTIONS(386),
    [anon_sym_default] = ACTIONS(388),
    [anon_sym_while] = ACTIONS(390),
    [anon_sym_do] = ACTIONS(392),
    [anon_sym_for] = ACTIONS(394),
    [anon_sym_return] = ACTIONS(396),
    [anon_sym_break] = ACTIONS(398),
    [anon_sym_continue] = ACTIONS(400),
    [anon_sym_goto] = ACTIONS(402),
    [anon_sym___try] = ACTIONS(404),
    [anon_sym___leave] = ACTIONS(406),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(161),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(163),
    [sym_false] = ACTIONS(163),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [31] = {
    [sym__block_item] = STATE(24),
    [sym_preproc_include] = STATE(24),
    [sym_preproc_def] = STATE(24),
    [sym_preproc_function_def] = STATE(24),
    [sym_preproc_call] = STATE(24),
    [sym_preproc_if] = STATE(24),
    [sym_preproc_ifdef] = STATE(24),
    [sym_function_definition] = STATE(24),
    [sym__old_style_function_definition] = STATE(271),
    [sym_declaration] = STATE(24),
    [sym_type_definition] = STATE(24),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1138),
    [sym_linkage_specification] = STATE(24),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_ms_call_modifier] = STATE(694),
    [sym_compound_statement] = STATE(250),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(812),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(272),
    [sym_statement] = STATE(24),
    [sym_labeled_statement] = STATE(250),
    [sym_expression_statement] = STATE(250),
    [sym_if_statement] = STATE(250),
    [sym_switch_statement] = STATE(250),
    [sym_case_statement] = STATE(250),
    [sym_while_statement] = STATE(250),
    [sym_do_statement] = STATE(250),
    [sym_for_statement] = STATE(250),
    [sym_return_statement] = STATE(250),
    [sym_break_statement] = STATE(250),
    [sym_continue_statement] = STATE(250),
    [sym_goto_statement] = STATE(250),
    [sym_seh_try_statement] = STATE(250),
    [sym_seh_leave_statement] = STATE(250),
    [sym_expression] = STATE(1071),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1906),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym__empty_declaration] = STATE(24),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym_preproc_if_repeat1] = STATE(24),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(349),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [sym_identifier] = ACTIONS(358),
    [aux_sym_preproc_include_token1] = ACTIONS(360),
    [aux_sym_preproc_def_token1] = ACTIONS(362),
    [aux_sym_preproc_if_token1] = ACTIONS(364),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(366),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(366),
    [sym_preproc_directive] = ACTIONS(368),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(370),
    [anon_sym___extension__] = ACTIONS(372),
    [anon_sym_typedef] = ACTIONS(374),
    [anon_sym_extern] = ACTIONS(376),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(37),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym___cdecl] = ACTIONS(41),
    [anon_sym___clrcall] = ACTIONS(41),
    [anon_sym___stdcall] = ACTIONS(41),
    [anon_sym___fastcall] = ACTIONS(41),
    [anon_sym___thiscall] = ACTIONS(41),
    [anon_sym___vectorcall] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(378),
    [anon_sym_RBRACE] = ACTIONS(542),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(382),
    [anon_sym_switch] = ACTIONS(384),
    [anon_sym_case] = ACTIONS(386),
    [anon_sym_default] = ACTIONS(388),
    [anon_sym_while] = ACTIONS(390),
    [anon_sym_do] = ACTIONS(392),
    [anon_sym_for] = ACTIONS(394),
    [anon_sym_return] = ACTIONS(396),
    [anon_sym_break] = ACTIONS(398),
    [anon_sym_continue] = ACTIONS(400),
    [anon_sym_goto] = ACTIONS(402),
    [anon_sym___try] = ACTIONS(404),
    [anon_sym___leave] = ACTIONS(406),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(161),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(163),
    [sym_false] = ACTIONS(163),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [32] = {
    [sym__block_item] = STATE(24),
    [sym_preproc_include] = STATE(24),
    [sym_preproc_def] = STATE(24),
    [sym_preproc_function_def] = STATE(24),
    [sym_preproc_call] = STATE(24),
    [sym_preproc_if] = STATE(24),
    [sym_preproc_ifdef] = STATE(24),
    [sym_function_definition] = STATE(24),
    [sym__old_style_function_definition] = STATE(271),
    [sym_declaration] = STATE(24),
    [sym_type_definition] = STATE(24),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1138),
    [sym_linkage_specification] = STATE(24),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_ms_call_modifier] = STATE(694),
    [sym_compound_statement] = STATE(250),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(812),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(272),
    [sym_statement] = STATE(24),
    [sym_labeled_statement] = STATE(250),
    [sym_expression_statement] = STATE(250),
    [sym_if_statement] = STATE(250),
    [sym_switch_statement] = STATE(250),
    [sym_case_statement] = STATE(250),
    [sym_while_statement] = STATE(250),
    [sym_do_statement] = STATE(250),
    [sym_for_statement] = STATE(250),
    [sym_return_statement] = STATE(250),
    [sym_break_statement] = STATE(250),
    [sym_continue_statement] = STATE(250),
    [sym_goto_statement] = STATE(250),
    [sym_seh_try_statement] = STATE(250),
    [sym_seh_leave_statement] = STATE(250),
    [sym_expression] = STATE(1071),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1906),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym__empty_declaration] = STATE(24),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym_preproc_if_repeat1] = STATE(24),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(349),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [sym_identifier] = ACTIONS(358),
    [aux_sym_preproc_include_token1] = ACTIONS(360),
    [aux_sym_preproc_def_token1] = ACTIONS(362),
    [aux_sym_preproc_if_token1] = ACTIONS(364),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(366),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(366),
    [sym_preproc_directive] = ACTIONS(368),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(370),
    [anon_sym___extension__] = ACTIONS(372),
    [anon_sym_typedef] = ACTIONS(374),
    [anon_sym_extern] = ACTIONS(376),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(37),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym___cdecl] = ACTIONS(41),
    [anon_sym___clrcall] = ACTIONS(41),
    [anon_sym___stdcall] = ACTIONS(41),
    [anon_sym___fastcall] = ACTIONS(41),
    [anon_sym___thiscall] = ACTIONS(41),
    [anon_sym___vectorcall] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(378),
    [anon_sym_RBRACE] = ACTIONS(544),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(382),
    [anon_sym_switch] = ACTIONS(384),
    [anon_sym_case] = ACTIONS(386),
    [anon_sym_default] = ACTIONS(388),
    [anon_sym_while] = ACTIONS(390),
    [anon_sym_do] = ACTIONS(392),
    [anon_sym_for] = ACTIONS(394),
    [anon_sym_return] = ACTIONS(396),
    [anon_sym_break] = ACTIONS(398),
    [anon_sym_continue] = ACTIONS(400),
    [anon_sym_goto] = ACTIONS(402),
    [anon_sym___try] = ACTIONS(404),
    [anon_sym___leave] = ACTIONS(406),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(161),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(163),
    [sym_false] = ACTIONS(163),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [33] = {
    [sym__block_item] = STATE(28),
    [sym_preproc_include] = STATE(28),
    [sym_preproc_def] = STATE(28),
    [sym_preproc_function_def] = STATE(28),
    [sym_preproc_call] = STATE(28),
    [sym_preproc_if] = STATE(28),
    [sym_preproc_ifdef] = STATE(28),
    [sym_function_definition] = STATE(28),
    [sym__old_style_function_definition] = STATE(271),
    [sym_declaration] = STATE(28),
    [sym_type_definition] = STATE(28),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1138),
    [sym_linkage_specification] = STATE(28),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_ms_call_modifier] = STATE(694),
    [sym_compound_statement] = STATE(250),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(812),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(272),
    [sym_statement] = STATE(28),
    [sym_labeled_statement] = STATE(250),
    [sym_expression_statement] = STATE(250),
    [sym_if_statement] = STATE(250),
    [sym_switch_statement] = STATE(250),
    [sym_case_statement] = STATE(250),
    [sym_while_statement] = STATE(250),
    [sym_do_statement] = STATE(250),
    [sym_for_statement] = STATE(250),
    [sym_return_statement] = STATE(250),
    [sym_break_statement] = STATE(250),
    [sym_continue_statement] = STATE(250),
    [sym_goto_statement] = STATE(250),
    [sym_seh_try_statement] = STATE(250),
    [sym_seh_leave_statement] = STATE(250),
    [sym_expression] = STATE(1071),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1906),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym__empty_declaration] = STATE(28),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym_preproc_if_repeat1] = STATE(28),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(349),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [sym_identifier] = ACTIONS(358),
    [aux_sym_preproc_include_token1] = ACTIONS(360),
    [aux_sym_preproc_def_token1] = ACTIONS(362),
    [aux_sym_preproc_if_token1] = ACTIONS(364),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(366),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(366),
    [sym_preproc_directive] = ACTIONS(368),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(370),
    [anon_sym___extension__] = ACTIONS(372),
    [anon_sym_typedef] = ACTIONS(374),
    [anon_sym_extern] = ACTIONS(376),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(37),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym___cdecl] = ACTIONS(41),
    [anon_sym___clrcall] = ACTIONS(41),
    [anon_sym___stdcall] = ACTIONS(41),
    [anon_sym___fastcall] = ACTIONS(41),
    [anon_sym___thiscall] = ACTIONS(41),
    [anon_sym___vectorcall] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(378),
    [anon_sym_RBRACE] = ACTIONS(546),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(382),
    [anon_sym_switch] = ACTIONS(384),
    [anon_sym_case] = ACTIONS(386),
    [anon_sym_default] = ACTIONS(388),
    [anon_sym_while] = ACTIONS(390),
    [anon_sym_do] = ACTIONS(392),
    [anon_sym_for] = ACTIONS(394),
    [anon_sym_return] = ACTIONS(396),
    [anon_sym_break] = ACTIONS(398),
    [anon_sym_continue] = ACTIONS(400),
    [anon_sym_goto] = ACTIONS(402),
    [anon_sym___try] = ACTIONS(404),
    [anon_sym___leave] = ACTIONS(406),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(161),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(163),
    [sym_false] = ACTIONS(163),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [34] = {
    [sym__block_item] = STATE(29),
    [sym_preproc_include] = STATE(29),
    [sym_preproc_def] = STATE(29),
    [sym_preproc_function_def] = STATE(29),
    [sym_preproc_call] = STATE(29),
    [sym_preproc_if] = STATE(29),
    [sym_preproc_ifdef] = STATE(29),
    [sym_function_definition] = STATE(29),
    [sym__old_style_function_definition] = STATE(271),
    [sym_declaration] = STATE(29),
    [sym_type_definition] = STATE(29),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1138),
    [sym_linkage_specification] = STATE(29),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_ms_call_modifier] = STATE(694),
    [sym_compound_statement] = STATE(250),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(812),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(272),
    [sym_statement] = STATE(29),
    [sym_labeled_statement] = STATE(250),
    [sym_expression_statement] = STATE(250),
    [sym_if_statement] = STATE(250),
    [sym_switch_statement] = STATE(250),
    [sym_case_statement] = STATE(250),
    [sym_while_statement] = STATE(250),
    [sym_do_statement] = STATE(250),
    [sym_for_statement] = STATE(250),
    [sym_return_statement] = STATE(250),
    [sym_break_statement] = STATE(250),
    [sym_continue_statement] = STATE(250),
    [sym_goto_statement] = STATE(250),
    [sym_seh_try_statement] = STATE(250),
    [sym_seh_leave_statement] = STATE(250),
    [sym_expression] = STATE(1071),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1906),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym__empty_declaration] = STATE(29),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym_preproc_if_repeat1] = STATE(29),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(349),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [sym_identifier] = ACTIONS(358),
    [aux_sym_preproc_include_token1] = ACTIONS(360),
    [aux_sym_preproc_def_token1] = ACTIONS(362),
    [aux_sym_preproc_if_token1] = ACTIONS(364),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(366),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(366),
    [sym_preproc_directive] = ACTIONS(368),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(370),
    [anon_sym___extension__] = ACTIONS(372),
    [anon_sym_typedef] = ACTIONS(374),
    [anon_sym_extern] = ACTIONS(376),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(37),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym___cdecl] = ACTIONS(41),
    [anon_sym___clrcall] = ACTIONS(41),
    [anon_sym___stdcall] = ACTIONS(41),
    [anon_sym___fastcall] = ACTIONS(41),
    [anon_sym___thiscall] = ACTIONS(41),
    [anon_sym___vectorcall] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(378),
    [anon_sym_RBRACE] = ACTIONS(548),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(382),
    [anon_sym_switch] = ACTIONS(384),
    [anon_sym_case] = ACTIONS(386),
    [anon_sym_default] = ACTIONS(388),
    [anon_sym_while] = ACTIONS(390),
    [anon_sym_do] = ACTIONS(392),
    [anon_sym_for] = ACTIONS(394),
    [anon_sym_return] = ACTIONS(396),
    [anon_sym_break] = ACTIONS(398),
    [anon_sym_continue] = ACTIONS(400),
    [anon_sym_goto] = ACTIONS(402),
    [anon_sym___try] = ACTIONS(404),
    [anon_sym___leave] = ACTIONS(406),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(161),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(163),
    [sym_false] = ACTIONS(163),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [35] = {
    [sym__block_item] = STATE(26),
    [sym_preproc_include] = STATE(26),
    [sym_preproc_def] = STATE(26),
    [sym_preproc_function_def] = STATE(26),
    [sym_preproc_call] = STATE(26),
    [sym_preproc_if] = STATE(26),
    [sym_preproc_ifdef] = STATE(26),
    [sym_function_definition] = STATE(26),
    [sym__old_style_function_definition] = STATE(286),
    [sym_declaration] = STATE(26),
    [sym_type_definition] = STATE(26),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1139),
    [sym_linkage_specification] = STATE(26),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_ms_call_modifier] = STATE(697),
    [sym_compound_statement] = STATE(180),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(798),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(287),
    [sym_statement] = STATE(26),
    [sym_labeled_statement] = STATE(180),
    [sym_expression_statement] = STATE(180),
    [sym_if_statement] = STATE(180),
    [sym_switch_statement] = STATE(180),
    [sym_case_statement] = STATE(180),
    [sym_while_statement] = STATE(180),
    [sym_do_statement] = STATE(180),
    [sym_for_statement] = STATE(180),
    [sym_return_statement] = STATE(180),
    [sym_break_statement] = STATE(180),
    [sym_continue_statement] = STATE(180),
    [sym_goto_statement] = STATE(180),
    [sym_seh_try_statement] = STATE(180),
    [sym_seh_leave_statement] = STATE(180),
    [sym_expression] = STATE(1052),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1858),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym__empty_declaration] = STATE(26),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym_preproc_if_repeat1] = STATE(26),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(378),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [sym_identifier] = ACTIONS(484),
    [aux_sym_preproc_include_token1] = ACTIONS(486),
    [aux_sym_preproc_def_token1] = ACTIONS(488),
    [aux_sym_preproc_if_token1] = ACTIONS(490),
    [aux_sym_preproc_if_token2] = ACTIONS(550),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(494),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(494),
    [sym_preproc_directive] = ACTIONS(496),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(498),
    [anon_sym___extension__] = ACTIONS(500),
    [anon_sym_typedef] = ACTIONS(502),
    [anon_sym_extern] = ACTIONS(504),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(37),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym___cdecl] = ACTIONS(41),
    [anon_sym___clrcall] = ACTIONS(41),
    [anon_sym___stdcall] = ACTIONS(41),
    [anon_sym___fastcall] = ACTIONS(41),
    [anon_sym___thiscall] = ACTIONS(41),
    [anon_sym___vectorcall] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(506),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(508),
    [anon_sym_switch] = ACTIONS(510),
    [anon_sym_case] = ACTIONS(512),
    [anon_sym_default] = ACTIONS(514),
    [anon_sym_while] = ACTIONS(516),
    [anon_sym_do] = ACTIONS(518),
    [anon_sym_for] = ACTIONS(520),
    [anon_sym_return] = ACTIONS(522),
    [anon_sym_break] = ACTIONS(524),
    [anon_sym_continue] = ACTIONS(526),
    [anon_sym_goto] = ACTIONS(528),
    [anon_sym___try] = ACTIONS(530),
    [anon_sym___leave] = ACTIONS(532),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(161),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(163),
    [sym_false] = ACTIONS(163),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [36] = {
    [sym__block_item] = STATE(38),
    [sym_preproc_include] = STATE(38),
    [sym_preproc_def] = STATE(38),
    [sym_preproc_function_def] = STATE(38),
    [sym_preproc_call] = STATE(38),
    [sym_preproc_if] = STATE(38),
    [sym_preproc_ifdef] = STATE(38),
    [sym_function_definition] = STATE(38),
    [sym__old_style_function_definition] = STATE(271),
    [sym_declaration] = STATE(38),
    [sym_type_definition] = STATE(38),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1138),
    [sym_linkage_specification] = STATE(38),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_ms_call_modifier] = STATE(694),
    [sym_compound_statement] = STATE(250),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(812),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(272),
    [sym_statement] = STATE(38),
    [sym_labeled_statement] = STATE(250),
    [sym_expression_statement] = STATE(250),
    [sym_if_statement] = STATE(250),
    [sym_switch_statement] = STATE(250),
    [sym_case_statement] = STATE(250),
    [sym_while_statement] = STATE(250),
    [sym_do_statement] = STATE(250),
    [sym_for_statement] = STATE(250),
    [sym_return_statement] = STATE(250),
    [sym_break_statement] = STATE(250),
    [sym_continue_statement] = STATE(250),
    [sym_goto_statement] = STATE(250),
    [sym_seh_try_statement] = STATE(250),
    [sym_seh_leave_statement] = STATE(250),
    [sym_expression] = STATE(1071),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1906),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym__empty_declaration] = STATE(38),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym_preproc_if_repeat1] = STATE(38),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(349),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [sym_identifier] = ACTIONS(358),
    [aux_sym_preproc_include_token1] = ACTIONS(360),
    [aux_sym_preproc_def_token1] = ACTIONS(362),
    [aux_sym_preproc_if_token1] = ACTIONS(364),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(366),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(366),
    [sym_preproc_directive] = ACTIONS(368),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(370),
    [anon_sym___extension__] = ACTIONS(372),
    [anon_sym_typedef] = ACTIONS(374),
    [anon_sym_extern] = ACTIONS(376),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(37),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym___cdecl] = ACTIONS(41),
    [anon_sym___clrcall] = ACTIONS(41),
    [anon_sym___stdcall] = ACTIONS(41),
    [anon_sym___fastcall] = ACTIONS(41),
    [anon_sym___thiscall] = ACTIONS(41),
    [anon_sym___vectorcall] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(378),
    [anon_sym_RBRACE] = ACTIONS(552),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(382),
    [anon_sym_switch] = ACTIONS(384),
    [anon_sym_case] = ACTIONS(386),
    [anon_sym_default] = ACTIONS(388),
    [anon_sym_while] = ACTIONS(390),
    [anon_sym_do] = ACTIONS(392),
    [anon_sym_for] = ACTIONS(394),
    [anon_sym_return] = ACTIONS(396),
    [anon_sym_break] = ACTIONS(398),
    [anon_sym_continue] = ACTIONS(400),
    [anon_sym_goto] = ACTIONS(402),
    [anon_sym___try] = ACTIONS(404),
    [anon_sym___leave] = ACTIONS(406),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(161),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(163),
    [sym_false] = ACTIONS(163),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [37] = {
    [sym__block_item] = STATE(42),
    [sym_preproc_include] = STATE(42),
    [sym_preproc_def] = STATE(42),
    [sym_preproc_function_def] = STATE(42),
    [sym_preproc_call] = STATE(42),
    [sym_preproc_if] = STATE(42),
    [sym_preproc_ifdef] = STATE(42),
    [sym_function_definition] = STATE(42),
    [sym__old_style_function_definition] = STATE(271),
    [sym_declaration] = STATE(42),
    [sym_type_definition] = STATE(42),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1138),
    [sym_linkage_specification] = STATE(42),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_ms_call_modifier] = STATE(694),
    [sym_compound_statement] = STATE(250),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(812),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(272),
    [sym_statement] = STATE(42),
    [sym_labeled_statement] = STATE(250),
    [sym_expression_statement] = STATE(250),
    [sym_if_statement] = STATE(250),
    [sym_switch_statement] = STATE(250),
    [sym_case_statement] = STATE(250),
    [sym_while_statement] = STATE(250),
    [sym_do_statement] = STATE(250),
    [sym_for_statement] = STATE(250),
    [sym_return_statement] = STATE(250),
    [sym_break_statement] = STATE(250),
    [sym_continue_statement] = STATE(250),
    [sym_goto_statement] = STATE(250),
    [sym_seh_try_statement] = STATE(250),
    [sym_seh_leave_statement] = STATE(250),
    [sym_expression] = STATE(1071),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1906),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym__empty_declaration] = STATE(42),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym_preproc_if_repeat1] = STATE(42),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(349),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [sym_identifier] = ACTIONS(358),
    [aux_sym_preproc_include_token1] = ACTIONS(360),
    [aux_sym_preproc_def_token1] = ACTIONS(362),
    [aux_sym_preproc_if_token1] = ACTIONS(364),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(366),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(366),
    [sym_preproc_directive] = ACTIONS(368),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(370),
    [anon_sym___extension__] = ACTIONS(372),
    [anon_sym_typedef] = ACTIONS(374),
    [anon_sym_extern] = ACTIONS(376),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(37),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym___cdecl] = ACTIONS(41),
    [anon_sym___clrcall] = ACTIONS(41),
    [anon_sym___stdcall] = ACTIONS(41),
    [anon_sym___fastcall] = ACTIONS(41),
    [anon_sym___thiscall] = ACTIONS(41),
    [anon_sym___vectorcall] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(378),
    [anon_sym_RBRACE] = ACTIONS(554),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(382),
    [anon_sym_switch] = ACTIONS(384),
    [anon_sym_case] = ACTIONS(386),
    [anon_sym_default] = ACTIONS(388),
    [anon_sym_while] = ACTIONS(390),
    [anon_sym_do] = ACTIONS(392),
    [anon_sym_for] = ACTIONS(394),
    [anon_sym_return] = ACTIONS(396),
    [anon_sym_break] = ACTIONS(398),
    [anon_sym_continue] = ACTIONS(400),
    [anon_sym_goto] = ACTIONS(402),
    [anon_sym___try] = ACTIONS(404),
    [anon_sym___leave] = ACTIONS(406),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(161),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(163),
    [sym_false] = ACTIONS(163),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [38] = {
    [sym__block_item] = STATE(24),
    [sym_preproc_include] = STATE(24),
    [sym_preproc_def] = STATE(24),
    [sym_preproc_function_def] = STATE(24),
    [sym_preproc_call] = STATE(24),
    [sym_preproc_if] = STATE(24),
    [sym_preproc_ifdef] = STATE(24),
    [sym_function_definition] = STATE(24),
    [sym__old_style_function_definition] = STATE(271),
    [sym_declaration] = STATE(24),
    [sym_type_definition] = STATE(24),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1138),
    [sym_linkage_specification] = STATE(24),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_ms_call_modifier] = STATE(694),
    [sym_compound_statement] = STATE(250),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(812),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(272),
    [sym_statement] = STATE(24),
    [sym_labeled_statement] = STATE(250),
    [sym_expression_statement] = STATE(250),
    [sym_if_statement] = STATE(250),
    [sym_switch_statement] = STATE(250),
    [sym_case_statement] = STATE(250),
    [sym_while_statement] = STATE(250),
    [sym_do_statement] = STATE(250),
    [sym_for_statement] = STATE(250),
    [sym_return_statement] = STATE(250),
    [sym_break_statement] = STATE(250),
    [sym_continue_statement] = STATE(250),
    [sym_goto_statement] = STATE(250),
    [sym_seh_try_statement] = STATE(250),
    [sym_seh_leave_statement] = STATE(250),
    [sym_expression] = STATE(1071),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1906),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym__empty_declaration] = STATE(24),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym_preproc_if_repeat1] = STATE(24),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(349),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [sym_identifier] = ACTIONS(358),
    [aux_sym_preproc_include_token1] = ACTIONS(360),
    [aux_sym_preproc_def_token1] = ACTIONS(362),
    [aux_sym_preproc_if_token1] = ACTIONS(364),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(366),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(366),
    [sym_preproc_directive] = ACTIONS(368),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(370),
    [anon_sym___extension__] = ACTIONS(372),
    [anon_sym_typedef] = ACTIONS(374),
    [anon_sym_extern] = ACTIONS(376),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(37),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym___cdecl] = ACTIONS(41),
    [anon_sym___clrcall] = ACTIONS(41),
    [anon_sym___stdcall] = ACTIONS(41),
    [anon_sym___fastcall] = ACTIONS(41),
    [anon_sym___thiscall] = ACTIONS(41),
    [anon_sym___vectorcall] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(378),
    [anon_sym_RBRACE] = ACTIONS(556),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(382),
    [anon_sym_switch] = ACTIONS(384),
    [anon_sym_case] = ACTIONS(386),
    [anon_sym_default] = ACTIONS(388),
    [anon_sym_while] = ACTIONS(390),
    [anon_sym_do] = ACTIONS(392),
    [anon_sym_for] = ACTIONS(394),
    [anon_sym_return] = ACTIONS(396),
    [anon_sym_break] = ACTIONS(398),
    [anon_sym_continue] = ACTIONS(400),
    [anon_sym_goto] = ACTIONS(402),
    [anon_sym___try] = ACTIONS(404),
    [anon_sym___leave] = ACTIONS(406),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(161),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(163),
    [sym_false] = ACTIONS(163),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [39] = {
    [sym__block_item] = STATE(41),
    [sym_preproc_include] = STATE(41),
    [sym_preproc_def] = STATE(41),
    [sym_preproc_function_def] = STATE(41),
    [sym_preproc_call] = STATE(41),
    [sym_preproc_if] = STATE(41),
    [sym_preproc_ifdef] = STATE(41),
    [sym_function_definition] = STATE(41),
    [sym__old_style_function_definition] = STATE(271),
    [sym_declaration] = STATE(41),
    [sym_type_definition] = STATE(41),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1138),
    [sym_linkage_specification] = STATE(41),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_ms_call_modifier] = STATE(694),
    [sym_compound_statement] = STATE(250),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(812),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(272),
    [sym_statement] = STATE(41),
    [sym_labeled_statement] = STATE(250),
    [sym_expression_statement] = STATE(250),
    [sym_if_statement] = STATE(250),
    [sym_switch_statement] = STATE(250),
    [sym_case_statement] = STATE(250),
    [sym_while_statement] = STATE(250),
    [sym_do_statement] = STATE(250),
    [sym_for_statement] = STATE(250),
    [sym_return_statement] = STATE(250),
    [sym_break_statement] = STATE(250),
    [sym_continue_statement] = STATE(250),
    [sym_goto_statement] = STATE(250),
    [sym_seh_try_statement] = STATE(250),
    [sym_seh_leave_statement] = STATE(250),
    [sym_expression] = STATE(1071),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1906),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym__empty_declaration] = STATE(41),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym_preproc_if_repeat1] = STATE(41),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(349),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [sym_identifier] = ACTIONS(358),
    [aux_sym_preproc_include_token1] = ACTIONS(360),
    [aux_sym_preproc_def_token1] = ACTIONS(362),
    [aux_sym_preproc_if_token1] = ACTIONS(364),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(366),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(366),
    [sym_preproc_directive] = ACTIONS(368),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(370),
    [anon_sym___extension__] = ACTIONS(372),
    [anon_sym_typedef] = ACTIONS(374),
    [anon_sym_extern] = ACTIONS(376),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(37),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym___cdecl] = ACTIONS(41),
    [anon_sym___clrcall] = ACTIONS(41),
    [anon_sym___stdcall] = ACTIONS(41),
    [anon_sym___fastcall] = ACTIONS(41),
    [anon_sym___thiscall] = ACTIONS(41),
    [anon_sym___vectorcall] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(378),
    [anon_sym_RBRACE] = ACTIONS(558),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(382),
    [anon_sym_switch] = ACTIONS(384),
    [anon_sym_case] = ACTIONS(386),
    [anon_sym_default] = ACTIONS(388),
    [anon_sym_while] = ACTIONS(390),
    [anon_sym_do] = ACTIONS(392),
    [anon_sym_for] = ACTIONS(394),
    [anon_sym_return] = ACTIONS(396),
    [anon_sym_break] = ACTIONS(398),
    [anon_sym_continue] = ACTIONS(400),
    [anon_sym_goto] = ACTIONS(402),
    [anon_sym___try] = ACTIONS(404),
    [anon_sym___leave] = ACTIONS(406),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(161),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(163),
    [sym_false] = ACTIONS(163),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [40] = {
    [sym__block_item] = STATE(40),
    [sym_preproc_include] = STATE(40),
    [sym_preproc_def] = STATE(40),
    [sym_preproc_function_def] = STATE(40),
    [sym_preproc_call] = STATE(40),
    [sym_preproc_if] = STATE(40),
    [sym_preproc_ifdef] = STATE(40),
    [sym_function_definition] = STATE(40),
    [sym__old_style_function_definition] = STATE(286),
    [sym_declaration] = STATE(40),
    [sym_type_definition] = STATE(40),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1139),
    [sym_linkage_specification] = STATE(40),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_ms_call_modifier] = STATE(697),
    [sym_compound_statement] = STATE(180),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(798),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(287),
    [sym_statement] = STATE(40),
    [sym_labeled_statement] = STATE(180),
    [sym_expression_statement] = STATE(180),
    [sym_if_statement] = STATE(180),
    [sym_switch_statement] = STATE(180),
    [sym_case_statement] = STATE(180),
    [sym_while_statement] = STATE(180),
    [sym_do_statement] = STATE(180),
    [sym_for_statement] = STATE(180),
    [sym_return_statement] = STATE(180),
    [sym_break_statement] = STATE(180),
    [sym_continue_statement] = STATE(180),
    [sym_goto_statement] = STATE(180),
    [sym_seh_try_statement] = STATE(180),
    [sym_seh_leave_statement] = STATE(180),
    [sym_expression] = STATE(1052),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1858),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym__empty_declaration] = STATE(40),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym_preproc_if_repeat1] = STATE(40),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(378),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [sym_identifier] = ACTIONS(560),
    [aux_sym_preproc_include_token1] = ACTIONS(563),
    [aux_sym_preproc_def_token1] = ACTIONS(566),
    [aux_sym_preproc_if_token1] = ACTIONS(569),
    [aux_sym_preproc_if_token2] = ACTIONS(215),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(572),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(572),
    [sym_preproc_directive] = ACTIONS(575),
    [anon_sym_LPAREN2] = ACTIONS(223),
    [anon_sym_BANG] = ACTIONS(226),
    [anon_sym_TILDE] = ACTIONS(226),
    [anon_sym_DASH] = ACTIONS(229),
    [anon_sym_PLUS] = ACTIONS(229),
    [anon_sym_STAR] = ACTIONS(232),
    [anon_sym_AMP] = ACTIONS(232),
    [anon_sym_SEMI] = ACTIONS(578),
    [anon_sym___extension__] = ACTIONS(581),
    [anon_sym_typedef] = ACTIONS(584),
    [anon_sym_extern] = ACTIONS(587),
    [anon_sym___attribute__] = ACTIONS(247),
    [anon_sym___attribute] = ACTIONS(247),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(250),
    [anon_sym___declspec] = ACTIONS(253),
    [anon_sym___cdecl] = ACTIONS(256),
    [anon_sym___clrcall] = ACTIONS(256),
    [anon_sym___stdcall] = ACTIONS(256),
    [anon_sym___fastcall] = ACTIONS(256),
    [anon_sym___thiscall] = ACTIONS(256),
    [anon_sym___vectorcall] = ACTIONS(256),
    [anon_sym_LBRACE] = ACTIONS(590),
    [anon_sym_signed] = ACTIONS(262),
    [anon_sym_unsigned] = ACTIONS(262),
    [anon_sym_long] = ACTIONS(262),
    [anon_sym_short] = ACTIONS(262),
    [anon_sym_static] = ACTIONS(265),
    [anon_sym_auto] = ACTIONS(265),
    [anon_sym_register] = ACTIONS(265),
    [anon_sym_inline] = ACTIONS(265),
    [anon_sym___inline] = ACTIONS(265),
    [anon_sym___inline__] = ACTIONS(265),
    [anon_sym___forceinline] = ACTIONS(265),
    [anon_sym_thread_local] = ACTIONS(265),
    [anon_sym___thread] = ACTIONS(265),
    [anon_sym_const] = ACTIONS(268),
    [anon_sym_constexpr] = ACTIONS(268),
    [anon_sym_volatile] = ACTIONS(268),
    [anon_sym_restrict] = ACTIONS(268),
    [anon_sym___restrict__] = ACTIONS(268),
    [anon_sym__Atomic] = ACTIONS(268),
    [anon_sym__Noreturn] = ACTIONS(268),
    [anon_sym_noreturn] = ACTIONS(268),
    [anon_sym__Nonnull] = ACTIONS(268),
    [anon_sym_alignas] = ACTIONS(271),
    [anon_sym__Alignas] = ACTIONS(271),
    [sym_primitive_type] = ACTIONS(274),
    [anon_sym_enum] = ACTIONS(277),
    [anon_sym_struct] = ACTIONS(280),
    [anon_sym_union] = ACTIONS(283),
    [anon_sym_if] = ACTIONS(593),
    [anon_sym_switch] = ACTIONS(596),
    [anon_sym_case] = ACTIONS(599),
    [anon_sym_default] = ACTIONS(602),
    [anon_sym_while] = ACTIONS(605),
    [anon_sym_do] = ACTIONS(608),
    [anon_sym_for] = ACTIONS(611),
    [anon_sym_return] = ACTIONS(614),
    [anon_sym_break] = ACTIONS(617),
    [anon_sym_continue] = ACTIONS(620),
    [anon_sym_goto] = ACTIONS(623),
    [anon_sym___try] = ACTIONS(626),
    [anon_sym___leave] = ACTIONS(629),
    [anon_sym_DASH_DASH] = ACTIONS(325),
    [anon_sym_PLUS_PLUS] = ACTIONS(325),
    [anon_sym_sizeof] = ACTIONS(328),
    [anon_sym___alignof__] = ACTIONS(331),
    [anon_sym___alignof] = ACTIONS(331),
    [anon_sym__alignof] = ACTIONS(331),
    [anon_sym_alignof] = ACTIONS(331),
    [anon_sym__Alignof] = ACTIONS(331),
    [anon_sym_offsetof] = ACTIONS(334),
    [anon_sym__Generic] = ACTIONS(337),
    [anon_sym_asm] = ACTIONS(340),
    [anon_sym___asm__] = ACTIONS(340),
    [anon_sym___asm] = ACTIONS(340),
    [sym_number_literal] = ACTIONS(343),
    [anon_sym_L_SQUOTE] = ACTIONS(346),
    [anon_sym_u_SQUOTE] = ACTIONS(346),
    [anon_sym_U_SQUOTE] = ACTIONS(346),
    [anon_sym_u8_SQUOTE] = ACTIONS(346),
    [anon_sym_SQUOTE] = ACTIONS(346),
    [anon_sym_L_DQUOTE] = ACTIONS(349),
    [anon_sym_u_DQUOTE] = ACTIONS(349),
    [anon_sym_U_DQUOTE] = ACTIONS(349),
    [anon_sym_u8_DQUOTE] = ACTIONS(349),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [sym_true] = ACTIONS(352),
    [sym_false] = ACTIONS(352),
    [anon_sym_NULL] = ACTIONS(355),
    [anon_sym_nullptr] = ACTIONS(355),
    [sym_comment] = ACTIONS(3),
  },
  [41] = {
    [sym__block_item] = STATE(24),
    [sym_preproc_include] = STATE(24),
    [sym_preproc_def] = STATE(24),
    [sym_preproc_function_def] = STATE(24),
    [sym_preproc_call] = STATE(24),
    [sym_preproc_if] = STATE(24),
    [sym_preproc_ifdef] = STATE(24),
    [sym_function_definition] = STATE(24),
    [sym__old_style_function_definition] = STATE(271),
    [sym_declaration] = STATE(24),
    [sym_type_definition] = STATE(24),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1138),
    [sym_linkage_specification] = STATE(24),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_ms_call_modifier] = STATE(694),
    [sym_compound_statement] = STATE(250),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(812),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(272),
    [sym_statement] = STATE(24),
    [sym_labeled_statement] = STATE(250),
    [sym_expression_statement] = STATE(250),
    [sym_if_statement] = STATE(250),
    [sym_switch_statement] = STATE(250),
    [sym_case_statement] = STATE(250),
    [sym_while_statement] = STATE(250),
    [sym_do_statement] = STATE(250),
    [sym_for_statement] = STATE(250),
    [sym_return_statement] = STATE(250),
    [sym_break_statement] = STATE(250),
    [sym_continue_statement] = STATE(250),
    [sym_goto_statement] = STATE(250),
    [sym_seh_try_statement] = STATE(250),
    [sym_seh_leave_statement] = STATE(250),
    [sym_expression] = STATE(1071),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1906),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym__empty_declaration] = STATE(24),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym_preproc_if_repeat1] = STATE(24),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(349),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [sym_identifier] = ACTIONS(358),
    [aux_sym_preproc_include_token1] = ACTIONS(360),
    [aux_sym_preproc_def_token1] = ACTIONS(362),
    [aux_sym_preproc_if_token1] = ACTIONS(364),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(366),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(366),
    [sym_preproc_directive] = ACTIONS(368),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(370),
    [anon_sym___extension__] = ACTIONS(372),
    [anon_sym_typedef] = ACTIONS(374),
    [anon_sym_extern] = ACTIONS(376),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(37),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym___cdecl] = ACTIONS(41),
    [anon_sym___clrcall] = ACTIONS(41),
    [anon_sym___stdcall] = ACTIONS(41),
    [anon_sym___fastcall] = ACTIONS(41),
    [anon_sym___thiscall] = ACTIONS(41),
    [anon_sym___vectorcall] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(378),
    [anon_sym_RBRACE] = ACTIONS(632),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(382),
    [anon_sym_switch] = ACTIONS(384),
    [anon_sym_case] = ACTIONS(386),
    [anon_sym_default] = ACTIONS(388),
    [anon_sym_while] = ACTIONS(390),
    [anon_sym_do] = ACTIONS(392),
    [anon_sym_for] = ACTIONS(394),
    [anon_sym_return] = ACTIONS(396),
    [anon_sym_break] = ACTIONS(398),
    [anon_sym_continue] = ACTIONS(400),
    [anon_sym_goto] = ACTIONS(402),
    [anon_sym___try] = ACTIONS(404),
    [anon_sym___leave] = ACTIONS(406),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(161),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(163),
    [sym_false] = ACTIONS(163),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [42] = {
    [sym__block_item] = STATE(24),
    [sym_preproc_include] = STATE(24),
    [sym_preproc_def] = STATE(24),
    [sym_preproc_function_def] = STATE(24),
    [sym_preproc_call] = STATE(24),
    [sym_preproc_if] = STATE(24),
    [sym_preproc_ifdef] = STATE(24),
    [sym_function_definition] = STATE(24),
    [sym__old_style_function_definition] = STATE(271),
    [sym_declaration] = STATE(24),
    [sym_type_definition] = STATE(24),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1138),
    [sym_linkage_specification] = STATE(24),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_ms_call_modifier] = STATE(694),
    [sym_compound_statement] = STATE(250),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(812),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(272),
    [sym_statement] = STATE(24),
    [sym_labeled_statement] = STATE(250),
    [sym_expression_statement] = STATE(250),
    [sym_if_statement] = STATE(250),
    [sym_switch_statement] = STATE(250),
    [sym_case_statement] = STATE(250),
    [sym_while_statement] = STATE(250),
    [sym_do_statement] = STATE(250),
    [sym_for_statement] = STATE(250),
    [sym_return_statement] = STATE(250),
    [sym_break_statement] = STATE(250),
    [sym_continue_statement] = STATE(250),
    [sym_goto_statement] = STATE(250),
    [sym_seh_try_statement] = STATE(250),
    [sym_seh_leave_statement] = STATE(250),
    [sym_expression] = STATE(1071),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1906),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym__empty_declaration] = STATE(24),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym_preproc_if_repeat1] = STATE(24),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(349),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [sym_identifier] = ACTIONS(358),
    [aux_sym_preproc_include_token1] = ACTIONS(360),
    [aux_sym_preproc_def_token1] = ACTIONS(362),
    [aux_sym_preproc_if_token1] = ACTIONS(364),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(366),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(366),
    [sym_preproc_directive] = ACTIONS(368),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(370),
    [anon_sym___extension__] = ACTIONS(372),
    [anon_sym_typedef] = ACTIONS(374),
    [anon_sym_extern] = ACTIONS(376),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(37),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym___cdecl] = ACTIONS(41),
    [anon_sym___clrcall] = ACTIONS(41),
    [anon_sym___stdcall] = ACTIONS(41),
    [anon_sym___fastcall] = ACTIONS(41),
    [anon_sym___thiscall] = ACTIONS(41),
    [anon_sym___vectorcall] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(378),
    [anon_sym_RBRACE] = ACTIONS(634),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(382),
    [anon_sym_switch] = ACTIONS(384),
    [anon_sym_case] = ACTIONS(386),
    [anon_sym_default] = ACTIONS(388),
    [anon_sym_while] = ACTIONS(390),
    [anon_sym_do] = ACTIONS(392),
    [anon_sym_for] = ACTIONS(394),
    [anon_sym_return] = ACTIONS(396),
    [anon_sym_break] = ACTIONS(398),
    [anon_sym_continue] = ACTIONS(400),
    [anon_sym_goto] = ACTIONS(402),
    [anon_sym___try] = ACTIONS(404),
    [anon_sym___leave] = ACTIONS(406),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(161),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(163),
    [sym_false] = ACTIONS(163),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [43] = {
    [sym__top_level_item] = STATE(43),
    [sym_preproc_include] = STATE(43),
    [sym_preproc_def] = STATE(43),
    [sym_preproc_function_def] = STATE(43),
    [sym_preproc_call] = STATE(43),
    [sym_preproc_if] = STATE(43),
    [sym_preproc_ifdef] = STATE(43),
    [sym_function_definition] = STATE(43),
    [sym__old_style_function_definition] = STATE(338),
    [sym_declaration] = STATE(43),
    [sym_type_definition] = STATE(43),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1136),
    [sym_linkage_specification] = STATE(43),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_ms_call_modifier] = STATE(691),
    [sym_compound_statement] = STATE(43),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(800),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(362),
    [sym__top_level_statement] = STATE(43),
    [sym_labeled_statement] = STATE(43),
    [sym__top_level_expression_statement] = STATE(43),
    [sym_if_statement] = STATE(43),
    [sym_switch_statement] = STATE(43),
    [sym_case_statement] = STATE(43),
    [sym_while_statement] = STATE(43),
    [sym_do_statement] = STATE(43),
    [sym_for_statement] = STATE(43),
    [sym_return_statement] = STATE(43),
    [sym_break_statement] = STATE(43),
    [sym_continue_statement] = STATE(43),
    [sym_goto_statement] = STATE(43),
    [sym_expression] = STATE(1116),
    [sym__string] = STATE(1119),
    [sym_conditional_expression] = STATE(1119),
    [sym_assignment_expression] = STATE(1119),
    [sym_pointer_expression] = STATE(935),
    [sym_unary_expression] = STATE(1119),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(1119),
    [sym_cast_expression] = STATE(1119),
    [sym_sizeof_expression] = STATE(1119),
    [sym_alignof_expression] = STATE(1119),
    [sym_offsetof_expression] = STATE(1119),
    [sym_generic_expression] = STATE(1119),
    [sym_subscript_expression] = STATE(935),
    [sym_call_expression] = STATE(935),
    [sym_gnu_asm_expression] = STATE(1119),
    [sym_extension_expression] = STATE(1119),
    [sym_field_expression] = STATE(935),
    [sym_compound_literal_expression] = STATE(1119),
    [sym_parenthesized_expression] = STATE(935),
    [sym_char_literal] = STATE(1119),
    [sym_concatenated_string] = STATE(1119),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(1119),
    [sym__empty_declaration] = STATE(43),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym_translation_unit_repeat1] = STATE(43),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(375),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [ts_builtin_sym_end] = ACTIONS(636),
    [sym_identifier] = ACTIONS(638),
    [aux_sym_preproc_include_token1] = ACTIONS(641),
    [aux_sym_preproc_def_token1] = ACTIONS(644),
    [aux_sym_preproc_if_token1] = ACTIONS(647),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(650),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(650),
    [sym_preproc_directive] = ACTIONS(653),
    [anon_sym_LPAREN2] = ACTIONS(656),
    [anon_sym_BANG] = ACTIONS(659),
    [anon_sym_TILDE] = ACTIONS(659),
    [anon_sym_DASH] = ACTIONS(662),
    [anon_sym_PLUS] = ACTIONS(662),
    [anon_sym_STAR] = ACTIONS(665),
    [anon_sym_AMP] = ACTIONS(665),
    [anon_sym_SEMI] = ACTIONS(668),
    [anon_sym___extension__] = ACTIONS(671),
    [anon_sym_typedef] = ACTIONS(674),
    [anon_sym_extern] = ACTIONS(677),
    [anon_sym___attribute__] = ACTIONS(680),
    [anon_sym___attribute] = ACTIONS(680),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(683),
    [anon_sym___declspec] = ACTIONS(686),
    [anon_sym___cdecl] = ACTIONS(689),
    [anon_sym___clrcall] = ACTIONS(689),
    [anon_sym___stdcall] = ACTIONS(689),
    [anon_sym___fastcall] = ACTIONS(689),
    [anon_sym___thiscall] = ACTIONS(689),
    [anon_sym___vectorcall] = ACTIONS(689),
    [anon_sym_LBRACE] = ACTIONS(692),
    [anon_sym_signed] = ACTIONS(695),
    [anon_sym_unsigned] = ACTIONS(695),
    [anon_sym_long] = ACTIONS(695),
    [anon_sym_short] = ACTIONS(695),
    [anon_sym_static] = ACTIONS(698),
    [anon_sym_auto] = ACTIONS(698),
    [anon_sym_register] = ACTIONS(698),
    [anon_sym_inline] = ACTIONS(698),
    [anon_sym___inline] = ACTIONS(698),
    [anon_sym___inline__] = ACTIONS(698),
    [anon_sym___forceinline] = ACTIONS(698),
    [anon_sym_thread_local] = ACTIONS(698),
    [anon_sym___thread] = ACTIONS(698),
    [anon_sym_const] = ACTIONS(701),
    [anon_sym_constexpr] = ACTIONS(701),
    [anon_sym_volatile] = ACTIONS(701),
    [anon_sym_restrict] = ACTIONS(701),
    [anon_sym___restrict__] = ACTIONS(701),
    [anon_sym__Atomic] = ACTIONS(701),
    [anon_sym__Noreturn] = ACTIONS(701),
    [anon_sym_noreturn] = ACTIONS(701),
    [anon_sym__Nonnull] = ACTIONS(701),
    [anon_sym_alignas] = ACTIONS(704),
    [anon_sym__Alignas] = ACTIONS(704),
    [sym_primitive_type] = ACTIONS(707),
    [anon_sym_enum] = ACTIONS(710),
    [anon_sym_struct] = ACTIONS(713),
    [anon_sym_union] = ACTIONS(716),
    [anon_sym_if] = ACTIONS(719),
    [anon_sym_switch] = ACTIONS(722),
    [anon_sym_case] = ACTIONS(725),
    [anon_sym_default] = ACTIONS(728),
    [anon_sym_while] = ACTIONS(731),
    [anon_sym_do] = ACTIONS(734),
    [anon_sym_for] = ACTIONS(737),
    [anon_sym_return] = ACTIONS(740),
    [anon_sym_break] = ACTIONS(743),
    [anon_sym_continue] = ACTIONS(746),
    [anon_sym_goto] = ACTIONS(749),
    [anon_sym_DASH_DASH] = ACTIONS(752),
    [anon_sym_PLUS_PLUS] = ACTIONS(752),
    [anon_sym_sizeof] = ACTIONS(755),
    [anon_sym___alignof__] = ACTIONS(758),
    [anon_sym___alignof] = ACTIONS(758),
    [anon_sym__alignof] = ACTIONS(758),
    [anon_sym_alignof] = ACTIONS(758),
    [anon_sym__Alignof] = ACTIONS(758),
    [anon_sym_offsetof] = ACTIONS(761),
    [anon_sym__Generic] = ACTIONS(764),
    [anon_sym_asm] = ACTIONS(767),
    [anon_sym___asm__] = ACTIONS(767),
    [anon_sym___asm] = ACTIONS(767),
    [sym_number_literal] = ACTIONS(770),
    [anon_sym_L_SQUOTE] = ACTIONS(773),
    [anon_sym_u_SQUOTE] = ACTIONS(773),
    [anon_sym_U_SQUOTE] = ACTIONS(773),
    [anon_sym_u8_SQUOTE] = ACTIONS(773),
    [anon_sym_SQUOTE] = ACTIONS(773),
    [anon_sym_L_DQUOTE] = ACTIONS(776),
    [anon_sym_u_DQUOTE] = ACTIONS(776),
    [anon_sym_U_DQUOTE] = ACTIONS(776),
    [anon_sym_u8_DQUOTE] = ACTIONS(776),
    [anon_sym_DQUOTE] = ACTIONS(776),
    [sym_true] = ACTIONS(779),
    [sym_false] = ACTIONS(779),
    [anon_sym_NULL] = ACTIONS(782),
    [anon_sym_nullptr] = ACTIONS(782),
    [sym_comment] = ACTIONS(3),
  },
  [44] = {
    [sym__top_level_item] = STATE(43),
    [sym_preproc_include] = STATE(43),
    [sym_preproc_def] = STATE(43),
    [sym_preproc_function_def] = STATE(43),
    [sym_preproc_call] = STATE(43),
    [sym_preproc_if] = STATE(43),
    [sym_preproc_ifdef] = STATE(43),
    [sym_function_definition] = STATE(43),
    [sym__old_style_function_definition] = STATE(338),
    [sym_declaration] = STATE(43),
    [sym_type_definition] = STATE(43),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1136),
    [sym_linkage_specification] = STATE(43),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_ms_call_modifier] = STATE(691),
    [sym_compound_statement] = STATE(43),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(800),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(362),
    [sym__top_level_statement] = STATE(43),
    [sym_labeled_statement] = STATE(43),
    [sym__top_level_expression_statement] = STATE(43),
    [sym_if_statement] = STATE(43),
    [sym_switch_statement] = STATE(43),
    [sym_case_statement] = STATE(43),
    [sym_while_statement] = STATE(43),
    [sym_do_statement] = STATE(43),
    [sym_for_statement] = STATE(43),
    [sym_return_statement] = STATE(43),
    [sym_break_statement] = STATE(43),
    [sym_continue_statement] = STATE(43),
    [sym_goto_statement] = STATE(43),
    [sym_expression] = STATE(1116),
    [sym__string] = STATE(1119),
    [sym_conditional_expression] = STATE(1119),
    [sym_assignment_expression] = STATE(1119),
    [sym_pointer_expression] = STATE(935),
    [sym_unary_expression] = STATE(1119),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(1119),
    [sym_cast_expression] = STATE(1119),
    [sym_sizeof_expression] = STATE(1119),
    [sym_alignof_expression] = STATE(1119),
    [sym_offsetof_expression] = STATE(1119),
    [sym_generic_expression] = STATE(1119),
    [sym_subscript_expression] = STATE(935),
    [sym_call_expression] = STATE(935),
    [sym_gnu_asm_expression] = STATE(1119),
    [sym_extension_expression] = STATE(1119),
    [sym_field_expression] = STATE(935),
    [sym_compound_literal_expression] = STATE(1119),
    [sym_parenthesized_expression] = STATE(935),
    [sym_char_literal] = STATE(1119),
    [sym_concatenated_string] = STATE(1119),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(1119),
    [sym__empty_declaration] = STATE(43),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym_translation_unit_repeat1] = STATE(43),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(375),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [ts_builtin_sym_end] = ACTIONS(785),
    [sym_identifier] = ACTIONS(7),
    [aux_sym_preproc_include_token1] = ACTIONS(9),
    [aux_sym_preproc_def_token1] = ACTIONS(11),
    [aux_sym_preproc_if_token1] = ACTIONS(13),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(15),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(15),
    [sym_preproc_directive] = ACTIONS(17),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(27),
    [anon_sym___extension__] = ACTIONS(29),
    [anon_sym_typedef] = ACTIONS(31),
    [anon_sym_extern] = ACTIONS(33),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(37),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym___cdecl] = ACTIONS(41),
    [anon_sym___clrcall] = ACTIONS(41),
    [anon_sym___stdcall] = ACTIONS(41),
    [anon_sym___fastcall] = ACTIONS(41),
    [anon_sym___thiscall] = ACTIONS(41),
    [anon_sym___vectorcall] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(61),
    [anon_sym_switch] = ACTIONS(63),
    [anon_sym_case] = ACTIONS(65),
    [anon_sym_default] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(69),
    [anon_sym_do] = ACTIONS(71),
    [anon_sym_for] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_break] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(79),
    [anon_sym_goto] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(95),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(101),
    [sym_false] = ACTIONS(101),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [45] = {
    [sym_declaration] = STATE(47),
    [sym_type_definition] = STATE(47),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1149),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_compound_statement] = STATE(47),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(727),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(47),
    [sym_labeled_statement] = STATE(47),
    [sym_expression_statement] = STATE(47),
    [sym_if_statement] = STATE(47),
    [sym_switch_statement] = STATE(47),
    [sym_while_statement] = STATE(47),
    [sym_do_statement] = STATE(47),
    [sym_for_statement] = STATE(47),
    [sym_return_statement] = STATE(47),
    [sym_break_statement] = STATE(47),
    [sym_continue_statement] = STATE(47),
    [sym_goto_statement] = STATE(47),
    [sym_seh_try_statement] = STATE(47),
    [sym_seh_leave_statement] = STATE(47),
    [sym_expression] = STATE(1049),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1950),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(373),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [aux_sym_case_statement_repeat1] = STATE(47),
    [sym_identifier] = ACTIONS(787),
    [aux_sym_preproc_include_token1] = ACTIONS(789),
    [aux_sym_preproc_def_token1] = ACTIONS(789),
    [aux_sym_preproc_if_token1] = ACTIONS(789),
    [aux_sym_preproc_if_token2] = ACTIONS(789),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(789),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(789),
    [aux_sym_preproc_else_token1] = ACTIONS(789),
    [aux_sym_preproc_elif_token1] = ACTIONS(789),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(789),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(789),
    [sym_preproc_directive] = ACTIONS(789),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(125),
    [anon_sym___extension__] = ACTIONS(127),
    [anon_sym_typedef] = ACTIONS(129),
    [anon_sym_extern] = ACTIONS(47),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(37),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym___cdecl] = ACTIONS(789),
    [anon_sym___clrcall] = ACTIONS(789),
    [anon_sym___stdcall] = ACTIONS(789),
    [anon_sym___fastcall] = ACTIONS(789),
    [anon_sym___thiscall] = ACTIONS(789),
    [anon_sym___vectorcall] = ACTIONS(789),
    [anon_sym_LBRACE] = ACTIONS(133),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(135),
    [anon_sym_else] = ACTIONS(789),
    [anon_sym_switch] = ACTIONS(137),
    [anon_sym_case] = ACTIONS(789),
    [anon_sym_default] = ACTIONS(789),
    [anon_sym_while] = ACTIONS(143),
    [anon_sym_do] = ACTIONS(145),
    [anon_sym_for] = ACTIONS(147),
    [anon_sym_return] = ACTIONS(149),
    [anon_sym_break] = ACTIONS(151),
    [anon_sym_continue] = ACTIONS(153),
    [anon_sym_goto] = ACTIONS(155),
    [anon_sym___try] = ACTIONS(157),
    [anon_sym___leave] = ACTIONS(159),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(161),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(163),
    [sym_false] = ACTIONS(163),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [46] = {
    [sym_declaration] = STATE(48),
    [sym_type_definition] = STATE(48),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1149),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_compound_statement] = STATE(48),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(727),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(48),
    [sym_labeled_statement] = STATE(48),
    [sym_expression_statement] = STATE(48),
    [sym_if_statement] = STATE(48),
    [sym_switch_statement] = STATE(48),
    [sym_while_statement] = STATE(48),
    [sym_do_statement] = STATE(48),
    [sym_for_statement] = STATE(48),
    [sym_return_statement] = STATE(48),
    [sym_break_statement] = STATE(48),
    [sym_continue_statement] = STATE(48),
    [sym_goto_statement] = STATE(48),
    [sym_seh_try_statement] = STATE(48),
    [sym_seh_leave_statement] = STATE(48),
    [sym_expression] = STATE(1049),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1950),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(373),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [aux_sym_case_statement_repeat1] = STATE(48),
    [sym_identifier] = ACTIONS(787),
    [aux_sym_preproc_include_token1] = ACTIONS(791),
    [aux_sym_preproc_def_token1] = ACTIONS(791),
    [aux_sym_preproc_if_token1] = ACTIONS(791),
    [aux_sym_preproc_if_token2] = ACTIONS(791),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(791),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(791),
    [aux_sym_preproc_else_token1] = ACTIONS(791),
    [aux_sym_preproc_elif_token1] = ACTIONS(791),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(791),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(791),
    [sym_preproc_directive] = ACTIONS(791),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(125),
    [anon_sym___extension__] = ACTIONS(127),
    [anon_sym_typedef] = ACTIONS(129),
    [anon_sym_extern] = ACTIONS(47),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(37),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym___cdecl] = ACTIONS(791),
    [anon_sym___clrcall] = ACTIONS(791),
    [anon_sym___stdcall] = ACTIONS(791),
    [anon_sym___fastcall] = ACTIONS(791),
    [anon_sym___thiscall] = ACTIONS(791),
    [anon_sym___vectorcall] = ACTIONS(791),
    [anon_sym_LBRACE] = ACTIONS(133),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(135),
    [anon_sym_else] = ACTIONS(791),
    [anon_sym_switch] = ACTIONS(137),
    [anon_sym_case] = ACTIONS(791),
    [anon_sym_default] = ACTIONS(791),
    [anon_sym_while] = ACTIONS(143),
    [anon_sym_do] = ACTIONS(145),
    [anon_sym_for] = ACTIONS(147),
    [anon_sym_return] = ACTIONS(149),
    [anon_sym_break] = ACTIONS(151),
    [anon_sym_continue] = ACTIONS(153),
    [anon_sym_goto] = ACTIONS(155),
    [anon_sym___try] = ACTIONS(157),
    [anon_sym___leave] = ACTIONS(159),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(161),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(163),
    [sym_false] = ACTIONS(163),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [47] = {
    [sym_declaration] = STATE(49),
    [sym_type_definition] = STATE(49),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1149),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_compound_statement] = STATE(49),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(727),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(49),
    [sym_labeled_statement] = STATE(49),
    [sym_expression_statement] = STATE(49),
    [sym_if_statement] = STATE(49),
    [sym_switch_statement] = STATE(49),
    [sym_while_statement] = STATE(49),
    [sym_do_statement] = STATE(49),
    [sym_for_statement] = STATE(49),
    [sym_return_statement] = STATE(49),
    [sym_break_statement] = STATE(49),
    [sym_continue_statement] = STATE(49),
    [sym_goto_statement] = STATE(49),
    [sym_seh_try_statement] = STATE(49),
    [sym_seh_leave_statement] = STATE(49),
    [sym_expression] = STATE(1049),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1950),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(373),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [aux_sym_case_statement_repeat1] = STATE(49),
    [sym_identifier] = ACTIONS(787),
    [aux_sym_preproc_include_token1] = ACTIONS(793),
    [aux_sym_preproc_def_token1] = ACTIONS(793),
    [aux_sym_preproc_if_token1] = ACTIONS(793),
    [aux_sym_preproc_if_token2] = ACTIONS(793),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(793),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(793),
    [aux_sym_preproc_else_token1] = ACTIONS(793),
    [aux_sym_preproc_elif_token1] = ACTIONS(793),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(793),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(793),
    [sym_preproc_directive] = ACTIONS(793),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(125),
    [anon_sym___extension__] = ACTIONS(127),
    [anon_sym_typedef] = ACTIONS(129),
    [anon_sym_extern] = ACTIONS(47),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(37),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym___cdecl] = ACTIONS(793),
    [anon_sym___clrcall] = ACTIONS(793),
    [anon_sym___stdcall] = ACTIONS(793),
    [anon_sym___fastcall] = ACTIONS(793),
    [anon_sym___thiscall] = ACTIONS(793),
    [anon_sym___vectorcall] = ACTIONS(793),
    [anon_sym_LBRACE] = ACTIONS(133),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(135),
    [anon_sym_else] = ACTIONS(793),
    [anon_sym_switch] = ACTIONS(137),
    [anon_sym_case] = ACTIONS(793),
    [anon_sym_default] = ACTIONS(793),
    [anon_sym_while] = ACTIONS(143),
    [anon_sym_do] = ACTIONS(145),
    [anon_sym_for] = ACTIONS(147),
    [anon_sym_return] = ACTIONS(149),
    [anon_sym_break] = ACTIONS(151),
    [anon_sym_continue] = ACTIONS(153),
    [anon_sym_goto] = ACTIONS(155),
    [anon_sym___try] = ACTIONS(157),
    [anon_sym___leave] = ACTIONS(159),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(161),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(163),
    [sym_false] = ACTIONS(163),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [48] = {
    [sym_declaration] = STATE(49),
    [sym_type_definition] = STATE(49),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1149),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_compound_statement] = STATE(49),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(727),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(49),
    [sym_labeled_statement] = STATE(49),
    [sym_expression_statement] = STATE(49),
    [sym_if_statement] = STATE(49),
    [sym_switch_statement] = STATE(49),
    [sym_while_statement] = STATE(49),
    [sym_do_statement] = STATE(49),
    [sym_for_statement] = STATE(49),
    [sym_return_statement] = STATE(49),
    [sym_break_statement] = STATE(49),
    [sym_continue_statement] = STATE(49),
    [sym_goto_statement] = STATE(49),
    [sym_seh_try_statement] = STATE(49),
    [sym_seh_leave_statement] = STATE(49),
    [sym_expression] = STATE(1049),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1950),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(373),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [aux_sym_case_statement_repeat1] = STATE(49),
    [sym_identifier] = ACTIONS(787),
    [aux_sym_preproc_include_token1] = ACTIONS(795),
    [aux_sym_preproc_def_token1] = ACTIONS(795),
    [aux_sym_preproc_if_token1] = ACTIONS(795),
    [aux_sym_preproc_if_token2] = ACTIONS(795),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(795),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(795),
    [aux_sym_preproc_else_token1] = ACTIONS(795),
    [aux_sym_preproc_elif_token1] = ACTIONS(795),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(795),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(795),
    [sym_preproc_directive] = ACTIONS(795),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(125),
    [anon_sym___extension__] = ACTIONS(127),
    [anon_sym_typedef] = ACTIONS(129),
    [anon_sym_extern] = ACTIONS(47),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(37),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym___cdecl] = ACTIONS(795),
    [anon_sym___clrcall] = ACTIONS(795),
    [anon_sym___stdcall] = ACTIONS(795),
    [anon_sym___fastcall] = ACTIONS(795),
    [anon_sym___thiscall] = ACTIONS(795),
    [anon_sym___vectorcall] = ACTIONS(795),
    [anon_sym_LBRACE] = ACTIONS(133),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(135),
    [anon_sym_else] = ACTIONS(795),
    [anon_sym_switch] = ACTIONS(137),
    [anon_sym_case] = ACTIONS(795),
    [anon_sym_default] = ACTIONS(795),
    [anon_sym_while] = ACTIONS(143),
    [anon_sym_do] = ACTIONS(145),
    [anon_sym_for] = ACTIONS(147),
    [anon_sym_return] = ACTIONS(149),
    [anon_sym_break] = ACTIONS(151),
    [anon_sym_continue] = ACTIONS(153),
    [anon_sym_goto] = ACTIONS(155),
    [anon_sym___try] = ACTIONS(157),
    [anon_sym___leave] = ACTIONS(159),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(161),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(163),
    [sym_false] = ACTIONS(163),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [49] = {
    [sym_declaration] = STATE(49),
    [sym_type_definition] = STATE(49),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1149),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_compound_statement] = STATE(49),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(727),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(49),
    [sym_labeled_statement] = STATE(49),
    [sym_expression_statement] = STATE(49),
    [sym_if_statement] = STATE(49),
    [sym_switch_statement] = STATE(49),
    [sym_while_statement] = STATE(49),
    [sym_do_statement] = STATE(49),
    [sym_for_statement] = STATE(49),
    [sym_return_statement] = STATE(49),
    [sym_break_statement] = STATE(49),
    [sym_continue_statement] = STATE(49),
    [sym_goto_statement] = STATE(49),
    [sym_seh_try_statement] = STATE(49),
    [sym_seh_leave_statement] = STATE(49),
    [sym_expression] = STATE(1049),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1950),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(373),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [aux_sym_case_statement_repeat1] = STATE(49),
    [sym_identifier] = ACTIONS(797),
    [aux_sym_preproc_include_token1] = ACTIONS(800),
    [aux_sym_preproc_def_token1] = ACTIONS(800),
    [aux_sym_preproc_if_token1] = ACTIONS(800),
    [aux_sym_preproc_if_token2] = ACTIONS(800),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(800),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(800),
    [aux_sym_preproc_else_token1] = ACTIONS(800),
    [aux_sym_preproc_elif_token1] = ACTIONS(800),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(800),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(800),
    [sym_preproc_directive] = ACTIONS(800),
    [anon_sym_LPAREN2] = ACTIONS(802),
    [anon_sym_BANG] = ACTIONS(805),
    [anon_sym_TILDE] = ACTIONS(805),
    [anon_sym_DASH] = ACTIONS(808),
    [anon_sym_PLUS] = ACTIONS(808),
    [anon_sym_STAR] = ACTIONS(811),
    [anon_sym_AMP] = ACTIONS(811),
    [anon_sym_SEMI] = ACTIONS(814),
    [anon_sym___extension__] = ACTIONS(817),
    [anon_sym_typedef] = ACTIONS(820),
    [anon_sym_extern] = ACTIONS(823),
    [anon_sym___attribute__] = ACTIONS(826),
    [anon_sym___attribute] = ACTIONS(826),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(829),
    [anon_sym___declspec] = ACTIONS(832),
    [anon_sym___cdecl] = ACTIONS(800),
    [anon_sym___clrcall] = ACTIONS(800),
    [anon_sym___stdcall] = ACTIONS(800),
    [anon_sym___fastcall] = ACTIONS(800),
    [anon_sym___thiscall] = ACTIONS(800),
    [anon_sym___vectorcall] = ACTIONS(800),
    [anon_sym_LBRACE] = ACTIONS(835),
    [anon_sym_signed] = ACTIONS(838),
    [anon_sym_unsigned] = ACTIONS(838),
    [anon_sym_long] = ACTIONS(838),
    [anon_sym_short] = ACTIONS(838),
    [anon_sym_static] = ACTIONS(823),
    [anon_sym_auto] = ACTIONS(823),
    [anon_sym_register] = ACTIONS(823),
    [anon_sym_inline] = ACTIONS(823),
    [anon_sym___inline] = ACTIONS(823),
    [anon_sym___inline__] = ACTIONS(823),
    [anon_sym___forceinline] = ACTIONS(823),
    [anon_sym_thread_local] = ACTIONS(823),
    [anon_sym___thread] = ACTIONS(823),
    [anon_sym_const] = ACTIONS(841),
    [anon_sym_constexpr] = ACTIONS(841),
    [anon_sym_volatile] = ACTIONS(841),
    [anon_sym_restrict] = ACTIONS(841),
    [anon_sym___restrict__] = ACTIONS(841),
    [anon_sym__Atomic] = ACTIONS(841),
    [anon_sym__Noreturn] = ACTIONS(841),
    [anon_sym_noreturn] = ACTIONS(841),
    [anon_sym__Nonnull] = ACTIONS(841),
    [anon_sym_alignas] = ACTIONS(844),
    [anon_sym__Alignas] = ACTIONS(844),
    [sym_primitive_type] = ACTIONS(847),
    [anon_sym_enum] = ACTIONS(850),
    [anon_sym_struct] = ACTIONS(853),
    [anon_sym_union] = ACTIONS(856),
    [anon_sym_if] = ACTIONS(859),
    [anon_sym_else] = ACTIONS(800),
    [anon_sym_switch] = ACTIONS(862),
    [anon_sym_case] = ACTIONS(800),
    [anon_sym_default] = ACTIONS(800),
    [anon_sym_while] = ACTIONS(865),
    [anon_sym_do] = ACTIONS(868),
    [anon_sym_for] = ACTIONS(871),
    [anon_sym_return] = ACTIONS(874),
    [anon_sym_break] = ACTIONS(877),
    [anon_sym_continue] = ACTIONS(880),
    [anon_sym_goto] = ACTIONS(883),
    [anon_sym___try] = ACTIONS(886),
    [anon_sym___leave] = ACTIONS(889),
    [anon_sym_DASH_DASH] = ACTIONS(892),
    [anon_sym_PLUS_PLUS] = ACTIONS(892),
    [anon_sym_sizeof] = ACTIONS(895),
    [anon_sym___alignof__] = ACTIONS(898),
    [anon_sym___alignof] = ACTIONS(898),
    [anon_sym__alignof] = ACTIONS(898),
    [anon_sym_alignof] = ACTIONS(898),
    [anon_sym__Alignof] = ACTIONS(898),
    [anon_sym_offsetof] = ACTIONS(901),
    [anon_sym__Generic] = ACTIONS(904),
    [anon_sym_asm] = ACTIONS(907),
    [anon_sym___asm__] = ACTIONS(907),
    [anon_sym___asm] = ACTIONS(907),
    [sym_number_literal] = ACTIONS(910),
    [anon_sym_L_SQUOTE] = ACTIONS(913),
    [anon_sym_u_SQUOTE] = ACTIONS(913),
    [anon_sym_U_SQUOTE] = ACTIONS(913),
    [anon_sym_u8_SQUOTE] = ACTIONS(913),
    [anon_sym_SQUOTE] = ACTIONS(913),
    [anon_sym_L_DQUOTE] = ACTIONS(916),
    [anon_sym_u_DQUOTE] = ACTIONS(916),
    [anon_sym_U_DQUOTE] = ACTIONS(916),
    [anon_sym_u8_DQUOTE] = ACTIONS(916),
    [anon_sym_DQUOTE] = ACTIONS(916),
    [sym_true] = ACTIONS(919),
    [sym_false] = ACTIONS(919),
    [anon_sym_NULL] = ACTIONS(922),
    [anon_sym_nullptr] = ACTIONS(922),
    [sym_comment] = ACTIONS(3),
  },
  [50] = {
    [sym_declaration] = STATE(64),
    [sym_type_definition] = STATE(64),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1154),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_compound_statement] = STATE(64),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(727),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(64),
    [sym_labeled_statement] = STATE(64),
    [sym_expression_statement] = STATE(64),
    [sym_if_statement] = STATE(64),
    [sym_switch_statement] = STATE(64),
    [sym_while_statement] = STATE(64),
    [sym_do_statement] = STATE(64),
    [sym_for_statement] = STATE(64),
    [sym_return_statement] = STATE(64),
    [sym_break_statement] = STATE(64),
    [sym_continue_statement] = STATE(64),
    [sym_goto_statement] = STATE(64),
    [sym_seh_try_statement] = STATE(64),
    [sym_seh_leave_statement] = STATE(64),
    [sym_expression] = STATE(1074),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1913),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(375),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [aux_sym_case_statement_repeat1] = STATE(64),
    [ts_builtin_sym_end] = ACTIONS(925),
    [sym_identifier] = ACTIONS(927),
    [aux_sym_preproc_include_token1] = ACTIONS(795),
    [aux_sym_preproc_def_token1] = ACTIONS(795),
    [aux_sym_preproc_if_token1] = ACTIONS(795),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(795),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(795),
    [sym_preproc_directive] = ACTIONS(795),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(929),
    [anon_sym___extension__] = ACTIONS(29),
    [anon_sym_typedef] = ACTIONS(31),
    [anon_sym_extern] = ACTIONS(47),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(37),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym___cdecl] = ACTIONS(795),
    [anon_sym___clrcall] = ACTIONS(795),
    [anon_sym___stdcall] = ACTIONS(795),
    [anon_sym___fastcall] = ACTIONS(795),
    [anon_sym___thiscall] = ACTIONS(795),
    [anon_sym___vectorcall] = ACTIONS(795),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(61),
    [anon_sym_else] = ACTIONS(795),
    [anon_sym_switch] = ACTIONS(63),
    [anon_sym_case] = ACTIONS(795),
    [anon_sym_default] = ACTIONS(795),
    [anon_sym_while] = ACTIONS(69),
    [anon_sym_do] = ACTIONS(71),
    [anon_sym_for] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_break] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(79),
    [anon_sym_goto] = ACTIONS(81),
    [anon_sym___try] = ACTIONS(931),
    [anon_sym___leave] = ACTIONS(933),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(161),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(163),
    [sym_false] = ACTIONS(163),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [51] = {
    [sym_declaration] = STATE(50),
    [sym_type_definition] = STATE(50),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1154),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_compound_statement] = STATE(50),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(727),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(50),
    [sym_labeled_statement] = STATE(50),
    [sym_expression_statement] = STATE(50),
    [sym_if_statement] = STATE(50),
    [sym_switch_statement] = STATE(50),
    [sym_while_statement] = STATE(50),
    [sym_do_statement] = STATE(50),
    [sym_for_statement] = STATE(50),
    [sym_return_statement] = STATE(50),
    [sym_break_statement] = STATE(50),
    [sym_continue_statement] = STATE(50),
    [sym_goto_statement] = STATE(50),
    [sym_seh_try_statement] = STATE(50),
    [sym_seh_leave_statement] = STATE(50),
    [sym_expression] = STATE(1074),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1913),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(375),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [aux_sym_case_statement_repeat1] = STATE(50),
    [ts_builtin_sym_end] = ACTIONS(935),
    [sym_identifier] = ACTIONS(927),
    [aux_sym_preproc_include_token1] = ACTIONS(791),
    [aux_sym_preproc_def_token1] = ACTIONS(791),
    [aux_sym_preproc_if_token1] = ACTIONS(791),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(791),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(791),
    [sym_preproc_directive] = ACTIONS(791),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(929),
    [anon_sym___extension__] = ACTIONS(29),
    [anon_sym_typedef] = ACTIONS(31),
    [anon_sym_extern] = ACTIONS(47),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(37),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym___cdecl] = ACTIONS(791),
    [anon_sym___clrcall] = ACTIONS(791),
    [anon_sym___stdcall] = ACTIONS(791),
    [anon_sym___fastcall] = ACTIONS(791),
    [anon_sym___thiscall] = ACTIONS(791),
    [anon_sym___vectorcall] = ACTIONS(791),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(61),
    [anon_sym_else] = ACTIONS(791),
    [anon_sym_switch] = ACTIONS(63),
    [anon_sym_case] = ACTIONS(791),
    [anon_sym_default] = ACTIONS(791),
    [anon_sym_while] = ACTIONS(69),
    [anon_sym_do] = ACTIONS(71),
    [anon_sym_for] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_break] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(79),
    [anon_sym_goto] = ACTIONS(81),
    [anon_sym___try] = ACTIONS(931),
    [anon_sym___leave] = ACTIONS(933),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(161),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(163),
    [sym_false] = ACTIONS(163),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [52] = {
    [sym_declaration] = STATE(55),
    [sym_type_definition] = STATE(55),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1158),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_compound_statement] = STATE(55),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(727),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(55),
    [sym_labeled_statement] = STATE(55),
    [sym_expression_statement] = STATE(55),
    [sym_if_statement] = STATE(55),
    [sym_switch_statement] = STATE(55),
    [sym_while_statement] = STATE(55),
    [sym_do_statement] = STATE(55),
    [sym_for_statement] = STATE(55),
    [sym_return_statement] = STATE(55),
    [sym_break_statement] = STATE(55),
    [sym_continue_statement] = STATE(55),
    [sym_goto_statement] = STATE(55),
    [sym_seh_try_statement] = STATE(55),
    [sym_seh_leave_statement] = STATE(55),
    [sym_expression] = STATE(1071),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1906),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(349),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [aux_sym_case_statement_repeat1] = STATE(55),
    [sym_identifier] = ACTIONS(937),
    [aux_sym_preproc_include_token1] = ACTIONS(791),
    [aux_sym_preproc_def_token1] = ACTIONS(791),
    [aux_sym_preproc_if_token1] = ACTIONS(791),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(791),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(791),
    [sym_preproc_directive] = ACTIONS(791),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(370),
    [anon_sym___extension__] = ACTIONS(372),
    [anon_sym_typedef] = ACTIONS(374),
    [anon_sym_extern] = ACTIONS(47),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(37),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym___cdecl] = ACTIONS(791),
    [anon_sym___clrcall] = ACTIONS(791),
    [anon_sym___stdcall] = ACTIONS(791),
    [anon_sym___fastcall] = ACTIONS(791),
    [anon_sym___thiscall] = ACTIONS(791),
    [anon_sym___vectorcall] = ACTIONS(791),
    [anon_sym_LBRACE] = ACTIONS(378),
    [anon_sym_RBRACE] = ACTIONS(935),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(382),
    [anon_sym_else] = ACTIONS(791),
    [anon_sym_switch] = ACTIONS(384),
    [anon_sym_case] = ACTIONS(791),
    [anon_sym_default] = ACTIONS(791),
    [anon_sym_while] = ACTIONS(390),
    [anon_sym_do] = ACTIONS(392),
    [anon_sym_for] = ACTIONS(394),
    [anon_sym_return] = ACTIONS(396),
    [anon_sym_break] = ACTIONS(398),
    [anon_sym_continue] = ACTIONS(400),
    [anon_sym_goto] = ACTIONS(402),
    [anon_sym___try] = ACTIONS(404),
    [anon_sym___leave] = ACTIONS(406),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(161),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(163),
    [sym_false] = ACTIONS(163),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [53] = {
    [sym_declaration] = STATE(56),
    [sym_type_definition] = STATE(56),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1158),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_compound_statement] = STATE(56),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(727),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(56),
    [sym_labeled_statement] = STATE(56),
    [sym_expression_statement] = STATE(56),
    [sym_if_statement] = STATE(56),
    [sym_switch_statement] = STATE(56),
    [sym_while_statement] = STATE(56),
    [sym_do_statement] = STATE(56),
    [sym_for_statement] = STATE(56),
    [sym_return_statement] = STATE(56),
    [sym_break_statement] = STATE(56),
    [sym_continue_statement] = STATE(56),
    [sym_goto_statement] = STATE(56),
    [sym_seh_try_statement] = STATE(56),
    [sym_seh_leave_statement] = STATE(56),
    [sym_expression] = STATE(1071),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1906),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(349),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [aux_sym_case_statement_repeat1] = STATE(56),
    [sym_identifier] = ACTIONS(937),
    [aux_sym_preproc_include_token1] = ACTIONS(793),
    [aux_sym_preproc_def_token1] = ACTIONS(793),
    [aux_sym_preproc_if_token1] = ACTIONS(793),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(793),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(793),
    [sym_preproc_directive] = ACTIONS(793),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(370),
    [anon_sym___extension__] = ACTIONS(372),
    [anon_sym_typedef] = ACTIONS(374),
    [anon_sym_extern] = ACTIONS(47),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(37),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym___cdecl] = ACTIONS(793),
    [anon_sym___clrcall] = ACTIONS(793),
    [anon_sym___stdcall] = ACTIONS(793),
    [anon_sym___fastcall] = ACTIONS(793),
    [anon_sym___thiscall] = ACTIONS(793),
    [anon_sym___vectorcall] = ACTIONS(793),
    [anon_sym_LBRACE] = ACTIONS(378),
    [anon_sym_RBRACE] = ACTIONS(939),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(382),
    [anon_sym_else] = ACTIONS(793),
    [anon_sym_switch] = ACTIONS(384),
    [anon_sym_case] = ACTIONS(793),
    [anon_sym_default] = ACTIONS(793),
    [anon_sym_while] = ACTIONS(390),
    [anon_sym_do] = ACTIONS(392),
    [anon_sym_for] = ACTIONS(394),
    [anon_sym_return] = ACTIONS(396),
    [anon_sym_break] = ACTIONS(398),
    [anon_sym_continue] = ACTIONS(400),
    [anon_sym_goto] = ACTIONS(402),
    [anon_sym___try] = ACTIONS(404),
    [anon_sym___leave] = ACTIONS(406),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(161),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(163),
    [sym_false] = ACTIONS(163),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [54] = {
    [sym_declaration] = STATE(53),
    [sym_type_definition] = STATE(53),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1158),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_compound_statement] = STATE(53),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(727),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(53),
    [sym_labeled_statement] = STATE(53),
    [sym_expression_statement] = STATE(53),
    [sym_if_statement] = STATE(53),
    [sym_switch_statement] = STATE(53),
    [sym_while_statement] = STATE(53),
    [sym_do_statement] = STATE(53),
    [sym_for_statement] = STATE(53),
    [sym_return_statement] = STATE(53),
    [sym_break_statement] = STATE(53),
    [sym_continue_statement] = STATE(53),
    [sym_goto_statement] = STATE(53),
    [sym_seh_try_statement] = STATE(53),
    [sym_seh_leave_statement] = STATE(53),
    [sym_expression] = STATE(1071),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1906),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(349),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [aux_sym_case_statement_repeat1] = STATE(53),
    [sym_identifier] = ACTIONS(937),
    [aux_sym_preproc_include_token1] = ACTIONS(789),
    [aux_sym_preproc_def_token1] = ACTIONS(789),
    [aux_sym_preproc_if_token1] = ACTIONS(789),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(789),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(789),
    [sym_preproc_directive] = ACTIONS(789),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(370),
    [anon_sym___extension__] = ACTIONS(372),
    [anon_sym_typedef] = ACTIONS(374),
    [anon_sym_extern] = ACTIONS(47),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(37),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym___cdecl] = ACTIONS(789),
    [anon_sym___clrcall] = ACTIONS(789),
    [anon_sym___stdcall] = ACTIONS(789),
    [anon_sym___fastcall] = ACTIONS(789),
    [anon_sym___thiscall] = ACTIONS(789),
    [anon_sym___vectorcall] = ACTIONS(789),
    [anon_sym_LBRACE] = ACTIONS(378),
    [anon_sym_RBRACE] = ACTIONS(941),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(382),
    [anon_sym_else] = ACTIONS(789),
    [anon_sym_switch] = ACTIONS(384),
    [anon_sym_case] = ACTIONS(789),
    [anon_sym_default] = ACTIONS(789),
    [anon_sym_while] = ACTIONS(390),
    [anon_sym_do] = ACTIONS(392),
    [anon_sym_for] = ACTIONS(394),
    [anon_sym_return] = ACTIONS(396),
    [anon_sym_break] = ACTIONS(398),
    [anon_sym_continue] = ACTIONS(400),
    [anon_sym_goto] = ACTIONS(402),
    [anon_sym___try] = ACTIONS(404),
    [anon_sym___leave] = ACTIONS(406),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(161),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(163),
    [sym_false] = ACTIONS(163),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [55] = {
    [sym_declaration] = STATE(56),
    [sym_type_definition] = STATE(56),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1158),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_compound_statement] = STATE(56),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(727),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(56),
    [sym_labeled_statement] = STATE(56),
    [sym_expression_statement] = STATE(56),
    [sym_if_statement] = STATE(56),
    [sym_switch_statement] = STATE(56),
    [sym_while_statement] = STATE(56),
    [sym_do_statement] = STATE(56),
    [sym_for_statement] = STATE(56),
    [sym_return_statement] = STATE(56),
    [sym_break_statement] = STATE(56),
    [sym_continue_statement] = STATE(56),
    [sym_goto_statement] = STATE(56),
    [sym_seh_try_statement] = STATE(56),
    [sym_seh_leave_statement] = STATE(56),
    [sym_expression] = STATE(1071),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1906),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(349),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [aux_sym_case_statement_repeat1] = STATE(56),
    [sym_identifier] = ACTIONS(937),
    [aux_sym_preproc_include_token1] = ACTIONS(795),
    [aux_sym_preproc_def_token1] = ACTIONS(795),
    [aux_sym_preproc_if_token1] = ACTIONS(795),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(795),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(795),
    [sym_preproc_directive] = ACTIONS(795),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(370),
    [anon_sym___extension__] = ACTIONS(372),
    [anon_sym_typedef] = ACTIONS(374),
    [anon_sym_extern] = ACTIONS(47),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(37),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym___cdecl] = ACTIONS(795),
    [anon_sym___clrcall] = ACTIONS(795),
    [anon_sym___stdcall] = ACTIONS(795),
    [anon_sym___fastcall] = ACTIONS(795),
    [anon_sym___thiscall] = ACTIONS(795),
    [anon_sym___vectorcall] = ACTIONS(795),
    [anon_sym_LBRACE] = ACTIONS(378),
    [anon_sym_RBRACE] = ACTIONS(925),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(382),
    [anon_sym_else] = ACTIONS(795),
    [anon_sym_switch] = ACTIONS(384),
    [anon_sym_case] = ACTIONS(795),
    [anon_sym_default] = ACTIONS(795),
    [anon_sym_while] = ACTIONS(390),
    [anon_sym_do] = ACTIONS(392),
    [anon_sym_for] = ACTIONS(394),
    [anon_sym_return] = ACTIONS(396),
    [anon_sym_break] = ACTIONS(398),
    [anon_sym_continue] = ACTIONS(400),
    [anon_sym_goto] = ACTIONS(402),
    [anon_sym___try] = ACTIONS(404),
    [anon_sym___leave] = ACTIONS(406),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(161),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(163),
    [sym_false] = ACTIONS(163),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [56] = {
    [sym_declaration] = STATE(56),
    [sym_type_definition] = STATE(56),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1158),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_compound_statement] = STATE(56),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(727),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(56),
    [sym_labeled_statement] = STATE(56),
    [sym_expression_statement] = STATE(56),
    [sym_if_statement] = STATE(56),
    [sym_switch_statement] = STATE(56),
    [sym_while_statement] = STATE(56),
    [sym_do_statement] = STATE(56),
    [sym_for_statement] = STATE(56),
    [sym_return_statement] = STATE(56),
    [sym_break_statement] = STATE(56),
    [sym_continue_statement] = STATE(56),
    [sym_goto_statement] = STATE(56),
    [sym_seh_try_statement] = STATE(56),
    [sym_seh_leave_statement] = STATE(56),
    [sym_expression] = STATE(1071),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1906),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(349),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [aux_sym_case_statement_repeat1] = STATE(56),
    [sym_identifier] = ACTIONS(943),
    [aux_sym_preproc_include_token1] = ACTIONS(800),
    [aux_sym_preproc_def_token1] = ACTIONS(800),
    [aux_sym_preproc_if_token1] = ACTIONS(800),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(800),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(800),
    [sym_preproc_directive] = ACTIONS(800),
    [anon_sym_LPAREN2] = ACTIONS(802),
    [anon_sym_BANG] = ACTIONS(805),
    [anon_sym_TILDE] = ACTIONS(805),
    [anon_sym_DASH] = ACTIONS(808),
    [anon_sym_PLUS] = ACTIONS(808),
    [anon_sym_STAR] = ACTIONS(811),
    [anon_sym_AMP] = ACTIONS(811),
    [anon_sym_SEMI] = ACTIONS(946),
    [anon_sym___extension__] = ACTIONS(949),
    [anon_sym_typedef] = ACTIONS(952),
    [anon_sym_extern] = ACTIONS(823),
    [anon_sym___attribute__] = ACTIONS(826),
    [anon_sym___attribute] = ACTIONS(826),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(829),
    [anon_sym___declspec] = ACTIONS(832),
    [anon_sym___cdecl] = ACTIONS(800),
    [anon_sym___clrcall] = ACTIONS(800),
    [anon_sym___stdcall] = ACTIONS(800),
    [anon_sym___fastcall] = ACTIONS(800),
    [anon_sym___thiscall] = ACTIONS(800),
    [anon_sym___vectorcall] = ACTIONS(800),
    [anon_sym_LBRACE] = ACTIONS(955),
    [anon_sym_RBRACE] = ACTIONS(958),
    [anon_sym_signed] = ACTIONS(838),
    [anon_sym_unsigned] = ACTIONS(838),
    [anon_sym_long] = ACTIONS(838),
    [anon_sym_short] = ACTIONS(838),
    [anon_sym_static] = ACTIONS(823),
    [anon_sym_auto] = ACTIONS(823),
    [anon_sym_register] = ACTIONS(823),
    [anon_sym_inline] = ACTIONS(823),
    [anon_sym___inline] = ACTIONS(823),
    [anon_sym___inline__] = ACTIONS(823),
    [anon_sym___forceinline] = ACTIONS(823),
    [anon_sym_thread_local] = ACTIONS(823),
    [anon_sym___thread] = ACTIONS(823),
    [anon_sym_const] = ACTIONS(841),
    [anon_sym_constexpr] = ACTIONS(841),
    [anon_sym_volatile] = ACTIONS(841),
    [anon_sym_restrict] = ACTIONS(841),
    [anon_sym___restrict__] = ACTIONS(841),
    [anon_sym__Atomic] = ACTIONS(841),
    [anon_sym__Noreturn] = ACTIONS(841),
    [anon_sym_noreturn] = ACTIONS(841),
    [anon_sym__Nonnull] = ACTIONS(841),
    [anon_sym_alignas] = ACTIONS(844),
    [anon_sym__Alignas] = ACTIONS(844),
    [sym_primitive_type] = ACTIONS(847),
    [anon_sym_enum] = ACTIONS(850),
    [anon_sym_struct] = ACTIONS(853),
    [anon_sym_union] = ACTIONS(856),
    [anon_sym_if] = ACTIONS(960),
    [anon_sym_else] = ACTIONS(800),
    [anon_sym_switch] = ACTIONS(963),
    [anon_sym_case] = ACTIONS(800),
    [anon_sym_default] = ACTIONS(800),
    [anon_sym_while] = ACTIONS(966),
    [anon_sym_do] = ACTIONS(969),
    [anon_sym_for] = ACTIONS(972),
    [anon_sym_return] = ACTIONS(975),
    [anon_sym_break] = ACTIONS(978),
    [anon_sym_continue] = ACTIONS(981),
    [anon_sym_goto] = ACTIONS(984),
    [anon_sym___try] = ACTIONS(987),
    [anon_sym___leave] = ACTIONS(990),
    [anon_sym_DASH_DASH] = ACTIONS(892),
    [anon_sym_PLUS_PLUS] = ACTIONS(892),
    [anon_sym_sizeof] = ACTIONS(895),
    [anon_sym___alignof__] = ACTIONS(898),
    [anon_sym___alignof] = ACTIONS(898),
    [anon_sym__alignof] = ACTIONS(898),
    [anon_sym_alignof] = ACTIONS(898),
    [anon_sym__Alignof] = ACTIONS(898),
    [anon_sym_offsetof] = ACTIONS(901),
    [anon_sym__Generic] = ACTIONS(904),
    [anon_sym_asm] = ACTIONS(907),
    [anon_sym___asm__] = ACTIONS(907),
    [anon_sym___asm] = ACTIONS(907),
    [sym_number_literal] = ACTIONS(910),
    [anon_sym_L_SQUOTE] = ACTIONS(913),
    [anon_sym_u_SQUOTE] = ACTIONS(913),
    [anon_sym_U_SQUOTE] = ACTIONS(913),
    [anon_sym_u8_SQUOTE] = ACTIONS(913),
    [anon_sym_SQUOTE] = ACTIONS(913),
    [anon_sym_L_DQUOTE] = ACTIONS(916),
    [anon_sym_u_DQUOTE] = ACTIONS(916),
    [anon_sym_U_DQUOTE] = ACTIONS(916),
    [anon_sym_u8_DQUOTE] = ACTIONS(916),
    [anon_sym_DQUOTE] = ACTIONS(916),
    [sym_true] = ACTIONS(919),
    [sym_false] = ACTIONS(919),
    [anon_sym_NULL] = ACTIONS(922),
    [anon_sym_nullptr] = ACTIONS(922),
    [sym_comment] = ACTIONS(3),
  },
  [57] = {
    [sym_declaration] = STATE(60),
    [sym_type_definition] = STATE(60),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1152),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_compound_statement] = STATE(60),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(727),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(60),
    [sym_labeled_statement] = STATE(60),
    [sym_expression_statement] = STATE(60),
    [sym_if_statement] = STATE(60),
    [sym_switch_statement] = STATE(60),
    [sym_while_statement] = STATE(60),
    [sym_do_statement] = STATE(60),
    [sym_for_statement] = STATE(60),
    [sym_return_statement] = STATE(60),
    [sym_break_statement] = STATE(60),
    [sym_continue_statement] = STATE(60),
    [sym_goto_statement] = STATE(60),
    [sym_seh_try_statement] = STATE(60),
    [sym_seh_leave_statement] = STATE(60),
    [sym_expression] = STATE(1052),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1858),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(378),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [aux_sym_case_statement_repeat1] = STATE(60),
    [sym_identifier] = ACTIONS(993),
    [aux_sym_preproc_include_token1] = ACTIONS(789),
    [aux_sym_preproc_def_token1] = ACTIONS(789),
    [aux_sym_preproc_if_token1] = ACTIONS(789),
    [aux_sym_preproc_if_token2] = ACTIONS(789),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(789),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(789),
    [sym_preproc_directive] = ACTIONS(789),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(498),
    [anon_sym___extension__] = ACTIONS(500),
    [anon_sym_typedef] = ACTIONS(502),
    [anon_sym_extern] = ACTIONS(47),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(37),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym___cdecl] = ACTIONS(789),
    [anon_sym___clrcall] = ACTIONS(789),
    [anon_sym___stdcall] = ACTIONS(789),
    [anon_sym___fastcall] = ACTIONS(789),
    [anon_sym___thiscall] = ACTIONS(789),
    [anon_sym___vectorcall] = ACTIONS(789),
    [anon_sym_LBRACE] = ACTIONS(506),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(508),
    [anon_sym_else] = ACTIONS(789),
    [anon_sym_switch] = ACTIONS(510),
    [anon_sym_case] = ACTIONS(789),
    [anon_sym_default] = ACTIONS(789),
    [anon_sym_while] = ACTIONS(516),
    [anon_sym_do] = ACTIONS(518),
    [anon_sym_for] = ACTIONS(520),
    [anon_sym_return] = ACTIONS(522),
    [anon_sym_break] = ACTIONS(524),
    [anon_sym_continue] = ACTIONS(526),
    [anon_sym_goto] = ACTIONS(528),
    [anon_sym___try] = ACTIONS(530),
    [anon_sym___leave] = ACTIONS(532),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(161),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(163),
    [sym_false] = ACTIONS(163),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [58] = {
    [sym_declaration] = STATE(59),
    [sym_type_definition] = STATE(59),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1152),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_compound_statement] = STATE(59),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(727),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(59),
    [sym_labeled_statement] = STATE(59),
    [sym_expression_statement] = STATE(59),
    [sym_if_statement] = STATE(59),
    [sym_switch_statement] = STATE(59),
    [sym_while_statement] = STATE(59),
    [sym_do_statement] = STATE(59),
    [sym_for_statement] = STATE(59),
    [sym_return_statement] = STATE(59),
    [sym_break_statement] = STATE(59),
    [sym_continue_statement] = STATE(59),
    [sym_goto_statement] = STATE(59),
    [sym_seh_try_statement] = STATE(59),
    [sym_seh_leave_statement] = STATE(59),
    [sym_expression] = STATE(1052),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1858),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(378),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [aux_sym_case_statement_repeat1] = STATE(59),
    [sym_identifier] = ACTIONS(993),
    [aux_sym_preproc_include_token1] = ACTIONS(791),
    [aux_sym_preproc_def_token1] = ACTIONS(791),
    [aux_sym_preproc_if_token1] = ACTIONS(791),
    [aux_sym_preproc_if_token2] = ACTIONS(791),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(791),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(791),
    [sym_preproc_directive] = ACTIONS(791),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(498),
    [anon_sym___extension__] = ACTIONS(500),
    [anon_sym_typedef] = ACTIONS(502),
    [anon_sym_extern] = ACTIONS(47),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(37),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym___cdecl] = ACTIONS(791),
    [anon_sym___clrcall] = ACTIONS(791),
    [anon_sym___stdcall] = ACTIONS(791),
    [anon_sym___fastcall] = ACTIONS(791),
    [anon_sym___thiscall] = ACTIONS(791),
    [anon_sym___vectorcall] = ACTIONS(791),
    [anon_sym_LBRACE] = ACTIONS(506),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(508),
    [anon_sym_else] = ACTIONS(791),
    [anon_sym_switch] = ACTIONS(510),
    [anon_sym_case] = ACTIONS(791),
    [anon_sym_default] = ACTIONS(791),
    [anon_sym_while] = ACTIONS(516),
    [anon_sym_do] = ACTIONS(518),
    [anon_sym_for] = ACTIONS(520),
    [anon_sym_return] = ACTIONS(522),
    [anon_sym_break] = ACTIONS(524),
    [anon_sym_continue] = ACTIONS(526),
    [anon_sym_goto] = ACTIONS(528),
    [anon_sym___try] = ACTIONS(530),
    [anon_sym___leave] = ACTIONS(532),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(161),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(163),
    [sym_false] = ACTIONS(163),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [59] = {
    [sym_declaration] = STATE(61),
    [sym_type_definition] = STATE(61),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1152),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_compound_statement] = STATE(61),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(727),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(61),
    [sym_labeled_statement] = STATE(61),
    [sym_expression_statement] = STATE(61),
    [sym_if_statement] = STATE(61),
    [sym_switch_statement] = STATE(61),
    [sym_while_statement] = STATE(61),
    [sym_do_statement] = STATE(61),
    [sym_for_statement] = STATE(61),
    [sym_return_statement] = STATE(61),
    [sym_break_statement] = STATE(61),
    [sym_continue_statement] = STATE(61),
    [sym_goto_statement] = STATE(61),
    [sym_seh_try_statement] = STATE(61),
    [sym_seh_leave_statement] = STATE(61),
    [sym_expression] = STATE(1052),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1858),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(378),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [aux_sym_case_statement_repeat1] = STATE(61),
    [sym_identifier] = ACTIONS(993),
    [aux_sym_preproc_include_token1] = ACTIONS(795),
    [aux_sym_preproc_def_token1] = ACTIONS(795),
    [aux_sym_preproc_if_token1] = ACTIONS(795),
    [aux_sym_preproc_if_token2] = ACTIONS(795),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(795),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(795),
    [sym_preproc_directive] = ACTIONS(795),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(498),
    [anon_sym___extension__] = ACTIONS(500),
    [anon_sym_typedef] = ACTIONS(502),
    [anon_sym_extern] = ACTIONS(47),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(37),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym___cdecl] = ACTIONS(795),
    [anon_sym___clrcall] = ACTIONS(795),
    [anon_sym___stdcall] = ACTIONS(795),
    [anon_sym___fastcall] = ACTIONS(795),
    [anon_sym___thiscall] = ACTIONS(795),
    [anon_sym___vectorcall] = ACTIONS(795),
    [anon_sym_LBRACE] = ACTIONS(506),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(508),
    [anon_sym_else] = ACTIONS(795),
    [anon_sym_switch] = ACTIONS(510),
    [anon_sym_case] = ACTIONS(795),
    [anon_sym_default] = ACTIONS(795),
    [anon_sym_while] = ACTIONS(516),
    [anon_sym_do] = ACTIONS(518),
    [anon_sym_for] = ACTIONS(520),
    [anon_sym_return] = ACTIONS(522),
    [anon_sym_break] = ACTIONS(524),
    [anon_sym_continue] = ACTIONS(526),
    [anon_sym_goto] = ACTIONS(528),
    [anon_sym___try] = ACTIONS(530),
    [anon_sym___leave] = ACTIONS(532),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(161),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(163),
    [sym_false] = ACTIONS(163),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [60] = {
    [sym_declaration] = STATE(61),
    [sym_type_definition] = STATE(61),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1152),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_compound_statement] = STATE(61),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(727),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(61),
    [sym_labeled_statement] = STATE(61),
    [sym_expression_statement] = STATE(61),
    [sym_if_statement] = STATE(61),
    [sym_switch_statement] = STATE(61),
    [sym_while_statement] = STATE(61),
    [sym_do_statement] = STATE(61),
    [sym_for_statement] = STATE(61),
    [sym_return_statement] = STATE(61),
    [sym_break_statement] = STATE(61),
    [sym_continue_statement] = STATE(61),
    [sym_goto_statement] = STATE(61),
    [sym_seh_try_statement] = STATE(61),
    [sym_seh_leave_statement] = STATE(61),
    [sym_expression] = STATE(1052),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1858),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(378),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [aux_sym_case_statement_repeat1] = STATE(61),
    [sym_identifier] = ACTIONS(993),
    [aux_sym_preproc_include_token1] = ACTIONS(793),
    [aux_sym_preproc_def_token1] = ACTIONS(793),
    [aux_sym_preproc_if_token1] = ACTIONS(793),
    [aux_sym_preproc_if_token2] = ACTIONS(793),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(793),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(793),
    [sym_preproc_directive] = ACTIONS(793),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(498),
    [anon_sym___extension__] = ACTIONS(500),
    [anon_sym_typedef] = ACTIONS(502),
    [anon_sym_extern] = ACTIONS(47),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(37),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym___cdecl] = ACTIONS(793),
    [anon_sym___clrcall] = ACTIONS(793),
    [anon_sym___stdcall] = ACTIONS(793),
    [anon_sym___fastcall] = ACTIONS(793),
    [anon_sym___thiscall] = ACTIONS(793),
    [anon_sym___vectorcall] = ACTIONS(793),
    [anon_sym_LBRACE] = ACTIONS(506),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(508),
    [anon_sym_else] = ACTIONS(793),
    [anon_sym_switch] = ACTIONS(510),
    [anon_sym_case] = ACTIONS(793),
    [anon_sym_default] = ACTIONS(793),
    [anon_sym_while] = ACTIONS(516),
    [anon_sym_do] = ACTIONS(518),
    [anon_sym_for] = ACTIONS(520),
    [anon_sym_return] = ACTIONS(522),
    [anon_sym_break] = ACTIONS(524),
    [anon_sym_continue] = ACTIONS(526),
    [anon_sym_goto] = ACTIONS(528),
    [anon_sym___try] = ACTIONS(530),
    [anon_sym___leave] = ACTIONS(532),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(161),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(163),
    [sym_false] = ACTIONS(163),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [61] = {
    [sym_declaration] = STATE(61),
    [sym_type_definition] = STATE(61),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1152),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_compound_statement] = STATE(61),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(727),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(61),
    [sym_labeled_statement] = STATE(61),
    [sym_expression_statement] = STATE(61),
    [sym_if_statement] = STATE(61),
    [sym_switch_statement] = STATE(61),
    [sym_while_statement] = STATE(61),
    [sym_do_statement] = STATE(61),
    [sym_for_statement] = STATE(61),
    [sym_return_statement] = STATE(61),
    [sym_break_statement] = STATE(61),
    [sym_continue_statement] = STATE(61),
    [sym_goto_statement] = STATE(61),
    [sym_seh_try_statement] = STATE(61),
    [sym_seh_leave_statement] = STATE(61),
    [sym_expression] = STATE(1052),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1858),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(378),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [aux_sym_case_statement_repeat1] = STATE(61),
    [sym_identifier] = ACTIONS(995),
    [aux_sym_preproc_include_token1] = ACTIONS(800),
    [aux_sym_preproc_def_token1] = ACTIONS(800),
    [aux_sym_preproc_if_token1] = ACTIONS(800),
    [aux_sym_preproc_if_token2] = ACTIONS(800),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(800),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(800),
    [sym_preproc_directive] = ACTIONS(800),
    [anon_sym_LPAREN2] = ACTIONS(802),
    [anon_sym_BANG] = ACTIONS(805),
    [anon_sym_TILDE] = ACTIONS(805),
    [anon_sym_DASH] = ACTIONS(808),
    [anon_sym_PLUS] = ACTIONS(808),
    [anon_sym_STAR] = ACTIONS(811),
    [anon_sym_AMP] = ACTIONS(811),
    [anon_sym_SEMI] = ACTIONS(998),
    [anon_sym___extension__] = ACTIONS(1001),
    [anon_sym_typedef] = ACTIONS(1004),
    [anon_sym_extern] = ACTIONS(823),
    [anon_sym___attribute__] = ACTIONS(826),
    [anon_sym___attribute] = ACTIONS(826),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(829),
    [anon_sym___declspec] = ACTIONS(832),
    [anon_sym___cdecl] = ACTIONS(800),
    [anon_sym___clrcall] = ACTIONS(800),
    [anon_sym___stdcall] = ACTIONS(800),
    [anon_sym___fastcall] = ACTIONS(800),
    [anon_sym___thiscall] = ACTIONS(800),
    [anon_sym___vectorcall] = ACTIONS(800),
    [anon_sym_LBRACE] = ACTIONS(1007),
    [anon_sym_signed] = ACTIONS(838),
    [anon_sym_unsigned] = ACTIONS(838),
    [anon_sym_long] = ACTIONS(838),
    [anon_sym_short] = ACTIONS(838),
    [anon_sym_static] = ACTIONS(823),
    [anon_sym_auto] = ACTIONS(823),
    [anon_sym_register] = ACTIONS(823),
    [anon_sym_inline] = ACTIONS(823),
    [anon_sym___inline] = ACTIONS(823),
    [anon_sym___inline__] = ACTIONS(823),
    [anon_sym___forceinline] = ACTIONS(823),
    [anon_sym_thread_local] = ACTIONS(823),
    [anon_sym___thread] = ACTIONS(823),
    [anon_sym_const] = ACTIONS(841),
    [anon_sym_constexpr] = ACTIONS(841),
    [anon_sym_volatile] = ACTIONS(841),
    [anon_sym_restrict] = ACTIONS(841),
    [anon_sym___restrict__] = ACTIONS(841),
    [anon_sym__Atomic] = ACTIONS(841),
    [anon_sym__Noreturn] = ACTIONS(841),
    [anon_sym_noreturn] = ACTIONS(841),
    [anon_sym__Nonnull] = ACTIONS(841),
    [anon_sym_alignas] = ACTIONS(844),
    [anon_sym__Alignas] = ACTIONS(844),
    [sym_primitive_type] = ACTIONS(847),
    [anon_sym_enum] = ACTIONS(850),
    [anon_sym_struct] = ACTIONS(853),
    [anon_sym_union] = ACTIONS(856),
    [anon_sym_if] = ACTIONS(1010),
    [anon_sym_else] = ACTIONS(800),
    [anon_sym_switch] = ACTIONS(1013),
    [anon_sym_case] = ACTIONS(800),
    [anon_sym_default] = ACTIONS(800),
    [anon_sym_while] = ACTIONS(1016),
    [anon_sym_do] = ACTIONS(1019),
    [anon_sym_for] = ACTIONS(1022),
    [anon_sym_return] = ACTIONS(1025),
    [anon_sym_break] = ACTIONS(1028),
    [anon_sym_continue] = ACTIONS(1031),
    [anon_sym_goto] = ACTIONS(1034),
    [anon_sym___try] = ACTIONS(1037),
    [anon_sym___leave] = ACTIONS(1040),
    [anon_sym_DASH_DASH] = ACTIONS(892),
    [anon_sym_PLUS_PLUS] = ACTIONS(892),
    [anon_sym_sizeof] = ACTIONS(895),
    [anon_sym___alignof__] = ACTIONS(898),
    [anon_sym___alignof] = ACTIONS(898),
    [anon_sym__alignof] = ACTIONS(898),
    [anon_sym_alignof] = ACTIONS(898),
    [anon_sym__Alignof] = ACTIONS(898),
    [anon_sym_offsetof] = ACTIONS(901),
    [anon_sym__Generic] = ACTIONS(904),
    [anon_sym_asm] = ACTIONS(907),
    [anon_sym___asm__] = ACTIONS(907),
    [anon_sym___asm] = ACTIONS(907),
    [sym_number_literal] = ACTIONS(910),
    [anon_sym_L_SQUOTE] = ACTIONS(913),
    [anon_sym_u_SQUOTE] = ACTIONS(913),
    [anon_sym_U_SQUOTE] = ACTIONS(913),
    [anon_sym_u8_SQUOTE] = ACTIONS(913),
    [anon_sym_SQUOTE] = ACTIONS(913),
    [anon_sym_L_DQUOTE] = ACTIONS(916),
    [anon_sym_u_DQUOTE] = ACTIONS(916),
    [anon_sym_U_DQUOTE] = ACTIONS(916),
    [anon_sym_u8_DQUOTE] = ACTIONS(916),
    [anon_sym_DQUOTE] = ACTIONS(916),
    [sym_true] = ACTIONS(919),
    [sym_false] = ACTIONS(919),
    [anon_sym_NULL] = ACTIONS(922),
    [anon_sym_nullptr] = ACTIONS(922),
    [sym_comment] = ACTIONS(3),
  },
  [62] = {
    [sym_declaration] = STATE(63),
    [sym_type_definition] = STATE(63),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1154),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_compound_statement] = STATE(63),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(727),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(63),
    [sym_labeled_statement] = STATE(63),
    [sym_expression_statement] = STATE(63),
    [sym_if_statement] = STATE(63),
    [sym_switch_statement] = STATE(63),
    [sym_while_statement] = STATE(63),
    [sym_do_statement] = STATE(63),
    [sym_for_statement] = STATE(63),
    [sym_return_statement] = STATE(63),
    [sym_break_statement] = STATE(63),
    [sym_continue_statement] = STATE(63),
    [sym_goto_statement] = STATE(63),
    [sym_seh_try_statement] = STATE(63),
    [sym_seh_leave_statement] = STATE(63),
    [sym_expression] = STATE(1074),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1913),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(375),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [aux_sym_case_statement_repeat1] = STATE(63),
    [ts_builtin_sym_end] = ACTIONS(941),
    [sym_identifier] = ACTIONS(927),
    [aux_sym_preproc_include_token1] = ACTIONS(789),
    [aux_sym_preproc_def_token1] = ACTIONS(789),
    [aux_sym_preproc_if_token1] = ACTIONS(789),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(789),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(789),
    [sym_preproc_directive] = ACTIONS(789),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(929),
    [anon_sym___extension__] = ACTIONS(29),
    [anon_sym_typedef] = ACTIONS(31),
    [anon_sym_extern] = ACTIONS(47),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(37),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym___cdecl] = ACTIONS(789),
    [anon_sym___clrcall] = ACTIONS(789),
    [anon_sym___stdcall] = ACTIONS(789),
    [anon_sym___fastcall] = ACTIONS(789),
    [anon_sym___thiscall] = ACTIONS(789),
    [anon_sym___vectorcall] = ACTIONS(789),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(61),
    [anon_sym_else] = ACTIONS(789),
    [anon_sym_switch] = ACTIONS(63),
    [anon_sym_case] = ACTIONS(789),
    [anon_sym_default] = ACTIONS(789),
    [anon_sym_while] = ACTIONS(69),
    [anon_sym_do] = ACTIONS(71),
    [anon_sym_for] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_break] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(79),
    [anon_sym_goto] = ACTIONS(81),
    [anon_sym___try] = ACTIONS(931),
    [anon_sym___leave] = ACTIONS(933),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(161),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(163),
    [sym_false] = ACTIONS(163),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [63] = {
    [sym_declaration] = STATE(64),
    [sym_type_definition] = STATE(64),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1154),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_compound_statement] = STATE(64),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(727),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(64),
    [sym_labeled_statement] = STATE(64),
    [sym_expression_statement] = STATE(64),
    [sym_if_statement] = STATE(64),
    [sym_switch_statement] = STATE(64),
    [sym_while_statement] = STATE(64),
    [sym_do_statement] = STATE(64),
    [sym_for_statement] = STATE(64),
    [sym_return_statement] = STATE(64),
    [sym_break_statement] = STATE(64),
    [sym_continue_statement] = STATE(64),
    [sym_goto_statement] = STATE(64),
    [sym_seh_try_statement] = STATE(64),
    [sym_seh_leave_statement] = STATE(64),
    [sym_expression] = STATE(1074),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1913),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(375),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [aux_sym_case_statement_repeat1] = STATE(64),
    [ts_builtin_sym_end] = ACTIONS(939),
    [sym_identifier] = ACTIONS(927),
    [aux_sym_preproc_include_token1] = ACTIONS(793),
    [aux_sym_preproc_def_token1] = ACTIONS(793),
    [aux_sym_preproc_if_token1] = ACTIONS(793),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(793),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(793),
    [sym_preproc_directive] = ACTIONS(793),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(929),
    [anon_sym___extension__] = ACTIONS(29),
    [anon_sym_typedef] = ACTIONS(31),
    [anon_sym_extern] = ACTIONS(47),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(37),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym___cdecl] = ACTIONS(793),
    [anon_sym___clrcall] = ACTIONS(793),
    [anon_sym___stdcall] = ACTIONS(793),
    [anon_sym___fastcall] = ACTIONS(793),
    [anon_sym___thiscall] = ACTIONS(793),
    [anon_sym___vectorcall] = ACTIONS(793),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(61),
    [anon_sym_else] = ACTIONS(793),
    [anon_sym_switch] = ACTIONS(63),
    [anon_sym_case] = ACTIONS(793),
    [anon_sym_default] = ACTIONS(793),
    [anon_sym_while] = ACTIONS(69),
    [anon_sym_do] = ACTIONS(71),
    [anon_sym_for] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_break] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(79),
    [anon_sym_goto] = ACTIONS(81),
    [anon_sym___try] = ACTIONS(931),
    [anon_sym___leave] = ACTIONS(933),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(161),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(163),
    [sym_false] = ACTIONS(163),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [64] = {
    [sym_declaration] = STATE(64),
    [sym_type_definition] = STATE(64),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1154),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_compound_statement] = STATE(64),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(727),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(64),
    [sym_labeled_statement] = STATE(64),
    [sym_expression_statement] = STATE(64),
    [sym_if_statement] = STATE(64),
    [sym_switch_statement] = STATE(64),
    [sym_while_statement] = STATE(64),
    [sym_do_statement] = STATE(64),
    [sym_for_statement] = STATE(64),
    [sym_return_statement] = STATE(64),
    [sym_break_statement] = STATE(64),
    [sym_continue_statement] = STATE(64),
    [sym_goto_statement] = STATE(64),
    [sym_seh_try_statement] = STATE(64),
    [sym_seh_leave_statement] = STATE(64),
    [sym_expression] = STATE(1074),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1913),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(375),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [aux_sym_case_statement_repeat1] = STATE(64),
    [ts_builtin_sym_end] = ACTIONS(958),
    [sym_identifier] = ACTIONS(1043),
    [aux_sym_preproc_include_token1] = ACTIONS(800),
    [aux_sym_preproc_def_token1] = ACTIONS(800),
    [aux_sym_preproc_if_token1] = ACTIONS(800),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(800),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(800),
    [sym_preproc_directive] = ACTIONS(800),
    [anon_sym_LPAREN2] = ACTIONS(802),
    [anon_sym_BANG] = ACTIONS(805),
    [anon_sym_TILDE] = ACTIONS(805),
    [anon_sym_DASH] = ACTIONS(808),
    [anon_sym_PLUS] = ACTIONS(808),
    [anon_sym_STAR] = ACTIONS(811),
    [anon_sym_AMP] = ACTIONS(811),
    [anon_sym_SEMI] = ACTIONS(1046),
    [anon_sym___extension__] = ACTIONS(1049),
    [anon_sym_typedef] = ACTIONS(1052),
    [anon_sym_extern] = ACTIONS(823),
    [anon_sym___attribute__] = ACTIONS(826),
    [anon_sym___attribute] = ACTIONS(826),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(829),
    [anon_sym___declspec] = ACTIONS(832),
    [anon_sym___cdecl] = ACTIONS(800),
    [anon_sym___clrcall] = ACTIONS(800),
    [anon_sym___stdcall] = ACTIONS(800),
    [anon_sym___fastcall] = ACTIONS(800),
    [anon_sym___thiscall] = ACTIONS(800),
    [anon_sym___vectorcall] = ACTIONS(800),
    [anon_sym_LBRACE] = ACTIONS(1055),
    [anon_sym_signed] = ACTIONS(838),
    [anon_sym_unsigned] = ACTIONS(838),
    [anon_sym_long] = ACTIONS(838),
    [anon_sym_short] = ACTIONS(838),
    [anon_sym_static] = ACTIONS(823),
    [anon_sym_auto] = ACTIONS(823),
    [anon_sym_register] = ACTIONS(823),
    [anon_sym_inline] = ACTIONS(823),
    [anon_sym___inline] = ACTIONS(823),
    [anon_sym___inline__] = ACTIONS(823),
    [anon_sym___forceinline] = ACTIONS(823),
    [anon_sym_thread_local] = ACTIONS(823),
    [anon_sym___thread] = ACTIONS(823),
    [anon_sym_const] = ACTIONS(841),
    [anon_sym_constexpr] = ACTIONS(841),
    [anon_sym_volatile] = ACTIONS(841),
    [anon_sym_restrict] = ACTIONS(841),
    [anon_sym___restrict__] = ACTIONS(841),
    [anon_sym__Atomic] = ACTIONS(841),
    [anon_sym__Noreturn] = ACTIONS(841),
    [anon_sym_noreturn] = ACTIONS(841),
    [anon_sym__Nonnull] = ACTIONS(841),
    [anon_sym_alignas] = ACTIONS(844),
    [anon_sym__Alignas] = ACTIONS(844),
    [sym_primitive_type] = ACTIONS(847),
    [anon_sym_enum] = ACTIONS(850),
    [anon_sym_struct] = ACTIONS(853),
    [anon_sym_union] = ACTIONS(856),
    [anon_sym_if] = ACTIONS(1058),
    [anon_sym_else] = ACTIONS(800),
    [anon_sym_switch] = ACTIONS(1061),
    [anon_sym_case] = ACTIONS(800),
    [anon_sym_default] = ACTIONS(800),
    [anon_sym_while] = ACTIONS(1064),
    [anon_sym_do] = ACTIONS(1067),
    [anon_sym_for] = ACTIONS(1070),
    [anon_sym_return] = ACTIONS(1073),
    [anon_sym_break] = ACTIONS(1076),
    [anon_sym_continue] = ACTIONS(1079),
    [anon_sym_goto] = ACTIONS(1082),
    [anon_sym___try] = ACTIONS(1085),
    [anon_sym___leave] = ACTIONS(1088),
    [anon_sym_DASH_DASH] = ACTIONS(892),
    [anon_sym_PLUS_PLUS] = ACTIONS(892),
    [anon_sym_sizeof] = ACTIONS(895),
    [anon_sym___alignof__] = ACTIONS(898),
    [anon_sym___alignof] = ACTIONS(898),
    [anon_sym__alignof] = ACTIONS(898),
    [anon_sym_alignof] = ACTIONS(898),
    [anon_sym__Alignof] = ACTIONS(898),
    [anon_sym_offsetof] = ACTIONS(901),
    [anon_sym__Generic] = ACTIONS(904),
    [anon_sym_asm] = ACTIONS(907),
    [anon_sym___asm__] = ACTIONS(907),
    [anon_sym___asm] = ACTIONS(907),
    [sym_number_literal] = ACTIONS(910),
    [anon_sym_L_SQUOTE] = ACTIONS(913),
    [anon_sym_u_SQUOTE] = ACTIONS(913),
    [anon_sym_U_SQUOTE] = ACTIONS(913),
    [anon_sym_u8_SQUOTE] = ACTIONS(913),
    [anon_sym_SQUOTE] = ACTIONS(913),
    [anon_sym_L_DQUOTE] = ACTIONS(916),
    [anon_sym_u_DQUOTE] = ACTIONS(916),
    [anon_sym_U_DQUOTE] = ACTIONS(916),
    [anon_sym_u8_DQUOTE] = ACTIONS(916),
    [anon_sym_DQUOTE] = ACTIONS(916),
    [sym_true] = ACTIONS(919),
    [sym_false] = ACTIONS(919),
    [anon_sym_NULL] = ACTIONS(922),
    [anon_sym_nullptr] = ACTIONS(922),
    [sym_comment] = ACTIONS(3),
  },
  [65] = {
    [sym_declaration] = STATE(192),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1158),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_compound_statement] = STATE(250),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(727),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(250),
    [sym_statement] = STATE(192),
    [sym_labeled_statement] = STATE(250),
    [sym_expression_statement] = STATE(250),
    [sym_if_statement] = STATE(250),
    [sym_switch_statement] = STATE(250),
    [sym_case_statement] = STATE(250),
    [sym_while_statement] = STATE(250),
    [sym_do_statement] = STATE(250),
    [sym_for_statement] = STATE(250),
    [sym_return_statement] = STATE(250),
    [sym_break_statement] = STATE(250),
    [sym_continue_statement] = STATE(250),
    [sym_goto_statement] = STATE(250),
    [sym_seh_try_statement] = STATE(250),
    [sym_seh_leave_statement] = STATE(250),
    [sym_expression] = STATE(1071),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1906),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(349),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [sym_identifier] = ACTIONS(937),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(370),
    [anon_sym___extension__] = ACTIONS(1091),
    [anon_sym_extern] = ACTIONS(47),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(37),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(378),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(382),
    [anon_sym_switch] = ACTIONS(384),
    [anon_sym_case] = ACTIONS(386),
    [anon_sym_default] = ACTIONS(388),
    [anon_sym_while] = ACTIONS(390),
    [anon_sym_do] = ACTIONS(392),
    [anon_sym_for] = ACTIONS(394),
    [anon_sym_return] = ACTIONS(396),
    [anon_sym_break] = ACTIONS(398),
    [anon_sym_continue] = ACTIONS(400),
    [anon_sym_goto] = ACTIONS(402),
    [anon_sym___try] = ACTIONS(404),
    [anon_sym___leave] = ACTIONS(406),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(161),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(163),
    [sym_false] = ACTIONS(163),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [66] = {
    [sym_declaration] = STATE(85),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1149),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_compound_statement] = STATE(110),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(727),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(110),
    [sym_statement] = STATE(85),
    [sym_labeled_statement] = STATE(110),
    [sym_expression_statement] = STATE(110),
    [sym_if_statement] = STATE(110),
    [sym_switch_statement] = STATE(110),
    [sym_case_statement] = STATE(110),
    [sym_while_statement] = STATE(110),
    [sym_do_statement] = STATE(110),
    [sym_for_statement] = STATE(110),
    [sym_return_statement] = STATE(110),
    [sym_break_statement] = STATE(110),
    [sym_continue_statement] = STATE(110),
    [sym_goto_statement] = STATE(110),
    [sym_seh_try_statement] = STATE(110),
    [sym_seh_leave_statement] = STATE(110),
    [sym_expression] = STATE(1049),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1950),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(373),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [sym_identifier] = ACTIONS(787),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(125),
    [anon_sym___extension__] = ACTIONS(1091),
    [anon_sym_extern] = ACTIONS(47),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(37),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(133),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(135),
    [anon_sym_switch] = ACTIONS(137),
    [anon_sym_case] = ACTIONS(139),
    [anon_sym_default] = ACTIONS(141),
    [anon_sym_while] = ACTIONS(143),
    [anon_sym_do] = ACTIONS(145),
    [anon_sym_for] = ACTIONS(147),
    [anon_sym_return] = ACTIONS(149),
    [anon_sym_break] = ACTIONS(151),
    [anon_sym_continue] = ACTIONS(153),
    [anon_sym_goto] = ACTIONS(155),
    [anon_sym___try] = ACTIONS(157),
    [anon_sym___leave] = ACTIONS(159),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(161),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(163),
    [sym_false] = ACTIONS(163),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [67] = {
    [sym_declaration] = STATE(70),
    [sym_type_definition] = STATE(70),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1154),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_compound_statement] = STATE(70),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(727),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(70),
    [sym_labeled_statement] = STATE(70),
    [sym_expression_statement] = STATE(70),
    [sym_if_statement] = STATE(70),
    [sym_switch_statement] = STATE(70),
    [sym_while_statement] = STATE(70),
    [sym_do_statement] = STATE(70),
    [sym_for_statement] = STATE(70),
    [sym_return_statement] = STATE(70),
    [sym_break_statement] = STATE(70),
    [sym_continue_statement] = STATE(70),
    [sym_goto_statement] = STATE(70),
    [sym_seh_try_statement] = STATE(70),
    [sym_seh_leave_statement] = STATE(70),
    [sym_expression] = STATE(1071),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1906),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(361),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [aux_sym_case_statement_repeat1] = STATE(70),
    [sym_identifier] = ACTIONS(1093),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(370),
    [anon_sym___extension__] = ACTIONS(29),
    [anon_sym_typedef] = ACTIONS(31),
    [anon_sym_extern] = ACTIONS(47),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(37),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(1095),
    [anon_sym_else] = ACTIONS(791),
    [anon_sym_switch] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(1097),
    [anon_sym_do] = ACTIONS(71),
    [anon_sym_for] = ACTIONS(1099),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_break] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(79),
    [anon_sym_goto] = ACTIONS(81),
    [anon_sym___try] = ACTIONS(1101),
    [anon_sym___leave] = ACTIONS(406),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(161),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(163),
    [sym_false] = ACTIONS(163),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [68] = {
    [sym_declaration] = STATE(227),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1154),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_compound_statement] = STATE(250),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(727),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(250),
    [sym_statement] = STATE(227),
    [sym_labeled_statement] = STATE(250),
    [sym_expression_statement] = STATE(250),
    [sym_if_statement] = STATE(250),
    [sym_switch_statement] = STATE(250),
    [sym_case_statement] = STATE(250),
    [sym_while_statement] = STATE(250),
    [sym_do_statement] = STATE(250),
    [sym_for_statement] = STATE(250),
    [sym_return_statement] = STATE(250),
    [sym_break_statement] = STATE(250),
    [sym_continue_statement] = STATE(250),
    [sym_goto_statement] = STATE(250),
    [sym_seh_try_statement] = STATE(250),
    [sym_seh_leave_statement] = STATE(250),
    [sym_expression] = STATE(1071),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1906),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(361),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [sym_identifier] = ACTIONS(1093),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(370),
    [anon_sym___extension__] = ACTIONS(1091),
    [anon_sym_extern] = ACTIONS(47),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(37),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(1095),
    [anon_sym_switch] = ACTIONS(63),
    [anon_sym_case] = ACTIONS(1103),
    [anon_sym_default] = ACTIONS(1105),
    [anon_sym_while] = ACTIONS(1097),
    [anon_sym_do] = ACTIONS(71),
    [anon_sym_for] = ACTIONS(1099),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_break] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(79),
    [anon_sym_goto] = ACTIONS(81),
    [anon_sym___try] = ACTIONS(1101),
    [anon_sym___leave] = ACTIONS(406),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(161),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(163),
    [sym_false] = ACTIONS(163),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [69] = {
    [sym_declaration] = STATE(71),
    [sym_type_definition] = STATE(71),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1154),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_compound_statement] = STATE(71),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(727),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(71),
    [sym_labeled_statement] = STATE(71),
    [sym_expression_statement] = STATE(71),
    [sym_if_statement] = STATE(71),
    [sym_switch_statement] = STATE(71),
    [sym_while_statement] = STATE(71),
    [sym_do_statement] = STATE(71),
    [sym_for_statement] = STATE(71),
    [sym_return_statement] = STATE(71),
    [sym_break_statement] = STATE(71),
    [sym_continue_statement] = STATE(71),
    [sym_goto_statement] = STATE(71),
    [sym_seh_try_statement] = STATE(71),
    [sym_seh_leave_statement] = STATE(71),
    [sym_expression] = STATE(1071),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1906),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(361),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [aux_sym_case_statement_repeat1] = STATE(71),
    [sym_identifier] = ACTIONS(1093),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(370),
    [anon_sym___extension__] = ACTIONS(29),
    [anon_sym_typedef] = ACTIONS(31),
    [anon_sym_extern] = ACTIONS(47),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(37),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(1095),
    [anon_sym_else] = ACTIONS(789),
    [anon_sym_switch] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(1097),
    [anon_sym_do] = ACTIONS(71),
    [anon_sym_for] = ACTIONS(1099),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_break] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(79),
    [anon_sym_goto] = ACTIONS(81),
    [anon_sym___try] = ACTIONS(1101),
    [anon_sym___leave] = ACTIONS(406),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(161),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(163),
    [sym_false] = ACTIONS(163),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [70] = {
    [sym_declaration] = STATE(72),
    [sym_type_definition] = STATE(72),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1154),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_compound_statement] = STATE(72),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(727),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(72),
    [sym_labeled_statement] = STATE(72),
    [sym_expression_statement] = STATE(72),
    [sym_if_statement] = STATE(72),
    [sym_switch_statement] = STATE(72),
    [sym_while_statement] = STATE(72),
    [sym_do_statement] = STATE(72),
    [sym_for_statement] = STATE(72),
    [sym_return_statement] = STATE(72),
    [sym_break_statement] = STATE(72),
    [sym_continue_statement] = STATE(72),
    [sym_goto_statement] = STATE(72),
    [sym_seh_try_statement] = STATE(72),
    [sym_seh_leave_statement] = STATE(72),
    [sym_expression] = STATE(1071),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1906),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(361),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [aux_sym_case_statement_repeat1] = STATE(72),
    [sym_identifier] = ACTIONS(1093),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(370),
    [anon_sym___extension__] = ACTIONS(29),
    [anon_sym_typedef] = ACTIONS(31),
    [anon_sym_extern] = ACTIONS(47),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(37),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(1095),
    [anon_sym_else] = ACTIONS(795),
    [anon_sym_switch] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(1097),
    [anon_sym_do] = ACTIONS(71),
    [anon_sym_for] = ACTIONS(1099),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_break] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(79),
    [anon_sym_goto] = ACTIONS(81),
    [anon_sym___try] = ACTIONS(1101),
    [anon_sym___leave] = ACTIONS(406),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(161),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(163),
    [sym_false] = ACTIONS(163),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [71] = {
    [sym_declaration] = STATE(72),
    [sym_type_definition] = STATE(72),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1154),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_compound_statement] = STATE(72),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(727),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(72),
    [sym_labeled_statement] = STATE(72),
    [sym_expression_statement] = STATE(72),
    [sym_if_statement] = STATE(72),
    [sym_switch_statement] = STATE(72),
    [sym_while_statement] = STATE(72),
    [sym_do_statement] = STATE(72),
    [sym_for_statement] = STATE(72),
    [sym_return_statement] = STATE(72),
    [sym_break_statement] = STATE(72),
    [sym_continue_statement] = STATE(72),
    [sym_goto_statement] = STATE(72),
    [sym_seh_try_statement] = STATE(72),
    [sym_seh_leave_statement] = STATE(72),
    [sym_expression] = STATE(1071),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1906),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(361),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [aux_sym_case_statement_repeat1] = STATE(72),
    [sym_identifier] = ACTIONS(1093),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(370),
    [anon_sym___extension__] = ACTIONS(29),
    [anon_sym_typedef] = ACTIONS(31),
    [anon_sym_extern] = ACTIONS(47),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(37),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(1095),
    [anon_sym_else] = ACTIONS(793),
    [anon_sym_switch] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(1097),
    [anon_sym_do] = ACTIONS(71),
    [anon_sym_for] = ACTIONS(1099),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_break] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(79),
    [anon_sym_goto] = ACTIONS(81),
    [anon_sym___try] = ACTIONS(1101),
    [anon_sym___leave] = ACTIONS(406),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(161),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(163),
    [sym_false] = ACTIONS(163),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [72] = {
    [sym_declaration] = STATE(72),
    [sym_type_definition] = STATE(72),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1154),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_compound_statement] = STATE(72),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(727),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(72),
    [sym_labeled_statement] = STATE(72),
    [sym_expression_statement] = STATE(72),
    [sym_if_statement] = STATE(72),
    [sym_switch_statement] = STATE(72),
    [sym_while_statement] = STATE(72),
    [sym_do_statement] = STATE(72),
    [sym_for_statement] = STATE(72),
    [sym_return_statement] = STATE(72),
    [sym_break_statement] = STATE(72),
    [sym_continue_statement] = STATE(72),
    [sym_goto_statement] = STATE(72),
    [sym_seh_try_statement] = STATE(72),
    [sym_seh_leave_statement] = STATE(72),
    [sym_expression] = STATE(1071),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1906),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(361),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [aux_sym_case_statement_repeat1] = STATE(72),
    [sym_identifier] = ACTIONS(1107),
    [anon_sym_LPAREN2] = ACTIONS(802),
    [anon_sym_BANG] = ACTIONS(805),
    [anon_sym_TILDE] = ACTIONS(805),
    [anon_sym_DASH] = ACTIONS(808),
    [anon_sym_PLUS] = ACTIONS(808),
    [anon_sym_STAR] = ACTIONS(811),
    [anon_sym_AMP] = ACTIONS(811),
    [anon_sym_SEMI] = ACTIONS(946),
    [anon_sym___extension__] = ACTIONS(1049),
    [anon_sym_typedef] = ACTIONS(1052),
    [anon_sym_extern] = ACTIONS(823),
    [anon_sym___attribute__] = ACTIONS(826),
    [anon_sym___attribute] = ACTIONS(826),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(829),
    [anon_sym___declspec] = ACTIONS(832),
    [anon_sym_LBRACE] = ACTIONS(1055),
    [anon_sym_signed] = ACTIONS(838),
    [anon_sym_unsigned] = ACTIONS(838),
    [anon_sym_long] = ACTIONS(838),
    [anon_sym_short] = ACTIONS(838),
    [anon_sym_static] = ACTIONS(823),
    [anon_sym_auto] = ACTIONS(823),
    [anon_sym_register] = ACTIONS(823),
    [anon_sym_inline] = ACTIONS(823),
    [anon_sym___inline] = ACTIONS(823),
    [anon_sym___inline__] = ACTIONS(823),
    [anon_sym___forceinline] = ACTIONS(823),
    [anon_sym_thread_local] = ACTIONS(823),
    [anon_sym___thread] = ACTIONS(823),
    [anon_sym_const] = ACTIONS(841),
    [anon_sym_constexpr] = ACTIONS(841),
    [anon_sym_volatile] = ACTIONS(841),
    [anon_sym_restrict] = ACTIONS(841),
    [anon_sym___restrict__] = ACTIONS(841),
    [anon_sym__Atomic] = ACTIONS(841),
    [anon_sym__Noreturn] = ACTIONS(841),
    [anon_sym_noreturn] = ACTIONS(841),
    [anon_sym__Nonnull] = ACTIONS(841),
    [anon_sym_alignas] = ACTIONS(844),
    [anon_sym__Alignas] = ACTIONS(844),
    [sym_primitive_type] = ACTIONS(847),
    [anon_sym_enum] = ACTIONS(850),
    [anon_sym_struct] = ACTIONS(853),
    [anon_sym_union] = ACTIONS(856),
    [anon_sym_if] = ACTIONS(1110),
    [anon_sym_else] = ACTIONS(800),
    [anon_sym_switch] = ACTIONS(1061),
    [anon_sym_while] = ACTIONS(1113),
    [anon_sym_do] = ACTIONS(1067),
    [anon_sym_for] = ACTIONS(1116),
    [anon_sym_return] = ACTIONS(1073),
    [anon_sym_break] = ACTIONS(1076),
    [anon_sym_continue] = ACTIONS(1079),
    [anon_sym_goto] = ACTIONS(1082),
    [anon_sym___try] = ACTIONS(1119),
    [anon_sym___leave] = ACTIONS(990),
    [anon_sym_DASH_DASH] = ACTIONS(892),
    [anon_sym_PLUS_PLUS] = ACTIONS(892),
    [anon_sym_sizeof] = ACTIONS(895),
    [anon_sym___alignof__] = ACTIONS(898),
    [anon_sym___alignof] = ACTIONS(898),
    [anon_sym__alignof] = ACTIONS(898),
    [anon_sym_alignof] = ACTIONS(898),
    [anon_sym__Alignof] = ACTIONS(898),
    [anon_sym_offsetof] = ACTIONS(901),
    [anon_sym__Generic] = ACTIONS(904),
    [anon_sym_asm] = ACTIONS(907),
    [anon_sym___asm__] = ACTIONS(907),
    [anon_sym___asm] = ACTIONS(907),
    [sym_number_literal] = ACTIONS(910),
    [anon_sym_L_SQUOTE] = ACTIONS(913),
    [anon_sym_u_SQUOTE] = ACTIONS(913),
    [anon_sym_U_SQUOTE] = ACTIONS(913),
    [anon_sym_u8_SQUOTE] = ACTIONS(913),
    [anon_sym_SQUOTE] = ACTIONS(913),
    [anon_sym_L_DQUOTE] = ACTIONS(916),
    [anon_sym_u_DQUOTE] = ACTIONS(916),
    [anon_sym_U_DQUOTE] = ACTIONS(916),
    [anon_sym_u8_DQUOTE] = ACTIONS(916),
    [anon_sym_DQUOTE] = ACTIONS(916),
    [sym_true] = ACTIONS(919),
    [sym_false] = ACTIONS(919),
    [anon_sym_NULL] = ACTIONS(922),
    [anon_sym_nullptr] = ACTIONS(922),
    [sym_comment] = ACTIONS(3),
  },
  [73] = {
    [sym_declaration] = STATE(227),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1154),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_compound_statement] = STATE(159),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(727),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(159),
    [sym_statement] = STATE(227),
    [sym_labeled_statement] = STATE(159),
    [sym_expression_statement] = STATE(159),
    [sym_if_statement] = STATE(159),
    [sym_switch_statement] = STATE(159),
    [sym_case_statement] = STATE(159),
    [sym_while_statement] = STATE(159),
    [sym_do_statement] = STATE(159),
    [sym_for_statement] = STATE(159),
    [sym_return_statement] = STATE(159),
    [sym_break_statement] = STATE(159),
    [sym_continue_statement] = STATE(159),
    [sym_goto_statement] = STATE(159),
    [sym_seh_try_statement] = STATE(159),
    [sym_seh_leave_statement] = STATE(159),
    [sym_expression] = STATE(1074),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1913),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(375),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [sym_identifier] = ACTIONS(927),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(929),
    [anon_sym___extension__] = ACTIONS(1091),
    [anon_sym_extern] = ACTIONS(47),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(37),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(61),
    [anon_sym_switch] = ACTIONS(63),
    [anon_sym_case] = ACTIONS(65),
    [anon_sym_default] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(69),
    [anon_sym_do] = ACTIONS(71),
    [anon_sym_for] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_break] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(79),
    [anon_sym_goto] = ACTIONS(81),
    [anon_sym___try] = ACTIONS(931),
    [anon_sym___leave] = ACTIONS(933),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(161),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(163),
    [sym_false] = ACTIONS(163),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [74] = {
    [sym_declaration] = STATE(196),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1152),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(407),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_compound_statement] = STATE(180),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(727),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym_attributed_statement] = STATE(180),
    [sym_statement] = STATE(196),
    [sym_labeled_statement] = STATE(180),
    [sym_expression_statement] = STATE(180),
    [sym_if_statement] = STATE(180),
    [sym_switch_statement] = STATE(180),
    [sym_case_statement] = STATE(180),
    [sym_while_statement] = STATE(180),
    [sym_do_statement] = STATE(180),
    [sym_for_statement] = STATE(180),
    [sym_return_statement] = STATE(180),
    [sym_break_statement] = STATE(180),
    [sym_continue_statement] = STATE(180),
    [sym_goto_statement] = STATE(180),
    [sym_seh_try_statement] = STATE(180),
    [sym_seh_leave_statement] = STATE(180),
    [sym_expression] = STATE(1052),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1858),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_attributed_declarator_repeat1] = STATE(378),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [sym_identifier] = ACTIONS(993),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(498),
    [anon_sym___extension__] = ACTIONS(1091),
    [anon_sym_extern] = ACTIONS(47),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(37),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(506),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_if] = ACTIONS(508),
    [anon_sym_switch] = ACTIONS(510),
    [anon_sym_case] = ACTIONS(512),
    [anon_sym_default] = ACTIONS(514),
    [anon_sym_while] = ACTIONS(516),
    [anon_sym_do] = ACTIONS(518),
    [anon_sym_for] = ACTIONS(520),
    [anon_sym_return] = ACTIONS(522),
    [anon_sym_break] = ACTIONS(524),
    [anon_sym_continue] = ACTIONS(526),
    [anon_sym_goto] = ACTIONS(528),
    [anon_sym___try] = ACTIONS(530),
    [anon_sym___leave] = ACTIONS(532),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(161),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(163),
    [sym_false] = ACTIONS(163),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [75] = {
    [sym_declaration] = STATE(491),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1160),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(710),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(727),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym__for_statement_body] = STATE(1874),
    [sym_expression] = STATE(1058),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1837),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [sym_identifier] = ACTIONS(1122),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(1124),
    [anon_sym___extension__] = ACTIONS(1091),
    [anon_sym_extern] = ACTIONS(47),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1126),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(161),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(163),
    [sym_false] = ACTIONS(163),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [76] = {
    [sym_declaration] = STATE(491),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1160),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(710),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(727),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym__for_statement_body] = STATE(1995),
    [sym_expression] = STATE(1058),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1837),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [sym_identifier] = ACTIONS(1122),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(1124),
    [anon_sym___extension__] = ACTIONS(1091),
    [anon_sym_extern] = ACTIONS(47),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1126),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(161),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(163),
    [sym_false] = ACTIONS(163),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [77] = {
    [sym_declaration] = STATE(491),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1160),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(710),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(727),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym__for_statement_body] = STATE(1815),
    [sym_expression] = STATE(1058),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1837),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [sym_identifier] = ACTIONS(1122),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(1124),
    [anon_sym___extension__] = ACTIONS(1091),
    [anon_sym_extern] = ACTIONS(47),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1126),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(161),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(163),
    [sym_false] = ACTIONS(163),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [78] = {
    [sym_declaration] = STATE(491),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1160),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(710),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(727),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym__for_statement_body] = STATE(1937),
    [sym_expression] = STATE(1058),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1837),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [sym_identifier] = ACTIONS(1122),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(1124),
    [anon_sym___extension__] = ACTIONS(1091),
    [anon_sym_extern] = ACTIONS(47),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1126),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(161),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(163),
    [sym_false] = ACTIONS(163),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [79] = {
    [sym_declaration] = STATE(491),
    [sym__declaration_modifiers] = STATE(710),
    [sym__declaration_specifiers] = STATE(1160),
    [sym_attribute_specifier] = STATE(710),
    [sym_attribute_declaration] = STATE(710),
    [sym_ms_declspec_modifier] = STATE(710),
    [sym_storage_class_specifier] = STATE(710),
    [sym_type_qualifier] = STATE(710),
    [sym_alignas_qualifier] = STATE(720),
    [sym_type_specifier] = STATE(727),
    [sym_sized_type_specifier] = STATE(772),
    [sym_enum_specifier] = STATE(772),
    [sym_struct_specifier] = STATE(772),
    [sym_union_specifier] = STATE(772),
    [sym__for_statement_body] = STATE(1838),
    [sym_expression] = STATE(1058),
    [sym__string] = STATE(693),
    [sym_comma_expression] = STATE(1837),
    [sym_conditional_expression] = STATE(693),
    [sym_assignment_expression] = STATE(693),
    [sym_pointer_expression] = STATE(843),
    [sym_unary_expression] = STATE(693),
    [sym_binary_expression] = STATE(693),
    [sym_update_expression] = STATE(693),
    [sym_cast_expression] = STATE(693),
    [sym_sizeof_expression] = STATE(693),
    [sym_alignof_expression] = STATE(693),
    [sym_offsetof_expression] = STATE(693),
    [sym_generic_expression] = STATE(693),
    [sym_subscript_expression] = STATE(843),
    [sym_call_expression] = STATE(843),
    [sym_gnu_asm_expression] = STATE(693),
    [sym_extension_expression] = STATE(693),
    [sym_field_expression] = STATE(843),
    [sym_compound_literal_expression] = STATE(693),
    [sym_parenthesized_expression] = STATE(843),
    [sym_char_literal] = STATE(693),
    [sym_concatenated_string] = STATE(693),
    [sym_string_literal] = STATE(673),
    [sym_null] = STATE(693),
    [sym_macro_type_specifier] = STATE(772),
    [aux_sym__declaration_specifiers_repeat1] = STATE(710),
    [aux_sym_sized_type_specifier_repeat1] = STATE(722),
    [sym_identifier] = ACTIONS(1122),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_AMP] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(1124),
    [anon_sym___extension__] = ACTIONS(1091),
    [anon_sym_extern] = ACTIONS(47),
    [anon_sym___attribute__] = ACTIONS(35),
    [anon_sym___attribute] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1126),
    [anon_sym___declspec] = ACTIONS(39),
    [anon_sym_signed] = ACTIONS(45),
    [anon_sym_unsigned] = ACTIONS(45),
    [anon_sym_long] = ACTIONS(45),
    [anon_sym_short] = ACTIONS(45),
    [anon_sym_static] = ACTIONS(47),
    [anon_sym_auto] = ACTIONS(47),
    [anon_sym_register] = ACTIONS(47),
    [anon_sym_inline] = ACTIONS(47),
    [anon_sym___inline] = ACTIONS(47),
    [anon_sym___inline__] = ACTIONS(47),
    [anon_sym___forceinline] = ACTIONS(47),
    [anon_sym_thread_local] = ACTIONS(47),
    [anon_sym___thread] = ACTIONS(47),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_constexpr] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_restrict] = ACTIONS(49),
    [anon_sym___restrict__] = ACTIONS(49),
    [anon_sym__Atomic] = ACTIONS(49),
    [anon_sym__Noreturn] = ACTIONS(49),
    [anon_sym_noreturn] = ACTIONS(49),
    [anon_sym__Nonnull] = ACTIONS(49),
    [anon_sym_alignas] = ACTIONS(51),
    [anon_sym__Alignas] = ACTIONS(51),
    [sym_primitive_type] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_struct] = ACTIONS(57),
    [anon_sym_union] = ACTIONS(59),
    [anon_sym_DASH_DASH] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(83),
    [anon_sym_sizeof] = ACTIONS(85),
    [anon_sym___alignof__] = ACTIONS(87),
    [anon_sym___alignof] = ACTIONS(87),
    [anon_sym__alignof] = ACTIONS(87),
    [anon_sym_alignof] = ACTIONS(87),
    [anon_sym__Alignof] = ACTIONS(87),
    [anon_sym_offsetof] = ACTIONS(89),
    [anon_sym__Generic] = ACTIONS(91),
    [anon_sym_asm] = ACTIONS(93),
    [anon_sym___asm__] = ACTIONS(93),
    [anon_sym___asm] = ACTIONS(93),
    [sym_number_literal] = ACTIONS(161),
    [anon_sym_L_SQUOTE] = ACTIONS(97),
    [anon_sym_u_SQUOTE] = ACTIONS(97),
    [anon_sym_U_SQUOTE] = ACTIONS(97),
    [anon_sym_u8_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [anon_sym_L_DQUOTE] = ACTIONS(99),
    [anon_sym_u_DQUOTE] = ACTIONS(99),
    [anon_sym_U_DQUOTE] = ACTIONS(99),
    [anon_sym_u8_DQUOTE] = ACTIONS(99),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_true] = ACTIONS(163),
    [sym_false] = ACTIONS(163),
    [anon_sym_NULL] = ACTIONS(103),
    [anon_sym_nullptr] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [80] = {
    [sym_else_clause] = STATE(90),
    [sym_identifier] = ACTIONS(1128),
    [aux_sym_preproc_include_token1] = ACTIONS(1128),
    [aux_sym_preproc_def_token1] = ACTIONS(1128),
    [aux_sym_preproc_if_token1] = ACTIONS(1128),
    [aux_sym_preproc_if_token2] = ACTIONS(1128),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1128),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1128),
    [aux_sym_preproc_else_token1] = ACTIONS(1128),
    [aux_sym_preproc_elif_token1] = ACTIONS(1128),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1128),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1128),
    [sym_preproc_directive] = ACTIONS(1128),
    [anon_sym_LPAREN2] = ACTIONS(1130),
    [anon_sym_BANG] = ACTIONS(1130),
    [anon_sym_TILDE] = ACTIONS(1130),
    [anon_sym_DASH] = ACTIONS(1128),
    [anon_sym_PLUS] = ACTIONS(1128),
    [anon_sym_STAR] = ACTIONS(1130),
    [anon_sym_AMP] = ACTIONS(1130),
    [anon_sym_SEMI] = ACTIONS(1130),
    [anon_sym___extension__] = ACTIONS(1128),
    [anon_sym_typedef] = ACTIONS(1128),
    [anon_sym_extern] = ACTIONS(1128),
    [anon_sym___attribute__] = ACTIONS(1128),
    [anon_sym___attribute] = ACTIONS(1128),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1130),
    [anon_sym___declspec] = ACTIONS(1128),
    [anon_sym___cdecl] = ACTIONS(1128),
    [anon_sym___clrcall] = ACTIONS(1128),
    [anon_sym___stdcall] = ACTIONS(1128),
    [anon_sym___fastcall] = ACTIONS(1128),
    [anon_sym___thiscall] = ACTIONS(1128),
    [anon_sym___vectorcall] = ACTIONS(1128),
    [anon_sym_LBRACE] = ACTIONS(1130),
    [anon_sym_signed] = ACTIONS(1128),
    [anon_sym_unsigned] = ACTIONS(1128),
    [anon_sym_long] = ACTIONS(1128),
    [anon_sym_short] = ACTIONS(1128),
    [anon_sym_static] = ACTIONS(1128),
    [anon_sym_auto] = ACTIONS(1128),
    [anon_sym_register] = ACTIONS(1128),
    [anon_sym_inline] = ACTIONS(1128),
    [anon_sym___inline] = ACTIONS(1128),
    [anon_sym___inline__] = ACTIONS(1128),
    [anon_sym___forceinline] = ACTIONS(1128),
    [anon_sym_thread_local] = ACTIONS(1128),
    [anon_sym___thread] = ACTIONS(1128),
    [anon_sym_const] = ACTIONS(1128),
    [anon_sym_constexpr] = ACTIONS(1128),
    [anon_sym_volatile] = ACTIONS(1128),
    [anon_sym_restrict] = ACTIONS(1128),
    [anon_sym___restrict__] = ACTIONS(1128),
    [anon_sym__Atomic] = ACTIONS(1128),
    [anon_sym__Noreturn] = ACTIONS(1128),
    [anon_sym_noreturn] = ACTIONS(1128),
    [anon_sym__Nonnull] = ACTIONS(1128),
    [anon_sym_alignas] = ACTIONS(1128),
    [anon_sym__Alignas] = ACTIONS(1128),
    [sym_primitive_type] = ACTIONS(1128),
    [anon_sym_enum] = ACTIONS(1128),
    [anon_sym_struct] = ACTIONS(1128),
    [anon_sym_union] = ACTIONS(1128),
    [anon_sym_if] = ACTIONS(1128),
    [anon_sym_else] = ACTIONS(1132),
    [anon_sym_switch] = ACTIONS(1128),
    [anon_sym_case] = ACTIONS(1128),
    [anon_sym_default] = ACTIONS(1128),
    [anon_sym_while] = ACTIONS(1128),
    [anon_sym_do] = ACTIONS(1128),
    [anon_sym_for] = ACTIONS(1128),
    [anon_sym_return] = ACTIONS(1128),
    [anon_sym_break] = ACTIONS(1128),
    [anon_sym_continue] = ACTIONS(1128),
    [anon_sym_goto] = ACTIONS(1128),
    [anon_sym___try] = ACTIONS(1128),
    [anon_sym___leave] = ACTIONS(1128),
    [anon_sym_DASH_DASH] = ACTIONS(1130),
    [anon_sym_PLUS_PLUS] = ACTIONS(1130),
    [anon_sym_sizeof] = ACTIONS(1128),
    [anon_sym___alignof__] = ACTIONS(1128),
    [anon_sym___alignof] = ACTIONS(1128),
    [anon_sym__alignof] = ACTIONS(1128),
    [anon_sym_alignof] = ACTIONS(1128),
    [anon_sym__Alignof] = ACTIONS(1128),
    [anon_sym_offsetof] = ACTIONS(1128),
    [anon_sym__Generic] = ACTIONS(1128),
    [anon_sym_asm] = ACTIONS(1128),
    [anon_sym___asm__] = ACTIONS(1128),
    [anon_sym___asm] = ACTIONS(1128),
    [sym_number_literal] = ACTIONS(1130),
    [anon_sym_L_SQUOTE] = ACTIONS(1130),
    [anon_sym_u_SQUOTE] = ACTIONS(1130),
    [anon_sym_U_SQUOTE] = ACTIONS(1130),
    [anon_sym_u8_SQUOTE] = ACTIONS(1130),
    [anon_sym_SQUOTE] = ACTIONS(1130),
    [anon_sym_L_DQUOTE] = ACTIONS(1130),
    [anon_sym_u_DQUOTE] = ACTIONS(1130),
    [anon_sym_U_DQUOTE] = ACTIONS(1130),
    [anon_sym_u8_DQUOTE] = ACTIONS(1130),
    [anon_sym_DQUOTE] = ACTIONS(1130),
    [sym_true] = ACTIONS(1128),
    [sym_false] = ACTIONS(1128),
    [anon_sym_NULL] = ACTIONS(1128),
    [anon_sym_nullptr] = ACTIONS(1128),
    [sym_comment] = ACTIONS(3),
  },
  [81] = {
    [sym_identifier] = ACTIONS(1134),
    [aux_sym_preproc_include_token1] = ACTIONS(1134),
    [aux_sym_preproc_def_token1] = ACTIONS(1134),
    [aux_sym_preproc_if_token1] = ACTIONS(1134),
    [aux_sym_preproc_if_token2] = ACTIONS(1134),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1134),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1134),
    [aux_sym_preproc_else_token1] = ACTIONS(1134),
    [aux_sym_preproc_elif_token1] = ACTIONS(1134),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1134),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1134),
    [sym_preproc_directive] = ACTIONS(1134),
    [anon_sym_LPAREN2] = ACTIONS(1136),
    [anon_sym_BANG] = ACTIONS(1136),
    [anon_sym_TILDE] = ACTIONS(1136),
    [anon_sym_DASH] = ACTIONS(1134),
    [anon_sym_PLUS] = ACTIONS(1134),
    [anon_sym_STAR] = ACTIONS(1136),
    [anon_sym_AMP] = ACTIONS(1136),
    [anon_sym_SEMI] = ACTIONS(1136),
    [anon_sym___extension__] = ACTIONS(1134),
    [anon_sym_typedef] = ACTIONS(1134),
    [anon_sym_extern] = ACTIONS(1134),
    [anon_sym___attribute__] = ACTIONS(1134),
    [anon_sym___attribute] = ACTIONS(1134),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1136),
    [anon_sym___declspec] = ACTIONS(1134),
    [anon_sym___cdecl] = ACTIONS(1134),
    [anon_sym___clrcall] = ACTIONS(1134),
    [anon_sym___stdcall] = ACTIONS(1134),
    [anon_sym___fastcall] = ACTIONS(1134),
    [anon_sym___thiscall] = ACTIONS(1134),
    [anon_sym___vectorcall] = ACTIONS(1134),
    [anon_sym_LBRACE] = ACTIONS(1136),
    [anon_sym_signed] = ACTIONS(1134),
    [anon_sym_unsigned] = ACTIONS(1134),
    [anon_sym_long] = ACTIONS(1134),
    [anon_sym_short] = ACTIONS(1134),
    [anon_sym_static] = ACTIONS(1134),
    [anon_sym_auto] = ACTIONS(1134),
    [anon_sym_register] = ACTIONS(1134),
    [anon_sym_inline] = ACTIONS(1134),
    [anon_sym___inline] = ACTIONS(1134),
    [anon_sym___inline__] = ACTIONS(1134),
    [anon_sym___forceinline] = ACTIONS(1134),
    [anon_sym_thread_local] = ACTIONS(1134),
    [anon_sym___thread] = ACTIONS(1134),
    [anon_sym_const] = ACTIONS(1134),
    [anon_sym_constexpr] = ACTIONS(1134),
    [anon_sym_volatile] = ACTIONS(1134),
    [anon_sym_restrict] = ACTIONS(1134),
    [anon_sym___restrict__] = ACTIONS(1134),
    [anon_sym__Atomic] = ACTIONS(1134),
    [anon_sym__Noreturn] = ACTIONS(1134),
    [anon_sym_noreturn] = ACTIONS(1134),
    [anon_sym__Nonnull] = ACTIONS(1134),
    [anon_sym_alignas] = ACTIONS(1134),
    [anon_sym__Alignas] = ACTIONS(1134),
    [sym_primitive_type] = ACTIONS(1134),
    [anon_sym_enum] = ACTIONS(1134),
    [anon_sym_struct] = ACTIONS(1134),
    [anon_sym_union] = ACTIONS(1134),
    [anon_sym_if] = ACTIONS(1134),
    [anon_sym_else] = ACTIONS(1134),
    [anon_sym_switch] = ACTIONS(1134),
    [anon_sym_case] = ACTIONS(1134),
    [anon_sym_default] = ACTIONS(1134),
    [anon_sym_while] = ACTIONS(1134),
    [anon_sym_do] = ACTIONS(1134),
    [anon_sym_for] = ACTIONS(1134),
    [anon_sym_return] = ACTIONS(1134),
    [anon_sym_break] = ACTIONS(1134),
    [anon_sym_continue] = ACTIONS(1134),
    [anon_sym_goto] = ACTIONS(1134),
    [anon_sym___try] = ACTIONS(1134),
    [anon_sym___leave] = ACTIONS(1134),
    [anon_sym_DASH_DASH] = ACTIONS(1136),
    [anon_sym_PLUS_PLUS] = ACTIONS(1136),
    [anon_sym_sizeof] = ACTIONS(1134),
    [anon_sym___alignof__] = ACTIONS(1134),
    [anon_sym___alignof] = ACTIONS(1134),
    [anon_sym__alignof] = ACTIONS(1134),
    [anon_sym_alignof] = ACTIONS(1134),
    [anon_sym__Alignof] = ACTIONS(1134),
    [anon_sym_offsetof] = ACTIONS(1134),
    [anon_sym__Generic] = ACTIONS(1134),
    [anon_sym_asm] = ACTIONS(1134),
    [anon_sym___asm__] = ACTIONS(1134),
    [anon_sym___asm] = ACTIONS(1134),
    [sym_number_literal] = ACTIONS(1136),
    [anon_sym_L_SQUOTE] = ACTIONS(1136),
    [anon_sym_u_SQUOTE] = ACTIONS(1136),
    [anon_sym_U_SQUOTE] = ACTIONS(1136),
    [anon_sym_u8_SQUOTE] = ACTIONS(1136),
    [anon_sym_SQUOTE] = ACTIONS(1136),
    [anon_sym_L_DQUOTE] = ACTIONS(1136),
    [anon_sym_u_DQUOTE] = ACTIONS(1136),
    [anon_sym_U_DQUOTE] = ACTIONS(1136),
    [anon_sym_u8_DQUOTE] = ACTIONS(1136),
    [anon_sym_DQUOTE] = ACTIONS(1136),
    [sym_true] = ACTIONS(1134),
    [sym_false] = ACTIONS(1134),
    [anon_sym_NULL] = ACTIONS(1134),
    [anon_sym_nullptr] = ACTIONS(1134),
    [sym_comment] = ACTIONS(3),
  },
  [82] = {
    [sym_identifier] = ACTIONS(1138),
    [aux_sym_preproc_include_token1] = ACTIONS(1138),
    [aux_sym_preproc_def_token1] = ACTIONS(1138),
    [aux_sym_preproc_if_token1] = ACTIONS(1138),
    [aux_sym_preproc_if_token2] = ACTIONS(1138),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1138),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1138),
    [aux_sym_preproc_else_token1] = ACTIONS(1138),
    [aux_sym_preproc_elif_token1] = ACTIONS(1138),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1138),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1138),
    [sym_preproc_directive] = ACTIONS(1138),
    [anon_sym_LPAREN2] = ACTIONS(1140),
    [anon_sym_BANG] = ACTIONS(1140),
    [anon_sym_TILDE] = ACTIONS(1140),
    [anon_sym_DASH] = ACTIONS(1138),
    [anon_sym_PLUS] = ACTIONS(1138),
    [anon_sym_STAR] = ACTIONS(1140),
    [anon_sym_AMP] = ACTIONS(1140),
    [anon_sym_SEMI] = ACTIONS(1140),
    [anon_sym___extension__] = ACTIONS(1138),
    [anon_sym_typedef] = ACTIONS(1138),
    [anon_sym_extern] = ACTIONS(1138),
    [anon_sym___attribute__] = ACTIONS(1138),
    [anon_sym___attribute] = ACTIONS(1138),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1140),
    [anon_sym___declspec] = ACTIONS(1138),
    [anon_sym___cdecl] = ACTIONS(1138),
    [anon_sym___clrcall] = ACTIONS(1138),
    [anon_sym___stdcall] = ACTIONS(1138),
    [anon_sym___fastcall] = ACTIONS(1138),
    [anon_sym___thiscall] = ACTIONS(1138),
    [anon_sym___vectorcall] = ACTIONS(1138),
    [anon_sym_LBRACE] = ACTIONS(1140),
    [anon_sym_signed] = ACTIONS(1138),
    [anon_sym_unsigned] = ACTIONS(1138),
    [anon_sym_long] = ACTIONS(1138),
    [anon_sym_short] = ACTIONS(1138),
    [anon_sym_static] = ACTIONS(1138),
    [anon_sym_auto] = ACTIONS(1138),
    [anon_sym_register] = ACTIONS(1138),
    [anon_sym_inline] = ACTIONS(1138),
    [anon_sym___inline] = ACTIONS(1138),
    [anon_sym___inline__] = ACTIONS(1138),
    [anon_sym___forceinline] = ACTIONS(1138),
    [anon_sym_thread_local] = ACTIONS(1138),
    [anon_sym___thread] = ACTIONS(1138),
    [anon_sym_const] = ACTIONS(1138),
    [anon_sym_constexpr] = ACTIONS(1138),
    [anon_sym_volatile] = ACTIONS(1138),
    [anon_sym_restrict] = ACTIONS(1138),
    [anon_sym___restrict__] = ACTIONS(1138),
    [anon_sym__Atomic] = ACTIONS(1138),
    [anon_sym__Noreturn] = ACTIONS(1138),
    [anon_sym_noreturn] = ACTIONS(1138),
    [anon_sym__Nonnull] = ACTIONS(1138),
    [anon_sym_alignas] = ACTIONS(1138),
    [anon_sym__Alignas] = ACTIONS(1138),
    [sym_primitive_type] = ACTIONS(1138),
    [anon_sym_enum] = ACTIONS(1138),
    [anon_sym_struct] = ACTIONS(1138),
    [anon_sym_union] = ACTIONS(1138),
    [anon_sym_if] = ACTIONS(1138),
    [anon_sym_else] = ACTIONS(1138),
    [anon_sym_switch] = ACTIONS(1138),
    [anon_sym_case] = ACTIONS(1138),
    [anon_sym_default] = ACTIONS(1138),
    [anon_sym_while] = ACTIONS(1138),
    [anon_sym_do] = ACTIONS(1138),
    [anon_sym_for] = ACTIONS(1138),
    [anon_sym_return] = ACTIONS(1138),
    [anon_sym_break] = ACTIONS(1138),
    [anon_sym_continue] = ACTIONS(1138),
    [anon_sym_goto] = ACTIONS(1138),
    [anon_sym___try] = ACTIONS(1138),
    [anon_sym___leave] = ACTIONS(1138),
    [anon_sym_DASH_DASH] = ACTIONS(1140),
    [anon_sym_PLUS_PLUS] = ACTIONS(1140),
    [anon_sym_sizeof] = ACTIONS(1138),
    [anon_sym___alignof__] = ACTIONS(1138),
    [anon_sym___alignof] = ACTIONS(1138),
    [anon_sym__alignof] = ACTIONS(1138),
    [anon_sym_alignof] = ACTIONS(1138),
    [anon_sym__Alignof] = ACTIONS(1138),
    [anon_sym_offsetof] = ACTIONS(1138),
    [anon_sym__Generic] = ACTIONS(1138),
    [anon_sym_asm] = ACTIONS(1138),
    [anon_sym___asm__] = ACTIONS(1138),
    [anon_sym___asm] = ACTIONS(1138),
    [sym_number_literal] = ACTIONS(1140),
    [anon_sym_L_SQUOTE] = ACTIONS(1140),
    [anon_sym_u_SQUOTE] = ACTIONS(1140),
    [anon_sym_U_SQUOTE] = ACTIONS(1140),
    [anon_sym_u8_SQUOTE] = ACTIONS(1140),
    [anon_sym_SQUOTE] = ACTIONS(1140),
    [anon_sym_L_DQUOTE] = ACTIONS(1140),
    [anon_sym_u_DQUOTE] = ACTIONS(1140),
    [anon_sym_U_DQUOTE] = ACTIONS(1140),
    [anon_sym_u8_DQUOTE] = ACTIONS(1140),
    [anon_sym_DQUOTE] = ACTIONS(1140),
    [sym_true] = ACTIONS(1138),
    [sym_false] = ACTIONS(1138),
    [anon_sym_NULL] = ACTIONS(1138),
    [anon_sym_nullptr] = ACTIONS(1138),
    [sym_comment] = ACTIONS(3),
  },
  [83] = {
    [sym_identifier] = ACTIONS(1142),
    [aux_sym_preproc_include_token1] = ACTIONS(1142),
    [aux_sym_preproc_def_token1] = ACTIONS(1142),
    [aux_sym_preproc_if_token1] = ACTIONS(1142),
    [aux_sym_preproc_if_token2] = ACTIONS(1142),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1142),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1142),
    [aux_sym_preproc_else_token1] = ACTIONS(1142),
    [aux_sym_preproc_elif_token1] = ACTIONS(1142),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1142),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1142),
    [sym_preproc_directive] = ACTIONS(1142),
    [anon_sym_LPAREN2] = ACTIONS(1144),
    [anon_sym_BANG] = ACTIONS(1144),
    [anon_sym_TILDE] = ACTIONS(1144),
    [anon_sym_DASH] = ACTIONS(1142),
    [anon_sym_PLUS] = ACTIONS(1142),
    [anon_sym_STAR] = ACTIONS(1144),
    [anon_sym_AMP] = ACTIONS(1144),
    [anon_sym_SEMI] = ACTIONS(1144),
    [anon_sym___extension__] = ACTIONS(1142),
    [anon_sym_typedef] = ACTIONS(1142),
    [anon_sym_extern] = ACTIONS(1142),
    [anon_sym___attribute__] = ACTIONS(1142),
    [anon_sym___attribute] = ACTIONS(1142),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1144),
    [anon_sym___declspec] = ACTIONS(1142),
    [anon_sym___cdecl] = ACTIONS(1142),
    [anon_sym___clrcall] = ACTIONS(1142),
    [anon_sym___stdcall] = ACTIONS(1142),
    [anon_sym___fastcall] = ACTIONS(1142),
    [anon_sym___thiscall] = ACTIONS(1142),
    [anon_sym___vectorcall] = ACTIONS(1142),
    [anon_sym_LBRACE] = ACTIONS(1144),
    [anon_sym_signed] = ACTIONS(1142),
    [anon_sym_unsigned] = ACTIONS(1142),
    [anon_sym_long] = ACTIONS(1142),
    [anon_sym_short] = ACTIONS(1142),
    [anon_sym_static] = ACTIONS(1142),
    [anon_sym_auto] = ACTIONS(1142),
    [anon_sym_register] = ACTIONS(1142),
    [anon_sym_inline] = ACTIONS(1142),
    [anon_sym___inline] = ACTIONS(1142),
    [anon_sym___inline__] = ACTIONS(1142),
    [anon_sym___forceinline] = ACTIONS(1142),
    [anon_sym_thread_local] = ACTIONS(1142),
    [anon_sym___thread] = ACTIONS(1142),
    [anon_sym_const] = ACTIONS(1142),
    [anon_sym_constexpr] = ACTIONS(1142),
    [anon_sym_volatile] = ACTIONS(1142),
    [anon_sym_restrict] = ACTIONS(1142),
    [anon_sym___restrict__] = ACTIONS(1142),
    [anon_sym__Atomic] = ACTIONS(1142),
    [anon_sym__Noreturn] = ACTIONS(1142),
    [anon_sym_noreturn] = ACTIONS(1142),
    [anon_sym__Nonnull] = ACTIONS(1142),
    [anon_sym_alignas] = ACTIONS(1142),
    [anon_sym__Alignas] = ACTIONS(1142),
    [sym_primitive_type] = ACTIONS(1142),
    [anon_sym_enum] = ACTIONS(1142),
    [anon_sym_struct] = ACTIONS(1142),
    [anon_sym_union] = ACTIONS(1142),
    [anon_sym_if] = ACTIONS(1142),
    [anon_sym_else] = ACTIONS(1142),
    [anon_sym_switch] = ACTIONS(1142),
    [anon_sym_case] = ACTIONS(1142),
    [anon_sym_default] = ACTIONS(1142),
    [anon_sym_while] = ACTIONS(1142),
    [anon_sym_do] = ACTIONS(1142),
    [anon_sym_for] = ACTIONS(1142),
    [anon_sym_return] = ACTIONS(1142),
    [anon_sym_break] = ACTIONS(1142),
    [anon_sym_continue] = ACTIONS(1142),
    [anon_sym_goto] = ACTIONS(1142),
    [anon_sym___try] = ACTIONS(1142),
    [anon_sym___leave] = ACTIONS(1142),
    [anon_sym_DASH_DASH] = ACTIONS(1144),
    [anon_sym_PLUS_PLUS] = ACTIONS(1144),
    [anon_sym_sizeof] = ACTIONS(1142),
    [anon_sym___alignof__] = ACTIONS(1142),
    [anon_sym___alignof] = ACTIONS(1142),
    [anon_sym__alignof] = ACTIONS(1142),
    [anon_sym_alignof] = ACTIONS(1142),
    [anon_sym__Alignof] = ACTIONS(1142),
    [anon_sym_offsetof] = ACTIONS(1142),
    [anon_sym__Generic] = ACTIONS(1142),
    [anon_sym_asm] = ACTIONS(1142),
    [anon_sym___asm__] = ACTIONS(1142),
    [anon_sym___asm] = ACTIONS(1142),
    [sym_number_literal] = ACTIONS(1144),
    [anon_sym_L_SQUOTE] = ACTIONS(1144),
    [anon_sym_u_SQUOTE] = ACTIONS(1144),
    [anon_sym_U_SQUOTE] = ACTIONS(1144),
    [anon_sym_u8_SQUOTE] = ACTIONS(1144),
    [anon_sym_SQUOTE] = ACTIONS(1144),
    [anon_sym_L_DQUOTE] = ACTIONS(1144),
    [anon_sym_u_DQUOTE] = ACTIONS(1144),
    [anon_sym_U_DQUOTE] = ACTIONS(1144),
    [anon_sym_u8_DQUOTE] = ACTIONS(1144),
    [anon_sym_DQUOTE] = ACTIONS(1144),
    [sym_true] = ACTIONS(1142),
    [sym_false] = ACTIONS(1142),
    [anon_sym_NULL] = ACTIONS(1142),
    [anon_sym_nullptr] = ACTIONS(1142),
    [sym_comment] = ACTIONS(3),
  },
  [84] = {
    [sym_identifier] = ACTIONS(1146),
    [aux_sym_preproc_include_token1] = ACTIONS(1146),
    [aux_sym_preproc_def_token1] = ACTIONS(1146),
    [aux_sym_preproc_if_token1] = ACTIONS(1146),
    [aux_sym_preproc_if_token2] = ACTIONS(1146),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1146),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1146),
    [aux_sym_preproc_else_token1] = ACTIONS(1146),
    [aux_sym_preproc_elif_token1] = ACTIONS(1146),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1146),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1146),
    [sym_preproc_directive] = ACTIONS(1146),
    [anon_sym_LPAREN2] = ACTIONS(1148),
    [anon_sym_BANG] = ACTIONS(1148),
    [anon_sym_TILDE] = ACTIONS(1148),
    [anon_sym_DASH] = ACTIONS(1146),
    [anon_sym_PLUS] = ACTIONS(1146),
    [anon_sym_STAR] = ACTIONS(1148),
    [anon_sym_AMP] = ACTIONS(1148),
    [anon_sym_SEMI] = ACTIONS(1148),
    [anon_sym___extension__] = ACTIONS(1146),
    [anon_sym_typedef] = ACTIONS(1146),
    [anon_sym_extern] = ACTIONS(1146),
    [anon_sym___attribute__] = ACTIONS(1146),
    [anon_sym___attribute] = ACTIONS(1146),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1148),
    [anon_sym___declspec] = ACTIONS(1146),
    [anon_sym___cdecl] = ACTIONS(1146),
    [anon_sym___clrcall] = ACTIONS(1146),
    [anon_sym___stdcall] = ACTIONS(1146),
    [anon_sym___fastcall] = ACTIONS(1146),
    [anon_sym___thiscall] = ACTIONS(1146),
    [anon_sym___vectorcall] = ACTIONS(1146),
    [anon_sym_LBRACE] = ACTIONS(1148),
    [anon_sym_signed] = ACTIONS(1146),
    [anon_sym_unsigned] = ACTIONS(1146),
    [anon_sym_long] = ACTIONS(1146),
    [anon_sym_short] = ACTIONS(1146),
    [anon_sym_static] = ACTIONS(1146),
    [anon_sym_auto] = ACTIONS(1146),
    [anon_sym_register] = ACTIONS(1146),
    [anon_sym_inline] = ACTIONS(1146),
    [anon_sym___inline] = ACTIONS(1146),
    [anon_sym___inline__] = ACTIONS(1146),
    [anon_sym___forceinline] = ACTIONS(1146),
    [anon_sym_thread_local] = ACTIONS(1146),
    [anon_sym___thread] = ACTIONS(1146),
    [anon_sym_const] = ACTIONS(1146),
    [anon_sym_constexpr] = ACTIONS(1146),
    [anon_sym_volatile] = ACTIONS(1146),
    [anon_sym_restrict] = ACTIONS(1146),
    [anon_sym___restrict__] = ACTIONS(1146),
    [anon_sym__Atomic] = ACTIONS(1146),
    [anon_sym__Noreturn] = ACTIONS(1146),
    [anon_sym_noreturn] = ACTIONS(1146),
    [anon_sym__Nonnull] = ACTIONS(1146),
    [anon_sym_alignas] = ACTIONS(1146),
    [anon_sym__Alignas] = ACTIONS(1146),
    [sym_primitive_type] = ACTIONS(1146),
    [anon_sym_enum] = ACTIONS(1146),
    [anon_sym_struct] = ACTIONS(1146),
    [anon_sym_union] = ACTIONS(1146),
    [anon_sym_if] = ACTIONS(1146),
    [anon_sym_else] = ACTIONS(1146),
    [anon_sym_switch] = ACTIONS(1146),
    [anon_sym_case] = ACTIONS(1146),
    [anon_sym_default] = ACTIONS(1146),
    [anon_sym_while] = ACTIONS(1146),
    [anon_sym_do] = ACTIONS(1146),
    [anon_sym_for] = ACTIONS(1146),
    [anon_sym_return] = ACTIONS(1146),
    [anon_sym_break] = ACTIONS(1146),
    [anon_sym_continue] = ACTIONS(1146),
    [anon_sym_goto] = ACTIONS(1146),
    [anon_sym___try] = ACTIONS(1146),
    [anon_sym___leave] = ACTIONS(1146),
    [anon_sym_DASH_DASH] = ACTIONS(1148),
    [anon_sym_PLUS_PLUS] = ACTIONS(1148),
    [anon_sym_sizeof] = ACTIONS(1146),
    [anon_sym___alignof__] = ACTIONS(1146),
    [anon_sym___alignof] = ACTIONS(1146),
    [anon_sym__alignof] = ACTIONS(1146),
    [anon_sym_alignof] = ACTIONS(1146),
    [anon_sym__Alignof] = ACTIONS(1146),
    [anon_sym_offsetof] = ACTIONS(1146),
    [anon_sym__Generic] = ACTIONS(1146),
    [anon_sym_asm] = ACTIONS(1146),
    [anon_sym___asm__] = ACTIONS(1146),
    [anon_sym___asm] = ACTIONS(1146),
    [sym_number_literal] = ACTIONS(1148),
    [anon_sym_L_SQUOTE] = ACTIONS(1148),
    [anon_sym_u_SQUOTE] = ACTIONS(1148),
    [anon_sym_U_SQUOTE] = ACTIONS(1148),
    [anon_sym_u8_SQUOTE] = ACTIONS(1148),
    [anon_sym_SQUOTE] = ACTIONS(1148),
    [anon_sym_L_DQUOTE] = ACTIONS(1148),
    [anon_sym_u_DQUOTE] = ACTIONS(1148),
    [anon_sym_U_DQUOTE] = ACTIONS(1148),
    [anon_sym_u8_DQUOTE] = ACTIONS(1148),
    [anon_sym_DQUOTE] = ACTIONS(1148),
    [sym_true] = ACTIONS(1146),
    [sym_false] = ACTIONS(1146),
    [anon_sym_NULL] = ACTIONS(1146),
    [anon_sym_nullptr] = ACTIONS(1146),
    [sym_comment] = ACTIONS(3),
  },
  [85] = {
    [sym_identifier] = ACTIONS(1150),
    [aux_sym_preproc_include_token1] = ACTIONS(1150),
    [aux_sym_preproc_def_token1] = ACTIONS(1150),
    [aux_sym_preproc_if_token1] = ACTIONS(1150),
    [aux_sym_preproc_if_token2] = ACTIONS(1150),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1150),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1150),
    [aux_sym_preproc_else_token1] = ACTIONS(1150),
    [aux_sym_preproc_elif_token1] = ACTIONS(1150),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1150),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1150),
    [sym_preproc_directive] = ACTIONS(1150),
    [anon_sym_LPAREN2] = ACTIONS(1152),
    [anon_sym_BANG] = ACTIONS(1152),
    [anon_sym_TILDE] = ACTIONS(1152),
    [anon_sym_DASH] = ACTIONS(1150),
    [anon_sym_PLUS] = ACTIONS(1150),
    [anon_sym_STAR] = ACTIONS(1152),
    [anon_sym_AMP] = ACTIONS(1152),
    [anon_sym_SEMI] = ACTIONS(1152),
    [anon_sym___extension__] = ACTIONS(1150),
    [anon_sym_typedef] = ACTIONS(1150),
    [anon_sym_extern] = ACTIONS(1150),
    [anon_sym___attribute__] = ACTIONS(1150),
    [anon_sym___attribute] = ACTIONS(1150),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1152),
    [anon_sym___declspec] = ACTIONS(1150),
    [anon_sym___cdecl] = ACTIONS(1150),
    [anon_sym___clrcall] = ACTIONS(1150),
    [anon_sym___stdcall] = ACTIONS(1150),
    [anon_sym___fastcall] = ACTIONS(1150),
    [anon_sym___thiscall] = ACTIONS(1150),
    [anon_sym___vectorcall] = ACTIONS(1150),
    [anon_sym_LBRACE] = ACTIONS(1152),
    [anon_sym_signed] = ACTIONS(1150),
    [anon_sym_unsigned] = ACTIONS(1150),
    [anon_sym_long] = ACTIONS(1150),
    [anon_sym_short] = ACTIONS(1150),
    [anon_sym_static] = ACTIONS(1150),
    [anon_sym_auto] = ACTIONS(1150),
    [anon_sym_register] = ACTIONS(1150),
    [anon_sym_inline] = ACTIONS(1150),
    [anon_sym___inline] = ACTIONS(1150),
    [anon_sym___inline__] = ACTIONS(1150),
    [anon_sym___forceinline] = ACTIONS(1150),
    [anon_sym_thread_local] = ACTIONS(1150),
    [anon_sym___thread] = ACTIONS(1150),
    [anon_sym_const] = ACTIONS(1150),
    [anon_sym_constexpr] = ACTIONS(1150),
    [anon_sym_volatile] = ACTIONS(1150),
    [anon_sym_restrict] = ACTIONS(1150),
    [anon_sym___restrict__] = ACTIONS(1150),
    [anon_sym__Atomic] = ACTIONS(1150),
    [anon_sym__Noreturn] = ACTIONS(1150),
    [anon_sym_noreturn] = ACTIONS(1150),
    [anon_sym__Nonnull] = ACTIONS(1150),
    [anon_sym_alignas] = ACTIONS(1150),
    [anon_sym__Alignas] = ACTIONS(1150),
    [sym_primitive_type] = ACTIONS(1150),
    [anon_sym_enum] = ACTIONS(1150),
    [anon_sym_struct] = ACTIONS(1150),
    [anon_sym_union] = ACTIONS(1150),
    [anon_sym_if] = ACTIONS(1150),
    [anon_sym_else] = ACTIONS(1150),
    [anon_sym_switch] = ACTIONS(1150),
    [anon_sym_case] = ACTIONS(1150),
    [anon_sym_default] = ACTIONS(1150),
    [anon_sym_while] = ACTIONS(1150),
    [anon_sym_do] = ACTIONS(1150),
    [anon_sym_for] = ACTIONS(1150),
    [anon_sym_return] = ACTIONS(1150),
    [anon_sym_break] = ACTIONS(1150),
    [anon_sym_continue] = ACTIONS(1150),
    [anon_sym_goto] = ACTIONS(1150),
    [anon_sym___try] = ACTIONS(1150),
    [anon_sym___leave] = ACTIONS(1150),
    [anon_sym_DASH_DASH] = ACTIONS(1152),
    [anon_sym_PLUS_PLUS] = ACTIONS(1152),
    [anon_sym_sizeof] = ACTIONS(1150),
    [anon_sym___alignof__] = ACTIONS(1150),
    [anon_sym___alignof] = ACTIONS(1150),
    [anon_sym__alignof] = ACTIONS(1150),
    [anon_sym_alignof] = ACTIONS(1150),
    [anon_sym__Alignof] = ACTIONS(1150),
    [anon_sym_offsetof] = ACTIONS(1150),
    [anon_sym__Generic] = ACTIONS(1150),
    [anon_sym_asm] = ACTIONS(1150),
    [anon_sym___asm__] = ACTIONS(1150),
    [anon_sym___asm] = ACTIONS(1150),
    [sym_number_literal] = ACTIONS(1152),
    [anon_sym_L_SQUOTE] = ACTIONS(1152),
    [anon_sym_u_SQUOTE] = ACTIONS(1152),
    [anon_sym_U_SQUOTE] = ACTIONS(1152),
    [anon_sym_u8_SQUOTE] = ACTIONS(1152),
    [anon_sym_SQUOTE] = ACTIONS(1152),
    [anon_sym_L_DQUOTE] = ACTIONS(1152),
    [anon_sym_u_DQUOTE] = ACTIONS(1152),
    [anon_sym_U_DQUOTE] = ACTIONS(1152),
    [anon_sym_u8_DQUOTE] = ACTIONS(1152),
    [anon_sym_DQUOTE] = ACTIONS(1152),
    [sym_true] = ACTIONS(1150),
    [sym_false] = ACTIONS(1150),
    [anon_sym_NULL] = ACTIONS(1150),
    [anon_sym_nullptr] = ACTIONS(1150),
    [sym_comment] = ACTIONS(3),
  },
  [86] = {
    [sym_identifier] = ACTIONS(1154),
    [aux_sym_preproc_include_token1] = ACTIONS(1154),
    [aux_sym_preproc_def_token1] = ACTIONS(1154),
    [aux_sym_preproc_if_token1] = ACTIONS(1154),
    [aux_sym_preproc_if_token2] = ACTIONS(1154),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1154),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1154),
    [aux_sym_preproc_else_token1] = ACTIONS(1154),
    [aux_sym_preproc_elif_token1] = ACTIONS(1154),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1154),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1154),
    [sym_preproc_directive] = ACTIONS(1154),
    [anon_sym_LPAREN2] = ACTIONS(1156),
    [anon_sym_BANG] = ACTIONS(1156),
    [anon_sym_TILDE] = ACTIONS(1156),
    [anon_sym_DASH] = ACTIONS(1154),
    [anon_sym_PLUS] = ACTIONS(1154),
    [anon_sym_STAR] = ACTIONS(1156),
    [anon_sym_AMP] = ACTIONS(1156),
    [anon_sym_SEMI] = ACTIONS(1156),
    [anon_sym___extension__] = ACTIONS(1154),
    [anon_sym_typedef] = ACTIONS(1154),
    [anon_sym_extern] = ACTIONS(1154),
    [anon_sym___attribute__] = ACTIONS(1154),
    [anon_sym___attribute] = ACTIONS(1154),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1156),
    [anon_sym___declspec] = ACTIONS(1154),
    [anon_sym___cdecl] = ACTIONS(1154),
    [anon_sym___clrcall] = ACTIONS(1154),
    [anon_sym___stdcall] = ACTIONS(1154),
    [anon_sym___fastcall] = ACTIONS(1154),
    [anon_sym___thiscall] = ACTIONS(1154),
    [anon_sym___vectorcall] = ACTIONS(1154),
    [anon_sym_LBRACE] = ACTIONS(1156),
    [anon_sym_signed] = ACTIONS(1154),
    [anon_sym_unsigned] = ACTIONS(1154),
    [anon_sym_long] = ACTIONS(1154),
    [anon_sym_short] = ACTIONS(1154),
    [anon_sym_static] = ACTIONS(1154),
    [anon_sym_auto] = ACTIONS(1154),
    [anon_sym_register] = ACTIONS(1154),
    [anon_sym_inline] = ACTIONS(1154),
    [anon_sym___inline] = ACTIONS(1154),
    [anon_sym___inline__] = ACTIONS(1154),
    [anon_sym___forceinline] = ACTIONS(1154),
    [anon_sym_thread_local] = ACTIONS(1154),
    [anon_sym___thread] = ACTIONS(1154),
    [anon_sym_const] = ACTIONS(1154),
    [anon_sym_constexpr] = ACTIONS(1154),
    [anon_sym_volatile] = ACTIONS(1154),
    [anon_sym_restrict] = ACTIONS(1154),
    [anon_sym___restrict__] = ACTIONS(1154),
    [anon_sym__Atomic] = ACTIONS(1154),
    [anon_sym__Noreturn] = ACTIONS(1154),
    [anon_sym_noreturn] = ACTIONS(1154),
    [anon_sym__Nonnull] = ACTIONS(1154),
    [anon_sym_alignas] = ACTIONS(1154),
    [anon_sym__Alignas] = ACTIONS(1154),
    [sym_primitive_type] = ACTIONS(1154),
    [anon_sym_enum] = ACTIONS(1154),
    [anon_sym_struct] = ACTIONS(1154),
    [anon_sym_union] = ACTIONS(1154),
    [anon_sym_if] = ACTIONS(1154),
    [anon_sym_else] = ACTIONS(1154),
    [anon_sym_switch] = ACTIONS(1154),
    [anon_sym_case] = ACTIONS(1154),
    [anon_sym_default] = ACTIONS(1154),
    [anon_sym_while] = ACTIONS(1154),
    [anon_sym_do] = ACTIONS(1154),
    [anon_sym_for] = ACTIONS(1154),
    [anon_sym_return] = ACTIONS(1154),
    [anon_sym_break] = ACTIONS(1154),
    [anon_sym_continue] = ACTIONS(1154),
    [anon_sym_goto] = ACTIONS(1154),
    [anon_sym___try] = ACTIONS(1154),
    [anon_sym___leave] = ACTIONS(1154),
    [anon_sym_DASH_DASH] = ACTIONS(1156),
    [anon_sym_PLUS_PLUS] = ACTIONS(1156),
    [anon_sym_sizeof] = ACTIONS(1154),
    [anon_sym___alignof__] = ACTIONS(1154),
    [anon_sym___alignof] = ACTIONS(1154),
    [anon_sym__alignof] = ACTIONS(1154),
    [anon_sym_alignof] = ACTIONS(1154),
    [anon_sym__Alignof] = ACTIONS(1154),
    [anon_sym_offsetof] = ACTIONS(1154),
    [anon_sym__Generic] = ACTIONS(1154),
    [anon_sym_asm] = ACTIONS(1154),
    [anon_sym___asm__] = ACTIONS(1154),
    [anon_sym___asm] = ACTIONS(1154),
    [sym_number_literal] = ACTIONS(1156),
    [anon_sym_L_SQUOTE] = ACTIONS(1156),
    [anon_sym_u_SQUOTE] = ACTIONS(1156),
    [anon_sym_U_SQUOTE] = ACTIONS(1156),
    [anon_sym_u8_SQUOTE] = ACTIONS(1156),
    [anon_sym_SQUOTE] = ACTIONS(1156),
    [anon_sym_L_DQUOTE] = ACTIONS(1156),
    [anon_sym_u_DQUOTE] = ACTIONS(1156),
    [anon_sym_U_DQUOTE] = ACTIONS(1156),
    [anon_sym_u8_DQUOTE] = ACTIONS(1156),
    [anon_sym_DQUOTE] = ACTIONS(1156),
    [sym_true] = ACTIONS(1154),
    [sym_false] = ACTIONS(1154),
    [anon_sym_NULL] = ACTIONS(1154),
    [anon_sym_nullptr] = ACTIONS(1154),
    [sym_comment] = ACTIONS(3),
  },
  [87] = {
    [sym_identifier] = ACTIONS(1154),
    [aux_sym_preproc_include_token1] = ACTIONS(1154),
    [aux_sym_preproc_def_token1] = ACTIONS(1154),
    [aux_sym_preproc_if_token1] = ACTIONS(1154),
    [aux_sym_preproc_if_token2] = ACTIONS(1154),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1154),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1154),
    [aux_sym_preproc_else_token1] = ACTIONS(1154),
    [aux_sym_preproc_elif_token1] = ACTIONS(1154),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1154),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1154),
    [sym_preproc_directive] = ACTIONS(1154),
    [anon_sym_LPAREN2] = ACTIONS(1156),
    [anon_sym_BANG] = ACTIONS(1156),
    [anon_sym_TILDE] = ACTIONS(1156),
    [anon_sym_DASH] = ACTIONS(1154),
    [anon_sym_PLUS] = ACTIONS(1154),
    [anon_sym_STAR] = ACTIONS(1156),
    [anon_sym_AMP] = ACTIONS(1156),
    [anon_sym_SEMI] = ACTIONS(1156),
    [anon_sym___extension__] = ACTIONS(1154),
    [anon_sym_typedef] = ACTIONS(1154),
    [anon_sym_extern] = ACTIONS(1154),
    [anon_sym___attribute__] = ACTIONS(1154),
    [anon_sym___attribute] = ACTIONS(1154),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1156),
    [anon_sym___declspec] = ACTIONS(1154),
    [anon_sym___cdecl] = ACTIONS(1154),
    [anon_sym___clrcall] = ACTIONS(1154),
    [anon_sym___stdcall] = ACTIONS(1154),
    [anon_sym___fastcall] = ACTIONS(1154),
    [anon_sym___thiscall] = ACTIONS(1154),
    [anon_sym___vectorcall] = ACTIONS(1154),
    [anon_sym_LBRACE] = ACTIONS(1156),
    [anon_sym_signed] = ACTIONS(1154),
    [anon_sym_unsigned] = ACTIONS(1154),
    [anon_sym_long] = ACTIONS(1154),
    [anon_sym_short] = ACTIONS(1154),
    [anon_sym_static] = ACTIONS(1154),
    [anon_sym_auto] = ACTIONS(1154),
    [anon_sym_register] = ACTIONS(1154),
    [anon_sym_inline] = ACTIONS(1154),
    [anon_sym___inline] = ACTIONS(1154),
    [anon_sym___inline__] = ACTIONS(1154),
    [anon_sym___forceinline] = ACTIONS(1154),
    [anon_sym_thread_local] = ACTIONS(1154),
    [anon_sym___thread] = ACTIONS(1154),
    [anon_sym_const] = ACTIONS(1154),
    [anon_sym_constexpr] = ACTIONS(1154),
    [anon_sym_volatile] = ACTIONS(1154),
    [anon_sym_restrict] = ACTIONS(1154),
    [anon_sym___restrict__] = ACTIONS(1154),
    [anon_sym__Atomic] = ACTIONS(1154),
    [anon_sym__Noreturn] = ACTIONS(1154),
    [anon_sym_noreturn] = ACTIONS(1154),
    [anon_sym__Nonnull] = ACTIONS(1154),
    [anon_sym_alignas] = ACTIONS(1154),
    [anon_sym__Alignas] = ACTIONS(1154),
    [sym_primitive_type] = ACTIONS(1154),
    [anon_sym_enum] = ACTIONS(1154),
    [anon_sym_struct] = ACTIONS(1154),
    [anon_sym_union] = ACTIONS(1154),
    [anon_sym_if] = ACTIONS(1154),
    [anon_sym_else] = ACTIONS(1154),
    [anon_sym_switch] = ACTIONS(1154),
    [anon_sym_case] = ACTIONS(1154),
    [anon_sym_default] = ACTIONS(1154),
    [anon_sym_while] = ACTIONS(1154),
    [anon_sym_do] = ACTIONS(1154),
    [anon_sym_for] = ACTIONS(1154),
    [anon_sym_return] = ACTIONS(1154),
    [anon_sym_break] = ACTIONS(1154),
    [anon_sym_continue] = ACTIONS(1154),
    [anon_sym_goto] = ACTIONS(1154),
    [anon_sym___try] = ACTIONS(1154),
    [anon_sym___leave] = ACTIONS(1154),
    [anon_sym_DASH_DASH] = ACTIONS(1156),
    [anon_sym_PLUS_PLUS] = ACTIONS(1156),
    [anon_sym_sizeof] = ACTIONS(1154),
    [anon_sym___alignof__] = ACTIONS(1154),
    [anon_sym___alignof] = ACTIONS(1154),
    [anon_sym__alignof] = ACTIONS(1154),
    [anon_sym_alignof] = ACTIONS(1154),
    [anon_sym__Alignof] = ACTIONS(1154),
    [anon_sym_offsetof] = ACTIONS(1154),
    [anon_sym__Generic] = ACTIONS(1154),
    [anon_sym_asm] = ACTIONS(1154),
    [anon_sym___asm__] = ACTIONS(1154),
    [anon_sym___asm] = ACTIONS(1154),
    [sym_number_literal] = ACTIONS(1156),
    [anon_sym_L_SQUOTE] = ACTIONS(1156),
    [anon_sym_u_SQUOTE] = ACTIONS(1156),
    [anon_sym_U_SQUOTE] = ACTIONS(1156),
    [anon_sym_u8_SQUOTE] = ACTIONS(1156),
    [anon_sym_SQUOTE] = ACTIONS(1156),
    [anon_sym_L_DQUOTE] = ACTIONS(1156),
    [anon_sym_u_DQUOTE] = ACTIONS(1156),
    [anon_sym_U_DQUOTE] = ACTIONS(1156),
    [anon_sym_u8_DQUOTE] = ACTIONS(1156),
    [anon_sym_DQUOTE] = ACTIONS(1156),
    [sym_true] = ACTIONS(1154),
    [sym_false] = ACTIONS(1154),
    [anon_sym_NULL] = ACTIONS(1154),
    [anon_sym_nullptr] = ACTIONS(1154),
    [sym_comment] = ACTIONS(3),
  },
  [88] = {
    [sym_identifier] = ACTIONS(1158),
    [aux_sym_preproc_include_token1] = ACTIONS(1158),
    [aux_sym_preproc_def_token1] = ACTIONS(1158),
    [aux_sym_preproc_if_token1] = ACTIONS(1158),
    [aux_sym_preproc_if_token2] = ACTIONS(1158),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1158),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1158),
    [aux_sym_preproc_else_token1] = ACTIONS(1158),
    [aux_sym_preproc_elif_token1] = ACTIONS(1158),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1158),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1158),
    [sym_preproc_directive] = ACTIONS(1158),
    [anon_sym_LPAREN2] = ACTIONS(1160),
    [anon_sym_BANG] = ACTIONS(1160),
    [anon_sym_TILDE] = ACTIONS(1160),
    [anon_sym_DASH] = ACTIONS(1158),
    [anon_sym_PLUS] = ACTIONS(1158),
    [anon_sym_STAR] = ACTIONS(1160),
    [anon_sym_AMP] = ACTIONS(1160),
    [anon_sym_SEMI] = ACTIONS(1160),
    [anon_sym___extension__] = ACTIONS(1158),
    [anon_sym_typedef] = ACTIONS(1158),
    [anon_sym_extern] = ACTIONS(1158),
    [anon_sym___attribute__] = ACTIONS(1158),
    [anon_sym___attribute] = ACTIONS(1158),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1160),
    [anon_sym___declspec] = ACTIONS(1158),
    [anon_sym___cdecl] = ACTIONS(1158),
    [anon_sym___clrcall] = ACTIONS(1158),
    [anon_sym___stdcall] = ACTIONS(1158),
    [anon_sym___fastcall] = ACTIONS(1158),
    [anon_sym___thiscall] = ACTIONS(1158),
    [anon_sym___vectorcall] = ACTIONS(1158),
    [anon_sym_LBRACE] = ACTIONS(1160),
    [anon_sym_signed] = ACTIONS(1158),
    [anon_sym_unsigned] = ACTIONS(1158),
    [anon_sym_long] = ACTIONS(1158),
    [anon_sym_short] = ACTIONS(1158),
    [anon_sym_static] = ACTIONS(1158),
    [anon_sym_auto] = ACTIONS(1158),
    [anon_sym_register] = ACTIONS(1158),
    [anon_sym_inline] = ACTIONS(1158),
    [anon_sym___inline] = ACTIONS(1158),
    [anon_sym___inline__] = ACTIONS(1158),
    [anon_sym___forceinline] = ACTIONS(1158),
    [anon_sym_thread_local] = ACTIONS(1158),
    [anon_sym___thread] = ACTIONS(1158),
    [anon_sym_const] = ACTIONS(1158),
    [anon_sym_constexpr] = ACTIONS(1158),
    [anon_sym_volatile] = ACTIONS(1158),
    [anon_sym_restrict] = ACTIONS(1158),
    [anon_sym___restrict__] = ACTIONS(1158),
    [anon_sym__Atomic] = ACTIONS(1158),
    [anon_sym__Noreturn] = ACTIONS(1158),
    [anon_sym_noreturn] = ACTIONS(1158),
    [anon_sym__Nonnull] = ACTIONS(1158),
    [anon_sym_alignas] = ACTIONS(1158),
    [anon_sym__Alignas] = ACTIONS(1158),
    [sym_primitive_type] = ACTIONS(1158),
    [anon_sym_enum] = ACTIONS(1158),
    [anon_sym_struct] = ACTIONS(1158),
    [anon_sym_union] = ACTIONS(1158),
    [anon_sym_if] = ACTIONS(1158),
    [anon_sym_else] = ACTIONS(1158),
    [anon_sym_switch] = ACTIONS(1158),
    [anon_sym_case] = ACTIONS(1158),
    [anon_sym_default] = ACTIONS(1158),
    [anon_sym_while] = ACTIONS(1158),
    [anon_sym_do] = ACTIONS(1158),
    [anon_sym_for] = ACTIONS(1158),
    [anon_sym_return] = ACTIONS(1158),
    [anon_sym_break] = ACTIONS(1158),
    [anon_sym_continue] = ACTIONS(1158),
    [anon_sym_goto] = ACTIONS(1158),
    [anon_sym___try] = ACTIONS(1158),
    [anon_sym___leave] = ACTIONS(1158),
    [anon_sym_DASH_DASH] = ACTIONS(1160),
    [anon_sym_PLUS_PLUS] = ACTIONS(1160),
    [anon_sym_sizeof] = ACTIONS(1158),
    [anon_sym___alignof__] = ACTIONS(1158),
    [anon_sym___alignof] = ACTIONS(1158),
    [anon_sym__alignof] = ACTIONS(1158),
    [anon_sym_alignof] = ACTIONS(1158),
    [anon_sym__Alignof] = ACTIONS(1158),
    [anon_sym_offsetof] = ACTIONS(1158),
    [anon_sym__Generic] = ACTIONS(1158),
    [anon_sym_asm] = ACTIONS(1158),
    [anon_sym___asm__] = ACTIONS(1158),
    [anon_sym___asm] = ACTIONS(1158),
    [sym_number_literal] = ACTIONS(1160),
    [anon_sym_L_SQUOTE] = ACTIONS(1160),
    [anon_sym_u_SQUOTE] = ACTIONS(1160),
    [anon_sym_U_SQUOTE] = ACTIONS(1160),
    [anon_sym_u8_SQUOTE] = ACTIONS(1160),
    [anon_sym_SQUOTE] = ACTIONS(1160),
    [anon_sym_L_DQUOTE] = ACTIONS(1160),
    [anon_sym_u_DQUOTE] = ACTIONS(1160),
    [anon_sym_U_DQUOTE] = ACTIONS(1160),
    [anon_sym_u8_DQUOTE] = ACTIONS(1160),
    [anon_sym_DQUOTE] = ACTIONS(1160),
    [sym_true] = ACTIONS(1158),
    [sym_false] = ACTIONS(1158),
    [anon_sym_NULL] = ACTIONS(1158),
    [anon_sym_nullptr] = ACTIONS(1158),
    [sym_comment] = ACTIONS(3),
  },
  [89] = {
    [sym_identifier] = ACTIONS(1162),
    [aux_sym_preproc_include_token1] = ACTIONS(1162),
    [aux_sym_preproc_def_token1] = ACTIONS(1162),
    [aux_sym_preproc_if_token1] = ACTIONS(1162),
    [aux_sym_preproc_if_token2] = ACTIONS(1162),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1162),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1162),
    [aux_sym_preproc_else_token1] = ACTIONS(1162),
    [aux_sym_preproc_elif_token1] = ACTIONS(1162),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1162),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1162),
    [sym_preproc_directive] = ACTIONS(1162),
    [anon_sym_LPAREN2] = ACTIONS(1164),
    [anon_sym_BANG] = ACTIONS(1164),
    [anon_sym_TILDE] = ACTIONS(1164),
    [anon_sym_DASH] = ACTIONS(1162),
    [anon_sym_PLUS] = ACTIONS(1162),
    [anon_sym_STAR] = ACTIONS(1164),
    [anon_sym_AMP] = ACTIONS(1164),
    [anon_sym_SEMI] = ACTIONS(1164),
    [anon_sym___extension__] = ACTIONS(1162),
    [anon_sym_typedef] = ACTIONS(1162),
    [anon_sym_extern] = ACTIONS(1162),
    [anon_sym___attribute__] = ACTIONS(1162),
    [anon_sym___attribute] = ACTIONS(1162),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1164),
    [anon_sym___declspec] = ACTIONS(1162),
    [anon_sym___cdecl] = ACTIONS(1162),
    [anon_sym___clrcall] = ACTIONS(1162),
    [anon_sym___stdcall] = ACTIONS(1162),
    [anon_sym___fastcall] = ACTIONS(1162),
    [anon_sym___thiscall] = ACTIONS(1162),
    [anon_sym___vectorcall] = ACTIONS(1162),
    [anon_sym_LBRACE] = ACTIONS(1164),
    [anon_sym_signed] = ACTIONS(1162),
    [anon_sym_unsigned] = ACTIONS(1162),
    [anon_sym_long] = ACTIONS(1162),
    [anon_sym_short] = ACTIONS(1162),
    [anon_sym_static] = ACTIONS(1162),
    [anon_sym_auto] = ACTIONS(1162),
    [anon_sym_register] = ACTIONS(1162),
    [anon_sym_inline] = ACTIONS(1162),
    [anon_sym___inline] = ACTIONS(1162),
    [anon_sym___inline__] = ACTIONS(1162),
    [anon_sym___forceinline] = ACTIONS(1162),
    [anon_sym_thread_local] = ACTIONS(1162),
    [anon_sym___thread] = ACTIONS(1162),
    [anon_sym_const] = ACTIONS(1162),
    [anon_sym_constexpr] = ACTIONS(1162),
    [anon_sym_volatile] = ACTIONS(1162),
    [anon_sym_restrict] = ACTIONS(1162),
    [anon_sym___restrict__] = ACTIONS(1162),
    [anon_sym__Atomic] = ACTIONS(1162),
    [anon_sym__Noreturn] = ACTIONS(1162),
    [anon_sym_noreturn] = ACTIONS(1162),
    [anon_sym__Nonnull] = ACTIONS(1162),
    [anon_sym_alignas] = ACTIONS(1162),
    [anon_sym__Alignas] = ACTIONS(1162),
    [sym_primitive_type] = ACTIONS(1162),
    [anon_sym_enum] = ACTIONS(1162),
    [anon_sym_struct] = ACTIONS(1162),
    [anon_sym_union] = ACTIONS(1162),
    [anon_sym_if] = ACTIONS(1162),
    [anon_sym_else] = ACTIONS(1162),
    [anon_sym_switch] = ACTIONS(1162),
    [anon_sym_case] = ACTIONS(1162),
    [anon_sym_default] = ACTIONS(1162),
    [anon_sym_while] = ACTIONS(1162),
    [anon_sym_do] = ACTIONS(1162),
    [anon_sym_for] = ACTIONS(1162),
    [anon_sym_return] = ACTIONS(1162),
    [anon_sym_break] = ACTIONS(1162),
    [anon_sym_continue] = ACTIONS(1162),
    [anon_sym_goto] = ACTIONS(1162),
    [anon_sym___try] = ACTIONS(1162),
    [anon_sym___leave] = ACTIONS(1162),
    [anon_sym_DASH_DASH] = ACTIONS(1164),
    [anon_sym_PLUS_PLUS] = ACTIONS(1164),
    [anon_sym_sizeof] = ACTIONS(1162),
    [anon_sym___alignof__] = ACTIONS(1162),
    [anon_sym___alignof] = ACTIONS(1162),
    [anon_sym__alignof] = ACTIONS(1162),
    [anon_sym_alignof] = ACTIONS(1162),
    [anon_sym__Alignof] = ACTIONS(1162),
    [anon_sym_offsetof] = ACTIONS(1162),
    [anon_sym__Generic] = ACTIONS(1162),
    [anon_sym_asm] = ACTIONS(1162),
    [anon_sym___asm__] = ACTIONS(1162),
    [anon_sym___asm] = ACTIONS(1162),
    [sym_number_literal] = ACTIONS(1164),
    [anon_sym_L_SQUOTE] = ACTIONS(1164),
    [anon_sym_u_SQUOTE] = ACTIONS(1164),
    [anon_sym_U_SQUOTE] = ACTIONS(1164),
    [anon_sym_u8_SQUOTE] = ACTIONS(1164),
    [anon_sym_SQUOTE] = ACTIONS(1164),
    [anon_sym_L_DQUOTE] = ACTIONS(1164),
    [anon_sym_u_DQUOTE] = ACTIONS(1164),
    [anon_sym_U_DQUOTE] = ACTIONS(1164),
    [anon_sym_u8_DQUOTE] = ACTIONS(1164),
    [anon_sym_DQUOTE] = ACTIONS(1164),
    [sym_true] = ACTIONS(1162),
    [sym_false] = ACTIONS(1162),
    [anon_sym_NULL] = ACTIONS(1162),
    [anon_sym_nullptr] = ACTIONS(1162),
    [sym_comment] = ACTIONS(3),
  },
  [90] = {
    [sym_identifier] = ACTIONS(1166),
    [aux_sym_preproc_include_token1] = ACTIONS(1166),
    [aux_sym_preproc_def_token1] = ACTIONS(1166),
    [aux_sym_preproc_if_token1] = ACTIONS(1166),
    [aux_sym_preproc_if_token2] = ACTIONS(1166),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1166),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1166),
    [aux_sym_preproc_else_token1] = ACTIONS(1166),
    [aux_sym_preproc_elif_token1] = ACTIONS(1166),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1166),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1166),
    [sym_preproc_directive] = ACTIONS(1166),
    [anon_sym_LPAREN2] = ACTIONS(1168),
    [anon_sym_BANG] = ACTIONS(1168),
    [anon_sym_TILDE] = ACTIONS(1168),
    [anon_sym_DASH] = ACTIONS(1166),
    [anon_sym_PLUS] = ACTIONS(1166),
    [anon_sym_STAR] = ACTIONS(1168),
    [anon_sym_AMP] = ACTIONS(1168),
    [anon_sym_SEMI] = ACTIONS(1168),
    [anon_sym___extension__] = ACTIONS(1166),
    [anon_sym_typedef] = ACTIONS(1166),
    [anon_sym_extern] = ACTIONS(1166),
    [anon_sym___attribute__] = ACTIONS(1166),
    [anon_sym___attribute] = ACTIONS(1166),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1168),
    [anon_sym___declspec] = ACTIONS(1166),
    [anon_sym___cdecl] = ACTIONS(1166),
    [anon_sym___clrcall] = ACTIONS(1166),
    [anon_sym___stdcall] = ACTIONS(1166),
    [anon_sym___fastcall] = ACTIONS(1166),
    [anon_sym___thiscall] = ACTIONS(1166),
    [anon_sym___vectorcall] = ACTIONS(1166),
    [anon_sym_LBRACE] = ACTIONS(1168),
    [anon_sym_signed] = ACTIONS(1166),
    [anon_sym_unsigned] = ACTIONS(1166),
    [anon_sym_long] = ACTIONS(1166),
    [anon_sym_short] = ACTIONS(1166),
    [anon_sym_static] = ACTIONS(1166),
    [anon_sym_auto] = ACTIONS(1166),
    [anon_sym_register] = ACTIONS(1166),
    [anon_sym_inline] = ACTIONS(1166),
    [anon_sym___inline] = ACTIONS(1166),
    [anon_sym___inline__] = ACTIONS(1166),
    [anon_sym___forceinline] = ACTIONS(1166),
    [anon_sym_thread_local] = ACTIONS(1166),
    [anon_sym___thread] = ACTIONS(1166),
    [anon_sym_const] = ACTIONS(1166),
    [anon_sym_constexpr] = ACTIONS(1166),
    [anon_sym_volatile] = ACTIONS(1166),
    [anon_sym_restrict] = ACTIONS(1166),
    [anon_sym___restrict__] = ACTIONS(1166),
    [anon_sym__Atomic] = ACTIONS(1166),
    [anon_sym__Noreturn] = ACTIONS(1166),
    [anon_sym_noreturn] = ACTIONS(1166),
    [anon_sym__Nonnull] = ACTIONS(1166),
    [anon_sym_alignas] = ACTIONS(1166),
    [anon_sym__Alignas] = ACTIONS(1166),
    [sym_primitive_type] = ACTIONS(1166),
    [anon_sym_enum] = ACTIONS(1166),
    [anon_sym_struct] = ACTIONS(1166),
    [anon_sym_union] = ACTIONS(1166),
    [anon_sym_if] = ACTIONS(1166),
    [anon_sym_else] = ACTIONS(1166),
    [anon_sym_switch] = ACTIONS(1166),
    [anon_sym_case] = ACTIONS(1166),
    [anon_sym_default] = ACTIONS(1166),
    [anon_sym_while] = ACTIONS(1166),
    [anon_sym_do] = ACTIONS(1166),
    [anon_sym_for] = ACTIONS(1166),
    [anon_sym_return] = ACTIONS(1166),
    [anon_sym_break] = ACTIONS(1166),
    [anon_sym_continue] = ACTIONS(1166),
    [anon_sym_goto] = ACTIONS(1166),
    [anon_sym___try] = ACTIONS(1166),
    [anon_sym___leave] = ACTIONS(1166),
    [anon_sym_DASH_DASH] = ACTIONS(1168),
    [anon_sym_PLUS_PLUS] = ACTIONS(1168),
    [anon_sym_sizeof] = ACTIONS(1166),
    [anon_sym___alignof__] = ACTIONS(1166),
    [anon_sym___alignof] = ACTIONS(1166),
    [anon_sym__alignof] = ACTIONS(1166),
    [anon_sym_alignof] = ACTIONS(1166),
    [anon_sym__Alignof] = ACTIONS(1166),
    [anon_sym_offsetof] = ACTIONS(1166),
    [anon_sym__Generic] = ACTIONS(1166),
    [anon_sym_asm] = ACTIONS(1166),
    [anon_sym___asm__] = ACTIONS(1166),
    [anon_sym___asm] = ACTIONS(1166),
    [sym_number_literal] = ACTIONS(1168),
    [anon_sym_L_SQUOTE] = ACTIONS(1168),
    [anon_sym_u_SQUOTE] = ACTIONS(1168),
    [anon_sym_U_SQUOTE] = ACTIONS(1168),
    [anon_sym_u8_SQUOTE] = ACTIONS(1168),
    [anon_sym_SQUOTE] = ACTIONS(1168),
    [anon_sym_L_DQUOTE] = ACTIONS(1168),
    [anon_sym_u_DQUOTE] = ACTIONS(1168),
    [anon_sym_U_DQUOTE] = ACTIONS(1168),
    [anon_sym_u8_DQUOTE] = ACTIONS(1168),
    [anon_sym_DQUOTE] = ACTIONS(1168),
    [sym_true] = ACTIONS(1166),
    [sym_false] = ACTIONS(1166),
    [anon_sym_NULL] = ACTIONS(1166),
    [anon_sym_nullptr] = ACTIONS(1166),
    [sym_comment] = ACTIONS(3),
  },
  [91] = {
    [sym_identifier] = ACTIONS(1170),
    [aux_sym_preproc_include_token1] = ACTIONS(1170),
    [aux_sym_preproc_def_token1] = ACTIONS(1170),
    [aux_sym_preproc_if_token1] = ACTIONS(1170),
    [aux_sym_preproc_if_token2] = ACTIONS(1170),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1170),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1170),
    [aux_sym_preproc_else_token1] = ACTIONS(1170),
    [aux_sym_preproc_elif_token1] = ACTIONS(1170),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1170),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1170),
    [sym_preproc_directive] = ACTIONS(1170),
    [anon_sym_LPAREN2] = ACTIONS(1172),
    [anon_sym_BANG] = ACTIONS(1172),
    [anon_sym_TILDE] = ACTIONS(1172),
    [anon_sym_DASH] = ACTIONS(1170),
    [anon_sym_PLUS] = ACTIONS(1170),
    [anon_sym_STAR] = ACTIONS(1172),
    [anon_sym_AMP] = ACTIONS(1172),
    [anon_sym_SEMI] = ACTIONS(1172),
    [anon_sym___extension__] = ACTIONS(1170),
    [anon_sym_typedef] = ACTIONS(1170),
    [anon_sym_extern] = ACTIONS(1170),
    [anon_sym___attribute__] = ACTIONS(1170),
    [anon_sym___attribute] = ACTIONS(1170),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1172),
    [anon_sym___declspec] = ACTIONS(1170),
    [anon_sym___cdecl] = ACTIONS(1170),
    [anon_sym___clrcall] = ACTIONS(1170),
    [anon_sym___stdcall] = ACTIONS(1170),
    [anon_sym___fastcall] = ACTIONS(1170),
    [anon_sym___thiscall] = ACTIONS(1170),
    [anon_sym___vectorcall] = ACTIONS(1170),
    [anon_sym_LBRACE] = ACTIONS(1172),
    [anon_sym_signed] = ACTIONS(1170),
    [anon_sym_unsigned] = ACTIONS(1170),
    [anon_sym_long] = ACTIONS(1170),
    [anon_sym_short] = ACTIONS(1170),
    [anon_sym_static] = ACTIONS(1170),
    [anon_sym_auto] = ACTIONS(1170),
    [anon_sym_register] = ACTIONS(1170),
    [anon_sym_inline] = ACTIONS(1170),
    [anon_sym___inline] = ACTIONS(1170),
    [anon_sym___inline__] = ACTIONS(1170),
    [anon_sym___forceinline] = ACTIONS(1170),
    [anon_sym_thread_local] = ACTIONS(1170),
    [anon_sym___thread] = ACTIONS(1170),
    [anon_sym_const] = ACTIONS(1170),
    [anon_sym_constexpr] = ACTIONS(1170),
    [anon_sym_volatile] = ACTIONS(1170),
    [anon_sym_restrict] = ACTIONS(1170),
    [anon_sym___restrict__] = ACTIONS(1170),
    [anon_sym__Atomic] = ACTIONS(1170),
    [anon_sym__Noreturn] = ACTIONS(1170),
    [anon_sym_noreturn] = ACTIONS(1170),
    [anon_sym__Nonnull] = ACTIONS(1170),
    [anon_sym_alignas] = ACTIONS(1170),
    [anon_sym__Alignas] = ACTIONS(1170),
    [sym_primitive_type] = ACTIONS(1170),
    [anon_sym_enum] = ACTIONS(1170),
    [anon_sym_struct] = ACTIONS(1170),
    [anon_sym_union] = ACTIONS(1170),
    [anon_sym_if] = ACTIONS(1170),
    [anon_sym_else] = ACTIONS(1170),
    [anon_sym_switch] = ACTIONS(1170),
    [anon_sym_case] = ACTIONS(1170),
    [anon_sym_default] = ACTIONS(1170),
    [anon_sym_while] = ACTIONS(1170),
    [anon_sym_do] = ACTIONS(1170),
    [anon_sym_for] = ACTIONS(1170),
    [anon_sym_return] = ACTIONS(1170),
    [anon_sym_break] = ACTIONS(1170),
    [anon_sym_continue] = ACTIONS(1170),
    [anon_sym_goto] = ACTIONS(1170),
    [anon_sym___try] = ACTIONS(1170),
    [anon_sym___leave] = ACTIONS(1170),
    [anon_sym_DASH_DASH] = ACTIONS(1172),
    [anon_sym_PLUS_PLUS] = ACTIONS(1172),
    [anon_sym_sizeof] = ACTIONS(1170),
    [anon_sym___alignof__] = ACTIONS(1170),
    [anon_sym___alignof] = ACTIONS(1170),
    [anon_sym__alignof] = ACTIONS(1170),
    [anon_sym_alignof] = ACTIONS(1170),
    [anon_sym__Alignof] = ACTIONS(1170),
    [anon_sym_offsetof] = ACTIONS(1170),
    [anon_sym__Generic] = ACTIONS(1170),
    [anon_sym_asm] = ACTIONS(1170),
    [anon_sym___asm__] = ACTIONS(1170),
    [anon_sym___asm] = ACTIONS(1170),
    [sym_number_literal] = ACTIONS(1172),
    [anon_sym_L_SQUOTE] = ACTIONS(1172),
    [anon_sym_u_SQUOTE] = ACTIONS(1172),
    [anon_sym_U_SQUOTE] = ACTIONS(1172),
    [anon_sym_u8_SQUOTE] = ACTIONS(1172),
    [anon_sym_SQUOTE] = ACTIONS(1172),
    [anon_sym_L_DQUOTE] = ACTIONS(1172),
    [anon_sym_u_DQUOTE] = ACTIONS(1172),
    [anon_sym_U_DQUOTE] = ACTIONS(1172),
    [anon_sym_u8_DQUOTE] = ACTIONS(1172),
    [anon_sym_DQUOTE] = ACTIONS(1172),
    [sym_true] = ACTIONS(1170),
    [sym_false] = ACTIONS(1170),
    [anon_sym_NULL] = ACTIONS(1170),
    [anon_sym_nullptr] = ACTIONS(1170),
    [sym_comment] = ACTIONS(3),
  },
  [92] = {
    [sym_identifier] = ACTIONS(1170),
    [aux_sym_preproc_include_token1] = ACTIONS(1170),
    [aux_sym_preproc_def_token1] = ACTIONS(1170),
    [aux_sym_preproc_if_token1] = ACTIONS(1170),
    [aux_sym_preproc_if_token2] = ACTIONS(1170),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1170),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1170),
    [aux_sym_preproc_else_token1] = ACTIONS(1170),
    [aux_sym_preproc_elif_token1] = ACTIONS(1170),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1170),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1170),
    [sym_preproc_directive] = ACTIONS(1170),
    [anon_sym_LPAREN2] = ACTIONS(1172),
    [anon_sym_BANG] = ACTIONS(1172),
    [anon_sym_TILDE] = ACTIONS(1172),
    [anon_sym_DASH] = ACTIONS(1170),
    [anon_sym_PLUS] = ACTIONS(1170),
    [anon_sym_STAR] = ACTIONS(1172),
    [anon_sym_AMP] = ACTIONS(1172),
    [anon_sym_SEMI] = ACTIONS(1172),
    [anon_sym___extension__] = ACTIONS(1170),
    [anon_sym_typedef] = ACTIONS(1170),
    [anon_sym_extern] = ACTIONS(1170),
    [anon_sym___attribute__] = ACTIONS(1170),
    [anon_sym___attribute] = ACTIONS(1170),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1172),
    [anon_sym___declspec] = ACTIONS(1170),
    [anon_sym___cdecl] = ACTIONS(1170),
    [anon_sym___clrcall] = ACTIONS(1170),
    [anon_sym___stdcall] = ACTIONS(1170),
    [anon_sym___fastcall] = ACTIONS(1170),
    [anon_sym___thiscall] = ACTIONS(1170),
    [anon_sym___vectorcall] = ACTIONS(1170),
    [anon_sym_LBRACE] = ACTIONS(1172),
    [anon_sym_signed] = ACTIONS(1170),
    [anon_sym_unsigned] = ACTIONS(1170),
    [anon_sym_long] = ACTIONS(1170),
    [anon_sym_short] = ACTIONS(1170),
    [anon_sym_static] = ACTIONS(1170),
    [anon_sym_auto] = ACTIONS(1170),
    [anon_sym_register] = ACTIONS(1170),
    [anon_sym_inline] = ACTIONS(1170),
    [anon_sym___inline] = ACTIONS(1170),
    [anon_sym___inline__] = ACTIONS(1170),
    [anon_sym___forceinline] = ACTIONS(1170),
    [anon_sym_thread_local] = ACTIONS(1170),
    [anon_sym___thread] = ACTIONS(1170),
    [anon_sym_const] = ACTIONS(1170),
    [anon_sym_constexpr] = ACTIONS(1170),
    [anon_sym_volatile] = ACTIONS(1170),
    [anon_sym_restrict] = ACTIONS(1170),
    [anon_sym___restrict__] = ACTIONS(1170),
    [anon_sym__Atomic] = ACTIONS(1170),
    [anon_sym__Noreturn] = ACTIONS(1170),
    [anon_sym_noreturn] = ACTIONS(1170),
    [anon_sym__Nonnull] = ACTIONS(1170),
    [anon_sym_alignas] = ACTIONS(1170),
    [anon_sym__Alignas] = ACTIONS(1170),
    [sym_primitive_type] = ACTIONS(1170),
    [anon_sym_enum] = ACTIONS(1170),
    [anon_sym_struct] = ACTIONS(1170),
    [anon_sym_union] = ACTIONS(1170),
    [anon_sym_if] = ACTIONS(1170),
    [anon_sym_else] = ACTIONS(1170),
    [anon_sym_switch] = ACTIONS(1170),
    [anon_sym_case] = ACTIONS(1170),
    [anon_sym_default] = ACTIONS(1170),
    [anon_sym_while] = ACTIONS(1170),
    [anon_sym_do] = ACTIONS(1170),
    [anon_sym_for] = ACTIONS(1170),
    [anon_sym_return] = ACTIONS(1170),
    [anon_sym_break] = ACTIONS(1170),
    [anon_sym_continue] = ACTIONS(1170),
    [anon_sym_goto] = ACTIONS(1170),
    [anon_sym___try] = ACTIONS(1170),
    [anon_sym___leave] = ACTIONS(1170),
    [anon_sym_DASH_DASH] = ACTIONS(1172),
    [anon_sym_PLUS_PLUS] = ACTIONS(1172),
    [anon_sym_sizeof] = ACTIONS(1170),
    [anon_sym___alignof__] = ACTIONS(1170),
    [anon_sym___alignof] = ACTIONS(1170),
    [anon_sym__alignof] = ACTIONS(1170),
    [anon_sym_alignof] = ACTIONS(1170),
    [anon_sym__Alignof] = ACTIONS(1170),
    [anon_sym_offsetof] = ACTIONS(1170),
    [anon_sym__Generic] = ACTIONS(1170),
    [anon_sym_asm] = ACTIONS(1170),
    [anon_sym___asm__] = ACTIONS(1170),
    [anon_sym___asm] = ACTIONS(1170),
    [sym_number_literal] = ACTIONS(1172),
    [anon_sym_L_SQUOTE] = ACTIONS(1172),
    [anon_sym_u_SQUOTE] = ACTIONS(1172),
    [anon_sym_U_SQUOTE] = ACTIONS(1172),
    [anon_sym_u8_SQUOTE] = ACTIONS(1172),
    [anon_sym_SQUOTE] = ACTIONS(1172),
    [anon_sym_L_DQUOTE] = ACTIONS(1172),
    [anon_sym_u_DQUOTE] = ACTIONS(1172),
    [anon_sym_U_DQUOTE] = ACTIONS(1172),
    [anon_sym_u8_DQUOTE] = ACTIONS(1172),
    [anon_sym_DQUOTE] = ACTIONS(1172),
    [sym_true] = ACTIONS(1170),
    [sym_false] = ACTIONS(1170),
    [anon_sym_NULL] = ACTIONS(1170),
    [anon_sym_nullptr] = ACTIONS(1170),
    [sym_comment] = ACTIONS(3),
  },
  [93] = {
    [sym_identifier] = ACTIONS(1174),
    [aux_sym_preproc_include_token1] = ACTIONS(1174),
    [aux_sym_preproc_def_token1] = ACTIONS(1174),
    [aux_sym_preproc_if_token1] = ACTIONS(1174),
    [aux_sym_preproc_if_token2] = ACTIONS(1174),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1174),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1174),
    [aux_sym_preproc_else_token1] = ACTIONS(1174),
    [aux_sym_preproc_elif_token1] = ACTIONS(1174),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1174),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1174),
    [sym_preproc_directive] = ACTIONS(1174),
    [anon_sym_LPAREN2] = ACTIONS(1176),
    [anon_sym_BANG] = ACTIONS(1176),
    [anon_sym_TILDE] = ACTIONS(1176),
    [anon_sym_DASH] = ACTIONS(1174),
    [anon_sym_PLUS] = ACTIONS(1174),
    [anon_sym_STAR] = ACTIONS(1176),
    [anon_sym_AMP] = ACTIONS(1176),
    [anon_sym_SEMI] = ACTIONS(1176),
    [anon_sym___extension__] = ACTIONS(1174),
    [anon_sym_typedef] = ACTIONS(1174),
    [anon_sym_extern] = ACTIONS(1174),
    [anon_sym___attribute__] = ACTIONS(1174),
    [anon_sym___attribute] = ACTIONS(1174),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1176),
    [anon_sym___declspec] = ACTIONS(1174),
    [anon_sym___cdecl] = ACTIONS(1174),
    [anon_sym___clrcall] = ACTIONS(1174),
    [anon_sym___stdcall] = ACTIONS(1174),
    [anon_sym___fastcall] = ACTIONS(1174),
    [anon_sym___thiscall] = ACTIONS(1174),
    [anon_sym___vectorcall] = ACTIONS(1174),
    [anon_sym_LBRACE] = ACTIONS(1176),
    [anon_sym_signed] = ACTIONS(1174),
    [anon_sym_unsigned] = ACTIONS(1174),
    [anon_sym_long] = ACTIONS(1174),
    [anon_sym_short] = ACTIONS(1174),
    [anon_sym_static] = ACTIONS(1174),
    [anon_sym_auto] = ACTIONS(1174),
    [anon_sym_register] = ACTIONS(1174),
    [anon_sym_inline] = ACTIONS(1174),
    [anon_sym___inline] = ACTIONS(1174),
    [anon_sym___inline__] = ACTIONS(1174),
    [anon_sym___forceinline] = ACTIONS(1174),
    [anon_sym_thread_local] = ACTIONS(1174),
    [anon_sym___thread] = ACTIONS(1174),
    [anon_sym_const] = ACTIONS(1174),
    [anon_sym_constexpr] = ACTIONS(1174),
    [anon_sym_volatile] = ACTIONS(1174),
    [anon_sym_restrict] = ACTIONS(1174),
    [anon_sym___restrict__] = ACTIONS(1174),
    [anon_sym__Atomic] = ACTIONS(1174),
    [anon_sym__Noreturn] = ACTIONS(1174),
    [anon_sym_noreturn] = ACTIONS(1174),
    [anon_sym__Nonnull] = ACTIONS(1174),
    [anon_sym_alignas] = ACTIONS(1174),
    [anon_sym__Alignas] = ACTIONS(1174),
    [sym_primitive_type] = ACTIONS(1174),
    [anon_sym_enum] = ACTIONS(1174),
    [anon_sym_struct] = ACTIONS(1174),
    [anon_sym_union] = ACTIONS(1174),
    [anon_sym_if] = ACTIONS(1174),
    [anon_sym_else] = ACTIONS(1174),
    [anon_sym_switch] = ACTIONS(1174),
    [anon_sym_case] = ACTIONS(1174),
    [anon_sym_default] = ACTIONS(1174),
    [anon_sym_while] = ACTIONS(1174),
    [anon_sym_do] = ACTIONS(1174),
    [anon_sym_for] = ACTIONS(1174),
    [anon_sym_return] = ACTIONS(1174),
    [anon_sym_break] = ACTIONS(1174),
    [anon_sym_continue] = ACTIONS(1174),
    [anon_sym_goto] = ACTIONS(1174),
    [anon_sym___try] = ACTIONS(1174),
    [anon_sym___leave] = ACTIONS(1174),
    [anon_sym_DASH_DASH] = ACTIONS(1176),
    [anon_sym_PLUS_PLUS] = ACTIONS(1176),
    [anon_sym_sizeof] = ACTIONS(1174),
    [anon_sym___alignof__] = ACTIONS(1174),
    [anon_sym___alignof] = ACTIONS(1174),
    [anon_sym__alignof] = ACTIONS(1174),
    [anon_sym_alignof] = ACTIONS(1174),
    [anon_sym__Alignof] = ACTIONS(1174),
    [anon_sym_offsetof] = ACTIONS(1174),
    [anon_sym__Generic] = ACTIONS(1174),
    [anon_sym_asm] = ACTIONS(1174),
    [anon_sym___asm__] = ACTIONS(1174),
    [anon_sym___asm] = ACTIONS(1174),
    [sym_number_literal] = ACTIONS(1176),
    [anon_sym_L_SQUOTE] = ACTIONS(1176),
    [anon_sym_u_SQUOTE] = ACTIONS(1176),
    [anon_sym_U_SQUOTE] = ACTIONS(1176),
    [anon_sym_u8_SQUOTE] = ACTIONS(1176),
    [anon_sym_SQUOTE] = ACTIONS(1176),
    [anon_sym_L_DQUOTE] = ACTIONS(1176),
    [anon_sym_u_DQUOTE] = ACTIONS(1176),
    [anon_sym_U_DQUOTE] = ACTIONS(1176),
    [anon_sym_u8_DQUOTE] = ACTIONS(1176),
    [anon_sym_DQUOTE] = ACTIONS(1176),
    [sym_true] = ACTIONS(1174),
    [sym_false] = ACTIONS(1174),
    [anon_sym_NULL] = ACTIONS(1174),
    [anon_sym_nullptr] = ACTIONS(1174),
    [sym_comment] = ACTIONS(3),
  },
  [94] = {
    [sym_identifier] = ACTIONS(1174),
    [aux_sym_preproc_include_token1] = ACTIONS(1174),
    [aux_sym_preproc_def_token1] = ACTIONS(1174),
    [aux_sym_preproc_if_token1] = ACTIONS(1174),
    [aux_sym_preproc_if_token2] = ACTIONS(1174),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1174),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1174),
    [aux_sym_preproc_else_token1] = ACTIONS(1174),
    [aux_sym_preproc_elif_token1] = ACTIONS(1174),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1174),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1174),
    [sym_preproc_directive] = ACTIONS(1174),
    [anon_sym_LPAREN2] = ACTIONS(1176),
    [anon_sym_BANG] = ACTIONS(1176),
    [anon_sym_TILDE] = ACTIONS(1176),
    [anon_sym_DASH] = ACTIONS(1174),
    [anon_sym_PLUS] = ACTIONS(1174),
    [anon_sym_STAR] = ACTIONS(1176),
    [anon_sym_AMP] = ACTIONS(1176),
    [anon_sym_SEMI] = ACTIONS(1176),
    [anon_sym___extension__] = ACTIONS(1174),
    [anon_sym_typedef] = ACTIONS(1174),
    [anon_sym_extern] = ACTIONS(1174),
    [anon_sym___attribute__] = ACTIONS(1174),
    [anon_sym___attribute] = ACTIONS(1174),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1176),
    [anon_sym___declspec] = ACTIONS(1174),
    [anon_sym___cdecl] = ACTIONS(1174),
    [anon_sym___clrcall] = ACTIONS(1174),
    [anon_sym___stdcall] = ACTIONS(1174),
    [anon_sym___fastcall] = ACTIONS(1174),
    [anon_sym___thiscall] = ACTIONS(1174),
    [anon_sym___vectorcall] = ACTIONS(1174),
    [anon_sym_LBRACE] = ACTIONS(1176),
    [anon_sym_signed] = ACTIONS(1174),
    [anon_sym_unsigned] = ACTIONS(1174),
    [anon_sym_long] = ACTIONS(1174),
    [anon_sym_short] = ACTIONS(1174),
    [anon_sym_static] = ACTIONS(1174),
    [anon_sym_auto] = ACTIONS(1174),
    [anon_sym_register] = ACTIONS(1174),
    [anon_sym_inline] = ACTIONS(1174),
    [anon_sym___inline] = ACTIONS(1174),
    [anon_sym___inline__] = ACTIONS(1174),
    [anon_sym___forceinline] = ACTIONS(1174),
    [anon_sym_thread_local] = ACTIONS(1174),
    [anon_sym___thread] = ACTIONS(1174),
    [anon_sym_const] = ACTIONS(1174),
    [anon_sym_constexpr] = ACTIONS(1174),
    [anon_sym_volatile] = ACTIONS(1174),
    [anon_sym_restrict] = ACTIONS(1174),
    [anon_sym___restrict__] = ACTIONS(1174),
    [anon_sym__Atomic] = ACTIONS(1174),
    [anon_sym__Noreturn] = ACTIONS(1174),
    [anon_sym_noreturn] = ACTIONS(1174),
    [anon_sym__Nonnull] = ACTIONS(1174),
    [anon_sym_alignas] = ACTIONS(1174),
    [anon_sym__Alignas] = ACTIONS(1174),
    [sym_primitive_type] = ACTIONS(1174),
    [anon_sym_enum] = ACTIONS(1174),
    [anon_sym_struct] = ACTIONS(1174),
    [anon_sym_union] = ACTIONS(1174),
    [anon_sym_if] = ACTIONS(1174),
    [anon_sym_else] = ACTIONS(1174),
    [anon_sym_switch] = ACTIONS(1174),
    [anon_sym_case] = ACTIONS(1174),
    [anon_sym_default] = ACTIONS(1174),
    [anon_sym_while] = ACTIONS(1174),
    [anon_sym_do] = ACTIONS(1174),
    [anon_sym_for] = ACTIONS(1174),
    [anon_sym_return] = ACTIONS(1174),
    [anon_sym_break] = ACTIONS(1174),
    [anon_sym_continue] = ACTIONS(1174),
    [anon_sym_goto] = ACTIONS(1174),
    [anon_sym___try] = ACTIONS(1174),
    [anon_sym___leave] = ACTIONS(1174),
    [anon_sym_DASH_DASH] = ACTIONS(1176),
    [anon_sym_PLUS_PLUS] = ACTIONS(1176),
    [anon_sym_sizeof] = ACTIONS(1174),
    [anon_sym___alignof__] = ACTIONS(1174),
    [anon_sym___alignof] = ACTIONS(1174),
    [anon_sym__alignof] = ACTIONS(1174),
    [anon_sym_alignof] = ACTIONS(1174),
    [anon_sym__Alignof] = ACTIONS(1174),
    [anon_sym_offsetof] = ACTIONS(1174),
    [anon_sym__Generic] = ACTIONS(1174),
    [anon_sym_asm] = ACTIONS(1174),
    [anon_sym___asm__] = ACTIONS(1174),
    [anon_sym___asm] = ACTIONS(1174),
    [sym_number_literal] = ACTIONS(1176),
    [anon_sym_L_SQUOTE] = ACTIONS(1176),
    [anon_sym_u_SQUOTE] = ACTIONS(1176),
    [anon_sym_U_SQUOTE] = ACTIONS(1176),
    [anon_sym_u8_SQUOTE] = ACTIONS(1176),
    [anon_sym_SQUOTE] = ACTIONS(1176),
    [anon_sym_L_DQUOTE] = ACTIONS(1176),
    [anon_sym_u_DQUOTE] = ACTIONS(1176),
    [anon_sym_U_DQUOTE] = ACTIONS(1176),
    [anon_sym_u8_DQUOTE] = ACTIONS(1176),
    [anon_sym_DQUOTE] = ACTIONS(1176),
    [sym_true] = ACTIONS(1174),
    [sym_false] = ACTIONS(1174),
    [anon_sym_NULL] = ACTIONS(1174),
    [anon_sym_nullptr] = ACTIONS(1174),
    [sym_comment] = ACTIONS(3),
  },
  [95] = {
    [sym_identifier] = ACTIONS(1178),
    [aux_sym_preproc_include_token1] = ACTIONS(1178),
    [aux_sym_preproc_def_token1] = ACTIONS(1178),
    [aux_sym_preproc_if_token1] = ACTIONS(1178),
    [aux_sym_preproc_if_token2] = ACTIONS(1178),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1178),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1178),
    [aux_sym_preproc_else_token1] = ACTIONS(1178),
    [aux_sym_preproc_elif_token1] = ACTIONS(1178),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1178),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1178),
    [sym_preproc_directive] = ACTIONS(1178),
    [anon_sym_LPAREN2] = ACTIONS(1180),
    [anon_sym_BANG] = ACTIONS(1180),
    [anon_sym_TILDE] = ACTIONS(1180),
    [anon_sym_DASH] = ACTIONS(1178),
    [anon_sym_PLUS] = ACTIONS(1178),
    [anon_sym_STAR] = ACTIONS(1180),
    [anon_sym_AMP] = ACTIONS(1180),
    [anon_sym_SEMI] = ACTIONS(1180),
    [anon_sym___extension__] = ACTIONS(1178),
    [anon_sym_typedef] = ACTIONS(1178),
    [anon_sym_extern] = ACTIONS(1178),
    [anon_sym___attribute__] = ACTIONS(1178),
    [anon_sym___attribute] = ACTIONS(1178),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1180),
    [anon_sym___declspec] = ACTIONS(1178),
    [anon_sym___cdecl] = ACTIONS(1178),
    [anon_sym___clrcall] = ACTIONS(1178),
    [anon_sym___stdcall] = ACTIONS(1178),
    [anon_sym___fastcall] = ACTIONS(1178),
    [anon_sym___thiscall] = ACTIONS(1178),
    [anon_sym___vectorcall] = ACTIONS(1178),
    [anon_sym_LBRACE] = ACTIONS(1180),
    [anon_sym_signed] = ACTIONS(1178),
    [anon_sym_unsigned] = ACTIONS(1178),
    [anon_sym_long] = ACTIONS(1178),
    [anon_sym_short] = ACTIONS(1178),
    [anon_sym_static] = ACTIONS(1178),
    [anon_sym_auto] = ACTIONS(1178),
    [anon_sym_register] = ACTIONS(1178),
    [anon_sym_inline] = ACTIONS(1178),
    [anon_sym___inline] = ACTIONS(1178),
    [anon_sym___inline__] = ACTIONS(1178),
    [anon_sym___forceinline] = ACTIONS(1178),
    [anon_sym_thread_local] = ACTIONS(1178),
    [anon_sym___thread] = ACTIONS(1178),
    [anon_sym_const] = ACTIONS(1178),
    [anon_sym_constexpr] = ACTIONS(1178),
    [anon_sym_volatile] = ACTIONS(1178),
    [anon_sym_restrict] = ACTIONS(1178),
    [anon_sym___restrict__] = ACTIONS(1178),
    [anon_sym__Atomic] = ACTIONS(1178),
    [anon_sym__Noreturn] = ACTIONS(1178),
    [anon_sym_noreturn] = ACTIONS(1178),
    [anon_sym__Nonnull] = ACTIONS(1178),
    [anon_sym_alignas] = ACTIONS(1178),
    [anon_sym__Alignas] = ACTIONS(1178),
    [sym_primitive_type] = ACTIONS(1178),
    [anon_sym_enum] = ACTIONS(1178),
    [anon_sym_struct] = ACTIONS(1178),
    [anon_sym_union] = ACTIONS(1178),
    [anon_sym_if] = ACTIONS(1178),
    [anon_sym_else] = ACTIONS(1178),
    [anon_sym_switch] = ACTIONS(1178),
    [anon_sym_case] = ACTIONS(1178),
    [anon_sym_default] = ACTIONS(1178),
    [anon_sym_while] = ACTIONS(1178),
    [anon_sym_do] = ACTIONS(1178),
    [anon_sym_for] = ACTIONS(1178),
    [anon_sym_return] = ACTIONS(1178),
    [anon_sym_break] = ACTIONS(1178),
    [anon_sym_continue] = ACTIONS(1178),
    [anon_sym_goto] = ACTIONS(1178),
    [anon_sym___try] = ACTIONS(1178),
    [anon_sym___leave] = ACTIONS(1178),
    [anon_sym_DASH_DASH] = ACTIONS(1180),
    [anon_sym_PLUS_PLUS] = ACTIONS(1180),
    [anon_sym_sizeof] = ACTIONS(1178),
    [anon_sym___alignof__] = ACTIONS(1178),
    [anon_sym___alignof] = ACTIONS(1178),
    [anon_sym__alignof] = ACTIONS(1178),
    [anon_sym_alignof] = ACTIONS(1178),
    [anon_sym__Alignof] = ACTIONS(1178),
    [anon_sym_offsetof] = ACTIONS(1178),
    [anon_sym__Generic] = ACTIONS(1178),
    [anon_sym_asm] = ACTIONS(1178),
    [anon_sym___asm__] = ACTIONS(1178),
    [anon_sym___asm] = ACTIONS(1178),
    [sym_number_literal] = ACTIONS(1180),
    [anon_sym_L_SQUOTE] = ACTIONS(1180),
    [anon_sym_u_SQUOTE] = ACTIONS(1180),
    [anon_sym_U_SQUOTE] = ACTIONS(1180),
    [anon_sym_u8_SQUOTE] = ACTIONS(1180),
    [anon_sym_SQUOTE] = ACTIONS(1180),
    [anon_sym_L_DQUOTE] = ACTIONS(1180),
    [anon_sym_u_DQUOTE] = ACTIONS(1180),
    [anon_sym_U_DQUOTE] = ACTIONS(1180),
    [anon_sym_u8_DQUOTE] = ACTIONS(1180),
    [anon_sym_DQUOTE] = ACTIONS(1180),
    [sym_true] = ACTIONS(1178),
    [sym_false] = ACTIONS(1178),
    [anon_sym_NULL] = ACTIONS(1178),
    [anon_sym_nullptr] = ACTIONS(1178),
    [sym_comment] = ACTIONS(3),
  },
  [96] = {
    [sym_identifier] = ACTIONS(1182),
    [aux_sym_preproc_include_token1] = ACTIONS(1182),
    [aux_sym_preproc_def_token1] = ACTIONS(1182),
    [aux_sym_preproc_if_token1] = ACTIONS(1182),
    [aux_sym_preproc_if_token2] = ACTIONS(1182),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1182),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1182),
    [aux_sym_preproc_else_token1] = ACTIONS(1182),
    [aux_sym_preproc_elif_token1] = ACTIONS(1182),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1182),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1182),
    [sym_preproc_directive] = ACTIONS(1182),
    [anon_sym_LPAREN2] = ACTIONS(1184),
    [anon_sym_BANG] = ACTIONS(1184),
    [anon_sym_TILDE] = ACTIONS(1184),
    [anon_sym_DASH] = ACTIONS(1182),
    [anon_sym_PLUS] = ACTIONS(1182),
    [anon_sym_STAR] = ACTIONS(1184),
    [anon_sym_AMP] = ACTIONS(1184),
    [anon_sym_SEMI] = ACTIONS(1184),
    [anon_sym___extension__] = ACTIONS(1182),
    [anon_sym_typedef] = ACTIONS(1182),
    [anon_sym_extern] = ACTIONS(1182),
    [anon_sym___attribute__] = ACTIONS(1182),
    [anon_sym___attribute] = ACTIONS(1182),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1184),
    [anon_sym___declspec] = ACTIONS(1182),
    [anon_sym___cdecl] = ACTIONS(1182),
    [anon_sym___clrcall] = ACTIONS(1182),
    [anon_sym___stdcall] = ACTIONS(1182),
    [anon_sym___fastcall] = ACTIONS(1182),
    [anon_sym___thiscall] = ACTIONS(1182),
    [anon_sym___vectorcall] = ACTIONS(1182),
    [anon_sym_LBRACE] = ACTIONS(1184),
    [anon_sym_signed] = ACTIONS(1182),
    [anon_sym_unsigned] = ACTIONS(1182),
    [anon_sym_long] = ACTIONS(1182),
    [anon_sym_short] = ACTIONS(1182),
    [anon_sym_static] = ACTIONS(1182),
    [anon_sym_auto] = ACTIONS(1182),
    [anon_sym_register] = ACTIONS(1182),
    [anon_sym_inline] = ACTIONS(1182),
    [anon_sym___inline] = ACTIONS(1182),
    [anon_sym___inline__] = ACTIONS(1182),
    [anon_sym___forceinline] = ACTIONS(1182),
    [anon_sym_thread_local] = ACTIONS(1182),
    [anon_sym___thread] = ACTIONS(1182),
    [anon_sym_const] = ACTIONS(1182),
    [anon_sym_constexpr] = ACTIONS(1182),
    [anon_sym_volatile] = ACTIONS(1182),
    [anon_sym_restrict] = ACTIONS(1182),
    [anon_sym___restrict__] = ACTIONS(1182),
    [anon_sym__Atomic] = ACTIONS(1182),
    [anon_sym__Noreturn] = ACTIONS(1182),
    [anon_sym_noreturn] = ACTIONS(1182),
    [anon_sym__Nonnull] = ACTIONS(1182),
    [anon_sym_alignas] = ACTIONS(1182),
    [anon_sym__Alignas] = ACTIONS(1182),
    [sym_primitive_type] = ACTIONS(1182),
    [anon_sym_enum] = ACTIONS(1182),
    [anon_sym_struct] = ACTIONS(1182),
    [anon_sym_union] = ACTIONS(1182),
    [anon_sym_if] = ACTIONS(1182),
    [anon_sym_else] = ACTIONS(1182),
    [anon_sym_switch] = ACTIONS(1182),
    [anon_sym_case] = ACTIONS(1182),
    [anon_sym_default] = ACTIONS(1182),
    [anon_sym_while] = ACTIONS(1182),
    [anon_sym_do] = ACTIONS(1182),
    [anon_sym_for] = ACTIONS(1182),
    [anon_sym_return] = ACTIONS(1182),
    [anon_sym_break] = ACTIONS(1182),
    [anon_sym_continue] = ACTIONS(1182),
    [anon_sym_goto] = ACTIONS(1182),
    [anon_sym___try] = ACTIONS(1182),
    [anon_sym___leave] = ACTIONS(1182),
    [anon_sym_DASH_DASH] = ACTIONS(1184),
    [anon_sym_PLUS_PLUS] = ACTIONS(1184),
    [anon_sym_sizeof] = ACTIONS(1182),
    [anon_sym___alignof__] = ACTIONS(1182),
    [anon_sym___alignof] = ACTIONS(1182),
    [anon_sym__alignof] = ACTIONS(1182),
    [anon_sym_alignof] = ACTIONS(1182),
    [anon_sym__Alignof] = ACTIONS(1182),
    [anon_sym_offsetof] = ACTIONS(1182),
    [anon_sym__Generic] = ACTIONS(1182),
    [anon_sym_asm] = ACTIONS(1182),
    [anon_sym___asm__] = ACTIONS(1182),
    [anon_sym___asm] = ACTIONS(1182),
    [sym_number_literal] = ACTIONS(1184),
    [anon_sym_L_SQUOTE] = ACTIONS(1184),
    [anon_sym_u_SQUOTE] = ACTIONS(1184),
    [anon_sym_U_SQUOTE] = ACTIONS(1184),
    [anon_sym_u8_SQUOTE] = ACTIONS(1184),
    [anon_sym_SQUOTE] = ACTIONS(1184),
    [anon_sym_L_DQUOTE] = ACTIONS(1184),
    [anon_sym_u_DQUOTE] = ACTIONS(1184),
    [anon_sym_U_DQUOTE] = ACTIONS(1184),
    [anon_sym_u8_DQUOTE] = ACTIONS(1184),
    [anon_sym_DQUOTE] = ACTIONS(1184),
    [sym_true] = ACTIONS(1182),
    [sym_false] = ACTIONS(1182),
    [anon_sym_NULL] = ACTIONS(1182),
    [anon_sym_nullptr] = ACTIONS(1182),
    [sym_comment] = ACTIONS(3),
  },
  [97] = {
    [sym_identifier] = ACTIONS(1186),
    [aux_sym_preproc_include_token1] = ACTIONS(1186),
    [aux_sym_preproc_def_token1] = ACTIONS(1186),
    [aux_sym_preproc_if_token1] = ACTIONS(1186),
    [aux_sym_preproc_if_token2] = ACTIONS(1186),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1186),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1186),
    [aux_sym_preproc_else_token1] = ACTIONS(1186),
    [aux_sym_preproc_elif_token1] = ACTIONS(1186),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1186),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1186),
    [sym_preproc_directive] = ACTIONS(1186),
    [anon_sym_LPAREN2] = ACTIONS(1188),
    [anon_sym_BANG] = ACTIONS(1188),
    [anon_sym_TILDE] = ACTIONS(1188),
    [anon_sym_DASH] = ACTIONS(1186),
    [anon_sym_PLUS] = ACTIONS(1186),
    [anon_sym_STAR] = ACTIONS(1188),
    [anon_sym_AMP] = ACTIONS(1188),
    [anon_sym_SEMI] = ACTIONS(1188),
    [anon_sym___extension__] = ACTIONS(1186),
    [anon_sym_typedef] = ACTIONS(1186),
    [anon_sym_extern] = ACTIONS(1186),
    [anon_sym___attribute__] = ACTIONS(1186),
    [anon_sym___attribute] = ACTIONS(1186),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1188),
    [anon_sym___declspec] = ACTIONS(1186),
    [anon_sym___cdecl] = ACTIONS(1186),
    [anon_sym___clrcall] = ACTIONS(1186),
    [anon_sym___stdcall] = ACTIONS(1186),
    [anon_sym___fastcall] = ACTIONS(1186),
    [anon_sym___thiscall] = ACTIONS(1186),
    [anon_sym___vectorcall] = ACTIONS(1186),
    [anon_sym_LBRACE] = ACTIONS(1188),
    [anon_sym_signed] = ACTIONS(1186),
    [anon_sym_unsigned] = ACTIONS(1186),
    [anon_sym_long] = ACTIONS(1186),
    [anon_sym_short] = ACTIONS(1186),
    [anon_sym_static] = ACTIONS(1186),
    [anon_sym_auto] = ACTIONS(1186),
    [anon_sym_register] = ACTIONS(1186),
    [anon_sym_inline] = ACTIONS(1186),
    [anon_sym___inline] = ACTIONS(1186),
    [anon_sym___inline__] = ACTIONS(1186),
    [anon_sym___forceinline] = ACTIONS(1186),
    [anon_sym_thread_local] = ACTIONS(1186),
    [anon_sym___thread] = ACTIONS(1186),
    [anon_sym_const] = ACTIONS(1186),
    [anon_sym_constexpr] = ACTIONS(1186),
    [anon_sym_volatile] = ACTIONS(1186),
    [anon_sym_restrict] = ACTIONS(1186),
    [anon_sym___restrict__] = ACTIONS(1186),
    [anon_sym__Atomic] = ACTIONS(1186),
    [anon_sym__Noreturn] = ACTIONS(1186),
    [anon_sym_noreturn] = ACTIONS(1186),
    [anon_sym__Nonnull] = ACTIONS(1186),
    [anon_sym_alignas] = ACTIONS(1186),
    [anon_sym__Alignas] = ACTIONS(1186),
    [sym_primitive_type] = ACTIONS(1186),
    [anon_sym_enum] = ACTIONS(1186),
    [anon_sym_struct] = ACTIONS(1186),
    [anon_sym_union] = ACTIONS(1186),
    [anon_sym_if] = ACTIONS(1186),
    [anon_sym_else] = ACTIONS(1186),
    [anon_sym_switch] = ACTIONS(1186),
    [anon_sym_case] = ACTIONS(1186),
    [anon_sym_default] = ACTIONS(1186),
    [anon_sym_while] = ACTIONS(1186),
    [anon_sym_do] = ACTIONS(1186),
    [anon_sym_for] = ACTIONS(1186),
    [anon_sym_return] = ACTIONS(1186),
    [anon_sym_break] = ACTIONS(1186),
    [anon_sym_continue] = ACTIONS(1186),
    [anon_sym_goto] = ACTIONS(1186),
    [anon_sym___try] = ACTIONS(1186),
    [anon_sym___leave] = ACTIONS(1186),
    [anon_sym_DASH_DASH] = ACTIONS(1188),
    [anon_sym_PLUS_PLUS] = ACTIONS(1188),
    [anon_sym_sizeof] = ACTIONS(1186),
    [anon_sym___alignof__] = ACTIONS(1186),
    [anon_sym___alignof] = ACTIONS(1186),
    [anon_sym__alignof] = ACTIONS(1186),
    [anon_sym_alignof] = ACTIONS(1186),
    [anon_sym__Alignof] = ACTIONS(1186),
    [anon_sym_offsetof] = ACTIONS(1186),
    [anon_sym__Generic] = ACTIONS(1186),
    [anon_sym_asm] = ACTIONS(1186),
    [anon_sym___asm__] = ACTIONS(1186),
    [anon_sym___asm] = ACTIONS(1186),
    [sym_number_literal] = ACTIONS(1188),
    [anon_sym_L_SQUOTE] = ACTIONS(1188),
    [anon_sym_u_SQUOTE] = ACTIONS(1188),
    [anon_sym_U_SQUOTE] = ACTIONS(1188),
    [anon_sym_u8_SQUOTE] = ACTIONS(1188),
    [anon_sym_SQUOTE] = ACTIONS(1188),
    [anon_sym_L_DQUOTE] = ACTIONS(1188),
    [anon_sym_u_DQUOTE] = ACTIONS(1188),
    [anon_sym_U_DQUOTE] = ACTIONS(1188),
    [anon_sym_u8_DQUOTE] = ACTIONS(1188),
    [anon_sym_DQUOTE] = ACTIONS(1188),
    [sym_true] = ACTIONS(1186),
    [sym_false] = ACTIONS(1186),
    [anon_sym_NULL] = ACTIONS(1186),
    [anon_sym_nullptr] = ACTIONS(1186),
    [sym_comment] = ACTIONS(3),
  },
  [98] = {
    [sym_identifier] = ACTIONS(1190),
    [aux_sym_preproc_include_token1] = ACTIONS(1190),
    [aux_sym_preproc_def_token1] = ACTIONS(1190),
    [aux_sym_preproc_if_token1] = ACTIONS(1190),
    [aux_sym_preproc_if_token2] = ACTIONS(1190),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1190),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1190),
    [aux_sym_preproc_else_token1] = ACTIONS(1190),
    [aux_sym_preproc_elif_token1] = ACTIONS(1190),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1190),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1190),
    [sym_preproc_directive] = ACTIONS(1190),
    [anon_sym_LPAREN2] = ACTIONS(1192),
    [anon_sym_BANG] = ACTIONS(1192),
    [anon_sym_TILDE] = ACTIONS(1192),
    [anon_sym_DASH] = ACTIONS(1190),
    [anon_sym_PLUS] = ACTIONS(1190),
    [anon_sym_STAR] = ACTIONS(1192),
    [anon_sym_AMP] = ACTIONS(1192),
    [anon_sym_SEMI] = ACTIONS(1192),
    [anon_sym___extension__] = ACTIONS(1190),
    [anon_sym_typedef] = ACTIONS(1190),
    [anon_sym_extern] = ACTIONS(1190),
    [anon_sym___attribute__] = ACTIONS(1190),
    [anon_sym___attribute] = ACTIONS(1190),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1192),
    [anon_sym___declspec] = ACTIONS(1190),
    [anon_sym___cdecl] = ACTIONS(1190),
    [anon_sym___clrcall] = ACTIONS(1190),
    [anon_sym___stdcall] = ACTIONS(1190),
    [anon_sym___fastcall] = ACTIONS(1190),
    [anon_sym___thiscall] = ACTIONS(1190),
    [anon_sym___vectorcall] = ACTIONS(1190),
    [anon_sym_LBRACE] = ACTIONS(1192),
    [anon_sym_signed] = ACTIONS(1190),
    [anon_sym_unsigned] = ACTIONS(1190),
    [anon_sym_long] = ACTIONS(1190),
    [anon_sym_short] = ACTIONS(1190),
    [anon_sym_static] = ACTIONS(1190),
    [anon_sym_auto] = ACTIONS(1190),
    [anon_sym_register] = ACTIONS(1190),
    [anon_sym_inline] = ACTIONS(1190),
    [anon_sym___inline] = ACTIONS(1190),
    [anon_sym___inline__] = ACTIONS(1190),
    [anon_sym___forceinline] = ACTIONS(1190),
    [anon_sym_thread_local] = ACTIONS(1190),
    [anon_sym___thread] = ACTIONS(1190),
    [anon_sym_const] = ACTIONS(1190),
    [anon_sym_constexpr] = ACTIONS(1190),
    [anon_sym_volatile] = ACTIONS(1190),
    [anon_sym_restrict] = ACTIONS(1190),
    [anon_sym___restrict__] = ACTIONS(1190),
    [anon_sym__Atomic] = ACTIONS(1190),
    [anon_sym__Noreturn] = ACTIONS(1190),
    [anon_sym_noreturn] = ACTIONS(1190),
    [anon_sym__Nonnull] = ACTIONS(1190),
    [anon_sym_alignas] = ACTIONS(1190),
    [anon_sym__Alignas] = ACTIONS(1190),
    [sym_primitive_type] = ACTIONS(1190),
    [anon_sym_enum] = ACTIONS(1190),
    [anon_sym_struct] = ACTIONS(1190),
    [anon_sym_union] = ACTIONS(1190),
    [anon_sym_if] = ACTIONS(1190),
    [anon_sym_else] = ACTIONS(1190),
    [anon_sym_switch] = ACTIONS(1190),
    [anon_sym_case] = ACTIONS(1190),
    [anon_sym_default] = ACTIONS(1190),
    [anon_sym_while] = ACTIONS(1190),
    [anon_sym_do] = ACTIONS(1190),
    [anon_sym_for] = ACTIONS(1190),
    [anon_sym_return] = ACTIONS(1190),
    [anon_sym_break] = ACTIONS(1190),
    [anon_sym_continue] = ACTIONS(1190),
    [anon_sym_goto] = ACTIONS(1190),
    [anon_sym___try] = ACTIONS(1190),
    [anon_sym___leave] = ACTIONS(1190),
    [anon_sym_DASH_DASH] = ACTIONS(1192),
    [anon_sym_PLUS_PLUS] = ACTIONS(1192),
    [anon_sym_sizeof] = ACTIONS(1190),
    [anon_sym___alignof__] = ACTIONS(1190),
    [anon_sym___alignof] = ACTIONS(1190),
    [anon_sym__alignof] = ACTIONS(1190),
    [anon_sym_alignof] = ACTIONS(1190),
    [anon_sym__Alignof] = ACTIONS(1190),
    [anon_sym_offsetof] = ACTIONS(1190),
    [anon_sym__Generic] = ACTIONS(1190),
    [anon_sym_asm] = ACTIONS(1190),
    [anon_sym___asm__] = ACTIONS(1190),
    [anon_sym___asm] = ACTIONS(1190),
    [sym_number_literal] = ACTIONS(1192),
    [anon_sym_L_SQUOTE] = ACTIONS(1192),
    [anon_sym_u_SQUOTE] = ACTIONS(1192),
    [anon_sym_U_SQUOTE] = ACTIONS(1192),
    [anon_sym_u8_SQUOTE] = ACTIONS(1192),
    [anon_sym_SQUOTE] = ACTIONS(1192),
    [anon_sym_L_DQUOTE] = ACTIONS(1192),
    [anon_sym_u_DQUOTE] = ACTIONS(1192),
    [anon_sym_U_DQUOTE] = ACTIONS(1192),
    [anon_sym_u8_DQUOTE] = ACTIONS(1192),
    [anon_sym_DQUOTE] = ACTIONS(1192),
    [sym_true] = ACTIONS(1190),
    [sym_false] = ACTIONS(1190),
    [anon_sym_NULL] = ACTIONS(1190),
    [anon_sym_nullptr] = ACTIONS(1190),
    [sym_comment] = ACTIONS(3),
  },
  [99] = {
    [sym_identifier] = ACTIONS(1194),
    [aux_sym_preproc_include_token1] = ACTIONS(1194),
    [aux_sym_preproc_def_token1] = ACTIONS(1194),
    [aux_sym_preproc_if_token1] = ACTIONS(1194),
    [aux_sym_preproc_if_token2] = ACTIONS(1194),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1194),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1194),
    [aux_sym_preproc_else_token1] = ACTIONS(1194),
    [aux_sym_preproc_elif_token1] = ACTIONS(1194),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1194),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1194),
    [sym_preproc_directive] = ACTIONS(1194),
    [anon_sym_LPAREN2] = ACTIONS(1196),
    [anon_sym_BANG] = ACTIONS(1196),
    [anon_sym_TILDE] = ACTIONS(1196),
    [anon_sym_DASH] = ACTIONS(1194),
    [anon_sym_PLUS] = ACTIONS(1194),
    [anon_sym_STAR] = ACTIONS(1196),
    [anon_sym_AMP] = ACTIONS(1196),
    [anon_sym_SEMI] = ACTIONS(1196),
    [anon_sym___extension__] = ACTIONS(1194),
    [anon_sym_typedef] = ACTIONS(1194),
    [anon_sym_extern] = ACTIONS(1194),
    [anon_sym___attribute__] = ACTIONS(1194),
    [anon_sym___attribute] = ACTIONS(1194),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1196),
    [anon_sym___declspec] = ACTIONS(1194),
    [anon_sym___cdecl] = ACTIONS(1194),
    [anon_sym___clrcall] = ACTIONS(1194),
    [anon_sym___stdcall] = ACTIONS(1194),
    [anon_sym___fastcall] = ACTIONS(1194),
    [anon_sym___thiscall] = ACTIONS(1194),
    [anon_sym___vectorcall] = ACTIONS(1194),
    [anon_sym_LBRACE] = ACTIONS(1196),
    [anon_sym_signed] = ACTIONS(1194),
    [anon_sym_unsigned] = ACTIONS(1194),
    [anon_sym_long] = ACTIONS(1194),
    [anon_sym_short] = ACTIONS(1194),
    [anon_sym_static] = ACTIONS(1194),
    [anon_sym_auto] = ACTIONS(1194),
    [anon_sym_register] = ACTIONS(1194),
    [anon_sym_inline] = ACTIONS(1194),
    [anon_sym___inline] = ACTIONS(1194),
    [anon_sym___inline__] = ACTIONS(1194),
    [anon_sym___forceinline] = ACTIONS(1194),
    [anon_sym_thread_local] = ACTIONS(1194),
    [anon_sym___thread] = ACTIONS(1194),
    [anon_sym_const] = ACTIONS(1194),
    [anon_sym_constexpr] = ACTIONS(1194),
    [anon_sym_volatile] = ACTIONS(1194),
    [anon_sym_restrict] = ACTIONS(1194),
    [anon_sym___restrict__] = ACTIONS(1194),
    [anon_sym__Atomic] = ACTIONS(1194),
    [anon_sym__Noreturn] = ACTIONS(1194),
    [anon_sym_noreturn] = ACTIONS(1194),
    [anon_sym__Nonnull] = ACTIONS(1194),
    [anon_sym_alignas] = ACTIONS(1194),
    [anon_sym__Alignas] = ACTIONS(1194),
    [sym_primitive_type] = ACTIONS(1194),
    [anon_sym_enum] = ACTIONS(1194),
    [anon_sym_struct] = ACTIONS(1194),
    [anon_sym_union] = ACTIONS(1194),
    [anon_sym_if] = ACTIONS(1194),
    [anon_sym_else] = ACTIONS(1194),
    [anon_sym_switch] = ACTIONS(1194),
    [anon_sym_case] = ACTIONS(1194),
    [anon_sym_default] = ACTIONS(1194),
    [anon_sym_while] = ACTIONS(1194),
    [anon_sym_do] = ACTIONS(1194),
    [anon_sym_for] = ACTIONS(1194),
    [anon_sym_return] = ACTIONS(1194),
    [anon_sym_break] = ACTIONS(1194),
    [anon_sym_continue] = ACTIONS(1194),
    [anon_sym_goto] = ACTIONS(1194),
    [anon_sym___try] = ACTIONS(1194),
    [anon_sym___leave] = ACTIONS(1194),
    [anon_sym_DASH_DASH] = ACTIONS(1196),
    [anon_sym_PLUS_PLUS] = ACTIONS(1196),
    [anon_sym_sizeof] = ACTIONS(1194),
    [anon_sym___alignof__] = ACTIONS(1194),
    [anon_sym___alignof] = ACTIONS(1194),
    [anon_sym__alignof] = ACTIONS(1194),
    [anon_sym_alignof] = ACTIONS(1194),
    [anon_sym__Alignof] = ACTIONS(1194),
    [anon_sym_offsetof] = ACTIONS(1194),
    [anon_sym__Generic] = ACTIONS(1194),
    [anon_sym_asm] = ACTIONS(1194),
    [anon_sym___asm__] = ACTIONS(1194),
    [anon_sym___asm] = ACTIONS(1194),
    [sym_number_literal] = ACTIONS(1196),
    [anon_sym_L_SQUOTE] = ACTIONS(1196),
    [anon_sym_u_SQUOTE] = ACTIONS(1196),
    [anon_sym_U_SQUOTE] = ACTIONS(1196),
    [anon_sym_u8_SQUOTE] = ACTIONS(1196),
    [anon_sym_SQUOTE] = ACTIONS(1196),
    [anon_sym_L_DQUOTE] = ACTIONS(1196),
    [anon_sym_u_DQUOTE] = ACTIONS(1196),
    [anon_sym_U_DQUOTE] = ACTIONS(1196),
    [anon_sym_u8_DQUOTE] = ACTIONS(1196),
    [anon_sym_DQUOTE] = ACTIONS(1196),
    [sym_true] = ACTIONS(1194),
    [sym_false] = ACTIONS(1194),
    [anon_sym_NULL] = ACTIONS(1194),
    [anon_sym_nullptr] = ACTIONS(1194),
    [sym_comment] = ACTIONS(3),
  },
  [100] = {
    [sym_identifier] = ACTIONS(1198),
    [aux_sym_preproc_include_token1] = ACTIONS(1198),
    [aux_sym_preproc_def_token1] = ACTIONS(1198),
    [aux_sym_preproc_if_token1] = ACTIONS(1198),
    [aux_sym_preproc_if_token2] = ACTIONS(1198),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1198),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1198),
    [aux_sym_preproc_else_token1] = ACTIONS(1198),
    [aux_sym_preproc_elif_token1] = ACTIONS(1198),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1198),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1198),
    [sym_preproc_directive] = ACTIONS(1198),
    [anon_sym_LPAREN2] = ACTIONS(1200),
    [anon_sym_BANG] = ACTIONS(1200),
    [anon_sym_TILDE] = ACTIONS(1200),
    [anon_sym_DASH] = ACTIONS(1198),
    [anon_sym_PLUS] = ACTIONS(1198),
    [anon_sym_STAR] = ACTIONS(1200),
    [anon_sym_AMP] = ACTIONS(1200),
    [anon_sym_SEMI] = ACTIONS(1200),
    [anon_sym___extension__] = ACTIONS(1198),
    [anon_sym_typedef] = ACTIONS(1198),
    [anon_sym_extern] = ACTIONS(1198),
    [anon_sym___attribute__] = ACTIONS(1198),
    [anon_sym___attribute] = ACTIONS(1198),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1200),
    [anon_sym___declspec] = ACTIONS(1198),
    [anon_sym___cdecl] = ACTIONS(1198),
    [anon_sym___clrcall] = ACTIONS(1198),
    [anon_sym___stdcall] = ACTIONS(1198),
    [anon_sym___fastcall] = ACTIONS(1198),
    [anon_sym___thiscall] = ACTIONS(1198),
    [anon_sym___vectorcall] = ACTIONS(1198),
    [anon_sym_LBRACE] = ACTIONS(1200),
    [anon_sym_signed] = ACTIONS(1198),
    [anon_sym_unsigned] = ACTIONS(1198),
    [anon_sym_long] = ACTIONS(1198),
    [anon_sym_short] = ACTIONS(1198),
    [anon_sym_static] = ACTIONS(1198),
    [anon_sym_auto] = ACTIONS(1198),
    [anon_sym_register] = ACTIONS(1198),
    [anon_sym_inline] = ACTIONS(1198),
    [anon_sym___inline] = ACTIONS(1198),
    [anon_sym___inline__] = ACTIONS(1198),
    [anon_sym___forceinline] = ACTIONS(1198),
    [anon_sym_thread_local] = ACTIONS(1198),
    [anon_sym___thread] = ACTIONS(1198),
    [anon_sym_const] = ACTIONS(1198),
    [anon_sym_constexpr] = ACTIONS(1198),
    [anon_sym_volatile] = ACTIONS(1198),
    [anon_sym_restrict] = ACTIONS(1198),
    [anon_sym___restrict__] = ACTIONS(1198),
    [anon_sym__Atomic] = ACTIONS(1198),
    [anon_sym__Noreturn] = ACTIONS(1198),
    [anon_sym_noreturn] = ACTIONS(1198),
    [anon_sym__Nonnull] = ACTIONS(1198),
    [anon_sym_alignas] = ACTIONS(1198),
    [anon_sym__Alignas] = ACTIONS(1198),
    [sym_primitive_type] = ACTIONS(1198),
    [anon_sym_enum] = ACTIONS(1198),
    [anon_sym_struct] = ACTIONS(1198),
    [anon_sym_union] = ACTIONS(1198),
    [anon_sym_if] = ACTIONS(1198),
    [anon_sym_else] = ACTIONS(1198),
    [anon_sym_switch] = ACTIONS(1198),
    [anon_sym_case] = ACTIONS(1198),
    [anon_sym_default] = ACTIONS(1198),
    [anon_sym_while] = ACTIONS(1198),
    [anon_sym_do] = ACTIONS(1198),
    [anon_sym_for] = ACTIONS(1198),
    [anon_sym_return] = ACTIONS(1198),
    [anon_sym_break] = ACTIONS(1198),
    [anon_sym_continue] = ACTIONS(1198),
    [anon_sym_goto] = ACTIONS(1198),
    [anon_sym___try] = ACTIONS(1198),
    [anon_sym___leave] = ACTIONS(1198),
    [anon_sym_DASH_DASH] = ACTIONS(1200),
    [anon_sym_PLUS_PLUS] = ACTIONS(1200),
    [anon_sym_sizeof] = ACTIONS(1198),
    [anon_sym___alignof__] = ACTIONS(1198),
    [anon_sym___alignof] = ACTIONS(1198),
    [anon_sym__alignof] = ACTIONS(1198),
    [anon_sym_alignof] = ACTIONS(1198),
    [anon_sym__Alignof] = ACTIONS(1198),
    [anon_sym_offsetof] = ACTIONS(1198),
    [anon_sym__Generic] = ACTIONS(1198),
    [anon_sym_asm] = ACTIONS(1198),
    [anon_sym___asm__] = ACTIONS(1198),
    [anon_sym___asm] = ACTIONS(1198),
    [sym_number_literal] = ACTIONS(1200),
    [anon_sym_L_SQUOTE] = ACTIONS(1200),
    [anon_sym_u_SQUOTE] = ACTIONS(1200),
    [anon_sym_U_SQUOTE] = ACTIONS(1200),
    [anon_sym_u8_SQUOTE] = ACTIONS(1200),
    [anon_sym_SQUOTE] = ACTIONS(1200),
    [anon_sym_L_DQUOTE] = ACTIONS(1200),
    [anon_sym_u_DQUOTE] = ACTIONS(1200),
    [anon_sym_U_DQUOTE] = ACTIONS(1200),
    [anon_sym_u8_DQUOTE] = ACTIONS(1200),
    [anon_sym_DQUOTE] = ACTIONS(1200),
    [sym_true] = ACTIONS(1198),
    [sym_false] = ACTIONS(1198),
    [anon_sym_NULL] = ACTIONS(1198),
    [anon_sym_nullptr] = ACTIONS(1198),
    [sym_comment] = ACTIONS(3),
  },
  [101] = {
    [sym_identifier] = ACTIONS(1202),
    [aux_sym_preproc_include_token1] = ACTIONS(1202),
    [aux_sym_preproc_def_token1] = ACTIONS(1202),
    [aux_sym_preproc_if_token1] = ACTIONS(1202),
    [aux_sym_preproc_if_token2] = ACTIONS(1202),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1202),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1202),
    [aux_sym_preproc_else_token1] = ACTIONS(1202),
    [aux_sym_preproc_elif_token1] = ACTIONS(1202),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1202),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1202),
    [sym_preproc_directive] = ACTIONS(1202),
    [anon_sym_LPAREN2] = ACTIONS(1204),
    [anon_sym_BANG] = ACTIONS(1204),
    [anon_sym_TILDE] = ACTIONS(1204),
    [anon_sym_DASH] = ACTIONS(1202),
    [anon_sym_PLUS] = ACTIONS(1202),
    [anon_sym_STAR] = ACTIONS(1204),
    [anon_sym_AMP] = ACTIONS(1204),
    [anon_sym_SEMI] = ACTIONS(1204),
    [anon_sym___extension__] = ACTIONS(1202),
    [anon_sym_typedef] = ACTIONS(1202),
    [anon_sym_extern] = ACTIONS(1202),
    [anon_sym___attribute__] = ACTIONS(1202),
    [anon_sym___attribute] = ACTIONS(1202),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1204),
    [anon_sym___declspec] = ACTIONS(1202),
    [anon_sym___cdecl] = ACTIONS(1202),
    [anon_sym___clrcall] = ACTIONS(1202),
    [anon_sym___stdcall] = ACTIONS(1202),
    [anon_sym___fastcall] = ACTIONS(1202),
    [anon_sym___thiscall] = ACTIONS(1202),
    [anon_sym___vectorcall] = ACTIONS(1202),
    [anon_sym_LBRACE] = ACTIONS(1204),
    [anon_sym_signed] = ACTIONS(1202),
    [anon_sym_unsigned] = ACTIONS(1202),
    [anon_sym_long] = ACTIONS(1202),
    [anon_sym_short] = ACTIONS(1202),
    [anon_sym_static] = ACTIONS(1202),
    [anon_sym_auto] = ACTIONS(1202),
    [anon_sym_register] = ACTIONS(1202),
    [anon_sym_inline] = ACTIONS(1202),
    [anon_sym___inline] = ACTIONS(1202),
    [anon_sym___inline__] = ACTIONS(1202),
    [anon_sym___forceinline] = ACTIONS(1202),
    [anon_sym_thread_local] = ACTIONS(1202),
    [anon_sym___thread] = ACTIONS(1202),
    [anon_sym_const] = ACTIONS(1202),
    [anon_sym_constexpr] = ACTIONS(1202),
    [anon_sym_volatile] = ACTIONS(1202),
    [anon_sym_restrict] = ACTIONS(1202),
    [anon_sym___restrict__] = ACTIONS(1202),
    [anon_sym__Atomic] = ACTIONS(1202),
    [anon_sym__Noreturn] = ACTIONS(1202),
    [anon_sym_noreturn] = ACTIONS(1202),
    [anon_sym__Nonnull] = ACTIONS(1202),
    [anon_sym_alignas] = ACTIONS(1202),
    [anon_sym__Alignas] = ACTIONS(1202),
    [sym_primitive_type] = ACTIONS(1202),
    [anon_sym_enum] = ACTIONS(1202),
    [anon_sym_struct] = ACTIONS(1202),
    [anon_sym_union] = ACTIONS(1202),
    [anon_sym_if] = ACTIONS(1202),
    [anon_sym_else] = ACTIONS(1202),
    [anon_sym_switch] = ACTIONS(1202),
    [anon_sym_case] = ACTIONS(1202),
    [anon_sym_default] = ACTIONS(1202),
    [anon_sym_while] = ACTIONS(1202),
    [anon_sym_do] = ACTIONS(1202),
    [anon_sym_for] = ACTIONS(1202),
    [anon_sym_return] = ACTIONS(1202),
    [anon_sym_break] = ACTIONS(1202),
    [anon_sym_continue] = ACTIONS(1202),
    [anon_sym_goto] = ACTIONS(1202),
    [anon_sym___try] = ACTIONS(1202),
    [anon_sym___leave] = ACTIONS(1202),
    [anon_sym_DASH_DASH] = ACTIONS(1204),
    [anon_sym_PLUS_PLUS] = ACTIONS(1204),
    [anon_sym_sizeof] = ACTIONS(1202),
    [anon_sym___alignof__] = ACTIONS(1202),
    [anon_sym___alignof] = ACTIONS(1202),
    [anon_sym__alignof] = ACTIONS(1202),
    [anon_sym_alignof] = ACTIONS(1202),
    [anon_sym__Alignof] = ACTIONS(1202),
    [anon_sym_offsetof] = ACTIONS(1202),
    [anon_sym__Generic] = ACTIONS(1202),
    [anon_sym_asm] = ACTIONS(1202),
    [anon_sym___asm__] = ACTIONS(1202),
    [anon_sym___asm] = ACTIONS(1202),
    [sym_number_literal] = ACTIONS(1204),
    [anon_sym_L_SQUOTE] = ACTIONS(1204),
    [anon_sym_u_SQUOTE] = ACTIONS(1204),
    [anon_sym_U_SQUOTE] = ACTIONS(1204),
    [anon_sym_u8_SQUOTE] = ACTIONS(1204),
    [anon_sym_SQUOTE] = ACTIONS(1204),
    [anon_sym_L_DQUOTE] = ACTIONS(1204),
    [anon_sym_u_DQUOTE] = ACTIONS(1204),
    [anon_sym_U_DQUOTE] = ACTIONS(1204),
    [anon_sym_u8_DQUOTE] = ACTIONS(1204),
    [anon_sym_DQUOTE] = ACTIONS(1204),
    [sym_true] = ACTIONS(1202),
    [sym_false] = ACTIONS(1202),
    [anon_sym_NULL] = ACTIONS(1202),
    [anon_sym_nullptr] = ACTIONS(1202),
    [sym_comment] = ACTIONS(3),
  },
  [102] = {
    [sym_identifier] = ACTIONS(1202),
    [aux_sym_preproc_include_token1] = ACTIONS(1202),
    [aux_sym_preproc_def_token1] = ACTIONS(1202),
    [aux_sym_preproc_if_token1] = ACTIONS(1202),
    [aux_sym_preproc_if_token2] = ACTIONS(1202),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1202),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1202),
    [aux_sym_preproc_else_token1] = ACTIONS(1202),
    [aux_sym_preproc_elif_token1] = ACTIONS(1202),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1202),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1202),
    [sym_preproc_directive] = ACTIONS(1202),
    [anon_sym_LPAREN2] = ACTIONS(1204),
    [anon_sym_BANG] = ACTIONS(1204),
    [anon_sym_TILDE] = ACTIONS(1204),
    [anon_sym_DASH] = ACTIONS(1202),
    [anon_sym_PLUS] = ACTIONS(1202),
    [anon_sym_STAR] = ACTIONS(1204),
    [anon_sym_AMP] = ACTIONS(1204),
    [anon_sym_SEMI] = ACTIONS(1204),
    [anon_sym___extension__] = ACTIONS(1202),
    [anon_sym_typedef] = ACTIONS(1202),
    [anon_sym_extern] = ACTIONS(1202),
    [anon_sym___attribute__] = ACTIONS(1202),
    [anon_sym___attribute] = ACTIONS(1202),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1204),
    [anon_sym___declspec] = ACTIONS(1202),
    [anon_sym___cdecl] = ACTIONS(1202),
    [anon_sym___clrcall] = ACTIONS(1202),
    [anon_sym___stdcall] = ACTIONS(1202),
    [anon_sym___fastcall] = ACTIONS(1202),
    [anon_sym___thiscall] = ACTIONS(1202),
    [anon_sym___vectorcall] = ACTIONS(1202),
    [anon_sym_LBRACE] = ACTIONS(1204),
    [anon_sym_signed] = ACTIONS(1202),
    [anon_sym_unsigned] = ACTIONS(1202),
    [anon_sym_long] = ACTIONS(1202),
    [anon_sym_short] = ACTIONS(1202),
    [anon_sym_static] = ACTIONS(1202),
    [anon_sym_auto] = ACTIONS(1202),
    [anon_sym_register] = ACTIONS(1202),
    [anon_sym_inline] = ACTIONS(1202),
    [anon_sym___inline] = ACTIONS(1202),
    [anon_sym___inline__] = ACTIONS(1202),
    [anon_sym___forceinline] = ACTIONS(1202),
    [anon_sym_thread_local] = ACTIONS(1202),
    [anon_sym___thread] = ACTIONS(1202),
    [anon_sym_const] = ACTIONS(1202),
    [anon_sym_constexpr] = ACTIONS(1202),
    [anon_sym_volatile] = ACTIONS(1202),
    [anon_sym_restrict] = ACTIONS(1202),
    [anon_sym___restrict__] = ACTIONS(1202),
    [anon_sym__Atomic] = ACTIONS(1202),
    [anon_sym__Noreturn] = ACTIONS(1202),
    [anon_sym_noreturn] = ACTIONS(1202),
    [anon_sym__Nonnull] = ACTIONS(1202),
    [anon_sym_alignas] = ACTIONS(1202),
    [anon_sym__Alignas] = ACTIONS(1202),
    [sym_primitive_type] = ACTIONS(1202),
    [anon_sym_enum] = ACTIONS(1202),
    [anon_sym_struct] = ACTIONS(1202),
    [anon_sym_union] = ACTIONS(1202),
    [anon_sym_if] = ACTIONS(1202),
    [anon_sym_else] = ACTIONS(1202),
    [anon_sym_switch] = ACTIONS(1202),
    [anon_sym_case] = ACTIONS(1202),
    [anon_sym_default] = ACTIONS(1202),
    [anon_sym_while] = ACTIONS(1202),
    [anon_sym_do] = ACTIONS(1202),
    [anon_sym_for] = ACTIONS(1202),
    [anon_sym_return] = ACTIONS(1202),
    [anon_sym_break] = ACTIONS(1202),
    [anon_sym_continue] = ACTIONS(1202),
    [anon_sym_goto] = ACTIONS(1202),
    [anon_sym___try] = ACTIONS(1202),
    [anon_sym___leave] = ACTIONS(1202),
    [anon_sym_DASH_DASH] = ACTIONS(1204),
    [anon_sym_PLUS_PLUS] = ACTIONS(1204),
    [anon_sym_sizeof] = ACTIONS(1202),
    [anon_sym___alignof__] = ACTIONS(1202),
    [anon_sym___alignof] = ACTIONS(1202),
    [anon_sym__alignof] = ACTIONS(1202),
    [anon_sym_alignof] = ACTIONS(1202),
    [anon_sym__Alignof] = ACTIONS(1202),
    [anon_sym_offsetof] = ACTIONS(1202),
    [anon_sym__Generic] = ACTIONS(1202),
    [anon_sym_asm] = ACTIONS(1202),
    [anon_sym___asm__] = ACTIONS(1202),
    [anon_sym___asm] = ACTIONS(1202),
    [sym_number_literal] = ACTIONS(1204),
    [anon_sym_L_SQUOTE] = ACTIONS(1204),
    [anon_sym_u_SQUOTE] = ACTIONS(1204),
    [anon_sym_U_SQUOTE] = ACTIONS(1204),
    [anon_sym_u8_SQUOTE] = ACTIONS(1204),
    [anon_sym_SQUOTE] = ACTIONS(1204),
    [anon_sym_L_DQUOTE] = ACTIONS(1204),
    [anon_sym_u_DQUOTE] = ACTIONS(1204),
    [anon_sym_U_DQUOTE] = ACTIONS(1204),
    [anon_sym_u8_DQUOTE] = ACTIONS(1204),
    [anon_sym_DQUOTE] = ACTIONS(1204),
    [sym_true] = ACTIONS(1202),
    [sym_false] = ACTIONS(1202),
    [anon_sym_NULL] = ACTIONS(1202),
    [anon_sym_nullptr] = ACTIONS(1202),
    [sym_comment] = ACTIONS(3),
  },
  [103] = {
    [sym_identifier] = ACTIONS(1206),
    [aux_sym_preproc_include_token1] = ACTIONS(1206),
    [aux_sym_preproc_def_token1] = ACTIONS(1206),
    [aux_sym_preproc_if_token1] = ACTIONS(1206),
    [aux_sym_preproc_if_token2] = ACTIONS(1206),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1206),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1206),
    [aux_sym_preproc_else_token1] = ACTIONS(1206),
    [aux_sym_preproc_elif_token1] = ACTIONS(1206),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1206),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1206),
    [sym_preproc_directive] = ACTIONS(1206),
    [anon_sym_LPAREN2] = ACTIONS(1208),
    [anon_sym_BANG] = ACTIONS(1208),
    [anon_sym_TILDE] = ACTIONS(1208),
    [anon_sym_DASH] = ACTIONS(1206),
    [anon_sym_PLUS] = ACTIONS(1206),
    [anon_sym_STAR] = ACTIONS(1208),
    [anon_sym_AMP] = ACTIONS(1208),
    [anon_sym_SEMI] = ACTIONS(1208),
    [anon_sym___extension__] = ACTIONS(1206),
    [anon_sym_typedef] = ACTIONS(1206),
    [anon_sym_extern] = ACTIONS(1206),
    [anon_sym___attribute__] = ACTIONS(1206),
    [anon_sym___attribute] = ACTIONS(1206),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1208),
    [anon_sym___declspec] = ACTIONS(1206),
    [anon_sym___cdecl] = ACTIONS(1206),
    [anon_sym___clrcall] = ACTIONS(1206),
    [anon_sym___stdcall] = ACTIONS(1206),
    [anon_sym___fastcall] = ACTIONS(1206),
    [anon_sym___thiscall] = ACTIONS(1206),
    [anon_sym___vectorcall] = ACTIONS(1206),
    [anon_sym_LBRACE] = ACTIONS(1208),
    [anon_sym_signed] = ACTIONS(1206),
    [anon_sym_unsigned] = ACTIONS(1206),
    [anon_sym_long] = ACTIONS(1206),
    [anon_sym_short] = ACTIONS(1206),
    [anon_sym_static] = ACTIONS(1206),
    [anon_sym_auto] = ACTIONS(1206),
    [anon_sym_register] = ACTIONS(1206),
    [anon_sym_inline] = ACTIONS(1206),
    [anon_sym___inline] = ACTIONS(1206),
    [anon_sym___inline__] = ACTIONS(1206),
    [anon_sym___forceinline] = ACTIONS(1206),
    [anon_sym_thread_local] = ACTIONS(1206),
    [anon_sym___thread] = ACTIONS(1206),
    [anon_sym_const] = ACTIONS(1206),
    [anon_sym_constexpr] = ACTIONS(1206),
    [anon_sym_volatile] = ACTIONS(1206),
    [anon_sym_restrict] = ACTIONS(1206),
    [anon_sym___restrict__] = ACTIONS(1206),
    [anon_sym__Atomic] = ACTIONS(1206),
    [anon_sym__Noreturn] = ACTIONS(1206),
    [anon_sym_noreturn] = ACTIONS(1206),
    [anon_sym__Nonnull] = ACTIONS(1206),
    [anon_sym_alignas] = ACTIONS(1206),
    [anon_sym__Alignas] = ACTIONS(1206),
    [sym_primitive_type] = ACTIONS(1206),
    [anon_sym_enum] = ACTIONS(1206),
    [anon_sym_struct] = ACTIONS(1206),
    [anon_sym_union] = ACTIONS(1206),
    [anon_sym_if] = ACTIONS(1206),
    [anon_sym_else] = ACTIONS(1206),
    [anon_sym_switch] = ACTIONS(1206),
    [anon_sym_case] = ACTIONS(1206),
    [anon_sym_default] = ACTIONS(1206),
    [anon_sym_while] = ACTIONS(1206),
    [anon_sym_do] = ACTIONS(1206),
    [anon_sym_for] = ACTIONS(1206),
    [anon_sym_return] = ACTIONS(1206),
    [anon_sym_break] = ACTIONS(1206),
    [anon_sym_continue] = ACTIONS(1206),
    [anon_sym_goto] = ACTIONS(1206),
    [anon_sym___try] = ACTIONS(1206),
    [anon_sym___leave] = ACTIONS(1206),
    [anon_sym_DASH_DASH] = ACTIONS(1208),
    [anon_sym_PLUS_PLUS] = ACTIONS(1208),
    [anon_sym_sizeof] = ACTIONS(1206),
    [anon_sym___alignof__] = ACTIONS(1206),
    [anon_sym___alignof] = ACTIONS(1206),
    [anon_sym__alignof] = ACTIONS(1206),
    [anon_sym_alignof] = ACTIONS(1206),
    [anon_sym__Alignof] = ACTIONS(1206),
    [anon_sym_offsetof] = ACTIONS(1206),
    [anon_sym__Generic] = ACTIONS(1206),
    [anon_sym_asm] = ACTIONS(1206),
    [anon_sym___asm__] = ACTIONS(1206),
    [anon_sym___asm] = ACTIONS(1206),
    [sym_number_literal] = ACTIONS(1208),
    [anon_sym_L_SQUOTE] = ACTIONS(1208),
    [anon_sym_u_SQUOTE] = ACTIONS(1208),
    [anon_sym_U_SQUOTE] = ACTIONS(1208),
    [anon_sym_u8_SQUOTE] = ACTIONS(1208),
    [anon_sym_SQUOTE] = ACTIONS(1208),
    [anon_sym_L_DQUOTE] = ACTIONS(1208),
    [anon_sym_u_DQUOTE] = ACTIONS(1208),
    [anon_sym_U_DQUOTE] = ACTIONS(1208),
    [anon_sym_u8_DQUOTE] = ACTIONS(1208),
    [anon_sym_DQUOTE] = ACTIONS(1208),
    [sym_true] = ACTIONS(1206),
    [sym_false] = ACTIONS(1206),
    [anon_sym_NULL] = ACTIONS(1206),
    [anon_sym_nullptr] = ACTIONS(1206),
    [sym_comment] = ACTIONS(3),
  },
  [104] = {
    [sym_identifier] = ACTIONS(1210),
    [aux_sym_preproc_include_token1] = ACTIONS(1210),
    [aux_sym_preproc_def_token1] = ACTIONS(1210),
    [aux_sym_preproc_if_token1] = ACTIONS(1210),
    [aux_sym_preproc_if_token2] = ACTIONS(1210),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1210),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1210),
    [aux_sym_preproc_else_token1] = ACTIONS(1210),
    [aux_sym_preproc_elif_token1] = ACTIONS(1210),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1210),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1210),
    [sym_preproc_directive] = ACTIONS(1210),
    [anon_sym_LPAREN2] = ACTIONS(1212),
    [anon_sym_BANG] = ACTIONS(1212),
    [anon_sym_TILDE] = ACTIONS(1212),
    [anon_sym_DASH] = ACTIONS(1210),
    [anon_sym_PLUS] = ACTIONS(1210),
    [anon_sym_STAR] = ACTIONS(1212),
    [anon_sym_AMP] = ACTIONS(1212),
    [anon_sym_SEMI] = ACTIONS(1212),
    [anon_sym___extension__] = ACTIONS(1210),
    [anon_sym_typedef] = ACTIONS(1210),
    [anon_sym_extern] = ACTIONS(1210),
    [anon_sym___attribute__] = ACTIONS(1210),
    [anon_sym___attribute] = ACTIONS(1210),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1212),
    [anon_sym___declspec] = ACTIONS(1210),
    [anon_sym___cdecl] = ACTIONS(1210),
    [anon_sym___clrcall] = ACTIONS(1210),
    [anon_sym___stdcall] = ACTIONS(1210),
    [anon_sym___fastcall] = ACTIONS(1210),
    [anon_sym___thiscall] = ACTIONS(1210),
    [anon_sym___vectorcall] = ACTIONS(1210),
    [anon_sym_LBRACE] = ACTIONS(1212),
    [anon_sym_signed] = ACTIONS(1210),
    [anon_sym_unsigned] = ACTIONS(1210),
    [anon_sym_long] = ACTIONS(1210),
    [anon_sym_short] = ACTIONS(1210),
    [anon_sym_static] = ACTIONS(1210),
    [anon_sym_auto] = ACTIONS(1210),
    [anon_sym_register] = ACTIONS(1210),
    [anon_sym_inline] = ACTIONS(1210),
    [anon_sym___inline] = ACTIONS(1210),
    [anon_sym___inline__] = ACTIONS(1210),
    [anon_sym___forceinline] = ACTIONS(1210),
    [anon_sym_thread_local] = ACTIONS(1210),
    [anon_sym___thread] = ACTIONS(1210),
    [anon_sym_const] = ACTIONS(1210),
    [anon_sym_constexpr] = ACTIONS(1210),
    [anon_sym_volatile] = ACTIONS(1210),
    [anon_sym_restrict] = ACTIONS(1210),
    [anon_sym___restrict__] = ACTIONS(1210),
    [anon_sym__Atomic] = ACTIONS(1210),
    [anon_sym__Noreturn] = ACTIONS(1210),
    [anon_sym_noreturn] = ACTIONS(1210),
    [anon_sym__Nonnull] = ACTIONS(1210),
    [anon_sym_alignas] = ACTIONS(1210),
    [anon_sym__Alignas] = ACTIONS(1210),
    [sym_primitive_type] = ACTIONS(1210),
    [anon_sym_enum] = ACTIONS(1210),
    [anon_sym_struct] = ACTIONS(1210),
    [anon_sym_union] = ACTIONS(1210),
    [anon_sym_if] = ACTIONS(1210),
    [anon_sym_else] = ACTIONS(1210),
    [anon_sym_switch] = ACTIONS(1210),
    [anon_sym_case] = ACTIONS(1210),
    [anon_sym_default] = ACTIONS(1210),
    [anon_sym_while] = ACTIONS(1210),
    [anon_sym_do] = ACTIONS(1210),
    [anon_sym_for] = ACTIONS(1210),
    [anon_sym_return] = ACTIONS(1210),
    [anon_sym_break] = ACTIONS(1210),
    [anon_sym_continue] = ACTIONS(1210),
    [anon_sym_goto] = ACTIONS(1210),
    [anon_sym___try] = ACTIONS(1210),
    [anon_sym___leave] = ACTIONS(1210),
    [anon_sym_DASH_DASH] = ACTIONS(1212),
    [anon_sym_PLUS_PLUS] = ACTIONS(1212),
    [anon_sym_sizeof] = ACTIONS(1210),
    [anon_sym___alignof__] = ACTIONS(1210),
    [anon_sym___alignof] = ACTIONS(1210),
    [anon_sym__alignof] = ACTIONS(1210),
    [anon_sym_alignof] = ACTIONS(1210),
    [anon_sym__Alignof] = ACTIONS(1210),
    [anon_sym_offsetof] = ACTIONS(1210),
    [anon_sym__Generic] = ACTIONS(1210),
    [anon_sym_asm] = ACTIONS(1210),
    [anon_sym___asm__] = ACTIONS(1210),
    [anon_sym___asm] = ACTIONS(1210),
    [sym_number_literal] = ACTIONS(1212),
    [anon_sym_L_SQUOTE] = ACTIONS(1212),
    [anon_sym_u_SQUOTE] = ACTIONS(1212),
    [anon_sym_U_SQUOTE] = ACTIONS(1212),
    [anon_sym_u8_SQUOTE] = ACTIONS(1212),
    [anon_sym_SQUOTE] = ACTIONS(1212),
    [anon_sym_L_DQUOTE] = ACTIONS(1212),
    [anon_sym_u_DQUOTE] = ACTIONS(1212),
    [anon_sym_U_DQUOTE] = ACTIONS(1212),
    [anon_sym_u8_DQUOTE] = ACTIONS(1212),
    [anon_sym_DQUOTE] = ACTIONS(1212),
    [sym_true] = ACTIONS(1210),
    [sym_false] = ACTIONS(1210),
    [anon_sym_NULL] = ACTIONS(1210),
    [anon_sym_nullptr] = ACTIONS(1210),
    [sym_comment] = ACTIONS(3),
  },
  [105] = {
    [sym_identifier] = ACTIONS(1214),
    [aux_sym_preproc_include_token1] = ACTIONS(1214),
    [aux_sym_preproc_def_token1] = ACTIONS(1214),
    [aux_sym_preproc_if_token1] = ACTIONS(1214),
    [aux_sym_preproc_if_token2] = ACTIONS(1214),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1214),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1214),
    [aux_sym_preproc_else_token1] = ACTIONS(1214),
    [aux_sym_preproc_elif_token1] = ACTIONS(1214),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1214),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1214),
    [sym_preproc_directive] = ACTIONS(1214),
    [anon_sym_LPAREN2] = ACTIONS(1216),
    [anon_sym_BANG] = ACTIONS(1216),
    [anon_sym_TILDE] = ACTIONS(1216),
    [anon_sym_DASH] = ACTIONS(1214),
    [anon_sym_PLUS] = ACTIONS(1214),
    [anon_sym_STAR] = ACTIONS(1216),
    [anon_sym_AMP] = ACTIONS(1216),
    [anon_sym_SEMI] = ACTIONS(1216),
    [anon_sym___extension__] = ACTIONS(1214),
    [anon_sym_typedef] = ACTIONS(1214),
    [anon_sym_extern] = ACTIONS(1214),
    [anon_sym___attribute__] = ACTIONS(1214),
    [anon_sym___attribute] = ACTIONS(1214),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1216),
    [anon_sym___declspec] = ACTIONS(1214),
    [anon_sym___cdecl] = ACTIONS(1214),
    [anon_sym___clrcall] = ACTIONS(1214),
    [anon_sym___stdcall] = ACTIONS(1214),
    [anon_sym___fastcall] = ACTIONS(1214),
    [anon_sym___thiscall] = ACTIONS(1214),
    [anon_sym___vectorcall] = ACTIONS(1214),
    [anon_sym_LBRACE] = ACTIONS(1216),
    [anon_sym_signed] = ACTIONS(1214),
    [anon_sym_unsigned] = ACTIONS(1214),
    [anon_sym_long] = ACTIONS(1214),
    [anon_sym_short] = ACTIONS(1214),
    [anon_sym_static] = ACTIONS(1214),
    [anon_sym_auto] = ACTIONS(1214),
    [anon_sym_register] = ACTIONS(1214),
    [anon_sym_inline] = ACTIONS(1214),
    [anon_sym___inline] = ACTIONS(1214),
    [anon_sym___inline__] = ACTIONS(1214),
    [anon_sym___forceinline] = ACTIONS(1214),
    [anon_sym_thread_local] = ACTIONS(1214),
    [anon_sym___thread] = ACTIONS(1214),
    [anon_sym_const] = ACTIONS(1214),
    [anon_sym_constexpr] = ACTIONS(1214),
    [anon_sym_volatile] = ACTIONS(1214),
    [anon_sym_restrict] = ACTIONS(1214),
    [anon_sym___restrict__] = ACTIONS(1214),
    [anon_sym__Atomic] = ACTIONS(1214),
    [anon_sym__Noreturn] = ACTIONS(1214),
    [anon_sym_noreturn] = ACTIONS(1214),
    [anon_sym__Nonnull] = ACTIONS(1214),
    [anon_sym_alignas] = ACTIONS(1214),
    [anon_sym__Alignas] = ACTIONS(1214),
    [sym_primitive_type] = ACTIONS(1214),
    [anon_sym_enum] = ACTIONS(1214),
    [anon_sym_struct] = ACTIONS(1214),
    [anon_sym_union] = ACTIONS(1214),
    [anon_sym_if] = ACTIONS(1214),
    [anon_sym_else] = ACTIONS(1214),
    [anon_sym_switch] = ACTIONS(1214),
    [anon_sym_case] = ACTIONS(1214),
    [anon_sym_default] = ACTIONS(1214),
    [anon_sym_while] = ACTIONS(1214),
    [anon_sym_do] = ACTIONS(1214),
    [anon_sym_for] = ACTIONS(1214),
    [anon_sym_return] = ACTIONS(1214),
    [anon_sym_break] = ACTIONS(1214),
    [anon_sym_continue] = ACTIONS(1214),
    [anon_sym_goto] = ACTIONS(1214),
    [anon_sym___try] = ACTIONS(1214),
    [anon_sym___leave] = ACTIONS(1214),
    [anon_sym_DASH_DASH] = ACTIONS(1216),
    [anon_sym_PLUS_PLUS] = ACTIONS(1216),
    [anon_sym_sizeof] = ACTIONS(1214),
    [anon_sym___alignof__] = ACTIONS(1214),
    [anon_sym___alignof] = ACTIONS(1214),
    [anon_sym__alignof] = ACTIONS(1214),
    [anon_sym_alignof] = ACTIONS(1214),
    [anon_sym__Alignof] = ACTIONS(1214),
    [anon_sym_offsetof] = ACTIONS(1214),
    [anon_sym__Generic] = ACTIONS(1214),
    [anon_sym_asm] = ACTIONS(1214),
    [anon_sym___asm__] = ACTIONS(1214),
    [anon_sym___asm] = ACTIONS(1214),
    [sym_number_literal] = ACTIONS(1216),
    [anon_sym_L_SQUOTE] = ACTIONS(1216),
    [anon_sym_u_SQUOTE] = ACTIONS(1216),
    [anon_sym_U_SQUOTE] = ACTIONS(1216),
    [anon_sym_u8_SQUOTE] = ACTIONS(1216),
    [anon_sym_SQUOTE] = ACTIONS(1216),
    [anon_sym_L_DQUOTE] = ACTIONS(1216),
    [anon_sym_u_DQUOTE] = ACTIONS(1216),
    [anon_sym_U_DQUOTE] = ACTIONS(1216),
    [anon_sym_u8_DQUOTE] = ACTIONS(1216),
    [anon_sym_DQUOTE] = ACTIONS(1216),
    [sym_true] = ACTIONS(1214),
    [sym_false] = ACTIONS(1214),
    [anon_sym_NULL] = ACTIONS(1214),
    [anon_sym_nullptr] = ACTIONS(1214),
    [sym_comment] = ACTIONS(3),
  },
  [106] = {
    [sym_identifier] = ACTIONS(1218),
    [aux_sym_preproc_include_token1] = ACTIONS(1218),
    [aux_sym_preproc_def_token1] = ACTIONS(1218),
    [aux_sym_preproc_if_token1] = ACTIONS(1218),
    [aux_sym_preproc_if_token2] = ACTIONS(1218),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1218),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1218),
    [aux_sym_preproc_else_token1] = ACTIONS(1218),
    [aux_sym_preproc_elif_token1] = ACTIONS(1218),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1218),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1218),
    [sym_preproc_directive] = ACTIONS(1218),
    [anon_sym_LPAREN2] = ACTIONS(1220),
    [anon_sym_BANG] = ACTIONS(1220),
    [anon_sym_TILDE] = ACTIONS(1220),
    [anon_sym_DASH] = ACTIONS(1218),
    [anon_sym_PLUS] = ACTIONS(1218),
    [anon_sym_STAR] = ACTIONS(1220),
    [anon_sym_AMP] = ACTIONS(1220),
    [anon_sym_SEMI] = ACTIONS(1220),
    [anon_sym___extension__] = ACTIONS(1218),
    [anon_sym_typedef] = ACTIONS(1218),
    [anon_sym_extern] = ACTIONS(1218),
    [anon_sym___attribute__] = ACTIONS(1218),
    [anon_sym___attribute] = ACTIONS(1218),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1220),
    [anon_sym___declspec] = ACTIONS(1218),
    [anon_sym___cdecl] = ACTIONS(1218),
    [anon_sym___clrcall] = ACTIONS(1218),
    [anon_sym___stdcall] = ACTIONS(1218),
    [anon_sym___fastcall] = ACTIONS(1218),
    [anon_sym___thiscall] = ACTIONS(1218),
    [anon_sym___vectorcall] = ACTIONS(1218),
    [anon_sym_LBRACE] = ACTIONS(1220),
    [anon_sym_signed] = ACTIONS(1218),
    [anon_sym_unsigned] = ACTIONS(1218),
    [anon_sym_long] = ACTIONS(1218),
    [anon_sym_short] = ACTIONS(1218),
    [anon_sym_static] = ACTIONS(1218),
    [anon_sym_auto] = ACTIONS(1218),
    [anon_sym_register] = ACTIONS(1218),
    [anon_sym_inline] = ACTIONS(1218),
    [anon_sym___inline] = ACTIONS(1218),
    [anon_sym___inline__] = ACTIONS(1218),
    [anon_sym___forceinline] = ACTIONS(1218),
    [anon_sym_thread_local] = ACTIONS(1218),
    [anon_sym___thread] = ACTIONS(1218),
    [anon_sym_const] = ACTIONS(1218),
    [anon_sym_constexpr] = ACTIONS(1218),
    [anon_sym_volatile] = ACTIONS(1218),
    [anon_sym_restrict] = ACTIONS(1218),
    [anon_sym___restrict__] = ACTIONS(1218),
    [anon_sym__Atomic] = ACTIONS(1218),
    [anon_sym__Noreturn] = ACTIONS(1218),
    [anon_sym_noreturn] = ACTIONS(1218),
    [anon_sym__Nonnull] = ACTIONS(1218),
    [anon_sym_alignas] = ACTIONS(1218),
    [anon_sym__Alignas] = ACTIONS(1218),
    [sym_primitive_type] = ACTIONS(1218),
    [anon_sym_enum] = ACTIONS(1218),
    [anon_sym_struct] = ACTIONS(1218),
    [anon_sym_union] = ACTIONS(1218),
    [anon_sym_if] = ACTIONS(1218),
    [anon_sym_else] = ACTIONS(1218),
    [anon_sym_switch] = ACTIONS(1218),
    [anon_sym_case] = ACTIONS(1218),
    [anon_sym_default] = ACTIONS(1218),
    [anon_sym_while] = ACTIONS(1218),
    [anon_sym_do] = ACTIONS(1218),
    [anon_sym_for] = ACTIONS(1218),
    [anon_sym_return] = ACTIONS(1218),
    [anon_sym_break] = ACTIONS(1218),
    [anon_sym_continue] = ACTIONS(1218),
    [anon_sym_goto] = ACTIONS(1218),
    [anon_sym___try] = ACTIONS(1218),
    [anon_sym___leave] = ACTIONS(1218),
    [anon_sym_DASH_DASH] = ACTIONS(1220),
    [anon_sym_PLUS_PLUS] = ACTIONS(1220),
    [anon_sym_sizeof] = ACTIONS(1218),
    [anon_sym___alignof__] = ACTIONS(1218),
    [anon_sym___alignof] = ACTIONS(1218),
    [anon_sym__alignof] = ACTIONS(1218),
    [anon_sym_alignof] = ACTIONS(1218),
    [anon_sym__Alignof] = ACTIONS(1218),
    [anon_sym_offsetof] = ACTIONS(1218),
    [anon_sym__Generic] = ACTIONS(1218),
    [anon_sym_asm] = ACTIONS(1218),
    [anon_sym___asm__] = ACTIONS(1218),
    [anon_sym___asm] = ACTIONS(1218),
    [sym_number_literal] = ACTIONS(1220),
    [anon_sym_L_SQUOTE] = ACTIONS(1220),
    [anon_sym_u_SQUOTE] = ACTIONS(1220),
    [anon_sym_U_SQUOTE] = ACTIONS(1220),
    [anon_sym_u8_SQUOTE] = ACTIONS(1220),
    [anon_sym_SQUOTE] = ACTIONS(1220),
    [anon_sym_L_DQUOTE] = ACTIONS(1220),
    [anon_sym_u_DQUOTE] = ACTIONS(1220),
    [anon_sym_U_DQUOTE] = ACTIONS(1220),
    [anon_sym_u8_DQUOTE] = ACTIONS(1220),
    [anon_sym_DQUOTE] = ACTIONS(1220),
    [sym_true] = ACTIONS(1218),
    [sym_false] = ACTIONS(1218),
    [anon_sym_NULL] = ACTIONS(1218),
    [anon_sym_nullptr] = ACTIONS(1218),
    [sym_comment] = ACTIONS(3),
  },
  [107] = {
    [sym_identifier] = ACTIONS(1222),
    [aux_sym_preproc_include_token1] = ACTIONS(1222),
    [aux_sym_preproc_def_token1] = ACTIONS(1222),
    [aux_sym_preproc_if_token1] = ACTIONS(1222),
    [aux_sym_preproc_if_token2] = ACTIONS(1222),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1222),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1222),
    [aux_sym_preproc_else_token1] = ACTIONS(1222),
    [aux_sym_preproc_elif_token1] = ACTIONS(1222),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1222),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1222),
    [sym_preproc_directive] = ACTIONS(1222),
    [anon_sym_LPAREN2] = ACTIONS(1224),
    [anon_sym_BANG] = ACTIONS(1224),
    [anon_sym_TILDE] = ACTIONS(1224),
    [anon_sym_DASH] = ACTIONS(1222),
    [anon_sym_PLUS] = ACTIONS(1222),
    [anon_sym_STAR] = ACTIONS(1224),
    [anon_sym_AMP] = ACTIONS(1224),
    [anon_sym_SEMI] = ACTIONS(1224),
    [anon_sym___extension__] = ACTIONS(1222),
    [anon_sym_typedef] = ACTIONS(1222),
    [anon_sym_extern] = ACTIONS(1222),
    [anon_sym___attribute__] = ACTIONS(1222),
    [anon_sym___attribute] = ACTIONS(1222),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1224),
    [anon_sym___declspec] = ACTIONS(1222),
    [anon_sym___cdecl] = ACTIONS(1222),
    [anon_sym___clrcall] = ACTIONS(1222),
    [anon_sym___stdcall] = ACTIONS(1222),
    [anon_sym___fastcall] = ACTIONS(1222),
    [anon_sym___thiscall] = ACTIONS(1222),
    [anon_sym___vectorcall] = ACTIONS(1222),
    [anon_sym_LBRACE] = ACTIONS(1224),
    [anon_sym_signed] = ACTIONS(1222),
    [anon_sym_unsigned] = ACTIONS(1222),
    [anon_sym_long] = ACTIONS(1222),
    [anon_sym_short] = ACTIONS(1222),
    [anon_sym_static] = ACTIONS(1222),
    [anon_sym_auto] = ACTIONS(1222),
    [anon_sym_register] = ACTIONS(1222),
    [anon_sym_inline] = ACTIONS(1222),
    [anon_sym___inline] = ACTIONS(1222),
    [anon_sym___inline__] = ACTIONS(1222),
    [anon_sym___forceinline] = ACTIONS(1222),
    [anon_sym_thread_local] = ACTIONS(1222),
    [anon_sym___thread] = ACTIONS(1222),
    [anon_sym_const] = ACTIONS(1222),
    [anon_sym_constexpr] = ACTIONS(1222),
    [anon_sym_volatile] = ACTIONS(1222),
    [anon_sym_restrict] = ACTIONS(1222),
    [anon_sym___restrict__] = ACTIONS(1222),
    [anon_sym__Atomic] = ACTIONS(1222),
    [anon_sym__Noreturn] = ACTIONS(1222),
    [anon_sym_noreturn] = ACTIONS(1222),
    [anon_sym__Nonnull] = ACTIONS(1222),
    [anon_sym_alignas] = ACTIONS(1222),
    [anon_sym__Alignas] = ACTIONS(1222),
    [sym_primitive_type] = ACTIONS(1222),
    [anon_sym_enum] = ACTIONS(1222),
    [anon_sym_struct] = ACTIONS(1222),
    [anon_sym_union] = ACTIONS(1222),
    [anon_sym_if] = ACTIONS(1222),
    [anon_sym_else] = ACTIONS(1222),
    [anon_sym_switch] = ACTIONS(1222),
    [anon_sym_case] = ACTIONS(1222),
    [anon_sym_default] = ACTIONS(1222),
    [anon_sym_while] = ACTIONS(1222),
    [anon_sym_do] = ACTIONS(1222),
    [anon_sym_for] = ACTIONS(1222),
    [anon_sym_return] = ACTIONS(1222),
    [anon_sym_break] = ACTIONS(1222),
    [anon_sym_continue] = ACTIONS(1222),
    [anon_sym_goto] = ACTIONS(1222),
    [anon_sym___try] = ACTIONS(1222),
    [anon_sym___leave] = ACTIONS(1222),
    [anon_sym_DASH_DASH] = ACTIONS(1224),
    [anon_sym_PLUS_PLUS] = ACTIONS(1224),
    [anon_sym_sizeof] = ACTIONS(1222),
    [anon_sym___alignof__] = ACTIONS(1222),
    [anon_sym___alignof] = ACTIONS(1222),
    [anon_sym__alignof] = ACTIONS(1222),
    [anon_sym_alignof] = ACTIONS(1222),
    [anon_sym__Alignof] = ACTIONS(1222),
    [anon_sym_offsetof] = ACTIONS(1222),
    [anon_sym__Generic] = ACTIONS(1222),
    [anon_sym_asm] = ACTIONS(1222),
    [anon_sym___asm__] = ACTIONS(1222),
    [anon_sym___asm] = ACTIONS(1222),
    [sym_number_literal] = ACTIONS(1224),
    [anon_sym_L_SQUOTE] = ACTIONS(1224),
    [anon_sym_u_SQUOTE] = ACTIONS(1224),
    [anon_sym_U_SQUOTE] = ACTIONS(1224),
    [anon_sym_u8_SQUOTE] = ACTIONS(1224),
    [anon_sym_SQUOTE] = ACTIONS(1224),
    [anon_sym_L_DQUOTE] = ACTIONS(1224),
    [anon_sym_u_DQUOTE] = ACTIONS(1224),
    [anon_sym_U_DQUOTE] = ACTIONS(1224),
    [anon_sym_u8_DQUOTE] = ACTIONS(1224),
    [anon_sym_DQUOTE] = ACTIONS(1224),
    [sym_true] = ACTIONS(1222),
    [sym_false] = ACTIONS(1222),
    [anon_sym_NULL] = ACTIONS(1222),
    [anon_sym_nullptr] = ACTIONS(1222),
    [sym_comment] = ACTIONS(3),
  },
  [108] = {
    [sym_identifier] = ACTIONS(1226),
    [aux_sym_preproc_include_token1] = ACTIONS(1226),
    [aux_sym_preproc_def_token1] = ACTIONS(1226),
    [aux_sym_preproc_if_token1] = ACTIONS(1226),
    [aux_sym_preproc_if_token2] = ACTIONS(1226),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1226),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1226),
    [aux_sym_preproc_else_token1] = ACTIONS(1226),
    [aux_sym_preproc_elif_token1] = ACTIONS(1226),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1226),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1226),
    [sym_preproc_directive] = ACTIONS(1226),
    [anon_sym_LPAREN2] = ACTIONS(1228),
    [anon_sym_BANG] = ACTIONS(1228),
    [anon_sym_TILDE] = ACTIONS(1228),
    [anon_sym_DASH] = ACTIONS(1226),
    [anon_sym_PLUS] = ACTIONS(1226),
    [anon_sym_STAR] = ACTIONS(1228),
    [anon_sym_AMP] = ACTIONS(1228),
    [anon_sym_SEMI] = ACTIONS(1228),
    [anon_sym___extension__] = ACTIONS(1226),
    [anon_sym_typedef] = ACTIONS(1226),
    [anon_sym_extern] = ACTIONS(1226),
    [anon_sym___attribute__] = ACTIONS(1226),
    [anon_sym___attribute] = ACTIONS(1226),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1228),
    [anon_sym___declspec] = ACTIONS(1226),
    [anon_sym___cdecl] = ACTIONS(1226),
    [anon_sym___clrcall] = ACTIONS(1226),
    [anon_sym___stdcall] = ACTIONS(1226),
    [anon_sym___fastcall] = ACTIONS(1226),
    [anon_sym___thiscall] = ACTIONS(1226),
    [anon_sym___vectorcall] = ACTIONS(1226),
    [anon_sym_LBRACE] = ACTIONS(1228),
    [anon_sym_signed] = ACTIONS(1226),
    [anon_sym_unsigned] = ACTIONS(1226),
    [anon_sym_long] = ACTIONS(1226),
    [anon_sym_short] = ACTIONS(1226),
    [anon_sym_static] = ACTIONS(1226),
    [anon_sym_auto] = ACTIONS(1226),
    [anon_sym_register] = ACTIONS(1226),
    [anon_sym_inline] = ACTIONS(1226),
    [anon_sym___inline] = ACTIONS(1226),
    [anon_sym___inline__] = ACTIONS(1226),
    [anon_sym___forceinline] = ACTIONS(1226),
    [anon_sym_thread_local] = ACTIONS(1226),
    [anon_sym___thread] = ACTIONS(1226),
    [anon_sym_const] = ACTIONS(1226),
    [anon_sym_constexpr] = ACTIONS(1226),
    [anon_sym_volatile] = ACTIONS(1226),
    [anon_sym_restrict] = ACTIONS(1226),
    [anon_sym___restrict__] = ACTIONS(1226),
    [anon_sym__Atomic] = ACTIONS(1226),
    [anon_sym__Noreturn] = ACTIONS(1226),
    [anon_sym_noreturn] = ACTIONS(1226),
    [anon_sym__Nonnull] = ACTIONS(1226),
    [anon_sym_alignas] = ACTIONS(1226),
    [anon_sym__Alignas] = ACTIONS(1226),
    [sym_primitive_type] = ACTIONS(1226),
    [anon_sym_enum] = ACTIONS(1226),
    [anon_sym_struct] = ACTIONS(1226),
    [anon_sym_union] = ACTIONS(1226),
    [anon_sym_if] = ACTIONS(1226),
    [anon_sym_else] = ACTIONS(1226),
    [anon_sym_switch] = ACTIONS(1226),
    [anon_sym_case] = ACTIONS(1226),
    [anon_sym_default] = ACTIONS(1226),
    [anon_sym_while] = ACTIONS(1226),
    [anon_sym_do] = ACTIONS(1226),
    [anon_sym_for] = ACTIONS(1226),
    [anon_sym_return] = ACTIONS(1226),
    [anon_sym_break] = ACTIONS(1226),
    [anon_sym_continue] = ACTIONS(1226),
    [anon_sym_goto] = ACTIONS(1226),
    [anon_sym___try] = ACTIONS(1226),
    [anon_sym___leave] = ACTIONS(1226),
    [anon_sym_DASH_DASH] = ACTIONS(1228),
    [anon_sym_PLUS_PLUS] = ACTIONS(1228),
    [anon_sym_sizeof] = ACTIONS(1226),
    [anon_sym___alignof__] = ACTIONS(1226),
    [anon_sym___alignof] = ACTIONS(1226),
    [anon_sym__alignof] = ACTIONS(1226),
    [anon_sym_alignof] = ACTIONS(1226),
    [anon_sym__Alignof] = ACTIONS(1226),
    [anon_sym_offsetof] = ACTIONS(1226),
    [anon_sym__Generic] = ACTIONS(1226),
    [anon_sym_asm] = ACTIONS(1226),
    [anon_sym___asm__] = ACTIONS(1226),
    [anon_sym___asm] = ACTIONS(1226),
    [sym_number_literal] = ACTIONS(1228),
    [anon_sym_L_SQUOTE] = ACTIONS(1228),
    [anon_sym_u_SQUOTE] = ACTIONS(1228),
    [anon_sym_U_SQUOTE] = ACTIONS(1228),
    [anon_sym_u8_SQUOTE] = ACTIONS(1228),
    [anon_sym_SQUOTE] = ACTIONS(1228),
    [anon_sym_L_DQUOTE] = ACTIONS(1228),
    [anon_sym_u_DQUOTE] = ACTIONS(1228),
    [anon_sym_U_DQUOTE] = ACTIONS(1228),
    [anon_sym_u8_DQUOTE] = ACTIONS(1228),
    [anon_sym_DQUOTE] = ACTIONS(1228),
    [sym_true] = ACTIONS(1226),
    [sym_false] = ACTIONS(1226),
    [anon_sym_NULL] = ACTIONS(1226),
    [anon_sym_nullptr] = ACTIONS(1226),
    [sym_comment] = ACTIONS(3),
  },
  [109] = {
    [sym_identifier] = ACTIONS(1230),
    [aux_sym_preproc_include_token1] = ACTIONS(1230),
    [aux_sym_preproc_def_token1] = ACTIONS(1230),
    [aux_sym_preproc_if_token1] = ACTIONS(1230),
    [aux_sym_preproc_if_token2] = ACTIONS(1230),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1230),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1230),
    [aux_sym_preproc_else_token1] = ACTIONS(1230),
    [aux_sym_preproc_elif_token1] = ACTIONS(1230),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1230),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1230),
    [sym_preproc_directive] = ACTIONS(1230),
    [anon_sym_LPAREN2] = ACTIONS(1232),
    [anon_sym_BANG] = ACTIONS(1232),
    [anon_sym_TILDE] = ACTIONS(1232),
    [anon_sym_DASH] = ACTIONS(1230),
    [anon_sym_PLUS] = ACTIONS(1230),
    [anon_sym_STAR] = ACTIONS(1232),
    [anon_sym_AMP] = ACTIONS(1232),
    [anon_sym_SEMI] = ACTIONS(1232),
    [anon_sym___extension__] = ACTIONS(1230),
    [anon_sym_typedef] = ACTIONS(1230),
    [anon_sym_extern] = ACTIONS(1230),
    [anon_sym___attribute__] = ACTIONS(1230),
    [anon_sym___attribute] = ACTIONS(1230),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1232),
    [anon_sym___declspec] = ACTIONS(1230),
    [anon_sym___cdecl] = ACTIONS(1230),
    [anon_sym___clrcall] = ACTIONS(1230),
    [anon_sym___stdcall] = ACTIONS(1230),
    [anon_sym___fastcall] = ACTIONS(1230),
    [anon_sym___thiscall] = ACTIONS(1230),
    [anon_sym___vectorcall] = ACTIONS(1230),
    [anon_sym_LBRACE] = ACTIONS(1232),
    [anon_sym_signed] = ACTIONS(1230),
    [anon_sym_unsigned] = ACTIONS(1230),
    [anon_sym_long] = ACTIONS(1230),
    [anon_sym_short] = ACTIONS(1230),
    [anon_sym_static] = ACTIONS(1230),
    [anon_sym_auto] = ACTIONS(1230),
    [anon_sym_register] = ACTIONS(1230),
    [anon_sym_inline] = ACTIONS(1230),
    [anon_sym___inline] = ACTIONS(1230),
    [anon_sym___inline__] = ACTIONS(1230),
    [anon_sym___forceinline] = ACTIONS(1230),
    [anon_sym_thread_local] = ACTIONS(1230),
    [anon_sym___thread] = ACTIONS(1230),
    [anon_sym_const] = ACTIONS(1230),
    [anon_sym_constexpr] = ACTIONS(1230),
    [anon_sym_volatile] = ACTIONS(1230),
    [anon_sym_restrict] = ACTIONS(1230),
    [anon_sym___restrict__] = ACTIONS(1230),
    [anon_sym__Atomic] = ACTIONS(1230),
    [anon_sym__Noreturn] = ACTIONS(1230),
    [anon_sym_noreturn] = ACTIONS(1230),
    [anon_sym__Nonnull] = ACTIONS(1230),
    [anon_sym_alignas] = ACTIONS(1230),
    [anon_sym__Alignas] = ACTIONS(1230),
    [sym_primitive_type] = ACTIONS(1230),
    [anon_sym_enum] = ACTIONS(1230),
    [anon_sym_struct] = ACTIONS(1230),
    [anon_sym_union] = ACTIONS(1230),
    [anon_sym_if] = ACTIONS(1230),
    [anon_sym_else] = ACTIONS(1230),
    [anon_sym_switch] = ACTIONS(1230),
    [anon_sym_case] = ACTIONS(1230),
    [anon_sym_default] = ACTIONS(1230),
    [anon_sym_while] = ACTIONS(1230),
    [anon_sym_do] = ACTIONS(1230),
    [anon_sym_for] = ACTIONS(1230),
    [anon_sym_return] = ACTIONS(1230),
    [anon_sym_break] = ACTIONS(1230),
    [anon_sym_continue] = ACTIONS(1230),
    [anon_sym_goto] = ACTIONS(1230),
    [anon_sym___try] = ACTIONS(1230),
    [anon_sym___leave] = ACTIONS(1230),
    [anon_sym_DASH_DASH] = ACTIONS(1232),
    [anon_sym_PLUS_PLUS] = ACTIONS(1232),
    [anon_sym_sizeof] = ACTIONS(1230),
    [anon_sym___alignof__] = ACTIONS(1230),
    [anon_sym___alignof] = ACTIONS(1230),
    [anon_sym__alignof] = ACTIONS(1230),
    [anon_sym_alignof] = ACTIONS(1230),
    [anon_sym__Alignof] = ACTIONS(1230),
    [anon_sym_offsetof] = ACTIONS(1230),
    [anon_sym__Generic] = ACTIONS(1230),
    [anon_sym_asm] = ACTIONS(1230),
    [anon_sym___asm__] = ACTIONS(1230),
    [anon_sym___asm] = ACTIONS(1230),
    [sym_number_literal] = ACTIONS(1232),
    [anon_sym_L_SQUOTE] = ACTIONS(1232),
    [anon_sym_u_SQUOTE] = ACTIONS(1232),
    [anon_sym_U_SQUOTE] = ACTIONS(1232),
    [anon_sym_u8_SQUOTE] = ACTIONS(1232),
    [anon_sym_SQUOTE] = ACTIONS(1232),
    [anon_sym_L_DQUOTE] = ACTIONS(1232),
    [anon_sym_u_DQUOTE] = ACTIONS(1232),
    [anon_sym_U_DQUOTE] = ACTIONS(1232),
    [anon_sym_u8_DQUOTE] = ACTIONS(1232),
    [anon_sym_DQUOTE] = ACTIONS(1232),
    [sym_true] = ACTIONS(1230),
    [sym_false] = ACTIONS(1230),
    [anon_sym_NULL] = ACTIONS(1230),
    [anon_sym_nullptr] = ACTIONS(1230),
    [sym_comment] = ACTIONS(3),
  },
  [110] = {
    [sym_identifier] = ACTIONS(1234),
    [aux_sym_preproc_include_token1] = ACTIONS(1234),
    [aux_sym_preproc_def_token1] = ACTIONS(1234),
    [aux_sym_preproc_if_token1] = ACTIONS(1234),
    [aux_sym_preproc_if_token2] = ACTIONS(1234),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1234),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1234),
    [aux_sym_preproc_else_token1] = ACTIONS(1234),
    [aux_sym_preproc_elif_token1] = ACTIONS(1234),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1234),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1234),
    [sym_preproc_directive] = ACTIONS(1234),
    [anon_sym_LPAREN2] = ACTIONS(1236),
    [anon_sym_BANG] = ACTIONS(1236),
    [anon_sym_TILDE] = ACTIONS(1236),
    [anon_sym_DASH] = ACTIONS(1234),
    [anon_sym_PLUS] = ACTIONS(1234),
    [anon_sym_STAR] = ACTIONS(1236),
    [anon_sym_AMP] = ACTIONS(1236),
    [anon_sym_SEMI] = ACTIONS(1236),
    [anon_sym___extension__] = ACTIONS(1234),
    [anon_sym_typedef] = ACTIONS(1234),
    [anon_sym_extern] = ACTIONS(1234),
    [anon_sym___attribute__] = ACTIONS(1234),
    [anon_sym___attribute] = ACTIONS(1234),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1236),
    [anon_sym___declspec] = ACTIONS(1234),
    [anon_sym___cdecl] = ACTIONS(1234),
    [anon_sym___clrcall] = ACTIONS(1234),
    [anon_sym___stdcall] = ACTIONS(1234),
    [anon_sym___fastcall] = ACTIONS(1234),
    [anon_sym___thiscall] = ACTIONS(1234),
    [anon_sym___vectorcall] = ACTIONS(1234),
    [anon_sym_LBRACE] = ACTIONS(1236),
    [anon_sym_signed] = ACTIONS(1234),
    [anon_sym_unsigned] = ACTIONS(1234),
    [anon_sym_long] = ACTIONS(1234),
    [anon_sym_short] = ACTIONS(1234),
    [anon_sym_static] = ACTIONS(1234),
    [anon_sym_auto] = ACTIONS(1234),
    [anon_sym_register] = ACTIONS(1234),
    [anon_sym_inline] = ACTIONS(1234),
    [anon_sym___inline] = ACTIONS(1234),
    [anon_sym___inline__] = ACTIONS(1234),
    [anon_sym___forceinline] = ACTIONS(1234),
    [anon_sym_thread_local] = ACTIONS(1234),
    [anon_sym___thread] = ACTIONS(1234),
    [anon_sym_const] = ACTIONS(1234),
    [anon_sym_constexpr] = ACTIONS(1234),
    [anon_sym_volatile] = ACTIONS(1234),
    [anon_sym_restrict] = ACTIONS(1234),
    [anon_sym___restrict__] = ACTIONS(1234),
    [anon_sym__Atomic] = ACTIONS(1234),
    [anon_sym__Noreturn] = ACTIONS(1234),
    [anon_sym_noreturn] = ACTIONS(1234),
    [anon_sym__Nonnull] = ACTIONS(1234),
    [anon_sym_alignas] = ACTIONS(1234),
    [anon_sym__Alignas] = ACTIONS(1234),
    [sym_primitive_type] = ACTIONS(1234),
    [anon_sym_enum] = ACTIONS(1234),
    [anon_sym_struct] = ACTIONS(1234),
    [anon_sym_union] = ACTIONS(1234),
    [anon_sym_if] = ACTIONS(1234),
    [anon_sym_else] = ACTIONS(1234),
    [anon_sym_switch] = ACTIONS(1234),
    [anon_sym_case] = ACTIONS(1234),
    [anon_sym_default] = ACTIONS(1234),
    [anon_sym_while] = ACTIONS(1234),
    [anon_sym_do] = ACTIONS(1234),
    [anon_sym_for] = ACTIONS(1234),
    [anon_sym_return] = ACTIONS(1234),
    [anon_sym_break] = ACTIONS(1234),
    [anon_sym_continue] = ACTIONS(1234),
    [anon_sym_goto] = ACTIONS(1234),
    [anon_sym___try] = ACTIONS(1234),
    [anon_sym___leave] = ACTIONS(1234),
    [anon_sym_DASH_DASH] = ACTIONS(1236),
    [anon_sym_PLUS_PLUS] = ACTIONS(1236),
    [anon_sym_sizeof] = ACTIONS(1234),
    [anon_sym___alignof__] = ACTIONS(1234),
    [anon_sym___alignof] = ACTIONS(1234),
    [anon_sym__alignof] = ACTIONS(1234),
    [anon_sym_alignof] = ACTIONS(1234),
    [anon_sym__Alignof] = ACTIONS(1234),
    [anon_sym_offsetof] = ACTIONS(1234),
    [anon_sym__Generic] = ACTIONS(1234),
    [anon_sym_asm] = ACTIONS(1234),
    [anon_sym___asm__] = ACTIONS(1234),
    [anon_sym___asm] = ACTIONS(1234),
    [sym_number_literal] = ACTIONS(1236),
    [anon_sym_L_SQUOTE] = ACTIONS(1236),
    [anon_sym_u_SQUOTE] = ACTIONS(1236),
    [anon_sym_U_SQUOTE] = ACTIONS(1236),
    [anon_sym_u8_SQUOTE] = ACTIONS(1236),
    [anon_sym_SQUOTE] = ACTIONS(1236),
    [anon_sym_L_DQUOTE] = ACTIONS(1236),
    [anon_sym_u_DQUOTE] = ACTIONS(1236),
    [anon_sym_U_DQUOTE] = ACTIONS(1236),
    [anon_sym_u8_DQUOTE] = ACTIONS(1236),
    [anon_sym_DQUOTE] = ACTIONS(1236),
    [sym_true] = ACTIONS(1234),
    [sym_false] = ACTIONS(1234),
    [anon_sym_NULL] = ACTIONS(1234),
    [anon_sym_nullptr] = ACTIONS(1234),
    [sym_comment] = ACTIONS(3),
  },
  [111] = {
    [sym_identifier] = ACTIONS(1238),
    [aux_sym_preproc_include_token1] = ACTIONS(1238),
    [aux_sym_preproc_def_token1] = ACTIONS(1238),
    [aux_sym_preproc_if_token1] = ACTIONS(1238),
    [aux_sym_preproc_if_token2] = ACTIONS(1238),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1238),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1238),
    [aux_sym_preproc_else_token1] = ACTIONS(1238),
    [aux_sym_preproc_elif_token1] = ACTIONS(1238),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1238),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1238),
    [sym_preproc_directive] = ACTIONS(1238),
    [anon_sym_LPAREN2] = ACTIONS(1240),
    [anon_sym_BANG] = ACTIONS(1240),
    [anon_sym_TILDE] = ACTIONS(1240),
    [anon_sym_DASH] = ACTIONS(1238),
    [anon_sym_PLUS] = ACTIONS(1238),
    [anon_sym_STAR] = ACTIONS(1240),
    [anon_sym_AMP] = ACTIONS(1240),
    [anon_sym_SEMI] = ACTIONS(1240),
    [anon_sym___extension__] = ACTIONS(1238),
    [anon_sym_typedef] = ACTIONS(1238),
    [anon_sym_extern] = ACTIONS(1238),
    [anon_sym___attribute__] = ACTIONS(1238),
    [anon_sym___attribute] = ACTIONS(1238),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1240),
    [anon_sym___declspec] = ACTIONS(1238),
    [anon_sym___cdecl] = ACTIONS(1238),
    [anon_sym___clrcall] = ACTIONS(1238),
    [anon_sym___stdcall] = ACTIONS(1238),
    [anon_sym___fastcall] = ACTIONS(1238),
    [anon_sym___thiscall] = ACTIONS(1238),
    [anon_sym___vectorcall] = ACTIONS(1238),
    [anon_sym_LBRACE] = ACTIONS(1240),
    [anon_sym_signed] = ACTIONS(1238),
    [anon_sym_unsigned] = ACTIONS(1238),
    [anon_sym_long] = ACTIONS(1238),
    [anon_sym_short] = ACTIONS(1238),
    [anon_sym_static] = ACTIONS(1238),
    [anon_sym_auto] = ACTIONS(1238),
    [anon_sym_register] = ACTIONS(1238),
    [anon_sym_inline] = ACTIONS(1238),
    [anon_sym___inline] = ACTIONS(1238),
    [anon_sym___inline__] = ACTIONS(1238),
    [anon_sym___forceinline] = ACTIONS(1238),
    [anon_sym_thread_local] = ACTIONS(1238),
    [anon_sym___thread] = ACTIONS(1238),
    [anon_sym_const] = ACTIONS(1238),
    [anon_sym_constexpr] = ACTIONS(1238),
    [anon_sym_volatile] = ACTIONS(1238),
    [anon_sym_restrict] = ACTIONS(1238),
    [anon_sym___restrict__] = ACTIONS(1238),
    [anon_sym__Atomic] = ACTIONS(1238),
    [anon_sym__Noreturn] = ACTIONS(1238),
    [anon_sym_noreturn] = ACTIONS(1238),
    [anon_sym__Nonnull] = ACTIONS(1238),
    [anon_sym_alignas] = ACTIONS(1238),
    [anon_sym__Alignas] = ACTIONS(1238),
    [sym_primitive_type] = ACTIONS(1238),
    [anon_sym_enum] = ACTIONS(1238),
    [anon_sym_struct] = ACTIONS(1238),
    [anon_sym_union] = ACTIONS(1238),
    [anon_sym_if] = ACTIONS(1238),
    [anon_sym_else] = ACTIONS(1238),
    [anon_sym_switch] = ACTIONS(1238),
    [anon_sym_case] = ACTIONS(1238),
    [anon_sym_default] = ACTIONS(1238),
    [anon_sym_while] = ACTIONS(1238),
    [anon_sym_do] = ACTIONS(1238),
    [anon_sym_for] = ACTIONS(1238),
    [anon_sym_return] = ACTIONS(1238),
    [anon_sym_break] = ACTIONS(1238),
    [anon_sym_continue] = ACTIONS(1238),
    [anon_sym_goto] = ACTIONS(1238),
    [anon_sym___try] = ACTIONS(1238),
    [anon_sym___leave] = ACTIONS(1238),
    [ano