from _typeshed import Incomplete

class QRColorMask:
    back_color: Incomplete
    has_transparency: bool
    paint_color = back_color
    def initialize(self, styledPilImage, image) -> None: ...
    def apply_mask(self, image) -> None: ...
    def get_fg_pixel(self, image, x, y) -> None: ...
    def get_bg_pixel(self, image, x, y): ...
    def interp_num(self, n1, n2, norm): ...
    def interp_color(self, col1, col2, norm): ...
    def extrap_num(self, n1, n2, interped_num): ...
    def extrap_color(self, col1, col2, interped_color): ...

class SolidFillColorMask(QRColorMask):
    back_color: Incomplete
    front_color: Incomplete
    has_transparency: Incomplete
    def __init__(self, back_color=(255, 255, 255), front_color=(0, 0, 0)) -> None: ...
    def apply_mask(self, image) -> None: ...
    def get_fg_pixel(self, image, x, y): ...

class RadialGradiantColorMask(QRColorMask):
    back_color: Incomplete
    center_color: Incomplete
    edge_color: Incomplete
    has_transparency: Incomplete
    def __init__(self, back_color=(255, 255, 255), center_color=(0, 0, 0), edge_color=(0, 0, 255)) -> None: ...
    def get_fg_pixel(self, image, x, y): ...

class SquareGradiantColorMask(QRColorMask):
    back_color: Incomplete
    center_color: Incomplete
    edge_color: Incomplete
    has_transparency: Incomplete
    def __init__(self, back_color=(255, 255, 255), center_color=(0, 0, 0), edge_color=(0, 0, 255)) -> None: ...
    def get_fg_pixel(self, image, x, y): ...

class HorizontalGradiantColorMask(QRColorMask):
    back_color: Incomplete
    left_color: Incomplete
    right_color: Incomplete
    has_transparency: Incomplete
    def __init__(self, back_color=(255, 255, 255), left_color=(0, 0, 0), right_color=(0, 0, 255)) -> None: ...
    def get_fg_pixel(self, image, x, y): ...

class VerticalGradiantColorMask(QRColorMask):
    back_color: Incomplete
    top_color: Incomplete
    bottom_color: Incomplete
    has_transparency: Incomplete
    def __init__(self, back_color=(255, 255, 255), top_color=(0, 0, 0), bottom_color=(0, 0, 255)) -> None: ...
    def get_fg_pixel(self, image, x, y): ...

class ImageColorMask(QRColorMask):
    back_color: Incomplete
    color_img: Incomplete
    has_transparency: Incomplete
    def __init__(
        self, back_color=(255, 255, 255), color_mask_path: Incomplete | None = None, color_mask_image: Incomplete | None = None
    ) -> None: ...
    paint_color: Incomplete
    def initialize(self, styledPilImage, image) -> None: ...
    def get_fg_pixel(self, image, x, y): ...
