/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.station.backend.split.recents;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.RecentProject;
import com.intellij.ide.RecentProjectStatus;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.station.backend.split.StationBackendSplitBundle;
import com.intellij.station.backend.split.recents.IdeRecentProject;
import com.intellij.station.backend.split.recents.StationRecentProjectProgressManager;
import com.intellij.station.backend.split.recents.StationRecentProjectsService;
import com.intellij.station.comms.common.recents.RecentProjectsResponse;
import java.util.List;
import javax.swing.Icon;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010/\u001a\u000200H\u0016J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0016J\b\u00105\u001a\u000202H\u0016J\t\u00108\u001a\u00020\u0003H\u00c6\u0003J\u0013\u00109\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010:\u001a\u0002002\b\u0010;\u001a\u0004\u0018\u00010<H\u00d6\u0003J\t\u0010=\u001a\u00020>H\u00d6\u0001J\t\u0010?\u001a\u00020\rH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0016\u0010\u0013\u001a\u0004\u0018\u00010\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0010R\u0016\u0010\u0015\u001a\u0004\u0018\u00010\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0010R\u0016\u0010\u0017\u001a\u0004\u0018\u00010\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0010R\u001b\u0010\u0019\u001a\t\u0018\u00010\r\u00a2\u0006\u0002\b\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0010R\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0016\u0010 \u001a\u0004\u0018\u00010!X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0016\u0010$\u001a\u0004\u0018\u00010!X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010#R\u0014\u0010&\u001a\u00020'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u001a\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u0014\u00106\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u0010\u0007\u00a8\u0006@"}, d2={"Lcom/intellij/station/backend/split/recents/StationRecentProject;", "Lcom/intellij/ide/RecentProject;", "project", "Lcom/intellij/station/backend/split/recents/IdeRecentProject;", "<init>", "(Lcom/intellij/station/backend/split/recents/IdeRecentProject;)V", "getProject", "()Lcom/intellij/station/backend/split/recents/IdeRecentProject;", "record", "Lcom/intellij/station/comms/common/recents/RecentProjectsResponse$RecentProject;", "getRecord", "()Lcom/intellij/station/comms/common/recents/RecentProjectsResponse$RecentProject;", "projectId", "", "Lorg/jetbrains/annotations/NonNls;", "getProjectId", "()Ljava/lang/String;", "displayName", "getDisplayName", "projectPath", "getProjectPath", "branchName", "getBranchName", "providerName", "getProviderName", "providerPath", "Lcom/intellij/openapi/util/NlsSafe;", "getProviderPath", "activationTimestamp", "", "getActivationTimestamp", "()Ljava/lang/Long;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "providerIcon", "getProviderIcon", "status", "Lcom/intellij/ide/RecentProjectStatus;", "getStatus", "()Lcom/intellij/ide/RecentProjectStatus;", "additionalActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "getAdditionalActions", "()Ljava/util/List;", "canOpenProject", "", "openProject", "", "actionEvent", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "removeFromRecent", "upToDateProject", "getUpToDateProject", "component1", "copy", "equals", "other", "", "hashCode", "", "toString", "intellij.station.backend.split"})
@SourceDebugExtension(value={"SMAP\nStationRecentProjectsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StationRecentProjectsProvider.kt\ncom/intellij/station/backend/split/recents/StationRecentProject\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,205:1\n1#2:206\n40#3,3:207\n40#3,3:210\n40#3,3:213\n40#3,3:216\n*S KotlinDebug\n*F\n+ 1 StationRecentProjectsProvider.kt\ncom/intellij/station/backend/split/recents/StationRecentProject\n*L\n84#1:207,3\n102#1:210,3\n106#1:213,3\n112#1:216,3\n*E\n"})
public final class StationRecentProject
implements RecentProject {
    @NotNull
    private final IdeRecentProject project;
    @Nullable
    private final Icon icon;
    @Nullable
    private final Icon providerIcon;

    public StationRecentProject(@NotNull IdeRecentProject project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Lazy<Icon> lazy = this.project.getProjectIcon();
        this.icon = lazy != null ? (Icon)lazy.getValue() : null;
        Lazy<Icon> lazy2 = this.project.getProviderIcon();
        this.providerIcon = lazy2 != null ? (Icon)lazy2.getValue() : null;
    }

    @NotNull
    public final IdeRecentProject getProject() {
        return this.project;
    }

    @NotNull
    public final RecentProjectsResponse.RecentProject getRecord() {
        return this.project.getRecord();
    }

    @NotNull
    public String getProjectId() {
        return this.getRecord().getId();
    }

    @NotNull
    public String getDisplayName() {
        return this.getRecord().getDisplayName();
    }

    @Nullable
    public String getProjectPath() {
        return this.getRecord().getProjectPath();
    }

    @Nullable
    public String getBranchName() {
        return this.getRecord().getBranchName();
    }

    @Nullable
    public String getProviderName() {
        return this.getRecord().getProviderName();
    }

    @Nullable
    public String getProviderPath() {
        return this.getRecord().getProviderPath();
    }

    @Nullable
    public Long getActivationTimestamp() {
        return this.getRecord().getActivationTimestamp();
    }

    @Nullable
    public Icon getIcon() {
        return this.icon;
    }

    @Nullable
    public Icon getProviderIcon() {
        return this.providerIcon;
    }

    @NotNull
    public RecentProjectStatus getStatus() {
        String progressText;
        RecentProjectsResponse.HostStatus hostStatus;
        IdeRecentProject upToDateProject = this.getUpToDateProject();
        RecentProjectsResponse.HostStatus hostStatus2 = hostStatus = upToDateProject.getRecord().getHostStatus();
        String statusText = hostStatus2 != null ? hostStatus2.getStatusText() : null;
        Object object = hostStatus;
        if (object != null && (object = object.getProgressText()) != null) {
            Object it = object;
            boolean bl = false;
            v2 = StringUtil.capitalizeWords((String)it, (boolean)false);
        } else {
            v2 = progressText = null;
        }
        if (progressText == null) {
            boolean $i$f$service = false;
            Class<StationRecentProjectProgressManager> serviceClass$iv = StationRecentProjectProgressManager.class;
            Object object2 = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object2 == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            if (((StationRecentProjectProgressManager)object2).isProjectOpening(this.getRecord().getId())) {
                progressText = StationBackendSplitBundle.INSTANCE.message("station.opening.project.project.widget.status", new Object[0]);
            }
        }
        return new RecentProjectStatus(upToDateProject.getRecord().isProjectOpened(), statusText, progressText);
    }

    @NotNull
    public List<AnAction> getAdditionalActions() {
        return this.getUpToDateProject().getActions();
    }

    public boolean canOpenProject() {
        RecentProjectsResponse.HostStatus hostStatus = this.getUpToDateProject().getRecord().getHostStatus();
        if (hostStatus == null) {
            return true;
        }
        RecentProjectsResponse.HostStatus hostStatus2 = hostStatus;
        return hostStatus2.getCanOpenProject();
    }

    public void openProject(@NotNull AnActionEvent actionEvent) {
        Intrinsics.checkNotNullParameter((Object)actionEvent, (String)"actionEvent");
        boolean $i$f$service = false;
        Class<StationRecentProjectsService> serviceClass$iv = StationRecentProjectsService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        ((StationRecentProjectsService)object).openProject(this.getRecord().getId());
    }

    public void removeFromRecent() {
        boolean $i$f$service = false;
        Class<StationRecentProjectsService> serviceClass$iv = StationRecentProjectsService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        ((StationRecentProjectsService)object).removeFromRecent(this.getRecord().getId());
    }

    private final IdeRecentProject getUpToDateProject() {
        IdeRecentProject ideRecentProject;
        Object v1;
        block3: {
            boolean $i$f$service = false;
            Class<StationRecentProjectsService> serviceClass$iv = StationRecentProjectsService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            Iterable iterable = (Iterable)((StationRecentProjectsService)object).getRecentProjects().getValue();
            for (Object t : iterable) {
                IdeRecentProject it = (IdeRecentProject)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getRecord().getId(), (Object)this.getRecord().getId())) continue;
                v1 = t;
                break block3;
            }
            v1 = null;
        }
        if ((ideRecentProject = (IdeRecentProject)v1) == null) {
            ideRecentProject = this.project;
        }
        return ideRecentProject;
    }

    @NotNull
    public final IdeRecentProject component1() {
        return this.project;
    }

    @NotNull
    public final StationRecentProject copy(@NotNull IdeRecentProject project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new StationRecentProject(project);
    }

    public static /* synthetic */ StationRecentProject copy$default(StationRecentProject stationRecentProject, IdeRecentProject ideRecentProject, int n, Object object) {
        if ((n & 1) != 0) {
            ideRecentProject = stationRecentProject.project;
        }
        return stationRecentProject.copy(ideRecentProject);
    }

    @NotNull
    public String toString() {
        return "StationRecentProject(project=" + this.project + ")";
    }

    public int hashCode() {
        return this.project.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StationRecentProject)) {
            return false;
        }
        StationRecentProject stationRecentProject = (StationRecentProject)other;
        return Intrinsics.areEqual((Object)this.project, (Object)stationRecentProject.project);
    }
}

