/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.configurable;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.options.BoundSearchableConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.IssueNavigationConfiguration;
import com.intellij.openapi.vcs.IssueNavigationLink;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.configurable.IssueLinkConfigurationDialog;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.UIBundle;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u0002:\u0003\u0016\u0017\u0018B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\f\u001a\u00020\rH\u0016J\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u0013H\u0002J\u001e\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u0013H\u0002J\f\u0010\u0015\u001a\u00020\n*\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/openapi/vcs/configurable/IssueNavigationConfigurable;", "Lcom/intellij/openapi/options/BoundSearchableConfigurable;", "Lcom/intellij/openapi/options/Configurable$NoScroll;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "ISSUE_COLUMN", "Lcom/intellij/util/ui/ColumnInfo;", "Lcom/intellij/openapi/vcs/IssueNavigationLink;", "", "LINK_COLUMN", "createPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "removeLink", "", "linkTable", "Lcom/intellij/ui/table/JBTable;", "model", "Lcom/intellij/util/ui/ListTableModel;", "editLink", "addHttpsIfUrlPrefixMissing", "AddYouTrackLinkAction", "AddJiraLinkAction", "AddIssueNavigationLinkAction", "intellij.platform.vcs.impl"})
public final class IssueNavigationConfigurable
extends BoundSearchableConfigurable
implements Configurable.NoScroll {
    @NotNull
    private final Project project;
    @NotNull
    private final ColumnInfo<IssueNavigationLink, String> ISSUE_COLUMN;
    @NotNull
    private final ColumnInfo<IssueNavigationLink, String> LINK_COLUMN;

    public IssueNavigationConfigurable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = VcsBundle.message((String)"configurable.IssueNavigationConfigurationPanel.display.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        super(string, "project.propVCSSupport.Issue.Navigation", null, 4, null);
        this.project = project;
        String string2 = VcsBundle.message((String)"issue.link.issue.column", (Object[])new Object[0]);
        this.ISSUE_COLUMN = (ColumnInfo)new ColumnInfo<IssueNavigationLink, String>(string2){

            public String valueOf(IssueNavigationLink issueNavigationLink) {
                Intrinsics.checkNotNullParameter((Object)issueNavigationLink, (String)"issueNavigationLink");
                String string = issueNavigationLink.getIssueRegexp();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIssueRegexp(...)");
                return string;
            }
        };
        string2 = VcsBundle.message((String)"issue.link.link.column", (Object[])new Object[0]);
        this.LINK_COLUMN = (ColumnInfo)new ColumnInfo<IssueNavigationLink, String>(string2){

            public String valueOf(IssueNavigationLink issueNavigationLink) {
                Intrinsics.checkNotNullParameter((Object)issueNavigationLink, (String)"issueNavigationLink");
                String string = issueNavigationLink.getLinkRegexp();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLinkRegexp(...)");
                return string;
            }
        };
    }

    @NotNull
    public DialogPanel createPanel() {
        IssueNavigationConfiguration configuration = IssueNavigationConfiguration.getInstance((Project)this.project);
        List links = new ArrayList();
        ColumnInfo[] columnInfoArray = new ColumnInfo[]{this.ISSUE_COLUMN, this.LINK_COLUMN};
        ListTableModel model = new ListTableModel(columnInfoArray, links, 0);
        JBTable linkTable = new JBTable((TableModel)model);
        linkTable.setShowGrid(false);
        linkTable.getEmptyText().setText(VcsBundle.message((String)"issue.link.no.patterns", (Object[])new Object[0]));
        AnAction[] anActionArray = new AnAction[]{new AddYouTrackLinkAction(linkTable, (ListTableModel<IssueNavigationLink>)model), new AddJiraLinkAction(linkTable, (ListTableModel<IssueNavigationLink>)model), new AddIssueNavigationLinkAction((ListTableModel<IssueNavigationLink>)model)};
        DefaultActionGroup addGroup = new DefaultActionGroup(anActionArray);
        addGroup.getTemplatePresentation().setPopupGroup(true);
        addGroup.getTemplatePresentation().setIcon(AllIcons.General.Add);
        addGroup.getTemplatePresentation().setText(UIBundle.messagePointer((String)"button.text.add.with.ellipsis", (Object[])new Object[0]));
        addGroup.registerCustomShortcutSet(CommonShortcuts.getNewForDialogs(), null);
        String[] stringArray = new String[]{UIBundle.message((String)"button.text.add.with.ellipsis", (Object[])new Object[0]), VcsBundle.message((String)"configurable.issue.link.edit", (Object[])new Object[0]), VcsBundle.message((String)"configurable.issue.link.remove", (Object[])new Object[0])};
        JPanel jPanel = ToolbarDecorator.createDecorator((JTable)((JTable)linkTable)).disableAddAction().addExtraAction((AnAction)addGroup).setRemoveAction(arg_0 -> IssueNavigationConfigurable.createPanel$lambda$0(this, linkTable, model, arg_0)).setEditAction(arg_0 -> IssueNavigationConfigurable.createPanel$lambda$1(this, linkTable, model, arg_0)).setButtonComparator(stringArray).disableUpDownActions().createPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"createPanel(...)");
        JPanel decorator = jPanel;
        return BuilderKt.panel(arg_0 -> IssueNavigationConfigurable.createPanel$lambda$7(decorator, links, configuration, model, arg_0));
    }

    private final void removeLink(JBTable linkTable, ListTableModel<IssueNavigationLink> model) {
        if (Messages.showOkCancelDialog((Project)this.project, (String)VcsBundle.message((String)"issue.link.delete.prompt", (Object[])new Object[0]), (String)VcsBundle.message((String)"issue.link.delete.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) == 0) {
            int selRow = linkTable.getSelectedRow();
            model.removeRow(selRow);
            model.fireTableDataChanged();
            if (linkTable.getRowCount() > 0) {
                if (selRow >= linkTable.getRowCount()) {
                    --selRow;
                }
                linkTable.getSelectionModel().setSelectionInterval(selRow, selRow);
            }
        }
    }

    private final void editLink(JBTable linkTable, ListTableModel<IssueNavigationLink> model) {
        Object object = model.getItem(linkTable.getSelectedRow());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getItem(...)");
        IssueNavigationLink link2 = (IssueNavigationLink)object;
        IssueLinkConfigurationDialog dlg = new IssueLinkConfigurationDialog(this.project);
        dlg.setTitle(VcsBundle.message((String)"issue.link.edit.title", (Object[])new Object[0]));
        dlg.setLink(link2);
        if (dlg.showAndGet()) {
            IssueNavigationLink editedLink = dlg.getLink();
            link2.setIssueRegexp(editedLink.getIssueRegexp());
            String string = editedLink.getLinkRegexp();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLinkRegexp(...)");
            link2.setLinkRegexp(this.addHttpsIfUrlPrefixMissing(string));
            model.fireTableDataChanged();
        }
    }

    private final String addHttpsIfUrlPrefixMissing(String $this$addHttpsIfUrlPrefixMissing) {
        return StringsKt.contains$default((CharSequence)$this$addHttpsIfUrlPrefixMissing, (CharSequence)"://", (boolean)false, (int)2, null) ? $this$addHttpsIfUrlPrefixMissing : "https://" + $this$addHttpsIfUrlPrefixMissing;
    }

    private static final void createPanel$lambda$0(IssueNavigationConfigurable this$0, JBTable $linkTable, ListTableModel $model, AnActionButton it) {
        this$0.removeLink($linkTable, (ListTableModel<IssueNavigationLink>)$model);
    }

    private static final void createPanel$lambda$1(IssueNavigationConfigurable this$0, JBTable $linkTable, ListTableModel $model, AnActionButton it) {
        this$0.editLink($linkTable, (ListTableModel<IssueNavigationLink>)$model);
    }

    private static final Unit createPanel$lambda$7$lambda$2(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Object[] objectArray = new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()};
        String string = VcsBundle.message((String)"settings.issue.navigation.patterns", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Row.text$default((Row)$this$row, (String)string, (int)0, null, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$7$lambda$6$lambda$3(List $links, IssueNavigationConfiguration $configuration, ListTableModel $model) {
        $links.clear();
        for (IssueNavigationLink link2 : $configuration.getLinks()) {
            ((Collection)$links).add(new IssueNavigationLink(link2.getIssueRegexp(), link2.getLinkRegexp()));
        }
        $model.fireTableDataChanged();
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$7$lambda$6$lambda$4(IssueNavigationConfiguration $configuration, List $links) {
        $configuration.setLinks($links);
        return Unit.INSTANCE;
    }

    private static final boolean createPanel$lambda$7$lambda$6$lambda$5(List $links, IssueNavigationConfiguration $configuration) {
        return !Intrinsics.areEqual((Object)$links, (Object)$configuration.getLinks());
    }

    private static final Unit createPanel$lambda$7$lambda$6(JPanel $decorator, List $links, IssueNavigationConfiguration $configuration, ListTableModel $model, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)$decorator).align(Align.FILL).onReset(() -> IssueNavigationConfigurable.createPanel$lambda$7$lambda$6$lambda$3($links, $configuration, $model)).onApply(() -> IssueNavigationConfigurable.createPanel$lambda$7$lambda$6$lambda$4($configuration, $links)).onIsModified(() -> IssueNavigationConfigurable.createPanel$lambda$7$lambda$6$lambda$5($links, $configuration));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$7(JPanel $decorator, List $links, IssueNavigationConfiguration $configuration, ListTableModel $model, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, IssueNavigationConfigurable::createPanel$lambda$7$lambda$2, (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> IssueNavigationConfigurable.createPanel$lambda$7$lambda$6($decorator, $links, $configuration, $model, arg_0), (int)1, null).resizableRow();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lcom/intellij/openapi/vcs/configurable/IssueNavigationConfigurable$AddIssueNavigationLinkAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "model", "Lcom/intellij/util/ui/ListTableModel;", "Lcom/intellij/openapi/vcs/IssueNavigationLink;", "<init>", "(Lcom/intellij/openapi/vcs/configurable/IssueNavigationConfigurable;Lcom/intellij/util/ui/ListTableModel;)V", "getModel", "()Lcom/intellij/util/ui/ListTableModel;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.platform.vcs.impl"})
    private final class AddIssueNavigationLinkAction
    extends DumbAwareAction {
        @NotNull
        private final ListTableModel<IssueNavigationLink> model;

        public AddIssueNavigationLinkAction(ListTableModel<IssueNavigationLink> model) {
            Intrinsics.checkNotNullParameter(model, (String)"model");
            super(VcsBundle.messagePointer((String)"issue.link.add.title", (Object[])new Object[0]));
            this.model = model;
        }

        @NotNull
        public final ListTableModel<IssueNavigationLink> getModel() {
            return this.model;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            IssueLinkConfigurationDialog dlg = new IssueLinkConfigurationDialog(IssueNavigationConfigurable.this.project);
            dlg.setTitle(VcsBundle.message((String)"issue.link.add.title", (Object[])new Object[0]));
            if (dlg.showAndGet()) {
                this.model.addRow((Object)dlg.getLink());
                this.model.fireTableDataChanged();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/vcs/configurable/IssueNavigationConfigurable$AddJiraLinkAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "linkTable", "Lcom/intellij/ui/table/JBTable;", "model", "Lcom/intellij/util/ui/ListTableModel;", "Lcom/intellij/openapi/vcs/IssueNavigationLink;", "<init>", "(Lcom/intellij/openapi/vcs/configurable/IssueNavigationConfigurable;Lcom/intellij/ui/table/JBTable;Lcom/intellij/util/ui/ListTableModel;)V", "getLinkTable", "()Lcom/intellij/ui/table/JBTable;", "getModel", "()Lcom/intellij/util/ui/ListTableModel;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.platform.vcs.impl"})
    private final class AddJiraLinkAction
    extends DumbAwareAction {
        @NotNull
        private final JBTable linkTable;
        @NotNull
        private final ListTableModel<IssueNavigationLink> model;

        public AddJiraLinkAction(@NotNull JBTable linkTable, ListTableModel<IssueNavigationLink> model) {
            Intrinsics.checkNotNullParameter((Object)linkTable, (String)"linkTable");
            Intrinsics.checkNotNullParameter(model, (String)"model");
            super(VcsBundle.messagePointer((String)"action.AnActionButton.text.add.jira.pattern", (Object[])new Object[0]));
            this.linkTable = linkTable;
            this.model = model;
        }

        @NotNull
        public final JBTable getLinkTable() {
            return this.linkTable;
        }

        @NotNull
        public final ListTableModel<IssueNavigationLink> getModel() {
            return this.model;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            String string = Messages.showInputDialog((Component)((Component)this.linkTable), (String)VcsBundle.message((String)"issue.action.enter.jira.installation.url.label", (Object[])new Object[0]), (String)VcsBundle.message((String)"issue.action.add.jira.issue.navigation.pattern.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
            if (string == null) {
                return;
            }
            Object s = string;
            if (!StringsKt.endsWith$default((String)s, (String)"/", (boolean)false, (int)2, null)) {
                s = (String)s + "/";
            }
            s = IssueNavigationConfigurable.this.addHttpsIfUrlPrefixMissing((String)s);
            this.model.addRow((Object)new IssueNavigationLink("[A-Z]+\\-\\d+", (String)s + "browse/$0"));
            this.model.fireTableDataChanged();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/vcs/configurable/IssueNavigationConfigurable$AddYouTrackLinkAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "linkTable", "Lcom/intellij/ui/table/JBTable;", "model", "Lcom/intellij/util/ui/ListTableModel;", "Lcom/intellij/openapi/vcs/IssueNavigationLink;", "<init>", "(Lcom/intellij/openapi/vcs/configurable/IssueNavigationConfigurable;Lcom/intellij/ui/table/JBTable;Lcom/intellij/util/ui/ListTableModel;)V", "getLinkTable", "()Lcom/intellij/ui/table/JBTable;", "getModel", "()Lcom/intellij/util/ui/ListTableModel;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.platform.vcs.impl"})
    private final class AddYouTrackLinkAction
    extends DumbAwareAction {
        @NotNull
        private final JBTable linkTable;
        @NotNull
        private final ListTableModel<IssueNavigationLink> model;

        public AddYouTrackLinkAction(@NotNull JBTable linkTable, ListTableModel<IssueNavigationLink> model) {
            Intrinsics.checkNotNullParameter((Object)linkTable, (String)"linkTable");
            Intrinsics.checkNotNullParameter(model, (String)"model");
            super(VcsBundle.messagePointer((String)"action.AnActionButton.text.add.youtrack.pattern", (Object[])new Object[0]));
            this.linkTable = linkTable;
            this.model = model;
        }

        @NotNull
        public final JBTable getLinkTable() {
            return this.linkTable;
        }

        @NotNull
        public final ListTableModel<IssueNavigationLink> getModel() {
            return this.model;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            String string = Messages.showInputDialog((Component)((Component)this.linkTable), (String)VcsBundle.message((String)"issue.action.enter.youtrack.installation.url.label", (Object[])new Object[0]), (String)VcsBundle.message((String)"issue.action.add.youtrack.issue.navigation.pattern.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
            if (string == null) {
                return;
            }
            Object s = string;
            if (!StringsKt.endsWith$default((String)s, (String)"/", (boolean)false, (int)2, null)) {
                s = (String)s + "/";
            }
            s = IssueNavigationConfigurable.this.addHttpsIfUrlPrefixMissing((String)s);
            this.model.addRow((Object)new IssueNavigationLink("[A-Z]+\\-\\d+", (String)s + "issue/$0"));
            this.model.fireTableDataChanged();
        }
    }
}

