/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.impl.DiffEditorViewer;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.changes.ChangesViewDiffPreviewHandler;
import com.intellij.openapi.vcs.changes.actions.diff.lst.LocalChangeListDiffTool;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.TreeHandlerChangesTreeTracker;
import com.intellij.openapi.vcs.changes.ui.TreeHandlerDiffRequestProcessor;
import com.intellij.openapi.vcs.impl.LineStatusTrackerSettingListener;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0010B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u000b\u001a\u00020\u0005H\u0016J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005J\b\u0010\u000f\u001a\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/vcs/changes/ChangesViewDiffPreviewProcessor;", "Lcom/intellij/openapi/vcs/changes/ui/TreeHandlerDiffRequestProcessor;", "changesView", "Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;", "isInEditor", "", "<init>", "(Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;Z)V", "shouldAddToolbarBottomBorder", "toolbarComponents", "Lcom/intellij/diff/FrameDiffTool$ToolbarComponents;", "forceKeepCurrentFileWhileFocused", "setAllowExcludeFromCommit", "", "value", "fireDiffSettingsChanged", "MyLineStatusTrackerSettingsListener", "intellij.platform.vcs.impl"})
@ApiStatus.Internal
public final class ChangesViewDiffPreviewProcessor
extends TreeHandlerDiffRequestProcessor {
    private final boolean isInEditor;

    public ChangesViewDiffPreviewProcessor(@NotNull ChangesTree changesView, boolean isInEditor) {
        Intrinsics.checkNotNullParameter((Object)((Object)changesView), (String)"changesView");
        super(isInEditor ? "Default" : "ChangesView", changesView, ChangesViewDiffPreviewHandler.INSTANCE);
        this.isInEditor = isInEditor;
        this.putContextUserData(DiffUserDataKeysEx.LAST_REVISION_WITH_LOCAL, true);
        MessageBusConnection busConnection = this.getProject().getMessageBus().connect((Disposable)this);
        Topic topic = LineStatusTrackerSettingListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        busConnection.subscribe(topic, (Object)new MyLineStatusTrackerSettingsListener());
        new TreeHandlerChangesTreeTracker(this.getTree(), (DiffEditorViewer)this, this.getHandler(), false, 8, null).track();
    }

    protected boolean shouldAddToolbarBottomBorder(@NotNull FrameDiffTool.ToolbarComponents toolbarComponents) {
        Intrinsics.checkNotNullParameter((Object)toolbarComponents, (String)"toolbarComponents");
        return !this.isInEditor || super.shouldAddToolbarBottomBorder(toolbarComponents);
    }

    @Override
    public boolean forceKeepCurrentFileWhileFocused() {
        return true;
    }

    public final void setAllowExcludeFromCommit(boolean value) {
        UserDataHolder[] userDataHolderArray = new UserDataHolder[]{this.getContext()};
        if (DiffUtil.isUserDataFlagSet(LocalChangeListDiffTool.ALLOW_EXCLUDE_FROM_COMMIT, (UserDataHolder[])userDataHolderArray) == value) {
            return;
        }
        this.getContext().putUserData(LocalChangeListDiffTool.ALLOW_EXCLUDE_FROM_COMMIT, (Object)value);
        this.fireDiffSettingsChanged();
    }

    private final void fireDiffSettingsChanged() {
        this.dropCaches();
        this.updateRequest(true);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/vcs/changes/ChangesViewDiffPreviewProcessor$MyLineStatusTrackerSettingsListener;", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerSettingListener;", "<init>", "(Lcom/intellij/openapi/vcs/changes/ChangesViewDiffPreviewProcessor;)V", "settingsUpdated", "", "intellij.platform.vcs.impl"})
    private final class MyLineStatusTrackerSettingsListener
    implements LineStatusTrackerSettingListener {
        public void settingsUpdated() {
            ChangesViewDiffPreviewProcessor.this.fireDiffSettingsChanged();
        }
    }
}

