/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.fixture;

import org.assertj.core.util.Preconditions;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.swing.core.MouseButton;
import org.assertj.swing.core.MouseClickInfo;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.fixture.ItemFixture;
import org.assertj.swing.fixture.JListFixture;
import org.assertj.swing.fixture.JPopupMenuFixture;

public class JListItemFixture
implements ItemFixture<JListItemFixture> {
    private final JListFixture list;
    private final int index;

    public JListItemFixture(@Nonnull JListFixture list, int index) {
        this.list = (JListFixture)Preconditions.checkNotNull((Object)list);
        this.index = index;
    }

    @Override
    @Nonnull
    public final JListItemFixture select() {
        this.list.selectItem(this.index);
        return this;
    }

    @Nonnull
    public final JListItemFixture unselect() {
        this.list.unselectItem(this.index);
        return this;
    }

    @Override
    @Nonnull
    public final JListItemFixture click() {
        this.list.clickItem(this.index);
        return this;
    }

    @Override
    @Nonnull
    public final JListItemFixture click(@Nonnull MouseButton button) {
        this.list.clickItem(this.index, button, 1);
        return this;
    }

    @Override
    @Nonnull
    public final JListItemFixture click(@Nonnull MouseClickInfo mouseClickInfo) {
        this.list.clickItem(this.index, mouseClickInfo.button(), mouseClickInfo.times());
        return this;
    }

    @Override
    @Nonnull
    public final JListItemFixture doubleClick() {
        this.list.clickItem(this.index, MouseButton.LEFT_BUTTON, 2);
        return this;
    }

    @Override
    @Nonnull
    public final JListItemFixture rightClick() {
        this.list.clickItem(this.index, MouseButton.RIGHT_BUTTON, 1);
        return this;
    }

    @Override
    @Nonnull
    public final JPopupMenuFixture showPopupMenu() {
        return this.list.showPopupMenuAt(this.index);
    }

    @Override
    @Nullable
    public final String value() {
        return this.list.valueAt(this.index);
    }

    @Override
    @Nonnull
    public final JListItemFixture drag() {
        this.list.drag(this.index);
        return this;
    }

    @Override
    @Nonnull
    public final JListItemFixture drop() {
        this.list.drop(this.index);
        return this;
    }

    public final int index() {
        return this.index;
    }

    @Nonnull
    @VisibleForTesting
    JListFixture listFixture() {
        return this.list;
    }
}

