/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.requirement.PyRequirementVisitor;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/python/inspections/PyPackageRequirementsInspection;", "Lcom/jetbrains/python/inspections/PyInspection;", "<init>", "()V", "ignoredPackages", "", "", "getIgnoredPackages", "()Ljava/util/List;", "setIgnoredPackages", "(Ljava/util/List;)V", "getOptionsPane", "Lcom/intellij/codeInspection/options/OptPane;", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "isPythonInTemplateLanguages", "psiFile", "Lcom/intellij/psi/PsiFile;", "Companion", "intellij.python.community.impl"})
public final class PyPackageRequirementsInspection
extends PyInspection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private List<String> ignoredPackages = new ArrayList();
    @NotNull
    private static final String IGNORED_PACKAGES = "INSP.requirements.ignore.packages.label";

    @NotNull
    public final List<String> getIgnoredPackages() {
        return this.ignoredPackages;
    }

    public final void setIgnoredPackages(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.ignoredPackages = list;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptRegularComponent[] optRegularComponentArray = new OptRegularComponent[]{OptPane.stringList((String)"ignoredPackages", (String)PyPsiBundle.message(IGNORED_PACKAGES, new Object[0]))};
        OptPane optPane = OptPane.pane((OptRegularComponent[])optRegularComponentArray);
        Intrinsics.checkNotNullExpressionValue((Object)optPane, (String)"pane(...)");
        return optPane;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        PsiElementVisitor psiElementVisitor;
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        if (!(holder.getFile() instanceof PyFile)) {
            PsiFile psiFile = holder.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
            if (!this.isPythonInTemplateLanguages(psiFile)) {
                PsiElementVisitor psiElementVisitor2 = PsiElementVisitor.EMPTY_VISITOR;
                Intrinsics.checkNotNull((Object)psiElementVisitor2);
                psiElementVisitor = psiElementVisitor2;
                return psiElementVisitor;
            }
        }
        Collection collection = this.ignoredPackages;
        TypeEvalContext typeEvalContext = PyInspectionVisitor.getContext(session);
        Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"getContext(...)");
        psiElementVisitor = new PyRequirementVisitor(holder, collection, typeEvalContext);
        return psiElementVisitor;
    }

    private final boolean isPythonInTemplateLanguages(PsiFile psiFile) {
        return StreamEx.of((Collection)psiFile.getViewProvider().getLanguages()).findFirst(arg_0 -> PyPackageRequirementsInspection.isPythonInTemplateLanguages$lambda$1(PyPackageRequirementsInspection::isPythonInTemplateLanguages$lambda$0, arg_0)).isPresent();
    }

    private static final boolean isPythonInTemplateLanguages$lambda$0(Language it) {
        return it.isKindOf((Language)PythonLanguage.getInstance());
    }

    private static final boolean isPythonInTemplateLanguages$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/python/inspections/PyPackageRequirementsInspection$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/python/inspections/PyPackageRequirementsInspection;", "element", "Lcom/intellij/psi/PsiElement;", "IGNORED_PACKAGES", "", "intellij.python.community.impl"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final PyPackageRequirementsInspection getInstance(@NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            InspectionProfileImpl inspectionProfileImpl = InspectionProjectProfileManager.getInstance((Project)element.getProject()).getCurrentProfile();
            Intrinsics.checkNotNullExpressionValue((Object)inspectionProfileImpl, (String)"getCurrentProfile(...)");
            InspectionProfileImpl inspectionProfile = inspectionProfileImpl;
            String toolName = PyPackageRequirementsInspection.class.getSimpleName();
            return (PyPackageRequirementsInspection)inspectionProfile.getUnwrappedTool(toolName, element);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

