/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.PathUtil;
import com.jetbrains.python.psi.PyStringLiteralCoreUtil;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PythonStringUtil {
    private PythonStringUtil() {
    }

    @NotNull
    public static String removeFirstPrefix(@Nullable String s, String separator) {
        int pos;
        if (s != null && (pos = s.indexOf(separator)) != -1) {
            String string = s.substring(pos + separator.length());
            if (string == null) {
                PythonStringUtil.$$$reportNull$$$0(0);
            }
            return string;
        }
        return "";
    }

    @NotNull
    public static String removeLastSuffix(@Nullable String s, String separator) {
        int pos;
        if (s != null && (pos = s.lastIndexOf(separator)) != -1) {
            String string = s.substring(0, pos);
            if (string == null) {
                PythonStringUtil.$$$reportNull$$$0(1);
            }
            return string;
        }
        return "";
    }

    public static boolean isPath(@Nullable String s) {
        if (!StringUtil.isEmpty((String)s)) {
            s = Objects.requireNonNull(s);
            s = FileUtil.toSystemIndependentName((String)s);
            List components = StringUtil.split((String)s, (String)"/");
            for (String name2 : components) {
                if (Strings.areSameInstance((String)name2, (String)((String)components.get(0))) && SystemInfo.isWindows && name2.endsWith(":") || PathUtil.isValidFileName((String)name2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @NotNull
    public static String getFirstPrefix(String s, String separator) {
        int pos;
        if (s != null && (pos = s.indexOf(separator)) != -1) {
            String string = s.substring(0, pos);
            if (string == null) {
                PythonStringUtil.$$$reportNull$$$0(2);
            }
            return string;
        }
        return s != null ? s : "";
    }

    public static String getLastSuffix(String s, String separator) {
        int pos;
        if (s != null && (pos = s.lastIndexOf(separator)) != -1) {
            return s.substring(pos + 1);
        }
        return "";
    }

    public static String replaceLastSuffix(String s, String separator, String newElementName) {
        Pair quotes = null;
        if (PyStringLiteralCoreUtil.isQuoted((String)s)) {
            quotes = PyStringLiteralCoreUtil.getQuotes((String)s);
            s = PyStringLiteralCoreUtil.stripQuotesAroundValue((String)s);
        }
        if (!((String)(s = PythonStringUtil.removeLastSuffix((String)s, separator))).isEmpty()) {
            s = (String)s + separator;
        }
        s = (String)s + newElementName;
        if (quotes != null) {
            s = (String)quotes.first + (String)s + (String)quotes.second;
        }
        return s;
    }

    public static TextRange lastSuffixTextRange(@NotNull String text, String separator) {
        if (text == null) {
            PythonStringUtil.$$$reportNull$$$0(3);
        }
        int offset = text.lastIndexOf(separator) + 1;
        int length = text.length() - offset;
        return TextRange.from((int)(offset + 1), (int)length);
    }

    @Nullable
    public static String intersect(String fullName, String elementStringValue) {
        QualifiedName fullQName = QualifiedName.fromDottedString((String)fullName);
        QualifiedName stringQName = QualifiedName.fromDottedString((String)elementStringValue);
        String[] s1 = stringQName.getComponents().toArray(new String[stringQName.getComponentCount()]);
        String[] s2 = fullQName.getComponents().toArray(new String[fullQName.getComponentCount()]);
        for (int i = s1.length - 1; i >= 0; --i) {
            boolean flag = true;
            if (i > s2.length - 1) continue;
            for (int j = 0; j <= i; ++j) {
                if (s1[i - j].equals(s2[s2.length - j - 1])) continue;
                flag = false;
                break;
            }
            if (!flag) continue;
            StringBuilder res = new StringBuilder();
            for (int j = 0; j <= i; ++j) {
                if (j > 0) {
                    res.append(".");
                }
                res.append(s1[j]);
            }
            return res.toString();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/PythonStringUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "removeFirstPrefix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "removeLastSuffix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirstPrefix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/PythonStringUtil";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "lastSuffixTextRange";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3 -> new IllegalArgumentException(string);
        };
    }
}

