/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python;

import com.intellij.codeInsight.folding.CodeFoldingSettings;
import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonFoldingSettings;
import com.jetbrains.python.ast.PyAstAnnotation;
import com.jetbrains.python.ast.PyAstExpression;
import com.jetbrains.python.ast.PyAstFile;
import com.jetbrains.python.ast.PyAstFromImportStatement;
import com.jetbrains.python.ast.PyAstImportStatementBase;
import com.jetbrains.python.ast.PyAstStatementList;
import com.jetbrains.python.ast.PyAstStringElement;
import com.jetbrains.python.ast.PyAstStringLiteralExpression;
import com.jetbrains.python.psi.PyStringLiteralCoreUtil;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 22\u00020\u00012\u00020\u0002:\u00012B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J0\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J \u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\bH\u0002J \u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\bH\u0002J \u0010\u001e\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\bH\u0002J \u0010\u001f\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\bH\u0002J2\u0010 \u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b2\u0006\u0010!\u001a\u00020\u00152\b\u0010\"\u001a\u0004\u0018\u00010\u0013H\u0002J \u0010#\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\bH\u0002J\u0018\u0010$\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020\u00132\u0006\u0010&\u001a\u00020\u001bH\u0014J \u0010'\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\bH\u0002J\u0012\u0010(\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0010\u0010)\u001a\u00020\u00112\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u0010,\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0012\u0010-\u001a\u00020\u000f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0014J\u0012\u0010.\u001a\u00020\u000f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0014J$\u0010/\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\n\b\u0002\u00100\u001a\u0004\u0018\u000101H\u0014\u00a8\u00063"}, d2={"Lcom/jetbrains/python/PythonFoldingBuilder;", "Lcom/intellij/lang/folding/CustomFoldingBuilder;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "buildLanguageFoldRegions", "", "descriptors", "", "Lcom/intellij/lang/folding/FoldingDescriptor;", "root", "Lcom/intellij/psi/PsiElement;", "document", "Lcom/intellij/openapi/editor/Document;", "quick", "", "getLanguagePlaceholderText", "", "node", "Lcom/intellij/lang/ASTNode;", "range", "Lcom/intellij/openapi/util/TextRange;", "isRegionCollapsedByDefault", "isCustomFoldingCandidate", "isCustomFoldingRoot", "isLanguageSpecificFoldableBlock", "elementType", "Lcom/intellij/psi/tree/IElementType;", "appendDescriptors", "foldSequentialComments", "foldCollectionLiteral", "foldMatchStatement", "foldSegment", "nodeRange", "colon", "foldStatementList", "checkFoldBlocks", "statementList", "parentType", "foldLongStrings", "getDocStringOwnerType", "getLanguagePlaceholderForString", "stringLiteralExpression", "Lcom/jetbrains/python/ast/PyAstStringLiteralExpression;", "isImport", "isFunction", "isClass", "foldingDescriptor", "group", "Lcom/intellij/openapi/editor/FoldingGroup;", "Companion", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nPythonFoldingBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PythonFoldingBuilder.kt\ncom/jetbrains/python/PythonFoldingBuilder\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,312:1\n106#2:313\n78#2,22:314\n106#2:336\n78#2,22:337\n106#2:359\n78#2,22:360\n967#3,7:382\n*S KotlinDebug\n*F\n+ 1 PythonFoldingBuilder.kt\ncom/jetbrains/python/PythonFoldingBuilder\n*L\n40#1:313\n40#1:314,22\n42#1:336\n42#1:337,22\n43#1:359\n43#1:360,22\n104#1:382,7\n*E\n"})
public class PythonFoldingBuilder
extends CustomFoldingBuilder
implements DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final TokenSet FOLDABLE_COLLECTIONS_LITERALS;
    @NotNull
    public static final String PYTHON_TYPE_ANNOTATION_GROUP_NAME = "Python type annotation";

    protected void buildLanguageFoldRegions(@NotNull List<FoldingDescriptor> descriptors, @NotNull PsiElement root, @NotNull Document document, boolean quick) {
        Intrinsics.checkNotNullParameter(descriptors, (String)"descriptors");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        ASTNode aSTNode = root.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"getNode(...)");
        this.appendDescriptors(aSTNode, descriptors);
    }

    @NotNull
    protected String getLanguagePlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        if (this.isImport(node)) {
            return "import ...";
        }
        if (node.getElementType() == PyElementTypes.STRING_LITERAL_EXPRESSION) {
            PsiElement psiElement = node.getPsi();
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.jetbrains.python.ast.PyAstStringLiteralExpression");
            PyAstStringLiteralExpression stringLiteralExpression = (PyAstStringLiteralExpression)psiElement;
            String string = ((PyAstStringElement)stringLiteralExpression.getStringElements().get(0)).getPrefix();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPrefix(...)");
            String prefix = string;
            if (stringLiteralExpression.isDocString()) {
                String stringValue;
                String[] lines;
                String string2 = stringLiteralExpression.getStringValue();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getStringValue(...)");
                String $this$trim$iv = string2;
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = $this$trim$iv;
                boolean $i$f$trim2 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                if ((lines = LineTokenizer.Companion.tokenize$default((LineTokenizer.Companion)LineTokenizer.Companion, (CharSequence)(stringValue = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()), (boolean)true, (boolean)false, (int)4, null)).length > 2) {
                    boolean match$iv$iv;
                    char it;
                    int index$iv$iv;
                    String $this$trim$iv2 = lines[1];
                    boolean $i$f$trim3 = false;
                    CharSequence $this$trim$iv$iv2 = $this$trim$iv2;
                    boolean $i$f$trim4 = false;
                    int startIndex$iv$iv2 = 0;
                    int endIndex$iv$iv2 = $this$trim$iv$iv2.length() - 1;
                    boolean startFound$iv$iv2 = false;
                    while (startIndex$iv$iv2 <= endIndex$iv$iv2) {
                        index$iv$iv = !startFound$iv$iv2 ? startIndex$iv$iv2 : endIndex$iv$iv2;
                        it = $this$trim$iv$iv2.charAt(index$iv$iv);
                        boolean bl = false;
                        boolean bl3 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                        if (!startFound$iv$iv2) {
                            if (!match$iv$iv) {
                                startFound$iv$iv2 = true;
                                continue;
                            }
                            ++startIndex$iv$iv2;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv2;
                    }
                    if (((CharSequence)((Object)$this$trim$iv$iv2.subSequence(startIndex$iv$iv2, endIndex$iv$iv2 + 1)).toString()).length() == 0) {
                        $this$trim$iv2 = lines[0];
                        String string3 = prefix;
                        $i$f$trim3 = false;
                        $this$trim$iv$iv2 = $this$trim$iv2;
                        $i$f$trim4 = false;
                        startIndex$iv$iv2 = 0;
                        endIndex$iv$iv2 = $this$trim$iv$iv2.length() - 1;
                        startFound$iv$iv2 = false;
                        while (startIndex$iv$iv2 <= endIndex$iv$iv2) {
                            index$iv$iv = !startFound$iv$iv2 ? startIndex$iv$iv2 : endIndex$iv$iv2;
                            it = $this$trim$iv$iv2.charAt(index$iv$iv);
                            boolean bl = false;
                            boolean bl4 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                            if (!startFound$iv$iv2) {
                                if (!match$iv$iv) {
                                    startFound$iv$iv2 = true;
                                    continue;
                                }
                                ++startIndex$iv$iv2;
                                continue;
                            }
                            if (!match$iv$iv) break;
                            --endIndex$iv$iv2;
                        }
                        return string3 + "\"\"\"" + ((Object)$this$trim$iv$iv2.subSequence(startIndex$iv$iv2, endIndex$iv$iv2 + 1)).toString() + "...\"\"\"";
                    }
                }
                return prefix + "\"\"\"...\"\"\"";
            }
            return prefix + this.getLanguagePlaceholderForString(stringLiteralExpression);
        }
        return "...";
    }

    protected boolean isRegionCollapsedByDefault(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (this.isImport(node)) {
            return CodeFoldingSettings.getInstance().COLLAPSE_IMPORTS;
        }
        IElementType iElementType = node.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
        IElementType elementType = iElementType;
        if (elementType == PyElementTypes.STRING_LITERAL_EXPRESSION) {
            IElementType docStringOwnerType = this.getDocStringOwnerType(node);
            if (this.isFunction(docStringOwnerType) && CodeFoldingSettings.getInstance().COLLAPSE_METHODS) {
                return false;
            }
            if (docStringOwnerType != null) {
                return CodeFoldingSettings.getInstance().COLLAPSE_DOC_COMMENTS;
            }
            return PythonFoldingSettings.getInstance().isCollapseLongStrings();
        }
        if (elementType == PyTokenTypes.END_OF_LINE_COMMENT) {
            return PythonFoldingSettings.getInstance().isCollapseSequentialComments();
        }
        if (elementType == PyElementTypes.ANNOTATION) {
            return PythonFoldingSettings.getInstance().isCollapseTypeAnnotations();
        }
        if (elementType == PyElementTypes.STATEMENT_LIST && this.isFunction(node.getTreeParent().getElementType())) {
            return CodeFoldingSettings.getInstance().COLLAPSE_METHODS;
        }
        if (FOLDABLE_COLLECTIONS_LITERALS.contains(elementType)) {
            return PythonFoldingSettings.getInstance().isCollapseLongCollections();
        }
        if (this.isLanguageSpecificFoldableBlock(elementType)) {
            return CodeFoldingSettings.getInstance().COLLAPSE_METHODS;
        }
        return false;
    }

    protected boolean isCustomFoldingCandidate(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return node.getElementType() == PyTokenTypes.END_OF_LINE_COMMENT;
    }

    protected boolean isCustomFoldingRoot(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return node.getPsi() instanceof PyAstFile || node.getElementType() == PyElementTypes.STATEMENT_LIST;
    }

    protected boolean isLanguageSpecificFoldableBlock(@NotNull IElementType elementType) {
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        return false;
    }

    private final void appendDescriptors(ASTNode node, List<FoldingDescriptor> descriptors) {
        TextRange nodeRange;
        IElementType iElementType = node.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
        IElementType elementType = iElementType;
        if (node.getPsi() instanceof PyAstFile) {
            PsiElement psiElement = node.getPsi();
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.jetbrains.python.ast.PyAstFile");
            List imports = ((PyAstFile)psiElement).getImportBlock();
            Intrinsics.checkNotNull((Object)imports);
            Iterable $this$takeWhile$iv = imports;
            boolean $i$f$takeWhile = false;
            ArrayList list$iv = new ArrayList();
            for (Object item$iv : $this$takeWhile$iv) {
                PyAstImportStatementBase it = (PyAstImportStatementBase)item$iv;
                boolean bl = false;
                PyAstFromImportStatement pyAstFromImportStatement = it instanceof PyAstFromImportStatement ? (PyAstFromImportStatement)it : null;
                boolean bl2 = pyAstFromImportStatement != null ? pyAstFromImportStatement.isFromFuture() : false;
                if (!bl2) break;
                list$iv.add(item$iv);
            }
            int firstIndex = ((List)list$iv).size();
            if (imports.size() - firstIndex > 1) {
                PyAstImportStatementBase firstImport = (PyAstImportStatementBase)imports.get(firstIndex);
                Object object = CollectionsKt.last((List)imports);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"last(...)");
                PyAstImportStatementBase lastImport = (PyAstImportStatementBase)object;
                ASTNode aSTNode = firstImport.getNode();
                Intrinsics.checkNotNull((Object)aSTNode);
                descriptors.add(PythonFoldingBuilder.foldingDescriptor$default(this, aSTNode, new TextRange(firstImport.getTextRange().getStartOffset(), lastImport.getTextRange().getEndOffset()), null, 4, null));
            }
        } else if (elementType == PyElementTypes.MATCH_STATEMENT) {
            this.foldMatchStatement(node, descriptors);
        } else if (elementType == PyElementTypes.STATEMENT_LIST) {
            this.foldStatementList(node, descriptors);
        } else if (elementType == PyElementTypes.STRING_LITERAL_EXPRESSION) {
            this.foldLongStrings(node, descriptors);
        } else if (FOLDABLE_COLLECTIONS_LITERALS.contains(elementType)) {
            this.foldCollectionLiteral(node, descriptors);
        } else if (elementType == PyTokenTypes.END_OF_LINE_COMMENT) {
            this.foldSequentialComments(node, descriptors);
        } else if (elementType == PyElementTypes.ANNOTATION) {
            PsiElement annotation = node.getPsi();
            if (annotation instanceof PyAstAnnotation && ((PyAstAnnotation)annotation).getValue() != null) {
                PyAstExpression pyAstExpression = ((PyAstAnnotation)annotation).getValue();
                Intrinsics.checkNotNull((Object)pyAstExpression);
                TextRange textRange = pyAstExpression.getTextRange();
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
                descriptors.add(this.foldingDescriptor(node, textRange, FoldingGroup.newGroup((String)PYTHON_TYPE_ANNOTATION_GROUP_NAME)));
            }
        } else if (this.isLanguageSpecificFoldableBlock(elementType) && !(nodeRange = node.getTextRange()).isEmpty()) {
            ASTNode colon = node.findChildByType((IElementType)PyTokenTypes.COLON);
            Intrinsics.checkNotNull((Object)nodeRange);
            this.foldSegment(node, descriptors, nodeRange, colon);
        }
        for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            this.appendDescriptors(child, descriptors);
        }
    }

    private final void foldSequentialComments(ASTNode node, List<FoldingDescriptor> descriptors) {
        if (CustomFoldingBuilder.isCustomRegionElement((PsiElement)node.getPsi())) {
            return;
        }
        ASTNode curNode = node.getTreePrev();
        while (curNode != null) {
            if (curNode.getElementType() == PyTokenTypes.END_OF_LINE_COMMENT) {
                if (CustomFoldingBuilder.isCustomRegionElement((PsiElement)curNode.getPsi())) break;
                return;
            }
            curNode = curNode.getPsi() instanceof PsiWhiteSpace ? curNode.getTreePrev() : null;
        }
        curNode = node.getTreeNext();
        ASTNode lastCommentNode = node;
        while (curNode != null) {
            if (curNode.getElementType() == PyTokenTypes.END_OF_LINE_COMMENT) {
                if (CustomFoldingBuilder.isCustomRegionElement((PsiElement)curNode.getPsi())) break;
                lastCommentNode = curNode;
                curNode = curNode.getTreeNext();
                continue;
            }
            curNode = curNode.getPsi() instanceof PsiWhiteSpace ? curNode.getTreeNext() : null;
        }
        if (lastCommentNode != node) {
            int n = node.getStartOffset();
            ASTNode aSTNode = lastCommentNode;
            Intrinsics.checkNotNull((Object)aSTNode);
            TextRange textRange = TextRange.create((int)n, (int)aSTNode.getTextRange().getEndOffset());
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"create(...)");
            descriptors.add(PythonFoldingBuilder.foldingDescriptor$default(this, node, textRange, null, 4, null));
        }
    }

    private final void foldCollectionLiteral(ASTNode node, List<FoldingDescriptor> descriptors) {
        if (StringUtil.countNewLines((CharSequence)node.getChars()) > 0) {
            TextRange range = node.getTextRange();
            int delta = node.getElementType() == PyElementTypes.TUPLE_EXPRESSION ? 0 : 1;
            TextRange textRange = TextRange.create((int)(range.getStartOffset() + delta), (int)(range.getEndOffset() - delta));
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"create(...)");
            descriptors.add(PythonFoldingBuilder.foldingDescriptor$default(this, node, textRange, null, 4, null));
        }
    }

    private final void foldMatchStatement(ASTNode node, List<FoldingDescriptor> descriptors) {
        TextRange nodeRange = node.getTextRange();
        if (nodeRange.isEmpty()) {
            return;
        }
        IElementType iElementType = node.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
        IElementType elType = iElementType;
        if (elType == PyElementTypes.MATCH_STATEMENT) {
            ASTNode colon = node.findChildByType((IElementType)PyTokenTypes.COLON);
            Intrinsics.checkNotNull((Object)nodeRange);
            this.foldSegment(node, descriptors, nodeRange, colon);
        }
    }

    private final void foldSegment(ASTNode node, List<FoldingDescriptor> descriptors, TextRange nodeRange, ASTNode colon) {
        int nodeEnd = nodeRange.getEndOffset();
        if (colon != null && nodeEnd - (colon.getStartOffset() + 1) > 1) {
            int foldEnd;
            CharSequence charSequence = node.getChars();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getChars(...)");
            CharSequence chars = charSequence;
            int nodeStart = nodeRange.getStartOffset();
            int foldStart = colon.getStartOffset() + 1;
            for (foldEnd = nodeEnd; foldEnd > Math.max(nodeStart, foldStart + 1) && Character.isWhitespace(chars.charAt(foldEnd - nodeStart - 1)); --foldEnd) {
            }
            descriptors.add(PythonFoldingBuilder.foldingDescriptor$default(this, node, new TextRange(foldStart, foldEnd), null, 4, null));
        } else if (nodeRange.getLength() > 1) {
            descriptors.add(PythonFoldingBuilder.foldingDescriptor$default(this, node, nodeRange, null, 4, null));
        }
    }

    private final void foldStatementList(ASTNode node, List<FoldingDescriptor> descriptors) {
        TextRange nodeRange = node.getTextRange();
        if (nodeRange.isEmpty()) {
            return;
        }
        IElementType iElementType = node.getTreeParent().getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
        IElementType parentType = iElementType;
        if (this.isFunction(parentType) || this.isClass(parentType) || this.checkFoldBlocks(node, parentType)) {
            ASTNode colon = node.getTreeParent().findChildByType((IElementType)PyTokenTypes.COLON);
            Intrinsics.checkNotNull((Object)nodeRange);
            this.foldSegment(node, descriptors, nodeRange, colon);
        }
    }

    protected boolean checkFoldBlocks(@NotNull ASTNode statementList, @NotNull IElementType parentType) {
        Intrinsics.checkNotNullParameter((Object)statementList, (String)"statementList");
        Intrinsics.checkNotNullParameter((Object)parentType, (String)"parentType");
        PsiElement element = statementList.getPsi();
        boolean bl = element instanceof PyAstStatementList;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        return PyElementTypes.PARTS.contains(parentType) || parentType == PyElementTypes.WITH_STATEMENT || parentType == PyElementTypes.CASE_CLAUSE;
    }

    private final void foldLongStrings(ASTNode node, List<FoldingDescriptor> descriptors) {
        boolean shouldFoldString;
        boolean shouldFoldDocString = this.getDocStringOwnerType(node) != null && StringUtil.countNewLines((CharSequence)node.getChars()) > 1;
        boolean bl = shouldFoldString = this.getDocStringOwnerType(node) == null && StringUtil.countNewLines((CharSequence)node.getChars()) > 0;
        if (shouldFoldDocString || shouldFoldString) {
            TextRange textRange = node.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
            descriptors.add(PythonFoldingBuilder.foldingDescriptor$default(this, node, textRange, null, 4, null));
        }
    }

    @Nullable
    protected IElementType getDocStringOwnerType(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        ASTNode treeParent = node.getTreeParent();
        IElementType iElementType = treeParent.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
        IElementType parentType = iElementType;
        if (parentType == PyElementTypes.EXPRESSION_STATEMENT && treeParent.getTreeParent() != null) {
            ASTNode parent2 = treeParent.getTreeParent();
            if (parent2.getElementType() == PyElementTypes.STATEMENT_LIST && parent2.getTreeParent() != null && treeParent == parent2.getFirstChildNode()) {
                IElementType iElementType2 = parent2.getTreeParent().getElementType();
                Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"getElementType(...)");
                IElementType parent3 = iElementType2;
                if (this.isFunction(parent3) || this.isClass(parent3)) {
                    return parent3;
                }
            } else if (parent2 instanceof PyAstFile) {
                return parent2.getElementType();
            }
        }
        return null;
    }

    private final String getLanguagePlaceholderForString(PyAstStringLiteralExpression stringLiteralExpression) {
        String stringText = stringLiteralExpression.getText();
        Pair quotes = PyStringLiteralCoreUtil.getQuotes((String)stringText);
        if (quotes != null) {
            return quotes.second + "..." + quotes.second;
        }
        return "...";
    }

    protected boolean isImport(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return PyElementTypes.IMPORT_STATEMENTS.contains(node.getElementType());
    }

    protected boolean isFunction(@Nullable IElementType elementType) {
        return elementType == PyElementTypes.FUNCTION_DECLARATION;
    }

    protected boolean isClass(@Nullable IElementType elementType) {
        return elementType == PyElementTypes.CLASS_DECLARATION;
    }

    @NotNull
    protected FoldingDescriptor foldingDescriptor(@NotNull ASTNode node, @NotNull TextRange range, @Nullable FoldingGroup group2) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return new FoldingDescriptor(node, range, group2);
    }

    public static /* synthetic */ FoldingDescriptor foldingDescriptor$default(PythonFoldingBuilder pythonFoldingBuilder, ASTNode aSTNode, TextRange textRange, FoldingGroup foldingGroup, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: foldingDescriptor");
        }
        if ((n & 4) != 0) {
            foldingGroup = null;
        }
        return pythonFoldingBuilder.foldingDescriptor(aSTNode, textRange, foldingGroup);
    }

    static {
        IElementType[] iElementTypeArray = new IElementType[]{PyElementTypes.SET_LITERAL_EXPRESSION, PyElementTypes.DICT_LITERAL_EXPRESSION, PyElementTypes.GENERATOR_EXPRESSION, PyElementTypes.SET_COMP_EXPRESSION, PyElementTypes.DICT_COMP_EXPRESSION, PyElementTypes.LIST_LITERAL_EXPRESSION, PyElementTypes.LIST_COMP_EXPRESSION, PyElementTypes.TUPLE_EXPRESSION};
        TokenSet tokenSet = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(...)");
        FOLDABLE_COLLECTIONS_LITERALS = tokenSet;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/python/PythonFoldingBuilder$Companion;", "", "<init>", "()V", "FOLDABLE_COLLECTIONS_LITERALS", "Lcom/intellij/psi/tree/TokenSet;", "getFOLDABLE_COLLECTIONS_LITERALS", "()Lcom/intellij/psi/tree/TokenSet;", "PYTHON_TYPE_ANNOTATION_GROUP_NAME", "", "intellij.python.community.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TokenSet getFOLDABLE_COLLECTIONS_LITERALS() {
            return FOLDABLE_COLLECTIONS_LITERALS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

