/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.impl;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.PathKt;
import com.intellij.util.io.impl.DirectorySpecBase;
import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tH&J\b\u0010\u000e\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0002\u000f\u0010\u00a8\u0006\u0011"}, d2={"Lcom/intellij/util/io/impl/ZipSpecBase;", "Lcom/intellij/util/io/impl/DirectorySpecBase;", "extension", "", "<init>", "(Ljava/lang/String;)V", "generate", "", "path", "Ljava/nio/file/Path;", "compress", "contentDir", "Ljava/io/File;", "target", "generateInTempDir", "Lcom/intellij/util/io/impl/JarSpec;", "Lcom/intellij/util/io/impl/ZipSpec;", "intellij.platform.testFramework"})
public abstract class ZipSpecBase
extends DirectorySpecBase {
    @NotNull
    private final String extension;

    private ZipSpecBase(String extension) {
        super(null, null);
        this.extension = extension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File file = FileUtil.createTempDirectory((String)(this.extension + "-content"), null, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempDirectory(...)");
        File contentDir = file;
        try {
            Path path2 = contentDir.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toPath(...)");
            this.generateInDirectory(path2);
            PathKt.createParentDirectories((Path)path);
            this.compress(contentDir, path);
        }
        finally {
            FileUtil.delete((File)contentDir);
        }
    }

    public abstract void compress(@NotNull File var1, @NotNull Path var2);

    @Override
    @NotNull
    public Path generateInTempDir() {
        Path target = FileUtil.createTempFile((String)(this.extension + "-by-spec"), (String)("." + this.extension), (boolean)true).toPath();
        Intrinsics.checkNotNull((Object)target);
        this.generate(target);
        return target;
    }

    public /* synthetic */ ZipSpecBase(String extension, DefaultConstructorMarker $constructor_marker) {
        this(extension);
    }
}

