/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.java.features.correctness;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.ml.inline.completion.features.correctness.Severity;
import com.intellij.ml.inline.completion.java.features.JavaStringLiteralSupporterKt;
import com.intellij.ml.inline.completion.java.features.correctness.CorrectnessProblem;
import com.intellij.ml.inline.completion.java.features.correctness.JavaErrorEnrichmentTool;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u001a\u001e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u0016\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0004\u001a0\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\"\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0014\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0015\u001a\u00020\u0004H\u0002\"*\u0010\n\u001a\u001e\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"findTargetElements", "", "Lcom/intellij/psi/PsiElement;", "psiFile", "Lcom/intellij/psi/PsiFile;", "currentChangedRange", "Lcom/intellij/openapi/util/TextRange;", "createExtendedTextRange", "range", "file", "brackets", "", "Lcom/intellij/psi/tree/IElementType;", "kotlin.jvm.PlatformType", "checkHardcodedCorrectnessError", "Lcom/intellij/ml/inline/completion/java/features/correctness/JavaErrorEnrichmentTool$ErrorResults;", "targetElements", "isCloud", "", "isBraceStealing", "targetElement", "originalFile", "intellij.fullLine.java"})
public final class JavaSuggestionEnricherKt {
    @NotNull
    private static final Map<IElementType, IElementType> brackets;

    @NotNull
    public static final List<PsiElement> findTargetElements(@NotNull PsiFile psiFile2, @NotNull TextRange currentChangedRange) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)psiFile2, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)currentChangedRange, (String)"currentChangedRange");
        PsiElement psiElement2 = psiFile2.findElementAt(currentChangedRange.getStartOffset());
        if (psiElement2 == null) {
            return CollectionsKt.emptyList();
        }
        PsiElement startBoundaryElement = psiElement2;
        if (startBoundaryElement instanceof PsiWhiteSpace) {
            PsiElement psiElement3 = PsiTreeUtil.nextCodeLeaf((PsiElement)startBoundaryElement);
            if (psiElement3 == null) {
                return CollectionsKt.emptyList();
            }
            startBoundaryElement = psiElement3;
            PsiElement psiElement4 = PsiTreeUtil.getDeepestFirst((PsiElement)startBoundaryElement);
            Intrinsics.checkNotNullExpressionValue((Object)psiElement4, (String)"getDeepestFirst(...)");
            startBoundaryElement = psiElement4;
        }
        if (currentChangedRange.getEndOffset() - 1 <= 0) {
            return CollectionsKt.emptyList();
        }
        PsiElement psiElement5 = psiFile2.findElementAt(currentChangedRange.getEndOffset() - 1);
        if (psiElement5 == null) {
            return CollectionsKt.emptyList();
        }
        PsiElement endBoundaryElement = psiElement5;
        if (endBoundaryElement instanceof PsiWhiteSpace) {
            PsiElement psiElement6 = PsiTreeUtil.prevCodeLeaf((PsiElement)endBoundaryElement);
            if (psiElement6 == null) {
                return CollectionsKt.emptyList();
            }
            endBoundaryElement = psiElement6;
            PsiElement psiElement7 = PsiTreeUtil.getDeepestLast((PsiElement)endBoundaryElement);
            Intrinsics.checkNotNullExpressionValue((Object)psiElement7, (String)"getDeepestLast(...)");
            endBoundaryElement = psiElement7;
        }
        if (Intrinsics.areEqual((Object)startBoundaryElement, (Object)endBoundaryElement) ? (psiElement = startBoundaryElement.getParent()) == null : (psiElement = PsiTreeUtil.findCommonParent((PsiElement)startBoundaryElement, (PsiElement)endBoundaryElement)) == null) {
            return CollectionsKt.emptyList();
        }
        PsiElement commonParent = psiElement;
        Object[] statements = null;
        if (commonParent instanceof PsiCodeBlock) {
            statements = ((PsiCodeBlock)commonParent).getStatements();
        } else if (commonParent instanceof PsiBlockStatement) {
            statements = ((PsiBlockStatement)commonParent).getCodeBlock().getStatements();
        }
        if (statements != null) {
            if (statements.length == 0) {
                return CollectionsKt.listOf((Object)commonParent);
            }
            if (PsiTreeUtil.isAncestor((PsiElement)((PsiElement)statements[0]), (PsiElement)startBoundaryElement, (boolean)false) && PsiTreeUtil.isAncestor((PsiElement)((PsiElement)ArraysKt.last((Object[])statements)), (PsiElement)endBoundaryElement, (boolean)false)) {
                return CollectionsKt.listOf((Object)commonParent);
            }
        }
        PsiStatement startStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)startBoundaryElement, PsiStatement.class, (boolean)false);
        PsiStatement endStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)endBoundaryElement, PsiStatement.class, (boolean)false);
        if (startStatement != null && endStatement != null && Intrinsics.areEqual((Object)startStatement.getParent(), (Object)commonParent)) {
            List result2 = new ArrayList();
            PsiElement currentElement = (PsiElement)startStatement;
            while (true) {
                result2.add(currentElement);
                if (PsiTreeUtil.isAncestor((PsiElement)currentElement, (PsiElement)((PsiElement)endStatement), (boolean)false) || currentElement.getNextSibling() == null) break;
            }
            return result2;
        }
        Class[] classArray = new Class[]{PsiVariable.class, PsiStatement.class, PsiCodeBlock.class, PsiMember.class};
        PsiElement psiElement8 = PsiTreeUtil.getParentOfType((PsiElement)commonParent, (boolean)false, (Class[])classArray);
        if (psiElement8 == null) {
            psiElement8 = commonParent;
        }
        return CollectionsKt.listOf((Object)psiElement8);
    }

    @NotNull
    public static final TextRange createExtendedTextRange(@NotNull TextRange range, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        PsiElement psiElement = file.findElementAt(range.getStartOffset());
        if (psiElement == null) {
            return range;
        }
        PsiElement element = psiElement;
        Class[] classArray = new Class[]{PsiStatement.class};
        PsiStatement psiStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)element, (boolean)false, (Class[])classArray);
        if (psiStatement == null) {
            return range;
        }
        PsiStatement parent = psiStatement;
        return new TextRange(parent.getTextRange().getStartOffset(), range.getEndOffset());
    }

    /*
     * WARNING - void declaration
     */
    private static final JavaErrorEnrichmentTool.ErrorResults checkHardcodedCorrectnessError(PsiFile psiFile2, List<? extends PsiElement> targetElements, TextRange currentChangedRange, boolean isCloud) {
        Class[] classArray;
        PsiAnnotation psiAnnotation;
        PsiCodeBlock body;
        PsiElement commonParent;
        PsiElement prevLeaf;
        PsiElement startBoundaryElement = psiFile2.findElementAt(currentChangedRange.getStartOffset());
        if (startBoundaryElement != null && (prevLeaf = PsiTreeUtil.prevLeaf((PsiElement)startBoundaryElement)) instanceof PsiErrorElement) {
            return new JavaErrorEnrichmentTool.ErrorResults(CollectionsKt.listOf((Object)new CorrectnessProblem(null, currentChangedRange, Severity.CRITICAL, null, ((PsiErrorElement)prevLeaf).getErrorDescription(), false)));
        }
        PsiElement psiElement = commonParent = targetElements.size() == 1 ? targetElements.get(0) : null;
        if (commonParent != null && (commonParent instanceof PsiVariable || commonParent instanceof PsiExpressionStatement && ((PsiExpressionStatement)commonParent).getExpression() instanceof PsiAssignmentExpression)) {
            PsiElement nextSibling = PsiTreeUtil.getNextSiblingOfType((PsiElement)commonParent, PsiStatement.class);
            if (nextSibling == null) {
                nextSibling = PsiTreeUtil.getNextSiblingOfType((PsiElement)commonParent.getParent(), PsiStatement.class);
            }
            if (nextSibling != null && (Intrinsics.areEqual(nextSibling.getClass(), commonParent.getClass()) || Intrinsics.areEqual(nextSibling.getClass(), commonParent.getParent().getClass())) && Intrinsics.areEqual((Object)nextSibling.getText(), (Object)commonParent.getText())) {
                return new JavaErrorEnrichmentTool.ErrorResults(CollectionsKt.listOf((Object)new CorrectnessProblem(null, currentChangedRange, Severity.CRITICAL, null, JavaAnalysisBundle.message((String)"reassign.variable.display.name", (Object[])new Object[0]), false)));
            }
        }
        for (PsiElement psiElement2 : targetElements) {
            if (!(psiElement2 instanceof PsiTryStatement)) continue;
            FileTemplate template = null;
            FileTemplate defaultTemplate = null;
            for (PsiCatchSection catchSection : ((PsiTryStatement)psiElement2).getCatchSections()) {
                PsiParameter psiParameter = catchSection.getParameter();
                boolean bl = psiParameter != null && (psiParameter = psiParameter.getTextRange()) != null ? psiParameter.intersects(currentChangedRange) : false;
                if (!bl) continue;
                JavaErrorEnrichmentTool.ErrorResults errorResults = new JavaErrorEnrichmentTool.ErrorResults(CollectionsKt.listOf((Object)new CorrectnessProblem(null, currentChangedRange, Severity.CRITICAL, null, JavaAnalysisBundle.message((String)"reassign.variable.display.name", (Object[])new Object[0]), false)));
                if (template == null) {
                    try {
                        FileTemplateManager fileTemplateManager = FileTemplateManager.getInstance((Project)((PsiTryStatement)psiElement2).getProject());
                        template = fileTemplateManager.getCodeTemplate("Catch Statement Declaration.java");
                        defaultTemplate = fileTemplateManager.getDefaultTemplate("Catch Statement Declaration.java");
                    }
                    catch (RuntimeException runtimeException) {
                        return errorResults;
                    }
                }
                FileTemplate fileTemplate = defaultTemplate;
                if (Intrinsics.areEqual((Object)(fileTemplate != null ? fileTemplate.getText() : null), (Object)template.getText())) continue;
                return errorResults;
            }
        }
        if (commonParent instanceof PsiMethod && psiFile2.getTextLength() > currentChangedRange.getEndOffset() + 1 && (body = ((PsiMethod)commonParent).getBody()) != null && currentChangedRange.intersects(body.getTextRange())) {
            void var7_12;
            void var7_10;
            PsiElement psiElement3 = psiFile2.findElementAt(currentChangedRange.getEndOffset() + 1);
            if (psiElement3 instanceof PsiWhiteSpace) {
                PsiElement psiElement4 = ((PsiWhiteSpace)psiElement3).getNextSibling();
            }
            if (var7_10 != null) {
                PsiElement psiElement5 = PsiTreeUtil.getDeepestVisibleFirst((PsiElement)var7_10);
            }
            if (var7_12 instanceof PsiJavaToken && Intrinsics.areEqual((Object)((PsiJavaToken)var7_12).getTokenType(), (Object)JavaTokenType.LBRACE)) {
                PsiElement psiElement6 = (PsiElement)body;
                TextRange textRange = body.getTextRange();
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
                return new JavaErrorEnrichmentTool.ErrorResults(CollectionsKt.listOf((Object)new CorrectnessProblem(psiElement6, textRange, Severity.CRITICAL, null, null, false)));
            }
        }
        PsiElement startElement = psiFile2.findElementAt(currentChangedRange.getStartOffset());
        if (!isCloud && startElement != null && (psiAnnotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)startElement, PsiAnnotation.class, (boolean)false, (Class[])(classArray = new Class[]{PsiMember.class}))) != null && !PsiTreeUtil.processElements((PsiElement)((PsiElement)psiAnnotation), (PsiElementProcessor)new PsiElementProcessor(currentChangedRange){
            final /* synthetic */ TextRange $currentChangedRange;
            {
                this.$currentChangedRange = $currentChangedRange;
            }

            public final boolean execute(PsiElement it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return !JavaStringLiteralSupporterKt.getJAVA_STRING_TOKENS().contains(it.getNode().getElementType()) || !it.getTextRange().intersects(this.$currentChangedRange);
            }
        })) {
            PsiElement psiElement7 = (PsiElement)psiAnnotation;
            TextRange textRange = psiAnnotation.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
            return new JavaErrorEnrichmentTool.ErrorResults(CollectionsKt.listOf((Object)new CorrectnessProblem(psiElement7, textRange, Severity.CRITICAL, null, null, false)));
        }
        return null;
    }

    private static final boolean isBraceStealing(TextRange currentChangedRange, PsiElement targetElement, PsiFile originalFile) {
        for (PsiElement currentElement = targetElement; currentElement != null; currentElement = currentElement.getParent()) {
            PsiElement firstChild;
            boolean containsFirst;
            PsiElement lastChild;
            Intrinsics.checkNotNullExpressionValue((Object)PsiTreeUtil.getDeepestLast((PsiElement)currentElement), (String)"getDeepestLast(...)");
            Intrinsics.checkNotNullExpressionValue((Object)PsiTreeUtil.getDeepestFirst((PsiElement)currentElement), (String)"getDeepestFirst(...)");
            boolean containsLast = currentChangedRange.contains(lastChild.getTextRange().getEndOffset()) || currentChangedRange.getEndOffset() == lastChild.getTextRange().getEndOffset();
            boolean bl = containsFirst = currentChangedRange.contains(firstChild.getTextRange().getStartOffset()) || currentChangedRange.getStartOffset() == firstChild.getTextRange().getStartOffset();
            if (!containsLast && !containsFirst) {
                return false;
            }
            IElementType rElementType = PsiTreeUtilKt.getElementType((PsiElement)lastChild);
            IElementType lElementType = brackets.get(rElementType);
            if (lElementType == null || containsFirst) continue;
            PsiElement parent = lastChild.getParent();
            PsiElement lElement = null;
            for (PsiElement psiElement : parent.getChildren()) {
                if (!Intrinsics.areEqual((Object)lElementType, (Object)PsiTreeUtilKt.getElementType((PsiElement)psiElement)) || currentChangedRange.contains(psiElement.getTextRange().getStartOffset())) continue;
                lElement = psiElement;
                break;
            }
            if (lElement == null) continue;
            PsiElement lOriginalElement = originalFile.findElementAt(lElement.getTextRange().getStartOffset());
            if (lOriginalElement == null || !Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)lOriginalElement), (Object)lElementType)) {
                return true;
            }
            PsiElement originalParent = lOriginalElement.getParent();
            PsiElement rOriginalElement = null;
            for (PsiElement originalChild : originalParent.getChildren()) {
                if (!Intrinsics.areEqual((Object)rElementType, (Object)PsiTreeUtilKt.getElementType((PsiElement)originalChild))) continue;
                rOriginalElement = originalChild;
                break;
            }
            if (rOriginalElement == null || !currentChangedRange.contains(rOriginalElement.getTextRange().getStartOffset())) {
                return true;
            }
            PsiElement psiElement = PsiTreeUtil.nextCodeLeaf((PsiElement)currentElement);
            if (psiElement == null || brackets.containsKey(psiElement.getNode().getElementType()) || !currentChangedRange.contains(psiElement.getTextRange())) continue;
            return true;
        }
        return false;
    }

    public static final /* synthetic */ boolean access$isBraceStealing(TextRange currentChangedRange, PsiElement targetElement, PsiFile originalFile) {
        return JavaSuggestionEnricherKt.isBraceStealing(currentChangedRange, targetElement, originalFile);
    }

    public static final /* synthetic */ JavaErrorEnrichmentTool.ErrorResults access$checkHardcodedCorrectnessError(PsiFile psiFile2, List targetElements, TextRange currentChangedRange, boolean isCloud) {
        return JavaSuggestionEnricherKt.checkHardcodedCorrectnessError(psiFile2, targetElements, currentChangedRange, isCloud);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)JavaTokenType.RPARENTH, (Object)JavaTokenType.LPARENTH), TuplesKt.to((Object)JavaTokenType.RBRACE, (Object)JavaTokenType.LBRACE), TuplesKt.to((Object)JavaTokenType.RBRACKET, (Object)JavaTokenType.LBRACKET)};
        brackets = MapsKt.mutableMapOf((Pair[])pairArray);
    }
}

