/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.ml.api.feature.preprocessor;

import com.jetbrains.ml.api.feature.Feature;
import com.jetbrains.ml.api.feature.FeatureSet;
import com.jetbrains.ml.api.feature.FeatureSignature;
import com.jetbrains.ml.api.feature.FeatureSignatureKt;
import com.jetbrains.ml.api.feature.preprocessor.FeaturePreprocessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016J\"\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\b2\u0006\u0010\r\u001a\u00020\fJP\u0010\u0011\u001a \u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\b\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\b0\u00130\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\b2\u0012\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\b0\u00132\u0006\u0010\r\u001a\u00020\fH\u0016J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\b2\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\fH&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/ml/api/feature/preprocessor/FeatureTransformer;", "Lcom/jetbrains/ml/api/feature/preprocessor/FeaturePreprocessor;", "inputFeature", "Lcom/jetbrains/ml/api/feature/FeatureSignature;", "(Lcom/jetbrains/ml/api/feature/FeatureSignature;)V", "getInputFeature", "()Lcom/jetbrains/ml/api/feature/FeatureSignature;", "output", "", "getOutput", "()Ljava/util/Collection;", "deduceRequiredInput", "Lcom/jetbrains/ml/api/feature/FeatureSet;", "requiredOutput", "preprocessFeatures", "Lcom/jetbrains/ml/api/feature/Feature;", "features", "preprocessFeaturesBatch", "Lkotlin/Pair;", "", "contextFeatures", "itemFeatures", "transformFeature", "feature", "ml-api"})
@SourceDebugExtension(value={"SMAP\nPreprocessors.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Preprocessors.kt\ncom/jetbrains/ml/api/feature/preprocessor/FeatureTransformer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,61:1\n819#2:62\n847#2,2:63\n1549#2:65\n1620#2,3:66\n*S KotlinDebug\n*F\n+ 1 Preprocessors.kt\ncom/jetbrains/ml/api/feature/preprocessor/FeatureTransformer\n*L\n41#1:62\n41#1:63,2\n53#1:65\n53#1:66,3\n*E\n"})
public abstract class FeatureTransformer
extends FeaturePreprocessor {
    @NotNull
    private final FeatureSignature inputFeature;

    public FeatureTransformer(@NotNull FeatureSignature inputFeature) {
        Intrinsics.checkNotNullParameter((Object)inputFeature, (String)"inputFeature");
        this.inputFeature = inputFeature;
    }

    @NotNull
    public final FeatureSignature getInputFeature() {
        return this.inputFeature;
    }

    @NotNull
    public abstract Collection<FeatureSignature> getOutput();

    @NotNull
    public abstract Collection<Feature> transformFeature(@NotNull Feature var1, @NotNull FeatureSet var2);

    @Override
    @NotNull
    public FeatureSet deduceRequiredInput(@NotNull FeatureSet requiredOutput) {
        Intrinsics.checkNotNullParameter((Object)requiredOutput, (String)"requiredOutput");
        return new FeatureSet(this, requiredOutput){
            final /* synthetic */ FeatureTransformer this$0;
            final /* synthetic */ FeatureSet $requiredOutput;
            {
                this.this$0 = $receiver;
                this.$requiredOutput = $requiredOutput;
            }

            public boolean contains(@NotNull FeatureSignature signature) {
                Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
                if (!this.this$0.getInputFeature().isSupersetOf(signature)) {
                    return false;
                }
                return !this.$requiredOutput.selectSignatures(this.this$0.getOutput()).isEmpty();
            }

            @NotNull
            public Collection<FeatureSignature> selectMissingSignatures(@NotNull Collection<? extends FeatureSignature> provided) {
                Intrinsics.checkNotNullParameter(provided, (String)"provided");
                if (FeatureSignatureKt.isDeclaredBy(this.this$0.getInputFeature(), (Iterable<? extends FeatureSignature>)provided)) {
                    return CollectionsKt.emptyList();
                }
                return CollectionsKt.listOf((Object)this.this$0.getInputFeature());
            }

            @NotNull
            public Collection<Feature> selectFeatures(@NotNull Collection<? extends Feature> provided) {
                return FeatureSet.DefaultImpls.selectFeatures(this, provided);
            }

            @NotNull
            public Collection<FeatureSignature> selectSignatures(@NotNull Collection<? extends FeatureSignature> provided) {
                return FeatureSet.DefaultImpls.selectSignatures(this, provided);
            }

            @NotNull
            public Collection<FeatureSignature> selectMissingFeatures(@NotNull Collection<? extends Feature> provided) {
                return FeatureSet.DefaultImpls.selectMissingFeatures(this, provided);
            }

            @NotNull
            public Collection<Feature> selectFeaturesNotFromThis(@NotNull Collection<? extends Feature> provided) {
                return FeatureSet.DefaultImpls.selectFeaturesNotFromThis(this, provided);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public final Collection<Feature> preprocessFeatures(@NotNull Collection<? extends Feature> features, @NotNull FeatureSet requiredOutput) {
        List nonDeclared;
        Collection extraFeatures;
        Collection collection;
        Intrinsics.checkNotNullParameter(features, (String)"features");
        Intrinsics.checkNotNullParameter((Object)requiredOutput, (String)"requiredOutput");
        Feature feature = FeatureSignatureKt.findFeatureMatching((Iterable<? extends Feature>)features, this.inputFeature);
        if (feature != null) {
            Feature it = feature;
            boolean bl = false;
            collection = this.transformFeature(it, requiredOutput);
        } else {
            collection = null;
        }
        Collection transformedFeature = collection;
        List<Feature> otherFeatures = FeatureSignatureKt.findFeaturesNotMatching((Iterable<? extends Feature>)features, this.inputFeature);
        Collection collection2 = transformedFeature;
        if (collection2 == null || (collection2 = FeatureSet.Companion.selectOnlyNotFrom(collection2, requiredOutput)) == null) {
            collection2 = CollectionsKt.emptyList();
        }
        if (!(extraFeatures = collection2).isEmpty()) {
            boolean bl = false;
            String string = "Preprocessor " + this + " as produced features that are not required in the output: " + extraFeatures;
            throw new IllegalStateException(string.toString());
        }
        Collection collection3 = transformedFeature;
        if (collection3 != null) {
            void $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv = collection3;
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                Feature it = (Feature)element$iv$iv;
                boolean bl = false;
                if (FeatureSignatureKt.isDeclaredBy(it, (Iterable<? extends FeatureSignature>)this.getOutput())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            v4 = (List)destination$iv$iv;
        } else {
            v4 = nonDeclared = CollectionsKt.emptyList();
        }
        if (!nonDeclared.isEmpty()) {
            boolean bl = false;
            String string = "Preprocessor " + this + " has produced features that were not declared in the output: " + nonDeclared;
            throw new IllegalStateException(string.toString());
        }
        Collection collection4 = transformedFeature;
        if (collection4 == null) {
            collection4 = CollectionsKt.emptyList();
        }
        return CollectionsKt.plus((Collection)collection4, (Iterable)FeatureSet.Companion.selectOnlyFrom((Collection<? extends Feature>)otherFeatures, requiredOutput));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Pair<Collection<Feature>, List<Collection<Feature>>> preprocessFeaturesBatch(@NotNull Collection<? extends Feature> contextFeatures, @NotNull List<? extends Collection<? extends Feature>> itemFeatures, @NotNull FeatureSet requiredOutput) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(contextFeatures, (String)"contextFeatures");
        Intrinsics.checkNotNullParameter(itemFeatures, (String)"itemFeatures");
        Intrinsics.checkNotNullParameter((Object)requiredOutput, (String)"requiredOutput");
        Iterable iterable = itemFeatures;
        Collection<Feature> collection = this.preprocessFeatures(contextFeatures, requiredOutput);
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Collection collection2 = (Collection)item$iv$iv;
            Collection collection3 = destination$iv$iv;
            boolean bl = false;
            collection3.add(this.preprocessFeatures((Collection<? extends Feature>)it, requiredOutput));
        }
        return TuplesKt.to(collection, (Object)((List)destination$iv$iv));
    }
}

