/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlToken;
import com.intellij.ui.ColorChooserService;
import com.intellij.ui.ColorPickerListenerFactory;
import com.intellij.ui.ColorUtil;
import com.intellij.util.Function;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.util.ColorMap;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UserColorLookup
extends LookupElementDecorator<LookupElement> {
    private static final Function<Color, String> COLOR_TO_STRING_CONVERTER = color -> "#" + ColorUtil.toHex((Color)color);

    public UserColorLookup() {
        this(COLOR_TO_STRING_CONVERTER);
    }

    public UserColorLookup(Function<? super Color, String> colorToStringConverter) {
        this(colorToStringConverter, 2);
    }

    public UserColorLookup(final Function<? super Color, String> colorToStringConverter, int priority) {
        super(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)UserColorLookup.getColorString()).withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

            public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                if (context == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (item == null) {
                    1.$$$reportNull$$$0(1);
                }
                UserColorLookup.handleUserSelection(context, (Function<? super Color, String>)colorToStringConverter);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "item";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/xml/util/UserColorLookup$1";
                objectArray[2] = "handleInsert";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }), (double)priority));
    }

    private static void handleUserSelection(InsertionContext context, @NotNull Function<? super Color, String> colorToStringConverter) {
        if (colorToStringConverter == null) {
            UserColorLookup.$$$reportNull$$$0(0);
        }
        Project project = context.getProject();
        Editor editor = context.getEditor();
        int startOffset = context.getStartOffset();
        context.getDocument().deleteString(startOffset, context.getTailOffset());
        PsiElement element = context.getFile().findElementAt(editor.getCaretModel().getOffset());
        Color myColorAtCaret = element instanceof XmlToken ? UserColorLookup.getColorFromElement(element) : null;
        context.setLaterRunnable(() -> {
            if (editor.isDisposed() || project.isDisposed()) {
                return;
            }
            List listeners = ColorPickerListenerFactory.createListenersFor((PsiElement)element);
            Color color = ColorChooserService.getInstance().showDialog(project, (Component)WindowManager.getInstance().suggestParentWindow(project), IdeBundle.message((String)"dialog.title.choose.color", (Object[])new Object[0]), myColorAtCaret, true, listeners, true);
            if (color != null) {
                WriteCommandAction.runWriteCommandAction((Project)project, () -> {
                    editor.getCaretModel().moveToOffset(startOffset);
                    EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)((String)colorToStringConverter.fun((Object)color)));
                });
            }
        });
    }

    @Nullable
    public static Color getColorFromElement(PsiElement element) {
        if (!(element instanceof XmlToken)) {
            return null;
        }
        return ColorMap.getColor(element.getText());
    }

    private static String getColorString() {
        return XmlBundle.message("xml.lookup.choose.color", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorToStringConverter", "com/intellij/xml/util/UserColorLookup", "handleUserSelection"));
    }
}

