/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.XmlCustomTagHighlightingStrategy;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.util.LayeredTextAttributes;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlRecursiveElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.xml.XmlCustomTagHighlightingPassKt;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import com.intellij.xml.util.HtmlUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0016\u0010\u0013\u001a\u0010\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u00150\u00150\u0014H\u0002J \u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J)\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002\u00a2\u0006\u0002\u0010!J\u001b\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002\u00a2\u0006\u0002\u0010%J-\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002\u00a2\u0006\u0002\u0010)J\u0017\u0010*\u001a\t\u0018\u00010\u001f\u00a2\u0006\u0002\b+2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010,\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/intellij/xml/XmlCustomTagHighlightingPass;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPass;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/editor/Editor;)V", "getFile", "()Lcom/intellij/psi/PsiFile;", "myHolder", "Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;", "myHighlighter", "Lcom/intellij/openapi/fileTypes/SyntaxHighlighter;", "kotlin.jvm.PlatformType", "doCollectInformation", "", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getCustomNames", "", "", "applyHighlighting", "originalXmlTag", "Lcom/intellij/psi/xml/XmlTag;", "node", "Lcom/intellij/lang/ASTNode;", "elementType", "Lcom/intellij/psi/tree/IElementType;", "replaceTextAttributeKeys", "", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "attributesKeys", "(Lcom/intellij/psi/xml/XmlTag;[Lcom/intellij/openapi/editor/colors/TextAttributesKey;)[Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "hasKey", "", "keys", "([Lcom/intellij/openapi/editor/colors/TextAttributesKey;)Z", "highlight", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "key", "(Lcom/intellij/psi/xml/XmlTag;Lcom/intellij/lang/ASTNode;[Lcom/intellij/openapi/editor/colors/TextAttributesKey;)Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "getCustomAttributeKey", "Lorg/jetbrains/annotations/Nullable;", "doApplyInformationToEditor", "intellij.xml.analysis.impl"})
@SourceDebugExtension(value={"SMAP\nXmlCustomTagHighlightingPass.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XmlCustomTagHighlightingPass.kt\ncom/intellij/xml/XmlCustomTagHighlightingPass\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,147:1\n1163#2,3:148\n11228#3:151\n11563#3,3:152\n1310#3,2:159\n37#4:155\n36#4,3:156\n774#5:161\n865#5,2:162\n1#6:164\n*S KotlinDebug\n*F\n+ 1 XmlCustomTagHighlightingPass.kt\ncom/intellij/xml/XmlCustomTagHighlightingPass\n*L\n69#1:148,3\n86#1:151\n86#1:152,3\n93#1:159,2\n86#1:155\n86#1:156,3\n114#1:161\n114#1:162,2\n*E\n"})
public final class XmlCustomTagHighlightingPass
extends TextEditorHighlightingPass {
    @NotNull
    private final PsiFile file;
    @NotNull
    private final HighlightInfoHolder myHolder;
    private final SyntaxHighlighter myHighlighter;

    public XmlCustomTagHighlightingPass(@NotNull PsiFile file, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        super(file.getProject(), editor.getDocument(), true);
        this.file = file;
        this.myHolder = new HighlightInfoHolder(this.file, new HighlightInfoFilter[0]);
        this.myHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)this.file.getLanguage(), (Project)this.file.getProject(), (VirtualFile)this.file.getVirtualFile());
    }

    @NotNull
    public final PsiFile getFile() {
        return this.file;
    }

    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
        this.file.acceptChildren((PsiElementVisitor)new XmlRecursiveElementWalkingVisitor(this){
            final /* synthetic */ XmlCustomTagHighlightingPass this$0;
            {
                this.this$0 = $receiver;
            }

            public void visitXmlTag(XmlTag tag) {
                block4: {
                    Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
                    super.visitXmlTag(tag);
                    XmlElementDescriptor xmlElementDescriptor = tag.getDescriptor();
                    if (xmlElementDescriptor == null) {
                        return;
                    }
                    XmlElementDescriptor descriptor = xmlElementDescriptor;
                    if (descriptor instanceof AnyXmlElementDescriptor && !XmlCustomTagHighlightingPass.access$getCustomNames(this.this$0).contains(tag.getName())) {
                        return;
                    }
                    if (!XmlCustomTagHighlightingPassKt.isCustomTag(this.this$0.getFile(), tag)) break block4;
                    ASTNode aSTNode = tag.getNode();
                    if (aSTNode != null) {
                        ASTNode aSTNode2 = aSTNode;
                        XmlCustomTagHighlightingPass xmlCustomTagHighlightingPass = this.this$0;
                        ASTNode it = aSTNode2;
                        boolean bl = false;
                        for (ASTNode child : it.getChildren(null)) {
                            Intrinsics.checkNotNull((Object)child);
                            IElementType iElementType = child.getElementType();
                            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
                            XmlCustomTagHighlightingPass.access$applyHighlighting(xmlCustomTagHighlightingPass, tag, child, iElementType);
                        }
                    }
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final Set<String> getCustomNames() {
        Set set;
        String string = HtmlUtil.getEntitiesString((PsiElement)this.file, "HtmlUnknownTag");
        if (string != null) {
            char[] cArray = new char[]{','};
            Sequence sequence = StringsKt.splitToSequence$default((CharSequence)string, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            if (sequence != null) {
                void $this$mapTo$iv;
                Sequence sequence2 = sequence;
                Collection destination$iv = new HashSet();
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv.iterator();
                while (true) {
                    void it;
                    if (!iterator.hasNext()) {
                        set = (HashSet)destination$iv;
                        return set;
                    }
                    Object item$iv = iterator.next();
                    String string2 = (String)item$iv;
                    Collection collection = destination$iv;
                    boolean bl = false;
                    collection.add(StringUtil.toLowerCase((String)it));
                }
            }
        }
        set = SetsKt.emptySet();
        return set;
    }

    private final void applyHighlighting(XmlTag originalXmlTag, ASTNode node, IElementType elementType) {
        if (!(node instanceof LeafElement)) {
            return;
        }
        IElementType effectiveElementType = Intrinsics.areEqual((Object)elementType, (Object)XmlTokenType.XML_NAME) ? XmlTokenType.XML_TAG_NAME : elementType;
        Object[] objectArray = this.myHighlighter.getTokenHighlights(effectiveElementType);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getTokenHighlights(...)");
        Object[] attributesKeys = objectArray;
        Object[] newAttributesKeys = this.replaceTextAttributeKeys(originalXmlTag, (TextAttributesKey[])attributesKeys);
        if (!Arrays.equals(newAttributesKeys, attributesKeys)) {
            this.myHolder.add(this.highlight(originalXmlTag, node, (TextAttributesKey[])newAttributesKeys));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final TextAttributesKey[] replaceTextAttributeKeys(XmlTag originalXmlTag, TextAttributesKey[] attributesKeys) {
        if (this.hasKey(attributesKeys)) {
            void $this$mapTo$iv$iv;
            TextAttributesKey[] $this$map$iv = attributesKeys;
            boolean $i$f$map = false;
            TextAttributesKey[] textAttributesKeyArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var11_11 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                TextAttributesKey textAttributesKey = this.getCustomAttributeKey(originalXmlTag);
                if (textAttributesKey == null && (textAttributesKey = (TextAttributesKey)XmlCustomTagHighlightingPassKt.access$getAttributeKeyMapping$p().get(it)) == null) {
                    textAttributesKey = it;
                }
                collection.add(textAttributesKey);
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new TextAttributesKey[0]);
        }
        return attributesKeys;
    }

    private final boolean hasKey(TextAttributesKey[] keys) {
        TextAttributesKey textAttributesKey;
        block1: {
            TextAttributesKey[] $this$firstOrNull$iv = keys;
            boolean $i$f$firstOrNull = false;
            int n = $this$firstOrNull$iv.length;
            for (int i = 0; i < n; ++i) {
                TextAttributesKey element$iv;
                TextAttributesKey it = element$iv = $this$firstOrNull$iv[i];
                boolean bl = false;
                if (!XmlCustomTagHighlightingPassKt.access$getAttributeKeyMapping$p().containsKey(it)) continue;
                textAttributesKey = element$iv;
                break block1;
            }
            textAttributesKey = null;
        }
        return textAttributesKey != null;
    }

    private final HighlightInfo highlight(XmlTag originalXmlTag, ASTNode node, TextAttributesKey[] key) {
        Object object;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            object = this.getCustomAttributeKey(originalXmlTag);
            if (object == null || (object = object.getExternalName()) == null) {
                object = "Custom tag name";
            }
        } else {
            object = null;
        }
        TextAttributesKey description = object;
        HighlightInfo.Builder builder2 = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.INFORMATION).severity(HighlightInfoType.SYMBOL_TYPE_SEVERITY).range(node);
        EditorColorsScheme editorColorsScheme = this.getColorsScheme();
        if (editorColorsScheme == null) {
            EditorColorsScheme editorColorsScheme2 = EditorColorsUtil.getGlobalOrDefaultColorScheme();
            editorColorsScheme = editorColorsScheme2;
            Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme2, (String)"getGlobalOrDefaultColorScheme(...)");
        }
        HighlightInfo.Builder builder3 = builder2.textAttributes((TextAttributes)LayeredTextAttributes.create((EditorColorsScheme)editorColorsScheme, (TextAttributesKey[])key));
        Intrinsics.checkNotNullExpressionValue((Object)builder3, (String)"textAttributes(...)");
        HighlightInfo.Builder textAttributes = builder3;
        if (description != null) {
            HighlightInfo.Builder builder4 = textAttributes.description((String)description);
            Intrinsics.checkNotNullExpressionValue((Object)builder4, (String)"description(...)");
            textAttributes = builder4;
        }
        return textAttributes.create();
    }

    /*
     * WARNING - void declaration
     */
    private final TextAttributesKey getCustomAttributeKey(XmlTag originalXmlTag) {
        Iterable iterable;
        block2: {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = XmlCustomTagHighlightingStrategy.EP_NAME.getExtensionList();
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                XmlCustomTagHighlightingStrategy it = (XmlCustomTagHighlightingStrategy)element$iv$iv;
                boolean bl = false;
                if (!it.isAvailable(this.file, originalXmlTag)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (XmlCustomTagHighlightingStrategy it : (Iterable)((List)destination$iv$iv)) {
                boolean bl = false;
                iterable2 = it.highlightCustomTag(this.file, originalXmlTag);
                if (iterable2 == null) continue;
                iterable = iterable2;
                break block2;
            }
            iterable = null;
        }
        return iterable;
    }

    public void doApplyInformationToEditor() {
        List highlights = new ArrayList();
        int n = this.myHolder.size();
        for (int i = 0; i < n; ++i) {
            HighlightInfo highlightInfo = this.myHolder.get(i);
            Intrinsics.checkNotNullExpressionValue((Object)highlightInfo, (String)"get(...)");
            highlights.add(highlightInfo);
        }
        UpdateHighlightersUtil.setHighlightersToEditor((Project)this.myProject, (Document)this.myDocument, (int)0, (int)this.file.getTextLength(), (Collection)highlights, (EditorColorsScheme)this.getColorsScheme(), (int)this.getId());
    }

    public static final /* synthetic */ Set access$getCustomNames(XmlCustomTagHighlightingPass $this) {
        return $this.getCustomNames();
    }

    public static final /* synthetic */ void access$applyHighlighting(XmlCustomTagHighlightingPass $this, XmlTag originalXmlTag, ASTNode node, IElementType elementType) {
        $this.applyHighlighting(originalXmlTag, node, elementType);
    }
}

