/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.offscreen.raster;

import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.offscreen.NotebookGraphicsConfigurationManager;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.offscreen.raster.JcefOffScreenComponentController;
import com.intellij.notebooks.visualization.outputs.NotebookOutputInlayShowable;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 '2\u00020\u0001:\u0001'B!\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u001f\u001a\u00020\u0011J\u0006\u0010 \u001a\u00020\u0018J\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0003J\u000e\u0010$\u001a\u00020\"2\u0006\u0010%\u001a\u00020&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR$\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001e\u00a8\u0006("}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/raster/JcefOffscreenViewPort;", "Lcom/intellij/notebooks/visualization/outputs/NotebookOutputInlayShowable;", "bounds", "Ljava/awt/Rectangle;", "viewPortComponentController", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/raster/JcefOffScreenComponentController;", "graphicsConfigurationManager", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/NotebookGraphicsConfigurationManager;", "<init>", "(Ljava/awt/Rectangle;Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/raster/JcefOffScreenComponentController;Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/NotebookGraphicsConfigurationManager;)V", "getBounds", "()Ljava/awt/Rectangle;", "getViewPortComponentController", "()Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/raster/JcefOffScreenComponentController;", "getGraphicsConfigurationManager", "()Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/NotebookGraphicsConfigurationManager;", "value", "", "shown", "getShown", "()Z", "setShown", "(Z)V", "buffer", "Ljava/awt/image/BufferedImage;", "backgroundColor", "Ljava/awt/Color;", "getBackgroundColor", "()Ljava/awt/Color;", "setBackgroundColor", "(Ljava/awt/Color;)V", "hasBuffer", "getOrCreateBuffer", "setBounds", "", "newValue", "draw", "g", "Ljava/awt/Graphics;", "Companion", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJcefOffscreenViewPort.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JcefOffscreenViewPort.kt\ncom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/raster/JcefOffscreenViewPort\n+ 2 NotebookVisualizationUiUtil.kt\ncom/intellij/notebooks/visualization/NotebookVisualizationUiUtilKt\n*L\n1#1,117:1\n22#2,8:118\n*S KotlinDebug\n*F\n+ 1 JcefOffscreenViewPort.kt\ncom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/raster/JcefOffscreenViewPort\n*L\n79#1:118,8\n*E\n"})
public final class JcefOffscreenViewPort
implements NotebookOutputInlayShowable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Rectangle bounds;
    @NotNull
    private final JcefOffScreenComponentController viewPortComponentController;
    @NotNull
    private final NotebookGraphicsConfigurationManager graphicsConfigurationManager;
    private boolean shown;
    @Nullable
    private BufferedImage buffer;
    @NotNull
    private Color backgroundColor;

    public JcefOffscreenViewPort(@NotNull Rectangle bounds, @NotNull JcefOffScreenComponentController viewPortComponentController, @NotNull NotebookGraphicsConfigurationManager graphicsConfigurationManager) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Intrinsics.checkNotNullParameter((Object)viewPortComponentController, (String)"viewPortComponentController");
        Intrinsics.checkNotNullParameter((Object)graphicsConfigurationManager, (String)"graphicsConfigurationManager");
        this.bounds = bounds;
        this.viewPortComponentController = viewPortComponentController;
        this.graphicsConfigurationManager = graphicsConfigurationManager;
        JBColor jBColor = JBColor.BLACK;
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"BLACK");
        this.backgroundColor = (Color)jBColor;
    }

    @NotNull
    public final Rectangle getBounds() {
        return this.bounds;
    }

    @NotNull
    public final JcefOffScreenComponentController getViewPortComponentController() {
        return this.viewPortComponentController;
    }

    @NotNull
    public final NotebookGraphicsConfigurationManager getGraphicsConfigurationManager() {
        return this.graphicsConfigurationManager;
    }

    public boolean getShown() {
        return this.shown;
    }

    public void setShown(boolean value) {
        if (this.shown == value) {
            return;
        }
        this.shown = value;
        if (value) {
            this.getOrCreateBuffer();
        } else {
            this.buffer = null;
        }
    }

    @NotNull
    public final Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public final void setBackgroundColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"<set-?>");
        this.backgroundColor = color;
    }

    public final boolean hasBuffer() {
        return this.buffer != null;
    }

    @NotNull
    public final BufferedImage getOrCreateBuffer() {
        BufferedImage oldBufferedImage = this.buffer;
        int requiredWidth = this.graphicsConfigurationManager.scaleUp(this.bounds.width);
        int requiredHeight = this.graphicsConfigurationManager.scaleUp(this.bounds.height);
        if (oldBufferedImage != null && oldBufferedImage.getWidth() == requiredWidth && oldBufferedImage.getHeight() == requiredHeight) {
            return oldBufferedImage;
        }
        BufferedImage buffer = new BufferedImage(Math.max(1, requiredWidth), Math.max(1, requiredHeight), 1);
        JcefOffscreenViewPort.Companion.fillBufferedImage(buffer, this.backgroundColor);
        if (oldBufferedImage != null) {
            JcefOffscreenViewPort.Companion.copyFromBuffer(oldBufferedImage, buffer);
        }
        this.buffer = buffer;
        return buffer;
    }

    public final void setBounds(@NotNull Rectangle newValue) {
        Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
        if (Intrinsics.areEqual((Object)this.bounds, (Object)newValue)) {
            return;
        }
        this.bounds.setRect(newValue);
        if (this.getShown()) {
            this.getOrCreateBuffer();
        }
        this.viewPortComponentController.sizeChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void draw(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        BufferedImage bufferedImage = this.buffer;
        if (bufferedImage == null) {
            return;
        }
        BufferedImage buffer = bufferedImage;
        Graphics $this$useG2D$iv = g;
        boolean $i$f$useG2D = false;
        Graphics graphics = $this$useG2D$iv.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g2d$iv = (Graphics2D)graphics;
        try {
            Graphics2D g2d = g2d$iv;
            boolean bl = false;
            boolean bl2 = this.graphicsConfigurationManager.getHiDpi() ? g2d.drawImage(buffer, 0, 0, this.graphicsConfigurationManager.scaleDown(buffer.getWidth()), this.graphicsConfigurationManager.scaleDown(buffer.getHeight()), null) : g2d.drawImage((Image)buffer, 0, 0, null);
        }
        finally {
            g2d$iv.dispose();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007H\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/raster/JcefOffscreenViewPort$Companion;", "", "<init>", "()V", "fillBufferedImage", "", "buffer", "Ljava/awt/image/BufferedImage;", "color", "Ljava/awt/Color;", "copyFromBuffer", "sourceBuffer", "targetBuffer", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void fillBufferedImage(BufferedImage buffer, Color color) {
            Graphics g = buffer.getGraphics().create();
            try {
                g.setColor(color);
                g.fillRect(0, 0, buffer.getWidth(), buffer.getHeight());
            }
            finally {
                g.dispose();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void copyFromBuffer(BufferedImage sourceBuffer, BufferedImage targetBuffer) {
            Graphics g = targetBuffer.getGraphics().create();
            try {
                g.drawImage(sourceBuffer, 0, 0, null);
            }
            finally {
                g.dispose();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

