/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.connections.settings.state;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@State(name="VirtualFileConfigStorage", storages={@Storage(value="virtual-file-settings.xml", roamingType=RoamingType.DISABLED)})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 \u001c2\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002:\u0001\u001cB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0010\u001a\u00020\u0000H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0000H\u0016J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0007J\u0016\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0007J\u000e\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u001b\u001a\u00020\u0012R&\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR&\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\r0\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\t\"\u0004\b\u000f\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/settings/state/JupyterVirtualFileConfigState;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/openapi/Disposable$Default;", "<init>", "()V", "fileToConfig", "", "", "getFileToConfig", "()Ljava/util/Map;", "setFileToConfig", "(Ljava/util/Map;)V", "fileTimestamp", "", "getFileTimestamp", "setFileTimestamp", "getState", "loadState", "", "state", "getFileConfig", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "clearConfig", "configId", "registerFileConfig", "removeFileConfig", "clearOverLimitConfigs", "Companion", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterVirtualFileConfigState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterVirtualFileConfigState.kt\ncom/intellij/jupyter/core/jupyter/connections/settings/state/JupyterVirtualFileConfigState\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,65:1\n774#2:66\n865#2,2:67\n1563#2:69\n1634#2,3:70\n1869#2,2:73\n1056#2:75\n1563#2:76\n1634#2,3:77\n1869#2,2:80\n*S KotlinDebug\n*F\n+ 1 JupyterVirtualFileConfigState.kt\ncom/intellij/jupyter/core/jupyter/connections/settings/state/JupyterVirtualFileConfigState\n*L\n28#1:66\n28#1:67,2\n28#1:69\n28#1:70,3\n29#1:73,2\n49#1:75\n49#1:76\n49#1:77,3\n50#1:80,2\n*E\n"})
public final class JupyterVirtualFileConfigState
implements PersistentStateComponent<JupyterVirtualFileConfigState>,
Disposable.Default {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Map<String, String> fileToConfig = new LinkedHashMap();
    @NotNull
    private Map<String, Long> fileTimestamp = new LinkedHashMap();
    private static final int MAX_COUNT = 100;

    @NotNull
    public final Map<String, String> getFileToConfig() {
        return this.fileToConfig;
    }

    public final void setFileToConfig(@NotNull Map<String, String> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.fileToConfig = map;
    }

    @NotNull
    public final Map<String, Long> getFileTimestamp() {
        return this.fileTimestamp;
    }

    public final void setFileTimestamp(@NotNull Map<String, Long> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.fileTimestamp = map;
    }

    @NotNull
    public JupyterVirtualFileConfigState getState() {
        return this;
    }

    public void loadState(@NotNull JupyterVirtualFileConfigState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
        this.clearOverLimitConfigs();
    }

    @Nullable
    public final String getFileConfig(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.fileToConfig.get(JupyterVirtualFileConfigState.Companion.getFileId(file));
    }

    /*
     * WARNING - void declaration
     */
    public final void clearConfig(@NotNull String configId) {
        void $this$mapTo$iv$iv;
        Map.Entry it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)configId, (String)"configId");
        Iterable $this$filter$iv = this.fileToConfig.entrySet();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getValue(), (Object)configId)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((String)it.getKey());
        }
        List filesWithConfig = (List)destination$iv$iv;
        Iterable $this$forEach$iv = filesWithConfig;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it2 = (String)element$iv;
            boolean bl = false;
            this.fileToConfig.remove(it2);
            this.fileTimestamp.remove(it2);
        }
    }

    public final void registerFileConfig(@NotNull VirtualFile file, @NotNull String configId) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)configId, (String)"configId");
        this.fileToConfig.put(JupyterVirtualFileConfigState.Companion.getFileId(file), configId);
        this.fileTimestamp.put(JupyterVirtualFileConfigState.Companion.getFileId(file), System.currentTimeMillis());
    }

    public final void removeFileConfig(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.fileToConfig.remove(JupyterVirtualFileConfigState.Companion.getFileId(file));
        this.fileTimestamp.remove(JupyterVirtualFileConfigState.Companion.getFileId(file));
    }

    /*
     * WARNING - void declaration
     */
    public final void clearOverLimitConfigs() {
        void $this$mapTo$iv$iv;
        if (this.fileToConfig.size() <= 100) {
            return;
        }
        int countForRemove = this.fileToConfig.size() - 100;
        Iterable $this$sortedBy$iv = this.fileTimestamp.entrySet();
        boolean $i$f$sortedBy = false;
        Iterable $this$map$iv = CollectionsKt.take((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = (Long)it.getValue();
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Long)it.getValue()));
            }
        }), (int)countForRemove);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Map.Entry entry = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((String)it.getKey());
        }
        List oldKeys = (List)destination$iv$iv;
        Iterable $this$forEach$iv = oldKeys;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            this.fileToConfig.remove(it);
            this.fileTimestamp.remove(it);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\u00020\t*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/settings/state/JupyterVirtualFileConfigState$Companion;", "", "<init>", "()V", "MAX_COUNT", "", "getInstance", "Lcom/intellij/jupyter/core/jupyter/connections/settings/state/JupyterVirtualFileConfigState;", "fileId", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getFileId", "(Lcom/intellij/openapi/vfs/VirtualFile;)Ljava/lang/String;", "intellij.jupyter.core"})
    @SourceDebugExtension(value={"SMAP\nJupyterVirtualFileConfigState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterVirtualFileConfigState.kt\ncom/intellij/jupyter/core/jupyter/connections/settings/state/JupyterVirtualFileConfigState$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,65:1\n30#2,2:66\n*S KotlinDebug\n*F\n+ 1 JupyterVirtualFileConfigState.kt\ncom/intellij/jupyter/core/jupyter/connections/settings/state/JupyterVirtualFileConfigState$Companion\n*L\n60#1:66,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JupyterVirtualFileConfigState getInstance() {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
            ComponentManager $this$service$iv = (ComponentManager)application;
            boolean $i$f$service = false;
            Class<JupyterVirtualFileConfigState> serviceClass$iv = JupyterVirtualFileConfigState.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (JupyterVirtualFileConfigState)object;
        }

        private final String getFileId(VirtualFile $this$fileId) {
            Object object = $this$fileId instanceof VirtualFileWithId ? (VirtualFileWithId)$this$fileId : null;
            if (object == null || (object = Integer.valueOf(object.getId()).toString()) == null) {
                String string = $this$fileId.getPath();
                object = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            }
            return object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

