/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.core.impl.actions.tags;

import com.intellij.jupyter.core.core.impl.actions.JupyterActonUpdater;
import com.intellij.jupyter.core.core.impl.actions.select.NotebookCellLinesWithSelectionActionBase;
import com.intellij.jupyter.core.editor.ui.NotebookCellAddTagDialog;
import com.intellij.jupyter.core.fus.JupyterFusAddTagSource;
import com.intellij.jupyter.core.jupyter.helper.JupyterHelper;
import com.intellij.notebooks.ui.editor.actions.JupyterEditorAction;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookCellSelectionModel;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0014\u00a8\u0006\u0013"}, d2={"Lcom/intellij/jupyter/core/core/impl/actions/tags/NotebookCellAddTagAction;", "Lcom/intellij/jupyter/core/core/impl/actions/select/NotebookCellLinesWithSelectionActionBase;", "Lcom/intellij/openapi/actionSystem/remoting/ActionRemoteBehaviorSpecification$Frontend;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "cellLines", "Lcom/intellij/notebooks/visualization/NotebookCellLines;", "cellSelection", "Lcom/intellij/notebooks/visualization/NotebookCellSelectionModel;", "createActionUpdater", "Lcom/intellij/jupyter/core/core/impl/actions/JupyterActonUpdater;", "intellij.jupyter.core"})
public final class NotebookCellAddTagAction
extends NotebookCellLinesWithSelectionActionBase
implements ActionRemoteBehaviorSpecification.Frontend {
    @Override
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent event, @NotNull EditorImpl editor, @NotNull NotebookCellLines cellLines, @NotNull NotebookCellSelectionModel cellSelection) {
        NotebookCellLines.Interval interval;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)cellLines, (String)"cellLines");
        Intrinsics.checkNotNullParameter((Object)cellSelection, (String)"cellSelection");
        Project project = event.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        if (event.isFromContextMenu()) {
            DataContext dataContext = event.getDataContext();
            Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
            interval = JupyterHelper.INSTANCE.getHoveredInterval(dataContext);
        } else {
            interval = (NotebookCellLines.Interval)CollectionsKt.firstOrNull((List)cellSelection.getSelectedCells());
        }
        if (interval == null) {
            return;
        }
        NotebookCellLines.Interval interval2 = interval;
        NotebookCellAddTagDialog dialog2 = new NotebookCellAddTagDialog(project2, (Editor)editor, interval2.getOrdinal(), JupyterFusAddTagSource.CONTEXT_MENU);
        InputEvent inputEvent = event.getInputEvent();
        if (inputEvent instanceof MouseEvent) {
            dialog2.setLocation(((MouseEvent)inputEvent).getLocationOnScreen());
        }
        dialog2.show();
    }

    @Override
    @NotNull
    protected JupyterActonUpdater createActionUpdater() {
        return super.createActionUpdater().derive((Function1<? super JupyterActonUpdater.Builder, Unit>)((Function1)NotebookCellAddTagAction::createActionUpdater$lambda$1));
    }

    private static final boolean createActionUpdater$lambda$1$lambda$0(JupyterEditorAction action, AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        return Registry.Companion.is("jupyter.cell.metadata.tags", false);
    }

    private static final Unit createActionUpdater$lambda$1(JupyterActonUpdater.Builder $this$derive) {
        Intrinsics.checkNotNullParameter((Object)$this$derive, (String)"$this$derive");
        $this$derive.addEnabledAndVisibleProvider((Function2<? super JupyterEditorAction, ? super AnActionEvent, Boolean>)((Function2)NotebookCellAddTagAction::createActionUpdater$lambda$1$lambda$0));
        return Unit.INSTANCE;
    }
}

