/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.variables;

import com.intellij.icons.AllIcons;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.variables.common.JupyterVarsToolWindowPanel;
import com.intellij.jupyter.py.jupyterConsole.JupyterConsoleView;
import com.intellij.jupyter.py.variables.JupyterVariablesService;
import com.intellij.jupyter.py.variables.JupyterVarsFrameAccessor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ClickListener;
import com.intellij.ui.ListenerUtil;
import com.intellij.xdebugger.impl.frame.XStandaloneVariablesView;
import com.jetbrains.python.debugger.PyStackFrame;
import com.jetbrains.python.debugger.PyVariableViewSettings;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0015\u0016B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0014J\b\u0010\u0011\u001a\u00020\u000fH\u0014J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"Lcom/intellij/jupyter/py/variables/PythonJupyterVarsToolWindowPanel;", "Lcom/intellij/jupyter/core/jupyter/variables/common/JupyterVarsToolWindowPanel;", "project", "Lcom/intellij/openapi/project/Project;", "notebookFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "consoleView", "Lcom/intellij/jupyter/py/jupyterConsole/JupyterConsoleView;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;Lcom/intellij/jupyter/py/jupyterConsole/JupyterConsoleView;)V", "variablesService", "Lcom/intellij/jupyter/py/variables/JupyterVariablesService;", "getVariablesService", "()Lcom/intellij/jupyter/py/variables/JupyterVariablesService;", "initVariablesView", "", "onVariablesViewRebuilt", "clearInlineValuesData", "createActionToolbar", "frameAccessor", "Lcom/intellij/jupyter/py/variables/JupyterVarsFrameAccessor;", "RefreshAction", "ToggleConsoleVisibilityAction", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\nPythonJupyterVarsToolWindowPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PythonJupyterVarsToolWindowPanel.kt\ncom/intellij/jupyter/py/variables/PythonJupyterVarsToolWindowPanel\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,123:1\n30#2,2:124\n1#3:126\n*S KotlinDebug\n*F\n+ 1 PythonJupyterVarsToolWindowPanel.kt\ncom/intellij/jupyter/py/variables/PythonJupyterVarsToolWindowPanel\n*L\n31#1:124,2\n*E\n"})
public final class PythonJupyterVarsToolWindowPanel
extends JupyterVarsToolWindowPanel {
    @Nullable
    private final JupyterConsoleView consoleView;

    public PythonJupyterVarsToolWindowPanel(@NotNull Project project, @NotNull BackedNotebookVirtualFile notebookFile, @Nullable JupyterConsoleView consoleView) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)notebookFile, (String)"notebookFile");
        super(project, notebookFile);
        this.consoleView = consoleView;
    }

    private final JupyterVariablesService getVariablesService() {
        ComponentManager $this$service$iv = (ComponentManager)this.getProject();
        boolean $i$f$service = false;
        Class<JupyterVariablesService> serviceClass$iv = JupyterVariablesService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return (JupyterVariablesService)object;
    }

    public void initVariablesView() {
        this.removeAll();
        this.removeClickListener();
        Pair<PyStackFrame, JupyterVarsFrameAccessor> pair = this.getVariablesService().getStackFrameAndAccessor(this.getNotebookFile());
        if (pair == null) {
            return;
        }
        Pair<PyStackFrame, JupyterVarsFrameAccessor> pair2 = pair;
        PyStackFrame stackFrame = (PyStackFrame)pair2.component1();
        JupyterVarsFrameAccessor frameAccessor = (JupyterVarsFrameAccessor)pair2.component2();
        this.setVariablesView(this.getVariablesService().createVariablesView(this.getNotebookFile(), stackFrame));
        this.getVariablesService().createAndCallInlineCallback(this.getNotebookFile());
        XStandaloneVariablesView xStandaloneVariablesView = this.getVariablesView();
        if (xStandaloneVariablesView != null) {
            XStandaloneVariablesView it = xStandaloneVariablesView;
            boolean bl = false;
            Disposer.register((Disposable)((Disposable)this), (Disposable)((Disposable)it));
            this.add(it.getPanel(), "Center");
            this.setClickListener(new ClickListener(this){
                final /* synthetic */ PythonJupyterVarsToolWindowPanel this$0;
                {
                    this.this$0 = $receiver;
                }

                public boolean onClick(MouseEvent event, int clickCount) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    this.this$0.logViewUsage();
                    return false;
                }
            });
            ListenerUtil.addClickListener((Component)it.getPanel(), (ClickListener)this.getClickListener());
        }
        this.createActionToolbar(frameAccessor);
        this.validate();
        this.repaint();
    }

    protected void onVariablesViewRebuilt() {
        block0: {
            XStandaloneVariablesView xStandaloneVariablesView = this.getVariablesView();
            if (xStandaloneVariablesView == null) break block0;
            XStandaloneVariablesView it = xStandaloneVariablesView;
            boolean bl = false;
            this.getVariablesService().updateVariablesView(this.getNotebookFile(), it);
        }
    }

    protected void clearInlineValuesData() {
        this.getVariablesService().clearInlineValues(this.getNotebookFile());
    }

    private final void createActionToolbar(JupyterVarsFrameAccessor frameAccessor) {
        DefaultActionGroup toolbarActions = new DefaultActionGroup();
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("PythonJupyterVarsToolWindowPanel", (ActionGroup)toolbarActions, false);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"createActionToolbar(...)");
        ActionToolbar actionToolbar2 = actionToolbar;
        actionToolbar2.setTargetComponent((JComponent)((Object)this));
        this.add(actionToolbar2.getComponent(), "West");
        toolbarActions.add((AnAction)new RefreshAction(this));
        DefaultActionGroup settings = new DefaultActionGroup(JupyterBundle.message((String)"jupyter.toolbar.variables.settings.short.name", (Object[])new Object[0]), true);
        settings.getTemplatePresentation().setIcon(AllIcons.General.GearPlain);
        settings.add((AnAction)new PyVariableViewSettings.SimplifiedView(null));
        PyVariableViewSettings.VariablesPolicyGroup variablesPolicyGroup = new PyVariableViewSettings.VariablesPolicyGroup();
        variablesPolicyGroup.addValuesPolicyListener(() -> PythonJupyterVarsToolWindowPanel.createActionToolbar$lambda$2(frameAccessor));
        settings.add((AnAction)variablesPolicyGroup);
        toolbarActions.add((AnAction)settings);
        JupyterConsoleView jupyterConsoleView = this.consoleView;
        if (jupyterConsoleView != null) {
            JupyterConsoleView it = jupyterConsoleView;
            boolean bl = false;
            ToggleConsoleVisibilityAction toggleConsoleAction = new ToggleConsoleVisibilityAction(it);
            toolbarActions.add((AnAction)toggleConsoleAction);
        }
        this.setToolbar(actionToolbar2.getComponent());
    }

    private static final void createActionToolbar$lambda$2(JupyterVarsFrameAccessor $frameAccessor) {
        $frameAccessor.executeUpdateLoadingPolicyCommand();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/intellij/jupyter/py/variables/PythonJupyterVarsToolWindowPanel$RefreshAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "view", "Lcom/intellij/jupyter/py/variables/PythonJupyterVarsToolWindowPanel;", "<init>", "(Lcom/intellij/jupyter/py/variables/PythonJupyterVarsToolWindowPanel;)V", "getView", "()Lcom/intellij/jupyter/py/variables/PythonJupyterVarsToolWindowPanel;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.jupyter.py"})
    private static final class RefreshAction
    extends AnAction {
        @NotNull
        private final PythonJupyterVarsToolWindowPanel view;

        public RefreshAction(@NotNull PythonJupyterVarsToolWindowPanel view) {
            Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
            super(JupyterBundle.message((String)"jupyter.refresh.variables.title", (Object[])new Object[0]), JupyterBundle.message((String)"jupyter.refresh.variables.description", (Object[])new Object[0]), AllIcons.Actions.Refresh);
            this.view = view;
        }

        @NotNull
        public final PythonJupyterVarsToolWindowPanel getView() {
            return this.view;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project = e.getProject();
            String string = JupyterBundle.message((String)"jupyter.refresh.variables.description", (Object[])new Object[0]);
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(e, this, project, string){
                final /* synthetic */ AnActionEvent $e;
                final /* synthetic */ RefreshAction this$0;
                {
                    this.$e = $e;
                    this.this$0 = $receiver;
                    super($super_call_param$1, $super_call_param$2);
                }

                public void run(ProgressIndicator indicator) {
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    Object object = this.$e.getProject();
                    if (object != null) {
                        ComponentManager $this$service$iv = (ComponentManager)object;
                        boolean $i$f$service = false;
                        Class<JupyterVariablesService> serviceClass$iv = JupyterVariablesService.class;
                        Object object2 = $this$service$iv.getService(serviceClass$iv);
                        if (object2 == null) {
                            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                        }
                        object = (JupyterVariablesService)object2;
                        if (object != null) {
                            ((JupyterVariablesService)object).refreshEnv(this.this$0.getView().getNotebookFile());
                        }
                    }
                    this.this$0.getView().rebuildView();
                }
            });
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/jupyter/py/variables/PythonJupyterVarsToolWindowPanel$ToggleConsoleVisibilityAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "consoleView", "Lcom/intellij/jupyter/py/jupyterConsole/JupyterConsoleView;", "<init>", "(Lcom/intellij/jupyter/py/jupyterConsole/JupyterConsoleView;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.jupyter.py"})
    private static final class ToggleConsoleVisibilityAction
    extends AnAction {
        @NotNull
        private final JupyterConsoleView consoleView;

        public ToggleConsoleVisibilityAction(@NotNull JupyterConsoleView consoleView) {
            Intrinsics.checkNotNullParameter((Object)((Object)consoleView), (String)"consoleView");
            super(null, null, AllIcons.Debugger.Console);
            this.consoleView = consoleView;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.consoleView.setConsoleVisibility(!this.consoleView.isConsoleVisible());
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (this.consoleView.isConsoleVisible()) {
                e.getPresentation().setText(JupyterBundle.message((String)"jupyter.toggle.console.hide.title", (Object[])new Object[0]));
            } else {
                e.getPresentation().setText(JupyterBundle.message((String)"jupyter.toggle.console.show.title", (Object[])new Object[0]));
            }
        }
    }
}

