/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.editor;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.intellij.jupyter.core.jupyter.connections.execution.message.JupyterMessage;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.psi.PyLiteralExpression;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a*\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u00012\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a8\u0006\f"}, d2={"getLastFileOfPath", "", "completion", "insideLiteral", "", "getCompletionMatches", "", "message", "Lcom/intellij/jupyter/core/jupyter/connections/execution/message/JupyterMessage;", "qualifier", "parent", "Lcom/intellij/psi/PsiElement;", "intellij.jupyter.py"})
public final class JupyterPythonRuntimeCompletionContributorKt {
    private static final String getLastFileOfPath(String completion, boolean insideLiteral) {
        try {
            String file = ((Object)Path.of(completion, new String[0]).getFileName()).toString();
            if (Intrinsics.areEqual((Object)file, (Object)completion)) {
                return file;
            }
            return insideLiteral ? file : "";
        }
        catch (InvalidPathException invalidPathException) {
            return completion;
        }
    }

    @Nullable
    public static final List<String> getCompletionMatches(@NotNull JupyterMessage message2, @Nullable String qualifier, @NotNull PsiElement parent) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        JsonNode jsonNode = message2.getMessageContent().get("matches");
        ArrayNode arrayNode = jsonNode instanceof ArrayNode ? (ArrayNode)jsonNode : null;
        if (arrayNode == null) {
            return null;
        }
        ArrayNode matches = arrayNode;
        String string = qualifier;
        int qLength = string != null ? string.length() : 0;
        boolean insideLiteral = parent instanceof PyLiteralExpression;
        return CollectionsKt.distinct((Iterable)SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)matches)), JupyterPythonRuntimeCompletionContributorKt::getCompletionMatches$lambda$0), arg_0 -> JupyterPythonRuntimeCompletionContributorKt.getCompletionMatches$lambda$1(qualifier, qLength, insideLiteral, arg_0))));
    }

    private static final String getCompletionMatches$lambda$0(JsonNode it) {
        return it.toString();
    }

    private static final String getCompletionMatches$lambda$1(String $qualifier, int $qLength, boolean $insideLiteral, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.substring(1, it.length() - 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String completion = ((Object)StringsKt.trim((CharSequence)string)).toString();
        if (StringsKt.startsWith$default((String)completion, (String)"%", (boolean)false, (int)2, null)) {
            return null;
        }
        if ($qualifier != null) {
            if (StringsKt.startsWith$default((String)completion, (String)$qualifier, (boolean)false, (int)2, null)) {
                String string2 = completion.substring($qLength);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                completion = string2;
            }
            if (StringsKt.startsWith$default((String)completion, (String)".", (boolean)false, (int)2, null)) {
                String string3 = completion.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                completion = string3;
            }
        }
        if ($insideLiteral) {
            if (StringsKt.endsWith$default((String)completion, (String)"\\\"", (boolean)false, (int)2, null)) {
                completion = StringsKt.dropLast((String)completion, (int)2);
            } else if (StringsKt.endsWith$default((String)completion, (String)"'", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)completion, (String)"\"", (boolean)false, (int)2, null)) {
                String string4 = completion.substring(0, completion.length() - 1);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                completion = string4;
            }
        }
        if (((CharSequence)(completion = JupyterPythonRuntimeCompletionContributorKt.getLastFileOfPath(completion, $insideLiteral))).length() == 0) {
            return null;
        }
        return completion;
    }
}

