/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.diff.util;

import com.intellij.codeInsight.folding.impl.FoldingUtil;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.TextDiffType;
import com.intellij.jupyter.diff.util.JupyterDiffLineMarkerRenderer;
import com.intellij.notebooks.ui.visualization.NotebookEditorAppearanceUtils;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.LineSeparatorRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.DocumentUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0005+,-./B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005J(\u0010\r\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J>\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u0010J\u0016\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0005J\u0016\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\n\u001a\u00020\u000bJ\"\u0010$\u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010%\u001a\u00020&J\u001e\u0010'\u001a\u00020(2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010)\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/intellij/jupyter/diff/util/JupyterDiffDrawUtil;", "", "<init>", "()V", "STRIPE_LAYER", "", "LINE_MARKER_LAYER", "LAYER_PRIORITY_STEP", "determineLineGuardedBlockRelation", "Lcom/intellij/jupyter/diff/util/JupyterDiffDrawUtil$LineGuardedBlockRelation;", "editor", "Lcom/intellij/openapi/editor/Editor;", "lineNumber", "lineToY", "line", "lineStart", "", "includeInlays", "drawChunkBorderLine", "", "g", "Ljava/awt/Graphics2D;", "x1", "x2", "y", "color", "Ljava/awt/Color;", "doubleLine", "dottedLine", "getLayer", "layer", "layerPriority", "getStripeTextAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "type", "Lcom/intellij/diff/util/TextDiffType;", "getTextAttributes", "background", "Lcom/intellij/diff/util/DiffDrawUtil$BackgroundType;", "getGutterMarkerPaintRange", "Lcom/intellij/diff/util/DiffDrawUtil$MarkerRange;", "startLine", "endLine", "LineGuardedBlockRelation", "JupyterLineMarkerBuilder", "JupyterLineHighlighterBuilder", "DiffDefaultBorderRenderer", "AboveJupyterFoldDiffBorderRenderer", "intellij.jupyter.diff"})
public final class JupyterDiffDrawUtil {
    @NotNull
    public static final JupyterDiffDrawUtil INSTANCE = new JupyterDiffDrawUtil();
    public static final int STRIPE_LAYER = 4999;
    public static final int LINE_MARKER_LAYER = 5900;
    private static final int LAYER_PRIORITY_STEP = 5;

    private JupyterDiffDrawUtil() {
    }

    @NotNull
    public final LineGuardedBlockRelation determineLineGuardedBlockRelation(@NotNull Editor editor, int lineNumber) {
        LineGuardedBlockRelation lineGuardedBlockRelation;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Document document = editor.getDocument();
        Intrinsics.checkNotNull((Object)document, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.DocumentEx");
        DocumentEx document2 = (DocumentEx)document;
        List list = document2.getGuardedBlocks();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getGuardedBlocks(...)");
        List guardedBlocks = list;
        int intersectedBlockIndex = CollectionsKt.binarySearch$default((List)guardedBlocks, (int)0, (int)0, arg_0 -> JupyterDiffDrawUtil.determineLineGuardedBlockRelation$lambda$0(document2, lineNumber, arg_0), (int)3, null);
        if (intersectedBlockIndex >= 0) {
            RangeMarker block = (RangeMarker)guardedBlocks.get(intersectedBlockIndex);
            int blockStartLine = document2.getLineNumber(block.getStartOffset());
            int blockEndLine = document2.getLineNumber(block.getEndOffset());
            int n = lineNumber;
            lineGuardedBlockRelation = n == blockStartLine ? LineGuardedBlockRelation.UPPER_BOUNDARY : ((blockStartLine + 1 <= n ? n < blockEndLine : false) ? LineGuardedBlockRelation.WITHIN : (n == blockEndLine ? LineGuardedBlockRelation.LOWER_BOUNDARY : LineGuardedBlockRelation.NOT_INTERSECTING));
        } else {
            lineGuardedBlockRelation = LineGuardedBlockRelation.NOT_INTERSECTING;
        }
        return lineGuardedBlockRelation;
    }

    private final int lineToY(Editor editor, int line, boolean lineStart, boolean includeInlays) {
        if (line < 0) {
            return 0;
        }
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        if (line >= DiffUtil.getLineCount((Document)document2)) {
            int y = editor.logicalPositionToXY((LogicalPosition)editor.offsetToLogicalPosition((int)document2.getTextLength())).y;
            int tailLines = line - DiffUtil.getLineCount((Document)document2) + (lineStart ? 0 : 1);
            return y + editor.getLineHeight() * tailLines;
        }
        if (lineStart) {
            int visualLine = editor.offsetToVisualPosition((int)document2.getLineStartOffset((int)line), (boolean)false, (boolean)false).line;
            int inlay = includeInlays ? EditorUtil.getInlaysHeight((Editor)editor, (int)visualLine, (boolean)true) : 0;
            return editor.visualLineToY(visualLine) - inlay;
        }
        int visualLine = editor.offsetToVisualPosition((int)document2.getLineEndOffset((int)line), (boolean)true, (boolean)true).line;
        int inlay = includeInlays ? EditorUtil.getInlaysHeight((Editor)editor, (int)visualLine, (boolean)false) : 1;
        return editor.visualLineToY(visualLine) + editor.getLineHeight() + inlay;
    }

    public final void drawChunkBorderLine(@NotNull Graphics2D g, int x1, int x2, int y, @NotNull Color color, boolean doubleLine, boolean dottedLine) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        DiffDrawUtil.drawChunkBorderLine((Graphics2D)g, (int)x1, (int)x2, (int)y, (Color)color, (boolean)doubleLine, (boolean)dottedLine);
    }

    public final int getLayer(int layer, int layerPriority) {
        return layer + layerPriority * 5;
    }

    @NotNull
    public final TextAttributes getStripeTextAttributes(@NotNull TextDiffType type, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return (TextAttributes)new DiffDrawUtil.DiffStripeMarkerTextAttributes(type, editor);
    }

    @Nullable
    public final TextAttributes getTextAttributes(@NotNull TextDiffType type, @Nullable Editor editor, @NotNull DiffDrawUtil.BackgroundType background) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)background, (String)"background");
        if (background == DiffDrawUtil.BackgroundType.NONE) {
            return null;
        }
        return (TextAttributes)new DiffDrawUtil.DiffTextAttributes(background, type, editor);
    }

    @NotNull
    public final DiffDrawUtil.MarkerRange getGutterMarkerPaintRange(@NotNull Editor editor, int startLine, int endLine) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        int y1 = 0;
        int y2 = 0;
        LineGuardedBlockRelation status = this.determineLineGuardedBlockRelation(editor, startLine);
        if (startLine == endLine) {
            int n;
            if (startLine == 0) {
                n = this.lineToY(editor, 0, true, true) + 1;
            } else if (status != LineGuardedBlockRelation.NOT_INTERSECTING) {
                switch (WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
                    case 1: {
                        n = this.lineToY(editor, startLine, true, true) - NotebookEditorAppearanceUtils.INSTANCE.getJupyterCellSpacing(editor);
                        break;
                    }
                    case 2: {
                        n = this.lineToY(editor, startLine, true, true) + 1;
                        break;
                    }
                    default: {
                        n = this.lineToY(editor, startLine - 1, false, true) + 1;
                        break;
                    }
                }
            } else {
                n = this.lineToY(editor, startLine - 1, false, true);
            }
            y2 = y1 = n;
        } else {
            y1 = this.lineToY(editor, startLine, true, false);
            y2 = this.lineToY(editor, endLine - 1, false, false);
        }
        return new DiffDrawUtil.MarkerRange(y1, y2);
    }

    private static final int determineLineGuardedBlockRelation$lambda$0(DocumentEx $document, int $lineNumber, RangeMarker it) {
        int blockStartLine = $document.getLineNumber(it.getStartOffset());
        int blockEndLine = $document.getLineNumber(it.getEndOffset());
        return $lineNumber < blockStartLine ? 1 : ($lineNumber > blockEndLine ? -1 : 0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ(\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/jupyter/diff/util/JupyterDiffDrawUtil$AboveJupyterFoldDiffBorderRenderer;", "Lcom/intellij/openapi/editor/markup/LineSeparatorRenderer;", "myEditor", "Lcom/intellij/openapi/editor/Editor;", "myPlacement", "Lcom/intellij/openapi/editor/markup/SeparatorPlacement;", "myType", "Lcom/intellij/diff/util/TextDiffType;", "myDoubleLine", "", "myResolved", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/editor/markup/SeparatorPlacement;Lcom/intellij/diff/util/TextDiffType;ZZ)V", "drawLine", "", "g", "Ljava/awt/Graphics;", "x1", "", "x2", "y", "intellij.jupyter.diff"})
    private static final class AboveJupyterFoldDiffBorderRenderer
    implements LineSeparatorRenderer {
        @NotNull
        private final Editor myEditor;
        @NotNull
        private final SeparatorPlacement myPlacement;
        @NotNull
        private final TextDiffType myType;
        private final boolean myDoubleLine;
        private final boolean myResolved;

        public AboveJupyterFoldDiffBorderRenderer(@NotNull Editor myEditor, @NotNull SeparatorPlacement myPlacement, @NotNull TextDiffType myType, boolean myDoubleLine, boolean myResolved) {
            Intrinsics.checkNotNullParameter((Object)myEditor, (String)"myEditor");
            Intrinsics.checkNotNullParameter((Object)myPlacement, (String)"myPlacement");
            Intrinsics.checkNotNullParameter((Object)myType, (String)"myType");
            this.myEditor = myEditor;
            this.myPlacement = myPlacement;
            this.myType = myType;
            this.myDoubleLine = myDoubleLine;
            this.myResolved = myResolved;
        }

        public void drawLine(@NotNull Graphics g, int x1, int x2, int y) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Graphics2D g2d = (Graphics2D)g;
            Rectangle clip = g2d.getClipBounds();
            int newX2 = clip.x + clip.width;
            int cellSpacing = NotebookEditorAppearanceUtils.INSTANCE.getJupyterCellSpacing(this.myEditor);
            int newY = y - cellSpacing;
            if (this.myPlacement == SeparatorPlacement.BOTTOM) {
                newY -= cellSpacing - 1;
            }
            DiffDrawUtil.drawChunkBorderLine((Graphics2D)g2d, (int)x1, (int)newX2, (int)newY, (Color)this.myType.getColor(this.myEditor), (boolean)this.myDoubleLine, (boolean)this.myResolved);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B9\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014H\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/jupyter/diff/util/JupyterDiffDrawUtil$DiffDefaultBorderRenderer;", "Lcom/intellij/openapi/editor/markup/LineSeparatorRenderer;", "parentHighlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "editor", "Lcom/intellij/openapi/editor/Editor;", "placement", "Lcom/intellij/openapi/editor/markup/SeparatorPlacement;", "type", "Lcom/intellij/diff/util/TextDiffType;", "doubleLine", "", "resolved", "<init>", "(Lcom/intellij/openapi/editor/markup/RangeHighlighter;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/editor/markup/SeparatorPlacement;Lcom/intellij/diff/util/TextDiffType;ZZ)V", "drawLine", "", "g", "Ljava/awt/Graphics;", "x1", "", "x2", "y", "intellij.jupyter.diff"})
    public static final class DiffDefaultBorderRenderer
    implements LineSeparatorRenderer {
        @Nullable
        private final RangeHighlighter parentHighlighter;
        @NotNull
        private final Editor editor;
        @NotNull
        private final SeparatorPlacement placement;
        @NotNull
        private final TextDiffType type;
        private final boolean doubleLine;
        private final boolean resolved;

        public DiffDefaultBorderRenderer(@Nullable RangeHighlighter parentHighlighter, @NotNull Editor editor, @NotNull SeparatorPlacement placement, @NotNull TextDiffType type, boolean doubleLine, boolean resolved) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)placement, (String)"placement");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            this.parentHighlighter = parentHighlighter;
            this.editor = editor;
            this.placement = placement;
            this.type = type;
            this.doubleLine = doubleLine;
            this.resolved = resolved;
        }

        public void drawLine(@NotNull Graphics g, int x1, int x2, int y) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            if (this.parentHighlighter != null && FoldingUtil.isHighlighterFolded((Editor)this.editor, (RangeHighlighter)this.parentHighlighter)) {
                return;
            }
            Rectangle clip = g.getClipBounds();
            int x2Adjusted = clip.x + clip.width;
            int yAdjusted = y;
            if (this.placement == SeparatorPlacement.TOP) {
                ++yAdjusted;
            }
            Graphics2D graphics2D = (Graphics2D)g;
            Color color = this.type.getColor(this.editor);
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getColor(...)");
            INSTANCE.drawChunkBorderLine(graphics2D, x1, x2Adjusted, yAdjusted, color, this.doubleLine, this.resolved);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\fJ\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\fJ\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\fJ\u000e\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010 0\u001fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/jupyter/diff/util/JupyterDiffDrawUtil$JupyterLineHighlighterBuilder;", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "startLine", "", "endLine", "type", "Lcom/intellij/diff/util/TextDiffType;", "<init>", "(Lcom/intellij/openapi/editor/Editor;IILcom/intellij/diff/util/TextDiffType;)V", "ignored", "", "resolved", "excludedInEditor", "excludedInGutter", "hideWithoutLineNumbers", "hideStripeMarkers", "hideGutterMarkers", "alignedSides", "layerPriority", "fixedEditorMode", "Lcom/intellij/diff/util/DiffDrawUtil$PaintMode;", "fixedGutterMode", "withIgnored", "withExcludedInEditor", "excluded", "withExcludedInGutter", "withAlignedSides", "aligned", "done", "", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "intellij.jupyter.diff"})
    public static final class JupyterLineHighlighterBuilder {
        @NotNull
        private final Editor editor;
        private final int startLine;
        private final int endLine;
        @NotNull
        private final TextDiffType type;
        private boolean ignored;
        private boolean resolved;
        private boolean excludedInEditor;
        private boolean excludedInGutter;
        private boolean hideWithoutLineNumbers;
        private boolean hideStripeMarkers;
        private boolean hideGutterMarkers;
        private boolean alignedSides;
        private int layerPriority;
        @Nullable
        private DiffDrawUtil.PaintMode fixedEditorMode;
        @Nullable
        private DiffDrawUtil.PaintMode fixedGutterMode;

        public JupyterLineHighlighterBuilder(@NotNull Editor editor, int startLine, int endLine, @NotNull TextDiffType type) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            this.editor = editor;
            this.startLine = startLine;
            this.endLine = endLine;
            this.type = type;
        }

        @NotNull
        public final JupyterLineHighlighterBuilder withIgnored(boolean ignored) {
            this.ignored = ignored;
            return this;
        }

        @NotNull
        public final JupyterLineHighlighterBuilder withExcludedInEditor(boolean excluded) {
            this.excludedInEditor = excluded;
            return this;
        }

        @NotNull
        public final JupyterLineHighlighterBuilder withExcludedInGutter(boolean excluded) {
            this.excludedInGutter = excluded;
            return this;
        }

        @NotNull
        public final JupyterLineHighlighterBuilder withAlignedSides(boolean aligned) {
            this.alignedSides = aligned;
            return this;
        }

        @NotNull
        public final List<RangeHighlighter> done() {
            TextAttributes textAttributes;
            List highlighters = new ArrayList();
            DiffDrawUtil.PaintMode editorMode = DiffDrawUtil.PaintMode.DEFAULT;
            DiffDrawUtil.PaintMode gutterMode = DiffDrawUtil.PaintMode.DEFAULT;
            if (this.ignored) {
                editorMode = DiffDrawUtil.PaintMode.IGNORED;
            }
            if (this.excludedInEditor) {
                editorMode = DiffDrawUtil.PaintMode.EXCLUDED_EDITOR;
            }
            if (this.excludedInGutter) {
                gutterMode = DiffDrawUtil.PaintMode.EXCLUDED_GUTTER;
            }
            if (this.resolved) {
                editorMode = DiffDrawUtil.PaintMode.RESOLVED;
                gutterMode = DiffDrawUtil.PaintMode.RESOLVED;
            }
            if (this.fixedEditorMode != null) {
                editorMode = this.fixedEditorMode;
            }
            if (this.fixedGutterMode != null) {
                gutterMode = this.fixedGutterMode;
            }
            boolean isEmptyRange = this.startLine == this.endLine;
            boolean isFirstLine = this.startLine == 0;
            LineGuardedBlockRelation status = INSTANCE.determineLineGuardedBlockRelation(this.editor, this.startLine);
            boolean isLastLine = this.endLine == DiffUtil.getLineCount((Document)this.editor.getDocument());
            TextRange offsets = DiffUtil.getLinesRange((Document)this.editor.getDocument(), (int)this.startLine, (int)this.endLine);
            int start = offsets.getStartOffset();
            int end = offsets.getEndOffset();
            if (isEmptyRange) {
                textAttributes = null;
            } else {
                DiffDrawUtil.BackgroundType backgroundType = editorMode.background;
                Intrinsics.checkNotNullExpressionValue((Object)backgroundType, (String)"background");
                textAttributes = INSTANCE.getTextAttributes(this.type, this.editor, backgroundType);
            }
            TextAttributes attributes = textAttributes;
            TextAttributes stripeAttributes = this.hideStripeMarkers || editorMode.background == DiffDrawUtil.BackgroundType.NONE ? null : INSTANCE.getStripeTextAttributes(this.type, this.editor);
            boolean dottedLine = editorMode.border == DiffDrawUtil.BorderType.DOTTED;
            RangeHighlighter rangeHighlighter = this.editor.getMarkupModel().addRangeHighlighter(start, end, INSTANCE.getLayer(5898, this.layerPriority), attributes, HighlighterTargetArea.LINES_IN_RANGE);
            Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter, (String)"addRangeHighlighter(...)");
            RangeHighlighter highlighter = rangeHighlighter;
            highlighters.add(highlighter);
            if (!this.hideGutterMarkers) {
                DiffDrawUtil.PaintMode paintMode = editorMode;
                Intrinsics.checkNotNull((Object)paintMode);
                DiffDrawUtil.PaintMode paintMode2 = gutterMode;
                Intrinsics.checkNotNull((Object)paintMode2);
                highlighter.setLineMarkerRenderer((LineMarkerRenderer)new JupyterDiffLineMarkerRenderer(highlighter, this.type, paintMode, paintMode2, this.hideWithoutLineNumbers, isEmptyRange, isFirstLine, isLastLine, this.alignedSides));
            }
            if (isEmptyRange && !this.alignedSides) {
                JupyterLineMarkerBuilder builder = null;
                if (isFirstLine) {
                    builder = new JupyterLineMarkerBuilder(this.editor, 0, SeparatorPlacement.TOP, this.layerPriority);
                    v4 = builder.withDefaultRenderer(this.type, true, dottedLine, highlighter);
                } else if (status != LineGuardedBlockRelation.NOT_INTERSECTING) {
                    switch (WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
                        case 1: {
                            builder = new JupyterLineMarkerBuilder(this.editor, this.startLine, SeparatorPlacement.BOTTOM, this.layerPriority);
                            v4 = builder.withJupyterRenderer(this.type, true, dottedLine);
                            break;
                        }
                        case 2: {
                            builder = new JupyterLineMarkerBuilder(this.editor, this.startLine, SeparatorPlacement.TOP, this.layerPriority);
                            v4 = builder.withJupyterRenderer(this.type, true, dottedLine);
                            break;
                        }
                        case 3: {
                            builder = new JupyterLineMarkerBuilder(this.editor, this.startLine, SeparatorPlacement.TOP, this.layerPriority);
                            v4 = builder.withDefaultRenderer(this.type, true, dottedLine, highlighter);
                            break;
                        }
                        default: {
                            builder = new JupyterLineMarkerBuilder(this.editor, this.startLine - 1, SeparatorPlacement.BOTTOM, this.layerPriority);
                            v4 = builder.withDefaultRenderer(this.type, true, dottedLine, highlighter);
                            break;
                        }
                    }
                } else {
                    builder = new JupyterLineMarkerBuilder(this.editor, this.startLine - 1, SeparatorPlacement.BOTTOM, this.layerPriority);
                    v4 = builder.withDefaultRenderer(this.type, true, dottedLine, highlighter);
                }
                highlighters.addAll((Collection)builder.done());
            } else if (editorMode.border != DiffDrawUtil.BorderType.NONE && !this.alignedSides) {
                JupyterLineMarkerBuilder firstLineBuilder = new JupyterLineMarkerBuilder(this.editor, this.startLine, SeparatorPlacement.TOP, this.layerPriority).withDefaultRenderer(this.type, false, dottedLine, highlighter);
                JupyterLineMarkerBuilder secondLineBuilder = new JupyterLineMarkerBuilder(this.editor, this.endLine - 1, SeparatorPlacement.BOTTOM, this.layerPriority).withDefaultRenderer(this.type, false, dottedLine, highlighter);
                highlighters.addAll((Collection)firstLineBuilder.done());
                highlighters.addAll((Collection)secondLineBuilder.done());
            }
            if (stripeAttributes != null) {
                RangeHighlighter rangeHighlighter2 = this.editor.getMarkupModel().addRangeHighlighter(start, end, 4999, stripeAttributes, HighlighterTargetArea.LINES_IN_RANGE);
                Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter2, (String)"addRangeHighlighter(...)");
                RangeHighlighter stripeHighlighter = rangeHighlighter2;
                highlighters.add(stripeHighlighter);
            }
            return highlighters;
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[LineGuardedBlockRelation.values().length];
                try {
                    nArray[LineGuardedBlockRelation.UPPER_BOUNDARY.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LineGuardedBlockRelation.WITHIN.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LineGuardedBlockRelation.LOWER_BOUNDARY.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0014\u001a\u00020\u00002\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ(\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\b\u0010\u001b\u001a\u0004\u0018\u00010\rJ\u001e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019J\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\r0\u001eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/jupyter/diff/util/JupyterDiffDrawUtil$JupyterLineMarkerBuilder;", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "line", "", "placement", "Lcom/intellij/openapi/editor/markup/SeparatorPlacement;", "layerPriority", "<init>", "(Lcom/intellij/openapi/editor/Editor;ILcom/intellij/openapi/editor/markup/SeparatorPlacement;I)V", "offset", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "lineRenderer", "Lcom/intellij/openapi/editor/markup/LineSeparatorRenderer;", "gutterRenderer", "Lcom/intellij/openapi/editor/markup/LineMarkerRenderer;", "stripeAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "withRenderer", "withDefaultRenderer", "type", "Lcom/intellij/diff/util/TextDiffType;", "doubleLine", "", "dottedLine", "parentHighlighter", "withJupyterRenderer", "done", "", "intellij.jupyter.diff"})
    public static final class JupyterLineMarkerBuilder {
        @NotNull
        private final Editor editor;
        @NotNull
        private final SeparatorPlacement placement;
        private final int offset;
        @NotNull
        private final RangeHighlighter highlighter;
        @Nullable
        private LineSeparatorRenderer lineRenderer;
        @Nullable
        private LineMarkerRenderer gutterRenderer;
        @Nullable
        private TextAttributes stripeAttributes;

        public JupyterLineMarkerBuilder(@NotNull Editor editor, int line, @NotNull SeparatorPlacement placement, int layerPriority) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)placement, (String)"placement");
            this.editor = editor;
            this.placement = placement;
            this.offset = DocumentUtil.getFirstNonSpaceCharOffset((Document)this.editor.getDocument(), (int)line);
            RangeHighlighter rangeHighlighter = this.editor.getMarkupModel().addRangeHighlighter(null, this.offset, this.offset, INSTANCE.getLayer(5900, layerPriority), HighlighterTargetArea.LINES_IN_RANGE);
            Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter, (String)"addRangeHighlighter(...)");
            this.highlighter = rangeHighlighter;
        }

        public /* synthetic */ JupyterLineMarkerBuilder(Editor editor, int n, SeparatorPlacement separatorPlacement, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 8) != 0) {
                n2 = 0;
            }
            this(editor, n, separatorPlacement, n2);
        }

        @NotNull
        public final JupyterLineMarkerBuilder withRenderer(@Nullable LineSeparatorRenderer lineRenderer) {
            this.lineRenderer = lineRenderer;
            return this;
        }

        @NotNull
        public final JupyterLineMarkerBuilder withDefaultRenderer(@NotNull TextDiffType type, boolean doubleLine, boolean dottedLine, @Nullable RangeHighlighter parentHighlighter) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            RangeHighlighter rangeHighlighter = parentHighlighter;
            if (rangeHighlighter == null) {
                rangeHighlighter = this.highlighter;
            }
            RangeHighlighter parent = rangeHighlighter;
            return this.withRenderer(new DiffDefaultBorderRenderer(parent, this.editor, this.placement, type, doubleLine, dottedLine));
        }

        @NotNull
        public final JupyterLineMarkerBuilder withJupyterRenderer(@NotNull TextDiffType type, boolean doubleLine, boolean dottedLine) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            return this.withRenderer(new AboveJupyterFoldDiffBorderRenderer(this.editor, this.placement, type, doubleLine, dottedLine));
        }

        @NotNull
        public final List<RangeHighlighter> done() {
            this.highlighter.setLineSeparatorPlacement(this.placement);
            this.highlighter.setLineSeparatorRenderer(this.lineRenderer);
            this.highlighter.setLineMarkerRenderer(this.gutterRenderer);
            if (this.stripeAttributes == null) {
                return CollectionsKt.listOf((Object)this.highlighter);
            }
            RangeHighlighter rangeHighlighter = this.editor.getMarkupModel().addRangeHighlighter(this.offset, this.offset, 4999, this.stripeAttributes, HighlighterTargetArea.LINES_IN_RANGE);
            Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter, (String)"addRangeHighlighter(...)");
            RangeHighlighter stripeHighlighter = rangeHighlighter;
            Object[] objectArray = new RangeHighlighter[]{this.highlighter, stripeHighlighter};
            return CollectionsKt.listOf((Object[])objectArray);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/jupyter/diff/util/JupyterDiffDrawUtil$LineGuardedBlockRelation;", "", "<init>", "(Ljava/lang/String;I)V", "NOT_INTERSECTING", "UPPER_BOUNDARY", "LOWER_BOUNDARY", "WITHIN", "intellij.jupyter.diff"})
    public static final class LineGuardedBlockRelation
    extends Enum<LineGuardedBlockRelation> {
        public static final /* enum */ LineGuardedBlockRelation NOT_INTERSECTING = new LineGuardedBlockRelation();
        public static final /* enum */ LineGuardedBlockRelation UPPER_BOUNDARY = new LineGuardedBlockRelation();
        public static final /* enum */ LineGuardedBlockRelation LOWER_BOUNDARY = new LineGuardedBlockRelation();
        public static final /* enum */ LineGuardedBlockRelation WITHIN = new LineGuardedBlockRelation();
        private static final /* synthetic */ LineGuardedBlockRelation[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static LineGuardedBlockRelation[] values() {
            return (LineGuardedBlockRelation[])$VALUES.clone();
        }

        public static LineGuardedBlockRelation valueOf(String value) {
            return Enum.valueOf(LineGuardedBlockRelation.class, value);
        }

        @NotNull
        public static EnumEntries<LineGuardedBlockRelation> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = lineGuardedBlockRelationArray = new LineGuardedBlockRelation[]{LineGuardedBlockRelation.NOT_INTERSECTING, LineGuardedBlockRelation.UPPER_BOUNDARY, LineGuardedBlockRelation.LOWER_BOUNDARY, LineGuardedBlockRelation.WITHIN};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LineGuardedBlockRelation.values().length];
            try {
                nArray[LineGuardedBlockRelation.WITHIN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LineGuardedBlockRelation.LOWER_BOUNDARY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

