/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.preferences;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.PersistentList;
import kotlinx.collections.immutable.PersistentSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.textmate.Constants;
import org.jetbrains.plugins.textmate.MultiplatformKt;
import org.jetbrains.plugins.textmate.language.preferences.Preferences;
import org.jetbrains.plugins.textmate.language.preferences.PreferencesRegistry;
import org.jetbrains.plugins.textmate.language.preferences.PreferencesRegistryImpl;
import org.jetbrains.plugins.textmate.language.preferences.TextMateAutoClosingPair;
import org.jetbrains.plugins.textmate.language.preferences.TextMateBracePair;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateSelectorWeigher;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\tJ\u0018\u0010\u0013\u001a\u00020\u00122\u000e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0015H\u0002J\u0018\u0010\u0017\u001a\u00020\u00122\u000e\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u0015H\u0002J\u0006\u0010\u001a\u001a\u00020\u001bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u001c\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u001c\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u001c\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u001c\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/plugins/textmate/language/preferences/PreferencesRegistryBuilder;", "", "weigher", "Lorg/jetbrains/plugins/textmate/language/syntax/selector/TextMateSelectorWeigher;", "<init>", "(Lorg/jetbrains/plugins/textmate/language/syntax/selector/TextMateSelectorWeigher;)V", "preferences", "Lkotlin/concurrent/atomics/AtomicReference;", "Lkotlinx/collections/immutable/PersistentList;", "Lorg/jetbrains/plugins/textmate/language/preferences/Preferences;", "Ljava/util/concurrent/atomic/AtomicReference;", "leftHighlightingBraces", "Lkotlinx/collections/immutable/PersistentSet;", "", "rightHighlightingBraces", "leftSmartTypingBraces", "rightSmartTypingBraces", "add", "", "fillHighlightingBraces", "highlightingPairs", "", "Lorg/jetbrains/plugins/textmate/language/preferences/TextMateBracePair;", "fillSmartTypingBraces", "smartTypingPairs", "Lorg/jetbrains/plugins/textmate/language/preferences/TextMateAutoClosingPair;", "build", "Lorg/jetbrains/plugins/textmate/language/preferences/PreferencesRegistry;", "intellij.textmate.core"})
public final class PreferencesRegistryBuilder {
    @NotNull
    private final TextMateSelectorWeigher weigher;
    @NotNull
    private final AtomicReference<PersistentList<Preferences>> preferences;
    @NotNull
    private final AtomicReference<PersistentSet<Integer>> leftHighlightingBraces;
    @NotNull
    private final AtomicReference<PersistentSet<Integer>> rightHighlightingBraces;
    @NotNull
    private final AtomicReference<PersistentSet<Integer>> leftSmartTypingBraces;
    @NotNull
    private final AtomicReference<PersistentSet<Integer>> rightSmartTypingBraces;

    public PreferencesRegistryBuilder(@NotNull TextMateSelectorWeigher weigher) {
        Intrinsics.checkNotNullParameter((Object)weigher, (String)"weigher");
        this.weigher = weigher;
        this.preferences = new AtomicReference<PersistentList>(ExtensionsKt.persistentListOf());
        this.leftHighlightingBraces = new AtomicReference<PersistentSet>(ExtensionsKt.persistentSetOf());
        this.rightHighlightingBraces = new AtomicReference<PersistentSet>(ExtensionsKt.persistentSetOf());
        this.leftSmartTypingBraces = new AtomicReference<PersistentSet>(ExtensionsKt.persistentSetOf());
        this.rightSmartTypingBraces = new AtomicReference<PersistentSet>(ExtensionsKt.persistentSetOf());
    }

    public final void add(@NotNull Preferences preferences) {
        Intrinsics.checkNotNullParameter((Object)preferences, (String)"preferences");
        this.fillHighlightingBraces((Collection<TextMateBracePair>)preferences.getHighlightingPairs());
        this.fillSmartTypingBraces((Collection<TextMateAutoClosingPair>)preferences.getSmartTypingPairs());
        MultiplatformKt.update(this.preferences, arg_0 -> PreferencesRegistryBuilder.add$lambda$0(preferences, arg_0));
    }

    private final void fillHighlightingBraces(Collection<TextMateBracePair> highlightingPairs) {
        if (highlightingPairs != null) {
            for (TextMateBracePair pair : highlightingPairs) {
                if (!(((CharSequence)pair.getLeft()).length() == 0)) {
                    MultiplatformKt.update(this.leftHighlightingBraces, arg_0 -> PreferencesRegistryBuilder.fillHighlightingBraces$lambda$1(pair, arg_0));
                }
                if (((CharSequence)pair.getRight()).length() == 0) continue;
                MultiplatformKt.update(this.rightHighlightingBraces, arg_0 -> PreferencesRegistryBuilder.fillHighlightingBraces$lambda$2(pair, arg_0));
            }
        }
    }

    private final void fillSmartTypingBraces(Collection<TextMateAutoClosingPair> smartTypingPairs) {
        if (smartTypingPairs != null) {
            for (TextMateAutoClosingPair pair : smartTypingPairs) {
                if (!(pair.getLeft().length() == 0)) {
                    MultiplatformKt.update(this.leftSmartTypingBraces, arg_0 -> PreferencesRegistryBuilder.fillSmartTypingBraces$lambda$3(pair, arg_0));
                }
                if (pair.getRight().length() == 0) continue;
                MultiplatformKt.update(this.rightSmartTypingBraces, arg_0 -> PreferencesRegistryBuilder.fillSmartTypingBraces$lambda$4(pair, arg_0));
            }
        }
    }

    @NotNull
    public final PreferencesRegistry build() {
        this.fillHighlightingBraces((Collection<TextMateBracePair>)Constants.Companion.getDEFAULT_HIGHLIGHTING_BRACE_PAIRS());
        this.fillSmartTypingBraces((Collection<TextMateAutoClosingPair>)Constants.Companion.getDEFAULT_SMART_TYPING_BRACE_PAIRS());
        return new PreferencesRegistryImpl(this.weigher, (Collection)this.preferences.get(), (Set)this.leftHighlightingBraces.get(), (Set)this.rightHighlightingBraces.get(), (Set)this.leftSmartTypingBraces.get(), (Set)this.rightSmartTypingBraces.get());
    }

    private static final PersistentList add$lambda$0(Preferences $preferences, PersistentList it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.add((Object)$preferences);
    }

    private static final PersistentSet fillHighlightingBraces$lambda$1(TextMateBracePair $pair, PersistentSet it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.add((Object)$pair.getLeft().charAt(0));
    }

    private static final PersistentSet fillHighlightingBraces$lambda$2(TextMateBracePair $pair, PersistentSet it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.add((Object)$pair.getRight().charAt($pair.getRight().length() - 1));
    }

    private static final PersistentSet fillSmartTypingBraces$lambda$3(TextMateAutoClosingPair $pair, PersistentSet it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.add((Object)$pair.getLeft().charAt($pair.getLeft().length() - 1));
    }

    private static final PersistentSet fillSmartTypingBraces$lambda$4(TextMateAutoClosingPair $pair, PersistentSet it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.add((Object)$pair.getRight().charAt($pair.getRight().length() - 1));
    }
}

