/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import git4idea.branch.GitBrancher;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.GitBranchPopupActions;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0019"}, d2={"Lgit4idea/ui/branch/GitRebaseOntoCommitAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "myProject", "Lcom/intellij/openapi/project/Project;", "repository", "Lgit4idea/repo/GitRepository;", "commitId", "Lcom/intellij/vcs/log/CommitId;", "<init>", "(Lcom/intellij/openapi/project/Project;Lgit4idea/repo/GitRepository;Lcom/intellij/vcs/log/CommitId;)V", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "getRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "hash", "Lcom/intellij/vcs/log/Hash;", "getHash", "()Lcom/intellij/vcs/log/Hash;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "intellij.vcs.git"})
@ApiStatus.Internal
public final class GitRebaseOntoCommitAction
extends DumbAwareAction {
    @NotNull
    private final Project myProject;
    @NotNull
    private final GitRepository repository;
    @NotNull
    private final CommitId commitId;

    public GitRebaseOntoCommitAction(@NotNull Project myProject, @NotNull GitRepository repository2, @NotNull CommitId commitId) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)commitId, (String)"commitId");
        this.myProject = myProject;
        this.repository = repository2;
        this.commitId = commitId;
    }

    private final VirtualFile getRoot() {
        VirtualFile virtualFile = this.commitId.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
        return virtualFile;
    }

    private final Hash getHash() {
        Hash hash = this.commitId.getHash();
        Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"getHash(...)");
        return hash;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        String string = this.getHash().toShortString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toShortString(...)");
        String shortHash = string;
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
        Presentation p = presentation;
        String string2 = GitBranchPopupActions.getCurrentBranchTruncatedPresentation(this.myProject, CollectionsKt.listOf((Object)this.repository));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getCurrentBranchTruncatedPresentation(...)");
        String truncatedBranch = string2;
        Object[] objectArray = new Object[]{truncatedBranch};
        String string3 = GitBundle.message((String)"branches.rebase.onto.selected.commit", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        String actionText = string3;
        p.setText(actionText);
        boolean isOnBranch = this.repository.isOnBranch();
        if (!isOnBranch) {
            p.setDescription(GitBundle.message((String)"branches.rebase.is.not.possible.in.the.detached.head.state", (Object[])new Object[0]));
            p.setVisible(true);
            p.setEnabled(false);
            return;
        }
        objectArray = new Object[]{truncatedBranch, shortHash};
        p.setDescription(GitBundle.message((String)"branches.rebase.onto", (Object[])objectArray));
        p.setEnabledAndVisible(true);
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        VcsLogData vcsLogData = (VcsLogData)VcsLogInternalDataKeys.LOG_DATA.getData(dataContext);
        if (vcsLogData == null) {
            return;
        }
        VcsLogData logData = vcsLogData;
        Predicate currentBranchCondition = logData.getContainingBranchesGetter().getContainedInCurrentBranchCondition(this.getRoot());
        int commitIndex = logData.getCommitIndex(this.getHash(), this.getRoot());
        boolean isCommitInCurrentBranch = currentBranchCondition.test(commitIndex);
        String string4 = logData.getMiniDetailsGetter().getCommitData(commitIndex, (Iterable)SetsKt.setOf((Object)commitIndex)).getSubject();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getSubject(...)");
        String subject = string4;
        Object[] objectArray2 = new Object[]{truncatedBranch, shortHash + " \"" + subject + "\""};
        p.setDescription(GitBundle.message((String)"branches.rebase.onto", (Object[])objectArray2));
        p.setEnabledAndVisible(!isCommitInCurrentBranch);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        GitBrancher.getInstance(this.myProject).rebase((List<? extends GitRepository>)CollectionsKt.listOf((Object)this.repository), this.getHash().asString());
    }
}

