/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pycharm.community.ide.impl.newProjectWizard.welcome;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.DirectoryProjectConfigurator;
import com.intellij.pycharm.community.ide.impl.newProjectWizard.welcome.PyWelcome;
import com.intellij.pycharm.community.ide.impl.newProjectWizard.welcome.PyWelcomeCollector;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lcom/intellij/pycharm/community/ide/impl/newProjectWizard/welcome/PyWelcomeConfigurator;", "Lcom/intellij/platform/DirectoryProjectConfigurator;", "<init>", "()V", "isEdtRequired", "", "()Z", "configureProject", "", "project", "Lcom/intellij/openapi/project/Project;", "baseDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "moduleRef", "Lcom/intellij/openapi/util/Ref;", "Lcom/intellij/openapi/module/Module;", "isProjectCreatedWithWizard", "isInsideTempDirectory", "intellij.pycharm.community.ide.impl"})
public final class PyWelcomeConfigurator
implements DirectoryProjectConfigurator {
    public boolean isEdtRequired() {
        return false;
    }

    public void configureProject(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull Ref<Module> moduleRef, boolean isProjectCreatedWithWizard) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
        Intrinsics.checkNotNullParameter(moduleRef, (String)"moduleRef");
        if (isProjectCreatedWithWizard || this.isInsideTempDirectory(baseDir)) {
            return;
        }
        StartupManager.getInstance((Project)project).runAfterOpened((Runnable)((DumbAwareRunnable)() -> PyWelcomeConfigurator.configureProject$lambda$0(project, baseDir, moduleRef)));
    }

    private final boolean isInsideTempDirectory(VirtualFile baseDir) {
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(FileUtil.getTempDirectory());
        if (virtualFile == null) {
            return false;
        }
        VirtualFile tempDir = virtualFile;
        return VfsUtil.isAncestor((VirtualFile)tempDir, (VirtualFile)baseDir, (boolean)true);
    }

    private static final void configureProject$lambda$0(Project $project, VirtualFile $baseDir, Ref $moduleRef) {
        PyWelcomeCollector.INSTANCE.logWelcomeProject$intellij_pycharm_community_ide_impl($project, PyWelcomeCollector.ProjectType.OPENED);
        PyWelcome.INSTANCE.welcomeUser($project, $baseDir, (Module)$moduleRef.get());
    }
}

