/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.impl.VcsLogNavigationUtil;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import com.intellij.vcs.log.ui.VcsLogUiEx;
import com.intellij.vcs.log.ui.frame.CommitPresentationUtil;
import com.intellij.vcs.log.ui.table.VcsLogCommitList;
import com.intellij.vcs.log.ui.table.VcsLogCommitListKt;
import com.intellij.vcs.log.ui.table.VcsLogCommitListModel;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0010\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\"\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0010\u0010\u0013\u001a\f\u0012\b\u0012\u00060\u0015j\u0002`\u00160\u0014H\u0002J\u0014\u0010\u0017\u001a\u00020\u000b*\u00020\u00012\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0018\u001a\u00020\u0019*\u00020\u001a2\n\u0010\u001b\u001a\u00060\u0015j\u0002`\u0016H\u0003J\u001a\u0010\u001c\u001a\f\u0012\b\u0012\u00060\u0015j\u0002`\u00160\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001d"}, d2={"Lcom/intellij/vcs/log/ui/actions/GoToParentOrChildAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "parent", "", "<init>", "(Z)V", "getParent", "()Z", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "createGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "ui", "Lcom/intellij/vcs/log/ui/VcsLogUiEx;", "rows", "", "", "Lcom/intellij/vcs/log/graph/VcsLogVisibleGraphIndex;", "triggerUsage", "getActionText", "", "Lcom/intellij/vcs/log/ui/table/VcsLogCommitListModel;", "row", "getRowsToJump", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nGoToParentOrChildAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoToParentOrChildAction.kt\ncom/intellij/vcs/log/ui/actions/GoToParentOrChildAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,117:1\n1634#2,3:118\n*S KotlinDebug\n*F\n+ 1 GoToParentOrChildAction.kt\ncom/intellij/vcs/log/ui/actions/GoToParentOrChildAction\n*L\n74#1:118,3\n*E\n"})
public class GoToParentOrChildAction
extends DumbAwareAction {
    private final boolean parent;

    public GoToParentOrChildAction(boolean parent) {
        this.parent = parent;
    }

    public final boolean getParent() {
        return this.parent;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void update(@NotNull AnActionEvent e) {
        VcsLogUiEx ui;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Object object = e.getData(VcsLogDataKeys.VCS_LOG_UI);
        VcsLogUiEx vcsLogUiEx = ui = object instanceof VcsLogUiEx ? (VcsLogUiEx)object : null;
        if (ui == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setVisible(true);
        VcsLogCommitList vcsLogCommitList = ui.getTable();
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogCommitList, (String)"getTable(...)");
        VcsLogCommitList table = vcsLogCommitList;
        if (e.getInputEvent() instanceof KeyEvent && table instanceof Component) {
            e.getPresentation().setEnabled(((Component)((Object)table)).isFocusOwner());
        } else {
            e.getPresentation().setEnabled(!((Collection)this.getRowsToJump(ui)).isEmpty());
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.triggerUsage(this, e);
        Object object = e.getData(VcsLogDataKeys.VCS_LOG_UI);
        VcsLogUiEx vcsLogUiEx = object instanceof VcsLogUiEx ? (VcsLogUiEx)object : null;
        if (vcsLogUiEx == null) {
            return;
        }
        VcsLogUiEx ui = vcsLogUiEx;
        List<Integer> rows = this.getRowsToJump(ui);
        if (rows.isEmpty()) {
            return;
        }
        if (rows.size() == 1) {
            VcsLogNavigationUtil.jumpToGraphRow(ui, ((Number)CollectionsKt.single(rows)).intValue(), false, true);
        } else {
            ListPopup listPopup = JBPopupFactory.getInstance().createActionGroupPopup(this.parent ? VcsLogBundle.message("action.go.to.select.parent.to.navigate", new Object[0]) : VcsLogBundle.message("action.go.to.select.child.to.navigate", new Object[0]), this.createGroup(ui, rows), e.getDataContext(), JBPopupFactory.ActionSelectionAid.NUMBERING, false);
            Intrinsics.checkNotNullExpressionValue((Object)listPopup, (String)"createActionGroupPopup(...)");
            ListPopup popup = listPopup;
            popup.showInBestPositionFor(e.getDataContext());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final ActionGroup createGroup(VcsLogUiEx ui, List<Integer> rows) {
        void destination$iv;
        void $this$mapTo$iv;
        Iterable iterable = rows;
        Collection collection = new ArrayList();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void row;
            int n = ((Number)item$iv).intValue();
            void var14_13 = destination$iv;
            boolean bl = false;
            String text = this.getActionText(ui.getTable().getListModel(), (int)row);
            Object[] objectArray = new Object[]{text};
            String string = VcsLogBundle.message("action.go.to.navigate.to", objectArray);
            var14_13.add(new DumbAwareAction(text, this, ui, (int)row, string){
                final /* synthetic */ GoToParentOrChildAction this$0;
                final /* synthetic */ VcsLogUiEx $ui;
                final /* synthetic */ int $row;
                {
                    this.this$0 = $receiver;
                    this.$ui = $ui;
                    this.$row = $row;
                    super($text, $super_call_param$1, null);
                }

                public void actionPerformed(AnActionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    GoToParentOrChildAction.access$triggerUsage(this.this$0, this, e);
                    VcsLogNavigationUtil.jumpToGraphRow(this.$ui, this.$row, false, true);
                }
            });
        }
        List actions2 = (List)destination$iv;
        return (ActionGroup)new DefaultActionGroup(actions2);
    }

    private final void triggerUsage(DumbAwareAction $this$triggerUsage, AnActionEvent e) {
        VcsLogUsageTriggerCollector.triggerUsage(e, $this$triggerUsage, arg_0 -> GoToParentOrChildAction.triggerUsage$lambda$2(arg_0 -> GoToParentOrChildAction.triggerUsage$lambda$1(this, arg_0), arg_0));
    }

    @NlsActions.ActionText
    private final String getActionText(VcsLogCommitListModel $this$getActionText, int row) {
        VcsCommitMetadata commitMetadata = VcsLogCommitListKt.getCachedCommitMetadata($this$getActionText, row);
        if (commitMetadata != null) {
            long time = commitMetadata.getAuthorTime();
            String commitMessage = "\"" + StringUtil.shortenTextWithEllipsis((String)commitMetadata.getSubject(), (int)40, (int)0, (String)"...") + "\"";
            Object[] objectArray = new Object[]{((Hash)commitMetadata.getId()).toShortString(), commitMessage, CommitPresentationUtil.getAuthorPresentation((VcsShortCommitDetails)commitMetadata), DateFormatUtil.formatDate((long)time), DateFormatUtil.formatTime((long)time)};
            String string = VcsLogBundle.message("action.go.to.select.hash.subject.author.date.time", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
        Object object = VcsLogCommitListKt.getCommitId($this$getActionText, row);
        if (object == null || (object = object.getHash()) == null || (object = object.toShortString()) == null) {
            object = "";
        }
        return object;
    }

    private final List<Integer> getRowsToJump(VcsLogUiEx ui) {
        int[] selectedRows = ui.getTable().getSelection().getRows();
        if (selectedRows.length != 1) {
            return CollectionsKt.emptyList();
        }
        List list = ui.getDataPack().getVisibleGraph().getRowInfo(ArraysKt.single((int[])selectedRows)).getAdjacentRows(this.parent);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAdjacentRows(...)");
        return CollectionsKt.sorted((Iterable)list);
    }

    private static final Unit triggerUsage$lambda$1(GoToParentOrChildAction this$0, List data) {
        data.add(VcsLogUsageTriggerCollector.PARENT_COMMIT.with((Object)this$0.parent));
        return Unit.INSTANCE;
    }

    private static final void triggerUsage$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$triggerUsage(GoToParentOrChildAction $this, DumbAwareAction $receiver, AnActionEvent e) {
        $this.triggerUsage($receiver, e);
    }
}

