// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>The inputs from a <code>Converse</code> API request for token counting.</p>
/// <p>This structure mirrors the input format for the <code>Converse</code> operation, allowing you to count tokens for conversation-based inference requests.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct ConverseTokensRequest {
    /// <p>An array of messages to count tokens for.</p>
    pub messages: ::std::option::Option<::std::vec::Vec<crate::types::Message>>,
    /// <p>The system content blocks to count tokens for. System content provides instructions or context to the model about how it should behave or respond. The token count will include any system content provided.</p>
    pub system: ::std::option::Option<::std::vec::Vec<crate::types::SystemContentBlock>>,
}
impl ConverseTokensRequest {
    /// <p>An array of messages to count tokens for.</p>
    ///
    /// If no value was sent for this field, a default will be set. If you want to determine if no value was sent, use `.messages.is_none()`.
    pub fn messages(&self) -> &[crate::types::Message] {
        self.messages.as_deref().unwrap_or_default()
    }
    /// <p>The system content blocks to count tokens for. System content provides instructions or context to the model about how it should behave or respond. The token count will include any system content provided.</p>
    ///
    /// If no value was sent for this field, a default will be set. If you want to determine if no value was sent, use `.system.is_none()`.
    pub fn system(&self) -> &[crate::types::SystemContentBlock] {
        self.system.as_deref().unwrap_or_default()
    }
}
impl ConverseTokensRequest {
    /// Creates a new builder-style object to manufacture [`ConverseTokensRequest`](crate::types::ConverseTokensRequest).
    pub fn builder() -> crate::types::builders::ConverseTokensRequestBuilder {
        crate::types::builders::ConverseTokensRequestBuilder::default()
    }
}

/// A builder for [`ConverseTokensRequest`](crate::types::ConverseTokensRequest).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct ConverseTokensRequestBuilder {
    pub(crate) messages: ::std::option::Option<::std::vec::Vec<crate::types::Message>>,
    pub(crate) system: ::std::option::Option<::std::vec::Vec<crate::types::SystemContentBlock>>,
}
impl ConverseTokensRequestBuilder {
    /// Appends an item to `messages`.
    ///
    /// To override the contents of this collection use [`set_messages`](Self::set_messages).
    ///
    /// <p>An array of messages to count tokens for.</p>
    pub fn messages(mut self, input: crate::types::Message) -> Self {
        let mut v = self.messages.unwrap_or_default();
        v.push(input);
        self.messages = ::std::option::Option::Some(v);
        self
    }
    /// <p>An array of messages to count tokens for.</p>
    pub fn set_messages(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::Message>>) -> Self {
        self.messages = input;
        self
    }
    /// <p>An array of messages to count tokens for.</p>
    pub fn get_messages(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::Message>> {
        &self.messages
    }
    /// Appends an item to `system`.
    ///
    /// To override the contents of this collection use [`set_system`](Self::set_system).
    ///
    /// <p>The system content blocks to count tokens for. System content provides instructions or context to the model about how it should behave or respond. The token count will include any system content provided.</p>
    pub fn system(mut self, input: crate::types::SystemContentBlock) -> Self {
        let mut v = self.system.unwrap_or_default();
        v.push(input);
        self.system = ::std::option::Option::Some(v);
        self
    }
    /// <p>The system content blocks to count tokens for. System content provides instructions or context to the model about how it should behave or respond. The token count will include any system content provided.</p>
    pub fn set_system(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::SystemContentBlock>>) -> Self {
        self.system = input;
        self
    }
    /// <p>The system content blocks to count tokens for. System content provides instructions or context to the model about how it should behave or respond. The token count will include any system content provided.</p>
    pub fn get_system(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::SystemContentBlock>> {
        &self.system
    }
    /// Consumes the builder and constructs a [`ConverseTokensRequest`](crate::types::ConverseTokensRequest).
    pub fn build(self) -> crate::types::ConverseTokensRequest {
        crate::types::ConverseTokensRequest {
            messages: self.messages,
            system: self.system,
        }
    }
}
