/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.io.storage;

import java.io.IOException;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.util.io.PagedFileStorage;
import org.jetbrains.kotlin.com.intellij.util.io.storage.IDataTable;

final class DataTable
implements IDataTable {
    private static final Logger LOG = Logger.getInstance(DataTable.class);
    private final PagedFileStorage myFile;
    private volatile int myWasteSize;
    private volatile boolean myIsDirty;

    @Override
    public void close() throws IOException {
        this.markClean();
        this.myFile.close();
    }

    @Override
    public void force() throws IOException {
        this.markClean();
        this.myFile.force();
    }

    @Override
    public boolean isDirty() {
        return this.myIsDirty || this.myFile.isDirty();
    }

    private void markClean() throws IOException {
        if (this.myIsDirty) {
            this.myIsDirty = false;
            this.fillInHeader(523190095, this.myWasteSize);
        }
    }

    private void fillInHeader(int magic, int wasteSize) throws IOException {
        this.myFile.putInt(0L, magic);
        this.myFile.putInt(4L, wasteSize);
    }
}

