/*
 * Decompiled with CFR 0.152.
 */
package foxtrot.workers;

import foxtrot.AbstractWorkerThread;
import foxtrot.Task;

public class DefaultWorkerThread
extends AbstractWorkerThread
implements Runnable {
    private static final boolean debug = false;
    private Thread thread;
    private Link current;

    public void start() {
        if (this.thread != null && this.thread.isAlive()) {
            this.stop();
        }
        this.thread = new Thread((Runnable)this, this.getThreadName());
        this.thread.setDaemon(true);
        this.thread.start();
    }

    protected String getThreadName() {
        return "Foxtrot Default Worker Thread";
    }

    private void stop() {
        this.thread.interrupt();
    }

    public boolean isAlive() {
        if (this.thread == null) {
            return false;
        }
        return this.thread.isAlive();
    }

    public boolean isWorkerThread() {
        return Thread.currentThread() == this.thread;
    }

    public void postTask(Task t) {
        DefaultWorkerThread defaultWorkerThread = this;
        synchronized (defaultWorkerThread) {
            if (this.hasTasks()) {
                Link item = this.current;
                while (item.next != null) {
                    item = item.next;
                }
                item.next = new Link(t);
            } else {
                this.current = new Link(t);
                this.notifyAll();
            }
        }
    }

    protected Task takeTask() throws InterruptedException {
        DefaultWorkerThread defaultWorkerThread = this;
        synchronized (defaultWorkerThread) {
            while (!this.hasTasks()) {
                this.wait();
            }
            Task t = this.current.task;
            this.current = this.current.next;
            Task task = t;
            return task;
        }
    }

    private boolean hasTasks() {
        DefaultWorkerThread defaultWorkerThread = this;
        synchronized (defaultWorkerThread) {
            boolean bl = this.current != null;
            return bl;
        }
    }

    protected boolean isThreadInterrupted() {
        return this.thread.isInterrupted();
    }

    public void run() {
        while (!this.isThreadInterrupted()) {
            try {
                Task t = this.takeTask();
                this.runTask(t);
            }
            catch (InterruptedException x) {
                break;
            }
        }
    }

    private static class Link {
        private Link next;
        private Task task;

        private Link(Task task) {
            this.task = task;
        }
    }
}

