/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.QuickMenuCreator;
import org.eclipse.ui.dialogs.IWorkingSetNewWizard;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.actions.AbstractWorkingSetPulldownDelegate;

public class ModifyWorkingSetDelegate
extends AbstractWorkingSetPulldownDelegate
implements IExecutableExtension,
IActionDelegate2 {
    private final QuickMenuCreator contextMenuCreator = new QuickMenuCreator(){

        @Override
        protected void fillMenu(IMenuManager menu) {
            ModifyWorkingSetDelegate.this.fillMenu(menu);
        }
    };
    private boolean add = true;
    private final IPropertyChangeListener listener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            this.refreshEnablement();
        }

        private void refreshEnablement() {
            ModifyWorkingSetDelegate.this.selectionChanged(ModifyWorkingSetDelegate.this.actionProxy, ModifyWorkingSetDelegate.this.getSelection());
        }
    };
    private IAction actionProxy;

    @Override
    public void run(IAction action) {
        this.contextMenuCreator.createMenu();
    }

    @Override
    public void runWithEvent(IAction action, Event event) {
        if (event.type == 1 || event.type == 2) {
            this.run(action);
        }
    }

    @Override
    public void init(IWorkbenchWindow window) {
        super.init(window);
        this.getWindow().getWorkbench().getWorkingSetManager().addPropertyChangeListener(this.listener);
    }

    @Override
    public void dispose() {
        this.getWindow().getWorkbench().getWorkingSetManager().removePropertyChangeListener(this.listener);
        super.dispose();
        this.contextMenuCreator.dispose();
    }

    @Override
    public void fillMenu(Menu menu) {
        for (Object object : this.getItems()) {
            IContributionItem item;
            if (object instanceof IAction) {
                item = new ActionContributionItem((IAction)object);
                item.fill(menu, -1);
                continue;
            }
            item = (IContributionItem)object;
            item.fill(menu, -1);
        }
        if (this.add) {
            Separator item = null;
            if (menu.getItemCount() > 0) {
                item = new Separator();
                item.fill(menu, -1);
            }
            item = new ActionContributionItem((IAction)new NewWorkingSetAction());
            item.fill(menu, -1);
        }
    }

    private List getItems() {
        ArrayList<Action> menuItems = new ArrayList<Action>();
        ISelection selection = this.getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            if (!this.add) {
                Action emptyAction = new Action(WorkbenchMessages.NoApplicableWorkingSets){};
                emptyAction.setEnabled(false);
                menuItems.add(emptyAction);
            }
            return menuItems;
        }
        IWorkingSet[][] typedSets = this.splitSets();
        Object[] selectedElements = ((IStructuredSelection)selection).toArray();
        boolean needsSeparator = false;
        IWorkingSet[][] iWorkingSetArray = typedSets;
        int n = typedSets.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkingSet[] sets = iWorkingSetArray[n2];
            int oldCount = menuItems.size();
            IWorkingSet[] iWorkingSetArray2 = sets;
            int n3 = sets.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkingSet set = iWorkingSetArray2[n4];
                HashSet<IAdaptable> existingElements = new HashSet<IAdaptable>();
                existingElements.addAll(Arrays.asList(set.getElements()));
                boolean visible = false;
                IAdaptable[] adaptables = new IAdaptable[selectedElements.length];
                System.arraycopy(selectedElements, 0, adaptables, 0, selectedElements.length);
                adaptables = set.adaptElements(adaptables);
                if (adaptables.length > 0 && this.add) {
                    var21_22 = adaptables;
                    var20_21 = adaptables.length;
                    var19_20 = 0;
                    while (var19_20 < var20_21) {
                        adaptable = var21_22[var19_20];
                        if (!existingElements.contains(adaptable)) {
                            visible = true;
                            break;
                        }
                        ++var19_20;
                    }
                } else if (adaptables.length > 0) {
                    var21_22 = adaptables;
                    var20_21 = adaptables.length;
                    var19_20 = 0;
                    while (var19_20 < var20_21) {
                        adaptable = var21_22[var19_20];
                        if (existingElements.contains(adaptable)) {
                            visible = true;
                            break;
                        }
                        ++var19_20;
                    }
                }
                if (visible) {
                    if (needsSeparator) {
                        menuItems.add((Action)new Separator());
                        needsSeparator = false;
                    }
                    ModifyAction action = new ModifyAction(set, adaptables);
                    menuItems.add(action);
                }
                ++n4;
            }
            needsSeparator |= menuItems.size() > oldCount;
            ++n2;
        }
        if (menuItems.isEmpty() && !this.add) {
            Action emptyAction = new Action(WorkbenchMessages.NoApplicableWorkingSets){};
            emptyAction.setEnabled(false);
            menuItems.add(emptyAction);
        }
        return menuItems;
    }

    private void fillMenu(IMenuManager menu) {
        for (Object object : this.getItems()) {
            if (object instanceof IAction) {
                menu.add((IAction)object);
                continue;
            }
            IContributionItem item = (IContributionItem)object;
            menu.add(item);
        }
    }

    @Override
    public void selectionChanged(IAction actionProxy, ISelection selection) {
        super.selectionChanged(actionProxy, selection);
        if (selection instanceof IStructuredSelection) {
            boolean minimallyOkay = true;
            for (Object selectedElement : (IStructuredSelection)this.getSelection()) {
                if (selectedElement instanceof IAdaptable && !(selectedElement instanceof IWorkingSet)) continue;
                minimallyOkay = false;
                break;
            }
            actionProxy.setEnabled(minimallyOkay);
        } else {
            actionProxy.setEnabled(false);
        }
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) {
        if (data instanceof String) {
            this.add = Boolean.parseBoolean((String)data);
        }
    }

    @Override
    public void init(IAction action) {
        this.actionProxy = action;
    }

    private class ModifyAction
    extends Action {
        private final IWorkingSet set;
        private final IAdaptable[] selectedElements;

        private ModifyAction(IWorkingSet set, IAdaptable[] selectedElements) {
            super(set.getLabel(), 2);
            this.set = set;
            this.selectedElements = selectedElements;
            this.setImageDescriptor(set.getImageDescriptor());
        }

        public void run() {
            List<IAdaptable> oldElements = Arrays.asList(this.set.getElements());
            HashSet<IAdaptable> newElements = new HashSet<IAdaptable>(oldElements.size() + this.selectedElements.length);
            newElements.addAll(oldElements);
            List<IAdaptable> selectedAsList = Arrays.asList(this.selectedElements);
            if (ModifyWorkingSetDelegate.this.add) {
                newElements.addAll(selectedAsList);
            } else {
                newElements.removeAll(selectedAsList);
            }
            this.set.setElements(newElements.toArray(new IAdaptable[newElements.size()]));
        }
    }

    public static class NewWorkingSetAction
    extends Action {
        public NewWorkingSetAction() {
            super(WorkbenchMessages.NewWorkingSet);
        }

        public void run() {
            IWorkingSet workingSet;
            IWorkingSetManager manager = WorkbenchPlugin.getDefault().getWorkingSetManager();
            IWorkingSetNewWizard wizard = manager.createWorkingSetNewWizard(null);
            WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), (IWizard)wizard);
            dialog.create();
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.ui.working_set_new_wizard_context");
            if (dialog.open() == 0 && (workingSet = wizard.getSelection()) != null) {
                manager.addWorkingSet(workingSet);
            }
        }
    }
}

