/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.internal.gtk4.GTK4;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class TreeColumn
extends Item {
    long headerButtonCSSProvider = 0L;
    long labelHandle;
    long imageHandle;
    long buttonHandle;
    Tree parent;
    int modelIndex;
    int lastTime;
    int lastX;
    int lastWidth;
    boolean customDraw;
    String toolTipText;

    public TreeColumn(Tree parent, int style) {
        super(parent, TreeColumn.checkStyle(style));
        this.parent = parent;
        this.createWidget(parent.getColumnCount());
    }

    public TreeColumn(Tree parent, int style, int index) {
        super(parent, TreeColumn.checkStyle(style));
        this.parent = parent;
        this.createWidget(index);
    }

    public void addControlListener(ControlListener listener) {
        this.addTypedListener(listener, 11, 10);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.addTypedListener(listener, 13, 14);
    }

    static int checkStyle(int style) {
        return TreeColumn.checkBits(style, 16384, 0x1000000, 131072, 0, 0, 0);
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    void createWidget(int index) {
        this.parent.createItem(this, index);
        this.setOrientation(true);
        this.hookEvents();
        this.register();
        this.text = "";
    }

    @Override
    void deregister() {
        super.deregister();
        this.display.removeWidget(this.handle);
        if (this.buttonHandle != 0L) {
            this.display.removeWidget(this.buttonHandle);
        }
        if (this.labelHandle != 0L) {
            this.display.removeWidget(this.labelHandle);
        }
    }

    @Override
    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    public boolean getMoveable() {
        this.checkWidget();
        return GTK.gtk_tree_view_column_get_reorderable(this.handle);
    }

    public Tree getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getResizable() {
        this.checkWidget();
        return GTK.gtk_tree_view_column_get_resizable(this.handle);
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public int getWidth() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getWidthInPixels());
    }

    int getWidthInPixels() {
        this.checkWidget();
        if (!GTK.gtk_tree_view_column_get_visible(this.handle)) {
            return 0;
        }
        return GTK.gtk_tree_view_column_get_fixed_width(this.handle);
    }

    @Override
    long gtk_clicked(long widget) {
        boolean doubleClick = false;
        long eventPtr = GTK3.gtk_get_current_event();
        if (eventPtr != 0L) {
            int eventType = GDK.gdk_event_get_event_type(eventPtr);
            int eventTime = GDK.gdk_event_get_time(eventPtr);
            if (eventType == 7) {
                int clickTime = this.display.getDoubleClickTime();
                if (this.lastTime != 0 && Math.abs(this.lastTime - eventTime) <= clickTime) {
                    doubleClick = true;
                }
                this.lastTime = eventTime == 0 ? 1 : eventTime;
            }
            this.gdk_event_free(eventPtr);
        }
        this.sendSelectionEvent(doubleClick ? 14 : 13);
        return 0L;
    }

    @Override
    void gtk_gesture_press_event(long gesture, int n_press, double x, double y, long event) {
        boolean doubleClick = n_press >= 2;
        this.sendSelectionEvent(doubleClick ? 14 : 13);
    }

    @Override
    long gtk_event_after(long widget, long gdkEvent) {
        int eventType = GDK.gdk_event_get_event_type(gdkEvent);
        eventType = Control.fixGdkEventTypeValues(eventType);
        switch (eventType) {
            case 4: {
                int[] eventButton = new int[1];
                if (GTK.GTK4) {
                    eventButton[0] = GDK.gdk_button_event_get_button(gdkEvent);
                } else {
                    GDK.gdk_event_get_button(gdkEvent, eventButton);
                }
                double[] eventRX = new double[1];
                double[] eventRY = new double[1];
                GDK.gdk_event_get_root_coords(gdkEvent, eventRX, eventRY);
                if (eventButton[0] != 3) break;
                this.parent.showMenu((int)eventRX[0], (int)eventRY[0]);
            }
        }
        return 0L;
    }

    @Override
    long gtk_mnemonic_activate(long widget, long arg1) {
        return this.parent.gtk_mnemonic_activate(widget, arg1);
    }

    @Override
    long gtk_size_allocate(long widget, long allocation) {
        GtkAllocation widgetAllocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(widget, widgetAllocation);
        int x = widgetAllocation.x;
        int width = widgetAllocation.width;
        if (x != this.lastX) {
            this.lastX = x;
            this.sendEvent(10);
        }
        if (width != this.lastWidth) {
            this.lastWidth = width;
            this.sendEvent(11);
        }
        return 0L;
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        if (GTK.GTK4) {
            long clickController = GTK4.gtk_gesture_click_new();
            GTK4.gtk_widget_add_controller(this.buttonHandle, clickController);
            GTK.gtk_event_controller_set_propagation_phase(clickController, 1);
            OS.g_signal_connect(clickController, OS.pressed, this.display.gesturePressReleaseProc, 100L);
        } else {
            OS.g_signal_connect_closure(this.handle, OS.clicked, this.display.getClosure(8), false);
        }
        if (this.buttonHandle != 0L && !GTK.GTK4) {
            OS.g_signal_connect_closure_by_id(this.buttonHandle, this.display.signalIds[16], 0, this.display.getClosure(16), false);
            OS.g_signal_connect_closure_by_id(this.buttonHandle, this.display.signalIds[47], 0, this.display.getClosure(47), false);
        }
        if (this.labelHandle != 0L) {
            OS.g_signal_connect_closure_by_id(this.labelHandle, this.display.signalIds[32], 0, this.display.getClosure(32), false);
        }
    }

    public void pack() {
        this.checkWidget();
        int width = 0;
        if (this.buttonHandle != 0L) {
            boolean visible = GTK.gtk_widget_get_visible(this.buttonHandle);
            if (!visible) {
                GTK.gtk_widget_set_visible(this.buttonHandle, true);
            }
            GtkRequisition requisition = new GtkRequisition();
            this.gtk_widget_get_preferred_size(this.buttonHandle, requisition);
            width = requisition.width;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            int i = 0;
            while (i < this.parent.items.length) {
                TreeItem item = this.parent.items[i];
                if (item != null && item.cached) {
                    width = Math.max(width, this.parent.calculateWidth(this.handle, item.handle, true));
                }
                ++i;
            }
        } else {
            long iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
            if (GTK.gtk_tree_model_get_iter_first(this.parent.modelHandle, iter)) {
                do {
                    width = Math.max(width, this.parent.calculateWidth(this.handle, iter, true));
                } while (GTK.gtk_tree_model_iter_next(this.parent.modelHandle, iter));
            }
            OS.g_free(iter);
        }
        this.setWidthInPixels(width);
    }

    @Override
    void register() {
        super.register();
        this.display.addWidget(this.handle, this);
        if (this.buttonHandle != 0L) {
            this.display.addWidget(this.buttonHandle, this);
        }
        if (this.labelHandle != 0L) {
            this.display.addWidget(this.labelHandle, this);
        }
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        this.imageHandle = 0L;
        this.labelHandle = 0L;
        this.buttonHandle = 0L;
        this.handle = 0L;
        this.modelIndex = -1;
        this.parent = null;
    }

    @Override
    void releaseParent() {
        super.releaseParent();
        if (this.parent.sortColumn == this) {
            this.parent.sortColumn = null;
        }
    }

    public void removeControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(10, listener);
        this.eventTable.unhook(11, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void setAlignment(int alignment) {
        this.checkWidget();
        if ((alignment & 0x1024000) == 0) {
            return;
        }
        int index = this.parent.indexOf(this);
        if (index == -1 || index == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= alignment & 0x1024000;
        this.parent.createRenderers(this.handle, this.modelIndex, index == 0, this.style);
    }

    void setFontDescription(long font) {
        this.setFontDescription(this.labelHandle, font);
    }

    @Override
    public void setImage(Image image) {
        this.checkWidget();
        super.setImage(image);
        if (image != null) {
            int imageIndex;
            ImageList headerImageList = this.parent.headerImageList;
            if (headerImageList == null) {
                headerImageList = this.parent.headerImageList = new ImageList();
            }
            if ((imageIndex = headerImageList.indexOf(image)) == -1) {
                imageIndex = headerImageList.add(image);
            }
            if (GTK.GTK4) {
                long pixbuf = ImageList.createPixbuf(image);
                long texture = GDK.gdk_texture_new_for_pixbuf(pixbuf);
                OS.g_object_unref(pixbuf);
                GTK4.gtk_image_set_from_paintable(this.imageHandle, texture);
            } else {
                GTK3.gtk_image_set_from_surface(this.imageHandle, headerImageList.getSurface(imageIndex));
            }
            GTK.gtk_widget_show(this.imageHandle);
        } else {
            if (GTK.GTK4) {
                GTK4.gtk_image_clear(this.imageHandle);
            } else {
                GTK3.gtk_image_set_from_surface(this.imageHandle, 0L);
            }
            GTK.gtk_widget_hide(this.imageHandle);
        }
    }

    public void setMoveable(boolean moveable) {
        this.checkWidget();
        GTK.gtk_tree_view_column_set_reorderable(this.handle, moveable);
    }

    @Override
    void setOrientation(boolean create) {
        if (!((this.parent.style & 0x4000000) == 0 && create || this.buttonHandle == 0L)) {
            int dir = (this.parent.style & 0x4000000) != 0 ? 2 : 1;
            GTK.gtk_widget_set_direction(this.buttonHandle, dir);
            GTK3.gtk_container_forall(this.buttonHandle, this.display.setDirectionProc, dir);
        }
    }

    public void setResizable(boolean resizable) {
        this.checkWidget();
        GTK.gtk_tree_view_column_set_resizable(this.handle, resizable);
    }

    @Override
    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        super.setText(string);
        char[] chars = this.fixMnemonic(string);
        byte[] buffer = Converter.wcsToMbcs(chars, true);
        GTK.gtk_label_set_text_with_mnemonic(this.labelHandle, buffer);
        if (string.length() != 0) {
            GTK.gtk_widget_show(this.labelHandle);
        } else {
            GTK.gtk_widget_hide(this.labelHandle);
        }
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
        this.setToolTipText(this.buttonHandle, string);
    }

    public void setWidth(int width) {
        this.checkWidget();
        this.setWidthInPixels(DPIUtil.autoScaleUp(width));
    }

    void setWidthInPixels(int width) {
        long windowList;
        long window;
        this.checkWidget();
        if (width < 0) {
            return;
        }
        if (width == this.lastWidth) {
            return;
        }
        if (width > 0) {
            GTK.gtk_tree_view_column_set_fixed_width(this.handle, width);
        }
        if (width != 0) {
            GTK.gtk_widget_realize(this.parent.handle);
        }
        GTK.gtk_tree_view_column_set_visible(this.handle, width != 0);
        this.lastWidth = width;
        if (width != 0 && this.buttonHandle != 0L && !GTK.GTK4 && (window = GTK.gtk_widget_get_parent_window(this.buttonHandle)) != 0L && (windowList = GDK.gdk_window_get_children(window)) != 0L) {
            long windows = windowList;
            long[] userData = new long[1];
            while (windows != 0L) {
                long child = OS.g_list_data(windows);
                GDK.gdk_window_get_user_data(child, userData);
                if (userData[0] == this.buttonHandle) {
                    GDK.gdk_window_lower(child);
                    break;
                }
                windows = OS.g_list_next(windows);
            }
            OS.g_list_free(windowList);
        }
        this.sendEvent(11);
    }

    void setHeaderCSS(String css) {
        if (this.headerButtonCSSProvider == 0L) {
            this.headerButtonCSSProvider = GTK.gtk_css_provider_new();
            GTK.gtk_style_context_add_provider(GTK.gtk_widget_get_style_context(this.buttonHandle), this.headerButtonCSSProvider, 600);
        }
        if (GTK.GTK4) {
            GTK4.gtk_css_provider_load_from_data(this.headerButtonCSSProvider, Converter.javaStringToCString(css), -1L);
        } else {
            GTK3.gtk_css_provider_load_from_data(this.headerButtonCSSProvider, Converter.javaStringToCString(css), -1L, null);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.headerButtonCSSProvider != 0L) {
            OS.g_object_unref(this.headerButtonCSSProvider);
            this.headerButtonCSSProvider = 0L;
        }
    }

    @Override
    long dpiChanged(long object, long arg0) {
        super.dpiChanged(object, arg0);
        if (this.image != null) {
            this.image.internal_gtk_refreshImageForZoom();
            this.setImage(this.image);
        }
        return 0L;
    }
}

