/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;
import java.util.Spliterators;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;

public class BitSet
implements Cloneable,
Serializable {
    private static final int ADDRESS_BITS_PER_WORD = 6;
    private static final int BITS_PER_WORD = 64;
    private static final int BIT_INDEX_MASK = 63;
    private static final long WORD_MASK = -1L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("bits", long[].class)};
    private long[] words;
    private transient int wordsInUse = 0;
    private transient boolean sizeIsSticky = false;
    private static final long serialVersionUID = 7997698588986878753L;

    private static int wordIndex(int n) {
        return n >> 6;
    }

    private void checkInvariants() {
        assert (this.wordsInUse == 0 || this.words[this.wordsInUse - 1] != 0L);
        assert (this.wordsInUse >= 0 && this.wordsInUse <= this.words.length);
        assert (this.wordsInUse == this.words.length || this.words[this.wordsInUse] == 0L);
    }

    private void recalculateWordsInUse() {
        int n;
        for (n = this.wordsInUse - 1; n >= 0 && this.words[n] == 0L; --n) {
        }
        this.wordsInUse = n + 1;
    }

    public BitSet() {
        this.initWords(64);
        this.sizeIsSticky = false;
    }

    public BitSet(int n) {
        if (n < 0) {
            throw new NegativeArraySizeException("nbits < 0: " + n);
        }
        this.initWords(n);
        this.sizeIsSticky = true;
    }

    private void initWords(int n) {
        this.words = new long[BitSet.wordIndex(n - 1) + 1];
    }

    private BitSet(long[] lArray) {
        this.words = lArray;
        this.wordsInUse = lArray.length;
        this.checkInvariants();
    }

    public static BitSet valueOf(long[] lArray) {
        int n;
        for (n = lArray.length; n > 0 && lArray[n - 1] == 0L; --n) {
        }
        return new BitSet(Arrays.copyOf(lArray, n));
    }

    public static BitSet valueOf(LongBuffer longBuffer) {
        int n;
        longBuffer = longBuffer.slice();
        for (n = longBuffer.remaining(); n > 0 && longBuffer.get(n - 1) == 0L; --n) {
        }
        long[] lArray = new long[n];
        longBuffer.get(lArray);
        return new BitSet(lArray);
    }

    public static BitSet valueOf(byte[] byArray) {
        return BitSet.valueOf(ByteBuffer.wrap(byArray));
    }

    public static BitSet valueOf(ByteBuffer byteBuffer) {
        int n;
        byteBuffer = byteBuffer.slice().order(ByteOrder.LITTLE_ENDIAN);
        for (n = byteBuffer.remaining(); n > 0 && byteBuffer.get(n - 1) == 0; --n) {
        }
        long[] lArray = new long[(n + 7) / 8];
        byteBuffer.limit(n);
        int n2 = 0;
        while (byteBuffer.remaining() >= 8) {
            lArray[n2++] = byteBuffer.getLong();
        }
        int n3 = byteBuffer.remaining();
        for (int i = 0; i < n3; ++i) {
            int n4 = n2;
            lArray[n4] = lArray[n4] | ((long)byteBuffer.get() & 0xFFL) << 8 * i;
        }
        return new BitSet(lArray);
    }

    public byte[] toByteArray() {
        int n = this.wordsInUse;
        if (n == 0) {
            return new byte[0];
        }
        int n2 = 8 * (n - 1);
        for (long i = this.words[n - 1]; i != 0L; i >>>= 8) {
            ++n2;
        }
        byte[] byArray = new byte[n2];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < n - 1; ++i) {
            byteBuffer.putLong(this.words[i]);
        }
        for (long i = this.words[n - 1]; i != 0L; i >>>= 8) {
            byteBuffer.put((byte)(i & 0xFFL));
        }
        return byArray;
    }

    public long[] toLongArray() {
        return Arrays.copyOf(this.words, this.wordsInUse);
    }

    private void ensureCapacity(int n) {
        if (this.words.length < n) {
            int n2 = Math.max(2 * this.words.length, n);
            this.words = Arrays.copyOf(this.words, n2);
            this.sizeIsSticky = false;
        }
    }

    private void expandTo(int n) {
        int n2 = n + 1;
        if (this.wordsInUse < n2) {
            this.ensureCapacity(n2);
            this.wordsInUse = n2;
        }
    }

    private static void checkRange(int n, int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + n);
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("toIndex < 0: " + n2);
        }
        if (n > n2) {
            throw new IndexOutOfBoundsException("fromIndex: " + n + " > toIndex: " + n2);
        }
    }

    public void flip(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + n);
        }
        int n2 = BitSet.wordIndex(n);
        this.expandTo(n2);
        int n3 = n2;
        this.words[n3] = this.words[n3] ^ 1L << n;
        this.recalculateWordsInUse();
        this.checkInvariants();
    }

    public void flip(int n, int n2) {
        BitSet.checkRange(n, n2);
        if (n == n2) {
            return;
        }
        int n3 = BitSet.wordIndex(n);
        int n4 = BitSet.wordIndex(n2 - 1);
        this.expandTo(n4);
        long l = -1L << n;
        long l2 = -1L >>> -n2;
        if (n3 == n4) {
            int n5 = n3;
            this.words[n5] = this.words[n5] ^ l & l2;
        } else {
            int n6 = n3;
            this.words[n6] = this.words[n6] ^ l;
            int n7 = n3 + 1;
            while (n7 < n4) {
                int n8 = n7++;
                this.words[n8] = this.words[n8] ^ 0xFFFFFFFFFFFFFFFFL;
            }
            int n9 = n4;
            this.words[n9] = this.words[n9] ^ l2;
        }
        this.recalculateWordsInUse();
        this.checkInvariants();
    }

    public void set(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + n);
        }
        int n2 = BitSet.wordIndex(n);
        this.expandTo(n2);
        int n3 = n2;
        this.words[n3] = this.words[n3] | 1L << n;
        this.checkInvariants();
    }

    public void set(int n, boolean bl) {
        if (bl) {
            this.set(n);
        } else {
            this.clear(n);
        }
    }

    public void set(int n, int n2) {
        BitSet.checkRange(n, n2);
        if (n == n2) {
            return;
        }
        int n3 = BitSet.wordIndex(n);
        int n4 = BitSet.wordIndex(n2 - 1);
        this.expandTo(n4);
        long l = -1L << n;
        long l2 = -1L >>> -n2;
        if (n3 == n4) {
            int n5 = n3;
            this.words[n5] = this.words[n5] | l & l2;
        } else {
            int n6 = n3;
            this.words[n6] = this.words[n6] | l;
            for (int i = n3 + 1; i < n4; ++i) {
                this.words[i] = -1L;
            }
            int n7 = n4;
            this.words[n7] = this.words[n7] | l2;
        }
        this.checkInvariants();
    }

    public void set(int n, int n2, boolean bl) {
        if (bl) {
            this.set(n, n2);
        } else {
            this.clear(n, n2);
        }
    }

    public void clear(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + n);
        }
        int n2 = BitSet.wordIndex(n);
        if (n2 >= this.wordsInUse) {
            return;
        }
        int n3 = n2;
        this.words[n3] = this.words[n3] & (1L << n ^ 0xFFFFFFFFFFFFFFFFL);
        this.recalculateWordsInUse();
        this.checkInvariants();
    }

    public void clear(int n, int n2) {
        BitSet.checkRange(n, n2);
        if (n == n2) {
            return;
        }
        int n3 = BitSet.wordIndex(n);
        if (n3 >= this.wordsInUse) {
            return;
        }
        int n4 = BitSet.wordIndex(n2 - 1);
        if (n4 >= this.wordsInUse) {
            n2 = this.length();
            n4 = this.wordsInUse - 1;
        }
        long l = -1L << n;
        long l2 = -1L >>> -n2;
        if (n3 == n4) {
            int n5 = n3;
            this.words[n5] = this.words[n5] & (l & l2 ^ 0xFFFFFFFFFFFFFFFFL);
        } else {
            int n6 = n3;
            this.words[n6] = this.words[n6] & (l ^ 0xFFFFFFFFFFFFFFFFL);
            for (int i = n3 + 1; i < n4; ++i) {
                this.words[i] = 0L;
            }
            int n7 = n4;
            this.words[n7] = this.words[n7] & (l2 ^ 0xFFFFFFFFFFFFFFFFL);
        }
        this.recalculateWordsInUse();
        this.checkInvariants();
    }

    public void clear() {
        while (this.wordsInUse > 0) {
            this.words[--this.wordsInUse] = 0L;
        }
    }

    public boolean get(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + n);
        }
        this.checkInvariants();
        int n2 = BitSet.wordIndex(n);
        return n2 < this.wordsInUse && (this.words[n2] & 1L << n) != 0L;
    }

    public BitSet get(int n, int n2) {
        BitSet.checkRange(n, n2);
        this.checkInvariants();
        int n3 = this.length();
        if (n3 <= n || n == n2) {
            return new BitSet(0);
        }
        if (n2 > n3) {
            n2 = n3;
        }
        BitSet bitSet = new BitSet(n2 - n);
        int n4 = BitSet.wordIndex(n2 - n - 1) + 1;
        int n5 = BitSet.wordIndex(n);
        boolean bl = (n & 0x3F) == 0;
        int n6 = 0;
        while (n6 < n4 - 1) {
            bitSet.words[n6] = bl ? this.words[n5] : this.words[n5] >>> n | this.words[n5 + 1] << -n;
            ++n6;
            ++n5;
        }
        long l = -1L >>> -n2;
        bitSet.words[n4 - 1] = (n2 - 1 & 0x3F) < (n & 0x3F) ? this.words[n5] >>> n | (this.words[n5 + 1] & l) << -n : (this.words[n5] & l) >>> n;
        bitSet.wordsInUse = n4;
        bitSet.recalculateWordsInUse();
        bitSet.checkInvariants();
        return bitSet;
    }

    public int nextSetBit(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + n);
        }
        this.checkInvariants();
        int n2 = BitSet.wordIndex(n);
        if (n2 >= this.wordsInUse) {
            return -1;
        }
        long l = this.words[n2] & -1L << n;
        while (l == 0L) {
            if (++n2 == this.wordsInUse) {
                return -1;
            }
            l = this.words[n2];
        }
        return n2 * 64 + Long.numberOfTrailingZeros(l);
    }

    public int nextClearBit(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + n);
        }
        this.checkInvariants();
        int n2 = BitSet.wordIndex(n);
        if (n2 >= this.wordsInUse) {
            return n;
        }
        long l = (this.words[n2] ^ 0xFFFFFFFFFFFFFFFFL) & -1L << n;
        while (l == 0L) {
            if (++n2 == this.wordsInUse) {
                return this.wordsInUse * 64;
            }
            l = this.words[n2] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return n2 * 64 + Long.numberOfTrailingZeros(l);
    }

    public int previousSetBit(int n) {
        if (n < 0) {
            if (n == -1) {
                return -1;
            }
            throw new IndexOutOfBoundsException("fromIndex < -1: " + n);
        }
        this.checkInvariants();
        int n2 = BitSet.wordIndex(n);
        if (n2 >= this.wordsInUse) {
            return this.length() - 1;
        }
        long l = this.words[n2] & -1L >>> -(n + 1);
        while (l == 0L) {
            if (n2-- == 0) {
                return -1;
            }
            l = this.words[n2];
        }
        return (n2 + 1) * 64 - 1 - Long.numberOfLeadingZeros(l);
    }

    public int previousClearBit(int n) {
        if (n < 0) {
            if (n == -1) {
                return -1;
            }
            throw new IndexOutOfBoundsException("fromIndex < -1: " + n);
        }
        this.checkInvariants();
        int n2 = BitSet.wordIndex(n);
        if (n2 >= this.wordsInUse) {
            return n;
        }
        long l = (this.words[n2] ^ 0xFFFFFFFFFFFFFFFFL) & -1L >>> -(n + 1);
        while (l == 0L) {
            if (n2-- == 0) {
                return -1;
            }
            l = this.words[n2] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return (n2 + 1) * 64 - 1 - Long.numberOfLeadingZeros(l);
    }

    public int length() {
        if (this.wordsInUse == 0) {
            return 0;
        }
        return 64 * (this.wordsInUse - 1) + (64 - Long.numberOfLeadingZeros(this.words[this.wordsInUse - 1]));
    }

    public boolean isEmpty() {
        return this.wordsInUse == 0;
    }

    public boolean intersects(BitSet bitSet) {
        for (int i = Math.min(this.wordsInUse, bitSet.wordsInUse) - 1; i >= 0; --i) {
            if ((this.words[i] & bitSet.words[i]) == 0L) continue;
            return true;
        }
        return false;
    }

    public int cardinality() {
        int n = 0;
        for (int i = 0; i < this.wordsInUse; ++i) {
            n += Long.bitCount(this.words[i]);
        }
        return n;
    }

    public void and(BitSet bitSet) {
        if (this == bitSet) {
            return;
        }
        while (this.wordsInUse > bitSet.wordsInUse) {
            this.words[--this.wordsInUse] = 0L;
        }
        for (int i = 0; i < this.wordsInUse; ++i) {
            int n = i;
            this.words[n] = this.words[n] & bitSet.words[i];
        }
        this.recalculateWordsInUse();
        this.checkInvariants();
    }

    public void or(BitSet bitSet) {
        if (this == bitSet) {
            return;
        }
        int n = Math.min(this.wordsInUse, bitSet.wordsInUse);
        if (this.wordsInUse < bitSet.wordsInUse) {
            this.ensureCapacity(bitSet.wordsInUse);
            this.wordsInUse = bitSet.wordsInUse;
        }
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            this.words[n2] = this.words[n2] | bitSet.words[i];
        }
        if (n < bitSet.wordsInUse) {
            System.arraycopy(bitSet.words, n, this.words, n, this.wordsInUse - n);
        }
        this.checkInvariants();
    }

    public void xor(BitSet bitSet) {
        int n = Math.min(this.wordsInUse, bitSet.wordsInUse);
        if (this.wordsInUse < bitSet.wordsInUse) {
            this.ensureCapacity(bitSet.wordsInUse);
            this.wordsInUse = bitSet.wordsInUse;
        }
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            this.words[n2] = this.words[n2] ^ bitSet.words[i];
        }
        if (n < bitSet.wordsInUse) {
            System.arraycopy(bitSet.words, n, this.words, n, bitSet.wordsInUse - n);
        }
        this.recalculateWordsInUse();
        this.checkInvariants();
    }

    public void andNot(BitSet bitSet) {
        for (int i = Math.min(this.wordsInUse, bitSet.wordsInUse) - 1; i >= 0; --i) {
            int n = i;
            this.words[n] = this.words[n] & (bitSet.words[i] ^ 0xFFFFFFFFFFFFFFFFL);
        }
        this.recalculateWordsInUse();
        this.checkInvariants();
    }

    public int hashCode() {
        long l = 1234L;
        int n = this.wordsInUse;
        while (--n >= 0) {
            l ^= this.words[n] * (long)(n + 1);
        }
        return (int)(l >> 32 ^ l);
    }

    public int size() {
        return this.words.length * 64;
    }

    public boolean equals(Object object) {
        if (!(object instanceof BitSet)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        BitSet bitSet = (BitSet)object;
        this.checkInvariants();
        bitSet.checkInvariants();
        if (this.wordsInUse != bitSet.wordsInUse) {
            return false;
        }
        for (int i = 0; i < this.wordsInUse; ++i) {
            if (this.words[i] == bitSet.words[i]) continue;
            return false;
        }
        return true;
    }

    public Object clone() {
        if (!this.sizeIsSticky) {
            this.trimToSize();
        }
        try {
            BitSet bitSet = (BitSet)super.clone();
            bitSet.words = (long[])this.words.clone();
            bitSet.checkInvariants();
            return bitSet;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException);
        }
    }

    private void trimToSize() {
        if (this.wordsInUse != this.words.length) {
            this.words = Arrays.copyOf(this.words, this.wordsInUse);
            this.checkInvariants();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.checkInvariants();
        if (!this.sizeIsSticky) {
            this.trimToSize();
        }
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("bits", this.words);
        objectOutputStream.writeFields();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        this.words = (long[])getField.get("bits", null);
        this.wordsInUse = this.words.length;
        this.recalculateWordsInUse();
        this.sizeIsSticky = this.words.length > 0 && this.words[this.words.length - 1] == 0L;
        this.checkInvariants();
    }

    public String toString() {
        this.checkInvariants();
        int n = this.wordsInUse > 128 ? this.cardinality() : this.wordsInUse * 64;
        StringBuilder stringBuilder = new StringBuilder(6 * n + 2);
        stringBuilder.append('{');
        int n2 = this.nextSetBit(0);
        if (n2 != -1) {
            stringBuilder.append(n2);
            while (++n2 >= 0 && (n2 = this.nextSetBit(n2)) >= 0) {
                int n3 = this.nextClearBit(n2);
                do {
                    stringBuilder.append(", ").append(n2);
                } while (++n2 != n3);
            }
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public IntStream stream() {
        return StreamSupport.intStream(() -> {
            class BitSetIterator
            implements PrimitiveIterator.OfInt {
                int next;

                BitSetIterator() {
                    this.next = BitSet.this.nextSetBit(0);
                }

                @Override
                public boolean hasNext() {
                    return this.next != -1;
                }

                @Override
                public int nextInt() {
                    if (this.next != -1) {
                        int n = this.next;
                        this.next = BitSet.this.nextSetBit(this.next + 1);
                        return n;
                    }
                    throw new NoSuchElementException();
                }
            }
            return Spliterators.spliterator(new BitSetIterator(), (long)this.cardinality(), 21);
        }, 16469, false);
    }
}

