'use client';
'use strict';

var React = require('react');
var useCallbackRef = require('../use-callback-ref/use-callback-ref.cjs');

function useDebouncedCallback(callback, options) {
  const delay = typeof options === "number" ? options : options.delay;
  const flushOnUnmount = typeof options === "number" ? false : options.flushOnUnmount;
  const handleCallback = useCallbackRef.useCallbackRef(callback);
  const debounceTimerRef = React.useRef(0);
  const flushRef = React.useRef(() => {
  });
  const lastCallback = Object.assign(
    React.useCallback(
      (...args) => {
        window.clearTimeout(debounceTimerRef.current);
        const flush = () => {
          if (debounceTimerRef.current !== 0) {
            debounceTimerRef.current = 0;
            handleCallback(...args);
          }
        };
        flushRef.current = flush;
        lastCallback.flush = flush;
        debounceTimerRef.current = window.setTimeout(flush, delay);
      },
      [handleCallback, delay]
    ),
    { flush: flushRef.current }
  );
  React.useEffect(
    () => () => {
      window.clearTimeout(debounceTimerRef.current);
      if (flushOnUnmount) {
        lastCallback.flush();
      }
    },
    [lastCallback, flushOnUnmount]
  );
  return lastCallback;
}

exports.useDebouncedCallback = useDebouncedCallback;
//# sourceMappingURL=use-debounced-callback.cjs.map
