"use strict";Object.defineProperty(exports,"__esModule",{value:true});Object.defineProperty(exports,"RemotePersistentFilterDropdown",{enumerable:true,get:function(){return RemotePersistentFilterDropdown}});const _jsxruntime=require("react/jsx-runtime");const _react=/*#__PURE__*/_interop_require_wildcard(require("react"));const _lucidereact=require("lucide-react");const _RemotePersistentFilterDropdownmodulecss=/*#__PURE__*/_interop_require_default(require("./RemotePersistentFilterDropdown.module.css"));const _core=require("@mantine/core");const _reacti18next=require("react-i18next");const _Tooltip=require("../../Tooltip");const _ConfirmationDialog=require("../../ConfirmationDialog");const _genericTypes=require("../../../genericTypes");const _Typo=require("../../Typo");const _theme=require("../../../theme");function _interop_require_default(obj){return obj&&obj.__esModule?obj:{default:obj}}function _getRequireWildcardCache(nodeInterop){if(typeof WeakMap!=="function")return null;var cacheBabelInterop=new WeakMap;var cacheNodeInterop=new WeakMap;return(_getRequireWildcardCache=function(nodeInterop){return nodeInterop?cacheNodeInterop:cacheBabelInterop})(nodeInterop)}function _interop_require_wildcard(obj,nodeInterop){if(!nodeInterop&&obj&&obj.__esModule){return obj}if(obj===null||typeof obj!=="object"&&typeof obj!=="function"){return{default:obj}}var cache=_getRequireWildcardCache(nodeInterop);if(cache&&cache.has(obj)){return cache.get(obj)}var newObj={__proto__:null};var hasPropertyDescriptor=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var key in obj){if(key!=="default"&&Object.prototype.hasOwnProperty.call(obj,key)){var desc=hasPropertyDescriptor?Object.getOwnPropertyDescriptor(obj,key):null;if(desc&&(desc.get||desc.set)){Object.defineProperty(newObj,key,desc)}else{newObj[key]=obj[key]}}}newObj.default=obj;if(cache){cache.set(obj,newObj)}return newObj}const RemotePersistentFilterDropdown=({remotePersistentFilters,onSelect,onDelete})=>{const{t}=(0,_reacti18next.useTranslation)();const[selectedFilter,setSelectedFilter]=(0,_react.useState)();const[modalData,setModalData]=(0,_react.useState)(null);const combobox=(0,_core.useCombobox)();const dropdownList=(0,_react.useMemo)(()=>remotePersistentFilters.map(filter=>({value:filter.id,label:filter.filterName})),[remotePersistentFilters]);const handleClick=()=>combobox.toggleDropdown();(0,_react.useEffect)(()=>{if(selectedFilter)onSelect(selectedFilter)},[selectedFilter,onSelect]);const handleSelect=(0,_react.useCallback)(filter=>{if(filter){combobox.closeDropdown();setSelectedFilter(filter)}},[combobox]);const handleDelete=(0,_react.useCallback)((e,filterId)=>{e.stopPropagation();setModalData(filterId)},[]);const handleConfirmDelete=(0,_react.useCallback)(()=>{if(modalData){onDelete(modalData);setModalData(null)}},[modalData,onDelete]);const options=(0,_react.useMemo)(()=>dropdownList.sort((a,b)=>a.label.localeCompare(b.label)).map(item=>(0,_jsxruntime.jsx)(_core.Combobox.Option,{"data-testid":"dropdown-option",value:item.value,children:(0,_jsxruntime.jsxs)(_core.Group,{className:_RemotePersistentFilterDropdownmodulecss.default.options,children:[item.label.length>35?(0,_jsxruntime.jsx)(_Tooltip.Tooltip,{label:item.label,children:(0,_jsxruntime.jsx)("span",{className:_RemotePersistentFilterDropdownmodulecss.default["truncate-text"],children:item.label})}):(0,_jsxruntime.jsx)("span",{children:item.label}),(0,_jsxruntime.jsx)(_Tooltip.Tooltip,{label:t("Delete filter"),children:(0,_jsxruntime.jsx)(_lucidereact.Trash2,{"data-testid":"delete-icon",color:"red",size:16,className:_RemotePersistentFilterDropdownmodulecss.default["options-label"],onClick:e=>handleDelete(e,item.value)})})]})},item.value)),[dropdownList,handleDelete,t]);const emptyOption=(0,_jsxruntime.jsx)(_core.Combobox.Option,{value:"",children:(0,_jsxruntime.jsx)(_core.Group,{className:_RemotePersistentFilterDropdownmodulecss.default.options,children:(0,_jsxruntime.jsx)("span",{children:t("No saved filters available")})})},"");return(0,_jsxruntime.jsxs)(_jsxruntime.Fragment,{children:[(0,_jsxruntime.jsxs)(_core.Combobox,{store:combobox,width:300,position:"bottom-start",withArrow:true,onOptionSubmit:handleSelect,styles:{dropdown:{zIndex:_theme.Z_INDEX_LAYER.GROUND.HIGHEST,maxHeight:"258px",overflow:"auto"}},children:[(0,_jsxruntime.jsx)(_core.Combobox.Target,{children:(0,_jsxruntime.jsx)("div",{"data-testid":"filter-icon",className:_RemotePersistentFilterDropdownmodulecss.default.actions,onClick:handleClick,children:(0,_jsxruntime.jsx)(_Tooltip.Tooltip,{offset:15,label:t("Saved filters"),children:(0,_jsxruntime.jsx)(_lucidereact.Filter,{"data-testid":"filter-chevron-image",color:"var(--filter-chevron-color)",size:16})})})}),(0,_jsxruntime.jsx)(_core.Combobox.Dropdown,{children:(0,_jsxruntime.jsx)(_core.Combobox.Options,{children:options.length>0?options:emptyOption})})]}),(0,_jsxruntime.jsx)(_ConfirmationDialog.ConfirmationDialog,{alertStatus:_genericTypes.EStatus.ERROR,title:t("Delete filter"),content:(0,_jsxruntime.jsx)(_Typo.Typo,{type:"body",children:t("Do you really want to delete this filter?")}),opened:!!modalData,onClose:()=>setModalData(null),confirmationButtonText:t("Confirm"),confirmationButtonVariant:"danger",cancelButtonText:t("Cancel"),onSubmit:handleConfirmDelete})]})};
//# sourceMappingURL=RemotePersistentFilterDropdown.js.map