import { type SerializedStyles } from '@emotion/react';
import { CURRENT_SURFACE_CSS_VAR, token } from '@atlaskit/tokens';
/**
 * THIS SECTION WAS CREATED VIA CODEGEN DO NOT MODIFY {@see http://go/af-codegen}
 * @codegen <<SignedSource::df710bcd99c0a8704ca36bddb12c2154>>
 * @codegenId dimensions
 * @codegenCommand yarn workspace @atlaskit/primitives codegen-styles
 * @codegenParams ["dimensions"]
 * @codegenDependency ../../../primitives/scripts/codegen-file-templates/dimensions.tsx <<SignedSource::cc9b3f12104c6ede803da6a42daac0b0>>
 */
export declare const dimensionMap: {
    readonly '100%': "100%";
    readonly 'size.100': "1rem";
    readonly 'size.200': "1.5rem";
    readonly 'size.300': "2rem";
    readonly 'size.400': "2.5rem";
    readonly 'size.500': "3rem";
    readonly 'size.600': "6rem";
    readonly 'size.1000': "12rem";
};
export type Dimension = keyof typeof dimensionMap;
/**
 * @codegenEnd
 */
/**
 * THIS SECTION WAS CREATED VIA CODEGEN DO NOT MODIFY {@see http://go/af-codegen}
 * @codegen <<SignedSource::0d3c08d703b8431712d7e238a3f7229b>>
 * @codegenId spacing
 * @codegenCommand yarn workspace @atlaskit/primitives codegen-styles
 * @codegenDependency ../../../tokens/src/artifacts/tokens-raw/atlassian-spacing.tsx <<SignedSource::55622b91aca9b3afac4bce440f222b71>>
 */
export declare const positiveSpaceMap: {
    'space.0': "var(--ds-space-0)";
    'space.025': "var(--ds-space-025)";
    'space.050': "var(--ds-space-050)";
    'space.075': "var(--ds-space-075)";
    'space.100': "var(--ds-space-100)";
    'space.150': "var(--ds-space-150)";
    'space.200': "var(--ds-space-200)";
    'space.250': "var(--ds-space-250)";
    'space.300': "var(--ds-space-300)";
    'space.400': "var(--ds-space-400)";
    'space.500': "var(--ds-space-500)";
    'space.600': "var(--ds-space-600)";
    'space.800': "var(--ds-space-800)";
    'space.1000': "var(--ds-space-1000)";
};
export type Space = keyof typeof positiveSpaceMap;
export declare const negativeSpaceMap: {
    'space.negative.025': "var(--ds-space-negative-025)";
    'space.negative.050': "var(--ds-space-negative-050)";
    'space.negative.075': "var(--ds-space-negative-075)";
    'space.negative.100': "var(--ds-space-negative-100)";
    'space.negative.150': "var(--ds-space-negative-150)";
    'space.negative.200': "var(--ds-space-negative-200)";
    'space.negative.250': "var(--ds-space-negative-250)";
    'space.negative.300': "var(--ds-space-negative-300)";
    'space.negative.400': "var(--ds-space-negative-400)";
};
export type NegativeSpace = keyof typeof negativeSpaceMap;
export declare const allSpaceMap: {
    'space.negative.025': "var(--ds-space-negative-025)";
    'space.negative.050': "var(--ds-space-negative-050)";
    'space.negative.075': "var(--ds-space-negative-075)";
    'space.negative.100': "var(--ds-space-negative-100)";
    'space.negative.150': "var(--ds-space-negative-150)";
    'space.negative.200': "var(--ds-space-negative-200)";
    'space.negative.250': "var(--ds-space-negative-250)";
    'space.negative.300': "var(--ds-space-negative-300)";
    'space.negative.400': "var(--ds-space-negative-400)";
    'space.0': "var(--ds-space-0)";
    'space.025': "var(--ds-space-025)";
    'space.050': "var(--ds-space-050)";
    'space.075': "var(--ds-space-075)";
    'space.100': "var(--ds-space-100)";
    'space.150': "var(--ds-space-150)";
    'space.200': "var(--ds-space-200)";
    'space.250': "var(--ds-space-250)";
    'space.300': "var(--ds-space-300)";
    'space.400': "var(--ds-space-400)";
    'space.500': "var(--ds-space-500)";
    'space.600': "var(--ds-space-600)";
    'space.800': "var(--ds-space-800)";
    'space.1000': "var(--ds-space-1000)";
};
export type AllSpace = keyof typeof allSpaceMap;
/**
 * @codegenEnd
 */
/**
 * THIS SECTION WAS CREATED VIA CODEGEN DO NOT MODIFY {@see http://go/af-codegen}
 * @codegen <<SignedSource::22a2979c4fc1786fb195a77491780088>>
 * @codegenId inverse-colors
 * @codegenCommand yarn workspace @atlaskit/primitives codegen-styles
 * @codegenDependency ../../../tokens/src/artifacts/tokens-raw/atlassian-light.tsx <<SignedSource::d227fb20aa75533eb903b15ddcb61e67>>
 */
export declare const inverseColorMap: {
    readonly 'color.background.neutral.bold': "color.text.inverse";
    readonly 'color.background.neutral.bold.hovered': "color.text.inverse";
    readonly 'color.background.neutral.bold.pressed': "color.text.inverse";
    readonly 'color.background.selected.bold': "color.text.inverse";
    readonly 'color.background.selected.bold.hovered': "color.text.inverse";
    readonly 'color.background.selected.bold.pressed': "color.text.inverse";
    readonly 'color.background.brand.bold': "color.text.inverse";
    readonly 'color.background.brand.bold.hovered': "color.text.inverse";
    readonly 'color.background.brand.bold.pressed': "color.text.inverse";
    readonly 'color.background.brand.boldest': "color.text.inverse";
    readonly 'color.background.brand.boldest.hovered': "color.text.inverse";
    readonly 'color.background.brand.boldest.pressed': "color.text.inverse";
    readonly 'color.background.danger.bold': "color.text.inverse";
    readonly 'color.background.danger.bold.hovered': "color.text.inverse";
    readonly 'color.background.danger.bold.pressed': "color.text.inverse";
    readonly 'color.background.warning.bold': "color.text.warning.inverse";
    readonly 'color.background.warning.bold.hovered': "color.text.warning.inverse";
    readonly 'color.background.warning.bold.pressed': "color.text.warning.inverse";
    readonly 'color.background.success.bold': "color.text.inverse";
    readonly 'color.background.success.bold.hovered': "color.text.inverse";
    readonly 'color.background.success.bold.pressed': "color.text.inverse";
    readonly 'color.background.discovery.bold': "color.text.inverse";
    readonly 'color.background.discovery.bold.hovered': "color.text.inverse";
    readonly 'color.background.discovery.bold.pressed': "color.text.inverse";
    readonly 'color.background.information.bold': "color.text.inverse";
    readonly 'color.background.information.bold.hovered': "color.text.inverse";
    readonly 'color.background.information.bold.pressed': "color.text.inverse";
};
/**
 * @codegenEnd
 */
/**
 * THIS SECTION WAS CREATED VIA CODEGEN DO NOT MODIFY {@see http://go/af-codegen}
 * @codegen <<SignedSource::2eb224063963492535d5e8be41c5e2d9>>
 * @codegenId elevation
 * @codegenCommand yarn workspace @atlaskit/primitives codegen-styles
 * @codegenParams ["opacity", "shadow", "surface"]
 * @codegenDependency ../../../tokens/src/artifacts/tokens-raw/atlassian-light.tsx <<SignedSource::d227fb20aa75533eb903b15ddcb61e67>>
 */
export declare const opacityMap: {
    readonly 'opacity.disabled': "var(--ds-opacity-disabled)";
    readonly 'opacity.loading': "var(--ds-opacity-loading)";
};
export type Opacity = keyof typeof opacityMap;
export declare const shadowMap: {
    readonly 'elevation.shadow.overflow': "var(--ds-shadow-overflow)";
    readonly 'elevation.shadow.overflow.perimeter': "var(--ds-shadow-overflow-perimeter)";
    readonly 'elevation.shadow.overflow.spread': "var(--ds-shadow-overflow-spread)";
    readonly 'elevation.shadow.overlay': "var(--ds-shadow-overlay)";
    readonly 'elevation.shadow.raised': "var(--ds-shadow-raised)";
};
export type Shadow = keyof typeof shadowMap;
export declare const surfaceColorMap: {
    readonly 'elevation.surface': "var(--ds-surface)";
    readonly 'elevation.surface.hovered': "var(--ds-surface-hovered)";
    readonly 'elevation.surface.pressed': "var(--ds-surface-pressed)";
    readonly 'elevation.surface.overlay': "var(--ds-surface-overlay)";
    readonly 'elevation.surface.overlay.hovered': "var(--ds-surface-overlay-hovered)";
    readonly 'elevation.surface.overlay.pressed': "var(--ds-surface-overlay-pressed)";
    readonly 'elevation.surface.raised': "var(--ds-surface-raised)";
    readonly 'elevation.surface.raised.hovered': "var(--ds-surface-raised-hovered)";
    readonly 'elevation.surface.raised.pressed': "var(--ds-surface-raised-pressed)";
    readonly 'elevation.surface.sunken': "var(--ds-surface-sunken)";
};
export type SurfaceColor = keyof typeof surfaceColorMap;
/**
 * @codegenEnd
 */
/**
 * THIS SECTION WAS CREATED VIA CODEGEN DO NOT MODIFY {@see http://go/af-codegen}
 * @codegen <<SignedSource::0bab85e4a2b687630331ed0db60483dd>>
 * @codegenId colors
 * @codegenCommand yarn workspace @atlaskit/primitives codegen-styles
 * @codegenParams ["border", "background", "text", "fill"]
 * @codegenDependency ../../../tokens/src/artifacts/tokens-raw/atlassian-light.tsx <<SignedSource::d227fb20aa75533eb903b15ddcb61e67>>
 */
export declare const borderColorMap: {
    readonly 'color.border': "var(--ds-border)";
    readonly 'color.border.accent.lime': "var(--ds-border-accent-lime)";
    readonly 'color.border.accent.red': "var(--ds-border-accent-red)";
    readonly 'color.border.accent.orange': "var(--ds-border-accent-orange)";
    readonly 'color.border.accent.yellow': "var(--ds-border-accent-yellow)";
    readonly 'color.border.accent.green': "var(--ds-border-accent-green)";
    readonly 'color.border.accent.teal': "var(--ds-border-accent-teal)";
    readonly 'color.border.accent.blue': "var(--ds-border-accent-blue)";
    readonly 'color.border.accent.purple': "var(--ds-border-accent-purple)";
    readonly 'color.border.accent.magenta': "var(--ds-border-accent-magenta)";
    readonly 'color.border.accent.gray': "var(--ds-border-accent-gray)";
    readonly 'color.border.disabled': "var(--ds-border-disabled)";
    readonly 'color.border.focused': "var(--ds-border-focused)";
    readonly 'color.border.input': "var(--ds-border-input)";
    readonly 'color.border.inverse': "var(--ds-border-inverse)";
    readonly 'color.border.selected': "var(--ds-border-selected)";
    readonly 'color.border.brand': "var(--ds-border-brand)";
    readonly 'color.border.danger': "var(--ds-border-danger)";
    readonly 'color.border.warning': "var(--ds-border-warning)";
    readonly 'color.border.success': "var(--ds-border-success)";
    readonly 'color.border.discovery': "var(--ds-border-discovery)";
    readonly 'color.border.information': "var(--ds-border-information)";
    readonly 'color.border.bold': "var(--ds-border-bold)";
};
export type BorderColor = keyof typeof borderColorMap;
export declare const backgroundColorMap: {
    readonly 'color.background.accent.lime.subtlest': "var(--ds-background-accent-lime-subtlest)";
    readonly 'color.background.accent.lime.subtlest.hovered': "var(--ds-background-accent-lime-subtlest-hovered)";
    readonly 'color.background.accent.lime.subtlest.pressed': "var(--ds-background-accent-lime-subtlest-pressed)";
    readonly 'color.background.accent.lime.subtler': "var(--ds-background-accent-lime-subtler)";
    readonly 'color.background.accent.lime.subtler.hovered': "var(--ds-background-accent-lime-subtler-hovered)";
    readonly 'color.background.accent.lime.subtler.pressed': "var(--ds-background-accent-lime-subtler-pressed)";
    readonly 'color.background.accent.lime.subtle': "var(--ds-background-accent-lime-subtle)";
    readonly 'color.background.accent.lime.subtle.hovered': "var(--ds-background-accent-lime-subtle-hovered)";
    readonly 'color.background.accent.lime.subtle.pressed': "var(--ds-background-accent-lime-subtle-pressed)";
    readonly 'color.background.accent.lime.bolder': "var(--ds-background-accent-lime-bolder)";
    readonly 'color.background.accent.lime.bolder.hovered': "var(--ds-background-accent-lime-bolder-hovered)";
    readonly 'color.background.accent.lime.bolder.pressed': "var(--ds-background-accent-lime-bolder-pressed)";
    readonly 'color.background.accent.red.subtlest': "var(--ds-background-accent-red-subtlest)";
    readonly 'color.background.accent.red.subtlest.hovered': "var(--ds-background-accent-red-subtlest-hovered)";
    readonly 'color.background.accent.red.subtlest.pressed': "var(--ds-background-accent-red-subtlest-pressed)";
    readonly 'color.background.accent.red.subtler': "var(--ds-background-accent-red-subtler)";
    readonly 'color.background.accent.red.subtler.hovered': "var(--ds-background-accent-red-subtler-hovered)";
    readonly 'color.background.accent.red.subtler.pressed': "var(--ds-background-accent-red-subtler-pressed)";
    readonly 'color.background.accent.red.subtle': "var(--ds-background-accent-red-subtle)";
    readonly 'color.background.accent.red.subtle.hovered': "var(--ds-background-accent-red-subtle-hovered)";
    readonly 'color.background.accent.red.subtle.pressed': "var(--ds-background-accent-red-subtle-pressed)";
    readonly 'color.background.accent.red.bolder': "var(--ds-background-accent-red-bolder)";
    readonly 'color.background.accent.red.bolder.hovered': "var(--ds-background-accent-red-bolder-hovered)";
    readonly 'color.background.accent.red.bolder.pressed': "var(--ds-background-accent-red-bolder-pressed)";
    readonly 'color.background.accent.orange.subtlest': "var(--ds-background-accent-orange-subtlest)";
    readonly 'color.background.accent.orange.subtlest.hovered': "var(--ds-background-accent-orange-subtlest-hovered)";
    readonly 'color.background.accent.orange.subtlest.pressed': "var(--ds-background-accent-orange-subtlest-pressed)";
    readonly 'color.background.accent.orange.subtler': "var(--ds-background-accent-orange-subtler)";
    readonly 'color.background.accent.orange.subtler.hovered': "var(--ds-background-accent-orange-subtler-hovered)";
    readonly 'color.background.accent.orange.subtler.pressed': "var(--ds-background-accent-orange-subtler-pressed)";
    readonly 'color.background.accent.orange.subtle': "var(--ds-background-accent-orange-subtle)";
    readonly 'color.background.accent.orange.subtle.hovered': "var(--ds-background-accent-orange-subtle-hovered)";
    readonly 'color.background.accent.orange.subtle.pressed': "var(--ds-background-accent-orange-subtle-pressed)";
    readonly 'color.background.accent.orange.bolder': "var(--ds-background-accent-orange-bolder)";
    readonly 'color.background.accent.orange.bolder.hovered': "var(--ds-background-accent-orange-bolder-hovered)";
    readonly 'color.background.accent.orange.bolder.pressed': "var(--ds-background-accent-orange-bolder-pressed)";
    readonly 'color.background.accent.yellow.subtlest': "var(--ds-background-accent-yellow-subtlest)";
    readonly 'color.background.accent.yellow.subtlest.hovered': "var(--ds-background-accent-yellow-subtlest-hovered)";
    readonly 'color.background.accent.yellow.subtlest.pressed': "var(--ds-background-accent-yellow-subtlest-pressed)";
    readonly 'color.background.accent.yellow.subtler': "var(--ds-background-accent-yellow-subtler)";
    readonly 'color.background.accent.yellow.subtler.hovered': "var(--ds-background-accent-yellow-subtler-hovered)";
    readonly 'color.background.accent.yellow.subtler.pressed': "var(--ds-background-accent-yellow-subtler-pressed)";
    readonly 'color.background.accent.yellow.subtle': "var(--ds-background-accent-yellow-subtle)";
    readonly 'color.background.accent.yellow.subtle.hovered': "var(--ds-background-accent-yellow-subtle-hovered)";
    readonly 'color.background.accent.yellow.subtle.pressed': "var(--ds-background-accent-yellow-subtle-pressed)";
    readonly 'color.background.accent.yellow.bolder': "var(--ds-background-accent-yellow-bolder)";
    readonly 'color.background.accent.yellow.bolder.hovered': "var(--ds-background-accent-yellow-bolder-hovered)";
    readonly 'color.background.accent.yellow.bolder.pressed': "var(--ds-background-accent-yellow-bolder-pressed)";
    readonly 'color.background.accent.green.subtlest': "var(--ds-background-accent-green-subtlest)";
    readonly 'color.background.accent.green.subtlest.hovered': "var(--ds-background-accent-green-subtlest-hovered)";
    readonly 'color.background.accent.green.subtlest.pressed': "var(--ds-background-accent-green-subtlest-pressed)";
    readonly 'color.background.accent.green.subtler': "var(--ds-background-accent-green-subtler)";
    readonly 'color.background.accent.green.subtler.hovered': "var(--ds-background-accent-green-subtler-hovered)";
    readonly 'color.background.accent.green.subtler.pressed': "var(--ds-background-accent-green-subtler-pressed)";
    readonly 'color.background.accent.green.subtle': "var(--ds-background-accent-green-subtle)";
    readonly 'color.background.accent.green.subtle.hovered': "var(--ds-background-accent-green-subtle-hovered)";
    readonly 'color.background.accent.green.subtle.pressed': "var(--ds-background-accent-green-subtle-pressed)";
    readonly 'color.background.accent.green.bolder': "var(--ds-background-accent-green-bolder)";
    readonly 'color.background.accent.green.bolder.hovered': "var(--ds-background-accent-green-bolder-hovered)";
    readonly 'color.background.accent.green.bolder.pressed': "var(--ds-background-accent-green-bolder-pressed)";
    readonly 'color.background.accent.teal.subtlest': "var(--ds-background-accent-teal-subtlest)";
    readonly 'color.background.accent.teal.subtlest.hovered': "var(--ds-background-accent-teal-subtlest-hovered)";
    readonly 'color.background.accent.teal.subtlest.pressed': "var(--ds-background-accent-teal-subtlest-pressed)";
    readonly 'color.background.accent.teal.subtler': "var(--ds-background-accent-teal-subtler)";
    readonly 'color.background.accent.teal.subtler.hovered': "var(--ds-background-accent-teal-subtler-hovered)";
    readonly 'color.background.accent.teal.subtler.pressed': "var(--ds-background-accent-teal-subtler-pressed)";
    readonly 'color.background.accent.teal.subtle': "var(--ds-background-accent-teal-subtle)";
    readonly 'color.background.accent.teal.subtle.hovered': "var(--ds-background-accent-teal-subtle-hovered)";
    readonly 'color.background.accent.teal.subtle.pressed': "var(--ds-background-accent-teal-subtle-pressed)";
    readonly 'color.background.accent.teal.bolder': "var(--ds-background-accent-teal-bolder)";
    readonly 'color.background.accent.teal.bolder.hovered': "var(--ds-background-accent-teal-bolder-hovered)";
    readonly 'color.background.accent.teal.bolder.pressed': "var(--ds-background-accent-teal-bolder-pressed)";
    readonly 'color.background.accent.blue.subtlest': "var(--ds-background-accent-blue-subtlest)";
    readonly 'color.background.accent.blue.subtlest.hovered': "var(--ds-background-accent-blue-subtlest-hovered)";
    readonly 'color.background.accent.blue.subtlest.pressed': "var(--ds-background-accent-blue-subtlest-pressed)";
    readonly 'color.background.accent.blue.subtler': "var(--ds-background-accent-blue-subtler)";
    readonly 'color.background.accent.blue.subtler.hovered': "var(--ds-background-accent-blue-subtler-hovered)";
    readonly 'color.background.accent.blue.subtler.pressed': "var(--ds-background-accent-blue-subtler-pressed)";
    readonly 'color.background.accent.blue.subtle': "var(--ds-background-accent-blue-subtle)";
    readonly 'color.background.accent.blue.subtle.hovered': "var(--ds-background-accent-blue-subtle-hovered)";
    readonly 'color.background.accent.blue.subtle.pressed': "var(--ds-background-accent-blue-subtle-pressed)";
    readonly 'color.background.accent.blue.bolder': "var(--ds-background-accent-blue-bolder)";
    readonly 'color.background.accent.blue.bolder.hovered': "var(--ds-background-accent-blue-bolder-hovered)";
    readonly 'color.background.accent.blue.bolder.pressed': "var(--ds-background-accent-blue-bolder-pressed)";
    readonly 'color.background.accent.purple.subtlest': "var(--ds-background-accent-purple-subtlest)";
    readonly 'color.background.accent.purple.subtlest.hovered': "var(--ds-background-accent-purple-subtlest-hovered)";
    readonly 'color.background.accent.purple.subtlest.pressed': "var(--ds-background-accent-purple-subtlest-pressed)";
    readonly 'color.background.accent.purple.subtler': "var(--ds-background-accent-purple-subtler)";
    readonly 'color.background.accent.purple.subtler.hovered': "var(--ds-background-accent-purple-subtler-hovered)";
    readonly 'color.background.accent.purple.subtler.pressed': "var(--ds-background-accent-purple-subtler-pressed)";
    readonly 'color.background.accent.purple.subtle': "var(--ds-background-accent-purple-subtle)";
    readonly 'color.background.accent.purple.subtle.hovered': "var(--ds-background-accent-purple-subtle-hovered)";
    readonly 'color.background.accent.purple.subtle.pressed': "var(--ds-background-accent-purple-subtle-pressed)";
    readonly 'color.background.accent.purple.bolder': "var(--ds-background-accent-purple-bolder)";
    readonly 'color.background.accent.purple.bolder.hovered': "var(--ds-background-accent-purple-bolder-hovered)";
    readonly 'color.background.accent.purple.bolder.pressed': "var(--ds-background-accent-purple-bolder-pressed)";
    readonly 'color.background.accent.magenta.subtlest': "var(--ds-background-accent-magenta-subtlest)";
    readonly 'color.background.accent.magenta.subtlest.hovered': "var(--ds-background-accent-magenta-subtlest-hovered)";
    readonly 'color.background.accent.magenta.subtlest.pressed': "var(--ds-background-accent-magenta-subtlest-pressed)";
    readonly 'color.background.accent.magenta.subtler': "var(--ds-background-accent-magenta-subtler)";
    readonly 'color.background.accent.magenta.subtler.hovered': "var(--ds-background-accent-magenta-subtler-hovered)";
    readonly 'color.background.accent.magenta.subtler.pressed': "var(--ds-background-accent-magenta-subtler-pressed)";
    readonly 'color.background.accent.magenta.subtle': "var(--ds-background-accent-magenta-subtle)";
    readonly 'color.background.accent.magenta.subtle.hovered': "var(--ds-background-accent-magenta-subtle-hovered)";
    readonly 'color.background.accent.magenta.subtle.pressed': "var(--ds-background-accent-magenta-subtle-pressed)";
    readonly 'color.background.accent.magenta.bolder': "var(--ds-background-accent-magenta-bolder)";
    readonly 'color.background.accent.magenta.bolder.hovered': "var(--ds-background-accent-magenta-bolder-hovered)";
    readonly 'color.background.accent.magenta.bolder.pressed': "var(--ds-background-accent-magenta-bolder-pressed)";
    readonly 'color.background.accent.gray.subtlest': "var(--ds-background-accent-gray-subtlest)";
    readonly 'color.background.accent.gray.subtlest.hovered': "var(--ds-background-accent-gray-subtlest-hovered)";
    readonly 'color.background.accent.gray.subtlest.pressed': "var(--ds-background-accent-gray-subtlest-pressed)";
    readonly 'color.background.accent.gray.subtler': "var(--ds-background-accent-gray-subtler)";
    readonly 'color.background.accent.gray.subtler.hovered': "var(--ds-background-accent-gray-subtler-hovered)";
    readonly 'color.background.accent.gray.subtler.pressed': "var(--ds-background-accent-gray-subtler-pressed)";
    readonly 'color.background.accent.gray.subtle': "var(--ds-background-accent-gray-subtle)";
    readonly 'color.background.accent.gray.subtle.hovered': "var(--ds-background-accent-gray-subtle-hovered)";
    readonly 'color.background.accent.gray.subtle.pressed': "var(--ds-background-accent-gray-subtle-pressed)";
    readonly 'color.background.accent.gray.bolder': "var(--ds-background-accent-gray-bolder)";
    readonly 'color.background.accent.gray.bolder.hovered': "var(--ds-background-accent-gray-bolder-hovered)";
    readonly 'color.background.accent.gray.bolder.pressed': "var(--ds-background-accent-gray-bolder-pressed)";
    readonly 'color.background.disabled': "var(--ds-background-disabled)";
    readonly 'color.background.input': "var(--ds-background-input)";
    readonly 'color.background.input.hovered': "var(--ds-background-input-hovered)";
    readonly 'color.background.input.pressed': "var(--ds-background-input-pressed)";
    readonly 'color.background.inverse.subtle': "var(--ds-background-inverse-subtle)";
    readonly 'color.background.inverse.subtle.hovered': "var(--ds-background-inverse-subtle-hovered)";
    readonly 'color.background.inverse.subtle.pressed': "var(--ds-background-inverse-subtle-pressed)";
    readonly 'color.background.neutral': "var(--ds-background-neutral)";
    readonly 'color.background.neutral.hovered': "var(--ds-background-neutral-hovered)";
    readonly 'color.background.neutral.pressed': "var(--ds-background-neutral-pressed)";
    readonly 'color.background.neutral.subtle': "var(--ds-background-neutral-subtle)";
    readonly 'color.background.neutral.subtle.hovered': "var(--ds-background-neutral-subtle-hovered)";
    readonly 'color.background.neutral.subtle.pressed': "var(--ds-background-neutral-subtle-pressed)";
    readonly 'color.background.neutral.bold': "var(--ds-background-neutral-bold)";
    readonly 'color.background.neutral.bold.hovered': "var(--ds-background-neutral-bold-hovered)";
    readonly 'color.background.neutral.bold.pressed': "var(--ds-background-neutral-bold-pressed)";
    readonly 'color.background.selected': "var(--ds-background-selected)";
    readonly 'color.background.selected.hovered': "var(--ds-background-selected-hovered)";
    readonly 'color.background.selected.pressed': "var(--ds-background-selected-pressed)";
    readonly 'color.background.selected.bold': "var(--ds-background-selected-bold)";
    readonly 'color.background.selected.bold.hovered': "var(--ds-background-selected-bold-hovered)";
    readonly 'color.background.selected.bold.pressed': "var(--ds-background-selected-bold-pressed)";
    readonly 'color.background.brand.subtlest': "var(--ds-background-brand-subtlest)";
    readonly 'color.background.brand.subtlest.hovered': "var(--ds-background-brand-subtlest-hovered)";
    readonly 'color.background.brand.subtlest.pressed': "var(--ds-background-brand-subtlest-pressed)";
    readonly 'color.background.brand.bold': "var(--ds-background-brand-bold)";
    readonly 'color.background.brand.bold.hovered': "var(--ds-background-brand-bold-hovered)";
    readonly 'color.background.brand.bold.pressed': "var(--ds-background-brand-bold-pressed)";
    readonly 'color.background.brand.boldest': "var(--ds-background-brand-boldest)";
    readonly 'color.background.brand.boldest.hovered': "var(--ds-background-brand-boldest-hovered)";
    readonly 'color.background.brand.boldest.pressed': "var(--ds-background-brand-boldest-pressed)";
    readonly 'color.background.danger': "var(--ds-background-danger)";
    readonly 'color.background.danger.hovered': "var(--ds-background-danger-hovered)";
    readonly 'color.background.danger.pressed': "var(--ds-background-danger-pressed)";
    readonly 'color.background.danger.bold': "var(--ds-background-danger-bold)";
    readonly 'color.background.danger.bold.hovered': "var(--ds-background-danger-bold-hovered)";
    readonly 'color.background.danger.bold.pressed': "var(--ds-background-danger-bold-pressed)";
    readonly 'color.background.warning': "var(--ds-background-warning)";
    readonly 'color.background.warning.hovered': "var(--ds-background-warning-hovered)";
    readonly 'color.background.warning.pressed': "var(--ds-background-warning-pressed)";
    readonly 'color.background.warning.bold': "var(--ds-background-warning-bold)";
    readonly 'color.background.warning.bold.hovered': "var(--ds-background-warning-bold-hovered)";
    readonly 'color.background.warning.bold.pressed': "var(--ds-background-warning-bold-pressed)";
    readonly 'color.background.success': "var(--ds-background-success)";
    readonly 'color.background.success.hovered': "var(--ds-background-success-hovered)";
    readonly 'color.background.success.pressed': "var(--ds-background-success-pressed)";
    readonly 'color.background.success.bold': "var(--ds-background-success-bold)";
    readonly 'color.background.success.bold.hovered': "var(--ds-background-success-bold-hovered)";
    readonly 'color.background.success.bold.pressed': "var(--ds-background-success-bold-pressed)";
    readonly 'color.background.discovery': "var(--ds-background-discovery)";
    readonly 'color.background.discovery.hovered': "var(--ds-background-discovery-hovered)";
    readonly 'color.background.discovery.pressed': "var(--ds-background-discovery-pressed)";
    readonly 'color.background.discovery.bold': "var(--ds-background-discovery-bold)";
    readonly 'color.background.discovery.bold.hovered': "var(--ds-background-discovery-bold-hovered)";
    readonly 'color.background.discovery.bold.pressed': "var(--ds-background-discovery-bold-pressed)";
    readonly 'color.background.information': "var(--ds-background-information)";
    readonly 'color.background.information.hovered': "var(--ds-background-information-hovered)";
    readonly 'color.background.information.pressed': "var(--ds-background-information-pressed)";
    readonly 'color.background.information.bold': "var(--ds-background-information-bold)";
    readonly 'color.background.information.bold.hovered': "var(--ds-background-information-bold-hovered)";
    readonly 'color.background.information.bold.pressed': "var(--ds-background-information-bold-pressed)";
    readonly 'color.blanket': "var(--ds-blanket)";
    readonly 'color.blanket.selected': "var(--ds-blanket-selected)";
    readonly 'color.blanket.danger': "var(--ds-blanket-danger)";
    readonly 'color.skeleton': "var(--ds-skeleton)";
    readonly 'color.skeleton.subtle': "var(--ds-skeleton-subtle)";
    readonly 'elevation.surface': "var(--ds-surface)";
    readonly 'elevation.surface.hovered': "var(--ds-surface-hovered)";
    readonly 'elevation.surface.pressed': "var(--ds-surface-pressed)";
    readonly 'elevation.surface.overlay': "var(--ds-surface-overlay)";
    readonly 'elevation.surface.overlay.hovered': "var(--ds-surface-overlay-hovered)";
    readonly 'elevation.surface.overlay.pressed': "var(--ds-surface-overlay-pressed)";
    readonly 'elevation.surface.raised': "var(--ds-surface-raised)";
    readonly 'elevation.surface.raised.hovered': "var(--ds-surface-raised-hovered)";
    readonly 'elevation.surface.raised.pressed': "var(--ds-surface-raised-pressed)";
    readonly 'elevation.surface.sunken': "var(--ds-surface-sunken)";
    readonly 'utility.elevation.surface.current': "var(--ds-elevation-surface-current)";
};
export type BackgroundColor = keyof typeof backgroundColorMap;
export declare const textColorMap: {
    readonly 'color.text': "var(--ds-text)";
    readonly 'color.text.accent.lime': "var(--ds-text-accent-lime)";
    readonly 'color.text.accent.lime.bolder': "var(--ds-text-accent-lime-bolder)";
    readonly 'color.text.accent.red': "var(--ds-text-accent-red)";
    readonly 'color.text.accent.red.bolder': "var(--ds-text-accent-red-bolder)";
    readonly 'color.text.accent.orange': "var(--ds-text-accent-orange)";
    readonly 'color.text.accent.orange.bolder': "var(--ds-text-accent-orange-bolder)";
    readonly 'color.text.accent.yellow': "var(--ds-text-accent-yellow)";
    readonly 'color.text.accent.yellow.bolder': "var(--ds-text-accent-yellow-bolder)";
    readonly 'color.text.accent.green': "var(--ds-text-accent-green)";
    readonly 'color.text.accent.green.bolder': "var(--ds-text-accent-green-bolder)";
    readonly 'color.text.accent.teal': "var(--ds-text-accent-teal)";
    readonly 'color.text.accent.teal.bolder': "var(--ds-text-accent-teal-bolder)";
    readonly 'color.text.accent.blue': "var(--ds-text-accent-blue)";
    readonly 'color.text.accent.blue.bolder': "var(--ds-text-accent-blue-bolder)";
    readonly 'color.text.accent.purple': "var(--ds-text-accent-purple)";
    readonly 'color.text.accent.purple.bolder': "var(--ds-text-accent-purple-bolder)";
    readonly 'color.text.accent.magenta': "var(--ds-text-accent-magenta)";
    readonly 'color.text.accent.magenta.bolder': "var(--ds-text-accent-magenta-bolder)";
    readonly 'color.text.accent.gray': "var(--ds-text-accent-gray)";
    readonly 'color.text.accent.gray.bolder': "var(--ds-text-accent-gray-bolder)";
    readonly 'color.text.disabled': "var(--ds-text-disabled)";
    readonly 'color.text.inverse': "var(--ds-text-inverse)";
    readonly 'color.text.selected': "var(--ds-text-selected)";
    readonly 'color.text.brand': "var(--ds-text-brand)";
    readonly 'color.text.danger': "var(--ds-text-danger)";
    readonly 'color.text.warning': "var(--ds-text-warning)";
    readonly 'color.text.warning.inverse': "var(--ds-text-warning-inverse)";
    readonly 'color.text.success': "var(--ds-text-success)";
    readonly 'color.text.discovery': "var(--ds-text-discovery)";
    readonly 'color.text.information': "var(--ds-text-information)";
    readonly 'color.text.subtlest': "var(--ds-text-subtlest)";
    readonly 'color.text.subtle': "var(--ds-text-subtle)";
    readonly 'color.link': "var(--ds-link)";
    readonly 'color.link.pressed': "var(--ds-link-pressed)";
    readonly 'color.link.visited': "var(--ds-link-visited)";
    readonly 'color.link.visited.pressed': "var(--ds-link-visited-pressed)";
};
export type TextColor = keyof typeof textColorMap;
export declare const fillMap: {
    readonly 'color.icon': "var(--ds-icon)";
    readonly 'color.icon.accent.lime': "var(--ds-icon-accent-lime)";
    readonly 'color.icon.accent.red': "var(--ds-icon-accent-red)";
    readonly 'color.icon.accent.orange': "var(--ds-icon-accent-orange)";
    readonly 'color.icon.accent.yellow': "var(--ds-icon-accent-yellow)";
    readonly 'color.icon.accent.green': "var(--ds-icon-accent-green)";
    readonly 'color.icon.accent.teal': "var(--ds-icon-accent-teal)";
    readonly 'color.icon.accent.blue': "var(--ds-icon-accent-blue)";
    readonly 'color.icon.accent.purple': "var(--ds-icon-accent-purple)";
    readonly 'color.icon.accent.magenta': "var(--ds-icon-accent-magenta)";
    readonly 'color.icon.accent.gray': "var(--ds-icon-accent-gray)";
    readonly 'color.icon.disabled': "var(--ds-icon-disabled)";
    readonly 'color.icon.inverse': "var(--ds-icon-inverse)";
    readonly 'color.icon.selected': "var(--ds-icon-selected)";
    readonly 'color.icon.brand': "var(--ds-icon-brand)";
    readonly 'color.icon.danger': "var(--ds-icon-danger)";
    readonly 'color.icon.warning': "var(--ds-icon-warning)";
    readonly 'color.icon.warning.inverse': "var(--ds-icon-warning-inverse)";
    readonly 'color.icon.success': "var(--ds-icon-success)";
    readonly 'color.icon.discovery': "var(--ds-icon-discovery)";
    readonly 'color.icon.information': "var(--ds-icon-information)";
    readonly 'color.icon.subtlest': "var(--ds-icon-subtlest)";
    readonly 'color.icon.subtle': "var(--ds-icon-subtle)";
};
export type Fill = keyof typeof fillMap;
/**
 * @codegenEnd
 */
/**
 * THIS SECTION WAS CREATED VIA CODEGEN DO NOT MODIFY {@see http://go/af-codegen}
 * @codegen <<SignedSource::042cbfe8041c09e3817ae74154994f32>>
 * @codegenId misc
 * @codegenCommand yarn workspace @atlaskit/primitives codegen-styles
 * @codegenParams ["layer"]
 * @codegenDependency ../../../primitives/scripts/codegen-file-templates/dimensions.tsx <<SignedSource::cc9b3f12104c6ede803da6a42daac0b0>>
 * @codegenDependency ../../../primitives/scripts/codegen-file-templates/layer.tsx <<SignedSource::92793ca02dbfdad66e53ffbe9f0baa0a>>
 */
export declare const layerMap: {
    readonly '1': 1;
    readonly card: 100;
    readonly navigation: 200;
    readonly dialog: 300;
    readonly layer: 400;
    readonly blanket: 500;
    readonly modal: 510;
    readonly flag: 600;
    readonly spotlight: 700;
    readonly tooltip: 800;
};
export type Layer = keyof typeof layerMap;
/**
 * @codegenEnd
 */
/**
 * THIS SECTION WAS CREATED VIA CODEGEN DO NOT MODIFY {@see http://go/af-codegen}
 * @codegen <<SignedSource::957baf1fa3fc3fe5eb06b497a7ba6599>>
 * @codegenId border
 * @codegenCommand yarn workspace @atlaskit/primitives codegen-styles
 * @codegenParams ["width", "radius"]
 * @codegenDependency ../../../tokens/src/artifacts/tokens-raw/atlassian-shape.tsx <<SignedSource::80457377fd80c31f5dfcb5cc743d7016>>
 */
export declare const borderWidthMap: {
    readonly 'border.width': "var(--ds-border-width)";
    readonly 'border.width.0': "var(--ds-border-width-0)";
    readonly 'border.width.indicator': "var(--ds-border-width-indicator)";
    readonly 'border.width.outline': "var(--ds-border-width-outline)";
};
export type BorderWidth = keyof typeof borderWidthMap;
export declare const borderRadiusMap: {
    readonly 'border.radius.050': "var(--ds-border-radius-050)";
    readonly 'border.radius': "var(--ds-border-radius)";
    readonly 'border.radius.100': "var(--ds-border-radius-100)";
    readonly 'border.radius.200': "var(--ds-border-radius-200)";
    readonly 'border.radius.300': "var(--ds-border-radius-300)";
    readonly 'border.radius.400': "var(--ds-border-radius-400)";
    readonly 'border.radius.circle': "var(--ds-border-radius-circle)";
};
export type BorderRadius = keyof typeof borderRadiusMap;
/**
 * @codegenEnd
 */
/**
 * THIS SECTION WAS CREATED VIA CODEGEN DO NOT MODIFY {@see http://go/af-codegen}
 * @codegen <<SignedSource::b2a06338babbfbea48ed2205e34084fc>>
 * @codegenId typography
 * @codegenCommand yarn workspace @atlaskit/primitives codegen-styles
 * @codegenParams ["fontSize", "fontWeight", "fontFamily", "lineHeight", "body", "ui"]
 * @codegenDependency ../../../primitives/scripts/codegen-file-templates/dimensions.tsx <<SignedSource::cc9b3f12104c6ede803da6a42daac0b0>>
 * @codegenDependency ../../../primitives/scripts/codegen-file-templates/layer.tsx <<SignedSource::92793ca02dbfdad66e53ffbe9f0baa0a>>
 */
export declare const fontMap: {
    'font.body': "var(--ds-font-body)";
    'font.body.UNSAFE_small': "var(--ds-font-body-UNSAFE_small)";
    'font.body.large': "var(--ds-font-body-large)";
    'font.body.small': "var(--ds-font-body-small)";
    'font.code': "var(--ds-font-code)";
    'font.heading.large': "var(--ds-font-heading-large)";
    'font.heading.medium': "var(--ds-font-heading-medium)";
    'font.heading.small': "var(--ds-font-heading-small)";
    'font.heading.xlarge': "var(--ds-font-heading-xlarge)";
    'font.heading.xsmall': "var(--ds-font-heading-xsmall)";
    'font.heading.xxlarge': "var(--ds-font-heading-xxlarge)";
    'font.heading.xxsmall': "var(--ds-font-heading-xxsmall)";
};
export type Font = keyof typeof fontMap;
export declare const fontWeightMap: {
    'font.weight.bold': "var(--ds-font-weight-bold)";
    'font.weight.medium': "var(--ds-font-weight-medium)";
    'font.weight.regular': "var(--ds-font-weight-regular)";
    'font.weight.semibold': "var(--ds-font-weight-semibold)";
};
export type FontWeight = keyof typeof fontWeightMap;
export declare const fontFamilyMap: {
    'font.family.body': "var(--ds-font-family-body)";
    'font.family.brand.body': "var(--ds-font-family-brand-body)";
    'font.family.brand.heading': "var(--ds-font-family-brand-heading)";
    'font.family.code': "var(--ds-font-family-code)";
    'font.family.heading': "var(--ds-font-family-heading)";
};
export type FontFamily = keyof typeof fontFamilyMap;
/**
 * @codegenEnd
 */
/**
 * THIS SECTION WAS CREATED VIA CODEGEN DO NOT MODIFY {@see http://go/af-codegen}
 * @codegen <<SignedSource::159df661d29a2805a17ab6f52e842350>>
 * @codegenId text
 * @codegenCommand yarn workspace @atlaskit/primitives codegen-styles
 * @codegenDependency ../../../primitives/scripts/codegen-file-templates/dimensions.tsx <<SignedSource::cc9b3f12104c6ede803da6a42daac0b0>>
 * @codegenDependency ../../../primitives/scripts/codegen-file-templates/layer.tsx <<SignedSource::92793ca02dbfdad66e53ffbe9f0baa0a>>
 */
export declare const textSizeMap: {
    medium: "var(--ds-font-body)";
    UNSAFE_small: "var(--ds-font-body-UNSAFE_small)";
    large: "var(--ds-font-body-large)";
    small: "var(--ds-font-body-small)";
};
export type TextSize = keyof typeof textSizeMap;
export declare const textWeightMap: {
    bold: "var(--ds-font-weight-bold)";
    medium: "var(--ds-font-weight-medium)";
    regular: "var(--ds-font-weight-regular)";
    semibold: "var(--ds-font-weight-semibold)";
};
export type TextWeight = keyof typeof textWeightMap;
/**
 * @codegenEnd
 */
type MarginSpace = AllSpace | 'auto' | '0';
type PaddingSpace = Space | '0';
type GlobalValue = 'inherit' | 'initial' | 'revert' | 'revert-layer' | 'unset';
type AutoComplete<T extends string> = T | Omit<string, T>;
export type TokenisedProps = {
    backgroundColor?: BackgroundColor;
    blockSize?: Dimension | string;
    borderBlockColor?: AutoComplete<BorderColor>;
    borderBlockEndColor?: AutoComplete<BorderColor>;
    borderBlockEndWidth?: BorderWidth | string;
    borderBlockStartColor?: AutoComplete<BorderColor>;
    borderBlockStartWidth?: BorderWidth | string;
    borderBlockWidth?: BorderWidth | string;
    borderBottomColor?: AutoComplete<BorderColor>;
    borderBottomLeftRadius?: BorderRadius | string;
    borderBottomRightRadius?: BorderRadius | string;
    borderBottomWidth?: BorderWidth | string;
    borderColor?: BorderColor;
    borderEndEndRadius?: BorderRadius | string;
    borderEndStartRadius?: BorderRadius | string;
    borderInlineColor?: AutoComplete<BorderColor>;
    borderInlineEndColor?: AutoComplete<BorderColor>;
    borderInlineEndWidth?: BorderWidth | string;
    borderInlineStartColor?: AutoComplete<BorderColor>;
    borderInlineStartWidth?: BorderWidth | string;
    borderInlineWidth?: BorderWidth | string;
    borderLeftColor?: AutoComplete<BorderColor>;
    borderLeftWidth?: BorderWidth | string;
    borderRadius?: BorderRadius | string;
    borderRightColor?: AutoComplete<BorderColor>;
    borderRightWidth?: BorderWidth | string;
    borderStartEndRadius?: BorderRadius | string;
    borderStartStartRadius?: BorderRadius | string;
    borderTopColor?: AutoComplete<BorderColor>;
    borderTopLeftRadius?: BorderRadius | string;
    borderTopRightRadius?: BorderRadius | string;
    borderTopWidth?: BorderWidth | string;
    borderWidth?: BorderWidth | string;
    bottom?: AutoComplete<AllSpace>;
    boxShadow?: Shadow;
    color?: TextColor;
    columnGap?: Space;
    font?: Font | string;
    fontFamily?: FontFamily | string;
    fontStyle?: 'normal' | 'italic';
    fontWeight?: FontWeight | string | number;
    gap?: Space;
    height?: Dimension | string;
    inlineSize?: Dimension | string;
    inset?: AutoComplete<AllSpace>;
    insetBlock?: AutoComplete<AllSpace>;
    insetBlockEnd?: AutoComplete<AllSpace>;
    insetBlockStart?: AutoComplete<AllSpace>;
    insetInline?: AutoComplete<AllSpace>;
    insetInlineEnd?: AutoComplete<AllSpace>;
    insetInlineStart?: AutoComplete<AllSpace>;
    left?: AutoComplete<AllSpace>;
    margin?: MarginSpace | '0 auto' | GlobalValue;
    marginBlock?: MarginSpace | GlobalValue;
    marginInline?: MarginSpace | GlobalValue;
    marginBlockEnd?: MarginSpace | GlobalValue;
    marginBlockStart?: MarginSpace | GlobalValue;
    marginBottom?: MarginSpace | GlobalValue;
    marginInlineEnd?: MarginSpace | GlobalValue;
    marginInlineStart?: MarginSpace | GlobalValue;
    marginLeft?: MarginSpace | GlobalValue;
    marginRight?: MarginSpace | GlobalValue;
    marginTop?: MarginSpace | GlobalValue;
    maxBlockSize?: Dimension | string;
    maxHeight?: Dimension | string;
    maxInlineSize?: Dimension | string;
    maxWidth?: Dimension | string;
    minBlockSize?: Dimension | string;
    minHeight?: Dimension | string;
    minInlineSize?: Dimension | string;
    minWidth?: Dimension | string;
    opacity?: AutoComplete<Opacity> | number;
    outlineColor?: BorderColor;
    outlineOffset?: AllSpace;
    outlineWidth?: BorderWidth | string;
    padding?: PaddingSpace | GlobalValue;
    paddingBlock?: PaddingSpace | GlobalValue;
    paddingBlockEnd?: PaddingSpace | GlobalValue;
    paddingBlockStart?: PaddingSpace | GlobalValue;
    paddingBottom?: PaddingSpace | GlobalValue;
    paddingInline?: PaddingSpace | GlobalValue;
    paddingInlineEnd?: PaddingSpace | GlobalValue;
    paddingInlineStart?: PaddingSpace | GlobalValue;
    paddingLeft?: PaddingSpace | GlobalValue;
    paddingRight?: PaddingSpace | GlobalValue;
    paddingTop?: PaddingSpace | GlobalValue;
    right?: AutoComplete<AllSpace>;
    rowGap?: Space;
    top?: AutoComplete<AllSpace>;
    width?: Dimension | string;
    zIndex?: Layer;
};
declare const spacingProperties: readonly ["padding", "paddingBlock", "paddingBlockStart", "paddingBlockEnd", "paddingInline", "paddingInlineStart", "paddingInlineEnd", "gap", "rowGap", "columnGap"];
type SpacingProperty = (typeof spacingProperties)[number];
type TokenMappableProperty = SpacingProperty | 'backgroundColor' | 'fontWeight' | 'fontSize' | 'fontFamily' | 'lineHeight' | 'color' | 'font' | typeof CURRENT_SURFACE_CSS_VAR;
type PropsToken = SpacingToken | BackgroundColorToken | FontWeightToken | FontFamilyToken | TextColorToken | FontToken | TextWeightToken | TextSizeToken;
type TokenMap = Partial<Record<PropsToken, ReturnType<typeof token>>>;
type SerializedStylesMap = Record<PropsToken, SerializedStyles>;
export declare const getSerializedStylesMap: (cssProperty: TokenMappableProperty, tokenMap: TokenMap) => SerializedStylesMap;
type SpacingToken = keyof typeof positiveSpaceMap;
type BackgroundColorToken = keyof typeof backgroundColorMap;
type SurfaceColorToken = keyof typeof surfaceColorMap;
type TextColorToken = keyof typeof textColorMap;
type FontWeightToken = keyof typeof fontWeightMap;
type FontFamilyToken = keyof typeof fontFamilyMap;
type FontToken = keyof typeof fontMap;
type TextWeightToken = keyof typeof textWeightMap;
type TextSizeToken = keyof typeof textSizeMap;
type SpacingStyleMap = Record<SpacingProperty, Record<SpacingToken, SerializedStyles>>;
type BackgroundColorStyleMap = Record<BackgroundColorToken, SerializedStyles>;
type SurfaceColorStyleMap = Record<SurfaceColorToken, SerializedStyles>;
type TextColorStyleMap = Record<TextColorToken, SerializedStyles>;
type FontWeightStyleMap = Record<FontWeightToken, SerializedStyles>;
type FontFamilyStyleMap = Record<FontFamilyToken, SerializedStyles>;
type FontStyleMap = Record<FontToken, SerializedStyles>;
type TextWeightStyleMap = Record<TextWeightToken, SerializedStyles>;
type TextStyleMap = Record<TextSizeToken, SerializedStyles>;
export declare const paddingStylesMap: SpacingStyleMap;
export declare const spaceStylesMap: SpacingStyleMap;
export declare const backgroundColorStylesMap: BackgroundColorStyleMap;
export declare const textColorStylesMap: TextColorStyleMap;
export declare const fontWeightStylesMap: FontWeightStyleMap;
export declare const fontFamilyStylesMap: FontFamilyStyleMap;
export declare const fontStylesMap: FontStyleMap;
export declare const textSizeStylesMap: TextStyleMap;
export declare const textWeightStylesMap: TextWeightStyleMap;
export declare const surfaceColorStylesMap: SurfaceColorStyleMap;
export declare const isSurfaceColorToken: (color: unknown) => color is "elevation.surface" | "elevation.surface.hovered" | "elevation.surface.pressed" | "elevation.surface.overlay" | "elevation.surface.overlay.hovered" | "elevation.surface.overlay.pressed" | "elevation.surface.raised" | "elevation.surface.raised.hovered" | "elevation.surface.raised.pressed" | "elevation.surface.sunken";
export {};
