"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _cssBoxModel = require("css-box-model");
var _getMaxWindowScroll = _interopRequireDefault(require("./get-max-window-scroll"));
var _getWindowScroll = _interopRequireDefault(require("./get-window-scroll"));
var _default = exports.default = function _default() {
  var scroll = (0, _getWindowScroll.default)();
  var maxScroll = (0, _getMaxWindowScroll.default)();
  var top = scroll.y;
  var left = scroll.x;

  // window.innerHeight: includes scrollbars (not what we want)
  // document.clientHeight gives us the correct value when using the html5 doctype
  var doc = document.documentElement;
  // Using these values as they do not consider scrollbars
  // padding box, without scrollbar
  var width = doc.clientWidth;
  var height = doc.clientHeight;

  // Computed
  var right = left + width;
  var bottom = top + height;
  var container = (0, _cssBoxModel.getRect)({
    top: top,
    left: left,
    right: right,
    bottom: bottom
  });
  var viewport = {
    container: container,
    scroll: {
      current: scroll,
      max: maxScroll
    }
  };
  return viewport;
};