/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.jarjar;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.pantsbuild.jarjar.Keep;
import org.pantsbuild.jarjar.PatternElement;
import org.pantsbuild.jarjar.Rule;
import org.pantsbuild.jarjar.Zap;

class RulesFileParser {
    private RulesFileParser() {
    }

    public static List<PatternElement> parse(File file) throws IOException {
        return RulesFileParser.parse(new FileReader(file));
    }

    public static List<PatternElement> parse(String string) throws IOException {
        return RulesFileParser.parse(new StringReader(string));
    }

    private static String stripComment(String string) {
        int n = string.indexOf("#");
        return n < 0 ? string : string.substring(0, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<PatternElement> parse(Reader reader) throws IOException {
        try {
            String[] stringArray;
            String string;
            String[] stringArray2 = new ArrayList();
            BufferedReader bufferedReader = new BufferedReader(reader);
            int n = 1;
            while ((string = bufferedReader.readLine()) != null) {
                if ("".equals(string = RulesFileParser.stripComment(string))) continue;
                stringArray = string.split("\\s+");
                if (stringArray.length < 2) {
                    RulesFileParser.error(n, stringArray);
                }
                String string2 = stringArray[0];
                PatternElement patternElement = null;
                if (string2.equals("rule")) {
                    if (stringArray.length < 3) {
                        RulesFileParser.error(n, stringArray);
                    }
                    Rule rule = new Rule();
                    rule.setResult(stringArray[2]);
                    patternElement = rule;
                } else if (string2.equals("zap")) {
                    patternElement = new Zap();
                } else if (string2.equals("keep")) {
                    patternElement = new Keep();
                } else {
                    RulesFileParser.error(n, stringArray);
                }
                patternElement.setPattern(stringArray[1]);
                stringArray2.add(patternElement);
                ++n;
            }
            stringArray = stringArray2;
            return stringArray;
        }
        finally {
            reader.close();
        }
    }

    private static void error(int n, String[] stringArray) {
        throw new IllegalArgumentException("Error on line " + n + ": " + Arrays.asList(stringArray));
    }
}

