/*
 * Decompiled with CFR 0.152.
 */
package io.bazel.kotlin.builder.tasks;

import io.bazel.kotlin.builder.tasks.KotlinBuilder;
import io.bazel.kotlin.builder.tasks.js.Kotlin2JsTaskExecutor;
import io.bazel.kotlin.builder.tasks.jvm.KotlinJvmTaskExecutor;
import io.bazel.kotlin.builder.toolchain.CompilationStatusException;
import io.bazel.kotlin.builder.toolchain.CompilationTaskContext;
import io.bazel.kotlin.builder.utils.ArgMap;
import io.bazel.kotlin.builder.utils.ArgMaps;
import io.bazel.kotlin.builder.utils.Flag;
import io.bazel.kotlin.builder.utils.IOUtils;
import io.bazel.kotlin.builder.utils.TaskUtilsKt;
import io.bazel.kotlin.model.CompilationTaskInfo;
import io.bazel.kotlin.model.JsCompilationTask;
import io.bazel.kotlin.model.JvmCompilationTask;
import io.bazel.kotlin.model.Platform;
import io.bazel.kotlin.model.RuleKind;
import io.bazel.worker.WorkerContext;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroup;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Singleton
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 %2\u00020\u0001:\u0001%B\u0017\b\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ*\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u0012\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0010H\u0002J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0010H\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u0010H\u0002J \u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0010H\u0002J \u0010!\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0010H\u0002J\u0018\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020\r2\u0006\u0010$\u001a\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lio/bazel/kotlin/builder/tasks/KotlinBuilder;", "", "jvmTaskExecutor", "Lio/bazel/kotlin/builder/tasks/jvm/KotlinJvmTaskExecutor;", "jsTaskExecutor", "Lio/bazel/kotlin/builder/tasks/js/Kotlin2JsTaskExecutor;", "(Lio/bazel/kotlin/builder/tasks/jvm/KotlinJvmTaskExecutor;Lio/bazel/kotlin/builder/tasks/js/Kotlin2JsTaskExecutor;)V", "build", "", "taskContext", "Lio/bazel/worker/WorkerContext$TaskContext;", "args", "", "", "buildContext", "Lkotlin/Pair;", "Lio/bazel/kotlin/builder/utils/ArgMap;", "Lio/bazel/kotlin/builder/toolchain/CompilationTaskContext;", "ctx", "buildJsTask", "Lio/bazel/kotlin/model/JsCompilationTask;", "info", "Lio/bazel/kotlin/model/CompilationTaskInfo;", "workingDir", "Ljava/nio/file/Path;", "argMap", "buildJvmTask", "Lio/bazel/kotlin/model/JvmCompilationTask;", "buildTaskInfo", "Lio/bazel/kotlin/model/CompilationTaskInfo$Builder;", "executeJsTask", "", "context", "executeJvmTask", "getOutputDirPath", "moduleName", "dirName", "Companion", "src_main_kotlin_io_bazel_kotlin_builder_tasks-tasks"})
public final class KotlinBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KotlinJvmTaskExecutor jvmTaskExecutor;
    @NotNull
    private final Kotlin2JsTaskExecutor jsTaskExecutor;
    @NotNull
    private static final Regex FLAGFILE_RE;

    @Inject
    public KotlinBuilder(@NotNull KotlinJvmTaskExecutor jvmTaskExecutor, @NotNull Kotlin2JsTaskExecutor jsTaskExecutor) {
        Intrinsics.checkNotNullParameter(jvmTaskExecutor, "jvmTaskExecutor");
        Intrinsics.checkNotNullParameter(jsTaskExecutor, "jsTaskExecutor");
        this.jvmTaskExecutor = jvmTaskExecutor;
        this.jsTaskExecutor = jsTaskExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int build(@NotNull WorkerContext.TaskContext taskContext, @NotNull List<String> args2) {
        Intrinsics.checkNotNullParameter(taskContext, "taskContext");
        Intrinsics.checkNotNullParameter(args2, "args");
        Pair<ArgMap, CompilationTaskContext> pair = this.buildContext(taskContext, args2);
        ArgMap argMap = pair.component1();
        CompilationTaskContext compileContext = pair.component2();
        boolean success = false;
        int status = 0;
        try {
            Platform platform = compileContext.getInfo().getPlatform();
            switch (platform == null ? -1 : WhenMappings.$EnumSwitchMapping$0[platform.ordinal()]) {
                case 1: {
                    this.executeJvmTask(compileContext, taskContext.getDirectory(), argMap);
                    break;
                }
                case 2: {
                    this.executeJsTask(compileContext, taskContext.getDirectory(), argMap);
                    break;
                }
                case 3: {
                    throw new IllegalStateException("unrecognized platform: " + compileContext.getInfo());
                }
            }
            success = true;
        }
        catch (CompilationStatusException ex) {
            taskContext.error(new Function0<String>(ex){
                final /* synthetic */ CompilationStatusException $ex;
                {
                    this.$ex = $ex;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Compilation failure: " + this.$ex.getMessage();
                }
            });
            status = ex.getStatus();
        }
        catch (Throwable throwable) {
            taskContext.error(throwable, build.2.INSTANCE);
        }
        finally {
            compileContext.finalize(success);
        }
        return status;
    }

    private final Pair<ArgMap, CompilationTaskContext> buildContext(WorkerContext.TaskContext ctx, List<String> args2) {
        List<String> list;
        if (!(!((Collection)args2).isEmpty())) {
            boolean $i$a$-check-KotlinBuilder$buildContext$22 = false;
            String $i$a$-check-KotlinBuilder$buildContext$22 = "expected at least a single arg got: " + CollectionsKt.joinToString$default(args2, " ", null, null, 0, null, null, 62, null);
            throw new IllegalStateException($i$a$-check-KotlinBuilder$buildContext$22.toString());
        }
        Object object = FLAGFILE_RE.matchEntire(args2.get(0));
        if (object != null && (object = object.getGroups()) != null && (object = object.get(1)) != null) {
            Object it = object;
            boolean bl = false;
            list = Files.readAllLines(FileSystems.getDefault().getPath(((MatchGroup)it).getValue(), new String[0]), StandardCharsets.UTF_8);
        } else {
            list = null;
        }
        List<String> $i$a$-check-KotlinBuilder$buildContext$22 = list;
        List<String> lines = $i$a$-check-KotlinBuilder$buildContext$22 == null ? args2 : $i$a$-check-KotlinBuilder$buildContext$22;
        ArgMap argMap = ArgMaps.from(lines);
        CompilationTaskInfo info = this.buildTaskInfo(argMap).build();
        Intrinsics.checkNotNullExpressionValue(info, "info");
        CompilationTaskContext context = new CompilationTaskContext(info, ctx.asPrintStream(), null, 4, null);
        return new Pair<ArgMap, CompilationTaskContext>(argMap, context);
    }

    /*
     * WARNING - void declaration
     */
    private final CompilationTaskInfo.Builder buildTaskInfo(ArgMap argMap) {
        void var2_2;
        CompilationTaskInfo.Builder $this$buildTaskInfo_u24lambda_u248 = CompilationTaskInfo.newBuilder();
        boolean bl = false;
        $this$buildTaskInfo_u24lambda_u248.addAllDebug((Iterable<String>)argMap.mandatory(Companion.KotlinBuilderFlags.DEBUG));
        $this$buildTaskInfo_u24lambda_u248.setLabel(argMap.mandatorySingle(Companion.KotlinBuilderFlags.TARGET_LABEL));
        Object object = new String[]{"_"};
        Object it = object = StringsKt.split$default((CharSequence)argMap.mandatorySingle(Companion.KotlinBuilderFlags.RULE_KIND), (String[])object, false, 0, 6, null);
        boolean bl2 = false;
        if (!(it.size() == 3 && Intrinsics.areEqual(it.get(0), "kt"))) {
            boolean $i$a$-check-KotlinBuilder$buildTaskInfo$1$1$22 = false;
            String $i$a$-check-KotlinBuilder$buildTaskInfo$1$1$22 = "invalid rule kind " + it;
            throw new IllegalStateException($i$a$-check-KotlinBuilder$buildTaskInfo$1$1$22.toString());
        }
        CompilationTaskInfo.Builder builder = $this$buildTaskInfo_u24lambda_u248;
        String string = ((String)it.get(1)).toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).toUpperCase(Locale.ROOT)");
        Platform platform = Platform.valueOf(string);
        if (platform == null) {
            CompilationTaskInfo.Builder builder2 = builder;
            boolean $i$a$-checkNotNull-KotlinBuilder$buildTaskInfo$1$1$42 = false;
            CompilationTaskInfo.Builder builder3 = builder2;
            String $i$a$-checkNotNull-KotlinBuilder$buildTaskInfo$1$1$42 = "unrecognized platform " + (String)it.get(1);
            throw new IllegalStateException($i$a$-checkNotNull-KotlinBuilder$buildTaskInfo$1$1$42.toString());
        }
        builder.setPlatform(platform);
        CompilationTaskInfo.Builder builder4 = $this$buildTaskInfo_u24lambda_u248;
        String string2 = ((String)it.get(2)).toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).toUpperCase(Locale.ROOT)");
        RuleKind ruleKind = RuleKind.valueOf(string2);
        if (ruleKind == null) {
            CompilationTaskInfo.Builder builder5 = builder4;
            boolean $i$a$-checkNotNull-KotlinBuilder$buildTaskInfo$1$1$52 = false;
            CompilationTaskInfo.Builder builder6 = builder5;
            String $i$a$-checkNotNull-KotlinBuilder$buildTaskInfo$1$1$52 = "unrecognized rule kind " + (String)it.get(2);
            throw new IllegalStateException($i$a$-checkNotNull-KotlinBuilder$buildTaskInfo$1$1$52.toString());
        }
        builder4.setRuleKind(ruleKind);
        it = object = argMap.mandatorySingle(Companion.KotlinBuilderFlags.MODULE_NAME);
        CompilationTaskInfo.Builder builder7 = $this$buildTaskInfo_u24lambda_u248;
        boolean bl3 = false;
        if (!(!StringsKt.isBlank((CharSequence)it))) {
            boolean $i$a$-check-KotlinBuilder$buildTaskInfo$1$2$22 = false;
            String $i$a$-check-KotlinBuilder$buildTaskInfo$1$2$22 = "--kotlin_module_name should not be blank";
            throw new IllegalStateException($i$a$-check-KotlinBuilder$buildTaskInfo$1$2$22.toString());
        }
        builder7.setModuleName((String)object);
        List<String> list = argMap.optional(Companion.KotlinBuilderFlags.PASSTHROUGH_FLAGS);
        $this$buildTaskInfo_u24lambda_u248.addAllPassthroughFlags(list != null ? (Iterable)list : (Iterable)CollectionsKt.emptyList());
        List<String> list2 = argMap.optional(Companion.KotlinBuilderFlags.FRIEND_PATHS);
        if (list2 != null) {
            List<String> list3 = list2;
            Intrinsics.checkNotNullExpressionValue($this$buildTaskInfo_u24lambda_u248, "buildTaskInfo$lambda$8");
            CompilationTaskInfo.Builder builder8 = $this$buildTaskInfo_u24lambda_u248;
            Iterable p0 = list3;
            boolean bl4 = false;
            builder8.addAllFriendPaths(p0);
        }
        $this$buildTaskInfo_u24lambda_u248.getToolchainInfoBuilder().getCommonBuilder().setApiVersion(argMap.mandatorySingle(Companion.KotlinBuilderFlags.API_VERSION));
        $this$buildTaskInfo_u24lambda_u248.getToolchainInfoBuilder().getCommonBuilder().setLanguageVersion(argMap.mandatorySingle(Companion.KotlinBuilderFlags.LANGUAGE_VERSION));
        $this$buildTaskInfo_u24lambda_u248.setStrictKotlinDeps(argMap.mandatorySingle(Companion.KotlinBuilderFlags.STRICT_KOTLIN_DEPS));
        $this$buildTaskInfo_u24lambda_u248.setReducedClasspathMode(argMap.mandatorySingle(Companion.KotlinBuilderFlags.REDUCED_CLASSPATH_MODE));
        void v10 = var2_2;
        Intrinsics.checkNotNullExpressionValue(v10, "with(CompilationTaskInfo\u2026ODE)\n        this\n      }");
        return v10;
    }

    private final void executeJsTask(CompilationTaskContext context, Path workingDir, ArgMap argMap) {
        JsCompilationTask jsTask = this.buildJsTask(context.getInfo(), workingDir, argMap);
        boolean bl = false;
        context.whenTracing((Function1)new Function1<CompilationTaskContext, Unit>(jsTask){
            final /* synthetic */ JsCompilationTask $jsTask;
            {
                this.$jsTask = $jsTask;
                super(1);
            }

            public final void invoke(@NotNull CompilationTaskContext $this$whenTracing) {
                Intrinsics.checkNotNullParameter($this$whenTracing, "$this$whenTracing");
                $this$whenTracing.printProto("js task input", this.$jsTask);
            }
        });
        this.jsTaskExecutor.execute(context, jsTask);
    }

    private final JsCompilationTask buildJsTask(CompilationTaskInfo info, Path workingDir, ArgMap argMap) {
        JsCompilationTask.Builder $this$buildJsTask_u24lambda_u2413 = JsCompilationTask.newBuilder();
        boolean bl = false;
        $this$buildJsTask_u24lambda_u2413.setInfo(info);
        JsCompilationTask.Directories.Builder $this$buildJsTask_u24lambda_u2413_u24lambda_u2410 = $this$buildJsTask_u24lambda_u2413.getDirectoriesBuilder();
        boolean bl2 = false;
        $this$buildJsTask_u24lambda_u2413_u24lambda_u2410.setTemp(((Object)workingDir).toString());
        JsCompilationTask.Inputs.Builder $this$buildJsTask_u24lambda_u2413_u24lambda_u2411 = $this$buildJsTask_u24lambda_u2413.getInputsBuilder();
        boolean bl3 = false;
        $this$buildJsTask_u24lambda_u2413_u24lambda_u2411.addAllLibraries((Iterable<String>)argMap.mandatory(Companion.KotlinBuilderFlags.JS_LIBRARIES));
        $this$buildJsTask_u24lambda_u2413_u24lambda_u2411.addAllKotlinSources((Iterable<String>)argMap.mandatory(Companion.KotlinBuilderFlags.SOURCES));
        JsCompilationTask.Outputs.Builder $this$buildJsTask_u24lambda_u2413_u24lambda_u2412 = $this$buildJsTask_u24lambda_u2413.getOutputsBuilder();
        boolean bl4 = false;
        $this$buildJsTask_u24lambda_u2413_u24lambda_u2412.setJs(argMap.mandatorySingle(Companion.KotlinBuilderFlags.OUTPUT));
        $this$buildJsTask_u24lambda_u2413_u24lambda_u2412.setJar(argMap.mandatorySingle(Companion.KotlinBuilderFlags.OUTPUT_JS_JAR));
        $this$buildJsTask_u24lambda_u2413_u24lambda_u2412.setSrcjar(argMap.mandatorySingle(Companion.KotlinBuilderFlags.OUTPUT_SRCJAR));
        $this$buildJsTask_u24lambda_u2413.addAllPassThroughFlags((Iterable<String>)argMap.mandatory(Companion.KotlinBuilderFlags.JS_PASSTHROUGH_FLAGS));
        JsCompilationTask jsCompilationTask = $this$buildJsTask_u24lambda_u2413.build();
        Intrinsics.checkNotNullExpressionValue(jsCompilationTask, "with(JsCompilationTask.n\u2026)\n        build()\n      }");
        return jsCompilationTask;
    }

    private final void executeJvmTask(CompilationTaskContext context, Path workingDir, ArgMap argMap) {
        JvmCompilationTask task = this.buildJvmTask(context.getInfo(), workingDir, argMap);
        context.whenTracing((Function1)new Function1<CompilationTaskContext, Unit>(task){
            final /* synthetic */ JvmCompilationTask $task;
            {
                this.$task = $task;
                super(1);
            }

            public final void invoke(@NotNull CompilationTaskContext $this$whenTracing) {
                Intrinsics.checkNotNullParameter($this$whenTracing, "$this$whenTracing");
                $this$whenTracing.printProto("jvm task message:", this.$task);
            }
        });
        this.jvmTaskExecutor.execute(context, task);
    }

    private final JvmCompilationTask buildJvmTask(CompilationTaskInfo info, Path workingDir, ArgMap argMap) {
        String string;
        String it;
        JvmCompilationTask.Builder root = JvmCompilationTask.newBuilder();
        boolean bl = false;
        root.setInfo(info);
        root.setCompileKotlin(Boolean.parseBoolean(argMap.mandatorySingle(Companion.KotlinBuilderFlags.BUILD_KOTLIN)));
        root.setInstrumentCoverage(Boolean.parseBoolean(argMap.mandatorySingle(Companion.KotlinBuilderFlags.INSTRUMENT_COVERAGE)));
        JvmCompilationTask.Outputs.Builder $this$buildJvmTask_u24lambda_u2427_u24lambda_u2422 = root.getOutputsBuilder();
        boolean bl2 = false;
        String string2 = argMap.optionalSingle(Companion.KotlinBuilderFlags.OUTPUT);
        if (string2 != null) {
            it = string2;
            boolean bl3 = false;
            $this$buildJvmTask_u24lambda_u2427_u24lambda_u2422.setJar(it);
        }
        String string3 = argMap.optionalSingle(Companion.KotlinBuilderFlags.OUTPUT_SRCJAR);
        if (string3 != null) {
            it = string3;
            boolean bl4 = false;
            $this$buildJvmTask_u24lambda_u2427_u24lambda_u2422.setSrcjar(it);
        }
        String string4 = argMap.optionalSingle(Companion.KotlinBuilderFlags.OUTPUT_JDEPS);
        if (string4 != null) {
            String $this$buildJvmTask_u24lambda_u2427_u24lambda_u2422_u24lambda_u2416 = string = string4;
            boolean bl5 = false;
            $this$buildJvmTask_u24lambda_u2427_u24lambda_u2422.setJdeps($this$buildJvmTask_u24lambda_u2427_u24lambda_u2422_u24lambda_u2416);
        }
        String string5 = argMap.optionalSingle(Companion.KotlinBuilderFlags.GENERATED_JAVA_SRC_JAR);
        if (string5 != null) {
            String $this$buildJvmTask_u24lambda_u2427_u24lambda_u2422_u24lambda_u2417 = string = string5;
            boolean bl6 = false;
            $this$buildJvmTask_u24lambda_u2427_u24lambda_u2422.setGeneratedJavaSrcJar($this$buildJvmTask_u24lambda_u2427_u24lambda_u2422_u24lambda_u2417);
        }
        String string6 = argMap.optionalSingle(Companion.KotlinBuilderFlags.GENERATED_JAVA_STUB_JAR);
        if (string6 != null) {
            String $this$buildJvmTask_u24lambda_u2427_u24lambda_u2422_u24lambda_u2418 = string = string6;
            boolean bl7 = false;
            $this$buildJvmTask_u24lambda_u2427_u24lambda_u2422.setGeneratedJavaStubJar($this$buildJvmTask_u24lambda_u2427_u24lambda_u2422_u24lambda_u2418);
        }
        String string7 = argMap.optionalSingle(Companion.KotlinBuilderFlags.ABI_JAR);
        if (string7 != null) {
            it = string7;
            boolean bl8 = false;
            $this$buildJvmTask_u24lambda_u2427_u24lambda_u2422.setAbijar(it);
        }
        String string8 = argMap.optionalSingle(Companion.KotlinBuilderFlags.GENERATED_CLASS_JAR);
        if (string8 != null) {
            it = string8;
            boolean bl9 = false;
            $this$buildJvmTask_u24lambda_u2427_u24lambda_u2422.setGeneratedClassJar(it);
        }
        String string9 = argMap.optionalSingle(Companion.KotlinBuilderFlags.KSP_GENERATED_JAVA_SRCJAR);
        if (string9 != null) {
            it = string9;
            boolean bl10 = false;
            $this$buildJvmTask_u24lambda_u2427_u24lambda_u2422.setGeneratedKspSrcJar(it);
        }
        JvmCompilationTask.Directories.Builder $this$buildJvmTask_u24lambda_u2427_u24lambda_u2423 = root.getDirectoriesBuilder();
        boolean bl11 = false;
        String moduleName = argMap.mandatorySingle(Companion.KotlinBuilderFlags.MODULE_NAME);
        Object object = new String[]{this.getOutputDirPath(moduleName, "classes")};
        $this$buildJvmTask_u24lambda_u2427_u24lambda_u2423.setClasses(((Object)IOUtils.resolveNewDirectories(workingDir, (String[])object)).toString());
        object = new String[]{this.getOutputDirPath(moduleName, "java_classes")};
        $this$buildJvmTask_u24lambda_u2427_u24lambda_u2423.setJavaClasses(((Object)IOUtils.resolveNewDirectories(workingDir, (String[])object)).toString());
        object = new Flag[]{Companion.KotlinBuilderFlags.ABI_JAR};
        if (argMap.hasAll((Flag[])object)) {
            object = new String[]{this.getOutputDirPath(moduleName, "abi_classes")};
            $this$buildJvmTask_u24lambda_u2427_u24lambda_u2423.setAbiClasses(((Object)IOUtils.resolveNewDirectories(workingDir, (String[])object)).toString());
        }
        object = new String[]{this.getOutputDirPath(moduleName, "generated_classes")};
        $this$buildJvmTask_u24lambda_u2427_u24lambda_u2423.setGeneratedClasses(((Object)IOUtils.resolveNewDirectories(workingDir, (String[])object)).toString());
        object = new String[]{this.getOutputDirPath(moduleName, "temp")};
        $this$buildJvmTask_u24lambda_u2427_u24lambda_u2423.setTemp(((Object)IOUtils.resolveNewDirectories(workingDir, (String[])object)).toString());
        object = new String[]{this.getOutputDirPath(moduleName, "generated_sources")};
        $this$buildJvmTask_u24lambda_u2427_u24lambda_u2423.setGeneratedSources(((Object)IOUtils.resolveNewDirectories(workingDir, (String[])object)).toString());
        object = new String[]{this.getOutputDirPath(moduleName, "generated_java_sources")};
        $this$buildJvmTask_u24lambda_u2427_u24lambda_u2423.setGeneratedJavaSources(((Object)IOUtils.resolveNewDirectories(workingDir, (String[])object)).toString());
        object = new String[]{this.getOutputDirPath(moduleName, "stubs")};
        $this$buildJvmTask_u24lambda_u2427_u24lambda_u2423.setGeneratedStubClasses(((Object)IOUtils.resolveNewDirectories(workingDir, (String[])object)).toString());
        object = new String[]{this.getOutputDirPath(moduleName, "coverage-metadata")};
        $this$buildJvmTask_u24lambda_u2427_u24lambda_u2423.setCoverageMetadataClasses(((Object)IOUtils.resolveNewDirectories(workingDir, (String[])object)).toString());
        JvmCompilationTask.Inputs.Builder $this$buildJvmTask_u24lambda_u2427_u24lambda_u2425 = root.getInputsBuilder();
        boolean bl12 = false;
        $this$buildJvmTask_u24lambda_u2427_u24lambda_u2425.addAllClasspath((Iterable<String>)argMap.mandatory(Companion.KotlinBuilderFlags.CLASSPATH));
        List<String> list = argMap.optional(Companion.KotlinBuilderFlags.DEPS_ARTIFACTS);
        $this$buildJvmTask_u24lambda_u2427_u24lambda_u2425.addAllDepsArtifacts(list != null ? (Iterable)list : (Iterable)CollectionsKt.emptyList());
        $this$buildJvmTask_u24lambda_u2427_u24lambda_u2425.addAllDirectDependencies((Iterable<String>)argMap.mandatory(Companion.KotlinBuilderFlags.DIRECT_DEPENDENCIES));
        List<String> list2 = argMap.optional(Companion.KotlinBuilderFlags.PROCESSORS);
        $this$buildJvmTask_u24lambda_u2427_u24lambda_u2425.addAllProcessors(list2 != null ? (Iterable)list2 : (Iterable)CollectionsKt.emptyList());
        List<String> list3 = argMap.optional(Companion.KotlinBuilderFlags.PROCESSOR_PATH);
        $this$buildJvmTask_u24lambda_u2427_u24lambda_u2425.addAllProcessorpaths(list3 != null ? (Iterable)list3 : (Iterable)CollectionsKt.emptyList());
        List<String> list4 = argMap.optional(Companion.KotlinBuilderFlags.STUBS_PLUGIN_OPTIONS);
        $this$buildJvmTask_u24lambda_u2427_u24lambda_u2425.addAllStubsPluginOptions(list4 != null ? (Iterable)list4 : (Iterable)CollectionsKt.emptyList());
        List<String> list5 = argMap.optional(Companion.KotlinBuilderFlags.STUBS_PLUGIN_CLASS_PATH);
        $this$buildJvmTask_u24lambda_u2427_u24lambda_u2425.addAllStubsPluginClasspath(list5 != null ? (Iterable)list5 : (Iterable)CollectionsKt.emptyList());
        List<String> list6 = argMap.optional(Companion.KotlinBuilderFlags.COMPILER_PLUGIN_OPTIONS);
        $this$buildJvmTask_u24lambda_u2427_u24lambda_u2425.addAllCompilerPluginOptions(list6 != null ? (Iterable)list6 : (Iterable)CollectionsKt.emptyList());
        List<String> list7 = argMap.optional(Companion.KotlinBuilderFlags.COMPILER_PLUGIN_CLASS_PATH);
        $this$buildJvmTask_u24lambda_u2427_u24lambda_u2425.addAllCompilerPluginClasspath(list7 != null ? (Iterable)list7 : (Iterable)CollectionsKt.emptyList());
        List<String> list8 = argMap.optional(Companion.KotlinBuilderFlags.SOURCES);
        if (list8 != null && (object = list8.iterator()) != null) {
            TaskUtilsKt.partitionJvmSources((Iterator<String>)object, (Function1<? super String, Unit>)new Function1<String, Unit>($this$buildJvmTask_u24lambda_u2427_u24lambda_u2425){
                final /* synthetic */ JvmCompilationTask.Inputs.Builder $this_with;
                {
                    this.$this_with = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    this.$this_with.addKotlinSources(it);
                }
            }, (Function1<? super String, Unit>)new Function1<String, Unit>($this$buildJvmTask_u24lambda_u2427_u24lambda_u2425){
                final /* synthetic */ JvmCompilationTask.Inputs.Builder $this_with;
                {
                    this.$this_with = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    this.$this_with.addJavaSources(it);
                }
            });
        }
        list8 = argMap.optional(Companion.KotlinBuilderFlags.SOURCE_JARS);
        if (list8 != null) {
            Object it2 = object = list8;
            boolean bl13 = false;
            $this$buildJvmTask_u24lambda_u2427_u24lambda_u2425.addAllSourceJars((Iterable)it2);
        }
        CompilationTaskInfo.Builder $this$buildJvmTask_u24lambda_u2427_u24lambda_u2426 = root.getInfoBuilder();
        boolean bl14 = false;
        $this$buildJvmTask_u24lambda_u2427_u24lambda_u2426.getToolchainInfoBuilder().getJvmBuilder().setJvmTarget(argMap.mandatorySingle(Companion.KotlinBuilderFlags.JVM_TARGET));
        JvmCompilationTask jvmCompilationTask = root.build();
        Intrinsics.checkNotNullExpressionValue(jvmCompilationTask, "newBuilder().let { root \u2026     root.build()\n      }");
        return jvmCompilationTask;
    }

    private final String getOutputDirPath(String moduleName, String dirName) {
        return "_kotlinc/" + moduleName + "_jvm/" + dirName;
    }

    static {
        Pattern pattern = Pattern.compile("^--flagfile=((.*)-(\\d+).params)$");
        Intrinsics.checkNotNullExpressionValue(pattern, "compile(\"\"\"^--flagfile=((.*)-(\\d+).params)$\"\"\")");
        Pattern pattern2 = pattern;
        FLAGFILE_RE = new Regex(pattern2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0006B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u00a8\u0006\u0007"}, d2={"Lio/bazel/kotlin/builder/tasks/KotlinBuilder$Companion;", "", "()V", "FLAGFILE_RE", "Lkotlin/text/Regex;", "getFLAGFILE_RE$annotations", "KotlinBuilderFlags", "src_main_kotlin_io_bazel_kotlin_builder_tasks-tasks"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getFLAGFILE_RE$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b)\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002B\u000f\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001ej\u0002\b\u001fj\u0002\b j\u0002\b!j\u0002\b\"j\u0002\b#j\u0002\b$j\u0002\b%j\u0002\b&j\u0002\b'j\u0002\b(j\u0002\b)j\u0002\b*j\u0002\b+j\u0002\b,\u00a8\u0006-"}, d2={"Lio/bazel/kotlin/builder/tasks/KotlinBuilder$Companion$KotlinBuilderFlags;", "", "Lio/bazel/kotlin/builder/utils/Flag;", "flag", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getFlag", "()Ljava/lang/String;", "TARGET_LABEL", "CLASSPATH", "DIRECT_DEPENDENCIES", "DEPS_ARTIFACTS", "SOURCES", "SOURCE_JARS", "PROCESSOR_PATH", "PROCESSORS", "STUBS_PLUGIN_OPTIONS", "STUBS_PLUGIN_CLASS_PATH", "COMPILER_PLUGIN_OPTIONS", "COMPILER_PLUGIN_CLASS_PATH", "OUTPUT", "RULE_KIND", "MODULE_NAME", "PASSTHROUGH_FLAGS", "API_VERSION", "LANGUAGE_VERSION", "JVM_TARGET", "OUTPUT_SRCJAR", "GENERATED_CLASSDIR", "FRIEND_PATHS", "OUTPUT_JDEPS", "OUTPUT_JS_JAR", "JS_PASSTHROUGH_FLAGS", "JS_LIBRARIES", "DEBUG", "TASK_ID", "ABI_JAR", "GENERATED_JAVA_SRC_JAR", "GENERATED_JAVA_STUB_JAR", "GENERATED_CLASS_JAR", "BUILD_KOTLIN", "STRICT_KOTLIN_DEPS", "REDUCED_CLASSPATH_MODE", "INSTRUMENT_COVERAGE", "KSP_GENERATED_JAVA_SRCJAR", "src_main_kotlin_io_bazel_kotlin_builder_tasks-tasks"})
        public static final class KotlinBuilderFlags
        extends Enum<KotlinBuilderFlags>
        implements Flag {
            @NotNull
            private final String flag;
            public static final /* enum */ KotlinBuilderFlags TARGET_LABEL = new KotlinBuilderFlags("--target_label");
            public static final /* enum */ KotlinBuilderFlags CLASSPATH = new KotlinBuilderFlags("--classpath");
            public static final /* enum */ KotlinBuilderFlags DIRECT_DEPENDENCIES = new KotlinBuilderFlags("--direct_dependencies");
            public static final /* enum */ KotlinBuilderFlags DEPS_ARTIFACTS = new KotlinBuilderFlags("--deps_artifacts");
            public static final /* enum */ KotlinBuilderFlags SOURCES = new KotlinBuilderFlags("--sources");
            public static final /* enum */ KotlinBuilderFlags SOURCE_JARS = new KotlinBuilderFlags("--source_jars");
            public static final /* enum */ KotlinBuilderFlags PROCESSOR_PATH = new KotlinBuilderFlags("--processorpath");
            public static final /* enum */ KotlinBuilderFlags PROCESSORS = new KotlinBuilderFlags("--processors");
            public static final /* enum */ KotlinBuilderFlags STUBS_PLUGIN_OPTIONS = new KotlinBuilderFlags("--stubs_plugin_options");
            public static final /* enum */ KotlinBuilderFlags STUBS_PLUGIN_CLASS_PATH = new KotlinBuilderFlags("--stubs_plugin_classpath");
            public static final /* enum */ KotlinBuilderFlags COMPILER_PLUGIN_OPTIONS = new KotlinBuilderFlags("--compiler_plugin_options");
            public static final /* enum */ KotlinBuilderFlags COMPILER_PLUGIN_CLASS_PATH = new KotlinBuilderFlags("--compiler_plugin_classpath");
            public static final /* enum */ KotlinBuilderFlags OUTPUT = new KotlinBuilderFlags("--output");
            public static final /* enum */ KotlinBuilderFlags RULE_KIND = new KotlinBuilderFlags("--rule_kind");
            public static final /* enum */ KotlinBuilderFlags MODULE_NAME = new KotlinBuilderFlags("--kotlin_module_name");
            public static final /* enum */ KotlinBuilderFlags PASSTHROUGH_FLAGS = new KotlinBuilderFlags("--kotlin_passthrough_flags");
            public static final /* enum */ KotlinBuilderFlags API_VERSION = new KotlinBuilderFlags("--kotlin_api_version");
            public static final /* enum */ KotlinBuilderFlags LANGUAGE_VERSION = new KotlinBuilderFlags("--kotlin_language_version");
            public static final /* enum */ KotlinBuilderFlags JVM_TARGET = new KotlinBuilderFlags("--kotlin_jvm_target");
            public static final /* enum */ KotlinBuilderFlags OUTPUT_SRCJAR = new KotlinBuilderFlags("--kotlin_output_srcjar");
            public static final /* enum */ KotlinBuilderFlags GENERATED_CLASSDIR = new KotlinBuilderFlags("--kotlin_generated_classdir");
            public static final /* enum */ KotlinBuilderFlags FRIEND_PATHS = new KotlinBuilderFlags("--kotlin_friend_paths");
            public static final /* enum */ KotlinBuilderFlags OUTPUT_JDEPS = new KotlinBuilderFlags("--kotlin_output_jdeps");
            public static final /* enum */ KotlinBuilderFlags OUTPUT_JS_JAR = new KotlinBuilderFlags("--kotlin_output_js_jar");
            public static final /* enum */ KotlinBuilderFlags JS_PASSTHROUGH_FLAGS = new KotlinBuilderFlags("--kotlin_js_passthrough_flags");
            public static final /* enum */ KotlinBuilderFlags JS_LIBRARIES = new KotlinBuilderFlags("--kotlin_js_libraries");
            public static final /* enum */ KotlinBuilderFlags DEBUG = new KotlinBuilderFlags("--kotlin_debug_tags");
            public static final /* enum */ KotlinBuilderFlags TASK_ID = new KotlinBuilderFlags("--kotlin_task_id");
            public static final /* enum */ KotlinBuilderFlags ABI_JAR = new KotlinBuilderFlags("--abi_jar");
            public static final /* enum */ KotlinBuilderFlags GENERATED_JAVA_SRC_JAR = new KotlinBuilderFlags("--generated_java_srcjar");
            public static final /* enum */ KotlinBuilderFlags GENERATED_JAVA_STUB_JAR = new KotlinBuilderFlags("--kapt_generated_stub_jar");
            public static final /* enum */ KotlinBuilderFlags GENERATED_CLASS_JAR = new KotlinBuilderFlags("--kapt_generated_class_jar");
            public static final /* enum */ KotlinBuilderFlags BUILD_KOTLIN = new KotlinBuilderFlags("--build_kotlin");
            public static final /* enum */ KotlinBuilderFlags STRICT_KOTLIN_DEPS = new KotlinBuilderFlags("--strict_kotlin_deps");
            public static final /* enum */ KotlinBuilderFlags REDUCED_CLASSPATH_MODE = new KotlinBuilderFlags("--reduced_classpath_mode");
            public static final /* enum */ KotlinBuilderFlags INSTRUMENT_COVERAGE = new KotlinBuilderFlags("--instrument_coverage");
            public static final /* enum */ KotlinBuilderFlags KSP_GENERATED_JAVA_SRCJAR = new KotlinBuilderFlags("--ksp_generated_java_srcjar");
            private static final /* synthetic */ KotlinBuilderFlags[] $VALUES;

            private KotlinBuilderFlags(String flag) {
                this.flag = flag;
            }

            @Override
            @NotNull
            public String getFlag() {
                return this.flag;
            }

            public static KotlinBuilderFlags[] values() {
                return (KotlinBuilderFlags[])$VALUES.clone();
            }

            public static KotlinBuilderFlags valueOf(String value) {
                return Enum.valueOf(KotlinBuilderFlags.class, value);
            }

            static {
                $VALUES = kotlinBuilderFlagsArray = new KotlinBuilderFlags[]{KotlinBuilderFlags.TARGET_LABEL, KotlinBuilderFlags.CLASSPATH, KotlinBuilderFlags.DIRECT_DEPENDENCIES, KotlinBuilderFlags.DEPS_ARTIFACTS, KotlinBuilderFlags.SOURCES, KotlinBuilderFlags.SOURCE_JARS, KotlinBuilderFlags.PROCESSOR_PATH, KotlinBuilderFlags.PROCESSORS, KotlinBuilderFlags.STUBS_PLUGIN_OPTIONS, KotlinBuilderFlags.STUBS_PLUGIN_CLASS_PATH, KotlinBuilderFlags.COMPILER_PLUGIN_OPTIONS, KotlinBuilderFlags.COMPILER_PLUGIN_CLASS_PATH, KotlinBuilderFlags.OUTPUT, KotlinBuilderFlags.RULE_KIND, KotlinBuilderFlags.MODULE_NAME, KotlinBuilderFlags.PASSTHROUGH_FLAGS, KotlinBuilderFlags.API_VERSION, KotlinBuilderFlags.LANGUAGE_VERSION, KotlinBuilderFlags.JVM_TARGET, KotlinBuilderFlags.OUTPUT_SRCJAR, KotlinBuilderFlags.GENERATED_CLASSDIR, KotlinBuilderFlags.FRIEND_PATHS, KotlinBuilderFlags.OUTPUT_JDEPS, KotlinBuilderFlags.OUTPUT_JS_JAR, KotlinBuilderFlags.JS_PASSTHROUGH_FLAGS, KotlinBuilderFlags.JS_LIBRARIES, KotlinBuilderFlags.DEBUG, KotlinBuilderFlags.TASK_ID, KotlinBuilderFlags.ABI_JAR, KotlinBuilderFlags.GENERATED_JAVA_SRC_JAR, KotlinBuilderFlags.GENERATED_JAVA_STUB_JAR, KotlinBuilderFlags.GENERATED_CLASS_JAR, KotlinBuilderFlags.BUILD_KOTLIN, KotlinBuilderFlags.STRICT_KOTLIN_DEPS, KotlinBuilderFlags.REDUCED_CLASSPATH_MODE, KotlinBuilderFlags.INSTRUMENT_COVERAGE, KotlinBuilderFlags.KSP_GENERATED_JAVA_SRCJAR};
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Platform.values().length];
            try {
                nArray[Platform.JVM.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Platform.JS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Platform.UNRECOGNIZED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

