/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.util;

import com.google.protobuf.Descriptors;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Message;
import com.google.protobuf.util.FieldMaskUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Logger;

final class FieldMaskTree {
    private static final Logger logger = Logger.getLogger(FieldMaskTree.class.getName());
    private static final String FIELD_PATH_SEPARATOR_REGEX = "\\.";
    private final Node root = new Node();

    FieldMaskTree() {
    }

    FieldMaskTree(FieldMask mask) {
        this.mergeFromFieldMask(mask);
    }

    public String toString() {
        return FieldMaskUtil.toString(this.toFieldMask());
    }

    FieldMaskTree addFieldPath(String path) {
        String[] parts = path.split(FIELD_PATH_SEPARATOR_REGEX);
        if (parts.length == 0) {
            return this;
        }
        Node node = this.root;
        boolean createNewBranch = false;
        for (String part : parts) {
            if (!createNewBranch && node != this.root && node.children.isEmpty()) {
                return this;
            }
            if (node.children.containsKey(part)) {
                node = (Node)node.children.get(part);
                continue;
            }
            createNewBranch = true;
            Node tmp = new Node();
            node.children.put(part, tmp);
            node = tmp;
        }
        node.children.clear();
        return this;
    }

    FieldMaskTree mergeFromFieldMask(FieldMask mask) {
        for (String path : mask.getPathsList()) {
            this.addFieldPath(path);
        }
        return this;
    }

    FieldMask toFieldMask() {
        if (this.root.children.isEmpty()) {
            return FieldMask.getDefaultInstance();
        }
        ArrayList<String> paths2 = new ArrayList<String>();
        this.getFieldPaths(this.root, "", paths2);
        return FieldMask.newBuilder().addAllPaths(paths2).build();
    }

    private void getFieldPaths(Node node, String path, List<String> paths2) {
        if (node.children.isEmpty()) {
            paths2.add(path);
            return;
        }
        for (Map.Entry<String, Node> entry2 : node.children.entrySet()) {
            String childPath = path.isEmpty() ? entry2.getKey() : path + "." + entry2.getKey();
            this.getFieldPaths(entry2.getValue(), childPath, paths2);
        }
    }

    void intersectFieldPath(String path, FieldMaskTree output) {
        if (this.root.children.isEmpty()) {
            return;
        }
        String[] parts = path.split(FIELD_PATH_SEPARATOR_REGEX);
        if (parts.length == 0) {
            return;
        }
        Node node = this.root;
        for (String part : parts) {
            if (node != this.root && node.children.isEmpty()) {
                output.addFieldPath(path);
                return;
            }
            if (!node.children.containsKey(part)) {
                return;
            }
            node = (Node)node.children.get(part);
        }
        ArrayList<String> paths2 = new ArrayList<String>();
        this.getFieldPaths(node, path, paths2);
        for (String value : paths2) {
            output.addFieldPath(value);
        }
    }

    void merge(Message source, Message.Builder destination, FieldMaskUtil.MergeOptions options) {
        if (source.getDescriptorForType() != destination.getDescriptorForType()) {
            throw new IllegalArgumentException("Cannot merge messages of different types.");
        }
        if (this.root.children.isEmpty()) {
            return;
        }
        this.merge(this.root, "", source, destination, options);
    }

    private void merge(Node node, String path, Message source, Message.Builder destination, FieldMaskUtil.MergeOptions options) {
        if (source.getDescriptorForType() != destination.getDescriptorForType()) {
            throw new IllegalArgumentException(String.format("source (%s) and destination (%s) descriptor must be equal", source.getDescriptorForType(), destination.getDescriptorForType()));
        }
        Descriptors.Descriptor descriptor = source.getDescriptorForType();
        for (Map.Entry<String, Node> entry2 : node.children.entrySet()) {
            Descriptors.FieldDescriptor field = descriptor.findFieldByName(entry2.getKey());
            if (field == null) {
                logger.warning("Cannot find field \"" + entry2.getKey() + "\" in message type " + descriptor.getFullName());
                continue;
            }
            if (!entry2.getValue().children.isEmpty()) {
                if (field.isRepeated() || field.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                    logger.warning("Field \"" + field.getFullName() + "\" is not a singluar message field and cannot have sub-fields.");
                    continue;
                }
                if (!source.hasField(field) && !destination.hasField(field)) continue;
                String childPath = path.isEmpty() ? entry2.getKey() : path + "." + entry2.getKey();
                this.merge(entry2.getValue(), childPath, (Message)source.getField(field), destination.getFieldBuilder(field), options);
                continue;
            }
            if (field.isRepeated()) {
                if (options.replaceRepeatedFields()) {
                    destination.setField(field, source.getField(field));
                    continue;
                }
                for (Object element : (List)source.getField(field)) {
                    destination.addRepeatedField(field, element);
                }
                continue;
            }
            if (field.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                if (options.replaceMessageFields()) {
                    if (!source.hasField(field)) {
                        destination.clearField(field);
                        continue;
                    }
                    destination.setField(field, source.getField(field));
                    continue;
                }
                if (!source.hasField(field)) continue;
                destination.getFieldBuilder(field).mergeFrom((Message)source.getField(field));
                continue;
            }
            if (source.hasField(field) || !options.replacePrimitiveFields()) {
                destination.setField(field, source.getField(field));
                continue;
            }
            destination.clearField(field);
        }
    }

    private static final class Node {
        final SortedMap<String, Node> children = new TreeMap<String, Node>();

        private Node() {
        }
    }
}

