/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.netty4;

import io.micrometer.common.docs.KeyName;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.docs.MeterDocumentation;

public enum NettyMeters implements MeterDocumentation
{
    ALLOCATOR_MEMORY_USED{

        @Override
        public String getName() {
            return "netty.allocator.memory.used";
        }

        @Override
        public Meter.Type getType() {
            return Meter.Type.GAUGE;
        }

        @Override
        public String getBaseUnit() {
            return "bytes";
        }

        @Override
        public KeyName[] getKeyNames() {
            return KeyName.merge(AllocatorKeyNames.values(), AllocatorMemoryKeyNames.values());
        }
    }
    ,
    ALLOCATOR_MEMORY_PINNED{

        @Override
        public String getName() {
            return "netty.allocator.memory.pinned";
        }

        @Override
        public Meter.Type getType() {
            return Meter.Type.GAUGE;
        }

        @Override
        public String getBaseUnit() {
            return "bytes";
        }

        @Override
        public KeyName[] getKeyNames() {
            return KeyName.merge(AllocatorKeyNames.values(), AllocatorMemoryKeyNames.values());
        }
    }
    ,
    ALLOCATOR_POOLED_ARENAS{

        @Override
        public String getName() {
            return "netty.allocator.pooled.arenas";
        }

        @Override
        public Meter.Type getType() {
            return Meter.Type.GAUGE;
        }

        @Override
        public KeyName[] getKeyNames() {
            return KeyName.merge(AllocatorKeyNames.values(), AllocatorMemoryKeyNames.values());
        }
    }
    ,
    ALLOCATOR_POOLED_CACHE_SIZE{

        @Override
        public String getName() {
            return "netty.allocator.pooled.cache.size";
        }

        @Override
        public Meter.Type getType() {
            return Meter.Type.GAUGE;
        }

        @Override
        public String getBaseUnit() {
            return "bytes";
        }

        @Override
        public KeyName[] getKeyNames() {
            return KeyName.merge(AllocatorKeyNames.values(), AllocatorPooledCacheKeyNames.values());
        }
    }
    ,
    ALLOCATOR_POOLED_THREADLOCAL_CACHES{

        @Override
        public String getName() {
            return "netty.allocator.pooled.threadlocal.caches";
        }

        @Override
        public Meter.Type getType() {
            return Meter.Type.GAUGE;
        }

        @Override
        public KeyName[] getKeyNames() {
            return AllocatorKeyNames.values();
        }
    }
    ,
    ALLOCATOR_POOLED_CHUNK_SIZE{

        @Override
        public String getName() {
            return "netty.allocator.pooled.chunk.size";
        }

        @Override
        public Meter.Type getType() {
            return Meter.Type.GAUGE;
        }

        @Override
        public String getBaseUnit() {
            return "bytes";
        }

        @Override
        public KeyName[] getKeyNames() {
            return AllocatorKeyNames.values();
        }
    }
    ,
    EVENT_EXECUTOR_TASKS_PENDING{

        @Override
        public String getName() {
            return "netty.eventexecutor.tasks.pending";
        }

        @Override
        public Meter.Type getType() {
            return Meter.Type.GAUGE;
        }

        @Override
        public KeyName[] getKeyNames() {
            return EventExecutorTasksPendingKeyNames.values();
        }
    }
    ,
    EVENT_EXECUTOR_WORKERS{

        @Override
        public String getName() {
            return "netty.eventexecutor.workers";
        }

        @Override
        public Meter.Type getType() {
            return Meter.Type.GAUGE;
        }

        @Override
        public KeyName[] getKeyNames() {
            return new KeyName[0];
        }
    };


    static enum EventExecutorTasksPendingKeyNames implements KeyName
    {
        NAME{

            @Override
            public String asString() {
                return "name";
            }
        };

    }

    static enum AllocatorPooledCacheKeyNames implements KeyName
    {
        CACHE_TYPE{

            @Override
            public String asString() {
                return "cache.type";
            }
        };

    }

    static enum AllocatorMemoryKeyNames implements KeyName
    {
        MEMORY_TYPE{

            @Override
            public String asString() {
                return "memory.type";
            }
        };

    }

    static enum AllocatorKeyNames implements KeyName
    {
        ID{

            @Override
            public String asString() {
                return "id";
            }
        }
        ,
        ALLOCATOR_TYPE{

            @Override
            public String asString() {
                return "allocator.type";
            }
        };

    }
}

