! RUN: %flang_fc1 -fopenmp -emit-llvm %s -o - | FileCheck %s

! Combinational testing of control flow graph and builder insertion points
! in mlir-to-llvm conversion:
!   - mixing multiple delayed privatizations and multiple reductions
!   - multiple blocks in the private alloc region
!   - private alloc region has to read from the mold variable
!   - firstprivate
!   - multiple blocks in the private copy region
!   - multiple blocks in the reduction init region
!   - reduction init region has to read from the mold variable
!   - re-used omp.private ops
!   - re-used omp.reduction.declare ops
!   - unstructured code inside of the parallel region
!   - needs private dealloc region, and this has multiple blocks
!   - needs reduction cleanup region, and this has multiple blocks

! This maybe belongs in the mlir tests, but what we are doing here is complex
! enough that I find the kind of minimised mlir code preferred by mlir reviewers
! hard to read without some fortran here for reference. Nothing like this would
! be generated by other upstream users of the MLIR OpenMP dialect.

subroutine worst_case(a, b, c, d)
  real, allocatable :: a(:), b(:), c(:), d(:)
  integer i

  !$omp parallel firstprivate(a,b) reduction(+:c,d)
  if (sum(a) == 1) stop 1
  !$omp end parallel
end subroutine

! CHECK-LABEL: define internal void @worst_case_..omp_par
! CHECK-NEXT:  omp.par.entry:
!                [reduction alloc regions inlined here]
! CHECK:         br label %omp.private.latealloc

! CHECK:       omp.private.latealloc:                            ; preds = %omp.par.entry
! CHECK-NEXT:  br label %omp.private.alloc5

! CHECK:       omp.private.alloc5:                               ; preds = %omp.private.latealloc
!                [begin private alloc for first var]
!                [read the length from the mold argument]
!                [if it is non-zero...]
! CHECK:         br i1 {{.*}}, label %omp.private.alloc6, label %omp.private.alloc7

! CHECK:       omp.private.alloc7:                               ; preds = %omp.private.alloc5
!                [finish private alloc for first var with zero extent]
! CHECK:         br label %omp.private.alloc8

! CHECK:       omp.private.alloc8:                               ; preds = %omp.private.alloc6, %omp.private.alloc7
! CHECK-NEXT:    br label %omp.region.cont4

! CHECK:       omp.region.cont4:                                 ; preds = %omp.private.alloc8
! CHECK-NEXT:    %{{.*}} = phi ptr
! CHECK-NEXT:    br label %omp.private.alloc

! CHECK:       omp.private.alloc:                                ; preds = %omp.region.cont4
!                [begin private alloc for first var]
!                [read the length from the mold argument]
!                [if it is non-zero...]
! CHECK:         br i1 %{{.*}}, label %omp.private.alloc1, label %omp.private.alloc2

! CHECK:       omp.private.alloc2:                               ; preds = %omp.private.alloc
!                [finish private alloc for second var with zero extent]
! CHECK:         br label %omp.private.alloc3

! CHECK:       omp.private.alloc3:                               ; preds = %omp.private.alloc1, %omp.private.alloc2
! CHECK-NEXT:    br label %omp.region.cont

! CHECK:       omp.region.cont:                                  ; preds = %omp.private.alloc3
! CHECK-NEXT:    %{{.*}} = phi ptr
! CHECK-NEXT:    br label %omp.private.copy

! CHECK:       omp.private.copy:                                 ; preds = %omp.region.cont
! CHECK-NEXT:    br label %omp.private.copy11

! CHECK:       omp.private.copy11:                               ; preds = %omp.private.copy
!                [begin firstprivate copy for first var]
!                [read the length, is it non-zero?]
! CHECK:         br i1 %{{.*}}, label %omp.private.copy12, label %omp.private.copy13

! CHECK:       omp.private.copy13:                               ; preds = %omp.private.copy12, %omp.private.copy11
! CHECK-NEXT:    br label %omp.region.cont10

! CHECK:       omp.region.cont10:                                 ; preds = %omp.private.copy13
! CHECK-NEXT:    %{{.*}} = phi ptr
! CHECK-NEXT:    br label %omp.private.copy15

! CHECK:       omp.private.copy15:                               ; preds = %omp.region.cont10
!                [begin firstprivate copy for second var]
!                [read the length, is it non-zero?]
! CHECK:         br i1 %{{.*}}, label %omp.private.copy16, label %omp.private.copy17

! CHECK:       omp.private.copy17:                               ; preds = %omp.private.copy16, %omp.private.copy15
! CHECK-NEXT:    br label %omp.region.cont14

! CHECK:       omp.region.cont14:                                ; preds = %omp.private.copy17
! CHECK-NEXT:    %{{.*}} = phi ptr
! CHECK-NEXT:    br label %omp.region.after_alloca

! CHECK:       omp.region.after_alloca:
! CHECK-NEXT:    br label %omp.par.region

! CHECK:       omp.par.region:                                   ; preds = %omp.region.after_alloca
! CHECK-NEXT:    br label %omp.reduction.init

! CHECK:       omp.reduction.init:                               ; preds = %omp.par.region
!                [deffered stores for results of reduction alloc regions]
! CHECK:         br label %[[VAL_96:.*]]

! CHECK:       omp.reduction.neutral:                            ; preds = %omp.reduction.init
!                [start of reduction initialization region]
!                [null check:]
! CHECK:         br i1 %{{.*}}, label %omp.reduction.neutral19, label %omp.reduction.neutral20

! CHECK:       omp.reduction.neutral20:                          ; preds = %omp.reduction.neutral
!                [malloc and assign the default value to the reduction variable]
! CHECK:         br label %omp.reduction.neutral21

! CHECK:       omp.reduction.neutral21:                          ; preds = %omp.reduction.neutral19, %omp.reduction.neutral20
! CHECK-NEXT:    br label %omp.region.cont18

! CHECK:       omp.region.cont18:                                ; preds = %omp.reduction.neutral21
! CHECK-NEXT:    %{{.*}} = phi ptr
! CHECK-NEXT:    br label %omp.reduction.neutral23

! CHECK:       omp.reduction.neutral23:                          ; preds = %omp.region.cont18
!                [start of reduction initialization region]
!                [null check:]
! CHECK:         br i1 %{{.*}}, label %omp.reduction.neutral24, label %omp.reduction.neutral25

! CHECK:       omp.reduction.neutral25:                          ; preds = %omp.reduction.neutral23
!                [malloc and assign the default value to the reduction variable]
! CHECK:         br label %omp.reduction.neutral26

! CHECK:       omp.reduction.neutral26:                          ; preds = %omp.reduction.neutral24, %omp.reduction.neutral25
! CHECK-NEXT:    br label %omp.region.cont22

! CHECK:       omp.region.cont22:                                ; preds = %omp.reduction.neutral26
! CHECK-NEXT:    %{{.*}} = phi ptr
! CHECK-NEXT:    br label %omp.par.region28

! CHECK:       omp.par.region28:                                 ; preds = %omp.region.cont22
!                [call SUM runtime function]
!                [if (sum(a) == 1)]
! CHECK:         br i1 %{{.*}}, label %omp.par.region29, label %omp.par.region30

! CHECK:       omp.par.region30:                                 ; preds = %omp.par.region28
! CHECK-NEXT:    br label %omp.region.cont27

! CHECK:       omp.region.cont27:                                ; preds = %omp.par.region29, %omp.par.region30
!                [omp parallel region done, call into the runtime to complete reduction]
! CHECK:         %[[VAL_233:.*]] = call i32 @__kmpc_reduce(
! CHECK:         switch i32 %[[VAL_233]], label %reduce.finalize [
! CHECK-NEXT:      i32 1, label %reduce.switch.nonatomic
! CHECK-NEXT:      i32 2, label %reduce.switch.atomic
! CHECK-NEXT:    ]

! CHECK:       reduce.switch.atomic:                             ; preds = %omp.region.cont27
! CHECK-NEXT:    unreachable

! CHECK:       reduce.switch.nonatomic:                          ; preds = %omp.region.cont27
! CHECK-NEXT:    %[[red_private_value_0:.*]] = load ptr, ptr %{{.*}}, align 8
! CHECK-NEXT:    br label %omp.reduction.nonatomic.body

!              [various blocks implementing the reduction]

! CHECK:       omp.region.cont36:                                ; preds =
! CHECK-NEXT:    %{{.*}} = phi ptr
! CHECK-NEXT:    call void @__kmpc_end_reduce(
! CHECK-NEXT:    br label %reduce.finalize

! CHECK:       reduce.finalize:                                  ; preds =
! CHECK-NEXT:    br label %omp.par.pre_finalize

! CHECK:       omp.par.pre_finalize:                             ; preds = %reduce.finalize
! CHECK-NEXT:    %{{.*}} = load ptr, ptr
! CHECK-NEXT:    br label %omp.reduction.cleanup

! CHECK:       omp.reduction.cleanup:                            ; preds = %omp.par.pre_finalize
!                [null check]
! CHECK:         br i1 %{{.*}}, label %omp.reduction.cleanup42, label %omp.reduction.cleanup43

! CHECK:       omp.reduction.cleanup43:                          ; preds = %omp.reduction.cleanup42, %omp.reduction.cleanup
! CHECK-NEXT:    br label %omp.region.cont41

! CHECK:       omp.region.cont41:                                ; preds = %omp.reduction.cleanup43
! CHECK-NEXT:    %{{.*}} = load ptr, ptr
! CHECK-NEXT:    br label %omp.reduction.cleanup45

! CHECK:       omp.reduction.cleanup45:                          ; preds = %omp.region.cont41
!                [null check]
! CHECK:         br i1 %{{.*}}, label %omp.reduction.cleanup46, label %omp.reduction.cleanup47

! CHECK:       omp.reduction.cleanup47:                          ; preds = %omp.reduction.cleanup46, %omp.reduction.cleanup45
! CHECK-NEXT:    br label %omp.region.cont44

! CHECK:       omp.region.cont44:                                ; preds = %omp.reduction.cleanup47
! CHECK-NEXT:    br label %omp.private.dealloc

! CHECK:       omp.private.dealloc:                              ; preds = %omp.region.cont44
!                [null check]
! CHECK:         br i1 %{{.*}}, label %omp.private.dealloc49, label %omp.private.dealloc50

! CHECK:       omp.private.dealloc50:                            ; preds = %omp.private.dealloc49, %omp.private.dealloc
! CHECK-NEXT:    br label %omp.region.cont48

! CHECK:       omp.region.cont48:                                ; preds = %omp.private.dealloc50
! CHECK-NEXT:    br label %omp.private.dealloc52

! CHECK:       omp.private.dealloc52:                            ; preds = %omp.region.cont48
!                [null check]
! CHECK:         br i1 %{{.*}}, label %omp.private.dealloc53, label %omp.private.dealloc54

! CHECK:       omp.private.dealloc54:                            ; preds = %omp.private.dealloc53, %omp.private.dealloc52
! CHECK-NEXT:    br label %omp.region.cont51

! CHECK:       omp.region.cont51:                                ; preds = %omp.private.dealloc54
! CHECK-NEXT:    br label %omp.par.outlined.exit.exitStub

! CHECK:       omp.private.dealloc53:                            ; preds = %omp.private.dealloc52
!                [dealloc memory]
! CHECK:         br label %omp.private.dealloc54

! CHECK:       omp.private.dealloc49:                            ; preds = %omp.private.dealloc
!                [dealloc memory]
! CHECK:         br label %omp.private.dealloc50

! CHECK:       omp.reduction.cleanup46:                          ; preds = %omp.reduction.cleanup45
! CHECK-NEXT:    call void @free(
! CHECK-NEXT:    br label %omp.reduction.cleanup47

! CHECK:       omp.reduction.cleanup42:                          ; preds = %omp.reduction.cleanup
! CHECK-NEXT:    call void @free(
! CHECK-NEXT:    br label %omp.reduction.cleanup43

! CHECK:       omp.par.region29:                                 ; preds = %omp.par.region28
! CHECK-NEXT:    call void @_FortranAStopStatement

! CHECK:       omp.reduction.neutral24:                          ; preds = %omp.reduction.neutral23
!                [source length was zero: finish initializing array]
! CHECK:         br label %omp.reduction.neutral26

! CHECK:       omp.reduction.neutral19:                          ; preds = %omp.reduction.neutral
!                [source length was zero: finish initializing array]
! CHECK:         br label %omp.reduction.neutral21

! CHECK:       omp.private.copy16:                               ; preds = %omp.private.copy15
!                [source length was non-zero: call assign runtime]
! CHECK:         br label %omp.private.copy17

! CHECK:       omp.private.copy12:                               ; preds = %omp.private.copy11
!                [source length was non-zero: call assign runtime]
! CHECK:         br label %omp.private.copy13

! CHECK:       omp.private.alloc1:                               ; preds = %omp.private.alloc
!                [var extent was non-zero: malloc a private array]
! CHECK:         br label %omp.private.alloc3

! CHECK:       omp.private.alloc6:                               ; preds = %omp.private.alloc5
!                [var extent was non-zero: malloc a private array]
! CHECK:         br label %omp.private.alloc8

! CHECK:       omp.par.outlined.exit.exitStub:                   ; preds = %omp.region.cont51
! CHECK-NEXT:    ret void
