/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreObject;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilegeGrant;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilegeOwner;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilegeType;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRoleReference;
import org.jkiss.dbeaver.model.access.DBAPrivilege;
import org.jkiss.dbeaver.model.access.DBAPrivilegeGrant;
import org.jkiss.dbeaver.model.access.DBARole;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public abstract class PostgrePrivilege
implements DBAPrivilege,
Comparable<PostgrePrivilege> {
    public static final short NONE = 0;
    public static final short GRANTED = 1;
    public static final short WITH_GRANT_OPTION = 2;
    public static final short WITH_HIERARCHY = 4;
    protected final PostgrePrivilegeOwner owner;
    private ObjectPermission[] permissions;

    public PostgrePrivilege(PostgrePrivilegeOwner owner, List<PostgrePrivilegeGrant> grants) {
        this.owner = owner;
        this.permissions = new ObjectPermission[grants.size()];
        for (int i = 0; i < grants.size(); ++i) {
            PostgrePrivilegeGrant privilege = grants.get(i);
            short permission = 1;
            if (privilege.isGrantable()) {
                permission = (short)(permission | 2);
            }
            if (privilege.isWithHierarchy()) {
                permission = (short)(permission | 4);
            }
            this.permissions[i] = new ObjectPermission(privilege.getPrivilegeType(), privilege.getGrantor(), permission);
        }
    }

    public DBAPrivilegeGrant[] getGrants() {
        return this.permissions;
    }

    public boolean isPersisted() {
        return true;
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    @Nullable
    public PostgrePrivilegeOwner getParentObject() {
        return this.owner;
    }

    @NotNull
    public PostgreDataSource getDataSource() {
        return this.owner.getDataSource();
    }

    public PostgrePrivilegeOwner getOwner() {
        return this.owner;
    }

    public abstract PostgreObject getTargetObject(DBRProgressMonitor var1) throws DBException;

    public ObjectPermission[] getPermissions() {
        return this.permissions;
    }

    public PostgrePrivilegeType[] getPrivileges() {
        PostgrePrivilegeType[] ppt = new PostgrePrivilegeType[this.permissions.length];
        for (int i = 0; i < this.permissions.length; ++i) {
            ppt[i] = this.permissions[i].getPrivilegeType();
        }
        return ppt;
    }

    public short getPermission(PostgrePrivilegeType privilegeType) {
        for (ObjectPermission permission : this.permissions) {
            if (permission.privilegeType != privilegeType && permission.privilegeType != PostgrePrivilegeType.ALL) continue;
            return permission.permissions;
        }
        return 0;
    }

    public boolean hasPermission(@NotNull PostgrePrivilegeType privilegeType) {
        return this.getPermission(privilegeType) != 0;
    }

    public void addPermission(@NotNull PostgrePrivilegeGrant privilege) {
        ObjectPermission[] newPermissions = new ObjectPermission[this.permissions.length + 1];
        System.arraycopy(this.permissions, 0, newPermissions, 0, this.permissions.length);
        short permission = 1;
        if (privilege.isGrantable()) {
            permission = (short)(permission | 2);
        }
        if (privilege.isWithHierarchy()) {
            permission = (short)(permission | 4);
        }
        newPermissions[this.permissions.length] = new ObjectPermission(privilege.getPrivilegeType(), privilege.getGrantor(), permission);
        this.permissions = newPermissions;
    }

    public void removePermission(@NotNull PostgrePrivilegeType privilegeType) {
        for (int i = 0; i < this.permissions.length; ++i) {
            if (this.permissions[i].privilegeType != privilegeType) continue;
            ObjectPermission[] newPermissions = new ObjectPermission[this.permissions.length - 1];
            System.arraycopy(this.permissions, 0, newPermissions, 0, i);
            System.arraycopy(this.permissions, i + 1, newPermissions, i, this.permissions.length - i - 1);
            this.permissions = newPermissions;
            break;
        }
    }

    public boolean hasAllPrivileges(Object object) {
        for (PostgrePrivilegeType pt : this.getDataSource().getSupportedPrivilegeTypes()) {
            if (!pt.isValid() || !pt.supportsType(object.getClass()) || this.getPermission(pt) != 0) continue;
            return false;
        }
        return true;
    }

    public class ObjectPermission
    implements DBAPrivilegeGrant {
        @NotNull
        private final PostgrePrivilegeType privilegeType;
        @NotNull
        private final PostgreRoleReference grantor;
        private short permissions;

        public ObjectPermission(@NotNull PostgrePrivilegeType privilegeType, PostgreRoleReference grantor, short permissions) {
            this.privilegeType = privilegeType;
            this.grantor = grantor;
            this.permissions = permissions;
        }

        public DBARole getSubject(@NotNull DBRProgressMonitor monitor) throws DBException {
            return PostgrePrivilege.this.owner instanceof DBARole ? (DBARole)PostgrePrivilege.this.owner : (DBARole)PostgrePrivilege.this.getTargetObject(monitor);
        }

        public DBSObject getObject(@NotNull DBRProgressMonitor monitor) throws DBException {
            return PostgrePrivilege.this.owner instanceof DBARole ? PostgrePrivilege.this.getTargetObject(monitor) : PostgrePrivilege.this.owner;
        }

        public DBAPrivilege[] getPrivileges() {
            return new DBAPrivilege[]{PostgrePrivilege.this};
        }

        @NotNull
        public PostgrePrivilegeType getPrivilegeType() {
            return this.privilegeType;
        }

        public boolean isGranted() {
            return (this.permissions & 1) == 1;
        }

        @NotNull
        public PostgreRoleReference getGrantor() {
            return this.grantor;
        }

        public short getPermissions() {
            return this.permissions;
        }

        public String toString() {
            return this.privilegeType.toString();
        }
    }
}

