/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.spreadsheet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeConstraint;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.lightgrid.GridCell;
import org.jkiss.dbeaver.ui.controls.lightgrid.GridColumn;
import org.jkiss.dbeaver.ui.controls.lightgrid.GridPos;
import org.jkiss.dbeaver.ui.controls.lightgrid.IGridColumn;
import org.jkiss.dbeaver.ui.controls.lightgrid.IGridItem;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetModel;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.controls.resultset.handler.ResultSetHandlerMain;
import org.jkiss.dbeaver.ui.controls.resultset.internal.ResultSetMessages;
import org.jkiss.dbeaver.ui.controls.resultset.spreadsheet.Spreadsheet;
import org.jkiss.dbeaver.ui.controls.resultset.spreadsheet.SpreadsheetPresentation;

public class SpreadsheetCommandHandler
extends AbstractHandler {
    public static final String CMD_COLUMNS_FIT_VALUE = "org.jkiss.dbeaver.core.resultset.grid.columnsFitValue";
    public static final String CMD_COLUMNS_FIT_SCREEN = "org.jkiss.dbeaver.core.resultset.grid.columnsFitScreen";
    public static final String CMD_COLUMNS_HIDE_EMPTY = "org.jkiss.dbeaver.core.resultset.grid.columnsHideEmpty";
    public static final String CMD_SELECT_COLUMNS = "org.jkiss.dbeaver.core.resultset.grid.selectColumn";
    public static final String CMD_SELECT_ROWS = "org.jkiss.dbeaver.core.resultset.grid.selectRow";
    public static final String CMD_MOVE_COLUMNS_RIGHT = "org.jkiss.dbeaver.core.resultset.grid.moveColumnRight";
    public static final String CMD_MOVE_COLUMNS_LEFT = "org.jkiss.dbeaver.core.resultset.grid.moveColumnLeft";
    public static final String CMD_HIDE_COLUMNS = "org.jkiss.dbeaver.core.resultset.grid.hideColumns";
    public static final String CMD_SHOW_COLUMNS = "org.jkiss.dbeaver.core.resultset.grid.showColumns";
    public static final String CMD_SHOW_COLUMN_CONTEXT_MENU = "org.jkiss.dbeaver.core.resultset.grid.showColumnContextMenu";

    public static SpreadsheetPresentation getActiveSpreadsheet(ExecutionEvent event) {
        IResultSetPresentation presentation;
        IResultSetController resultSet = ResultSetHandlerMain.getActiveResultSet(HandlerUtil.getActivePart((ExecutionEvent)event));
        if (resultSet != null && (presentation = resultSet.getActivePresentation()) instanceof SpreadsheetPresentation) {
            return (SpreadsheetPresentation)presentation;
        }
        return null;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String actionId;
        SpreadsheetPresentation spreadsheet = SpreadsheetCommandHandler.getActiveSpreadsheet(event);
        if (spreadsheet == null) {
            return null;
        }
        switch (actionId = event.getCommand().getId()) {
            case "org.jkiss.dbeaver.core.resultset.grid.columnsFitValue": {
                spreadsheet.getSpreadsheet().packColumns(true);
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.grid.columnsFitScreen": {
                spreadsheet.getSpreadsheet().packColumns(false);
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.grid.columnsHideEmpty": {
                ResultSetModel model = spreadsheet.getController().getModel();
                HashSet<DBDAttributeBinding> attributes = new HashSet<DBDAttributeBinding>(model.getVisibleAttributes());
                for (ResultSetRow row : model.getAllRows()) {
                    attributes.removeIf(attribute -> !DBUtils.isNullValue((Object)model.getCellValue((DBDAttributeBinding)attribute, row)));
                }
                if (attributes.isEmpty()) break;
                for (DBDAttributeBinding attribute2 : attributes) {
                    model.setAttributeVisibility(attribute2, false);
                }
                spreadsheet.refreshData(true, false, true);
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.grid.selectColumn": {
                Spreadsheet s = spreadsheet.getSpreadsheet();
                GridPos focusPos = s.getFocusPos();
                int rowsCount = s.getItemCount();
                List<IGridColumn> columnsSelection = s.getColumnSelection();
                Collection cellsToSelect = columnsSelection.stream().flatMap(c -> IntStream.range(0, rowsCount).mapToObj(r -> new GridPos(c.getIndex(), r))).collect(Collectors.toList());
                s.selectCells(cellsToSelect);
                s.resetFocus();
                s.setFocusColumn(focusPos.col);
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.grid.selectRow": {
                Spreadsheet s = spreadsheet.getSpreadsheet();
                GridPos focusPos = s.getFocusPos();
                int columnsCount = s.getColumnCount();
                Collection<Integer> rowsSelection = s.getRowSelection();
                Collection cellsToSelect = rowsSelection.stream().flatMap(r -> IntStream.range(0, columnsCount).mapToObj(c -> new GridPos(c, (int)r))).collect(Collectors.toList());
                s.selectCells(cellsToSelect);
                s.resetFocus();
                s.setFocusItem(focusPos.row);
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.grid.moveColumnRight": {
                Spreadsheet s = spreadsheet.getSpreadsheet();
                List<GridCell> selectedCells = s.getCellSelection();
                List<IGridColumn> selectedColumns = s.getColumnSelection();
                GridPos focusPos = s.getFocusPos();
                Object focusColumnElement = s.getFocusColumnElement();
                int rightmostColumnIndex = selectedColumns.stream().mapToInt(IGridColumn::getIndex).max().getAsInt();
                if (rightmostColumnIndex >= s.getColumnCount() - 1) break;
                List<Object> columnsToMove = selectedColumns.stream().map(IGridItem::getElement).collect(Collectors.toList());
                List<GridPos> cellsToSelect = selectedCells.stream().map(s::cellToPos).map(p -> new GridPos(p.col + 1, p.row)).collect(Collectors.toList());
                if (!spreadsheet.shiftColumns(columnsToMove, 1)) break;
                s.deselectAll();
                s.selectCells(cellsToSelect);
                s.resetFocus();
                s.setFocusColumn(s.getColumnByElement(focusColumnElement).getIndex());
                s.setFocusItem(focusPos.row);
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.grid.moveColumnLeft": {
                Spreadsheet s = spreadsheet.getSpreadsheet();
                List<GridCell> selectedCells = s.getCellSelection();
                List<IGridColumn> selectedColumns = s.getColumnSelection();
                GridPos focusPos = s.getFocusPos();
                Object focusColumnElement = s.getFocusColumnElement();
                int leftmostColumnIndex = selectedColumns.stream().mapToInt(IGridColumn::getIndex).min().getAsInt();
                if (leftmostColumnIndex <= 0) break;
                List<Object> columnsToMove = selectedColumns.stream().map(IGridItem::getElement).collect(Collectors.toList());
                List<GridPos> cellsToSelect = selectedCells.stream().map(s::cellToPos).map(p -> new GridPos(p.col - 1, p.row)).collect(Collectors.toList());
                if (!spreadsheet.shiftColumns(columnsToMove, -1)) break;
                s.deselectAll();
                s.selectCells(cellsToSelect);
                s.resetFocus();
                s.setFocusColumn(s.getColumnByElement(focusColumnElement).getIndex());
                s.setFocusItem(focusPos.row);
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.grid.hideColumns": {
                ResultSetModel model = spreadsheet.getController().getModel();
                List<Object> selectedColumns = spreadsheet.getSpreadsheet().getColumnSelection();
                GridPos focusPos = spreadsheet.getSpreadsheet().getFocusPos();
                if (selectedColumns.size() == 1 && focusPos.col >= 0) {
                    GridColumn column = spreadsheet.getSpreadsheet().getColumn(focusPos.col);
                    selectedColumns = Collections.singletonList(column);
                }
                if (selectedColumns.size() >= model.getVisibleAttributeCount()) {
                    UIUtils.showMessageBox((Shell)spreadsheet.getControl().getShell(), (String)ResultSetMessages.controls_resultset_viewer_hide_columns_error_title, (String)ResultSetMessages.controls_resultset_viewer_hide_columnss_error_text, (int)1);
                    break;
                }
                for (IGridColumn selectedColumn : selectedColumns) {
                    model.setAttributeVisibility((DBDAttributeBinding)selectedColumn.getElement(), false);
                }
                spreadsheet.refreshData(true, false, true);
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.grid.showColumns": {
                ResultSetModel model = spreadsheet.getController().getModel();
                ArrayList<DBDAttributeBinding> hiddenAttributes = new ArrayList<DBDAttributeBinding>();
                List constraints = model.getDataFilter().getConstraints();
                for (DBDAttributeConstraint ac : constraints) {
                    DBSAttributeBase attribute3 = ac.getAttribute();
                    if (ac.isVisible() || !(attribute3 instanceof DBDAttributeBinding) || !DBDAttributeConstraint.isVisibleByDefault((DBDAttributeBinding)((DBDAttributeBinding)attribute3))) continue;
                    hiddenAttributes.add((DBDAttributeBinding)attribute3);
                }
                for (DBDAttributeBinding attr : hiddenAttributes) {
                    model.setAttributeVisibility(attr, true);
                }
                spreadsheet.refreshData(true, false, true);
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.grid.showColumnContextMenu": {
                Spreadsheet s = spreadsheet.getSpreadsheet();
                GridCell focusCell = s.getFocusCell();
                Object focusColumnElement = s.getFocusColumnElement();
                if (focusCell != null) {
                    GridPos focusPos = s.cellToPos(focusCell);
                    Rectangle r2 = s.getCellBounds(focusPos.col, focusPos.row);
                    s.getMenu().setLocation(s.toDisplay(new Point(r2.x + r2.width, r2.y)));
                } else if (focusColumnElement != null) {
                    IGridColumn focusColumn = s.getColumnByElement(focusColumnElement);
                    Rectangle r3 = s.getColumnBounds(focusColumn.getIndex());
                    s.getMenu().setLocation(s.toDisplay(new Point(r3.x + r3.width, r3.y)));
                }
                s.setColumnContextMenuShouldBeShown(true);
                s.getMenu().setVisible(true);
                break;
            }
        }
        return null;
    }
}

