/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StringUtilsStartsEndsWithTest
extends AbstractLangTest {
    private static final String foo = "foo";
    private static final String bar = "bar";
    private static final String foobar = "foobar";
    private static final String FOO = "FOO";
    private static final String BAR = "BAR";
    private static final String FOOBAR = "FOOBAR";

    @Test
    public void testEndsWith() {
        Assertions.assertTrue((boolean)StringUtils.endsWith(null, null), (String)"endsWith(null, null)");
        Assertions.assertFalse((boolean)StringUtils.endsWith((CharSequence)FOOBAR, null), (String)"endsWith(FOOBAR, null)");
        Assertions.assertFalse((boolean)StringUtils.endsWith(null, (CharSequence)FOO), (String)"endsWith(null, FOO)");
        Assertions.assertTrue((boolean)StringUtils.endsWith((CharSequence)FOOBAR, (CharSequence)""), (String)"endsWith(FOOBAR, \"\")");
        Assertions.assertFalse((boolean)StringUtils.endsWith((CharSequence)foobar, (CharSequence)foo), (String)"endsWith(foobar, foo)");
        Assertions.assertFalse((boolean)StringUtils.endsWith((CharSequence)FOOBAR, (CharSequence)FOO), (String)"endsWith(FOOBAR, FOO)");
        Assertions.assertFalse((boolean)StringUtils.endsWith((CharSequence)foobar, (CharSequence)FOO), (String)"endsWith(foobar, FOO)");
        Assertions.assertFalse((boolean)StringUtils.endsWith((CharSequence)FOOBAR, (CharSequence)foo), (String)"endsWith(FOOBAR, foo)");
        Assertions.assertFalse((boolean)StringUtils.endsWith((CharSequence)foo, (CharSequence)foobar), (String)"endsWith(foo, foobar)");
        Assertions.assertFalse((boolean)StringUtils.endsWith((CharSequence)bar, (CharSequence)foobar), (String)"endsWith(foo, foobar)");
        Assertions.assertTrue((boolean)StringUtils.endsWith((CharSequence)foobar, (CharSequence)bar), (String)"endsWith(foobar, bar)");
        Assertions.assertTrue((boolean)StringUtils.endsWith((CharSequence)FOOBAR, (CharSequence)BAR), (String)"endsWith(FOOBAR, BAR)");
        Assertions.assertFalse((boolean)StringUtils.endsWith((CharSequence)foobar, (CharSequence)BAR), (String)"endsWith(foobar, BAR)");
        Assertions.assertFalse((boolean)StringUtils.endsWith((CharSequence)FOOBAR, (CharSequence)bar), (String)"endsWith(FOOBAR, bar)");
        Assertions.assertTrue((boolean)StringUtils.endsWith((CharSequence)"\u03b1\u03b2\u03b3\u03b4", (CharSequence)"\u03b4"), (String)"endsWith(\u03b1\u03b2\u03b3\u03b4, \u03b4)");
        Assertions.assertFalse((boolean)StringUtils.endsWith((CharSequence)"\u03b1\u03b2\u03b3\u03b4", (CharSequence)"\u03b3\u0394"), (String)"endsWith(\u03b1\u03b2\u03b3\u03b4, \u03b3\u0394)");
    }

    @Test
    public void testEndsWithAny() {
        Assertions.assertFalse((boolean)StringUtils.endsWithAny(null, (CharSequence[])new CharSequence[]{null}), (String)"StringUtils.endsWithAny(null, null)");
        Assertions.assertFalse((boolean)StringUtils.endsWithAny(null, (CharSequence[])new CharSequence[]{"abc"}), (String)"StringUtils.endsWithAny(null, new String[] {abc})");
        Assertions.assertFalse((boolean)StringUtils.endsWithAny((CharSequence)"abcxyz", (CharSequence[])new CharSequence[]{null}), (String)"StringUtils.endsWithAny(abcxyz, null)");
        Assertions.assertTrue((boolean)StringUtils.endsWithAny((CharSequence)"abcxyz", (CharSequence[])new CharSequence[]{""}), (String)"StringUtils.endsWithAny(abcxyz, new String[] {\"\"})");
        Assertions.assertTrue((boolean)StringUtils.endsWithAny((CharSequence)"abcxyz", (CharSequence[])new CharSequence[]{"xyz"}), (String)"StringUtils.endsWithAny(abcxyz, new String[] {xyz})");
        Assertions.assertTrue((boolean)StringUtils.endsWithAny((CharSequence)"abcxyz", (CharSequence[])new CharSequence[]{null, "xyz", "abc"}), (String)"StringUtils.endsWithAny(abcxyz, new String[] {null, xyz, abc})");
        Assertions.assertFalse((boolean)StringUtils.endsWithAny((CharSequence)"defg", (CharSequence[])new CharSequence[]{null, "xyz", "abc"}), (String)"StringUtils.endsWithAny(defg, new String[] {null, xyz, abc})");
        Assertions.assertTrue((boolean)StringUtils.endsWithAny((CharSequence)"abcXYZ", (CharSequence[])new CharSequence[]{"def", "XYZ"}));
        Assertions.assertFalse((boolean)StringUtils.endsWithAny((CharSequence)"abcXYZ", (CharSequence[])new CharSequence[]{"def", "xyz"}));
        Assertions.assertTrue((boolean)StringUtils.endsWithAny((CharSequence)"abcXYZ", (CharSequence[])new CharSequence[]{"def", "YZ"}));
        Assertions.assertFalse((boolean)StringUtils.endsWithAny((CharSequence)"abcXYZ", (CharSequence[])new CharSequence[]{null}));
        Assertions.assertFalse((boolean)StringUtils.endsWithAny((CharSequence)"abcXYZ", (CharSequence[])null));
        Assertions.assertTrue((boolean)StringUtils.endsWithAny((CharSequence)"abcXYZ", (CharSequence[])new CharSequence[]{""}));
        Assertions.assertTrue((boolean)StringUtils.endsWithAny((CharSequence)"abcxyz", (CharSequence[])new CharSequence[]{new StringBuilder("abc"), new StringBuffer("xyz")}), (String)"StringUtils.endsWithAny(abcxyz, StringBuilder(abc), StringBuffer(xyz))");
        Assertions.assertTrue((boolean)StringUtils.endsWithAny((CharSequence)new StringBuffer("abcxyz"), (CharSequence[])new CharSequence[]{new StringBuilder("abc"), new StringBuffer("xyz")}), (String)"StringUtils.endsWithAny(StringBuffer(abcxyz), StringBuilder(abc), StringBuffer(xyz))");
    }

    @Test
    public void testEndsWithIgnoreCase() {
        Assertions.assertTrue((boolean)StringUtils.endsWithIgnoreCase(null, null), (String)"endsWithIgnoreCase(null, null)");
        Assertions.assertFalse((boolean)StringUtils.endsWithIgnoreCase((CharSequence)FOOBAR, null), (String)"endsWithIgnoreCase(FOOBAR, null)");
        Assertions.assertFalse((boolean)StringUtils.endsWithIgnoreCase(null, (CharSequence)FOO), (String)"endsWithIgnoreCase(null, FOO)");
        Assertions.assertTrue((boolean)StringUtils.endsWithIgnoreCase((CharSequence)FOOBAR, (CharSequence)""), (String)"endsWithIgnoreCase(FOOBAR, \"\")");
        Assertions.assertFalse((boolean)StringUtils.endsWithIgnoreCase((CharSequence)foobar, (CharSequence)foo), (String)"endsWithIgnoreCase(foobar, foo)");
        Assertions.assertFalse((boolean)StringUtils.endsWithIgnoreCase((CharSequence)FOOBAR, (CharSequence)FOO), (String)"endsWithIgnoreCase(FOOBAR, FOO)");
        Assertions.assertFalse((boolean)StringUtils.endsWithIgnoreCase((CharSequence)foobar, (CharSequence)FOO), (String)"endsWithIgnoreCase(foobar, FOO)");
        Assertions.assertFalse((boolean)StringUtils.endsWithIgnoreCase((CharSequence)FOOBAR, (CharSequence)foo), (String)"endsWithIgnoreCase(FOOBAR, foo)");
        Assertions.assertFalse((boolean)StringUtils.endsWithIgnoreCase((CharSequence)foo, (CharSequence)foobar), (String)"endsWithIgnoreCase(foo, foobar)");
        Assertions.assertFalse((boolean)StringUtils.endsWithIgnoreCase((CharSequence)bar, (CharSequence)foobar), (String)"endsWithIgnoreCase(foo, foobar)");
        Assertions.assertTrue((boolean)StringUtils.endsWithIgnoreCase((CharSequence)foobar, (CharSequence)bar), (String)"endsWithIgnoreCase(foobar, bar)");
        Assertions.assertTrue((boolean)StringUtils.endsWithIgnoreCase((CharSequence)FOOBAR, (CharSequence)BAR), (String)"endsWithIgnoreCase(FOOBAR, BAR)");
        Assertions.assertTrue((boolean)StringUtils.endsWithIgnoreCase((CharSequence)foobar, (CharSequence)BAR), (String)"endsWithIgnoreCase(foobar, BAR)");
        Assertions.assertTrue((boolean)StringUtils.endsWithIgnoreCase((CharSequence)FOOBAR, (CharSequence)bar), (String)"endsWithIgnoreCase(FOOBAR, bar)");
        Assertions.assertTrue((boolean)StringUtils.endsWithIgnoreCase((CharSequence)"abcdef", (CharSequence)"def"));
        Assertions.assertTrue((boolean)StringUtils.endsWithIgnoreCase((CharSequence)"ABCDEF", (CharSequence)"def"));
        Assertions.assertFalse((boolean)StringUtils.endsWithIgnoreCase((CharSequence)"ABCDEF", (CharSequence)"cde"));
        Assertions.assertTrue((boolean)StringUtils.endsWithIgnoreCase((CharSequence)"\u03b1\u03b2\u03b3\u03b4", (CharSequence)"\u0394"), (String)"endsWith(\u03b1\u03b2\u03b3\u03b4, \u0394)");
        Assertions.assertFalse((boolean)StringUtils.endsWithIgnoreCase((CharSequence)"\u03b1\u03b2\u03b3\u03b4", (CharSequence)"\u0393"), (String)"endsWith(\u03b1\u03b2\u03b3\u03b4, \u0393)");
    }

    @Test
    public void testStartsWith() {
        Assertions.assertTrue((boolean)StringUtils.startsWith(null, null), (String)"startsWith(null, null)");
        Assertions.assertFalse((boolean)StringUtils.startsWith((CharSequence)FOOBAR, null), (String)"startsWith(FOOBAR, null)");
        Assertions.assertFalse((boolean)StringUtils.startsWith(null, (CharSequence)FOO), (String)"startsWith(null, FOO)");
        Assertions.assertTrue((boolean)StringUtils.startsWith((CharSequence)FOOBAR, (CharSequence)""), (String)"startsWith(FOOBAR, \"\")");
        Assertions.assertTrue((boolean)StringUtils.startsWith((CharSequence)foobar, (CharSequence)foo), (String)"startsWith(foobar, foo)");
        Assertions.assertTrue((boolean)StringUtils.startsWith((CharSequence)FOOBAR, (CharSequence)FOO), (String)"startsWith(FOOBAR, FOO)");
        Assertions.assertFalse((boolean)StringUtils.startsWith((CharSequence)foobar, (CharSequence)FOO), (String)"startsWith(foobar, FOO)");
        Assertions.assertFalse((boolean)StringUtils.startsWith((CharSequence)FOOBAR, (CharSequence)foo), (String)"startsWith(FOOBAR, foo)");
        Assertions.assertFalse((boolean)StringUtils.startsWith((CharSequence)foo, (CharSequence)foobar), (String)"startsWith(foo, foobar)");
        Assertions.assertFalse((boolean)StringUtils.startsWith((CharSequence)bar, (CharSequence)foobar), (String)"startsWith(foo, foobar)");
        Assertions.assertFalse((boolean)StringUtils.startsWith((CharSequence)foobar, (CharSequence)bar), (String)"startsWith(foobar, bar)");
        Assertions.assertFalse((boolean)StringUtils.startsWith((CharSequence)FOOBAR, (CharSequence)BAR), (String)"startsWith(FOOBAR, BAR)");
        Assertions.assertFalse((boolean)StringUtils.startsWith((CharSequence)foobar, (CharSequence)BAR), (String)"startsWith(foobar, BAR)");
        Assertions.assertFalse((boolean)StringUtils.startsWith((CharSequence)FOOBAR, (CharSequence)bar), (String)"startsWith(FOOBAR, bar)");
    }

    @Test
    public void testStartsWithAny() {
        Assertions.assertFalse((boolean)StringUtils.startsWithAny(null, (CharSequence[])null));
        Assertions.assertFalse((boolean)StringUtils.startsWithAny(null, (CharSequence[])new CharSequence[]{"abc"}));
        Assertions.assertFalse((boolean)StringUtils.startsWithAny((CharSequence)"abcxyz", (CharSequence[])null));
        Assertions.assertFalse((boolean)StringUtils.startsWithAny((CharSequence)"abcxyz", (CharSequence[])new CharSequence[0]));
        Assertions.assertTrue((boolean)StringUtils.startsWithAny((CharSequence)"abcxyz", (CharSequence[])new CharSequence[]{"abc"}));
        Assertions.assertTrue((boolean)StringUtils.startsWithAny((CharSequence)"abcxyz", (CharSequence[])new CharSequence[]{null, "xyz", "abc"}));
        Assertions.assertFalse((boolean)StringUtils.startsWithAny((CharSequence)"abcxyz", (CharSequence[])new CharSequence[]{null, "xyz", "abcd"}));
        Assertions.assertTrue((boolean)StringUtils.startsWithAny((CharSequence)"abcxyz", (CharSequence[])new CharSequence[]{""}));
        Assertions.assertFalse((boolean)StringUtils.startsWithAny((CharSequence)"abcxyz", (CharSequence[])new CharSequence[]{null, "xyz", "ABCX"}));
        Assertions.assertFalse((boolean)StringUtils.startsWithAny((CharSequence)"ABCXYZ", (CharSequence[])new CharSequence[]{null, "xyz", "abc"}));
        Assertions.assertTrue((boolean)StringUtils.startsWithAny((CharSequence)"abcxyz", (CharSequence[])new CharSequence[]{new StringBuilder("xyz"), new StringBuffer("abc")}), (String)"StringUtils.startsWithAny(abcxyz, StringBuilder(xyz), StringBuffer(abc))");
        Assertions.assertTrue((boolean)StringUtils.startsWithAny((CharSequence)new StringBuffer("abcxyz"), (CharSequence[])new CharSequence[]{new StringBuilder("xyz"), new StringBuffer("abc")}), (String)"StringUtils.startsWithAny(StringBuffer(abcxyz), StringBuilder(xyz), StringBuffer(abc))");
    }

    @Test
    public void testStartsWithIgnoreCase() {
        Assertions.assertTrue((boolean)StringUtils.startsWithIgnoreCase(null, null), (String)"startsWithIgnoreCase(null, null)");
        Assertions.assertFalse((boolean)StringUtils.startsWithIgnoreCase((CharSequence)FOOBAR, null), (String)"startsWithIgnoreCase(FOOBAR, null)");
        Assertions.assertFalse((boolean)StringUtils.startsWithIgnoreCase(null, (CharSequence)FOO), (String)"startsWithIgnoreCase(null, FOO)");
        Assertions.assertTrue((boolean)StringUtils.startsWithIgnoreCase((CharSequence)FOOBAR, (CharSequence)""), (String)"startsWithIgnoreCase(FOOBAR, \"\")");
        Assertions.assertTrue((boolean)StringUtils.startsWithIgnoreCase((CharSequence)foobar, (CharSequence)foo), (String)"startsWithIgnoreCase(foobar, foo)");
        Assertions.assertTrue((boolean)StringUtils.startsWithIgnoreCase((CharSequence)FOOBAR, (CharSequence)FOO), (String)"startsWithIgnoreCase(FOOBAR, FOO)");
        Assertions.assertTrue((boolean)StringUtils.startsWithIgnoreCase((CharSequence)foobar, (CharSequence)FOO), (String)"startsWithIgnoreCase(foobar, FOO)");
        Assertions.assertTrue((boolean)StringUtils.startsWithIgnoreCase((CharSequence)FOOBAR, (CharSequence)foo), (String)"startsWithIgnoreCase(FOOBAR, foo)");
        Assertions.assertFalse((boolean)StringUtils.startsWithIgnoreCase((CharSequence)foo, (CharSequence)foobar), (String)"startsWithIgnoreCase(foo, foobar)");
        Assertions.assertFalse((boolean)StringUtils.startsWithIgnoreCase((CharSequence)bar, (CharSequence)foobar), (String)"startsWithIgnoreCase(foo, foobar)");
        Assertions.assertFalse((boolean)StringUtils.startsWithIgnoreCase((CharSequence)foobar, (CharSequence)bar), (String)"startsWithIgnoreCase(foobar, bar)");
        Assertions.assertFalse((boolean)StringUtils.startsWithIgnoreCase((CharSequence)FOOBAR, (CharSequence)BAR), (String)"startsWithIgnoreCase(FOOBAR, BAR)");
        Assertions.assertFalse((boolean)StringUtils.startsWithIgnoreCase((CharSequence)foobar, (CharSequence)BAR), (String)"startsWithIgnoreCase(foobar, BAR)");
        Assertions.assertFalse((boolean)StringUtils.startsWithIgnoreCase((CharSequence)FOOBAR, (CharSequence)bar), (String)"startsWithIgnoreCase(FOOBAR, bar)");
    }
}

