/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.yaml.internal.things;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.config.core.Configuration;
import org.openhab.core.model.yaml.internal.util.YamlElementUtils;
import org.openhab.core.thing.type.ChannelKind;
import org.openhab.core.thing.type.ChannelTypeUID;

public class YamlChannelDTO {
    public String type;
    public String kind;
    public String itemType;
    public String itemDimension;
    public String label;
    public String description;
    public Map<@NonNull String, @NonNull Object> config;

    public boolean isValid(@NonNull List<@NonNull String> errors, @NonNull List<@NonNull String> warnings) {
        boolean ok = true;
        if (this.config != null) {
            try {
                new Configuration(this.config);
            }
            catch (IllegalArgumentException e) {
                errors.add("invalid data in \"config\" field: %s".formatted(e.getMessage()));
                ok = false;
            }
        }
        if (this.type != null) {
            try {
                new ChannelTypeUID("dummy", this.type);
            }
            catch (IllegalArgumentException e) {
                errors.add("invalid value \"%s\" for \"type\" field: %s".formatted(this.type, e.getMessage()));
                ok = false;
            }
            if (this.kind != null) {
                warnings.add("\"kind\" field ignored; channel kind will be retrieved from the channel type");
            }
            if (this.itemType != null) {
                warnings.add("\"itemType\" field ignored; item type will be retrieved from the channel type");
            }
            if (this.itemDimension != null) {
                warnings.add("\"itemDimension\" field ignored; item type and dimension will be retrieved from the channel type");
            }
        } else if (this.itemType != null) {
            if (!YamlElementUtils.isValidItemType(this.itemType)) {
                errors.add("invalid value \"%s\" for \"itemType\" field".formatted(this.itemType));
                ok = false;
            } else if (YamlElementUtils.isNumberItemType(this.itemType)) {
                if (!YamlElementUtils.isValidItemDimension(this.itemDimension)) {
                    errors.add("invalid value \"%s\" for \"itemDimension\" field".formatted(this.itemDimension));
                    ok = false;
                }
            } else if (this.itemDimension != null) {
                warnings.add("\"itemDimension\" field ignored as item type is not Number");
            }
            try {
                ChannelKind.parse((String)this.kind);
            }
            catch (IllegalArgumentException e) {
                warnings.add("invalid value \"%s\" for \"kind\" field; only \"state\" and \"trigger\" whatever the case are valid; \"state\" will be considered".formatted(this.kind != null ? this.kind : "null"));
            }
        } else {
            errors.add("one of the \"type\" and \"itemType\" fields is mandatory");
            ok = false;
        }
        return ok;
    }

    public ChannelKind getKind() {
        try {
            return ChannelKind.parse((String)this.kind);
        }
        catch (IllegalArgumentException e) {
            return ChannelKind.STATE;
        }
    }

    public @Nullable String getItemType() {
        return YamlElementUtils.getItemTypeWithDimension(this.itemType, this.itemDimension);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.getKind(), this.getItemType(), this.label, this.description);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        YamlChannelDTO other = (YamlChannelDTO)obj;
        return Objects.equals(this.type, other.type) && this.getKind() == other.getKind() && Objects.equals(this.getItemType(), other.getItemType()) && Objects.equals(this.label, other.label) && Objects.equals(this.description, other.description) && YamlElementUtils.equalsConfig(this.config, other.config);
    }
}

